/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-09-06 04:17:08 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4950 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4837 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=189008 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=11681 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=380 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_activity_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sub_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `severity` int NOT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `progress` float NOT NULL DEFAULT '0',
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_duplicator_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `data` longtext NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`),
  KEY `value_2` (`value_2`),
  KEY `value_3` (`value_3`),
  KEY `value_4` (`value_4`),
  KEY `value_5` (`value_5`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_e_notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `route_post_id` bigint unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint unsigned DEFAULT NULL,
  `element_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `position` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `is_resolved` tinyint(1) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_notes_users_relations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `referer_title` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `element_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `form_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `log` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_em_bookings` (
  `booking_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint unsigned DEFAULT NULL,
  `person_id` bigint unsigned NOT NULL,
  `booking_spaces` int NOT NULL,
  `booking_comment` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `booking_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `booking_status` tinyint(1) NOT NULL DEFAULT '1',
  `booking_price` decimal(14,4) unsigned NOT NULL DEFAULT '0.0000',
  `booking_tax_rate` decimal(7,4) DEFAULT NULL,
  `booking_taxes` decimal(14,4) DEFAULT NULL,
  `booking_meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`booking_id`),
  KEY `event_id` (`event_id`),
  KEY `person_id` (`person_id`),
  KEY `booking_status` (`booking_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_em_events` (
  `event_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL,
  `event_slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_owner` bigint unsigned DEFAULT NULL,
  `event_status` int DEFAULT NULL,
  `event_name` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `event_start_date` date DEFAULT NULL,
  `event_end_date` date DEFAULT NULL,
  `event_start_time` time DEFAULT NULL,
  `event_end_time` time DEFAULT NULL,
  `event_all_day` int DEFAULT NULL,
  `event_start` datetime DEFAULT NULL,
  `event_end` datetime DEFAULT NULL,
  `event_timezone` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `event_rsvp` tinyint(1) NOT NULL DEFAULT '0',
  `event_rsvp_date` date DEFAULT NULL,
  `event_rsvp_time` time DEFAULT NULL,
  `event_rsvp_spaces` int DEFAULT NULL,
  `event_spaces` int DEFAULT '0',
  `event_private` tinyint(1) NOT NULL DEFAULT '0',
  `location_id` bigint unsigned DEFAULT NULL,
  `recurrence_id` bigint unsigned DEFAULT NULL,
  `event_date_created` datetime DEFAULT NULL,
  `event_date_modified` datetime DEFAULT NULL,
  `recurrence` tinyint(1) DEFAULT '0',
  `recurrence_interval` int DEFAULT NULL,
  `recurrence_freq` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `recurrence_byday` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `recurrence_byweekno` int DEFAULT NULL,
  `recurrence_days` int DEFAULT NULL,
  `recurrence_rsvp_days` int DEFAULT NULL,
  `blog_id` bigint unsigned DEFAULT NULL,
  `group_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `event_status` (`event_status`),
  KEY `post_id` (`post_id`),
  KEY `blog_id` (`blog_id`),
  KEY `group_id` (`group_id`),
  KEY `location_id` (`location_id`),
  KEY `event_start` (`event_start`),
  KEY `event_start_2` (`event_start`),
  KEY `event_end` (`event_end`),
  KEY `event_end_2` (`event_end`),
  KEY `event_start_date` (`event_start_date`),
  KEY `event_start_date_2` (`event_start_date`),
  KEY `event_end_date` (`event_end_date`),
  KEY `event_end_date_2` (`event_end_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_em_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL,
  `blog_id` bigint unsigned DEFAULT NULL,
  `location_slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_name` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `location_owner` bigint unsigned NOT NULL DEFAULT '0',
  `location_address` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_town` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_postcode` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_region` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_latitude` float(10,6) DEFAULT NULL,
  `location_longitude` float(10,6) DEFAULT NULL,
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `location_status` int DEFAULT NULL,
  `location_private` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`location_id`),
  KEY `location_country` (`location_country`),
  KEY `post_id` (`post_id`),
  KEY `blog_id` (`blog_id`),
  KEY `location_state` (`location_state`(191)),
  KEY `location_region` (`location_region`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_em_meta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `object_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `meta_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`meta_id`),
  KEY `object_id` (`object_id`),
  KEY `meta_key` (`meta_key`(250)),
  KEY `meta_key_2` (`meta_key`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_em_tickets` (
  `ticket_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint unsigned NOT NULL,
  `ticket_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ticket_description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ticket_price` decimal(14,4) DEFAULT NULL,
  `ticket_start` datetime DEFAULT NULL,
  `ticket_end` datetime DEFAULT NULL,
  `ticket_min` int DEFAULT NULL,
  `ticket_max` int DEFAULT NULL,
  `ticket_spaces` int DEFAULT NULL,
  `ticket_members` int DEFAULT NULL,
  `ticket_members_roles` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ticket_guests` int DEFAULT NULL,
  `ticket_required` int DEFAULT NULL,
  `ticket_meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ticket_id`),
  KEY `event_id` (`event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_em_tickets_bookings` (
  `ticket_booking_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint unsigned NOT NULL,
  `ticket_id` bigint unsigned NOT NULL,
  `ticket_booking_spaces` int NOT NULL,
  `ticket_booking_price` decimal(14,4) NOT NULL,
  PRIMARY KEY (`ticket_booking_id`),
  KEY `booking_id` (`booking_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=429977 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=95731 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=12169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_css` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_css_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_layer_animations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_layer_animations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_navigations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_navigations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_sliders7` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_sliders_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_slides7` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_static_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_static_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_rtl_rsm_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `section` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `result` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14083 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_sc_notifications_views` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `notif_id` int NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_studiare_quiz_attempts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `quiz_id` bigint unsigned NOT NULL,
  `start_time` datetime NOT NULL,
  `timer_seconds` int NOT NULL,
  `is_completed` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_user_quiz` (`user_id`,`quiz_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_studiare_quiz_results` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `quiz_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned DEFAULT NULL,
  `score` float NOT NULL,
  `timestamp` datetime NOT NULL,
  `details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `quiz_id` (`quiz_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=176 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4602 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `last_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `company` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `state` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `postcode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `country` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`),
  KEY `phone` (`phone`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`),
  KEY `billing_email` (`billing_email`),
  KEY `type_status` (`type`,`status`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`,`meta_value`(100)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`,`meta_value`(100))
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woo_wallet_transaction_meta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woo_wallet_transactions` (
  `transaction_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` bigint unsigned NOT NULL DEFAULT '1',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `amount` decimal(16,8) DEFAULT NULL,
  `balance` decimal(16,8) DEFAULT NULL,
  `currency` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_by` bigint unsigned NOT NULL DEFAULT '1',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`transaction_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=513 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_ir` (
  `id` int NOT NULL AUTO_INCREMENT,
  `text1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `text2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=1467 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=164 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=2644 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("1","studiare","$wp$2y$10$B6iupNb.rcYQDrUhc.lWUuVEfwk7WCACVgR1vQiQVaskig0Cwm.Zu","studiare","bagher.pebs@yahoo.com","","2018-09-13 21:26:21","","0","تیم طراحی سان کد");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("1","1","nickname","studiare"),
("2","1","first_name","سان"),
("3","1","last_name","کد"),
("4","1","description","توجه: این متن از پیشخوان&gt;کاربران&gt; ویرایش کاربری&gt;زندگی نامه تغییر پیدا می کند. لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد."),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp_capabilities","a:2:{s:13:\"administrator\";b:1;s:13:\"bbp_keymaster\";b:1;}"),
("13","1","wp_user_level","10"),
("14","1","dismissed_wp_pointers","wp496_privacy,text_widget_custom_html,vc_pointers_backend_editor,vc_pointers_frontend_editor,vc_grid_item,theme_editor_notice,plugin_editor_notice"),
("15","1","show_welcome_panel","0"),
("17","1","wp_dashboard_quick_press_last_post_id","12164"),
("19","1","wc_last_active","1757116800"),
("20","1","nav_menu_recently_edited","45"),
("21","1","managenav-menuscolumnshidden","a:0:{}"),
("22","1","metaboxhidden_nav-menus","a:0:{}"),
("23","1","dismissed_no_shipping_methods_notice","1"),
("24","1","wp_user-settings","libraryContent=browse&editor=tinymce&hidetb=1&posts_list_mode=list"),
("25","1","wp_user-settings-time","1745867466"),
("26","1","last_update","1745876531"),
("27","1","billing_first_name","سان"),
("28","1","billing_last_name","کد"),
("29","1","billing_address_1","تهران"),
("30","1","billing_address_2","تهران"),
("31","1","billing_city","تهران"),
("32","1","billing_state","THR"),
("33","1","billing_postcode","1234567890"),
("34","1","billing_country","IR"),
("35","1","billing_email","bagher.pebs@yahoo.com"),
("36","1","billing_phone","02112356789"),
("40","1","show_try_gutenberg_panel","0"),
("41","1","dismissed_no_secure_connection_notice","1"),
("42","1","paying_customer","1"),
("43","1","manageedit-eventcolumnshidden","a:1:{i:0;s:8:\"event-id\";}"),
("44","1","closedpostboxes_nav-menus","a:0:{}"),
("45","1","closedpostboxes_post","a:1:{i:0;s:25:\"slider_revolution_metabox\";}"),
("46","1","metaboxhidden_post","a:0:{}"),
("60","1","community-events-location","a:1:{s:2:\"ip\";s:12:\"46.249.125.0\";}"),
("61","1","closedpostboxes_product","a:1:{i:0;s:26:\"woocommerce-product-images\";}"),
("62","1","metaboxhidden_product","a:8:{i:0;s:11:\"postdivrich\";i:1;s:25:\"slider_revolution_metabox\";i:3;s:7:\"slugdiv\";i:4;s:25:\"cmb-group-lessons_group-0\";i:5;s:41:\"cmb-group-_studiare_metaboxjff_sections-0\";i:6;s:41:\"cmb-group-_studiare_metaboxjff_sections-1\";i:7;s:41:\"cmb-group-_studiare_metaboxjff_sections-2\";i:8;s:41:\"cmb-group-_studiare_metaboxjff_sections-3\";}"),
("68","1","shipping_method",""),
("71","1","dokan_profile_settings","a:24:{s:10:\"store_name\";s:8:\"studiare\";s:6:\"social\";a:8:{s:2:\"fb\";s:27:\"http://facebook.com/suncode\";s:5:\"gplus\";b:0;s:7:\"twitter\";b:0;s:9:\"pinterest\";b:0;s:8:\"linkedin\";b:0;s:7:\"youtube\";b:0;s:9:\"instagram\";s:29:\"http://instagram.com/facebook\";s:6:\"flickr\";b:0;}s:7:\"payment\";a:2:{s:6:\"paypal\";a:1:{i:0;s:5:\"email\";}s:4:\"bank\";a:0:{}}s:5:\"phone\";s:12:\"021123456789\";s:10:\"show_email\";s:2:\"no\";s:7:\"address\";a:6:{s:8:\"street_1\";s:0:\"\";s:8:\"street_2\";s:0:\"\";s:4:\"city\";s:0:\"\";s:3:\"zip\";s:0:\"\";s:7:\"country\";s:2:\"IR\";s:5:\"state\";s:2:\"TE\";}s:8:\"location\";s:0:\"\";s:6:\"banner\";i:622;s:9:\"store_ppp\";i:0;s:12:\"find_address\";s:0:\"\";s:14:\"show_more_ptab\";s:3:\"yes\";s:8:\"gravatar\";i:0;s:10:\"enable_tnc\";s:0:\"\";s:9:\"store_tnc\";s:0:\"\";s:16:\"dokan_store_time\";a:7:{s:6:\"sunday\";a:3:{s:4:\"open\";s:5:\"close\";s:12:\"opening_time\";s:0:\"\";s:12:\"closing_time\";s:0:\"\";}s:6:\"monday\";a:3:{s:4:\"open\";s:5:\"close\";s:12:\"opening_time\";s:0:\"\";s:12:\"closing_time\";s:0:\"\";}s:7:\"tuesday\";a:3:{s:4:\"open\";s:5:\"close\";s:12:\"opening_time\";s:0:\"\";s:12:\"closing_time\";s:0:\"\";}s:9:\"wednesday\";a:3:{s:4:\"open\";s:5:\"close\";s:12:\"opening_time\";s:0:\"\";s:12:\"closing_time\";s:0:\"\";}s:8:\"thursday\";a:3:{s:4:\"open\";s:5:\"close\";s:12:\"opening_time\";s:0:\"\";s:12:\"closing_time\";s:0:\"\";}s:6:\"friday\";a:3:{s:4:\"open\";s:5:\"close\";s:12:\"opening_time\";s:0:\"\";s:12:\"closing_time\";s:0:\"\";}s:8:\"saturday\";a:3:{s:4:\"open\";s:5:\"close\";s:12:\"opening_time\";s:0:\"\";s:12:\"closing_time\";s:0:\"\";}}s:24:\"dokan_store_time_enabled\";s:0:\"\";s:23:\"dokan_store_open_notice\";s:0:\"\";s:24:\"dokan_store_close_notice\";s:0:\"\";s:18:\"profile_completion\";a:8:{s:2:\"fb\";i:2;s:5:\"phone\";i:10;s:6:\"banner\";i:15;s:10:\"store_name\";i:10;s:4:\"Bank\";i:15;s:9:\"next_todo\";s:40:\"Add Profile Picture to gain 15% progress\";s:8:\"progress\";i:52;s:13:\"progress_vals\";a:8:{s:10:\"banner_val\";i:15;s:19:\"profile_picture_val\";i:15;s:14:\"store_name_val\";i:10;s:10:\"social_val\";a:5:{s:2:\"fb\";i:2;s:5:\"gplus\";i:2;s:7:\"twitter\";i:2;s:7:\"youtube\";i:2;s:8:\"linkedin\";i:2;}s:18:\"payment_method_val\";i:15;s:9:\"phone_val\";i:10;s:11:\"address_val\";i:10;s:7:\"map_val\";i:15;}}s:23:\"show_min_order_discount\";s:2:\"no\";s:28:\"setting_minimum_order_amount\";s:0:\"\";s:24:\"setting_order_percentage\";s:0:\"\";s:16:\"support_btn_name\";s:44:\"دریافت پشتیبانی محصولات\";s:16:\"show_support_btn\";s:3:\"yes\";}"),
("72","1","dokan_enable_selling","yes"),
("73","1","dokan_publishing","yes"),
("74","1","dokan_admin_percentage",""),
("75","1","dokan_admin_percentage_type","percentage"),
("76","1","dokan_feature_seller","yes"),
("77","1","dokan_store_name","studiare"),
("78","1","billing_company",""),
("79","1","shipping_first_name",""),
("80","1","shipping_last_name",""),
("81","1","shipping_company",""),
("82","1","shipping_address_1",""),
("83","1","shipping_address_2",""),
("84","1","shipping_city",""),
("85","1","shipping_postcode",""),
("86","1","shipping_country",""),
("87","1","shipping_state",""),
("88","1","closedpostboxes_dashboard","a:0:{}"),
("89","1","metaboxhidden_dashboard","a:9:{i:0;s:19:\"dashboard_right_now\";i:1;s:24:\"persian_woocommerce_feed\";i:2;s:36:\"woocommerce_dashboard_recent_reviews\";i:3;s:20:\"e-dashboard-overview\";i:4;s:24:\"wp-dashboard-widget-news\";i:5;s:27:\"duplicator_dashboard_widget\";i:6;s:18:\"dashboard_activity\";i:7;s:21:\"dashboard_site_health\";i:8;s:17:\"dashboard_primary\";}"),
("1346","1","dismissed_wootenberg_notice","1"),
("1913","1","dismissed_update_notice","1"),
("2156","1","_woocommerce_tracks_anon_id","woo:1mnbQL+t2gzwwfqlCgJ0lkF+"),
("2157","1","wp_r_tru_u_x","a:2:{s:2:\"id\";s:0:\"\";s:7:\"expires\";i:86400;}"),
("2158","1","dismissed_wc_admin_notice","1"),
("2964","1","users_per_page","130"),
("2965","1","itsec_user_activity_last_seen","1568418332"),
("2966","1","itsec-settings-view","grid"),
("2968","1","woosw_key","TXNZB8"),
("2972","1","edit_shop_order_per_page","90"),
("2982","1","closedpostboxes_shop_order","a:0:{}"),
("2983","1","metaboxhidden_shop_order","a:0:{}"),
("2986","1","wp_tab_widget_ignore_notice","1"),
("3058","1","meta-box-order_product","a:4:{s:15:\"acf_after_title\";s:0:\"\";s:4:\"side\";s:124:\"submitdiv,product_catdiv,tagsdiv-product_tag,postimagediv,woocommerce-product-images,pageparentdiv,slider_revolution_metabox\";s:6:\"normal\";s:138:\"postexcerpt,woocommerce-product-data,slugdiv,product_metabox,cmb-group-_studiare_metaboxjff_sections-0,postcustom,commentsdiv,revisionsdiv\";s:8:\"advanced\";s:0:\"\";}"),
("3059","1","screen_layout_product","2"),
("3062","1","dismissed_maxmind_license_key_notice","1"),
("3079","1","manageedit-productcolumnshidden","a:1:{i:0;s:10:\"post_views\";}"),
("3086","1","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:154:\"dashboard_right_now,dashboard_quick_press,persian_woocommerce_feed,woocommerce_dashboard_recent_reviews,e-dashboard-overview,quadlayers-dashboard-overview\";s:4:\"side\";s:87:\"dashboard_activity,dashboard_site_health,dashboard_primary,woocommerce_dashboard_status\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("3088","1","manageedit-cdownloadcolumnshidden","a:1:{i:0;s:10:\"post_views\";}"),
("3118","1","tgmpa_dismissed_notice_tgmpa","1"),
("3223","1","meta-box-order_post","a:4:{s:6:\"normal\";s:72:\"post_format_box,download_box,cmb-group-download_box_group-0,page_metabox\";s:8:\"advanced\";s:0:\"\";s:15:\"acf_after_title\";s:0:\"\";s:4:\"side\";s:25:\"slider_revolution_metabox\";}"),
("3224","1","screen_layout_post","2"),
("3300","1","meta-box-order_vc_grid_item","a:3:{s:4:\"side\";s:9:\"submitdiv\";s:6:\"normal\";s:27:\"wpb_visual_composer,slugdiv\";s:8:\"advanced\";s:0:\"\";}"),
("3301","1","screen_layout_vc_grid_item","1"),
("3305","1","th_thunk_notice_ignore","true"),
("3313","1","digits_form_data","a:0:{}"),
("3314","1","closedpostboxes_page","a:0:{}"),
("3315","1","metaboxhidden_page","a:1:{i:0;s:25:\"slider_revolution_metabox\";}"),
("3325","1","_current_woo_wallet_balance","417670"),
("3329","1","_woo_wallet_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("3338","1","a3_lazy_load-a3_lazy_load_global_settings","a:3:{i:0;s:23:\"a3l_apply_to_images_box\";i:1;s:22:\"a3l_settings_style_box\";i:2;s:32:\"a3l_script_load_optimization_box\";}"),
("3802","1","wcsts_ticket_id","2425"),
("3803","1","wcsts_ticket_id","2431"),
("3810","1","swss_ticket_id","2440"),
("3877","1","extendifysdk_uuid","34b8defbe31d2ab355f25db805544b94"),
("3878","1","extendifysdk_user_data","{\"state\":{\"firstLoadedOn\":\"2022-04-16T19:21:52.586Z\",\"email\":\"\",\"apiKey\":\"\",\"uuid\":\"34b8defbe31d2ab355f25db805544b94\",\"sdkPartner\":\"Redux\",\"noticesDismissedAt\":[],\"modalNoticesDismissedAt\":[],\"imports\":0,\"runningImports\":0,\"allowedImports\":0,\"freebieImports\":0,\"entryPoint\":\"main-button\",\"enabled\":true,\"canInstallPlugins\":true,\"canActivatePlugins\":true,\"participatingTestsGroups\":{\"main-button-text\":\"C\",\"main-button-text2\":\"A\"},\"preferredOptions\":{\"taxonomies\":[],\"type\":\"\",\"search\":\"\"},\"preferredOptionsHistory\":{\"siteType\":[]},\"isAdmin\":true},\"version\":0}"),
("3881","1","wp_elementor_connect_common_data","a:3:{s:9:\"client_id\";s:32:\"CxO9CC10L4TgKhgQLU2DXYNz1LDJQT4f\";s:11:\"auth_secret\";s:32:\"pia4R55pgbkgrnBwZP2nohaiOBkgxABB\";s:5:\"state\";s:12:\"mazzO5zLFLQV\";}"),
("3886","1","elementor_library_remote","a:1:{s:9:\"favorites\";a:1:{i:13244;b:1;}}"),
("3888","1","elementor_introduction","a:6:{s:13:\"popupSettings\";b:1;s:27:\"ai-get-started-announcement\";b:1;s:35:\"upload_json_warning_generic_message\";b:1;s:20:\"globals_introduction\";b:1;s:6:\"e-apps\";b:1;s:34:\"ai_promotion_introduction_textarea\";b:1;}"),
("3920","1","wpclever_wpcstore_ignore","true"),
("3939","1","elementor_admin_notices","a:5:{s:21:\"elementor_dev_promote\";s:4:\"true\";s:20:\"experiment_promotion\";s:4:\"true\";s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:6:\"3.25.4\";}}s:31:\"elementor-pro-forms-submissions\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}s:21:\"site_mailer_promotion\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("4010","1","manageedit-elementor_librarycolumnshidden","a:2:{i:0;s:6:\"author\";i:1;s:4:\"date\";}"),
("4069","1","wp_elementor_editor_user_favorites","a:0:{}"),
("4077","1","woosw_keys","a:1:{s:6:\"TXNZB8\";a:3:{s:4:\"type\";s:7:\"primary\";s:4:\"name\";s:0:\"\";s:4:\"time\";s:0:\"\";}}"),
("4089","1","dismissed_download_directories_sync_complete_notice","1"),
("4171","1","aco-user-rating","1"),
("4180","1","aco-user-premium","1"),
("4193","1","aco-user-cross-sell","1"),
("4201","1","wp_persisted_preferences","a:3:{s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2025-04-28T21:42:11.824Z\";s:4:\"core\";a:2:{s:10:\"openPanels\";a:5:{i:0;s:11:\"post-status\";i:1;s:23:\"taxonomy-panel-category\";i:2;s:23:\"taxonomy-panel-post_tag\";i:3;s:14:\"featured-image\";i:4;s:12:\"post-excerpt\";}s:26:\"isComplementaryAreaVisible\";b:0;}}"),
("4208","1","shipping_phone",""),
("4210","1","dismissed_template_files_notice","1"),
("4238","1","closedpostboxes_swss_ticket","a:0:{}"),
("4239","1","metaboxhidden_swss_ticket","a:1:{i:0;s:7:\"slugdiv\";}"),
("4273","1","meta-box-order_swss_ticket","a:4:{s:15:\"acf_after_title\";s:23:\"acf-group_57c444e52816c\";s:4:\"side\";s:78:\"submitdiv,acf-group_57c4404468513,slider_revolution_metabox,wcst-customer-data\";s:6:\"normal\";s:76:\"slugdiv,wcst-assigned-user-manager,wcst-subject,wcst-messages,wcst-reply-box\";s:8:\"advanced\";s:0:\"\";}"),
("4274","1","screen_layout_swss_ticket","2"),
("4375","1","announcements_user_counter","1"),
("4404","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("4495","1","dismissed_product_reviews_moved_notice","1"),
("4597","1","_rcp_new_subscription","1"),
("4598","1","rcp_pending_subscription_key","1a4455c603348bc21df7c21d12139ead"),
("4599","1","rcp_pending_subscription_level","2"),
("4600","1","rcp_pending_payment_id","1"),
("4601","1","rcp_pending_email_verification","23e223d7709a14dc65452a95b0c4a083"),
("4602","1","rcp_pending_subscription_amount","320000"),
("4607","1","pmpro_logins","a:10:{s:4:\"last\";s:14:\"9 January 2024\";s:8:\"thisdate\";s:10:\"2024-09-01\";s:4:\"week\";i:1;s:8:\"thisweek\";s:2:\"02\";s:5:\"month\";i:2;s:9:\"thismonth\";s:1:\"1\";s:3:\"ytd\";i:2;s:8:\"thisyear\";s:4:\"2024\";s:7:\"alltime\";i:3;s:5:\"today\";i:0;}"),
("4609","1","pmpro_visits","a:10:{s:4:\"last\";s:14:\"6 January 2024\";s:8:\"thisdate\";s:10:\"2024-06-01\";s:4:\"week\";i:3;s:8:\"thisweek\";s:2:\"01\";s:5:\"month\";i:3;s:9:\"thismonth\";s:1:\"1\";s:3:\"ytd\";i:3;s:8:\"thisyear\";s:4:\"2024\";s:7:\"alltime\";i:4;s:5:\"today\";i:0;}"),
("4610","1","pmpro_views","a:10:{s:4:\"last\";s:14:\"9 January 2024\";s:8:\"thisdate\";s:10:\"2024-09-01\";s:4:\"week\";i:2;s:8:\"thisweek\";s:2:\"02\";s:5:\"month\";i:20;s:9:\"thismonth\";s:1:\"1\";s:3:\"ytd\";i:20;s:8:\"thisyear\";s:4:\"2024\";s:7:\"alltime\";i:89;s:5:\"today\";i:0;}"),
("4620","1","closedpostboxes_teacher","a:1:{i:0;s:12:\"revisionsdiv\";}"),
("4621","1","metaboxhidden_teacher","a:1:{i:0;s:7:\"slugdiv\";}"),
("4658","1","duplicator_user_ui_option","a:6:{s:17:\"num_packages_list\";i:10;s:19:\"created_date_format\";s:1:\"1\";s:16:\"show_note_column\";b:0;s:16:\"show_size_column\";b:1;s:19:\"show_created_column\";b:1;s:15:\"show_age_column\";b:0;}"),
("4678","1","elementor_dismissed_editor_notices","a:2:{i:0;s:23:\"image-optimization-once\";i:1;s:20:\"image_optimizer_hint\";}"),
("4765","1","quadlayers_autocomplete-woocommerce-orders_notice_hidden_0","1"),
("4803","1","quadlayers_autocomplete-woocommerce-orders_notice_hidden_1","1"),
("4807","1","quadlayers_autocomplete-woocommerce-orders_notice_hidden_2","1"),
("4808","1","quadlayers_autocomplete-woocommerce-orders_notice_hidden_3","1"),
("4809","1","meta-box-order_studi_lesson","a:4:{s:15:\"acf_after_title\";s:0:\"\";s:4:\"side\";s:35:\"submitdiv,slider_revolution_metabox\";s:6:\"normal\";s:84:\"sc_course_options_box,cmb-group-lesson_data-0,parent_post_meta_box,slugdiv,authordiv\";s:8:\"advanced\";s:0:\"\";}"),
("4810","1","screen_layout_studi_lesson","2"),
("4817","1","wp_media_library_mode","grid"),
("4818","1","edit_elementor_library_per_page","40"),
("4921","1","wc_order_count_wp","0"),
("4948","1","session_tokens","a:1:{s:64:\"fe85f58fd9f2a0a96d90b722fcf581b9230102472cdb637d31c0a60953355538\";a:4:{s:10:\"expiration\";i:1757303181;s:2:\"ip\";s:13:\"46.249.125.82\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";s:5:\"login\";i:1757130381;}}");

INSERT IGNORE INTO `wp_actionscheduler_actions` VALUES 
("1938","action_scheduler/migration_hook","failed","2023-02-15 06:42:20","2023-02-15 10:12:20","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1676443340;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1676443340;}","1","1","2023-02-15 06:43:21","2023-02-15 10:13:21","0",NULL,"10"),
("1942","action_scheduler/migration_hook","failed","2023-02-15 10:26:38","2023-02-15 13:56:38","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1676456798;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1676456798;}","1","1","2023-02-15 10:26:52","2023-02-15 13:56:52","0",NULL,"10"),
("1944","action_scheduler/migration_hook","failed","2023-02-15 11:26:19","2023-02-15 14:56:19","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1676460379;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1676460379;}","1","1","2023-02-15 11:28:27","2023-02-15 14:58:27","0",NULL,"10"),
("1946","action_scheduler/migration_hook","failed","2023-02-15 19:46:35","2023-02-15 23:16:35","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1676490395;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1676490395;}","1","1","2023-02-15 19:46:44","2023-02-15 23:16:44","0",NULL,"10"),
("1950","action_scheduler/migration_hook","failed","2023-02-16 17:50:11","2023-02-16 21:20:11","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1676569811;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1676569811;}","1","1","2023-02-16 17:50:16","2023-02-16 21:20:16","0",NULL,"10"),
("1953","action_scheduler/migration_hook","failed","2023-02-16 18:20:28","2023-02-16 21:50:28","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1676571628;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1676571628;}","1","1","2023-02-16 18:20:38","2023-02-16 21:50:38","0",NULL,"10"),
("1955","action_scheduler/migration_hook","failed","2023-02-16 18:28:09","2023-02-16 21:58:09","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1676572089;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1676572089;}","1","1","2023-02-16 18:29:13","2023-02-16 21:59:13","0",NULL,"10"),
("1957","action_scheduler/migration_hook","failed","2023-02-16 18:47:29","2023-02-16 22:17:29","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1676573249;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1676573249;}","1","1","2023-02-16 18:47:34","2023-02-16 22:17:34","0",NULL,"10"),
("2110","action_scheduler/migration_hook","failed","2023-04-20 10:45:12","2023-04-20 15:15:12","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1681987512;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1681987512;}","1","1","2023-04-20 10:45:28","2023-04-20 15:15:28","0",NULL,"10"),
("2112","action_scheduler/migration_hook","failed","2023-04-20 13:36:30","2023-04-20 18:06:30","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1681997790;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1681997790;}","1","1","2023-04-20 13:37:03","2023-04-20 18:07:03","0",NULL,"10"),
("2213","action_scheduler/migration_hook","failed","2023-07-14 07:51:36","2023-07-14 12:21:36","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1689321096;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1689321096;}","1","1","2023-07-14 07:52:24","2023-07-14 12:22:24","0",NULL,"10"),
("2476","action_scheduler/migration_hook","failed","2024-01-09 12:11:40","2024-01-09 15:41:40","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1704802300;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1704802300;}","1","1","2024-01-09 12:12:32","2024-01-09 15:42:32","0",NULL,"10"),
("2533","action_scheduler/migration_hook","failed","2024-02-16 07:40:25","2024-02-16 11:10:25","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1708069225;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1708069225;}","1","1","2024-02-16 07:42:26","2024-02-16 11:12:26","0",NULL,"10"),
("2541","action_scheduler/migration_hook","failed","2024-02-19 11:12:43","2024-02-19 14:42:43","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1708341163;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1708341163;}","1","1","2024-02-19 11:13:43","2024-02-19 14:43:43","0",NULL,"10"),
("2576","action_scheduler/migration_hook","failed","2024-03-18 21:35:41","2024-03-19 01:05:41","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1710797741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1710797741;}","1","1","2024-03-18 21:35:49","2024-03-19 01:05:49","0",NULL,"10"),
("2777","action_scheduler/migration_hook","failed","2024-06-06 12:19:19","2024-06-06 15:49:19","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1717676359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1717676359;}","1","1","2024-06-06 12:19:21","2024-06-06 15:49:21","0",NULL,"10"),
("2819","action_scheduler/migration_hook","failed","2024-11-02 14:04:01","2024-11-02 17:34:01","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730556241;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730556241;}","1","1","2024-11-02 14:05:02","2024-11-02 17:35:02","0",NULL,"10"),
("2821","action_scheduler/migration_hook","failed","2024-11-02 14:11:58","2024-11-02 17:41:58","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730556718;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730556718;}","1","1","2024-11-02 14:13:42","2024-11-02 17:43:42","0",NULL,"10"),
("2824","action_scheduler/migration_hook","failed","2024-11-02 14:27:37","2024-11-02 17:57:37","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730557657;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730557657;}","1","1","2024-11-02 14:27:38","2024-11-02 17:57:38","0",NULL,"10"),
("2848","action_scheduler/migration_hook","failed","2024-11-04 05:47:40","2024-11-04 09:17:40","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730699260;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730699260;}","1","1","2024-11-04 05:47:40","2024-11-04 09:17:40","0",NULL,"10"),
("4784","woocommerce_custom_orders_table_background_sync","complete","2025-04-30 15:38:25","2025-04-30 19:08:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746027505;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746027505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-04-30 15:42:39","2025-04-30 19:12:39","0",NULL,"10"),
("4785","woocommerce_custom_orders_table_background_sync","complete","2025-04-30 16:42:39","2025-04-30 20:12:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746031359;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746031359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-04-30 16:55:12","2025-04-30 20:25:12","0",NULL,"10"),
("4786","woocommerce_custom_orders_table_background_sync","complete","2025-04-30 17:55:12","2025-04-30 21:25:12","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746035712;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746035712;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-04-30 18:33:25","2025-04-30 22:03:25","0",NULL,"10"),
("4787","woocommerce_custom_orders_table_background_sync","complete","2025-04-30 19:33:25","2025-04-30 23:03:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746041605;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746041605;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-04-30 19:35:10","2025-04-30 23:05:10","0",NULL,"10"),
("4788","woocommerce_custom_orders_table_background_sync","complete","2025-04-30 20:35:10","2025-05-01 00:05:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746045310;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746045310;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-04-30 20:41:51","2025-05-01 00:11:51","0",NULL,"10"),
("4789","woocommerce_custom_orders_table_background_sync","complete","2025-04-30 21:41:51","2025-05-01 01:11:51","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746049311;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746049311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-04-30 21:42:33","2025-05-01 01:12:33","0",NULL,"10"),
("4790","woocommerce_custom_orders_table_background_sync","complete","2025-04-30 22:42:33","2025-05-01 02:12:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746052953;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746052953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-04-30 22:47:54","2025-05-01 02:17:54","0",NULL,"10"),
("4791","woocommerce_marketplace_fetch_promotions_clear","complete","2025-04-30 21:42:33","2025-05-01 01:12:33","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746049353;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746049353;}","5","1","2025-04-30 21:46:29","2025-05-01 01:16:29","0",NULL,"10"),
("4792","woocommerce_custom_orders_table_background_sync","complete","2025-04-30 23:47:54","2025-05-01 03:17:54","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746056874;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746056874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-05-01 00:05:26","2025-05-01 03:35:26","0",NULL,"10"),
("4793","woocommerce_custom_orders_table_background_sync","complete","2025-05-01 01:05:26","2025-05-01 04:35:26","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746061526;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746061526;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-05-01 01:14:50","2025-05-01 04:44:50","0",NULL,"10"),
("4794","woocommerce_custom_orders_table_background_sync","complete","2025-05-01 02:14:50","2025-05-01 05:44:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746065690;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746065690;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-05-01 02:31:48","2025-05-01 06:01:48","0",NULL,"10"),
("4795","woocommerce_custom_orders_table_background_sync","complete","2025-05-01 03:31:48","2025-05-01 07:01:48","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746070308;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746070308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-05-01 03:35:36","2025-05-01 07:05:36","0",NULL,"10"),
("4796","woocommerce_custom_orders_table_background_sync","complete","2025-05-01 04:35:36","2025-05-01 08:05:36","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746074136;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746074136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-05-01 04:40:56","2025-05-01 08:10:56","0",NULL,"10"),
("4797","woocommerce_cleanup_draft_orders","complete","2025-05-02 04:31:28","2025-05-02 08:01:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746160288;s:18:\"\0*\0first_timestamp\";i:1681934572;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746160288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2025-09-06 03:44:14","2025-09-06 07:14:14","0",NULL,"10"),
("4798","woocommerce_custom_orders_table_background_sync","complete","2025-05-01 05:40:56","2025-05-01 09:10:56","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746078056;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746078056;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-05-01 05:42:01","2025-05-01 09:12:01","0",NULL,"10"),
("4799","woocommerce_custom_orders_table_background_sync","complete","2025-05-01 06:42:01","2025-05-01 10:12:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746081721;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746081721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-05-01 06:42:14","2025-05-01 10:12:14","0",NULL,"10"),
("4800","woocommerce_custom_orders_table_background_sync","complete","2025-05-01 07:42:14","2025-05-01 11:12:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746085334;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746085334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-05-01 07:59:39","2025-05-01 11:29:39","0",NULL,"10"),
("4801","fetch_patterns","complete","2025-05-01 07:08:00","2025-05-01 10:38:00","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746083280;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746083280;}","5","1","2025-05-01 07:08:12","2025-05-01 10:38:12","0",NULL,"10"),
("4802","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2025-05-01 07:08:12","2025-05-01 10:38:12","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746083292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746083292;}","2","1","2025-05-01 07:08:12","2025-05-01 10:38:12","0",NULL,"10"),
("4803","woocommerce_custom_orders_table_background_sync","complete","2025-05-01 08:59:39","2025-05-01 12:29:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746089979;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746089979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-05-01 09:00:00","2025-05-01 12:30:00","0",NULL,"10"),
("4804","woocommerce_custom_orders_table_background_sync","complete","2025-05-01 10:00:00","2025-05-01 13:30:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746093600;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746093600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","1","2025-09-06 03:44:14","2025-09-06 07:14:14","0",NULL,"10"),
("4805","woocommerce_marketplace_fetch_promotions_clear","complete","2025-05-01 09:38:35","2025-05-01 13:08:35","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746092315;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746092315;}","5","1","2025-05-01 09:39:35","2025-05-01 13:09:35","0",NULL,"10"),
("4806","action_scheduler/migration_hook","complete","2025-05-01 09:57:11","2025-05-01 13:27:11","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746093431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746093431;}","1","1","2025-05-01 09:57:24","2025-05-01 13:27:24","0",NULL,"10"),
("4807","woocommerce_custom_orders_table_background_sync","pending","2025-09-06 04:44:14","2025-09-06 08:14:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757133854;s:18:\"\0*\0first_timestamp\";i:1717669058;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757133854;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","5","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("4808","woocommerce_cleanup_draft_orders","pending","2025-09-07 03:44:14","2025-09-07 07:14:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757216654;s:18:\"\0*\0first_timestamp\";i:1681934572;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757216654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("4809","woocommerce_marketplace_fetch_promotions_clear","complete","2025-09-06 03:44:20","2025-09-06 07:14:20","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757130260;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757130260;}","5","1","2025-09-06 03:44:22","2025-09-06 07:14:22","0",NULL,"10"),
("4810","woocommerce_run_update_callback","complete","2025-09-06 04:08:55","2025-09-06 07:38:55","{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131735;}","2","1","2025-09-06 04:08:55","2025-09-06 07:38:55","188989",NULL,"10"),
("4811","woocommerce_run_update_callback","complete","2025-09-06 04:08:56","2025-09-06 07:38:56","{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131736;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131736;}","2","1","2025-09-06 04:08:56","2025-09-06 07:38:56","188992",NULL,"10"),
("4812","woocommerce_run_update_callback","complete","2025-09-06 04:08:57","2025-09-06 07:38:57","{\"update_callback\":\"wc_update_990_remove_email_notes\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131737;}","2","1","2025-09-06 04:09:01","2025-09-06 07:39:01","188994",NULL,"10"),
("4813","woocommerce_run_update_callback","complete","2025-09-06 04:08:58","2025-09-06 07:38:58","{\"update_callback\":\"wc_update_1000_multisite_visibility_setting\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131738;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131738;}","2","1","2025-09-06 04:09:01","2025-09-06 07:39:01","188994",NULL,"10"),
("4814","woocommerce_run_update_callback","complete","2025-09-06 04:08:59","2025-09-06 07:38:59","{\"update_callback\":\"wc_update_1000_remove_patterns_toolkit_transient\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131739;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131739;}","2","1","2025-09-06 04:09:01","2025-09-06 07:39:01","188994",NULL,"10"),
("4815","woocommerce_update_db_to_current_version","complete","2025-09-06 04:09:00","2025-09-06 07:39:00","{\"version\":\"10.1.2\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131740;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131740;}","2","1","2025-09-06 04:09:01","2025-09-06 07:39:01","188994",NULL,"10"),
("4816","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2025-09-06 04:08:56","2025-09-06 07:38:56","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131736;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131736;}","2","1","2025-09-06 04:08:56","2025-09-06 07:38:56","188992",NULL,"10"),
("4817","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-09-06 04:08:55","2025-09-06 07:38:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757131735;s:18:\"\0*\0first_timestamp\";i:1757131735;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757131735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2025-09-06 04:08:55","2025-09-06 07:38:55","188989",NULL,"20"),
("4818","woocommerce_run_update_callback","complete","2025-09-06 04:08:55","2025-09-06 07:38:55","{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131735;}","2","1","2025-09-06 04:08:55","2025-09-06 07:38:55","188990",NULL,"10"),
("4819","woocommerce_scheduled_sales","pending","2025-09-06 21:00:00","2025-09-07 00:30:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757192400;s:18:\"\0*\0first_timestamp\";i:1757192400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757192400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("4820","woocommerce_run_update_callback","complete","2025-09-06 04:08:56","2025-09-06 07:38:56","{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131736;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131736;}","2","1","2025-09-06 04:08:56","2025-09-06 07:38:56","188992",NULL,"10"),
("4821","woocommerce_cancel_unpaid_orders","pending","2025-09-06 05:08:55","2025-09-06 08:38:55","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757135335;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757135335;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("4822","woocommerce_run_update_callback","complete","2025-09-06 04:08:57","2025-09-06 07:38:57","{\"update_callback\":\"wc_update_990_remove_email_notes\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131737;}","2","1","2025-09-06 04:09:01","2025-09-06 07:39:01","188994",NULL,"10"),
("4823","woocommerce_cleanup_personal_data","complete","2025-09-06 04:09:05","2025-09-06 07:39:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757131745;s:18:\"\0*\0first_timestamp\";i:1757131745;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757131745;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","1","2025-09-06 04:09:06","2025-09-06 07:39:06","188996",NULL,"10"),
("4824","woocommerce_run_update_callback","complete","2025-09-06 04:08:58","2025-09-06 07:38:58","{\"update_callback\":\"wc_update_1000_multisite_visibility_setting\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131738;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131738;}","2","1","2025-09-06 04:09:01","2025-09-06 07:39:01","188994",NULL,"10"),
("4825","woocommerce_cleanup_logs","pending","2025-09-06 07:08:55","2025-09-06 10:38:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757142535;s:18:\"\0*\0first_timestamp\";i:1757142535;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757142535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("4826","woocommerce_run_update_callback","complete","2025-09-06 04:08:59","2025-09-06 07:38:59","{\"update_callback\":\"wc_update_1000_remove_patterns_toolkit_transient\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131739;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131739;}","2","1","2025-09-06 04:09:01","2025-09-06 07:39:01","188994",NULL,"10"),
("4827","woocommerce_cleanup_sessions","pending","2025-09-06 10:08:55","2025-09-06 13:38:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757153335;s:18:\"\0*\0first_timestamp\";i:1757153335;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757153335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("4828","woocommerce_geoip_updater","complete","2025-09-06 04:09:55","2025-09-06 07:39:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757131795;s:18:\"\0*\0first_timestamp\";i:1757131795;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757131795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}","10","1","2025-09-06 04:10:00","2025-09-06 07:40:00","188998",NULL,"10"),
("4829","woocommerce_cleanup_rate_limits_wrapper","pending","2025-09-06 07:08:55","2025-09-06 10:38:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757142535;s:18:\"\0*\0first_timestamp\";i:1757142535;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757142535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("4830","wc_admin_daily_wrapper","complete","2025-09-06 04:08:55","2025-09-06 07:38:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757131735;s:18:\"\0*\0first_timestamp\";i:1757131735;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757131735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","1","2025-09-06 04:08:55","2025-09-06 07:38:55","188990",NULL,"10"),
("4831","generate_category_lookup_table_wrapper","complete","2025-09-06 04:09:05","2025-09-06 07:39:05","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131745;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131745;}","10","1","2025-09-06 04:09:06","2025-09-06 07:39:06","188996",NULL,"10"),
("4832","woocommerce_refresh_order_count_cache","pending","2025-09-06 16:08:55","2025-09-06 19:38:55","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757174935;s:18:\"\0*\0first_timestamp\";i:1757174935;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757174935;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","11","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("4833","action_scheduler_run_recurring_actions_schedule_hook","pending","2025-09-07 04:08:55","2025-09-07 07:38:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757218135;s:18:\"\0*\0first_timestamp\";i:1757131735;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757218135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"20"),
("4834","wc_admin_daily_wrapper","pending","2025-09-07 04:08:55","2025-09-07 07:38:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757218135;s:18:\"\0*\0first_timestamp\";i:1757131735;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757218135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("4835","woocommerce_cleanup_personal_data","pending","2025-09-07 04:09:06","2025-09-07 07:39:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757218146;s:18:\"\0*\0first_timestamp\";i:1757131745;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757218146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("4836","woocommerce_geoip_updater","pending","2025-09-21 04:10:00","2025-09-21 07:40:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758427800;s:18:\"\0*\0first_timestamp\";i:1757131795;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758427800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}","10","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10");

INSERT IGNORE INTO `wp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2","woocommerce-db-updates"),
("3","wc_update_product_lookup_tables"),
("4","wc-admin-data"),
("5",""),
("6","wc_update_product_default_cat"),
("7","wc_batch_processes"),
("8","wc_delete_related_product_transients_group"),
("9","ActionScheduler"),
("10","woocommerce"),
("11","count");

INSERT IGNORE INTO `wp_actionscheduler_logs` VALUES 
("3011","1938","ایجاد فعالیت","2023-02-15 06:41:20","2023-02-15 10:11:20"),
("3012","1938","عملیات توسط WP Cron شروع شد","2023-02-15 06:43:21","2023-02-15 10:13:21"),
("3013","1938","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-02-15 06:43:21","2023-02-15 10:13:21"),
("3023","1942","ایجاد فعالیت","2023-02-15 10:25:38","2023-02-15 13:55:38"),
("3024","1942","عملیات توسط WP Cron شروع شد","2023-02-15 10:26:52","2023-02-15 13:56:52"),
("3025","1942","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-02-15 10:26:52","2023-02-15 13:56:52"),
("3029","1944","ایجاد فعالیت","2023-02-15 11:25:19","2023-02-15 14:55:19"),
("3030","1944","عملیات توسط WP Cron شروع شد","2023-02-15 11:28:27","2023-02-15 14:58:27"),
("3031","1944","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-02-15 11:28:27","2023-02-15 14:58:27"),
("3035","1946","ایجاد فعالیت","2023-02-15 19:45:35","2023-02-15 23:15:35"),
("3036","1946","عملیات توسط WP Cron شروع شد","2023-02-15 19:46:44","2023-02-15 23:16:44"),
("3037","1946","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-02-15 19:46:44","2023-02-15 23:16:44"),
("3047","1950","ایجاد فعالیت","2023-02-16 17:49:11","2023-02-16 21:19:11"),
("3048","1950","عملیات توسط WP Cron شروع شد","2023-02-16 17:50:16","2023-02-16 21:20:16"),
("3049","1950","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-02-16 17:50:16","2023-02-16 21:20:16"),
("3056","1953","ایجاد فعالیت","2023-02-16 18:19:28","2023-02-16 21:49:28"),
("3057","1953","عملیات توسط Async Request شروع شد","2023-02-16 18:20:38","2023-02-16 21:50:38"),
("3058","1953","اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-02-16 18:20:38","2023-02-16 21:50:38"),
("3062","1955","ایجاد فعالیت","2023-02-16 18:27:09","2023-02-16 21:57:09"),
("3063","1955","عملیات توسط WP Cron شروع شد","2023-02-16 18:29:13","2023-02-16 21:59:13"),
("3064","1955","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-02-16 18:29:13","2023-02-16 21:59:13"),
("3068","1957","ایجاد فعالیت","2023-02-16 18:46:29","2023-02-16 22:16:29"),
("3069","1957","عملیات توسط Async Request شروع شد","2023-02-16 18:47:34","2023-02-16 22:17:34"),
("3070","1957","اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-02-16 18:47:34","2023-02-16 22:17:34"),
("3523","2110","ایجاد فعالیت","2023-04-20 10:44:12","2023-04-20 15:14:12"),
("3524","2110","عملیات توسط WP Cron شروع شد","2023-04-20 10:45:28","2023-04-20 15:15:28"),
("3525","2110","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-04-20 10:45:28","2023-04-20 15:15:28"),
("3529","2112","ایجاد فعالیت","2023-04-20 13:35:30","2023-04-20 18:05:30"),
("3530","2112","عملیات توسط WP Cron شروع شد","2023-04-20 13:37:03","2023-04-20 18:07:03"),
("3531","2112","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-04-20 13:37:03","2023-04-20 18:07:03"),
("3832","2213","ایجاد فعالیت","2023-07-14 07:50:36","2023-07-14 12:20:36"),
("3833","2213","عملیات توسط WP Cron شروع شد","2023-07-14 07:52:24","2023-07-14 12:22:24"),
("3834","2213","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-07-14 07:52:24","2023-07-14 12:22:24"),
("4621","2476","ایجاد فعالیت","2024-01-09 12:10:40","2024-01-09 15:40:40"),
("4622","2476","عملیات توسط WP Cron شروع شد","2024-01-09 12:12:32","2024-01-09 15:42:32"),
("4623","2476","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-01-09 12:12:32","2024-01-09 15:42:32"),
("4792","2533","ایجاد فعالیت","2024-02-16 07:39:25","2024-02-16 11:09:25"),
("4793","2533","عملیات توسط WP Cron شروع شد","2024-02-16 07:42:26","2024-02-16 11:12:26"),
("4794","2533","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-02-16 07:42:26","2024-02-16 11:12:26"),
("4816","2541","action created","2024-02-19 11:11:43","2024-02-19 14:41:43"),
("4817","2541","action started via WP Cron","2024-02-19 11:13:43","2024-02-19 14:43:43"),
("4818","2541","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-02-19 11:13:43","2024-02-19 14:43:43"),
("4921","2576","ایجاد فعالیت","2024-03-18 21:34:41","2024-03-19 01:04:41"),
("4922","2576","عملیات توسط WP Cron شروع شد","2024-03-18 21:35:49","2024-03-19 01:05:49"),
("4923","2576","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-03-18 21:35:49","2024-03-19 01:05:49"),
("5520","2777","ایجاد فعالیت","2024-06-06 12:18:19","2024-06-06 15:48:19"),
("5521","2777","عملیات توسط Async Request شروع شد","2024-06-06 12:19:21","2024-06-06 15:49:21"),
("5522","2777","اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-06-06 12:19:21","2024-06-06 15:49:21"),
("5646","2819","عملیات ایجاد شد","2024-11-02 14:03:01","2024-11-02 17:33:01"),
("5647","2819","عملیات با WP Cron شروع شد","2024-11-02 14:05:02","2024-11-02 17:35:02"),
("5648","2819","عملکرد از طریقWP Cron انجام نشد:Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-11-02 14:05:02","2024-11-02 17:35:02"),
("5652","2821","عملیات ایجاد شد","2024-11-02 14:10:58","2024-11-02 17:40:58"),
("5653","2821","عملیات با WP Cron شروع شد","2024-11-02 14:13:42","2024-11-02 17:43:42"),
("5654","2821","عملکرد از طریقWP Cron انجام نشد:Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-11-02 14:13:42","2024-11-02 17:43:42"),
("5661","2824","ایجاد فعالیت","2024-11-02 14:26:37","2024-11-02 17:56:37"),
("5662","2824","عملیات توسط WP Cron شروع شد","2024-11-02 14:27:38","2024-11-02 17:57:38"),
("5663","2824","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-11-02 14:27:38","2024-11-02 17:57:38"),
("5734","2848","عملیات ایجاد شد","2024-11-04 05:46:40","2024-11-04 09:16:40"),
("5735","2848","عملیات با WP Cron شروع شد","2024-11-04 05:47:40","2024-11-04 09:17:40"),
("5736","2848","عملکرد از طریقWP Cron انجام نشد:Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-11-04 05:47:40","2024-11-04 09:17:40"),
("11544","4784","عملیات ایجاد شد","2025-04-30 14:38:25","2025-04-30 18:08:25"),
("11545","4784","عملیات با WP Cron شروع شد","2025-04-30 15:42:39","2025-04-30 19:12:39"),
("11546","4784","عملیات با WP Cron تکمیل شد","2025-04-30 15:42:39","2025-04-30 19:12:39"),
("11547","4785","عملیات ایجاد شد","2025-04-30 15:42:39","2025-04-30 19:12:39"),
("11548","4785","عملیات با WP Cron شروع شد","2025-04-30 16:55:12","2025-04-30 20:25:12"),
("11549","4785","عملیات با WP Cron تکمیل شد","2025-04-30 16:55:12","2025-04-30 20:25:12"),
("11550","4786","عملیات ایجاد شد","2025-04-30 16:55:12","2025-04-30 20:25:12"),
("11551","4786","عملیات با WP Cron شروع شد","2025-04-30 18:33:25","2025-04-30 22:03:25"),
("11552","4786","عملیات با WP Cron تکمیل شد","2025-04-30 18:33:25","2025-04-30 22:03:25"),
("11553","4787","عملیات ایجاد شد","2025-04-30 18:33:25","2025-04-30 22:03:25"),
("11554","4787","عملیات با WP Cron شروع شد","2025-04-30 19:35:10","2025-04-30 23:05:10"),
("11555","4787","عملیات با WP Cron تکمیل شد","2025-04-30 19:35:10","2025-04-30 23:05:10"),
("11556","4788","عملیات ایجاد شد","2025-04-30 19:35:10","2025-04-30 23:05:10"),
("11557","4788","عملیات با WP Cron شروع شد","2025-04-30 20:41:51","2025-05-01 00:11:51"),
("11558","4788","عملیات با WP Cron تکمیل شد","2025-04-30 20:41:51","2025-05-01 00:11:51"),
("11559","4789","عملیات ایجاد شد","2025-04-30 20:41:51","2025-05-01 00:11:51"),
("11560","4789","عملیات با WP Cron شروع شد","2025-04-30 21:42:33","2025-05-01 01:12:33"),
("11561","4789","عملیات با WP Cron تکمیل شد","2025-04-30 21:42:33","2025-05-01 01:12:33"),
("11562","4790","عملیات ایجاد شد","2025-04-30 21:42:33","2025-05-01 01:12:33"),
("11563","4791","عملیات ایجاد شد","2025-04-30 21:42:33","2025-05-01 01:12:33"),
("11564","4791","عملیات با WP Cron شروع شد","2025-04-30 21:46:29","2025-05-01 01:16:29"),
("11565","4791","عملیات با WP Cron تکمیل شد","2025-04-30 21:46:29","2025-05-01 01:16:29"),
("11566","4790","عملیات با WP Cron شروع شد","2025-04-30 22:47:54","2025-05-01 02:17:54"),
("11567","4790","عملیات با WP Cron تکمیل شد","2025-04-30 22:47:54","2025-05-01 02:17:54"),
("11568","4792","عملیات ایجاد شد","2025-04-30 22:47:54","2025-05-01 02:17:54"),
("11569","4792","عملیات با WP Cron شروع شد","2025-05-01 00:05:26","2025-05-01 03:35:26"),
("11570","4792","عملیات با WP Cron تکمیل شد","2025-05-01 00:05:26","2025-05-01 03:35:26"),
("11571","4793","عملیات ایجاد شد","2025-05-01 00:05:26","2025-05-01 03:35:26"),
("11572","4793","عملیات با WP Cron شروع شد","2025-05-01 01:14:50","2025-05-01 04:44:50"),
("11573","4793","عملیات با WP Cron تکمیل شد","2025-05-01 01:14:50","2025-05-01 04:44:50"),
("11574","4794","عملیات ایجاد شد","2025-05-01 01:14:50","2025-05-01 04:44:50"),
("11575","4794","عملیات با WP Cron شروع شد","2025-05-01 02:31:48","2025-05-01 06:01:48"),
("11576","4794","عملیات با WP Cron تکمیل شد","2025-05-01 02:31:48","2025-05-01 06:01:48"),
("11577","4795","عملیات ایجاد شد","2025-05-01 02:31:48","2025-05-01 06:01:48"),
("11578","4795","عملیات با WP Cron شروع شد","2025-05-01 03:35:36","2025-05-01 07:05:36"),
("11579","4795","عملیات با WP Cron تکمیل شد","2025-05-01 03:35:36","2025-05-01 07:05:36"),
("11580","4796","عملیات ایجاد شد","2025-05-01 03:35:36","2025-05-01 07:05:36"),
("11583","4797","عملیات ایجاد شد","2025-05-01 04:31:28","2025-05-01 08:01:28"),
("11584","4796","عملیات با WP Cron شروع شد","2025-05-01 04:40:56","2025-05-01 08:10:56"),
("11585","4796","عملیات با WP Cron تکمیل شد","2025-05-01 04:40:56","2025-05-01 08:10:56"),
("11586","4798","عملیات ایجاد شد","2025-05-01 04:40:56","2025-05-01 08:10:56"),
("11587","4798","عملیات با WP Cron شروع شد","2025-05-01 05:42:01","2025-05-01 09:12:01"),
("11588","4798","عملیات با WP Cron تکمیل شد","2025-05-01 05:42:01","2025-05-01 09:12:01"),
("11589","4799","عملیات ایجاد شد","2025-05-01 05:42:01","2025-05-01 09:12:01"),
("11590","4799","عملیات با Async Request شروع شد","2025-05-01 06:42:14","2025-05-01 10:12:14"),
("11591","4799","عملیات با Async Request تکمیل شد","2025-05-01 06:42:14","2025-05-01 10:12:14"),
("11592","4800","عملیات ایجاد شد","2025-05-01 06:42:14","2025-05-01 10:12:14"),
("11593","4801","عملیات ایجاد شد","2025-05-01 07:08:00","2025-05-01 10:38:00"),
("11594","4802","عملیات ایجاد شد","2025-05-01 07:08:11","2025-05-01 10:38:11"),
("11595","4801","عملیات با Async Request شروع شد","2025-05-01 07:08:12","2025-05-01 10:38:12"),
("11596","4801","عملیات با Async Request تکمیل شد","2025-05-01 07:08:12","2025-05-01 10:38:12"),
("11597","4802","عملیات با Async Request شروع شد","2025-05-01 07:08:12","2025-05-01 10:38:12"),
("11598","4802","عملیات با Async Request تکمیل شد","2025-05-01 07:08:12","2025-05-01 10:38:12"),
("11599","4800","عملیات با WP Cron شروع شد","2025-05-01 07:59:39","2025-05-01 11:29:39"),
("11600","4800","عملیات با WP Cron تکمیل شد","2025-05-01 07:59:39","2025-05-01 11:29:39"),
("11601","4803","عملیات ایجاد شد","2025-05-01 07:59:39","2025-05-01 11:29:39"),
("11602","4803","عملیات با WP Cron شروع شد","2025-05-01 09:00:00","2025-05-01 12:30:00"),
("11603","4803","عملیات با WP Cron تکمیل شد","2025-05-01 09:00:00","2025-05-01 12:30:00"),
("11604","4804","عملیات ایجاد شد","2025-05-01 09:00:00","2025-05-01 12:30:00"),
("11605","4805","عملیات ایجاد شد","2025-05-01 09:38:35","2025-05-01 13:08:35"),
("11606","4805","عملیات با WP Cron شروع شد","2025-05-01 09:39:35","2025-05-01 13:09:35"),
("11607","4805","عملیات با WP Cron تکمیل شد","2025-05-01 09:39:35","2025-05-01 13:09:35"),
("11608","4806","عملیات ایجاد شد","2025-05-01 09:56:11","2025-05-01 13:26:11"),
("11609","4806","عملیات با WP Cron شروع شد","2025-05-01 09:57:24","2025-05-01 13:27:24"),
("11610","4806","عملیات با WP Cron تکمیل شد","2025-05-01 09:57:24","2025-05-01 13:27:24"),
("11611","4804","عملیات با WP Cron شروع شد","2025-09-06 03:44:14","2025-09-06 07:14:14"),
("11612","4804","عملیات با WP Cron تکمیل شد","2025-09-06 03:44:14","2025-09-06 07:14:14"),
("11613","4807","عملیات ایجاد شد","2025-09-06 03:44:14","2025-09-06 07:14:14"),
("11614","4797","عملیات با WP Cron شروع شد","2025-09-06 03:44:14","2025-09-06 07:14:14"),
("11615","4797","عملیات با WP Cron تکمیل شد","2025-09-06 03:44:14","2025-09-06 07:14:14"),
("11616","4808","عملیات ایجاد شد","2025-09-06 03:44:14","2025-09-06 07:14:14"),
("11617","4809","عملیات ایجاد شد","2025-09-06 03:44:20","2025-09-06 07:14:20"),
("11618","4809","عملیات با Async Request شروع شد","2025-09-06 03:44:22","2025-09-06 07:14:22"),
("11619","4809","عملیات با Async Request تکمیل شد","2025-09-06 03:44:22","2025-09-06 07:14:22"),
("11620","4810","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11621","4811","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11622","4812","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11623","4813","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11624","4814","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11625","4815","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11626","4816","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11627","4817","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11628","4810","عملیات با Async Request شروع شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11629","4810","عملیات با Async Request تکمیل شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11630","4817","عملیات با Async Request شروع شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11631","4818","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11632","4819","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11633","4820","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11634","4821","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11635","4822","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11636","4823","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11637","4824","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11638","4825","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11639","4826","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11640","4827","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11641","4828","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11642","4829","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11643","4830","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11644","4831","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11645","4832","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11646","4817","عملیات با Async Request تکمیل شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11647","4833","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11648","4818","عملیات با Async Request شروع شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11649","4818","عملیات با Async Request تکمیل شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11650","4830","عملیات با Async Request شروع شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11651","4830","عملیات با Async Request تکمیل شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11652","4834","عملیات ایجاد شد","2025-09-06 04:08:55","2025-09-06 07:38:55"),
("11653","4811","عملیات با WP Cron شروع شد","2025-09-06 04:08:56","2025-09-06 07:38:56"),
("11654","4811","عملیات با WP Cron تکمیل شد","2025-09-06 04:08:56","2025-09-06 07:38:56"),
("11655","4816","عملیات با WP Cron شروع شد","2025-09-06 04:08:56","2025-09-06 07:38:56"),
("11656","4816","عملیات با WP Cron تکمیل شد","2025-09-06 04:08:56","2025-09-06 07:38:56"),
("11657","4820","عملیات با WP Cron شروع شد","2025-09-06 04:08:56","2025-09-06 07:38:56"),
("11658","4820","عملیات با WP Cron تکمیل شد","2025-09-06 04:08:56","2025-09-06 07:38:56"),
("11659","4812","عملیات با Async Request شروع شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11660","4812","عملیات با Async Request تکمیل شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11661","4822","عملیات با Async Request شروع شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11662","4822","عملیات با Async Request تکمیل شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11663","4813","عملیات با Async Request شروع شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11664","4813","عملیات با Async Request تکمیل شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11665","4824","عملیات با Async Request شروع شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11666","4824","عملیات با Async Request تکمیل شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11667","4814","عملیات با Async Request شروع شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11668","4814","عملیات با Async Request تکمیل شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11669","4826","عملیات با Async Request شروع شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11670","4826","عملیات با Async Request تکمیل شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11671","4815","عملیات با Async Request شروع شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11672","4815","عملیات با Async Request تکمیل شد","2025-09-06 04:09:01","2025-09-06 07:39:01"),
("11673","4823","عملیات با Async Request شروع شد","2025-09-06 04:09:06","2025-09-06 07:39:06"),
("11674","4823","عملیات با Async Request تکمیل شد","2025-09-06 04:09:06","2025-09-06 07:39:06"),
("11675","4835","عملیات ایجاد شد","2025-09-06 04:09:06","2025-09-06 07:39:06"),
("11676","4831","عملیات با Async Request شروع شد","2025-09-06 04:09:06","2025-09-06 07:39:06"),
("11677","4831","عملیات با Async Request تکمیل شد","2025-09-06 04:09:06","2025-09-06 07:39:06"),
("11678","4828","عملیات با WP Cron شروع شد","2025-09-06 04:10:00","2025-09-06 07:40:00"),
("11679","4828","عملیات با WP Cron تکمیل شد","2025-09-06 04:10:00","2025-09-06 07:40:00"),
("11680","4836","عملیات ایجاد شد","2025-09-06 04:10:00","2025-09-06 07:40:00");

INSERT IGNORE INTO `wp_commentmeta` VALUES 
("1","3","rating","4"),
("2","3","verified","0"),
("3","4","rating","5"),
("4","4","verified","0"),
("9","12","rating","5"),
("10","12","verified","0"),
("15","60","rating","5"),
("16","60","verified","1"),
("17","61","rating","5"),
("18","61","verified","1"),
("19","72","rating","5"),
("20","72","verified","0"),
("29","117","rating","5"),
("30","117","verified","1"),
("33","135","rating","5"),
("34","135","verified","1"),
("35","138","rating","3"),
("36","138","verified","1"),
("39","142","rating","2"),
("40","142","verified","0"),
("45","156","rating","5"),
("46","156","verified","0"),
("49","214","rating","5"),
("50","214","verified","1"),
("51","215","rating","1"),
("52","215","verified","1"),
("53","224","rating","1"),
("54","224","verified","1"),
("69","285","rating","4"),
("70","285","verified","1"),
("71","301","rating","4"),
("72","301","verified","0"),
("87","303","rating","5"),
("88","303","verified","0"),
("89","304","rating","4"),
("90","304","verified","1"),
("91","309","rating","5"),
("92","309","verified","0"),
("101","316","rating","5"),
("102","316","verified","0"),
("116","352","rating","5"),
("117","352","verified","1"),
("118","352","wallet_transaction_id","69"),
("121","368","rating","5"),
("122","368","verified","1"),
("123","368","wallet_transaction_id","317");

INSERT IGNORE INTO `wp_comments` VALUES 
("2","470","وردپرس","wapuu@wordpress.example","http://codebean.co/","","2018-04-20 18:50:26","2018-04-20 14:20:26","سلام، این یک دیدگاه میباشد.\r\nبرای شروع کار با نظارت، ویرایش و حذف نظرات، لطفا از صفحه نمایش نظرات در داشبورد دیدن کنید.\r\nCommenter avatars come from <a href=\"https://gravatar.com\" rel=\"nofollow ugc\">Gravatar</a>.","0","1","","comment","0","0"),
("3","77","استیون اسمیت","mkmfsco1@yahoo.com","","46.99.92.107","2018-06-14 09:34:16","2018-06-14 05:04:16","طراحی تاپ","0","1","","review","0","0"),
("4","77","مارگارت","mkmfsco1@yahoo.com","","46.99.92.107","2018-06-14 09:35:14","2018-06-14 05:05:14","آسان برای نصب، قیمت مناسب!","0","1","","review","0","0"),
("5","216","آنا","mkmfsco1@yahoo.com","","46.99.91.69","2018-06-14 11:22:05","2018-06-14 06:52:05","مشاهده مسائل مربوط به محصول خود را از طریق چشم کاربران خود برای ایجاد UX قوی بسیار مهم است.","0","1","","comment","0","0"),
("6","224","مارسی واشنگتن","mkmfsco1@yahoo.com","","46.99.92.107","2018-06-14 10:04:50","2018-06-14 05:34:50","خیلی چیزها راجع به ماسک ها نیز یاد گرفتید. با تشکر از شما برای به اشتراک گذاری.","0","1","","comment","0","0"),
("7","224","کالب تورس","endrithajrizi96@gmail.com","","46.99.92.107","2018-06-14 10:05:46","2018-06-14 05:35:46","نتیجه خوبی Caroline! خوشحالم که از آن لذت بردم","0","1","","comment","6","0"),
("8","224","مارسی واشنگتن","mkmfsco1@yahoo.com","","46.99.92.107","2018-06-14 10:06:18","2018-06-14 05:36:18","این خیلی عالی بود، تشکر کالب","0","1","","comment","7","0"),
("9","224","آندره","endrit.hajrizi1@gmail.com","","46.99.91.69","2018-06-14 11:21:03","2018-06-14 06:51:03","مقاله بزرگ من فکر می کنم که شرکت ها قوی ترین طرفدار های کاربر را ایجاد می کنند زمانی که طراحان و برنامه نویسان ارزش ارزش تجربه کاربر را درک می کنند.","0","1","","comment","0","0"),
("12","86","شوان برگ","endrithajrizi96@gmail.com","","46.99.92.107","2018-06-14 09:37:24","2018-06-14 05:07:24","واقعا دیزاینر حرفه ای هست<strong>این دوره رو پیشنهاد می کنم.</strong>","0","1","","review","0","0"),
("60","68","سان کد","bagher.pebs@yahoo.com","","151.235.107.112","2018-10-12 10:23:23","2018-10-12 06:53:23","این دیدگاه آزمایشی می باشد :)","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36","review","0","1"),
("61","77","سان کد","bagher.pebs@yahoo.com","","151.235.109.232","2018-10-12 20:48:26","2018-10-12 17:18:26","این یک دیدگاه آزمایشی از خریدار دوره می باشد","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36","review","0","1"),
("72","64","zgroup","aminpc23@gmail.com","","37.254.57.62","2018-11-08 15:55:34","2018-11-08 12:25:34",".","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:63.0) Gecko/20100101 Firefox/63.0","review","0","24"),
("117","77","demo","demo@demo.com","","94.183.161.147","2018-12-19 21:06:21","2018-12-19 17:36:21","خوب","0","1","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:64.0) Gecko/20100101 Firefox/64.0","review","0","2"),
("135","75","kaseb","peymanpourkhaleghi@gmail.com","","5.119.13.172","2019-01-28 15:24:49","2019-01-28 11:54:49","تست نظر","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36","review","0","57"),
("138","75","2222","Ad@aa.com","","185.239.173.108","2019-01-30 15:47:42","2019-01-30 12:17:42","عالی","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36","review","0","58"),
("142","75","cbc","cb@gmail.com","","5.117.111.164","2019-02-27 15:07:41","2019-02-27 11:37:41","b","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:65.0) Gecko/20100101 Firefox/65.0","review","0","0"),
("156","77","یاشار","asjdaks@lajda.com","","5.78.246.46","2019-04-06 09:48:10","2019-04-06 05:18:10","خیلی عالی بود","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36","review","0","0"),
("214","77","سان کد","bagher.pebs@yahoo.com","","5.134.138.229","2019-06-17 02:19:09","2019-06-16 21:49:09","تست پاسخ!","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36","review","4","1"),
("215","77","سان کد","bagher.pebs@yahoo.com","","5.134.138.229","2019-06-17 02:20:02","2019-06-16 21:50:02","تست دیدگاه!","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36","review","4","1"),
("224","64","سان کد","bagher.pebs@yahoo.com","","5.134.167.126","2019-06-24 22:06:17","2019-06-24 17:36:17","کیفیت آموزش پایین!","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.100 Safari/537.36","review","0","1"),
("278","470","سان کد","bagher.pebs@yahoo.com","","5.134.128.202","2019-10-12 22:04:47","2019-10-12 18:34:47","این یک پاسخ به دیدگاه شما می باشد.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","comment","2","1"),
("279","470","سان کد","bagher.pebs@yahoo.com","","5.134.128.202","2019-10-12 22:05:14","2019-10-12 18:35:14","این یک دیدگاه جدید می باشد","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","comment","0","1"),
("280","470","سان کد","bagher.pebs@yahoo.com","","5.134.128.202","2019-10-12 22:09:47","2019-10-12 18:39:47","این دومین پاسخ است!","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","comment","2","1"),
("285","82","سان کد","bagher.pebs@yahoo.com","","5.134.156.137","2019-10-27 01:45:05","2019-10-26 22:15:05","من از این دوره راضی هستم.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","review","0","1"),
("301","1172","سان کد","bagher.pebs@yahoo.com","","5.62.220.172","2020-03-30 12:15:13","2020-03-30 07:45:13","کتاب خوبی است. پیشنهاد می کنم مطالعه کنید✔","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","review","0","1"),
("303","1387","سان کد","bagher.pebs@yahoo.com","","37.137.234.169","2020-04-02 15:04:54","2020-04-02 10:34:54","این کتاب فوق العاده است :)","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.162 Safari/537.36","review","0","1"),
("304","73","سان کد","bagher.pebs@yahoo.com","","94.24.102.232","2020-04-04 17:43:16","2020-04-04 13:13:16","این یک دیدگاه برای بررسی بخش دیدگاه های دوره می باشد","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","review","0","1"),
("309","951","تیم طراحی سان کد","bagher.pebs@yahoo.com","","193.176.84.3","2020-08-15 09:37:35","2020-08-15 05:07:35","قالب Studiare پوسته وردپرس حرفه ای جهت راه اندازی وبسایت آموزشی و فروش دوره های آنلاین می باشد. صفحات قالب استادیار و همچنین محتوای دوره ها با افزونه WP Bakery طراحی شده است و برای ساخت اسلایدها نیز از افزونه رولوشن اسلایدر استفاده شده است.","0","pending","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36","review","0","1"),
("316","951","تیم طراحی سان کد","bagher.pebs@yahoo.com","","5.202.219.76","2020-10-29 19:46:18","2020-10-29 16:16:18","قالب Studiare پوسته وردپرس حرفه ای جهت راه اندازی وبسایت آموزشی و فروش دوره های آنلاین می باشد.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.111 Safari/537.36","review","0","1"),
("339","224","m.a021361","m.a021361@gmail.com","","46.209.153.226","2021-05-12 12:43:10","2021-05-12 08:13:10","عالی بود","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36","comment","0","144"),
("352","1391","تیم طراحی سان کد","bagher.pebs@yahoo.com","","185.134.22.23","2022-01-09 22:02:11","2022-01-09 18:32:11","مطالعه این کتاب را به همه پیشنهاد می کنم.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36","review","0","1"),
("368","75","تیم طراحی سان کد","bagher.pebs@yahoo.com","","83.123.28.38","2023-04-14 16:18:27","2023-04-14 11:48:27","این دیدگاه آزمایشی است.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36","review","0","1"),
("372","125","تیم طراحی سان کد","bagher.pebs@yahoo.com","","185.100.45.3","2023-07-23 10:02:06","2023-07-23 05:32:06","آقای زمانی یکی از بهترین مدرسین مجموعه استادیار هستند.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36","comment","0","1");

INSERT IGNORE INTO `wp_duplicator_activity_logs` VALUES 
("1","websites_scan","scan_start","10","اسکن","{\n    \"packageId\": 43,\n    \"packageName\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/api\",\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/lab\",\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/package\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/0error_log\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/1error_log\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/0studiare-core\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core(14030317).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core.zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0000studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/000studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/00studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-03).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-08).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-18-not-encoded).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14020809).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021121).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021125).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021130).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-1).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-2).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-3).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-4).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202-2).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021203).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021205).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030306).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030317).zip\"\n    ],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0\n}","0","4.5.22.4","2025-09-06 04:16:58","2025-09-06 04:16:58"),
("2","websites_scan","scan_end","10","اسکن تکمیل شد","{\n    \"packageId\": 43,\n    \"packageName\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/api\",\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/lab\",\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/package\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/0error_log\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/1error_log\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/0studiare-core\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core(14030317).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core.zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0000studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/000studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/00studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-03).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-08).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-18-not-encoded).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14020809).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021121).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021125).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021130).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-1).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-2).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-3).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-4).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202-2).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021203).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021205).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030306).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030317).zip\"\n    ],\n    \"fileCount\": 25214,\n    \"dirCount\": 4049,\n    \"size\": 478633153\n}","1","4.5.22.4","2025-09-06 04:16:59","2025-09-06 04:16:59"),
("3","backup_create","start","10","ایجاد بک‌آپ: 20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8","{\n    \"packageId\": 44,\n    \"packageName\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/api\",\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/lab\",\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/package\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/0error_log\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/1error_log\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/0studiare-core\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core(14030317).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core.zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0000studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/000studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/00studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-03).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-08).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-18-not-encoded).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14020809).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021121).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021125).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021130).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-1).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-2).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-3).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-4).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202-2).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021203).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021205).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030306).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030317).zip\"\n    ],\n    \"fileCount\": 25214,\n    \"dirCount\": 4049,\n    \"size\": 478633153,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"\\u0628\\u0627\\u06cc\\u06af\\u0627\\u0646\\u06cc \\u0632\\u06cc\\u067e\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","0","4.5.22.4","2025-09-06 04:17:08","2025-09-06 04:17:08"),
("4","backup_create","db_dump","10","ایجاد بک‌آپ: 20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8 - دامپ دیتابیس","{\n    \"packageId\": 44,\n    \"packageName\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/api\",\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/lab\",\n        \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/package\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/0error_log\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/1error_log\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/0studiare-core\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core(14030317).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core.zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0000studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/000studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/00studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0studiare\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-03).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-08).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-18-not-encoded).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14020809).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021121).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021125).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021130).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-1).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-2).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-3).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-4).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202-2).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021203).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021205).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030306).zip\",\n        \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030317).zip\"\n    ],\n    \"fileCount\": 25214,\n    \"dirCount\": 4049,\n    \"size\": 478633153,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"\\u0628\\u0627\\u06cc\\u06af\\u0627\\u0646\\u06cc \\u0632\\u06cc\\u067e\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","3","4.5.22.4","2025-09-06 04:17:08","2025-09-06 04:17:08");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("43","20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8","eb11807476ed57829862_20250906041656","5","2025-09-06 04:16:56","","{\n    \"ID\": 43,\n    \"VersionWP\": \"6.8.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8\",\n    \"hash\": \"eb11807476ed57829862_20250906041656\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8_eb11807476ed57829862_20250906041656_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"\\u0627\\u0633\\u062a\\u0627\\u062f\\u06cc\\u0627\\u0631\",\n    \"Brand_ID\": 6,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/api;\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/lab;\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/package;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/0error_log;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/1error_log;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/0studiare-core;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core(14030317).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core.zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0000studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/000studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/00studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-03).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-08).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-18-not-encoded).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14020809).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021121).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021125).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021130).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-1).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-2).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-3).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-4).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202-2).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021203).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021205).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030306).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030317).zip\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.opcache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.tmb\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/bps-backup\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/cache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/old-cache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/updraft\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wfcache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.htaccess\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.user.ini\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/php.ini\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/web.config\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-config.php\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8_eb11807476ed57829862_20250906041656_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/\",\n        \"Size\": 478633153,\n        \"Dirs\": [],\n        \"DirCount\": 4049,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 25214,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 235397158,\n                        \"bytes\": \"224.49MB\",\n                        \"nodes\": 19801,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 148812187,\n                        \"bytes\": \"141.92MB\",\n                        \"nodes\": 5296,\n                        \"name\": \"uploads\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/uploads\"\n                    },\n                    {\n                        \"ubytes\": 418289272,\n                        \"bytes\": \"398.91MB\",\n                        \"nodes\": 26171,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-snapshots\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.opcache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.tmb\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/old-cache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/updraft\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wfcache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/cache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.htaccess\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.user.ini\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/php.ini\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/web.config\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/debug.log\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy <span class=\\\"size\\\" >456.46MB<\\/span> <span class=\\\"nodes\\\" >29263<\\/span>\",\n                \"fullPath\": \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >398.91MB<\\/span> <span class=\\\"nodes\\\" >26171<\\/span>\",\n                        \"fullPath\": \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >224.49MB<\\/span> <span class=\\\"nodes\\\" >19801<\\/span>\",\n                                \"fullPath\": \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": true,\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"uploads <span class=\\\"size\\\" >141.92MB<\\/span> <span class=\\\"nodes\\\" >5296<\\/span>\",\n                                \"fullPath\": \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": true,\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"\\u067e\\u0648\\u0634\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0627\\u0635\\u0644\\u06cc \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633 \\u0646\\u0628\\u0627\\u06cc\\u062f \\u0641\\u06cc\\u0644\\u062a\\u0631 \\u0634\\u0648\\u0646\\u062f. \\u062f\\u0631 \\u062d\\u0630\\u0641 \\u0641\\u0627\\u06cc\\u0644\\u200c\\u0647\\u0627 \\u0627\\u062d\\u062a\\u06cc\\u0627\\u0637 \\u06a9\\u0646\\u06cc\\u062f.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8_eb11807476ed57829862_20250906041656_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"zuAA9fycXcqdQvasth7o6QEZXpBx0vraRzO4BroqjMyvAPV2xtweL6mMJYfWpjYEfV5ghwX4pLB\\/J\\/dN5AFgDg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\",\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"studiar1_demos_academy\",\n            \"tablesBaseCount\": 86,\n            \"tablesFinalCount\": 86,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 16732,\n            \"tablesSizeOnDisk\": 27111725,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"73\",\n                    \"insertedRows\": 0,\n                    \"size\": 191676\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 0,\n                    \"size\": 9588\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"195\",\n                    \"insertedRows\": 0,\n                    \"size\": 262160\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"46\",\n                    \"insertedRows\": 0,\n                    \"size\": 11928\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 0,\n                    \"size\": 16856\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 33400\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 33176\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_e_submissions\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 34284\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 11952\n                },\n                \"wp_e_submissions_values\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 0,\n                    \"size\": 7184\n                },\n                \"wp_em_bookings\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_em_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_em_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_em_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_em_tickets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_em_tickets_bookings\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"2023\",\n                    \"insertedRows\": 0,\n                    \"size\": 2697568\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"11420\",\n                    \"insertedRows\": 0,\n                    \"size\": 10026124\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"871\",\n                    \"insertedRows\": 0,\n                    \"size\": 11111184\n                },\n                \"wp_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 100272\n                },\n                \"wp_revslider_css_bkp\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 95152\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_layer_animations_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations_bkp\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 2424\n                },\n                \"wp_revslider_sliders\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 73864\n                },\n                \"wp_revslider_sliders7\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_revslider_sliders_bkp\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 13160\n                },\n                \"wp_revslider_slides\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 233684\n                },\n                \"wp_revslider_slides7\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 311296\n                },\n                \"wp_revslider_slides_bkp\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 141108\n                },\n                \"wp_revslider_static_slides\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 3996\n                },\n                \"wp_revslider_static_slides_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_rtl_rsm_logs\": {\n                    \"inaccurateRows\": \"321\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_sc_notifications_views\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 2371\n                },\n                \"wp_studiare_quiz_attempts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_studiare_quiz_results\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"295\",\n                    \"insertedRows\": 0,\n                    \"size\": 21555\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 0,\n                    \"size\": 50736\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"117\",\n                    \"insertedRows\": 0,\n                    \"size\": 20140\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 0,\n                    \"size\": 19728\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"145\",\n                    \"insertedRows\": 0,\n                    \"size\": 39312\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 8348\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 0,\n                    \"size\": 7372\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 12732\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 2201\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 6476\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 4816\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 0,\n                    \"size\": 8736\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 11796\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 12616\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 9496\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woo_wallet_transaction_meta\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woo_wallet_transactions\": {\n                    \"inaccurateRows\": \"510\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_ir\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 178412\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8_eb11807476ed57829862_20250906041656_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"progressPercent\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 7,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-06 04:16:56\",\n    \"updated\": \"2025-09-06 04:16:59\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 0\n}","20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8_eb11807476ed57829862_20250906041656_archive.zip","0","MANUAL,ZIP_ARCHIVE,TEMPORARY","4.5.22.4","2025-09-06 04:16:59","Standard"),
("44","20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8","eb11807476ed57829862_20250906041656","20","2025-09-06 04:16:56","","{\n    \"ID\": 44,\n    \"VersionWP\": \"6.8.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8\",\n    \"hash\": \"eb11807476ed57829862_20250906041656\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8_eb11807476ed57829862_20250906041656_scan.json\",\n    \"timer_start\": 1757132228.106473,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"\\u0627\\u0633\\u062a\\u0627\\u062f\\u06cc\\u0627\\u0631\",\n    \"Brand_ID\": 6,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/api;\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/lab;\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/package;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/0error_log;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/1error_log;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/0studiare-core;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core(14030317).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core.zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0000studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/000studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/00studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-03).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-08).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-18-not-encoded).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14020809).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021121).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021125).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021130).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-1).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-2).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-3).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-4).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202-2).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021203).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021205).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030306).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030317).zip\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.opcache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.tmb\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/bps-backup\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/cache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/old-cache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/updraft\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wfcache\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.htaccess\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.user.ini\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/php.ini\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/web.config\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-config.php\",\n            \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8_eb11807476ed57829862_20250906041656_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/\",\n        \"Size\": 478633153,\n        \"Dirs\": [],\n        \"DirCount\": 4049,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 25214,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 235397158,\n                        \"bytes\": \"224.49MB\",\n                        \"nodes\": 19801,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 148812187,\n                        \"bytes\": \"141.92MB\",\n                        \"nodes\": 5296,\n                        \"name\": \"uploads\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/uploads\"\n                    },\n                    {\n                        \"ubytes\": 418289272,\n                        \"bytes\": \"398.91MB\",\n                        \"nodes\": 26171,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-snapshots\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.opcache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.tmb\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/old-cache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/updraft\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/wfcache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/cache\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.htaccess\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/.user.ini\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/php.ini\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/web.config\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/debug.log\",\n                    \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8_eb11807476ed57829862_20250906041656_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"xep5bRmGZmAOK7IzAdEGFblzTwtJkLUE1iAcokRHcVnZkusK8Si1tYEybzqddbbqOEcBeZ4O3wFB+q2ChPU71A==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\",\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"studiar1_demos_academy\",\n            \"tablesBaseCount\": 86,\n            \"tablesFinalCount\": 86,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 16732,\n            \"tablesSizeOnDisk\": 27111725,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"73\",\n                    \"insertedRows\": 0,\n                    \"size\": 191676\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 0,\n                    \"size\": 9588\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"195\",\n                    \"insertedRows\": 0,\n                    \"size\": 262160\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"46\",\n                    \"insertedRows\": 0,\n                    \"size\": 11928\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 0,\n                    \"size\": 16856\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 33400\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 33176\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_e_submissions\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 34284\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 11952\n                },\n                \"wp_e_submissions_values\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 0,\n                    \"size\": 7184\n                },\n                \"wp_em_bookings\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_em_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_em_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_em_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_em_tickets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_em_tickets_bookings\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"2023\",\n                    \"insertedRows\": 0,\n                    \"size\": 2697568\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"11420\",\n                    \"insertedRows\": 0,\n                    \"size\": 10026124\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"871\",\n                    \"insertedRows\": 0,\n                    \"size\": 11111184\n                },\n                \"wp_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 100272\n                },\n                \"wp_revslider_css_bkp\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 95152\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_layer_animations_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations_bkp\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 2424\n                },\n                \"wp_revslider_sliders\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 73864\n                },\n                \"wp_revslider_sliders7\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_revslider_sliders_bkp\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 13160\n                },\n                \"wp_revslider_slides\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 233684\n                },\n                \"wp_revslider_slides7\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 311296\n                },\n                \"wp_revslider_slides_bkp\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 141108\n                },\n                \"wp_revslider_static_slides\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 3996\n                },\n                \"wp_revslider_static_slides_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_rtl_rsm_logs\": {\n                    \"inaccurateRows\": \"321\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_sc_notifications_views\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 2371\n                },\n                \"wp_studiare_quiz_attempts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_studiare_quiz_results\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"295\",\n                    \"insertedRows\": 0,\n                    \"size\": 21555\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 0,\n                    \"size\": 50736\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"117\",\n                    \"insertedRows\": 0,\n                    \"size\": 20140\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 0,\n                    \"size\": 19728\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"145\",\n                    \"insertedRows\": 0,\n                    \"size\": 39312\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 8348\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 0,\n                    \"size\": 7372\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 12732\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 2201\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 6476\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 4816\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 0,\n                    \"size\": 8736\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 11796\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 12616\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 9496\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woo_wallet_transaction_meta\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woo_wallet_transactions\": {\n                    \"inaccurateRows\": \"510\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_ir\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 178412\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8_eb11807476ed57829862_20250906041656_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/backups-dup-pro\\/tmp\\/20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8_eb11807476ed57829862_20250906041656_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"progressPercent\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1757132229,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_actionscheduler_actions\",\n            \"wp_actionscheduler_claims\",\n            \"wp_actionscheduler_groups\",\n            \"wp_actionscheduler_logs\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_activity_logs\",\n            \"wp_duplicator_backups\",\n            \"wp_duplicator_entities\",\n            \"wp_e_events\",\n            \"wp_e_notes\",\n            \"wp_e_notes_users_relations\",\n            \"wp_e_submissions\",\n            \"wp_e_submissions_actions_log\",\n            \"wp_e_submissions_values\",\n            \"wp_em_bookings\",\n            \"wp_em_events\",\n            \"wp_em_locations\",\n            \"wp_em_meta\",\n            \"wp_em_tickets\",\n            \"wp_em_tickets_bookings\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_revslider_css\",\n            \"wp_revslider_css_bkp\",\n            \"wp_revslider_layer_animations\",\n            \"wp_revslider_layer_animations_bkp\",\n            \"wp_revslider_navigations\",\n            \"wp_revslider_navigations_bkp\",\n            \"wp_revslider_sliders\",\n            \"wp_revslider_sliders7\",\n            \"wp_revslider_sliders_bkp\",\n            \"wp_revslider_slides\",\n            \"wp_revslider_slides7\",\n            \"wp_revslider_slides_bkp\",\n            \"wp_revslider_static_slides\",\n            \"wp_revslider_static_slides_bkp\",\n            \"wp_rtl_rsm_logs\",\n            \"wp_sc_notifications_views\",\n            \"wp_studiare_quiz_attempts\",\n            \"wp_studiare_quiz_results\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_wc_admin_note_actions\",\n            \"wp_wc_admin_notes\",\n            \"wp_wc_category_lookup\",\n            \"wp_wc_customer_lookup\",\n            \"wp_wc_download_log\",\n            \"wp_wc_order_addresses\",\n            \"wp_wc_order_coupon_lookup\",\n            \"wp_wc_order_operational_data\",\n            \"wp_wc_order_product_lookup\",\n            \"wp_wc_order_stats\",\n            \"wp_wc_order_tax_lookup\",\n            \"wp_wc_orders\",\n            \"wp_wc_orders_meta\",\n            \"wp_wc_product_attributes_lookup\",\n            \"wp_wc_product_download_directories\",\n            \"wp_wc_product_meta_lookup\",\n            \"wp_wc_rate_limits\",\n            \"wp_wc_reserved_stock\",\n            \"wp_wc_tax_rate_classes\",\n            \"wp_wc_webhooks\",\n            \"wp_woo_wallet_transaction_meta\",\n            \"wp_woo_wallet_transactions\",\n            \"wp_woocommerce_api_keys\",\n            \"wp_woocommerce_attribute_taxonomies\",\n            \"wp_woocommerce_downloadable_product_permissions\",\n            \"wp_woocommerce_ir\",\n            \"wp_woocommerce_log\",\n            \"wp_woocommerce_order_itemmeta\",\n            \"wp_woocommerce_order_items\",\n            \"wp_woocommerce_payment_tokenmeta\",\n            \"wp_woocommerce_payment_tokens\",\n            \"wp_woocommerce_sessions\",\n            \"wp_woocommerce_shipping_zone_locations\",\n            \"wp_woocommerce_shipping_zone_methods\",\n            \"wp_woocommerce_shipping_zones\",\n            \"wp_woocommerce_tax_rate_locations\",\n            \"wp_woocommerce_tax_rates\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1757132228.11271,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 16732,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_notes_users_relations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_em_bookings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_em_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_em_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_em_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_em_tickets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_em_tickets_bookings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_css_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_layer_animations_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_navigations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_navigations_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_sliders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_sliders7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_sliders_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_slides7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_slides_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_static_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_static_slides_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rtl_rsm_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_sc_notifications_views\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_studiare_quiz_attempts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_studiare_quiz_results\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woo_wallet_transaction_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woo_wallet_transactions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_ir\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 7,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2025-09-06 04:16:56\",\n    \"updated\": \"2025-09-06 04:17:09\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 3\n}","20250906_d982d8a7d984d8a8d8a7d8b3d8aad8a7d8afdb8_eb11807476ed57829862_20250906041656_archive.zip","0","MANUAL,ZIP_ARCHIVE","4.5.22.4","2025-09-06 04:17:09","Standard");

INSERT IGNORE INTO `wp_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"bagher.pebs@yahoo.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": null,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 6,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 18,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"bagher.pebs@yahoo.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/demo.suncode.ir\\/studiare6\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        7\n    ],\n    \"license_key_visible\": 0,\n    \"lkp\": \"\",\n    \"last_system_check_timestamp\": 1691299647,\n    \"initial_activation_timestamp\": 1585830143,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-09-06 04:16:56\"\n}","","","","","","4.5.22.4","0000-00-00 00:00:00","2025-09-06 04:16:56"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-09-06 04:07:57\"\n}","","","","","","4.5.22.4","0000-00-00 00:00:00","2025-09-06 04:07:57"),
("3","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1757132227,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-09-06 04:17:07\"\n}","","","","","","4.5.22.4","0000-00-00 00:00:00","2025-09-06 04:17:07"),
("4","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": null,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"Vqg+OfyIzEpLtZv48shvFKqVxdsuoSxdKOJIrQ7E0RRNzpzAt5IEeqH1MOymYe+kVXOYiJILN4fmy0gA1PMBDg==\",\n    \"installer_opts_skip_scan\": null,\n    \"installer_opts_db_host\": null,\n    \"installer_opts_db_name\": null,\n    \"installer_opts_db_user\": null,\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 4\n}","","","","","","","0000-00-00 00:00:00","2024-01-17 23:38:43"),
("5","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/api;\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/lab;\\/home\\/demosuncod\\/domains\\/demo.suncode.ir\\/public_html\\/studiare6\\/package;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/0error_log;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/1error_log;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/0studiare-core;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core(14030317).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/plugins\\/studiare-core.zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0000studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/000studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/00studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/0studiare;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-03).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-08).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(1402-12-18-not-encoded).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14020809).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021121).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021125).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021130).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-1).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-2).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-3).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021201-4).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021202-2).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021203).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14021205).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030306).zip;\\/home\\/studiar1\\/demo.studiaretheme.ir\\/academy\\/wp-content\\/themes\\/studiare(14030317).zip\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"j6dyXUt6IkAbx8geY6COOu7HJyZnnTUo7+7ILxP69Vr4fQ66MboVm8Vc+gZ6LWY8HpHWdF+gPqDU10NMyv0WOQ==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": 6,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-09-06 04:16:56\"\n}","","","","","","4.5.22.4","0000-00-00 00:00:00","2025-09-06 04:16:56"),
("6","DUP_PRO_Brand_Entity","{\n    \"name\": \"\\u0627\\u0633\\u062a\\u0627\\u062f\\u06cc\\u0627\\u0631\",\n    \"notes\": \"\",\n    \"editable\": true,\n    \"logo\": \"<img src=\\\"https:\\/\\/sunthemes.ir\\/images\\/studiare.png\\\" alt=\\\"\\u0642\\u0627\\u0644\\u0628 \\u0627\\u0633\\u062a\\u0627\\u062f\\u06cc\\u0627\\u0631\\\" style=\\\" max-height: 60px; \\\"><i class=\\\"fa fa-bolt fa-sm\\\"><\\/i> \\u0628\\u0633\\u062a\\u0647 \\u0646\\u0635\\u0628\\u06cc \\u062f\\u0645\\u0648\\u06cc \\u0622\\u06a9\\u0627\\u062f\\u0645\\u06cc (18 \\u0635\\u0641\\u062d\\u0647 \\u0627\\u0635\\u0644\\u06cc) \\u0642\\u0627\\u0644\\u0628 \\u0627\\u0633\\u062a\\u0627\\u062f\\u06cc\\u0627\\u0631 | \\u0633\\u0627\\u0646 \\u06a9\\u062f<img src=\\\"https:\\/\\/sunthemes.ir\\/images\\/logo.png\\\" alt=\\\"\\u0633\\u0627\\u0646 \\u06a9\\u062f\\\" \\/>\",\n    \"attachments\": [\n        \"\",\n        \"\",\n        \"\",\n        \"\"\n    ],\n    \"default\": false,\n    \"brandMode\": 1,\n    \"active\": false,\n    \"style\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-09-06 04:16:50\"\n}","","","","","","4.5.22.4","0000-00-00 00:00:00","2025-09-06 04:16:50"),
("7","DUP_PRO_Storage_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"7Peqnv2bBqiR209Y3im8liTpp1CUczjpXyCUhZzZp78LTY50EiLPWBsMNXzMvH3SBXvQtv9t\\/gs8ZzBVgNCeaztsbqqs3AIUzMyRl4trFptCdv2LgW9gaRRaiZDN6NZ6ByIRsxs3DjxAC4YBLR8QKdICxTSrstgqBa6iiz+W1pT9JFevwEdt2ACvPb5ZFPhj9pzQUL+EV3\\/RT29MTyAwchWj521sp6pWvfCf3p32z0B1fftpBnwlurzKXBAwhFHc+haaTZsTzMghOH0HYW390Q==\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2024-01-17 20:08:44\",\n    \"updated\": \"2025-09-06 04:07:57\"\n}","","","","","","4.5.22.4","2024-01-17 20:08:44","2025-09-06 04:07:57"),
("8","EmailSummary","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"id\": 8,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.21.2\",\n    \"created\": \"\",\n    \"updated\": \"2025-09-06 03:46:30\"\n}","","","","","","4.5.21.2","0000-00-00 00:00:00","2025-09-06 03:46:30"),
("9","Dynamic_Entity","{\n    \"data\": \"QKUJZdsLhrvZ15\\/SZ6IW3+whzLO\\/+rhvekGdjISaT96sODC6EIrDuu2X2v6SAhSgoV8QYdFZ7xnk380WP7jlW8bKGEVt2w42fgxO0Fdfz825dLPWEvKhCM+juHgzDZHv6rXAPwlRGq\\/1LZnFWDptscYAZWMee2d4eZ7adUYvGB5IgGbil0kLncplp6xWcOlRsSwi3UJVaqphUc73xg3ftdh3b724Bzr6UPQqjOBt8uD1rBi1qcm+Xu+ezn8SauDTHuIeyo57AXN4f64\\/WhiSp6FfEGHRWe8Z5N\\/NFj+45VtcmLGH2Kr1AWblKwcdiC9QrRZ72sH9GNFM2n6+GdUiJxRiMi4qzbjE5+\\/pxApEWhSYQLvG2p7V5I9t7DdnTLYqorHPHqKQY3K22zkHhvZ5YZBuV3kQ60xWJkza1emm3S8sS4lC6xTtUw==\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 9,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2024-11-04 06:03:35\",\n    \"updated\": \"2025-09-06 04:07:57\",\n    \"dataIsEncrypted\": true\n}","","","","","","4.5.22.4","2024-11-04 06:03:35","2025-09-06 04:07:57"),
("10","LicenseDataEntity","{\n    \"licenseKey\": \"s+BSOQr270tnaAiTYuvRyAhDlyw5pNNTYfNsTWc+7hSig59edtM1cKAs7FBOmMnD8hrGRSz\\/+4\\/vBNp7BeNDpA==\",\n    \"status\": \"3zGdwYNiz4ssaKoUXRTxwW7es9FmweoS4cegLHqn8i1R+3P1n3nn2toAUyeJoDIou5WQrDmj1W6RcU9953Xo2OE3xRXMsF+A\",\n    \"type\": \"5fKTvh6S9UBTnNpyivohdv+DByHH10Q5amuo2zRVnkbvSOcxYX0Z3vuNwat+fgyOgO1Jom9iWjyAjbh53hSfQigYTfX3qVfx\",\n    \"data\": \"EaiKQKkyhKq762kIxtXDFfXiTmdTgdNxHhE1eBOP+32CaZilVz77p+WcLehlaCDpKCKnuWMJI9Fe60NKXAK0LsSwAzYyFS12Pl04t+MGColDyjmp\\/RKrEsMb9MeTiUDpLVwpJ7DZvQ21Ebk0PLuAX1Rr4uk2uWSeltWhvbXrW1F3djIQ5KQq9PVoParQIgMeRws69kljGKU8RJnPGmNHGS+gjrIJJgVvJlh3V31w42v87p7L0op5UCgip7ljCSPRIpqBfHTt8kYs+vJl2wGHPp09jNKDv1RzB9GFVUe5vrfO75ZBjqFTwsyk0cAafRfWuRQQrJzhwMbVi4QqOe2WToL367VtVcXJ0o1nTTBwgbGgrU\\/GgUo+1u2sCQTMcw4pqQJ\\/0xWHHm19qA4BPqWAKrodaOiiG3nze55DEjmyHfA=\",\n    \"lastRemoteUpdate\": \"\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 10,\n    \"version\": \"4.5.22.4\",\n    \"created\": \"2024-11-04 06:03:35\",\n    \"updated\": \"2025-09-06 04:17:09\"\n}","","","","","","4.5.22.4","2024-11-04 06:03:35","2025-09-06 04:17:09");

INSERT IGNORE INTO `wp_e_submissions` VALUES 
("1","submission","428ae1cc-e02b-45ba-a8d1-a442699435f4","1","3271","https://demo.studiaretheme.ir/academy/el-home-02/?footer_id=3271","خانه 2 – المنتور","1e48b6a9","New Form","0","1","5.202.218.13","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.81 Safari/537.36","1","0","new","0","{\"edit_post_id\":\"3271\"}","2021-10-24 06:40:18","2021-10-24 06:40:18","2021-10-24 10:10:18","2021-10-24 10:10:18"),
("2","submission","70afbe24-1f3b-4fed-ba5c-7b0898f83a40","3","2900","https://demo.studiaretheme.ir/academy/contact-us-elementor/","تماس با ما","70b502c","New Form","0","1","95.162.221.237","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36","1","0","new","0","{\"edit_post_id\":\"2900\"}","2021-11-07 18:40:34","2021-11-07 18:40:34","2021-11-07 22:10:34","2021-11-07 22:10:34"),
("3","submission","18655159-7b1d-495b-9a3f-daaad9f4982f","6","125","https://demo.studiaretheme.ir/academy/teacher/mehrdad-zamani/","مهرداد زمانی","a84b2ca","فرم جدید","0","1","95.162.149.200","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.110 Safari/537.36","1","0","new","0","{\"edit_post_id\":\"125\"}","2021-12-17 06:43:10","2021-12-17 06:43:10","2021-12-17 10:13:10","2021-12-17 10:13:10"),
("4","submission","cc93e865-cda2-48de-b069-afcd0304d66c","11","2780","https://demo.studiaretheme.ir/academy/contact-us-elementor/","","9523ba7","New Form","0","1","5.202.26.203","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36","1","1","new","0","{\"edit_post_id\":\"2780\"}","2024-11-02 19:40:41","2024-11-02 19:40:42","2024-11-02 23:10:41","2024-11-02 23:10:42"),
("5","submission","a0f7db29-f60b-4e1b-86a2-7d5af5c1577a","14","2900","https://demo.studiaretheme.ir/academy/contact-us-elementor/","تماس با ما","bf99fc5","New Form","0","1","5.202.26.203","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36","1","1","new","0","{\"edit_post_id\":\"2900\"}","2024-11-02 19:40:49","2024-11-02 19:40:49","2024-11-02 23:10:49","2024-11-02 23:10:49"),
("6","submission","8cfb646b-d260-41eb-8a37-65f559012d57","21","2780","https://demo.studiaretheme.ir/academy/product/studiare-properties/","","32b62a5","New Form","0","1","5.202.26.203","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36","1","1","new","0","{\"edit_post_id\":\"2780\"}","2024-11-02 20:30:35","2024-11-02 20:30:35","2024-11-03 00:00:35","2024-11-03 00:00:35"),
("7","submission","4b120f7a-0273-4fa1-b22b-114a90df6c1d","26","2780","https://demo.studiaretheme.ir/academy/#scfeatures","","32b62a5","New Form","0","1","193.24.121.166","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36","1","0","new","0","{\"edit_post_id\":\"2780\"}","2025-04-28 18:49:40","2025-04-28 18:49:40","2025-04-28 22:19:40","2025-04-28 22:19:40");

INSERT IGNORE INTO `wp_e_submissions_actions_log` VALUES 
("1","1","email","Email","failed","Server error. Form not sent.","2021-10-24 06:40:18","2021-10-24 06:40:18","2021-10-24 10:10:18","2021-10-24 10:10:18"),
("2","2","email","ایمیل","failed","خطای سرور. فرم ارسال نشده است.","2021-11-07 18:40:34","2021-11-07 18:40:34","2021-11-07 22:10:34","2021-11-07 22:10:34"),
("3","3","email","ایمیل","failed","خطای سرور. فرم ارسال نشده است.","2021-12-17 06:43:10","2021-12-17 06:43:10","2021-12-17 10:13:10","2021-12-17 10:13:10"),
("4","4","email","ایمیل","success",NULL,"2024-11-02 19:40:42","2024-11-02 19:40:42","2024-11-02 23:10:42","2024-11-02 23:10:42"),
("5","5","email","ایمیل","success",NULL,"2024-11-02 19:40:49","2024-11-02 19:40:49","2024-11-02 23:10:49","2024-11-02 23:10:49"),
("6","6","email","ایمیل","success",NULL,"2024-11-02 20:30:35","2024-11-02 20:30:35","2024-11-03 00:00:35","2024-11-03 00:00:35"),
("7","7","email","آدرس ایمیل","failed","ارسال شما به دلیل یک خطای سرور انجام نشد.","2025-04-28 18:49:41","2025-04-28 18:49:41","2025-04-28 22:19:41","2025-04-28 22:19:41");

INSERT IGNORE INTO `wp_e_submissions_values` VALUES 
("1","1","email","galaxyboy1988@yahoo.com"),
("2","2","name","تست"),
("3","2","email","bagher.pebs@yahoo.com"),
("4","2","message","254"),
("5","3","name","تست"),
("6","3","email","bagher.pebs@yahoo.com"),
("7","3","message",""),
("8","4","name",""),
("9","4","field_5809e90",""),
("10","4","field_d2c95f4",""),
("11","4","email","dssdsd@dssds.com"),
("12","4","message",""),
("13","5","name",""),
("14","5","email","dssdsd@dssds.com"),
("15","5","field_49275bc",""),
("16","5","field_509e02f","دپارتمان"),
("17","5","message",""),
("18","6","name",""),
("19","6","field_5809e90",""),
("20","6","field_d2c95f4",""),
("21","6","email","dssdsd@dssds.com"),
("22","6","message",""),
("23","7","name",""),
("24","7","field_5809e90",""),
("25","7","field_d2c95f4",""),
("26","7","email","dssdsd@dssds.com"),
("27","7","message","");

INSERT IGNORE INTO `wp_options` VALUES 
("1","siteurl","https://demo.studiaretheme.ir/academy","yes"),
("2","home","https://demo.studiaretheme.ir/academy","yes"),
("3","blogname","قالب استادیار","yes"),
("4","blogdescription","فروش دوره با ووکامرس","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","bagher.pebs@yahoo.com","yes"),
("7","start_of_week","6","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","8","yes"),
("13","rss_use_excerpt","1","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","1","yes"),
("22","posts_per_page","8","yes"),
("23","date_format","j F Y","yes"),
("24","time_format","H:i","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:15:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:35:\"redux-framework/redux-framework.php\";i:2;s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";i:3;s:67:\"autocomplete-woocommerce-orders/autocomplete-woocommerce-orders.php\";i:4;s:33:\"duplicator-pro/duplicator-pro.php\";i:5;s:33:\"duplicator-pro/duplicator-pro.php\";i:6;s:31:\"elementor-pro/elementor-pro.php\";i:7;s:23:\"elementor/elementor.php\";i:8;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:9;s:43:\"persian-woocommerce/woocommerce-persian.php\";i:10;s:23:\"revslider/revslider.php\";i:11;s:31:\"studiare-core/studiare-core.php\";i:12;s:41:\"woo-smart-wishlist/wpc-smart-wishlist.php\";i:13;s:27:\"woocommerce/woocommerce.php\";i:14;s:39:\"wp-events-manager/wp-events-manager.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","https://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","a:5:{i:0;s:92:\"/home/studiar1/demo.studiaretheme.ir/academy/wp-content/themes/studiare/public_functions.php\";i:2;s:81:\"/home/studiar1/demo.studiaretheme.ir/academy/wp-content/themes/studiare/style.css\";i:3;s:100:\"/home/studiar1/demo.studiaretheme.ir/academy/wp-content/themes/studiare/inc/templates/page-title.php\";i:4;s:82:\"/home/studiar1/demo.studiaretheme.ir/academy/wp-content/themes/studiare/header.php\";i:5;s:101:\"/home/studiar1/demo.studiaretheme.ir/academy/wp-content/themes/studiare/inc/templates/blog/single.php\";}","no"),
("40","template","studiare","yes"),
("41","stylesheet","studiare","yes"),
("44","comment_registration","","yes"),
("45","html_type","text/html","yes"),
("46","use_trackback","0","yes"),
("47","default_role","subscriber","yes"),
("48","db_version","60421","yes"),
("49","uploads_use_yearmonth_folders","1","yes"),
("50","upload_path","","yes"),
("51","blog_public","1","yes"),
("52","default_link_category","2","yes"),
("53","show_on_front","page","yes"),
("54","tag_base","","yes"),
("55","show_avatars","1","yes"),
("56","avatar_rating","G","yes"),
("57","upload_url_path","","yes"),
("58","thumbnail_size_w","150","yes"),
("59","thumbnail_size_h","150","yes"),
("60","thumbnail_crop","1","yes"),
("61","medium_size_w","300","yes"),
("62","medium_size_h","300","yes"),
("63","avatar_default","mystery","yes"),
("64","large_size_w","1024","yes"),
("65","large_size_h","1024","yes"),
("66","image_default_link_type","none","yes"),
("67","image_default_size","","yes"),
("68","image_default_align","","yes"),
("69","close_comments_for_old_posts","","yes"),
("70","close_comments_days_old","14","yes"),
("71","thread_comments","1","yes"),
("72","thread_comments_depth","5","yes"),
("73","page_comments","","yes"),
("74","comments_per_page","50","yes"),
("75","default_comments_page","newest","yes"),
("76","comment_order","asc","yes"),
("77","sticky_posts","a:0:{}","yes"),
("78","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("79","widget_text","a:3:{i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:703:\"<img class=\"alignnone wp-image-379\" src=\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2021/12/logo-light.png\" alt=\"Logo Light\" width=\"160\" height=\"68\" />\r\n<div style=\"text-align: justify;\">ما قالب استادیار را با نام استاد سیمین دانشور مزین کردیم، زیرا برند ها رشد می کنند و توانایی آنها درک می شود.</div>\r\n<div>توجه: این بخش از پیشخوان ← نمایش ← ابزارک ها ← پاورقی قابل ویرایش است. توجه: نوع پاورقی کل سایت (نوع موجود یا المنتوری) از تنظیمات قالب&gt;پاورقی قابل انتخاب است.</div>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:2;a:4:{s:5:\"title\";s:14:\"خبرنامه\";s:4:\"text\";s:136:\"چیزی را از دست ندهید، ثبت نام کنید و در مورد شرکت ما مطلع باشید.\r\n[mc4wp_form id=\"380\"]\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}","yes"),
("80","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("81","uninstall_plugins","a:3:{s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:16:\"handle_uninstall\";}s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:27:\"autoptimize/autoptimize.php\";s:29:\"autoptimizeMain::on_uninstall\";}","no"),
("82","timezone_string","Asia/Tehran","yes"),
("83","page_for_posts","19","yes"),
("84","page_on_front","4734","yes"),
("85","default_post_format","0","yes"),
("86","link_manager_enabled","0","yes"),
("87","finished_splitting_shared_terms","1","yes"),
("88","site_icon","0","yes"),
("89","medium_large_size_w","768","yes"),
("90","medium_large_size_h","0","yes"),
("91","wp_page_for_privacy_policy","3","yes"),
("92","initial_db_version","38590","yes"),
("93","wp_user_roles","a:15:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:267:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:34:\"vc_access_rules_post_types/product\";b:1;s:34:\"vc_access_rules_post_types/teacher\";b:1;s:36:\"vc_access_rules_post_types/portfolio\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:14:\"publish_events\";b:1;s:20:\"delete_others_events\";b:1;s:18:\"edit_others_events\";b:1;s:22:\"manage_others_bookings\";b:1;s:24:\"publish_recurring_events\";b:1;s:30:\"delete_others_recurring_events\";b:1;s:28:\"edit_others_recurring_events\";b:1;s:17:\"publish_locations\";b:1;s:23:\"delete_others_locations\";b:1;s:16:\"delete_locations\";b:1;s:21:\"edit_others_locations\";b:1;s:23:\"delete_event_categories\";b:1;s:21:\"edit_event_categories\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;s:35:\"vc_access_rules_post_types/tp_event\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:23:\"dokan_view_booking_menu\";b:1;s:25:\"dokan_add_booking_product\";b:1;s:26:\"dokan_edit_booking_product\";b:1;s:28:\"dokan_delete_booking_product\";b:1;s:29:\"dokan_manage_booking_products\";b:1;s:29:\"dokan_manage_booking_calendar\";b:1;s:21:\"dokan_manage_bookings\";b:1;s:29:\"dokan_manage_booking_resource\";b:1;s:34:\"dokan_view_store_verification_menu\";b:1;s:21:\"dokan_view_tools_menu\";b:1;s:28:\"dokan_manage_support_tickets\";b:1;s:23:\"dokan_view_auction_menu\";b:1;s:25:\"dokan_add_auction_product\";b:1;s:26:\"dokan_edit_auction_product\";b:1;s:28:\"dokan_delete_auction_product\";b:1;s:38:\"vc_access_rules_post_types/sc_megamenu\";b:1;s:18:\"bcn_manage_options\";b:1;s:42:\"vc_access_rules_post_types/sc_notification\";b:1;s:17:\"edit_wcsts_ticket\";b:1;s:18:\"edit_wcsts_tickets\";b:1;s:21:\"publish_wcsts_tickets\";b:1;s:17:\"read_wcsts_ticket\";b:1;s:26:\"read_private_wcsts_tickets\";b:1;s:20:\"delete_wcsts_tickets\";b:1;s:19:\"delete_wcsts_ticket\";b:1;s:20:\"create_wcsts_tickets\";b:1;s:25:\"edit_others_wcsts_tickets\";b:1;s:18:\"dokan_export_order\";b:1;s:14:\"read_ywsbs_sub\";b:1;s:22:\"read_others_ywsbs_subs\";b:1;s:14:\"edit_ywsbs_sub\";b:1;s:15:\"edit_ywsbs_subs\";b:1;s:22:\"edit_others_ywsbs_subs\";b:1;s:16:\"delete_ywsbs_sub\";b:1;s:24:\"delete_others_ywsbs_subs\";b:1;s:15:\"manage_security\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:16:\"edit_swss_ticket\";b:1;s:17:\"edit_swss_tickets\";b:1;s:20:\"publish_swss_tickets\";b:1;s:16:\"read_swss_ticket\";b:1;s:25:\"read_private_swss_tickets\";b:1;s:19:\"delete_swss_tickets\";b:1;s:18:\"delete_swss_ticket\";b:1;s:19:\"create_swss_tickets\";b:1;s:24:\"edit_others_swss_tickets\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;s:16:\"rcp_view_members\";b:1;s:18:\"rcp_manage_members\";b:1;s:15:\"rcp_view_levels\";b:1;s:17:\"rcp_manage_levels\";b:1;s:18:\"rcp_view_discounts\";b:1;s:20:\"rcp_manage_discounts\";b:1;s:17:\"rcp_view_payments\";b:1;s:19:\"rcp_manage_payments\";b:1;s:19:\"rcp_manage_settings\";b:1;s:15:\"rcp_export_data\";b:1;s:13:\"rcp_view_help\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:66:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:14:\"publish_events\";b:1;s:20:\"delete_others_events\";b:1;s:18:\"edit_others_events\";b:1;s:22:\"manage_others_bookings\";b:1;s:24:\"publish_recurring_events\";b:1;s:30:\"delete_others_recurring_events\";b:1;s:28:\"edit_others_recurring_events\";b:1;s:17:\"publish_locations\";b:1;s:23:\"delete_others_locations\";b:1;s:16:\"delete_locations\";b:1;s:21:\"edit_others_locations\";b:1;s:23:\"delete_event_categories\";b:1;s:21:\"edit_event_categories\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:29:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:24:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:4:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:22:\"read_private_locations\";b:1;s:19:\"read_private_events\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:183:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:23:\"dokan_view_booking_menu\";b:1;s:25:\"dokan_add_booking_product\";b:1;s:26:\"dokan_edit_booking_product\";b:1;s:28:\"dokan_delete_booking_product\";b:1;s:29:\"dokan_manage_booking_products\";b:1;s:29:\"dokan_manage_booking_calendar\";b:1;s:21:\"dokan_manage_bookings\";b:1;s:29:\"dokan_manage_booking_resource\";b:1;s:34:\"dokan_view_store_verification_menu\";b:1;s:21:\"dokan_view_tools_menu\";b:1;s:28:\"dokan_manage_support_tickets\";b:1;s:23:\"dokan_view_auction_menu\";b:1;s:25:\"dokan_add_auction_product\";b:1;s:26:\"dokan_edit_auction_product\";b:1;s:28:\"dokan_delete_auction_product\";b:1;s:17:\"edit_wcsts_ticket\";b:1;s:18:\"edit_wcsts_tickets\";b:1;s:21:\"publish_wcsts_tickets\";b:1;s:17:\"read_wcsts_ticket\";b:1;s:26:\"read_private_wcsts_tickets\";b:1;s:20:\"delete_wcsts_tickets\";b:1;s:19:\"delete_wcsts_ticket\";b:1;s:20:\"create_wcsts_tickets\";b:1;s:25:\"edit_others_wcsts_tickets\";b:1;s:18:\"dokan_export_order\";b:1;s:14:\"read_ywsbs_sub\";b:1;s:22:\"read_others_ywsbs_subs\";b:1;s:14:\"edit_ywsbs_sub\";b:1;s:15:\"edit_ywsbs_subs\";b:1;s:22:\"edit_others_ywsbs_subs\";b:1;s:16:\"delete_ywsbs_sub\";b:1;s:24:\"delete_others_ywsbs_subs\";b:1;s:16:\"edit_swss_ticket\";b:1;s:17:\"edit_swss_tickets\";b:1;s:20:\"publish_swss_tickets\";b:1;s:16:\"read_swss_ticket\";b:1;s:25:\"read_private_swss_tickets\";b:1;s:19:\"delete_swss_tickets\";b:1;s:18:\"delete_swss_ticket\";b:1;s:19:\"create_swss_tickets\";b:1;s:24:\"edit_others_swss_tickets\";b:1;s:16:\"create_customers\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:0:{}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:0:{}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:0:{}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:0:{}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:0:{}}s:6:\"seller\";a:2:{s:4:\"name\";s:6:\"Vendor\";s:12:\"capabilities\";a:95:{s:4:\"read\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:12:\"delete_posts\";b:1;s:17:\"manage_categories\";b:1;s:17:\"moderate_comments\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:16:\"edit_shop_orders\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:23:\"dokan_view_booking_menu\";b:1;s:25:\"dokan_add_booking_product\";b:1;s:26:\"dokan_edit_booking_product\";b:1;s:28:\"dokan_delete_booking_product\";b:1;s:29:\"dokan_manage_booking_products\";b:1;s:29:\"dokan_manage_booking_calendar\";b:1;s:21:\"dokan_manage_bookings\";b:1;s:29:\"dokan_manage_booking_resource\";b:1;s:34:\"dokan_view_store_verification_menu\";b:1;s:21:\"dokan_view_tools_menu\";b:1;s:28:\"dokan_manage_support_tickets\";b:1;s:21:\"dokan_view_inbox_menu\";b:1;s:23:\"dokan_view_auction_menu\";b:1;s:25:\"dokan_add_auction_product\";b:1;s:26:\"dokan_edit_auction_product\";b:1;s:28:\"dokan_delete_auction_product\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:36:\"vc_access_rules_post_types/portfolio\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:33:\"vc_access_rules_shortcodes/seller\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:18:\"dokan_export_order\";b:1;}}s:12:\"vendor_staff\";a:2:{s:4:\"name\";s:12:\"Vendor Staff\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:17:\"swss_support_user\";a:2:{s:4:\"name\";s:25:\"کاربر پشتیبان\";s:12:\"capabilities\";a:13:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:20:\"view_admin_dashboard\";b:1;s:16:\"edit_swss_ticket\";b:1;s:17:\"edit_swss_tickets\";b:1;s:20:\"publish_swss_tickets\";b:1;s:16:\"read_swss_ticket\";b:1;s:25:\"read_private_swss_tickets\";b:1;s:19:\"delete_swss_tickets\";b:1;s:18:\"delete_swss_ticket\";b:1;s:19:\"create_swss_tickets\";b:1;s:24:\"edit_others_swss_tickets\";b:1;}}}","yes"),
("94","fresh_site","0","off"),
("95","widget_search","a:3:{i:3;a:1:{s:5:\"title\";s:0:\"\";}i:4;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("96","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("97","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("98","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("99","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("100","sidebars_widgets","a:11:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:10:\"contacts-2\";i:1;s:16:\"namad_carousel-2\";i:2;s:26:\"woocommerce_price_filter-2\";}s:9:\"sidebar-1\";a:4:{i:0;s:8:\"search-3\";i:1;s:13:\"custom_html-1\";i:2;s:12:\"categories-2\";i:3;s:11:\"tag_cloud-1\";}s:17:\"studiare-footer-1\";a:1:{i:0;s:6:\"text-1\";}s:17:\"studiare-footer-2\";a:1:{i:0;s:10:\"nav_menu-1\";}s:17:\"studiare-footer-3\";a:1:{i:0;s:6:\"text-2\";}s:17:\"studiare-footer-4\";a:1:{i:0;s:16:\"namad_carousel-3\";}s:12:\"sidebar_shop\";a:3:{i:0;s:32:\"woocommerce_product_categories-1\";i:1;s:22:\"woocommerce_products-1\";i:2;s:13:\"custom_html-3\";}s:10:\"singleshop\";a:1:{i:0;s:13:\"custom_html-5\";}s:14:\"sidebar_events\";a:2:{i:0;s:8:\"search-4\";i:1;s:13:\"custom_html-6\";}s:14:\"sc_single_shop\";a:1:{i:0;s:13:\"custom_html-4\";}s:13:\"array_version\";i:3;}","yes"),
("101","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("102","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("103","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("104","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("105","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("106","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("107","widget_tag_cloud","a:2:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}","yes"),
("108","widget_nav_menu","a:2:{i:1;a:2:{s:5:\"title\";s:21:\"دسترسی سریع\";s:8:\"nav_menu\";i:43;}s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_custom_html","a:6:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:338:\"<a href=\"https://demo.studiaretheme.ir/academy/contact/\" target=\"_blank\"><img src=\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2020/03/help.jpg\" alt=\"پشتیبانی\"></a>\r\n<p>توجه: این بخش از پیشخوان ← نمایش ← ابزارک ها ← نوار کناری وبلاگ قابل ویرایش است</p>\";}i:3;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:342:\"<a href=\"https://demo.studiaretheme.ir/academy/contact/\" target=\"_blank\"><img src=\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2020/03/help.jpg\" alt=\"پشتیبانی\"></a>\r\n<p>توجه: این بخش از پیشخوان ← نمایش ← ابزارک ها ← نوار کناری فروشگاه قابل ویرایش است</p>\";}i:4;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:205:\"<a href=\"https://themeforest.net/cart/add_items?ref=Esmet&amp;item_ids=21759246\" target=\"_blank\"><img src=\"http://codebean.co/studiare/wp-content/uploads/sites/5/2018/06/ad-banner.jpg\" alt=\"Ad Banner\"></a>\";}i:5;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:345:\"<a href=\"https://demo.studiaretheme.ir/academy/contact/\" target=\"_blank\"><img src=\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2020/03/help.jpg\" alt=\"پشتیبانی\"></a>\r\n<p>توجه: این بخش از پیشخوان ← نمایش ← ابزارک ها ← نوار کناری محصول تکی قابل ویرایش است</p>\";}i:6;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:344:\"<a href=\"https://demo.studiaretheme.ir/academy/contact/\" target=\"_blank\"><img src=\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2020/03/help.jpg\" alt=\"پشتیبانی\"></a>\r\n<p>توجه: این بخش از پیشخوان ← نمایش ← ابزارک ها ← نوار کناری رویدادها قابل ویرایش است</p>\";}s:12:\"_multiwidget\";i:1;}","yes"),
("110","cron","a:43:{i:1757132273;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1757132472;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1757132577;a:1:{s:32:\"duplicator_backup_storages_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:41:\"duplicator_backup_storages_check_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1757132781;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1757132795;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1757133600;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757134810;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1757135033;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757137887;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"f0f217d6f32928cc2d4aa538385bb1fe\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:12162;}}}}i:1757138028;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"2df28b668669e08896431dfc8de1b180\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:12163;}}}}i:1757138410;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757141876;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757144280;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757146647;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757148751;a:1:{s:24:\"dps_schedule_pack_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757150781;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757151505;a:1:{s:40:\"woocommerce_marketplace_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757156549;a:2:{s:23:\"rcp_check_member_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:27:\"rcp_mark_abandoned_payments\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757162053;a:1:{s:13:\"rsmAutoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757169486;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757171950;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757172984;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757179293;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757193990;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757194182;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757199509;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757208120;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757210760;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757215380;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757218077;a:1:{s:31:\"duplicator_activity_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"duplicator_daily_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757327400;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757530084;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757606760;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757668217;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757670186;a:1:{s:40:\"health-check-scheduled-site-status-check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757707595;a:1:{s:34:\"redux-framework_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1759340423;a:1:{s:20:\"put_do_weekly_action\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2635200;}}}i:1766874600;a:1:{s:24:\"tp_event_schedule_status\";a:1:{s:32:\"0625cc10d775c19ef42fe74bcad16b4b\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:2:{i:0;i:320;i:1;s:9:\"happening\";}}}}i:1779575400;a:1:{s:24:\"tp_event_schedule_status\";a:1:{s:32:\"8518638f525b572b734d56af6b10a500\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:2:{i:0;i:322;i:1;s:9:\"happening\";}}}}i:1779759000;a:1:{s:24:\"tp_event_schedule_status\";a:1:{s:32:\"54c9e04e03e214b4619b231ca95f10f0\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:2:{i:0;i:322;i:1;s:7:\"expired\";}}}}i:1796769000;a:1:{s:24:\"tp_event_schedule_status\";a:1:{s:32:\"7c7bb45cb56f823d6c8e1801c2ee1571\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:2:{i:0;i:324;i:1;s:9:\"happening\";}}}}i:1796963400;a:1:{s:24:\"tp_event_schedule_status\";a:1:{s:32:\"81aedc87f103b450301fc21cd7a16a76\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:2:{i:0;i:324;i:1;s:7:\"expired\";}}}}s:7:\"version\";i:2;}","on"),
("111","theme_mods_twentyseventeen","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1536874070;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","no"),
("138","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:21:\"bagher.pebs@yahoo.com\";s:7:\"version\";s:5:\"6.8.2\";s:9:\"timestamp\";i:1757130268;}","off"),
("142","current_theme","Studiare","yes"),
("143","theme_mods_studiare","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:9:\"main-menu\";i:44;s:12:\"top-bar-menu\";i:45;s:11:\"mobile-menu\";i:44;}s:18:\"custom_css_post_id\";i:7241;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1708247156;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:10:\"contacts-2\";i:1;s:16:\"namad_carousel-2\";i:2;s:26:\"woocommerce_price_filter-2\";}s:9:\"sidebar-1\";a:4:{i:0;s:8:\"search-3\";i:1;s:13:\"custom_html-1\";i:2;s:12:\"categories-2\";i:3;s:11:\"tag_cloud-1\";}s:17:\"studiare-footer-1\";a:1:{i:0;s:6:\"text-1\";}s:17:\"studiare-footer-2\";a:1:{i:0;s:10:\"nav_menu-1\";}s:17:\"studiare-footer-3\";a:1:{i:0;s:6:\"text-2\";}s:17:\"studiare-footer-4\";a:1:{i:0;s:16:\"namad_carousel-3\";}s:12:\"sidebar_shop\";a:3:{i:0;s:32:\"woocommerce_product_categories-1\";i:1;s:22:\"woocommerce_products-1\";i:2;s:13:\"custom_html-3\";}s:10:\"singleshop\";a:1:{i:0;s:13:\"custom_html-5\";}s:14:\"sidebar_events\";a:2:{i:0;s:8:\"search-4\";i:1;s:13:\"custom_html-6\";}s:14:\"sc_single_shop\";a:1:{i:0;s:13:\"custom_html-4\";}}}}","yes"),
("144","theme_switched","","yes"),
("145","widget_contacts","a:3:{i:1;a:5:{s:5:\"title\";s:0:\"\";s:7:\"address\";s:85:\"تهران، خیابان آزادی، خیابان بهبودی، ساختمان 101\";s:5:\"phone\";s:12:\"021123456789\";s:3:\"fax\";s:0:\"\";s:5:\"email\";s:0:\"\";}i:2;a:5:{s:5:\"title\";s:8:\"تماس\";s:7:\"address\";s:36:\"تهران، خیابان آزادی\";s:5:\"phone\";s:11:\"09123456789\";s:3:\"fax\";s:12:\"021123456789\";s:5:\"email\";s:22:\"info@studiaretheme.com\";}s:12:\"_multiwidget\";i:1;}","yes"),
("149","woocommerce_store_address","تهران, تهران, تهران","yes"),
("150","woocommerce_store_address_2","تهران","yes"),
("151","woocommerce_store_city","تهران","yes"),
("152","woocommerce_default_country","IR:THR","yes"),
("153","woocommerce_store_postcode","255564","yes"),
("154","woocommerce_allowed_countries","specific","yes"),
("155","woocommerce_all_except_countries","a:0:{}","yes"),
("156","woocommerce_specific_allowed_countries","a:1:{i:0;s:2:\"IR\";}","yes"),
("157","woocommerce_ship_to_countries","","yes"),
("158","woocommerce_specific_ship_to_countries","a:0:{}","yes"),
("159","woocommerce_default_customer_address","geolocation","yes"),
("160","woocommerce_calc_taxes","no","yes"),
("161","woocommerce_enable_coupons","yes","yes"),
("162","woocommerce_calc_discounts_sequentially","no","no"),
("163","woocommerce_currency","IRT","yes"),
("164","woocommerce_currency_pos","right_space","yes"),
("165","woocommerce_price_thousand_sep",",","yes"),
("166","woocommerce_price_decimal_sep",".","yes"),
("167","woocommerce_price_num_decimals","0","yes"),
("168","woocommerce_shop_page_id","491","yes"),
("169","woocommerce_cart_redirect_after_add","no","yes"),
("170","woocommerce_enable_ajax_add_to_cart","yes","yes"),
("171","woocommerce_weight_unit","kg","yes"),
("172","woocommerce_dimension_unit","cm","yes"),
("173","woocommerce_enable_reviews","yes","yes"),
("174","woocommerce_review_rating_verification_label","yes","no"),
("175","woocommerce_review_rating_verification_required","no","no"),
("176","woocommerce_enable_review_rating","yes","yes"),
("177","woocommerce_review_rating_required","yes","no"),
("178","woocommerce_manage_stock","yes","yes"),
("179","woocommerce_hold_stock_minutes","60","no"),
("180","woocommerce_notify_low_stock","yes","no"),
("181","woocommerce_notify_no_stock","yes","no"),
("182","woocommerce_stock_email_recipient","bagher.pebs@yahoo.com","no"),
("183","woocommerce_notify_low_stock_amount","2","no"),
("184","woocommerce_notify_no_stock_amount","0","yes"),
("185","woocommerce_hide_out_of_stock_items","no","yes"),
("186","woocommerce_stock_format","","yes"),
("187","woocommerce_file_download_method","force","no"),
("188","woocommerce_downloads_require_login","yes","no"),
("189","woocommerce_downloads_grant_access_after_payment","yes","no"),
("190","woocommerce_prices_include_tax","no","yes"),
("191","woocommerce_tax_based_on","shipping","yes"),
("192","woocommerce_shipping_tax_class","inherit","yes"),
("193","woocommerce_tax_round_at_subtotal","no","yes"),
("195","woocommerce_tax_display_shop","excl","yes"),
("196","woocommerce_tax_display_cart","excl","yes"),
("197","woocommerce_price_display_suffix","","yes"),
("198","woocommerce_tax_total_display","itemized","no"),
("199","woocommerce_enable_shipping_calc","yes","no"),
("200","woocommerce_shipping_cost_requires_address","no","yes"),
("201","woocommerce_ship_to_destination","billing","no"),
("202","woocommerce_shipping_debug_mode","no","yes"),
("203","woocommerce_enable_guest_checkout","no","no"),
("204","woocommerce_enable_checkout_login_reminder","yes","no"),
("205","woocommerce_enable_signup_and_login_from_checkout","yes","no"),
("206","woocommerce_enable_myaccount_registration","yes","no"),
("207","woocommerce_registration_generate_username","yes","no"),
("208","woocommerce_registration_generate_password","no","no"),
("209","woocommerce_erasure_request_removes_order_data","no","no"),
("210","woocommerce_erasure_request_removes_download_data","no","no"),
("211","woocommerce_registration_privacy_policy_text","داده های شخصی شما برای پشتیبانی از تجربه شما در این وب سایت، برای مدیریت دسترسی به حساب کاربری شما و برای اهداف دیگری که در [privacy_policy] ما شرح داده می شود مورد استفاده قرار می گیرد.","yes"),
("212","woocommerce_checkout_privacy_policy_text","اطلاعات شخصی شما برای پردازش سفارش شما مورد استفاده قرار میگیرد، تجربه شما را در این وبسایت و سایر اهداف مورد نظر در [privacy_policy] ما پشتیبانی می کند.","yes"),
("213","woocommerce_delete_inactive_accounts","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("214","woocommerce_trash_pending_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","no"),
("215","woocommerce_trash_failed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","no"),
("216","woocommerce_trash_cancelled_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","no"),
("217","woocommerce_anonymize_completed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("218","woocommerce_email_from_name","قالب آموزش آنلاین studiare وردپرس","no"),
("219","woocommerce_email_from_address","bagher.pebs@yahoo.com","no"),
("220","woocommerce_email_header_image","","no"),
("221","woocommerce_email_footer_text","{site_title}","no"),
("222","woocommerce_email_base_color","#96588a","no"),
("223","woocommerce_email_background_color","#f7f7f7","no"),
("224","woocommerce_email_body_background_color","#ffffff","no"),
("225","woocommerce_email_text_color","#3c3c3c","no"),
("226","woocommerce_cart_page_id","467","yes"),
("227","woocommerce_checkout_page_id","468","yes"),
("228","woocommerce_myaccount_page_id","469","yes"),
("229","woocommerce_terms_page_id","3","no"),
("230","woocommerce_force_ssl_checkout","no","yes"),
("231","woocommerce_unforce_ssl_checkout","no","yes"),
("232","woocommerce_checkout_pay_endpoint","order-pay","yes"),
("233","woocommerce_checkout_order_received_endpoint","order-received","yes"),
("234","woocommerce_myaccount_add_payment_method_endpoint","add-payment-method","yes"),
("235","woocommerce_myaccount_delete_payment_method_endpoint","delete-payment-method","yes"),
("236","woocommerce_myaccount_set_default_payment_method_endpoint","set-default-payment-method","yes"),
("237","woocommerce_myaccount_orders_endpoint","orders","yes"),
("238","woocommerce_myaccount_view_order_endpoint","view-order","yes"),
("239","woocommerce_myaccount_downloads_endpoint","downloads","yes"),
("240","woocommerce_myaccount_edit_account_endpoint","edit-account","yes"),
("241","woocommerce_myaccount_edit_address_endpoint","edit-address","yes"),
("242","woocommerce_myaccount_payment_methods_endpoint","payment-methods","yes"),
("243","woocommerce_myaccount_lost_password_endpoint","lost-password","yes"),
("244","woocommerce_logout_endpoint","customer-logout","yes"),
("245","woocommerce_api_enabled","no","yes"),
("246","woocommerce_single_image_width","600","yes"),
("247","woocommerce_thumbnail_image_width","300","yes"),
("248","woocommerce_checkout_highlight_required_fields","yes","yes"),
("249","woocommerce_demo_store","no","yes"),
("250","woocommerce_permalinks","a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:15:\"course-category\";s:8:\"tag_base\";s:10:\"course-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}","yes"),
("251","current_theme_supports_woocommerce","yes","yes"),
("252","woocommerce_queue_flush_rewrite_rules","no","yes"),
("255","default_product_cat","15","yes"),
("261","revslider_servers","a:3:{i:0;s:22:\"themepunch-ext-b.tools\";i:1;s:22:\"themepunch-ext-c.tools\";i:2;s:22:\"themepunch-ext-a.tools\";}","yes"),
("262","revslider_server_refresh","1757130253","yes"),
("263","revslider-update-check-short","1757130261","yes"),
("264","revslider-templates-check","1757130261","yes"),
("268","redux_version_upgraded_from","3.6.18","yes"),
("270","widget_woocommerce_widget_cart","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("271","widget_woocommerce_layered_nav_filters","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("272","widget_woocommerce_layered_nav","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("273","widget_woocommerce_price_filter","a:2:{i:2;a:1:{s:5:\"title\";s:34:\"فیلتر براساس قیمت :\";}s:12:\"_multiwidget\";i:1;}","yes"),
("274","widget_woocommerce_product_categories","a:2:{i:1;a:8:{s:5:\"title\";s:22:\"دسته بندی ها\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:1;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("275","widget_woocommerce_product_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("276","widget_woocommerce_product_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("277","widget_woocommerce_products","a:2:{i:1;a:7:{s:5:\"title\";s:14:\"محصولات\";s:6:\"number\";i:4;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("278","widget_woocommerce_recently_viewed_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("279","widget_woocommerce_top_rated_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("280","widget_woocommerce_recent_reviews","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("281","widget_woocommerce_rating_filter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("282","widget_mc4wp_form_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("283","widget_bcn_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("285","woocommerce_meta_box_errors","a:0:{}","yes"),
("286","woocommerce_admin_notices","a:0:{}","yes"),
("296","codebean_option","a:418:{s:8:\"last_tab\";s:0:\"\";s:20:\"studiare_layout_mode\";s:5:\"boxed\";s:27:\"studiare_boxed_width_mobile\";s:3:\"540\";s:27:\"studiare_boxed_width_tablet\";s:3:\"720\";s:27:\"studiare_boxed_width_laptop\";s:3:\"960\";s:28:\"studiare_boxed_width_desktop\";s:4:\"1230\";s:7:\"favicon\";a:5:{s:3:\"url\";s:77:\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2022/04/fvicon-o.png\";s:2:\"id\";s:4:\"7423\";s:6:\"height\";s:3:\"144\";s:5:\"width\";s:3:\"144\";s:9:\"thumbnail\";s:77:\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2022/04/fvicon-o.png\";}s:14:\"favicon_retina\";a:5:{s:3:\"url\";s:77:\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2022/04/fvicon-o.png\";s:2:\"id\";s:4:\"7423\";s:6:\"height\";s:3:\"144\";s:5:\"width\";s:3:\"144\";s:9:\"thumbnail\";s:77:\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2022/04/fvicon-o.png\";}s:18:\"studiare_preloader\";s:1:\"1\";s:14:\"preloader_icon\";s:5:\"book2\";s:22:\"custom_preloader_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:23:\"sc_preloader_icon_color\";a:1:{s:16:\"background-color\";s:7:\"#26a69a\";}s:23:\"sc_preloader_background\";a:1:{s:16:\"background-color\";s:7:\"#ffffff\";}s:14:\"preloader_text\";s:63:\"قالب استادیار طراحی اختصاصی سان کد\";s:25:\"preloader_text_typography\";a:6:{s:11:\"font-family\";s:10:\"Yekan_Bakh\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"32px\";s:5:\"color\";s:7:\"#7d7e7f\";}s:14:\"google_api_key\";s:0:\"\";s:11:\"progressbar\";s:15:\"show_in_singles\";s:17:\"progressbar_color\";s:7:\"#058dfc\";s:22:\"siteb_backgrount_color\";a:7:{s:16:\"background-color\";s:11:\"transparent\";s:17:\"background-repeat\";s:6:\"repeat\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:103:\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2021/12/maxcoach-shape-square-plus-150x150.png\";}}s:13:\"primary_color\";s:7:\"#26A69A\";s:15:\"secondary_color\";s:7:\"#4ECDC4\";s:12:\"eshare_color\";s:7:\"#494949\";s:17:\"sc_darkmode_ready\";s:0:\"\";s:18:\"sc_darkmode_always\";s:1:\"1\";s:22:\"dark_mode_default_type\";s:4:\"dark\";s:28:\"show_darkmode_icon_in_header\";s:1:\"1\";s:27:\"dark_siteb_backgrount_color\";a:7:{s:16:\"background-color\";s:7:\"#020134\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:18:\"dark_primary_color\";s:7:\"#150550\";s:20:\"dark_secondary_color\";s:7:\"#020134\";s:16:\"dark_light_color\";s:7:\"#FFFFFF\";s:19:\"dark_headings_color\";s:7:\"#FFFFFF\";s:16:\"dark_links_color\";s:7:\"#FFFFFF\";s:9:\"font_body\";a:6:{s:11:\"font-family\";s:10:\"Yekan_Bakh\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"14px\";s:5:\"color\";s:7:\"#7d7e7f\";}s:12:\"menu_heading\";a:5:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"15px\";}s:12:\"submenu_font\";a:5:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"13px\";}s:9:\"h1_params\";a:6:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"800\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"22px\";s:5:\"color\";s:7:\"#464749\";}s:9:\"h2_params\";a:6:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"800\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"20px\";s:5:\"color\";s:7:\"#464749\";}s:9:\"h3_params\";a:6:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"18px\";s:5:\"color\";s:7:\"#464749\";}s:9:\"h4_params\";a:6:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"16px\";s:5:\"color\";s:7:\"#464749\";}s:9:\"h5_params\";a:6:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"14px\";s:5:\"color\";s:7:\"#464749\";}s:9:\"h6_params\";a:6:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"12px\";s:5:\"color\";s:7:\"#464749\";}s:16:\"sc_links_tpgrphy\";a:6:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:5:\"color\";s:7:\"#464749\";}s:22:\"sc_vrd_heading_tpgrphy\";a:5:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"32px\";}s:17:\"studi_header_type\";s:7:\"default\";s:14:\"header_page_id\";s:4:\"7539\";s:18:\"sc_header_bg_color\";a:1:{s:16:\"background-color\";s:7:\"#ffffff\";}s:13:\"header_height\";s:2:\"60\";s:17:\"custom_logo_image\";a:5:{s:3:\"url\";s:73:\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2021/10/logo.png\";s:2:\"id\";s:4:\"3576\";s:6:\"height\";s:3:\"144\";s:5:\"width\";s:3:\"339\";s:9:\"thumbnail\";s:81:\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2021/10/logo-150x144.png\";}s:14:\"logo_img_width\";s:3:\"111\";s:21:\"mobile_logo_img_width\";s:2:\"96\";s:15:\"logo_img_height\";s:2:\"47\";s:22:\"mobile_logo_img_height\";s:2:\"50\";s:12:\"logo_padding\";a:5:{s:5:\"units\";s:2:\"px\";s:11:\"padding-top\";s:4:\"10px\";s:13:\"padding-right\";s:4:\"20px\";s:14:\"padding-bottom\";s:4:\"10px\";s:12:\"padding-left\";s:1:\"0\";}s:25:\"show_notif_icon_in_header\";s:1:\"1\";s:26:\"show_search_icon_in_header\";s:1:\"1\";s:23:\"search_placeholder_text\";s:0:\"\";s:28:\"show_shopping_icon_in_header\";s:1:\"1\";s:13:\"header_button\";s:1:\"1\";s:18:\"header_button_link\";s:7:\"account\";s:18:\"header_button_type\";s:7:\"submenu\";s:10:\"hb_submenu\";s:3:\"110\";s:27:\"header_button_custom_text_0\";s:17:\"شروع کنید\";s:27:\"header_button_custom_text_1\";s:21:\"حساب کاربری\";s:25:\"header_button_custom_text\";s:21:\"ورود / عضویت\";s:27:\"header_button_custom_text_2\";s:21:\"حساب کاربری\";s:25:\"header_button_custom_link\";s:48:\"https://demo.studiaretheme.ir/academy/my-account\";s:11:\"show_avatar\";s:1:\"1\";s:17:\"show_display_name\";s:1:\"1\";s:25:\"sc_header_button_bg_color\";a:1:{s:16:\"background-color\";s:7:\"#e8f5fb\";}s:26:\"sc_header_button_txt_color\";s:7:\"#6c8d9d\";s:20:\"header_button_border\";a:6:{s:10:\"border-top\";s:3:\"1px\";s:12:\"border-right\";s:3:\"1px\";s:13:\"border-bottom\";s:3:\"1px\";s:11:\"border-left\";s:3:\"1px\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:7:\"#e8f5fb\";}s:24:\"header_menuholder_border\";a:6:{s:10:\"border-top\";s:3:\"0px\";s:12:\"border-right\";s:3:\"0px\";s:13:\"border-bottom\";s:3:\"0px\";s:11:\"border-left\";s:3:\"0px\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:7:\"#e91e63\";}s:17:\"sc-menuholder-spc\";a:5:{s:5:\"units\";s:2:\"px\";s:11:\"padding-top\";s:1:\"0\";s:13:\"padding-right\";s:1:\"0\";s:14:\"padding-bottom\";s:1:\"0\";s:12:\"padding-left\";s:1:\"0\";}s:27:\"sc-menuholder-border-radius\";a:5:{s:5:\"units\";s:2:\"px\";s:10:\"margin-top\";s:4:\"10px\";s:12:\"margin-right\";s:4:\"10px\";s:13:\"margin-bottom\";s:4:\"10px\";s:11:\"margin-left\";s:4:\"10px\";}s:25:\"sc_menu_style_links_color\";s:0:\"\";s:38:\"sc_menu_style_links_hover_active_color\";s:7:\"#4ECDC4\";s:25:\"menu_item_active_bg_color\";a:1:{s:16:\"background-color\";s:0:\"\";}s:27:\"sc-menu-items-border-radius\";a:5:{s:5:\"units\";s:2:\"px\";s:10:\"margin-top\";s:3:\"5px\";s:12:\"margin-right\";s:3:\"5px\";s:13:\"margin-bottom\";s:3:\"5px\";s:11:\"margin-left\";s:3:\"5px\";}s:17:\"sc-menu-items-mrg\";a:3:{s:5:\"units\";s:2:\"px\";s:12:\"margin-right\";s:3:\"5px\";s:11:\"margin-left\";s:3:\"5px\";}s:17:\"sc-menu-items-spc\";a:5:{s:5:\"units\";s:2:\"px\";s:11:\"padding-top\";s:3:\"5px\";s:13:\"padding-right\";s:3:\"5px\";s:14:\"padding-bottom\";s:3:\"5px\";s:12:\"padding-left\";s:3:\"5px\";}s:29:\"sc_sub_menu_style_links_color\";s:7:\"#464749\";s:42:\"sc_sub_menu_style_links_hover_active_color\";s:7:\"#4ECDC4\";s:17:\"sub_menu_bg_color\";a:1:{s:16:\"background-color\";s:0:\"\";}s:18:\"sc-submenu-box-spc\";a:5:{s:5:\"units\";s:2:\"px\";s:11:\"padding-top\";s:1:\"0\";s:13:\"padding-right\";s:1:\"0\";s:14:\"padding-bottom\";s:1:\"0\";s:12:\"padding-left\";s:1:\"0\";}s:28:\"sc-submenu-box-border-radius\";a:5:{s:5:\"units\";s:2:\"px\";s:10:\"margin-top\";s:3:\"4px\";s:12:\"margin-right\";s:3:\"4px\";s:13:\"margin-bottom\";s:3:\"4px\";s:11:\"margin-left\";s:3:\"4px\";}s:20:\"sub_menu_lines_color\";a:1:{s:16:\"background-color\";s:0:\"\";}s:30:\"sc-submenu-items-border-radius\";a:5:{s:5:\"units\";s:2:\"px\";s:10:\"margin-top\";s:3:\"5px\";s:12:\"margin-right\";s:3:\"5px\";s:13:\"margin-bottom\";s:3:\"5px\";s:11:\"margin-left\";s:3:\"5px\";}s:20:\"sc-submenu-items-mrg\";a:5:{s:5:\"units\";s:2:\"px\";s:10:\"margin-top\";s:1:\"0\";s:12:\"margin-right\";s:1:\"0\";s:13:\"margin-bottom\";s:1:\"0\";s:11:\"margin-left\";s:1:\"0\";}s:20:\"sc-submenu-items-spc\";a:5:{s:5:\"units\";s:2:\"px\";s:11:\"padding-top\";s:4:\"10px\";s:13:\"padding-right\";s:4:\"20px\";s:14:\"padding-bottom\";s:4:\"10px\";s:12:\"padding-left\";s:4:\"20px\";}s:20:\"sc_top_notifbar_situ\";s:1:\"1\";s:23:\"sc_top_notifbar_content\";s:4:\"2768\";s:25:\"sc_top_notifbar_close_btn\";s:1:\"1\";s:27:\"sc_top_notifbar_reopen_time\";s:4:\"7200\";s:24:\"sc_top_notifbar_bg_color\";s:7:\"#FFD700\";s:18:\"sc_top_notifbar_bg\";a:6:{s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:18:\"topbar_display_opt\";s:1:\"1\";s:12:\"topbar_color\";s:5:\"light\";s:10:\"top-bar-bg\";a:1:{s:16:\"background-color\";s:7:\"#2e3e77\";}s:13:\"top_bar_phone\";s:10:\"0123456789\";s:18:\"top_bar_phone_link\";s:1:\"1\";s:13:\"top_bar_email\";s:16:\"info@studiare.ir\";s:18:\"top_bar_email_link\";s:1:\"1\";s:11:\"topbar_menu\";s:1:\"1\";s:13:\"topbar_search\";s:1:\"1\";s:18:\"topbar_search_ajax\";s:0:\"\";s:11:\"topbar_cart\";s:1:\"0\";s:17:\"topbar_woo_wallet\";s:1:\"1\";s:20:\"enable_disable_brdcr\";s:1:\"1\";s:16:\"sc_disable_title\";s:1:\"1\";s:16:\"sc_disable_brdcr\";s:1:\"1\";s:15:\"sc_header_boxed\";s:0:\"\";s:11:\"sc-brdcm-bg\";a:7:{s:16:\"background-color\";s:7:\"#4ecdc4\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:15:\"sc-brdcm-bg-spc\";a:5:{s:5:\"units\";s:2:\"px\";s:11:\"padding-top\";s:4:\"40px\";s:13:\"padding-right\";s:0:\"\";s:14:\"padding-bottom\";s:4:\"30px\";s:12:\"padding-left\";s:0:\"\";}s:15:\"sc-brdcm-bg-mrg\";a:3:{s:5:\"units\";s:2:\"px\";s:10:\"margin-top\";s:1:\"0\";s:13:\"margin-bottom\";s:1:\"0\";}s:19:\"header_brdcm_border\";a:6:{s:10:\"border-top\";s:3:\"0px\";s:12:\"border-right\";s:3:\"0px\";s:13:\"border-bottom\";s:3:\"0px\";s:11:\"border-left\";s:3:\"0px\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:7:\"#e91e63\";}s:22:\"sc-brdcm-border-radius\";a:5:{s:5:\"units\";s:2:\"px\";s:10:\"margin-top\";s:1:\"0\";s:12:\"margin-right\";s:1:\"0\";s:13:\"margin-bottom\";s:1:\"0\";s:11:\"margin-left\";s:1:\"0\";}s:17:\"sc-brdcm-bg-txclr\";s:7:\"#FFFFFF\";s:33:\"header_button_link_show_on_mobile\";s:9:\"show_icon\";s:33:\"sc_off_canvas_navigation_position\";s:1:\"0\";s:35:\"show_shopping_icon_in_header_mobile\";s:1:\"1\";s:28:\"sc_bg_header_color_in_chrome\";s:7:\"#2E3E77\";s:27:\"sc_bg_off_canvas_navigation\";a:7:{s:16:\"background-color\";s:7:\"#212529\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:88:\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2022/03/colorful_bg-150x150.png\";}}s:33:\"sc_txtcolor_off_canvas_navigation\";s:7:\"#FFFFFF\";s:17:\"off_canvas_search\";s:1:\"1\";s:15:\"off_canvas_cart\";s:1:\"1\";s:17:\"off_canvas_footer\";s:33:\"																																	\";s:25:\"show_mobile_bottom_navbar\";s:1:\"1\";s:16:\"mobile_more_menu\";s:4:\"9722\";s:24:\"mobile-button-nav-blocks\";a:2:{s:7:\"enabled\";a:7:{s:7:\"placebo\";s:7:\"placebo\";s:9:\"backtotop\";s:26:\"بازگشت به بالا\";s:4:\"home\";s:8:\"خانه\";s:6:\"search\";s:10:\"جستجو\";s:7:\"account\";s:21:\"حساب کاربری\";s:4:\"cart\";s:15:\"سبد خرید\";s:4:\"more\";s:19:\"دکمه بیشتر\";}s:8:\"disabled\";a:1:{s:7:\"placebo\";s:7:\"placebo\";}}s:16:\"btm_account_link\";s:0:\"\";s:16:\"sc_topfix_header\";s:0:\"\";s:19:\"sc_middlefix_header\";s:1:\"1\";s:15:\"sc_smart_sticky\";s:3:\"off\";s:16:\"sc_before_footer\";s:1:\"1\";s:24:\"sc_before_footer_content\";s:4:\"2698\";s:17:\"footer_visibility\";s:1:\"1\";s:17:\"studi_footer_type\";s:7:\"default\";s:14:\"footer_page_id\";s:4:\"3205\";s:19:\"footer_color_scheme\";s:5:\"light\";s:17:\"footer-widgets-bg\";a:7:{s:16:\"background-color\";s:7:\"#2e3e77\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:14:\"footer_widgets\";s:1:\"1\";s:14:\"footer_columns\";s:4:\"four\";s:18:\"disable_copyrights\";s:1:\"1\";s:17:\"copyrights-layout\";s:7:\"default\";s:10:\"copyrights\";s:151:\"© 1404. قالب استادیار نسخه سیمین دانشور - طراحی <a href=\"https://www.rtl-theme.com/author/bagherpebs/\">سان کد</a>\";s:11:\"copyrights2\";s:25:\"[social_networks rounded]\";s:14:\"scroll_top_btn\";s:1:\"1\";s:15:\"sc_floating_btn\";s:1:\"1\";s:23:\"sc_floating_btn_content\";s:4:\"3058\";s:22:\"sc_floating_btn_color1\";s:7:\"#222E59\";s:22:\"sc_floating_btn_color2\";s:7:\"#2E3E77\";s:22:\"sc_floating_btn_color3\";s:7:\"#FFFFFF\";s:31:\"sc_floating_btn_color3_darkmode\";s:7:\"#000000\";s:23:\"sc_contact_floating_btn\";s:1:\"1\";s:31:\"sc_contact_floating_btn_content\";s:4:\"2780\";s:26:\"sc_contact_floating_btn_bg\";s:7:\"#8BC34A\";s:28:\"sc_contact_floating_btn_brdr\";s:7:\"#C5E1A5\";s:29:\"sc_contact_floating_btn_title\";s:1:\"1\";s:33:\"sc_contact_floating_btn_title_txt\";s:18:\"تماس با ما\";s:40:\"studi_custom_floating_btn_content_margin\";s:2:\"10\";s:12:\"shop_sidebar\";s:4:\"left\";s:29:\"place_of_discriptions_of_cats\";s:6:\"bottom\";s:15:\"courses_columns\";s:1:\"3\";s:19:\"courses_layout_mode\";s:4:\"grid\";s:19:\"shop_pro_image_size\";s:21:\"studiare-course-thumb\";s:13:\"shop_per_page\";s:1:\"6\";s:20:\"archive_teacher_view\";s:6:\"avatar\";s:19:\"product_rating_view\";s:1:\"1\";s:13:\"product_stars\";s:1:\"1\";s:23:\"product_descr_shop_page\";s:1:\"1\";s:14:\"toman_as_image\";s:1:\"0\";s:22:\"sc_shop_page_addtocart\";s:1:\"1\";s:15:\"sc_shop_page_qv\";s:0:\"\";s:15:\"sc_shop_page_aw\";s:1:\"1\";s:26:\"product_danshjou_icon_view\";s:1:\"1\";s:28:\"product_sc_loop_main_feature\";s:1:\"1\";s:23:\"product_category_border\";s:1:\"1\";s:22:\"free_or_call_for_price\";s:1:\"0\";s:13:\"danshjou_icon\";s:18:\"fal fa-users-class\";s:21:\"exclude_products_shop\";s:0:\"\";s:24:\"show_excluded_in_archive\";s:0:\"\";s:28:\"show_custom_shop_description\";s:6:\"bottom\";s:31:\"custom_shop_description_content\";s:2090:\"<h2>قالب استادیار - بهترین انتخاب برای فروش دوره و محصولات آموزشی</h2>\r\n🎓 <strong>قالب استادیار</strong>، یک راه‌حل حرفه‌ای و کاربردی برای فروش دوره‌های آموزشی، محصولات دانلودی و محتوای دیجیتال در وردپرس است. این قالب با طراحی مدرن، انعطاف‌پذیری بالا و امکانات پیشرفته، به شما کمک می‌کند تا یک فروشگاه اینترنتی جذاب و پر بازده راه‌اندازی کنید.\r\n\r\nویژگی‌های کلیدی قالب استادیار:\r\n✔ طراحی واکنش‌گرا و مدرن - نمایش عالی در تمام دستگاه‌ها (موبایل، تبلت و دسکتاپ)\r\n✔ سازگاری کامل با ووکامرس - مدیریت آسان محصولات، دوره‌ها و پرداخت‌ها\r\n✔ سیستم مدیریت دوره‌های آموزشی - پشتیبانی از دوره‌های آنلاین، ویدیویی و دانلودی\r\n✔ امکانات پیشرفته سئو - بهینه‌سازی شده برای رتبه‌بندی بهتر در گوگل\r\n✔ صفحه ساز حرفه‌ای - امکان طراحی صفحات فروش جذاب بدون نیاز به کدنویسی\r\n✔ پشتیبانی از چندین روش پرداخت - درگاه‌های بانکی، کیف پول و پرداخت آنلاین\r\n✔ طرح‌بندی متنوع برای محصولات - نمایش زیبا و جذاب دوره‌ها و فایل‌های دانلودی\r\n\r\n🚀 با قالب استادیار، فروش دوره‌ها و محصولات آموزشی خود را متحول کنید!\r\n\r\n📌 نصب آسان، تنظیمات سریع و پشتیبانی حرفه‌ای - بهترین گزینه برای مدرسان، آموزشگاه‌ها و فروشندگان محتوای دیجیتال.\r\n\r\n🔹 همین حالا قالب استادیار را نصب کنید و فروش خود را افزایش دهید!\";s:21:\"single_product_layout\";s:9:\"layout-03\";s:24:\"product_sidebar_position\";s:1:\"0\";s:27:\"product_meta_info_top_stuts\";s:1:\"1\";s:27:\"show_fullscreen_mode_button\";s:1:\"0\";s:22:\"related_course_product\";s:1:\"1\";s:24:\"single_fixed_information\";s:1:\"1\";s:29:\"product_single_sc_show_buyers\";s:1:\"1\";s:21:\"sc_lesson_number_auto\";s:1:\"0\";s:25:\"sc_lessons_display_in_tab\";s:0:\"\";s:29:\"sc_lock_lessons_based_on_quiz\";s:1:\"1\";s:21:\"sc_lock_lessons_scope\";s:9:\"all_items\";s:26:\"sc_always_allow_first_item\";s:1:\"1\";s:22:\"product_meta_info_list\";s:1:\"1\";s:23:\"product_buyers_insingle\";s:1:\"1\";s:31:\"product_single_sc_single_navbar\";s:1:\"0\";s:32:\"product_meta_info_comment_number\";s:1:\"1\";s:24:\"product_meta_info_list_2\";s:1:\"1\";s:37:\"product_meta_info_list_date_published\";s:1:\"1\";s:36:\"product_meta_info_list_date_modified\";s:1:\"1\";s:28:\"product_meta_info_list_stars\";s:1:\"1\";s:27:\"product_meta_info_list_cats\";s:1:\"1\";s:27:\"product_meta_info_list_tags\";s:1:\"1\";s:33:\"product_meta_info_list_short_link\";s:1:\"1\";s:33:\"product_meta_info_teacher_profile\";s:1:\"1\";s:31:\"product_meta_info_teacher_about\";s:1:\"1\";s:39:\"product_meta_info_teacher_other_courses\";s:1:\"1\";s:24:\"single_add_to_cart_color\";s:4:\"#fff\";s:29:\"single_add_to_cart_background\";s:7:\"#4CAF50\";s:20:\"sc--amazing-offer-bg\";a:7:{s:16:\"background-color\";s:7:\"#e91e63\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:21:\"sc--amazing-offer-txt\";s:7:\"#ffffff\";s:30:\"sc--amazing-offer-txt-disvalue\";s:7:\"#e91e63\";s:19:\"lesson_header_color\";a:2:{s:4:\"from\";s:7:\"#39DAA9\";s:2:\"to\";s:7:\"#13CE92\";}s:26:\"lesson_header_active_color\";a:2:{s:4:\"from\";s:7:\"#2E3E77\";s:2:\"to\";s:7:\"#3F51B5\";}s:24:\"lesson_header_icon_color\";s:7:\"#009688\";s:31:\"lesson_header_icon_active_color\";s:7:\"#3f51b5\";s:28:\"private_lesson_message_color\";s:7:\"#ff0000\";s:31:\"private_lesson_message_bg_color\";a:7:{s:16:\"background-color\";s:7:\"#ffcdd2\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:22:\"private_lesson_message\";s:159:\"این بخش خصوصی می باشد. برای دسترسی کامل به دروس این دوره باید این دوره را خریداری نمایید.\";s:19:\"login_toast_message\";s:94:\"برای دانلود این فایل باید وارد حساب کاربری خود شوید.\";s:17:\"login_toast_title\";s:8:\"توجه\";s:20:\"bought_toast_message\";s:88:\"برای دانلود این فایل باید دوره را خریداری نمایید\";s:18:\"bought_toast_title\";s:8:\"توجه\";s:23:\"product_single_outstock\";s:1:\"1\";s:31:\"product_single_outstock_message\";s:25:\"ظرفیت تمام شد!\";s:34:\"product_single_sc_add_to_cart_text\";s:33:\"افزودن به سبد خرید\";s:36:\"product_single_sc_added_to_cart_text\";s:54:\"دوره به سبد خرید اضافه شده است\";s:41:\"product_single_sc_purchased_producct_text\";s:48:\"شما دانشجوی این دوره هستید\";s:21:\"related_products_base\";s:11:\"product_cat\";s:37:\"radio_instead_dropdown_variable_items\";s:1:\"1\";s:26:\"product_single_rating_mode\";s:1:\"1\";s:21:\"studi_readmore_in_pro\";s:1:\"0\";s:17:\"readmore_open_txt\";s:23:\"مشاهده بیشتر\";s:18:\"readmore_close_txt\";s:21:\"مشاهده کمتر\";s:22:\"related_products_count\";s:1:\"4\";s:26:\"related_products_per_slide\";s:1:\"2\";s:31:\"related_products_per_slide_ltwo\";s:1:\"3\";s:33:\"related_products_per_slide_lthree\";s:1:\"3\";s:25:\"user_other_products_count\";s:1:\"4\";s:25:\"product_single_sc_message\";s:1:\"1\";s:18:\"sc_offer_amount_in\";s:2:\"50\";s:27:\"product_single_sc_message_0\";s:166:\"با کد تخفیف <strong>suncode</strong> این محصول را با 50 درصد تخفیف خریداری نمایید. یعنی: [sc_amazing_offer_final_price]\";s:15:\"sc--discount-bg\";a:7:{s:16:\"background-color\";s:7:\"#ffc107\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:16:\"sc--discount-txt\";s:7:\"#FFFFFF\";s:24:\"sc_view_page_general_att\";s:1:\"1\";s:26:\"sc_select_page_general_att\";s:4:\"3284\";s:39:\"sc_select_page_general_att_exclude_cats\";a:1:{i:0;s:2:\"53\";}s:18:\"course_share_story\";s:1:\"1\";s:13:\"sc_site_email\";s:0:\"\";s:30:\"course_checkout_address_fields\";s:0:\"\";s:18:\"show_logo_in_login\";s:1:\"0\";s:19:\"login_page_template\";s:7:\"temp-03\";s:11:\"login_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:21:\"login-page-main-color\";s:7:\"#8224E3\";s:3:\"otp\";s:1:\"0\";s:21:\"compulsion_mobile_num\";s:1:\"0\";s:14:\"login_priority\";s:5:\"email\";s:12:\"otp_provider\";s:12:\"mellipayamak\";s:24:\"mellipayamak_api_address\";s:0:\"\";s:19:\"suncode_api_address\";s:0:\"\";s:24:\"myaccount_page_fullwidth\";s:0:\"\";s:24:\"my_account_page_template\";s:17:\"myaccount-temp-01\";s:16:\"sc_notif_to_show\";s:1:\"5\";s:20:\"sc_comments_per_page\";s:1:\"5\";s:29:\"enable_profile_picture_upload\";s:1:\"1\";s:24:\"sc_custom_dashboard_page\";s:0:\"\";s:18:\"sc_active_dash_tab\";s:6:\"notifs\";s:22:\"show_latest_notifs_tab\";s:1:\"1\";s:19:\"show_statistics_tab\";s:1:\"1\";s:15:\"show_custom_tab\";s:1:\"1\";s:21:\"dash_custom_tab_title\";s:17:\"تب سفارشی\";s:23:\"dash_custom_tab_content\";s:340:\"این یک تب سفارشی است و شما می توانید متن دلخواه خود را در آن قرار دهید <strong>(تنظیمات قالب&gt;تنظیمات حساب کاربری&gt;نمایش تب سفارشی)</strong>\r\n<ul>\r\n 	<li>عنوان اول</li>\r\n 	<li>عنوان دوم</li>\r\n 	<li>عنون سوم</li>\r\n</ul>\";s:20:\"sc_custom_logout_url\";s:0:\"\";s:29:\"sc_disable_menu_from_endpoint\";s:0:\"\";s:20:\"custom_account_menus\";a:7:{s:19:\"redux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:10:\"menu_title\";a:1:{i:0;s:0:\"\";}s:9:\"menu_slug\";a:1:{i:0;s:0:\"\";}s:9:\"menu_icon\";a:1:{i:0;s:0:\"\";}s:17:\"menu_content_type\";a:1:{i:0;s:6:\"editor\";}s:19:\"menu_content_editor\";a:1:{i:0;s:0:\"\";}s:17:\"menu_content_page\";a:1:{i:0;s:0:\"\";}}s:17:\"teachers_per_page\";s:1:\"4\";s:21:\"teachers_archive_page\";s:0:\"\";s:32:\"enable_dynamic_teacher_name_slug\";s:1:\"0\";s:21:\"teachers_custom_title\";s:12:\"مدرسان\";s:20:\"teachers_custom_slug\";s:7:\"teacher\";s:15:\"blog_post_style\";s:4:\"list\";s:17:\"blog_grid_columns\";s:5:\"three\";s:34:\"place_of_discriptions_of_cats_blog\";s:6:\"bottom\";s:16:\"sidebar_position\";s:5:\"right\";s:27:\"sticky_blog_archive_sidebar\";s:1:\"1\";s:20:\"blog_list_image_size\";s:4:\"full\";s:19:\"blog_pro_image_size\";s:29:\"studiare-image-420x294-croped\";s:17:\"blog_hover_effect\";s:7:\"default\";s:14:\"blog_show_date\";s:1:\"1\";s:16:\"blog_show_author\";s:1:\"1\";s:17:\"blog_show_excerpt\";s:1:\"1\";s:24:\"blog_show_excerpt_length\";s:3:\"200\";s:20:\"blog_show_categories\";s:1:\"1\";s:23:\"single_sidebar_position\";s:5:\"right\";s:19:\"sticky_blog_sidebar\";s:1:\"1\";s:34:\"article_feautred_image_single_post\";s:1:\"1\";s:28:\"article_date_top_single_post\";s:1:\"1\";s:30:\"article_author_top_single_post\";s:1:\"1\";s:28:\"article_cats_top_single_post\";s:1:\"1\";s:31:\"article_tags_bottom_single_post\";s:1:\"1\";s:14:\"article_author\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:19:\"single_post_related\";s:5:\"bycat\";s:9:\"spr_title\";s:24:\"پست های مرتبط\";s:12:\"spr_post_num\";s:1:\"5\";s:11:\"post_layout\";s:4:\"grid\";s:12:\"spr_elements\";a:3:{i:0;s:4:\"date\";i:1;s:8:\"readmore\";i:2;s:6:\"author\";}s:10:\"rp_columns\";s:1:\"3\";s:17:\"rp_columns_tablet\";s:1:\"2\";s:17:\"rp_columns_mobile\";s:1:\"1\";s:16:\"blog_share_story\";s:1:\"1\";s:18:\"event_login_to_woo\";s:1:\"1\";s:16:\"portfolio_status\";s:1:\"1\";s:17:\"portfolio_columns\";s:5:\"three\";s:17:\"portfolio_filters\";s:4:\"left\";s:18:\"portfolio_per_page\";s:1:\"9\";s:13:\"portfolio_nav\";s:1:\"1\";s:24:\"portfolio_featured_image\";s:1:\"1\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_singular_name\";s:21:\"نمونه کارها\";s:21:\"portfolio_plural_name\";s:21:\"نمونه کارها\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:18:\"portfolio_tag_slug\";s:13:\"portfolio_tag\";s:12:\"social_order\";a:2:{s:7:\"enabled\";a:6:{s:7:\"placebo\";s:7:\"placebo\";s:6:\"aparat\";s:6:\"Aparat\";s:8:\"telegram\";s:8:\"Telegram\";s:2:\"ig\";s:9:\"Instagram\";s:2:\"fb\";s:8:\"Facebook\";s:2:\"tw\";s:7:\"Twitter\";}s:8:\"disabled\";a:24:{s:7:\"placebo\";s:7:\"placebo\";s:2:\"be\";s:7:\"Behance\";s:2:\"gp\";s:7:\"Google+\";s:3:\"lin\";s:8:\"LinkedIn\";s:2:\"yt\";s:7:\"YouTube\";s:6:\"custom\";s:11:\"Custom Link\";s:2:\"fs\";s:10:\"Foursquare\";s:3:\"drb\";s:8:\"Dribbble\";s:2:\"vm\";s:5:\"Vimeo\";s:2:\"pi\";s:9:\"Pinterest\";s:2:\"vk\";s:9:\"VKontakte\";s:2:\"da\";s:10:\"DeviantArt\";s:2:\"fl\";s:6:\"Flickr\";s:2:\"vi\";s:4:\"Vine\";s:2:\"tu\";s:6:\"Tumblr\";s:2:\"sk\";s:5:\"Skype\";s:2:\"gh\";s:6:\"GitHub\";s:2:\"hz\";s:5:\"Houzz\";s:2:\"px\";s:5:\"500px\";s:2:\"xi\";s:4:\"Xing\";s:2:\"sn\";s:8:\"Snapchat\";s:2:\"em\";s:5:\"Email\";s:2:\"yp\";s:4:\"Yelp\";s:2:\"ta\";s:11:\"TripAdvisor\";}}s:27:\"social_networks_target_attr\";s:6:\"_blank\";s:22:\"social_network_link_fb\";s:0:\"\";s:26:\"social_network_link_aparat\";s:0:\"\";s:28:\"social_network_link_telegram\";s:0:\"\";s:22:\"social_network_link_tw\";s:0:\"\";s:23:\"social_network_link_lin\";s:0:\"\";s:22:\"social_network_link_yt\";s:0:\"\";s:22:\"social_network_link_vm\";s:0:\"\";s:23:\"social_network_link_drb\";s:0:\"\";s:22:\"social_network_link_ig\";s:0:\"\";s:22:\"social_network_link_pi\";s:0:\"\";s:22:\"social_network_link_gp\";s:0:\"\";s:22:\"social_network_link_vk\";s:0:\"\";s:22:\"social_network_link_da\";s:0:\"\";s:22:\"social_network_link_tu\";s:0:\"\";s:22:\"social_network_link_be\";s:0:\"\";s:22:\"social_network_link_fl\";s:0:\"\";s:22:\"social_network_link_fs\";s:0:\"\";s:22:\"social_network_link_sk\";s:0:\"\";s:22:\"social_network_link_gh\";s:0:\"\";s:22:\"social_network_link_hz\";s:0:\"\";s:22:\"social_network_link_px\";s:0:\"\";s:22:\"social_network_link_vi\";s:0:\"\";s:22:\"social_network_link_sn\";s:0:\"\";s:22:\"social_network_link_yp\";s:0:\"\";s:22:\"social_network_link_ta\";s:0:\"\";s:22:\"social_network_link_em\";s:0:\"\";s:30:\"social_network_link_em_subject\";s:0:\"\";s:32:\"social_network_custom_link_title\";s:0:\"\";s:31:\"social_network_custom_link_link\";s:0:\"\";s:31:\"social_network_custom_link_icon\";s:0:\"\";s:12:\"story_status\";s:1:\"1\";s:14:\"tickets_status\";s:1:\"1\";s:24:\"tickets_in_dashbard_page\";s:1:\"1\";s:13:\"sp_post_types\";a:2:{s:7:\"enabled\";a:5:{s:7:\"placebo\";s:7:\"placebo\";s:4:\"post\";s:6:\"پست\";s:7:\"product\";s:10:\"محصول\";s:4:\"page\";s:8:\"برگه\";s:8:\"tp_event\";s:12:\"رویداد\";}s:8:\"disabled\";a:3:{s:7:\"placebo\";s:7:\"placebo\";s:7:\"teacher\";s:8:\"مدرس\";s:9:\"portfolio\";s:21:\"نمونه کارها\";}}s:17:\"sp_result_perpage\";s:1:\"9\";s:19:\"sc_custom_css_codes\";s:0:\"\";s:20:\"sc_remove_ver_css_js\";s:1:\"0\";s:28:\"sc_disable_gutenberg_widgets\";s:1:\"1\";s:29:\"sc_disable_gutenberg_in_posts\";s:0:\"\";s:28:\"sc_disable_admin_menu_button\";s:1:\"1\";s:31:\"sc_dequee_elementor_fontawesome\";s:1:\"1\";s:29:\"sc_top_notifbar_reset_cookies\";s:0:\"\";s:26:\"sc_preloader_microchip_hue\";i:153;s:16:\"product_no_image\";s:7:\"default\";s:21:\"prerequisites_enabled\";b:0;s:30:\"prerequisites_display_location\";s:7:\"in_tabs\";s:23:\"prerequisites_title_tag\";s:2:\"h4\";s:24:\"prerequisites_title_text\";s:19:\"پیش نیازها\";s:25:\"prerequisites_description\";s:0:\"\";s:26:\"studi_readmore_in_desktops\";i:0;s:28:\"studi_readmore_height_mobile\";i:260;s:29:\"studi_readmore_height_desktop\";i:340;s:21:\"studi_readmore_sticky\";i:1;s:21:\"studi_readmore_zindex\";i:10;s:30:\"studi_readmore_target_selector\";s:25:\".studi_pro_content_holder\";s:23:\"studi_readmore_color_bg\";s:7:\"#ffffff\";s:25:\"studi_readmore_color_text\";s:7:\"#0049f8\";s:27:\"studi_readmore_color_border\";s:7:\"#0049f8\";s:29:\"studi_readmore_color_fade_top\";a:2:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";i:0;}s:29:\"studi_readmore_color_fade_bot\";a:2:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";i:1;}s:21:\"enable_suncode_player\";b:0;s:12:\"disable_mejs\";b:0;s:18:\"enable_hls_support\";b:0;s:29:\"suncode_video_player_controls\";a:2:{s:7:\"enabled\";a:16:{s:10:\"play-large\";s:24:\"دکمه پخش بزرگ\";s:6:\"rewind\";s:15:\"عقب‌گرد\";s:4:\"play\";s:15:\"پخش/توقف\";s:12:\"fast-forward\";s:11:\"به جلو\";s:8:\"progress\";s:21:\"نوار پیمایش\";s:4:\"mute\";s:26:\"بی‌صدا/صدادار\";s:6:\"volume\";s:6:\"صدا\";s:8:\"captions\";s:24:\"زیرنویس‌‌ها\";s:7:\"airplay\";s:12:\"ایرپلی\";s:12:\"current-time\";s:17:\"زمان فعلی\";s:8:\"duration\";s:15:\"مدت زمان\";s:7:\"restart\";s:15:\"از ابتدا\";s:4:\"loop\";s:10:\"تکرار\";s:7:\"quality\";s:10:\"کیفیت\";s:8:\"settings\";s:14:\"تنظیمات\";s:10:\"fullscreen\";s:17:\"تمام صفحه\";}s:8:\"disabled\";a:2:{s:8:\"download\";s:12:\"دانلود\";s:3:\"pip\";s:26:\"تصویر در تصویر\";}}s:29:\"suncode_audio_player_controls\";a:2:{s:7:\"enabled\";a:7:{s:4:\"play\";s:15:\"پخش/توقف\";s:8:\"progress\";s:21:\"نوار پیمایش\";s:4:\"mute\";s:26:\"بی‌صدا/صدادار\";s:6:\"volume\";s:6:\"صدا\";s:8:\"settings\";s:14:\"تنظیمات\";s:12:\"current-time\";s:17:\"زمان فعلی\";s:8:\"duration\";s:15:\"مدت زمان\";}s:8:\"disabled\";a:6:{s:8:\"download\";s:12:\"دانلود\";s:7:\"restart\";s:15:\"از ابتدا\";s:6:\"rewind\";s:15:\"عقب‌گرد\";s:4:\"loop\";s:10:\"تکرار\";s:10:\"play-large\";s:24:\"دکمه پخش بزرگ\";s:12:\"fast-forward\";s:11:\"به جلو\";}}s:23:\"suncode_player_tooltips\";b:1;s:24:\"suncode_player_watermark\";s:8:\"disabled\";s:22:\"watermark_content_type\";s:12:\"display_name\";s:15:\"watermark_count\";i:1;s:19:\"watermark_min_speed\";i:30;s:19:\"watermark_max_speed\";i:60;s:18:\"enable_video_cover\";b:0;s:17:\"video_cover_image\";a:1:{s:3:\"url\";s:95:\"https://demo.studiaretheme.ir/academy/wp-content/themes/studiare/assets/images/video-cover.webp\";}s:19:\"login_redirect_type\";s:7:\"account\";s:25:\"login_custom_redirect_url\";s:0:\"\";s:19:\"email_login_enabled\";b:1;s:19:\"ippanel_api_address\";s:0:\"\";s:20:\"ippanel_pattern_code\";s:0:\"\";s:24:\"ippanel_pattern_variable\";s:0:\"\";s:20:\"farazsms_api_address\";s:0:\"\";s:21:\"farazsms_pattern_code\";s:0:\"\";s:25:\"farazsms_pattern_variable\";s:0:\"\";s:17:\"smsir_api_address\";s:0:\"\";s:18:\"smsir_pattern_code\";s:0:\"\";s:22:\"smsir_pattern_variable\";s:0:\"\";s:26:\"new_user_display_name_type\";s:6:\"mobile\";s:28:\"new_user_custom_display_name\";s:19:\"کاربر جدید\";s:11:\"chat_status\";b:0;s:12:\"chat_emojies\";b:0;s:8:\"chat_gif\";b:0;s:9:\"chat_file\";b:0;}","yes"),
("297","codebean_option-transients","a:5:{s:14:\"changed_values\";a:3:{s:19:\"single_post_related\";s:4:\"none\";s:10:\"rp_columns\";s:1:\"4\";s:29:\"sc_top_notifbar_reset_cookies\";s:0:\"\";}s:9:\"last_save\";i:1757130840;s:13:\"last_compiler\";i:1746089496;s:7:\"notices\";a:2:{s:6:\"errors\";a:0:{}s:8:\"sanitize\";a:0:{}}s:11:\"last_import\";i:1746089496;}","yes"),
("300","mc4wp_version","4.10.7","yes"),
("301","mc4wp_flash_messages","a:0:{}","off"),
("311","thimpress-event-version","2.1.7.2","yes"),
("312","thimpress_events_register_page_id","6","yes"),
("313","thimpress_events_login_page_id","7","yes"),
("314","thimpress_events_forgot_password_page_id","8","yes"),
("315","thimpress_events_reset_password_page_id","9","yes"),
("316","thimpress_events_account_page_id","10","yes"),
("322","widget_bbp_login_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("323","widget_bbp_views_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("324","widget_bbp_search_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("325","widget_bbp_forums_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("326","widget_bbp_topics_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("327","widget_bbp_replies_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("328","widget_bbp_stats_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("329","widget_wpems_widget_countdown","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("330","vc_version","6.7.0","yes"),
("333","_bbp_private_forums","a:0:{}","yes"),
("334","_bbp_hidden_forums","a:0:{}","yes"),
("335","_bbp_db_version","263","yes"),
("336","revslider-library-check","1757130261","yes"),
("338","rs_tables_created","1","yes"),
("340","revslider-global-settings","{\"permission\":\"admin\",\"lang\":\"fa_IR\",\"allinclude\":\"true\",\"highContrast\":\"false\",\"templateGuide\":\"false\",\"moduleGuide\":\"false\",\"includeids\":\"\",\"script\":{\"footer\":\"false\",\"defer\":\"false\",\"full\":\"false\",\"async\":\"false\"},\"imgcrossOrigin\":\"unset\",\"lazyloaddata\":\"\",\"fontdownload\":\"preload\",\"fontawesomedisable\":\"true\",\"onedpronmobile\":\"false\",\"forceLazyLoading\":\"smart\",\"forceViewport\":\"true\",\"lazyonbg\":\"false\",\"forcedViewportDistance\":\"-200px\",\"internalcaching\":\"false\",\"tracking\":\"2023-12-18\",\"trackingOnOff\":\"false\",\"fonturl\":\"\",\"size\":{\"desktop\":\"1240\",\"notebook\":\"1024\",\"tablet\":\"768\",\"mobile\":\"480\"},\"customfonts\":\"\",\"customFontList\":[{\"family\":\"\",\"url\":\"\",\"frontend\":\"false\",\"backend\":\"true\",\"weights\":\"200,300,400,500,600,700,800,900\"}],\"getTec\":{\"engine\":\"SR7\"}}","yes"),
("341","revslider_update_version","6.7.24","yes"),
("342","widget_rev-slider-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("351","recently_activated","a:0:{}","off"),
("360","rs_cache_overlay","1.0.0","yes"),
("375","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","off"),
("378","WPLANG","fa_IR","yes"),
("379","new_admin_email","bagher.pebs@yahoo.com","yes"),
("382","revslider-valid-notice","false","yes"),
("391","wpp_settings","a:17:{s:10:\"admin_lang\";s:6:\"enable\";s:9:\"user_lang\";s:6:\"enable\";s:12:\"submenu_move\";s:6:\"enable\";s:12:\"persian_date\";s:6:\"enable\";s:16:\"droidsans_editor\";s:7:\"disable\";s:15:\"droidsans_admin\";s:7:\"disable\";s:10:\"conv_title\";s:7:\"disable\";s:13:\"conv_contents\";s:7:\"disable\";s:12:\"conv_excerpt\";s:7:\"disable\";s:13:\"conv_comments\";s:7:\"disable\";s:18:\"conv_comment_count\";s:7:\"disable\";s:10:\"conv_dates\";s:7:\"disable\";s:9:\"conv_cats\";s:7:\"disable\";s:11:\"conv_arabic\";s:7:\"disable\";s:15:\"conv_permalinks\";s:6:\"enable\";s:11:\"news_source\";s:5:\"parsi\";s:15:\"conv_page_title\";s:7:\"disable\";}","yes"),
("392","widget_parsidate_archive","a:2:{i:2;a:4:{s:23:\"parsidate_archive_title\";s:14:\"بایگانی\";s:23:\"parsidate_archive_count\";i:0;s:22:\"parsidate_archive_list\";i:0;s:22:\"parsidate_archive_type\";s:7:\"monthly\";}s:12:\"_multiwidget\";i:1;}","yes"),
("393","widget_parsidate_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("402","woocommerce_product_type","both","yes"),
("403","woocommerce_allow_tracking","no","on"),
("404","woocommerce_ppec_paypal_settings","a:2:{s:16:\"reroute_requests\";b:0;s:5:\"email\";b:0;}","yes"),
("405","woocommerce_cheque_settings","a:1:{s:7:\"enabled\";s:2:\"no\";}","yes"),
("406","woocommerce_bacs_settings","a:1:{s:7:\"enabled\";s:3:\"yes\";}","yes"),
("407","woocommerce_cod_settings","a:1:{s:7:\"enabled\";s:2:\"no\";}","yes"),
("434","revslider-connection","1","yes"),
("435","revslider-latest-version","6.7.37","yes"),
("436","revslider-stable-version","4.2.0","yes"),
("437","revslider-notices","a:5:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-b.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-b.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":11:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:324:\"<style type=\"text/css\">#rs_ads_1 .rs_close_advert { display: none; } #rs_ads_1 { box-shadow: none !important; }</style>\n<iframe id=\"sr-notice-ad-iframe-wrapper\" \n        src=\"//updates.themepunch-ext-b.tools//banners/ads/ads.php\"\n        style=\"text-align: center; height:360px;width: 100%;\"\n        scrolling=\"no\"\n</iframe>\";s:4:\"code\";s:10:\"TPAD1_2025\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:2:\"id\";s:8:\"rs_ads_1\";s:10:\"additional\";a:0:{}}}","yes"),
("438","revslider-dashboard","a:0:{}","yes"),
("439","revslider-addons","O:8:\"stdClass\":36:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"559\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"558\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"567\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"551\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"568\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:6:\"6.7.31\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"6.7.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2025-01-17\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"545\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"569\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"555\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"552\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"553\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"556\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2025-01-15\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"547\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"550\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2024-12-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"554\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2024-12-06\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"562\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"616\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:6:\"6.7.21\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"575\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"549\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2025-02-18\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"564\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2024-12-19\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"571\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:81:\"//updates.themepunch-ext-b.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"560\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"561\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"566\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-shapeburst-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"613\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:26:\"revslider-shapeburst-addon\";s:12:\"version_from\";s:6:\"6.7.23\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"ShapeBurst\";s:6:\"line_1\";s:8:\"Shape...\";s:6:\"line_2\";s:9:\"and Burst\";s:9:\"available\";s:5:\"7.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"670\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_shape_burst.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_shape_burst.jpg\";s:7:\"img_md5\";s:32:\"2b1b6cb4613bdfcfff4c8c46660be8f5\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:1:{i:0;s:14:\"Visual Effects\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"570\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"548\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}","yes");

INSERT IGNORE INTO `wp_options` VALUES 
("522","PW_Options","a:16:{s:14:\"allowed_states\";s:3:\"all\";s:18:\"enable_iran_cities\";s:3:\"yes\";s:15:\"flip_state_city\";s:2:\"no\";s:15:\"fix_orders_list\";s:2:\"no\";s:24:\"enable_jalali_datepicker\";s:3:\"yes\";s:15:\"fix_load_states\";s:2:\"no\";s:27:\"fix_postcode_persian_number\";s:2:\"no\";s:19:\"postcode_validation\";s:2:\"no\";s:24:\"fix_phone_persian_number\";s:2:\"no\";s:16:\"phone_validation\";s:2:\"no\";s:27:\"remove_extra_field_physical\";s:3:\"yes\";s:21:\"super_admin_boost_woo\";s:2:\"no\";s:27:\"super_admin_boost_dashboard\";s:2:\"no\";s:24:\"super_admin_disable_core\";s:2:\"no\";s:27:\"super_admin_disable_plugins\";s:2:\"no\";s:26:\"super_admin_disable_themes\";s:2:\"no\";}","yes"),
("598","revslider_table_version","1.0.13","yes"),
("599","thimpress_events_allow_register_event","yes","yes"),
("600","thimpress_events_currency","IRT","yes"),
("601","thimpress_events_currency_position","right_space","yes"),
("602","thimpress_events_currency_thousand",",","yes"),
("603","thimpress_events_currency_separator",".","yes"),
("604","thimpress_events_currency_num_decimal","0","yes"),
("605","thimpress_events_google_map_api_key","","yes"),
("611","dbem_flush_needed","0","yes"),
("612","widget_em_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("613","widget_em_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("614","dbem_events_page","514","yes"),
("615","dbem_locations_page","515","yes"),
("616","dbem_categories_page","516","yes"),
("617","dbem_tags_page","517","yes"),
("618","dbem_my_bookings_page","518","yes"),
("619","dbem_hello_to_user","1","yes"),
("620","dbem_data","a:0:{}","yes"),
("621","dbem_time_format","g:i a","yes"),
("622","dbem_date_format","d/m/Y","yes"),
("623","dbem_date_format_js","yy/mm/dd","yes"),
("624","dbem_dates_separator"," - ","yes"),
("625","dbem_times_separator"," - ","yes"),
("626","dbem_default_category","0","yes"),
("627","dbem_default_location","0","yes"),
("628","dbem_events_default_orderby","event_start_date,event_start_time,event_name","yes"),
("629","dbem_events_default_order","ASC","yes"),
("630","dbem_events_default_limit","10","yes"),
("631","dbem_search_form_submit","جستجو","yes"),
("632","dbem_search_form_advanced","1","yes"),
("633","dbem_search_form_advanced_hidden","1","yes"),
("634","dbem_search_form_advanced_show","مشاهده جستجوی پیشرفته","yes"),
("635","dbem_search_form_advanced_hide","پنهان سازی جستجوی پیشرفته","yes"),
("636","dbem_search_form_text","1","yes"),
("637","dbem_search_form_text_label","جستجو","yes"),
("638","dbem_search_form_geo","1","yes"),
("639","dbem_search_form_geo_label","در حوالی ...","yes"),
("640","dbem_search_form_geo_units","1","yes"),
("641","dbem_search_form_geo_units_label","Within","yes"),
("642","dbem_search_form_geo_unit_default","mi","yes"),
("643","dbem_search_form_geo_distance_default","25","yes"),
("644","dbem_search_form_geo_distance_options","5,10,25,50,100","yes"),
("645","dbem_search_form_dates","1","yes"),
("646","dbem_search_form_dates_label","تاریخ","yes"),
("647","dbem_search_form_dates_separator","و","yes"),
("648","dbem_search_form_categories","1","yes"),
("649","dbem_search_form_categories_label","همه دسته بندی ها","yes"),
("650","dbem_search_form_category_label","دسته بندی","yes"),
("651","dbem_search_form_countries","1","yes"),
("652","dbem_search_form_default_country","","yes"),
("653","dbem_search_form_countries_label","همه کشورها","yes"),
("654","dbem_search_form_country_label","کشور","yes"),
("655","dbem_search_form_regions","1","yes"),
("656","dbem_search_form_regions_label","همه مناطق","yes"),
("657","dbem_search_form_region_label","منطقه","yes"),
("658","dbem_search_form_states","1","yes"),
("659","dbem_search_form_states_label","همه استان ها","yes"),
("660","dbem_search_form_state_label","استان / ایالت","yes"),
("661","dbem_search_form_towns","0","yes"),
("662","dbem_search_form_towns_label","همه شهرها","yes"),
("663","dbem_search_form_town_label","شهر / شهرستان","yes"),
("664","dbem_events_form_editor","1","yes"),
("665","dbem_events_form_reshow","1","yes"),
("666","dbem_events_form_result_success","رویداد شما که در انتظار تایید جهت انتشار بود، با موفقیت تایید شد.","yes"),
("667","dbem_events_form_result_success_updated","رویداد شما که در انتظار برای بازنشر بود، با موفقیت بروزرسانی شد.","yes"),
("668","dbem_events_anonymous_submissions","0","yes"),
("669","dbem_events_anonymous_user","0","yes"),
("670","dbem_events_anonymous_result_success","رویداد شما که در انتظار تایید جهت انتشار بود، با موفقیت تایید شد.","yes"),
("671","dbem_event_submitted_email_admin","","yes"),
("672","dbem_event_submitted_email_subject","رویدادهای تایید شدۀ در حال انتظار","yes"),
("673","dbem_event_submitted_email_body","رویداد جدیدی جهت نمایش ارسال شده است. اطلاعات رویداد به شرح زیر است: \n\rدرخواست کننده:   #_CONTACTNAME \n\r نام رویداد :  #_EVENTNAME  \n\r تاریخ برگزاری:  #_EVENTDATES   \n\r زمان برگزاری :  #_EVENTTIMES  \n\r لطفاً این لینک را برای تایید انتشار رویداد ملاحظه فرمایید:   https://demo.studiaretheme.ir/academy/wp-admin/post.php?action=edit&post=#_EVENTPOSTID\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("674","dbem_event_resubmitted_email_subject","رویدادهای باز تایید شدۀ در حال انتظار","yes"),
("675","dbem_event_resubmitted_email_body","رویدادی که قبلاً منتشر شده بود، ویرایش شده است. این رویداد به حالت معلق درآمده است تا شما اجازه انتشار دهید. اطلاعات رویداد به شرح زیر است: \n\rدرخواست کننده:   #_CONTACTNAME \n\r نام رویداد :  #_EVENTNAME  \n\r تاریخ برگزاری:  #_EVENTDATES   \n\r زمان برگزاری :  #_EVENTTIMES  \n\r لطفاً این لینک را برای تایید انتشار رویداد ملاحظه فرمایید:   https://demo.studiaretheme.ir/academy/wp-admin/post.php?action=edit&post=#_EVENTPOSTID\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("676","dbem_event_published_email_subject","رویدادهای منتشر شده - #_EVENTNAME","yes"),
("677","dbem_event_published_email_body","رویداد جدیدی جهت نمایش منتشر شده است. اطلاعات رویداد به شرح زیر است: \n\rمنتشر کننده:   #_CONTACTNAME \n\r نام رویداد :  #_EVENTNAME  \n\r تاریخ برگزاری:  #_EVENTDATES   \n\r زمان برگزاری :  #_EVENTTIMES  \n\r لینک ویرایش رویداد :   https://demo.studiaretheme.ir/academy/wp-admin/post.php?action=edit&post=#_EVENTPOSTID \n\r لینک مشاهده رویداد: #_EVENTURL\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("678","dbem_event_approved_email_subject","رویداد اجازه انتشار دارد - #_EVENTNAME","yes"),
("679","dbem_event_approved_email_body","کاربر گرامی #_CONTACTNAME ، \n\r رویداد شما با اطلاعات زیر تایید شده است: \n\r نام رویداد :  #_EVENTNAME   \n\r تاریخ برگزاری:   #_EVENTDATES  \n\r شما می توانید رویداد خود را در این آدرس ببینید: #_EVENTURL\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("680","dbem_event_reapproved_email_subject","رویداد اجازه انتشار دارد - #_EVENTNAME","yes"),
("681","dbem_event_reapproved_email_body","کاربر گرامی #_CONTACTNAME ، \n\r رویداد شما با اطلاعات زیر تایید شده است: \n\r نام رویداد :  #_EVENTNAME   \n\r تاریخ برگزاری:   #_EVENTDATES  \n\r شما می توانید رویداد خود را در این آدرس ببینید: #_EVENTURL\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("682","dbem_events_page_title","رویدادها","yes"),
("683","dbem_events_page_scope","future","yes"),
("684","dbem_events_page_search_form","1","yes"),
("685","dbem_event_list_item_format_header","<table class=\"events-table\" >\r\n    <thead>\r\n        <tr>\r\n			<th class=\"event-time\" scope=\"col\">تاریخ / زمان</th>\r\n			<th class=\"event-description\" scope=\"col\">رویداد</th>\r\n		</tr>\r\n   	</thead>\r\n    <tbody>","yes"),
("686","dbem_event_list_item_format","<tr>\r\n			<td>\r\n                #_EVENTDATES<br/>\r\n                #_EVENTTIMES\r\n            </td>\r\n            <td>\r\n                #_EVENTLINK\r\n                {has_location}<br/><i>#_LOCATIONNAME, #_LOCATIONTOWN #_LOCATIONSTATE</i>{/has_location}\r\n            </td>\r\n        </tr>","yes"),
("687","dbem_event_list_item_format_footer","</tbody></table>","yes"),
("688","dbem_event_list_groupby","0","yes"),
("689","dbem_event_list_groupby_format","","yes"),
("690","dbem_event_list_groupby_header_format","<h2>#s</h2>","yes"),
("691","dbem_display_calendar_in_events_page","0","yes"),
("692","dbem_single_event_format","<div style=\"float:right; margin:0px 0px 15px 15px;\">#_LOCATIONMAP</div>\r\n<p>\r\n	<strong>تاریخ / زمان</strong><br/>\r\n	Date(s) - #_EVENTDATES<br /><i>#_EVENTTIMES</i>\r\n</p>\r\n{has_location}\r\n<p>\r\n	<strong>مکان</strong><br/>\r\n	#_LOCATIONLINK\r\n</p>\r\n{/has_location}\r\n<p>\r\n	<strong>دسته بندی ها</strong>\r\n	#_CATEGORIES\r\n</p>\r\n<br style=\"clear:both\" />\r\n#_EVENTNOTES\r\n{has_bookings}\r\n<h3>ثبت نامی ها</h3>\r\n#_BOOKINGFORM\r\n{/has_bookings}","yes"),
("693","dbem_event_excerpt_format","#_EVENTDATES @ #_EVENTTIMES - #_EVENTEXCERPT","yes"),
("694","dbem_event_excerpt_alt_format","#_EVENTDATES @ #_EVENTTIMES - #_EVENTEXCERPT{55}","yes"),
("695","dbem_event_page_title_format","#_EVENTNAME","yes"),
("696","dbem_event_all_day_message","هر روزه","yes"),
("697","dbem_no_events_message","هیچ رویدادها","yes"),
("698","dbem_locations_default_orderby","location_name","yes"),
("699","dbem_locations_default_order","ASC","yes"),
("700","dbem_locations_default_limit","10","yes"),
("701","dbem_locations_page_title","رویداد مکان ها","yes"),
("702","dbem_locations_page_search_form","1","yes"),
("703","dbem_no_locations_message","هیچ مکان ها","yes"),
("704","dbem_location_default_country","","yes"),
("705","dbem_location_list_item_format_header","<ul class=\"em-locations-list\">","yes"),
("706","dbem_location_list_item_format","<li>#_LOCATIONLINK<ul><li>#_LOCATIONFULLLINE</li></ul></li>","yes"),
("707","dbem_location_list_item_format_footer","</ul>","yes"),
("708","dbem_location_page_title_format","#_LOCATIONNAME","yes"),
("709","dbem_single_location_format","<div style=\"float:right; margin:0px 0px 15px 15px;\">#_LOCATIONMAP</div>\r\n<p>\r\n	<strong>نشانی</strong><br/>\r\n	#_LOCATIONADDRESS<br/>\r\n	#_LOCATIONTOWN<br/>\r\n	#_LOCATIONSTATE<br/>\r\n	#_LOCATIONREGION<br/>\r\n	#_LOCATIONPOSTCODE<br/>\r\n	#_LOCATIONCOUNTRY\r\n</p>\r\n<br style=\"clear:both\" />\r\n#_LOCATIONNOTES\r\n\r\n<h3>رویدادهای اخیر</h3>\r\n<p>#_LOCATIONNEXTEVENTS</p>","yes"),
("710","dbem_location_excerpt_format","#_LOCATIONEXCERPT","yes"),
("711","dbem_location_excerpt_alt_format","#_LOCATIONEXCERPT{55}","yes"),
("712","dbem_location_no_events_message","<li>رویدادی در این مکان وجود ندارد.</li>","yes"),
("713","dbem_location_event_list_item_header_format","<ul>","yes"),
("714","dbem_location_event_list_item_format","<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES</li>","yes"),
("715","dbem_location_event_list_item_footer_format","</ul>","yes"),
("716","dbem_location_event_list_limit","20","yes"),
("717","dbem_location_event_list_orderby","event_start_date,event_start_time,event_name","yes"),
("718","dbem_location_event_list_order","ASC","yes"),
("719","dbem_location_event_single_format","#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES","yes"),
("720","dbem_location_no_event_message","رویدادی در این مکان وجود ندارد.","yes"),
("721","dbem_categories_default_limit","10","yes"),
("722","dbem_categories_default_orderby","name","yes"),
("723","dbem_categories_default_order","ASC","yes"),
("724","dbem_categories_list_item_format_header","<ul class=\"em-categories-list\">","yes"),
("725","dbem_categories_list_item_format","<li>#_CATEGORYLINK</li>","yes"),
("726","dbem_categories_list_item_format_footer","</ul>","yes"),
("727","dbem_no_categories_message","هیچ دسته بندی ها","yes"),
("728","dbem_category_page_title_format","#_CATEGORYNAME","yes"),
("729","dbem_category_page_format","#_CATEGORYNOTES<h3>رویدادهای اخیر</h3>#_CATEGORYNEXTEVENTS","yes"),
("730","dbem_category_no_events_message","<li>رویدادی در این دسته بندی وجود ندارد.</li>","yes"),
("731","dbem_category_event_list_item_header_format","<ul>","yes"),
("732","dbem_category_event_list_item_format","<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES</li>","yes"),
("733","dbem_category_event_list_item_footer_format","</ul>","yes"),
("734","dbem_category_event_list_limit","20","yes"),
("735","dbem_category_event_list_orderby","event_start_date,event_start_time,event_name","yes"),
("736","dbem_category_event_list_order","ASC","yes"),
("737","dbem_category_event_single_format","#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES","yes"),
("738","dbem_category_no_event_message","رویدادی در این دسته بندی وجود ندارد.","yes"),
("739","dbem_category_default_color","#a8d144","yes"),
("740","dbem_tags_default_limit","10","yes"),
("741","dbem_tags_default_orderby","name","yes"),
("742","dbem_tags_default_order","ASC","yes"),
("743","dbem_tags_list_item_format_header","<ul class=\"em-tags-list\">","yes"),
("744","dbem_tags_list_item_format","<li>#_TAGLINK</li>","yes"),
("745","dbem_tags_list_item_format_footer","</ul>","yes"),
("746","dbem_no_tags_message","هیچ تگ ها","yes"),
("747","dbem_tag_page_title_format","#_TAGNAME","yes"),
("748","dbem_tag_page_format","<h3>رویدادهای اخیر</h3>#_TAGNEXTEVENTS","yes"),
("749","dbem_tag_no_events_message","<li>رویدادی با این کلید واژه وجود ندارد.</li>","yes"),
("750","dbem_tag_event_list_item_header_format","<ul class=\"em-tags-list\">","yes"),
("751","dbem_tag_event_list_item_format","<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES</li>","yes"),
("752","dbem_tag_event_list_item_footer_format","</ul>","yes"),
("753","dbem_tag_event_single_format","#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES","yes"),
("754","dbem_tag_no_event_message","رویدادی با این کلید واژه وجود ندارد.","yes"),
("755","dbem_tag_event_list_limit","20","yes"),
("756","dbem_tag_event_list_orderby","event_start_date,event_start_time,event_name","yes"),
("757","dbem_tag_event_list_order","ASC","yes"),
("758","dbem_tag_default_color","#a8d145","yes"),
("759","dbem_rss_limit","50","yes"),
("760","dbem_rss_scope","future","yes"),
("761","dbem_rss_main_title","قالب آموزش آنلاین studiare وردپرس - رویدادها","yes"),
("762","dbem_rss_main_description"," - رویدادها","yes"),
("763","dbem_rss_description_format","#_EVENTDATES - #_EVENTTIMES <br/>#_LOCATIONNAME <br/>#_LOCATIONADDRESS <br/>#_LOCATIONTOWN","yes"),
("764","dbem_rss_title_format","#_EVENTNAME","yes"),
("765","dbem_rss_order","ASC","yes"),
("766","dbem_rss_orderby","event_start_date,event_start_time,event_name","yes"),
("767","em_rss_pubdate","Thu, 27 Sep 2018 12:28:34 +0000","yes"),
("768","dbem_ical_limit","50","yes"),
("769","dbem_ical_scope","future","yes"),
("770","dbem_ical_description_format","#_EVENTNAME","yes"),
("771","dbem_ical_real_description_format","#_EVENTEXCERPT","yes"),
("772","dbem_ical_location_format","#_LOCATIONNAME, #_LOCATIONFULLLINE, #_LOCATIONCOUNTRY","yes"),
("773","dbem_gmap_is_active","1","yes"),
("774","dbem_google_maps_browser_key","","yes"),
("775","dbem_map_default_width","400px","yes"),
("776","dbem_map_default_height","300px","yes"),
("777","dbem_location_baloon_format","<strong>#_LOCATIONNAME</strong><br/>#_LOCATIONADDRESS - #_LOCATIONTOWN<br/><a href=\"#_LOCATIONPAGEURL\">رویدادها</a>","yes"),
("778","dbem_map_text_format","<strong>#_LOCATIONNAME</strong><p>#_LOCATIONADDRESS</p><p>#_LOCATIONTOWN</p>","yes"),
("779","dbem_email_disable_registration","0","yes"),
("780","dbem_rsvp_mail_port","465","yes"),
("781","dbem_smtp_host","localhost","yes"),
("782","dbem_mail_sender_name","","yes"),
("783","dbem_rsvp_mail_send_method","wp_mail","yes"),
("784","dbem_rsvp_mail_SMTPAuth","1","yes"),
("785","dbem_smtp_html","1","yes"),
("786","dbem_smtp_html_br","1","yes"),
("787","dbem_image_max_width","700","yes"),
("788","dbem_image_max_height","700","yes"),
("789","dbem_image_min_width","50","yes"),
("790","dbem_image_min_height","50","yes"),
("791","dbem_image_max_size","204800","yes"),
("792","dbem_list_date_title","رویدادها - #j #M #y","yes"),
("793","dbem_full_calendar_month_format","M Y","yes"),
("794","dbem_full_calendar_event_format","<li>#_EVENTLINK</li>","yes"),
("795","dbem_full_calendar_long_events","0","yes"),
("796","dbem_full_calendar_initials_length","0","yes"),
("797","dbem_full_calendar_abbreviated_weekdays","1","yes"),
("798","dbem_display_calendar_day_single_yes","1","yes"),
("799","dbem_small_calendar_month_format","M Y","yes"),
("800","dbem_small_calendar_event_title_format","#_EVENTNAME","yes"),
("801","dbem_small_calendar_event_title_separator",", ","yes"),
("802","dbem_small_calendar_initials_length","1","yes"),
("803","dbem_small_calendar_abbreviated_weekdays","","yes"),
("804","dbem_small_calendar_long_events","0","yes"),
("805","dbem_display_calendar_order","ASC","yes"),
("806","dbem_display_calendar_orderby","event_name,event_start_time","yes"),
("807","dbem_display_calendar_events_limit","3","yes"),
("808","dbem_display_calendar_events_limit_msg","بیشتر...","yes"),
("809","dbem_calendar_direct_links","1","yes"),
("810","dbem_timezone_enabled","1","yes"),
("811","dbem_timezone_default","Asia/Tehran","yes"),
("812","dbem_require_location","0","yes"),
("813","dbem_locations_enabled","1","yes"),
("814","dbem_use_select_for_locations","0","yes"),
("815","dbem_attributes_enabled","1","yes"),
("816","dbem_recurrence_enabled","1","yes"),
("817","dbem_rsvp_enabled","1","yes"),
("818","dbem_categories_enabled","1","yes"),
("819","dbem_tags_enabled","1","yes"),
("820","dbem_placeholders_custom","","yes"),
("821","dbem_location_attributes_enabled","1","yes"),
("822","dbem_location_placeholders_custom","","yes"),
("823","dbem_bookings_registration_disable","0","yes"),
("824","dbem_bookings_registration_disable_user_emails","0","yes"),
("825","dbem_bookings_approval","1","yes"),
("826","dbem_bookings_approval_reserved","0","yes"),
("827","dbem_bookings_approval_overbooking","0","yes"),
("828","dbem_bookings_double","0","yes"),
("829","dbem_bookings_user_cancellation","1","yes"),
("830","dbem_bookings_currency","USD","yes"),
("831","dbem_bookings_currency_decimal_point","٫","yes"),
("832","dbem_bookings_currency_thousands_sep",",","yes"),
("833","dbem_bookings_currency_format","@#","yes"),
("834","dbem_bookings_tax","0","yes"),
("835","dbem_bookings_tax_auto_add","0","yes"),
("836","dbem_bookings_submit_button","ارسال ثبت نام شما","yes"),
("837","dbem_bookings_login_form","1","yes"),
("838","dbem_bookings_anonymous","1","yes"),
("839","dbem_bookings_form_max","20","yes"),
("840","dbem_bookings_form_msg_disabled","ثبت نام آنلاین برای این رویداد فعال نیست.","yes"),
("841","dbem_bookings_form_msg_closed","ثبت نام برای این رویداد بسته شده است.","yes"),
("842","dbem_bookings_form_msg_full","ظرفیت ثبت نام این رویداد کامل شده است.","yes"),
("843","dbem_bookings_form_msg_attending","شما قبلاً این رویداد را ثبت نام کرده اید.","yes"),
("844","dbem_bookings_form_msg_bookings_link","مدیریت ثبت نامی های من","yes"),
("845","dbem_booking_warning_cancel","آیا از انصراف خود در این رویداد مطمئن هستید؟","yes"),
("846","dbem_booking_feedback_cancelled","ثبت نام منصرف شده","yes"),
("847","dbem_booking_feedback_pending","ثبت نام موفقیت آمیز بود، در حال بررسی است (پس از تایید شما ایمیلی دریافت خواهید کرد).","yes"),
("848","dbem_booking_feedback","ثبت نام موفقیت آمیز بود.","yes"),
("849","dbem_booking_feedback_full","فضای کافی برای ثبت نام جدید وجود ندارد!","yes"),
("850","dbem_booking_feedback_log_in","شما بایستی برای ثبت نام وارد شوید یا ثبت نام کنید.","yes"),
("851","dbem_booking_feedback_nomail","ممکن است، مشکلاتی در ارسال ایمیل تایید برای شما یا شخص مالک رویداد وجود داشته باشد. می توانید مستقیماً با مدیریت سایت تماس بگیرید و آنها را از این خطا مطلع سازید.","yes"),
("852","dbem_booking_feedback_error","ثبت نام نمی تواند ساخته شود.:","yes"),
("853","dbem_booking_feedback_email_exists","این ایمیل هنوز در سیستم ما وجود دارد، لطفاً برای تکمیل ثبت نام خود وارد شوید.","yes"),
("854","dbem_booking_feedback_new_user","شناسه کاربری جدیدی برای شما ساخته شده است. لطفاً ایمیل خود را برای جزئیات ورود به حساب چک کنید.","yes"),
("855","dbem_booking_feedback_reg_error","خطایی در هنگام ساختن حساب کاربری جدید وجود دارد. لطفاً با مدیریت سایت تماس بگیرید.","yes"),
("856","dbem_booking_feedback_already_booked","شما قبلاً در این رویداد فضایی را گرفته اید.","yes"),
("857","dbem_booking_feedback_min_space","شما حداقل بایستی یک فضا برای ثبت نام در این رویداد درخواست کنید.","yes"),
("858","dbem_booking_feedback_spaces_limit","شما نمی توانید بیشتر از %d فضا برای ثبت نام در این رویداد درخواست کنید.","yes"),
("859","dbem_booking_button_msg_book","الان ثبت نام کن","yes"),
("860","dbem_booking_button_msg_booking","ثبت نام...","yes"),
("861","dbem_booking_button_msg_booked","ثبت نام تایید شد.","yes"),
("862","dbem_booking_button_msg_already_booked","قبلاً ثبت نام شده","yes"),
("863","dbem_booking_button_msg_error","خطای ثبت نام، تلاش مجدد؟","yes"),
("864","dbem_booking_button_msg_full","فروخته شده است","yes"),
("865","dbem_booking_button_msg_closed","ثبت نام بسته شده است.","yes"),
("866","dbem_booking_button_msg_cancel","انصراف","yes"),
("867","dbem_booking_button_msg_canceling","انصراف...","yes"),
("868","dbem_booking_button_msg_cancelled","منصرف شده","yes"),
("869","dbem_booking_button_msg_cancel_error","خطای انصراف، تلاش مجدد؟","yes"),
("870","dbem_bookings_notify_admin","0","yes"),
("871","dbem_bookings_contact_email","1","yes"),
("872","dbem_bookings_contact_email_pending_subject","ثبت نام در حال انتظار","yes"),
("873","dbem_bookings_contact_email_pending_body","The following booking is در حال انتظار :\n\r#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES\n\rNow there are #_BOOKEDSPACES spaces reserved, #_AVAILABLESPACES are still available.\n\rجزئیات ثبت نام\n\rنام : #_BOOKINGNAME\n\rایمیل : #_BOOKINGEMAIL\n\r#_BOOKINGSUMMARY\n\r\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("874","dbem_bookings_contact_email_confirmed_subject","ثبت نام تایید شده","yes"),
("875","dbem_bookings_contact_email_confirmed_body","The following booking is تایید شده :\n\r#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES\n\rNow there are #_BOOKEDSPACES spaces reserved, #_AVAILABLESPACES are still available.\n\rجزئیات ثبت نام\n\rنام : #_BOOKINGNAME\n\rایمیل : #_BOOKINGEMAIL\n\r#_BOOKINGSUMMARY\n\r\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("876","dbem_bookings_contact_email_rejected_subject","ثبت نام رد شده","yes"),
("877","dbem_bookings_contact_email_rejected_body","The following booking is رد شده :\n\r#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES\n\rNow there are #_BOOKEDSPACES spaces reserved, #_AVAILABLESPACES are still available.\n\rجزئیات ثبت نام\n\rنام : #_BOOKINGNAME\n\rایمیل : #_BOOKINGEMAIL\n\r#_BOOKINGSUMMARY\n\r\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("878","dbem_bookings_contact_email_cancelled_subject","ثبت نام منصرف شده","yes"),
("879","dbem_bookings_contact_email_cancelled_body","The following booking is منصرف شده :\n\r#_EVENTNAME - #_EVENTDATES @ #_EVENTTIMES\n\rNow there are #_BOOKEDSPACES spaces reserved, #_AVAILABLESPACES are still available.\n\rجزئیات ثبت نام\n\rنام : #_BOOKINGNAME\n\rایمیل : #_BOOKINGEMAIL\n\r#_BOOKINGSUMMARY\n\r\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("880","dbem_bookings_email_pending_subject","ثبت نام در حال انتظار","yes"),
("881","dbem_bookings_email_pending_body","کاربر گرامی، #_BOOKINGNAME ؛ \n\r شما درخواستی با مشخصات مندرج در ذیل برای شرکت در یک رویداد را داده اید. درخواست شما در حال حاضر معلق است تا به وسیله مدیریت تایید شود. به محض تایید توسط مدیریت، ایمیلی مبنی بر اجازه تایید ثبت نام شما ارسال خواهد شد. \n\r فضای درخواستی در رویداد: #_BOOKINGSPACES  \n\r نام رویداد: #_EVENTNAME \n\r زمان برگزاری:  #_EVENTDATES @ #_EVENTTIMES \n\r محل برگزاری: #_LOCATIONNAME - #_LOCATIONFULLLINE \n\r با آرزوی موفقیت \n\r #_CONTACTNAME\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("882","dbem_bookings_email_rejected_subject","ثبت نام رد شده","yes"),
("883","dbem_bookings_email_rejected_body","کاربر گرامی #_BOOKINGNAME, \n\r درخواست شما برای شرکت در رویدادی که اطلاعات آن در ذیل مندرج است، رد شده است. \n\r تعداد فضای درخواستی:   #_BOOKINGSPACES   \n\r نام رویداد:   #_EVENTNAME  \n\r تاریخ برگزاری رویداد:  #_EVENTDATES  \n\r با احترام، \n\r  #_CONTACTNAME\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("884","dbem_bookings_email_confirmed_subject","ثبت نام تایید شده","yes"),
("885","dbem_bookings_email_confirmed_body","کاربر گرامی، #_BOOKINGNAME ؛ \n\r شما با موفقیت #_BOOKINGSPACES فضا برای رویداد #_EVENTNAME را رزرو کردید. \n\r زمان برگزاری رویداد:  #_EVENTDATES @ #_EVENTTIMES \n\r محل برگزاری رویداد: #_LOCATIONNAME - #_LOCATIONFULLLINE \n\r با آرزوی موفقیت، \n\r #_CONTACTNAME\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("886","dbem_bookings_email_cancelled_subject","ثبت نام منصرف شده","yes"),
("887","dbem_bookings_email_cancelled_body","کاربر گرامی #_BOOKINGNAME, \n\r درخواست شما برای شرکت در رویدادی که اطلاعات آن در ذیل مندرج است، لغو شده است. \n\r تعداد فضای درخواستی:   #_BOOKINGSPACES   \n\r نام رویداد:   #_EVENTNAME  \n\r تاریخ برگزاری رویداد:  #_EVENTDATES  \n\r با احترام، \n\r  #_CONTACTNAME\n\r\n\r-------------------------------\n\rPowered by Events Manager - http://wp-events-plugin.com","yes"),
("888","dbem_bookings_email_registration_subject","[قالب آموزش آنلاین studiare وردپرس] شناسه کاربری و رمز عبور شما","yes"),
("889","dbem_bookings_email_registration_body","شما با موفقیت حساب کاربری در قالب آموزش آنلاین studiare وردپرس ساختید.\n\rشما می توانید به سایت خود از طریق آدرس https://demo.studiaretheme.ir/academy/wp-login.php وارد شوید.\n\rشناسه کاربری : %username%\n\rگذرواژه : %password%\n\rبرای مشاهدۀ ثبت نامی های خود، لطفاً پس از ورود به https://demo.studiaretheme.ir/academy/%d8%b1%d9%88%db%8c%d8%af%d8%a7%d8%af%d9%87%d8%a7-2/%d8%ab%d8%a8%d8%aa-%d9%86%d8%a7%d9%85-%d9%87%d8%a7%db%8c-%d9%85%d9%86/ مراجعه کنید.","yes"),
("890","dbem_bookings_tickets_orderby","ticket_price DESC, ticket_name ASC","yes"),
("891","dbem_bookings_tickets_priority","0","yes"),
("892","dbem_bookings_tickets_show_unavailable","0","yes"),
("893","dbem_bookings_tickets_show_loggedout","1","yes"),
("894","dbem_bookings_tickets_single","0","yes"),
("895","dbem_bookings_tickets_single_form","0","yes"),
("896","dbem_bookings_my_title_format","ثبت نام های من","yes"),
("897","dbem_bp_events_list_format_header","<ul class=\"em-events-list\">","yes"),
("898","dbem_bp_events_list_format","<li>#_EVENTLINK - #_EVENTDATES - #_EVENTTIMES<ul><li>#_LOCATIONLINK - #_LOCATIONADDRESS, #_LOCATIONTOWN</li></ul></li>","yes"),
("899","dbem_bp_events_list_format_footer","</ul>","yes"),
("900","dbem_bp_events_list_none_format","<p class=\"em-events-list\">هیچ رویدادی نیست</p>","yes"),
("901","dbem_css_editors","1","yes"),
("902","dbem_css_rsvp","1","yes"),
("903","dbem_css_rsvpadmin","1","yes"),
("904","dbem_css_evlist","1","yes"),
("905","dbem_css_search","1","yes"),
("906","dbem_css_loclist","1","yes"),
("907","dbem_css_catlist","1","yes"),
("908","dbem_css_taglist","1","yes"),
("909","dbem_cp_events_slug","events","yes"),
("910","dbem_cp_locations_slug","locations","yes"),
("911","dbem_taxonomy_category_slug","events/categories","yes"),
("912","dbem_taxonomy_tag_slug","events/tags","yes"),
("913","dbem_cp_events_template","","yes"),
("914","dbem_cp_events_body_class","","yes"),
("915","dbem_cp_events_post_class","","yes"),
("916","dbem_cp_events_formats","1","yes"),
("917","dbem_cp_events_has_archive","1","yes"),
("918","dbem_events_default_archive_orderby","_event_start","yes"),
("919","dbem_events_default_archive_order","ASC","yes"),
("920","dbem_events_archive_scope","past","yes"),
("921","dbem_cp_events_archive_formats","1","yes"),
("922","dbem_cp_events_excerpt_formats","1","yes"),
("923","dbem_cp_events_search_results","0","yes"),
("924","dbem_cp_events_custom_fields","0","yes"),
("925","dbem_cp_events_comments","1","yes"),
("926","dbem_cp_locations_template","","yes"),
("927","dbem_cp_locations_body_class","","yes"),
("928","dbem_cp_locations_post_class","","yes"),
("929","dbem_cp_locations_formats","1","yes"),
("930","dbem_cp_locations_has_archive","1","yes"),
("931","dbem_locations_default_archive_orderby","title","yes"),
("932","dbem_locations_default_archive_order","ASC","yes"),
("933","dbem_cp_locations_archive_formats","1","yes"),
("934","dbem_cp_locations_excerpt_formats","1","yes"),
("935","dbem_cp_locations_search_results","0","yes"),
("936","dbem_cp_locations_custom_fields","0","yes"),
("937","dbem_cp_locations_comments","1","yes"),
("938","dbem_cp_categories_formats","1","yes"),
("939","dbem_categories_default_archive_orderby","event_start_date,event_start_time,event_name","yes"),
("940","dbem_categories_default_archive_order","ASC","yes"),
("941","dbem_cp_tags_formats","1","yes"),
("942","dbem_tags_default_archive_orderby","event_start_date,event_start_time,event_name","yes"),
("943","dbem_tags_default_archive_order","ASC","yes"),
("944","dbem_disable_thumbnails","","yes"),
("945","dbem_feedback_reminder","1538051315","yes"),
("946","dbem_events_page_ajax","0","yes"),
("947","dbem_conditional_recursions","1","yes"),
("948","dbem_data_privacy_consent_text","I consent to my submitted data being collected and stored as outlined by the site %s.","yes"),
("949","dbem_data_privacy_consent_remember","1","yes"),
("950","dbem_data_privacy_consent_events","1","yes"),
("951","dbem_data_privacy_consent_locations","1","yes"),
("952","dbem_data_privacy_consent_bookings","1","yes"),
("953","dbem_data_privacy_export_events","1","yes"),
("954","dbem_data_privacy_export_locations","1","yes"),
("955","dbem_data_privacy_export_bookings","1","yes"),
("956","dbem_data_privacy_erase_events","1","yes"),
("957","dbem_data_privacy_erase_locations","1","yes"),
("958","dbem_data_privacy_erase_bookings","1","yes"),
("959","dbem_time_24h","1","yes"),
("960","dbem_credits","1","yes"),
("961","dbem_version","5.95","yes"),
("962","widget_em_locations_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("991","mc4wp","a:4:{s:7:\"api_key\";s:0:\"\";s:20:\"allow_usage_tracking\";i:0;s:15:\"debug_log_level\";s:7:\"warning\";s:18:\"first_activated_on\";i:1538088138;}","yes"),
("992","mc4wp_form_stylesheets","a:0:{}","yes"),
("993","mc4wp_default_form_id","380","yes"),
("1156","rs-library","a:3:{s:4:\"hash\";s:32:\"324e6ba47fb68dfb7f1bd5b0b203bdc5\";s:7:\"objects\";a:417:{i:0;a:13:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14130;s:4:\"orig\";i:220294;}}i:1;a:13:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:27127;s:4:\"orig\";i:1192484;}}i:2;a:13:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:1745;s:4:\"orig\";i:36243;}}i:3;a:13:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10511;s:4:\"orig\";i:102067;}}i:4;a:13:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18581;s:4:\"orig\";i:776243;}}i:5;a:13:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4745;s:4:\"orig\";i:330658;}}i:6;a:13:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4461;s:4:\"orig\";i:109963;}}i:7;a:13:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6790;s:4:\"orig\";i:407746;}}i:8;a:13:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18710;s:4:\"orig\";i:985569;}}i:9;a:13:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6113;s:4:\"orig\";i:75865;}}i:10;a:13:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8145;s:4:\"orig\";i:400329;}}i:11;a:13:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5251;s:4:\"orig\";i:358141;}}i:12;a:13:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:127536;s:4:\"orig\";i:838279;}}i:13;a:13:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4081;s:4:\"orig\";i:22391;}}i:14;a:13:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9331;s:4:\"orig\";i:516465;}}i:15;a:13:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:463818;}}i:16;a:13:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6359;s:4:\"orig\";i:102578;}}i:17;a:13:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22078;s:4:\"orig\";i:1107904;}}i:18;a:13:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15660;s:4:\"orig\";i:355784;}}i:19;a:13:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5586;s:4:\"orig\";i:106514;}}i:20;a:13:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20909;s:4:\"orig\";i:988589;}}i:21;a:13:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6807;s:4:\"orig\";i:604409;}}i:22;a:13:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10484;s:4:\"orig\";i:229243;}}i:23;a:13:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6034;s:4:\"orig\";i:516575;}}i:24;a:13:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30999;s:4:\"orig\";i:627862;}}i:25;a:13:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:658948;}}i:26;a:13:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16432;s:4:\"orig\";i:531684;}}i:27;a:13:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15860;s:4:\"orig\";i:212685;}}i:28;a:13:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12774;s:4:\"orig\";i:290128;}}i:29;a:13:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8558;s:4:\"orig\";i:264887;}}i:30;a:13:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23349;s:4:\"orig\";i:324946;}}i:31;a:13:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18439;s:4:\"orig\";i:583276;}}i:32;a:13:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8475;s:4:\"orig\";i:241613;}}i:33;a:13:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12227;s:4:\"orig\";i:465092;}}i:34;a:13:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23476;s:4:\"orig\";i:838985;}}i:35;a:13:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:128594;s:4:\"orig\";i:323284;}}i:36;a:13:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15763;s:4:\"orig\";i:606028;}}i:37;a:13:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8743;s:4:\"orig\";i:230696;}}i:38;a:13:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18213;s:4:\"orig\";i:963650;}}i:39;a:13:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9109;s:4:\"orig\";i:190560;}}i:40;a:13:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7469;s:4:\"orig\";i:161910;}}i:41;a:13:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8883;s:4:\"orig\";i:223813;}}i:42;a:13:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13021;s:4:\"orig\";i:334845;}}i:43;a:13:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20718;s:4:\"orig\";i:626836;}}i:44;a:13:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:135139;s:4:\"orig\";i:761240;}}i:45;a:13:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13099;s:4:\"orig\";i:337348;}}i:46;a:13:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13096;s:4:\"orig\";i:413010;}}i:47;a:13:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8043;s:4:\"orig\";i:146037;}}i:48;a:13:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37011;s:4:\"orig\";i:2569343;}}i:49;a:13:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:118650;s:4:\"orig\";i:83713;}}i:50;a:13:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16941;s:4:\"orig\";i:419726;}}i:51;a:13:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23620;s:4:\"orig\";i:734047;}}i:52;a:13:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21088;s:4:\"orig\";i:683735;}}i:53;a:13:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121307;s:4:\"orig\";i:454357;}}i:54;a:13:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39586;s:4:\"orig\";i:1296460;}}i:55;a:13:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21396;s:4:\"orig\";i:835061;}}i:56;a:13:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9545;s:4:\"orig\";i:197811;}}i:57;a:13:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12033;s:4:\"orig\";i:168991;}}i:58;a:13:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39587;s:4:\"orig\";i:1318549;}}i:59;a:13:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:137321;s:4:\"orig\";i:211275;}}i:60;a:13:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14164;s:4:\"orig\";i:731428;}}i:61;a:13:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:130362;s:4:\"orig\";i:908876;}}i:62;a:13:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:132862;s:4:\"orig\";i:925492;}}i:63;a:13:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119015;s:4:\"orig\";i:133010;}}i:64;a:13:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28476;s:4:\"orig\";i:203448;}}i:65;a:13:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:120592;s:4:\"orig\";i:133753;}}i:66;a:13:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119554;s:4:\"orig\";i:160622;}}i:67;a:13:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14058;s:4:\"orig\";i:98209;}}i:68;a:13:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:126007;s:4:\"orig\";i:137953;}}i:69;a:13:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124418;s:4:\"orig\";i:108064;}}i:70;a:13:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125639;s:4:\"orig\";i:131820;}}i:71;a:13:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11948;s:4:\"orig\";i:74707;}}i:72;a:13:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:115633;s:4:\"orig\";i:176188;}}i:73;a:13:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121535;s:4:\"orig\";i:315586;}}i:74;a:13:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:133693;s:4:\"orig\";i:907152;}}i:75;a:13:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11689;s:4:\"orig\";i:183976;}}i:76;a:13:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119147;s:4:\"orig\";i:164255;}}i:77;a:13:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9499;s:4:\"orig\";i:358634;}}i:78;a:13:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14203;s:4:\"orig\";i:523017;}}i:79;a:13:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10702;s:4:\"orig\";i:121030;}}i:80;a:13:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9002;s:4:\"orig\";i:338072;}}i:81;a:13:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121622;s:4:\"orig\";i:211345;}}i:82;a:13:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:122962;s:4:\"orig\";i:353407;}}i:83;a:13:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7170;s:4:\"orig\";i:118827;}}i:84;a:13:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125910;s:4:\"orig\";i:126452;}}i:85;a:13:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12207;s:4:\"orig\";i:177730;}}i:86;a:13:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13663;s:4:\"orig\";i:833006;}}i:87;a:13:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9899;s:4:\"orig\";i:247486;}}i:88;a:13:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7169;s:4:\"orig\";i:522980;}}i:89;a:13:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12411;s:4:\"orig\";i:1051815;}}i:90;a:13:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14974;s:4:\"orig\";i:1082610;}}i:91;a:13:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26819;s:4:\"orig\";i:1283468;}}i:92;a:13:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22713;s:4:\"orig\";i:1335327;}}i:93;a:13:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5513;s:4:\"orig\";i:477513;}}i:94;a:13:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24077;s:4:\"orig\";i:1392352;}}i:95;a:13:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11502;s:4:\"orig\";i:779077;}}i:96;a:13:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7975;s:4:\"orig\";i:323107;}}i:97;a:13:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:129564;s:4:\"orig\";i:432451;}}i:98;a:13:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6743;s:4:\"orig\";i:479348;}}i:99;a:13:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3910;s:4:\"orig\";i:246373;}}i:100;a:13:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9677;s:4:\"orig\";i:154608;}}i:101;a:13:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5998;s:4:\"orig\";i:447839;}}i:102;a:13:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10117;s:4:\"orig\";i:559800;}}i:103;a:13:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24853;s:4:\"orig\";i:1214851;}}i:104;a:13:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18163;s:4:\"orig\";i:1098732;}}i:105;a:13:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5457;s:4:\"orig\";i:320148;}}i:106;a:13:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13313;s:4:\"orig\";i:828871;}}i:107;a:13:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5901;s:4:\"orig\";i:268842;}}i:108;a:13:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37178;s:4:\"orig\";i:1972817;}}i:109;a:13:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26589;s:4:\"orig\";i:851135;}}i:110;a:13:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13334;s:4:\"orig\";i:225651;}}i:111;a:13:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17640;s:4:\"orig\";i:719125;}}i:112;a:13:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8897;s:4:\"orig\";i:83416;}}i:113;a:13:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29174;s:4:\"orig\";i:1663503;}}i:114;a:13:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3668;s:4:\"orig\";i:69153;}}i:115;a:13:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3179;s:4:\"orig\";i:45340;}}i:116;a:13:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21907;s:4:\"orig\";i:937495;}}i:117;a:13:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124560;s:4:\"orig\";i:575796;}}i:118;a:13:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20553;s:4:\"orig\";i:734042;}}i:119;a:13:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9048;s:4:\"orig\";i:129827;}}i:120;a:13:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19226;s:4:\"orig\";i:758093;}}i:121;a:13:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12387;s:4:\"orig\";i:472820;}}i:122;a:13:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10972;s:4:\"orig\";i:380716;}}i:123;a:13:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12394;s:4:\"orig\";i:959761;}}i:124;a:13:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11474;s:4:\"orig\";i:284282;}}i:125;a:13:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13395;s:4:\"orig\";i:519568;}}i:126;a:13:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15367;s:4:\"orig\";i:364626;}}i:127;a:13:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16174;s:4:\"orig\";i:265728;}}i:128;a:13:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7677;s:4:\"orig\";i:256526;}}i:129;a:13:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12408;s:4:\"orig\";i:354771;}}i:130;a:13:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17621;s:4:\"orig\";i:673109;}}i:131;a:13:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9464;s:4:\"orig\";i:180683;}}i:132;a:13:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16190;s:4:\"orig\";i:381967;}}i:133;a:13:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26583;s:4:\"orig\";i:792941;}}i:134;a:13:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17464;s:4:\"orig\";i:394604;}}i:135;a:13:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19126;s:4:\"orig\";i:403268;}}i:136;a:13:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16597;s:4:\"orig\";i:552042;}}i:137;a:13:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16027;s:4:\"orig\";i:430912;}}i:138;a:13:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15961;s:4:\"orig\";i:706482;}}i:139;a:13:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20286;s:4:\"orig\";i:704324;}}i:140;a:13:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10077;s:4:\"orig\";i:197347;}}i:141;a:13:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14092;s:4:\"orig\";i:517927;}}i:142;a:13:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18629;s:4:\"orig\";i:620706;}}i:143;a:13:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10220;s:4:\"orig\";i:348322;}}i:144;a:13:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6348;s:4:\"orig\";i:211494;}}i:145;a:13:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9826;s:4:\"orig\";i:377551;}}i:146;a:13:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13862;s:4:\"orig\";i:454028;}}i:147;a:13:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18636;s:4:\"orig\";i:785357;}}i:148;a:13:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17409;s:4:\"orig\";i:996686;}}i:149;a:13:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12053;s:4:\"orig\";i:916937;}}i:150;a:13:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3887;s:4:\"orig\";i:154603;}}i:151;a:13:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16305;s:4:\"orig\";i:483681;}}i:152;a:13:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12105;s:4:\"orig\";i:314746;}}i:153;a:13:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18137;s:4:\"orig\";i:371805;}}i:154;a:13:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11586;s:4:\"orig\";i:354781;}}i:155;a:13:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9848;s:4:\"orig\";i:195359;}}i:156;a:13:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10089;s:4:\"orig\";i:218538;}}i:157;a:13:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16403;s:4:\"orig\";i:547096;}}i:158;a:13:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19188;s:4:\"orig\";i:371592;}}i:159;a:13:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15157;s:4:\"orig\";i:658386;}}i:160;a:13:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24833;s:4:\"orig\";i:942816;}}i:161;a:13:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:345362;}}i:162;a:13:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15665;s:4:\"orig\";i:407640;}}i:163;a:13:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19443;s:4:\"orig\";i:844506;}}i:164;a:13:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15564;s:4:\"orig\";i:573777;}}i:165;a:13:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13337;s:4:\"orig\";i:762091;}}i:166;a:13:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16746;s:4:\"orig\";i:365391;}}i:167;a:13:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12699;s:4:\"orig\";i:427166;}}i:168;a:13:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4748;s:4:\"orig\";i:238506;}}i:169;a:13:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19043;s:4:\"orig\";i:595277;}}i:170;a:13:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11863;s:4:\"orig\";i:228649;}}i:171;a:13:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10878;s:4:\"orig\";i:313238;}}i:172;a:13:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7596;s:4:\"orig\";i:193734;}}i:173;a:13:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9305;s:4:\"orig\";i:223763;}}i:174;a:13:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23289;s:4:\"orig\";i:699269;}}i:175;a:13:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16638;s:4:\"orig\";i:415507;}}i:176;a:13:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11706;s:4:\"orig\";i:310875;}}i:177;a:13:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18880;s:4:\"orig\";i:531273;}}i:178;a:13:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20175;s:4:\"orig\";i:554813;}}i:179;a:13:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6818;s:4:\"orig\";i:122809;}}i:180;a:13:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8776;s:4:\"orig\";i:190452;}}i:181;a:13:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52127;s:4:\"orig\";i:352596;}}i:182;a:13:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8878;s:4:\"orig\";i:183427;}}i:183;a:13:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:368977;}}i:184;a:13:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15080;s:4:\"orig\";i:707157;}}i:185;a:13:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5473;s:4:\"orig\";i:288675;}}i:186;a:13:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19262;s:4:\"orig\";i:513524;}}i:187;a:13:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9810;s:4:\"orig\";i:317981;}}i:188;a:13:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15773;s:4:\"orig\";i:519696;}}i:189;a:13:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32647;s:4:\"orig\";i:350074;}}i:190;a:13:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14643;s:4:\"orig\";i:314424;}}i:191;a:13:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19823;s:4:\"orig\";i:511473;}}i:192;a:13:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37262;s:4:\"orig\";i:1590451;}}i:193;a:13:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13647;s:4:\"orig\";i:408622;}}i:194;a:13:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10075;s:4:\"orig\";i:216586;}}i:195;a:13:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10969;s:4:\"orig\";i:405945;}}i:196;a:13:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9975;s:4:\"orig\";i:257177;}}i:197;a:13:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9598;s:4:\"orig\";i:300066;}}i:198;a:13:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7588;s:4:\"orig\";i:184359;}}i:199;a:13:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9507;s:4:\"orig\";i:290246;}}i:200;a:13:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14875;s:4:\"orig\";i:324145;}}i:201;a:13:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18138;s:4:\"orig\";i:736181;}}i:202;a:13:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10664;s:4:\"orig\";i:411404;}}i:203;a:13:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11609;s:4:\"orig\";i:273103;}}i:204;a:13:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16837;s:4:\"orig\";i:456937;}}i:205;a:13:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13774;s:4:\"orig\";i:385875;}}i:206;a:13:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12285;s:4:\"orig\";i:546492;}}i:207;a:13:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12631;s:4:\"orig\";i:540206;}}i:208;a:13:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9964;s:4:\"orig\";i:309994;}}i:209;a:13:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13683;s:4:\"orig\";i:369417;}}i:210;a:13:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15941;s:4:\"orig\";i:475914;}}i:211;a:13:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17854;s:4:\"orig\";i:371480;}}i:212;a:13:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17441;s:4:\"orig\";i:507045;}}i:213;a:13:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32396;s:4:\"orig\";i:750503;}}i:214;a:13:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25355;s:4:\"orig\";i:517171;}}i:215;a:13:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30467;s:4:\"orig\";i:1076108;}}i:216;a:13:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17629;s:4:\"orig\";i:804567;}}i:217;a:13:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12952;s:4:\"orig\";i:489898;}}i:218;a:13:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11065;s:4:\"orig\";i:384178;}}i:219;a:13:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6262;s:4:\"orig\";i:198960;}}i:220;a:13:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16353;s:4:\"orig\";i:245636;}}i:221;a:13:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6048;s:4:\"orig\";i:133907;}}i:222;a:13:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15187;s:4:\"orig\";i:450326;}}i:223;a:13:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17977;s:4:\"orig\";i:582673;}}i:224;a:13:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20171;s:4:\"orig\";i:617346;}}i:225;a:13:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14937;s:4:\"orig\";i:227355;}}i:226;a:13:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9789;s:4:\"orig\";i:321713;}}i:227;a:13:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18374;s:4:\"orig\";i:642218;}}i:228;a:13:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17332;s:4:\"orig\";i:791283;}}i:229;a:13:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28854;s:4:\"orig\";i:1228379;}}i:230;a:13:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7529;s:4:\"orig\";i:263779;}}i:231;a:13:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18101;s:4:\"orig\";i:617407;}}i:232;a:13:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18049;s:4:\"orig\";i:757700;}}i:233;a:13:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18133;s:4:\"orig\";i:633849;}}i:234;a:13:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24430;s:4:\"orig\";i:954378;}}i:235;a:13:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16738;s:4:\"orig\";i:664032;}}i:236;a:13:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17594;s:4:\"orig\";i:503413;}}i:237;a:13:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15558;s:4:\"orig\";i:508616;}}i:238;a:13:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14665;s:4:\"orig\";i:429256;}}i:239;a:13:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20433;s:4:\"orig\";i:1162968;}}i:240;a:13:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10872;s:4:\"orig\";i:289488;}}i:241;a:13:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17988;s:4:\"orig\";i:602577;}}i:242;a:13:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9794;s:4:\"orig\";i:352053;}}i:243;a:13:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:370551;}}i:244;a:13:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10397;s:4:\"orig\";i:280660;}}i:245;a:13:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26832;s:4:\"orig\";i:677097;}}i:246;a:13:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13591;s:4:\"orig\";i:846550;}}i:247;a:13:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12138;s:4:\"orig\";i:511326;}}i:248;a:13:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14005;s:4:\"orig\";i:392648;}}i:249;a:13:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11612;s:4:\"orig\";i:688650;}}i:250;a:13:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28096;s:4:\"orig\";i:766943;}}i:251;a:13:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17419;s:4:\"orig\";i:759716;}}i:252;a:13:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10910;s:4:\"orig\";i:191059;}}i:253;a:13:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24825;s:4:\"orig\";i:706226;}}i:254;a:13:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11091;s:4:\"orig\";i:300143;}}i:255;a:13:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15004;s:4:\"orig\";i:475888;}}i:256;a:13:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13155;s:4:\"orig\";i:683645;}}i:257;a:13:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15305;s:4:\"orig\";i:655207;}}i:258;a:13:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17740;s:4:\"orig\";i:745183;}}i:259;a:13:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17442;s:4:\"orig\";i:641873;}}i:260;a:13:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16088;s:4:\"orig\";i:241567;}}i:261;a:13:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8512;s:4:\"orig\";i:267430;}}i:262;a:13:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25804;s:4:\"orig\";i:908234;}}i:263;a:13:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4691;s:4:\"orig\";i:108160;}}i:264;a:13:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12753;s:4:\"orig\";i:218714;}}i:265;a:13:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19312;s:4:\"orig\";i:438345;}}i:266;a:13:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16224;s:4:\"orig\";i:409547;}}i:267;a:13:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22344;s:4:\"orig\";i:432904;}}i:268;a:13:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9431;s:4:\"orig\";i:220442;}}i:269;a:13:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29538;s:4:\"orig\";i:733632;}}i:270;a:13:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12859;s:4:\"orig\";i:430959;}}i:271;a:13:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13413;s:4:\"orig\";i:324558;}}i:272;a:13:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11553;s:4:\"orig\";i:146076;}}i:273;a:13:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21184;s:4:\"orig\";i:537577;}}i:274;a:13:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14134;s:4:\"orig\";i:245565;}}i:275;a:13:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16035;s:4:\"orig\";i:401592;}}i:276;a:13:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12906;s:4:\"orig\";i:483885;}}i:277;a:13:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:80956;}}i:278;a:13:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11452;s:4:\"orig\";i:175118;}}i:279;a:13:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12170;s:4:\"orig\";i:236860;}}i:280;a:13:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10268;s:4:\"orig\";i:117315;}}i:281;a:13:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12485;s:4:\"orig\";i:374567;}}i:282;a:13:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8401;s:4:\"orig\";i:203253;}}i:283;a:13:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12578;s:4:\"orig\";i:287796;}}i:284;a:13:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8484;s:4:\"orig\";i:199508;}}i:285;a:13:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16659;s:4:\"orig\";i:524922;}}i:286;a:13:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9240;s:4:\"orig\";i:109310;}}i:287;a:13:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8288;s:4:\"orig\";i:216553;}}i:288;a:13:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6855;s:4:\"orig\";i:234043;}}i:289;a:13:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12347;s:4:\"orig\";i:238706;}}i:290;a:13:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7748;s:4:\"orig\";i:169462;}}i:291;a:13:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10402;s:4:\"orig\";i:358403;}}i:292;a:13:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12887;s:4:\"orig\";i:261525;}}i:293;a:13:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:2963;s:4:\"orig\";i:30890;}}i:294;a:13:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10266;s:4:\"orig\";i:183341;}}i:295;a:13:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8156;s:4:\"orig\";i:102119;}}i:296;a:13:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10271;s:4:\"orig\";i:138495;}}i:297;a:13:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11654;s:4:\"orig\";i:171098;}}i:298;a:13:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10569;s:4:\"orig\";i:437331;}}i:299;a:13:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15739;s:4:\"orig\";i:446809;}}i:300;a:13:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9456;s:4:\"orig\";i:206722;}}i:301;a:13:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13833;s:4:\"orig\";i:341185;}}i:302;a:13:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10647;s:4:\"orig\";i:193025;}}i:303;a:13:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6239;s:4:\"orig\";i:48178;}}i:304;a:13:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14454;s:4:\"orig\";i:454843;}}i:305;a:13:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7734;s:4:\"orig\";i:119909;}}i:306;a:13:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11927;s:4:\"orig\";i:209224;}}i:307;a:13:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9609;s:4:\"orig\";i:230249;}}i:308;a:13:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12396;s:4:\"orig\";i:290596;}}i:309;a:14:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25803;s:11:\"video_thumb\";i:2753823;s:5:\"cover\";i:127867;s:4:\"orig\";i:5991847;}}i:310;a:14:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19154;s:11:\"video_thumb\";i:4783500;s:5:\"cover\";i:97843;s:4:\"orig\";i:12408832;}}i:311;a:14:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28284;s:11:\"video_thumb\";i:2150510;s:5:\"cover\";i:124176;s:4:\"orig\";i:7726114;}}i:312;a:14:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23354;s:11:\"video_thumb\";i:3635377;s:5:\"cover\";i:106283;s:4:\"orig\";i:12688465;}}i:313;a:14:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29858;s:11:\"video_thumb\";i:9614915;s:5:\"cover\";i:153660;s:4:\"orig\";i:13424151;}}i:314;a:14:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19155;s:11:\"video_thumb\";i:2361089;s:5:\"cover\";i:103588;s:4:\"orig\";i:14717688;}}i:315;a:14:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:11719;s:11:\"video_thumb\";i:4841259;s:5:\"cover\";i:40309;s:4:\"orig\";i:11715637;}}i:316;a:14:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:56469;s:11:\"video_thumb\";i:5107558;s:5:\"cover\";i:273635;s:4:\"orig\";i:13833056;}}i:317;a:14:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:30439;s:11:\"video_thumb\";i:3864288;s:5:\"cover\";i:133345;s:4:\"orig\";i:13159814;}}i:318;a:14:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31267;s:11:\"video_thumb\";i:2732735;s:5:\"cover\";i:173636;s:4:\"orig\";i:5536475;}}i:319;a:14:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29090;s:11:\"video_thumb\";i:4861363;s:5:\"cover\";i:188894;s:4:\"orig\";i:13731609;}}i:320;a:14:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31123;s:11:\"video_thumb\";i:1386258;s:5:\"cover\";i:219740;s:4:\"orig\";i:6479275;}}i:321;a:14:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21091;s:11:\"video_thumb\";i:11134706;s:5:\"cover\";i:115059;s:4:\"orig\";i:12313637;}}i:322;a:14:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19624;s:11:\"video_thumb\";i:3913179;s:5:\"cover\";i:118864;s:4:\"orig\";i:14700830;}}i:323;a:14:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:45123;s:11:\"video_thumb\";i:2547876;s:5:\"cover\";i:268587;s:4:\"orig\";i:8823724;}}i:324;a:14:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:33867;s:11:\"video_thumb\";i:5972511;s:5:\"cover\";i:172632;s:4:\"orig\";i:13869858;}}i:325;a:14:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16185;s:11:\"video_thumb\";i:4097952;s:5:\"cover\";i:160912;s:4:\"orig\";i:12307362;}}i:326;a:14:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9324;s:11:\"video_thumb\";i:1843046;s:5:\"cover\";i:94919;s:4:\"orig\";i:4938526;}}i:327;a:14:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:13455;s:11:\"video_thumb\";i:5101194;s:5:\"cover\";i:66493;s:4:\"orig\";i:11852447;}}i:328;a:14:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20003;s:11:\"video_thumb\";i:1696754;s:5:\"cover\";i:103202;s:4:\"orig\";i:12515577;}}i:329;a:14:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19377;s:11:\"video_thumb\";i:3861934;s:5:\"cover\";i:101592;s:4:\"orig\";i:13370749;}}i:330;a:14:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31120;s:11:\"video_thumb\";i:2732488;s:5:\"cover\";i:190596;s:4:\"orig\";i:13625169;}}i:331;a:14:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17475;s:11:\"video_thumb\";i:1248121;s:5:\"cover\";i:203284;s:4:\"orig\";i:4921567;}}i:332;a:14:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26132;s:11:\"video_thumb\";i:5777142;s:5:\"cover\";i:138198;s:4:\"orig\";i:12817212;}}i:333;a:14:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40668;s:11:\"video_thumb\";i:3711074;s:5:\"cover\";i:243587;s:4:\"orig\";i:12354374;}}i:334;a:14:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:41275;s:11:\"video_thumb\";i:2631988;s:5:\"cover\";i:330226;s:4:\"orig\";i:8304831;}}i:335;a:14:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:54209;s:11:\"video_thumb\";i:4596191;s:5:\"cover\";i:335804;s:4:\"orig\";i:13306988;}}i:336;a:14:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:75484;s:11:\"video_thumb\";i:3134686;s:5:\"cover\";i:461854;s:4:\"orig\";i:20337064;}}i:337;a:14:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25915;s:11:\"video_thumb\";i:2352326;s:5:\"cover\";i:136931;s:4:\"orig\";i:12104254;}}i:338;a:14:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40965;s:11:\"video_thumb\";i:8637814;s:5:\"cover\";i:195812;s:4:\"orig\";i:13878956;}}i:339;a:14:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19037;s:11:\"video_thumb\";i:3065043;s:5:\"cover\";i:65493;s:4:\"orig\";i:12935967;}}i:340;a:14:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:24344;s:11:\"video_thumb\";i:1911296;s:5:\"cover\";i:192540;s:4:\"orig\";i:4631422;}}i:341;a:14:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23517;s:11:\"video_thumb\";i:4899641;s:5:\"cover\";i:86737;s:4:\"orig\";i:12281833;}}i:342;a:14:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31844;s:11:\"video_thumb\";i:4412295;s:5:\"cover\";i:154844;s:4:\"orig\";i:10753079;}}i:343;a:14:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14905;s:11:\"video_thumb\";i:3394055;s:5:\"cover\";i:73276;s:4:\"orig\";i:11722124;}}i:344;a:14:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:48591;s:11:\"video_thumb\";i:5268295;s:5:\"cover\";i:211021;s:4:\"orig\";i:11990742;}}i:345;a:14:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27863;s:11:\"video_thumb\";i:2674570;s:5:\"cover\";i:119321;s:4:\"orig\";i:11602755;}}i:346;a:14:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27505;s:11:\"video_thumb\";i:3025283;s:5:\"cover\";i:144357;s:4:\"orig\";i:13176990;}}i:347;a:14:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22543;s:11:\"video_thumb\";i:1327376;s:5:\"cover\";i:111224;s:4:\"orig\";i:4727340;}}i:348;a:14:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:34936;s:11:\"video_thumb\";i:3198076;s:5:\"cover\";i:160493;s:4:\"orig\";i:12804022;}}i:349;a:14:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28883;s:11:\"video_thumb\";i:4750283;s:5:\"cover\";i:153687;s:4:\"orig\";i:13054569;}}i:350;a:14:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:53693;s:11:\"video_thumb\";i:9780815;s:5:\"cover\";i:341419;s:4:\"orig\";i:13738077;}}i:351;a:14:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9494;s:11:\"video_thumb\";i:942533;s:5:\"cover\";i:52833;s:4:\"orig\";i:6629299;}}i:352;a:14:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22781;s:11:\"video_thumb\";i:2415073;s:5:\"cover\";i:126450;s:4:\"orig\";i:11684367;}}i:353;a:14:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22296;s:11:\"video_thumb\";i:1465206;s:5:\"cover\";i:73047;s:4:\"orig\";i:4008355;}}i:354;a:14:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19851;s:11:\"video_thumb\";i:3023599;s:5:\"cover\";i:25426;s:4:\"orig\";i:12847145;}}i:355;a:14:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:18002;s:11:\"video_thumb\";i:1791449;s:5:\"cover\";i:101725;s:4:\"orig\";i:13746552;}}i:356;a:14:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:8176;s:11:\"video_thumb\";i:4255586;s:5:\"cover\";i:75455;s:4:\"orig\";i:10948491;}}i:357;a:14:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:46567;s:11:\"video_thumb\";i:3789289;s:5:\"cover\";i:25425;s:4:\"orig\";i:15943336;}}i:358;a:14:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26927;s:11:\"video_thumb\";i:2605391;s:5:\"cover\";i:149830;s:4:\"orig\";i:13232415;}}i:359;a:14:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20000;s:11:\"video_thumb\";i:655504;s:5:\"cover\";i:620066;s:4:\"orig\";i:13229794;}}i:360;a:14:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23213;s:11:\"video_thumb\";i:498407;s:5:\"cover\";i:308442;s:4:\"orig\";i:11108924;}}i:361;a:14:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21648;s:11:\"video_thumb\";i:109062;s:5:\"cover\";i:305957;s:4:\"orig\";i:6267674;}}i:362;a:14:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19198;s:11:\"video_thumb\";i:326656;s:5:\"cover\";i:554701;s:4:\"orig\";i:10151652;}}i:363;a:14:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14725;s:11:\"video_thumb\";i:72977;s:5:\"cover\";i:72535;s:4:\"orig\";i:4938006;}}i:364;a:14:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:12165;s:11:\"video_thumb\";i:256975;s:5:\"cover\";i:340550;s:4:\"orig\";i:9691449;}}i:365;a:14:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:36900;s:11:\"video_thumb\";i:920631;s:5:\"cover\";i:949012;s:4:\"orig\";i:13422013;}}i:366;a:14:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17289;s:11:\"video_thumb\";i:137402;s:5:\"cover\";i:300574;s:4:\"orig\";i:7528458;}}i:367;a:14:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16562;s:11:\"video_thumb\";i:161004;s:5:\"cover\";i:291708;s:4:\"orig\";i:7596827;}}i:368;a:14:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19186;s:11:\"video_thumb\";i:404406;s:5:\"cover\";i:496556;s:4:\"orig\";i:15358645;}}i:369;a:14:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11778;s:5:\"video\";i:126230;}}i:370;a:14:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9342;s:5:\"video\";i:258890;}}i:371;a:14:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22925;s:5:\"video\";i:337622;}}i:372;a:14:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13590;s:5:\"video\";i:143116;}}i:373;a:14:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12603;s:5:\"video\";i:267056;}}i:374;a:14:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11225;s:5:\"video\";i:104722;}}i:375;a:14:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16221;s:5:\"video\";i:183244;}}i:376;a:14:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15072;s:5:\"video\";i:90577;}}i:377;a:14:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11741;s:5:\"video\";i:96061;}}i:378;a:14:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15979;s:5:\"video\";i:136040;}}i:379;a:14:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13637;s:5:\"video\";i:98053;}}i:380;a:14:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14892;s:5:\"video\";i:125449;}}i:381;a:14:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16568;s:5:\"video\";i:127133;}}i:382;a:14:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19099;s:5:\"video\";i:202784;}}i:383;a:14:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21756;s:5:\"video\";i:295899;}}i:384;a:14:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20783;s:5:\"video\";i:279347;}}i:385;a:14:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17862;s:5:\"video\";i:111140;}}i:386;a:14:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10799;s:5:\"video\";i:49269;}}i:387;a:14:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14442;s:5:\"video\";i:143950;}}i:388;a:14:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16819;s:5:\"video\";i:142842;}}i:389;a:14:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12575;s:5:\"video\";i:106541;}}i:390;a:14:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12931;s:5:\"video\";i:84922;}}i:391;a:14:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18105;s:5:\"video\";i:184683;}}i:392;a:14:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13440;s:5:\"video\";i:104866;}}i:393;a:14:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17477;s:5:\"video\";i:147765;}}i:394;a:14:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36069;s:5:\"video\";i:104559;}}i:395;a:14:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20095;s:5:\"video\";i:60429;}}i:396;a:14:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:38056;s:5:\"video\";i:45726;}}i:397;a:14:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:54736;s:5:\"video\";i:26685;}}i:398;a:14:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34717;s:5:\"video\";i:16283;}}i:399;a:14:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25700;s:5:\"video\";i:38602;}}i:400;a:14:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:55897;s:5:\"video\";i:21279;}}i:401;a:14:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39579;s:5:\"video\";i:22677;}}i:402;a:14:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41903;s:5:\"video\";i:65515;}}i:403;a:14:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25902;s:5:\"video\";i:15295;}}i:404;a:14:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40029;s:5:\"video\";i:28970;}}i:405;a:14:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21834;s:5:\"video\";i:21250;}}i:406;a:14:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36633;s:5:\"video\";i:51973;}}i:407;a:14:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22669;s:5:\"video\";i:46598;}}i:408;a:14:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52537;s:5:\"video\";i:29580;}}i:409;a:14:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34343;s:5:\"video\";i:18413;}}i:410;a:14:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20519;s:5:\"video\";i:25391;}}i:411;a:14:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16265;s:5:\"video\";i:75634;}}i:412;a:14:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41495;s:5:\"video\";i:49692;}}i:413;a:14:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40417;s:5:\"video\";i:80078;}}i:414;a:14:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34150;s:5:\"video\";i:23500;}}i:415;a:14:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15426;s:5:\"video\";i:21651;}}i:416;a:14:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:33524;s:5:\"video\";i:46449;}}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("1237","wpb_js_composer_license_activation_notified","yes","yes"),
("1435","dokan_pages","a:4:{s:9:\"dashboard\";s:4:\"4062\";s:9:\"my_orders\";s:4:\"4065\";s:11:\"reg_tc_page\";s:1:\"2\";s:13:\"store_listing\";s:0:\"\";}","yes"),
("1436","dokan_pages_created","1","yes"),
("1437","dokan_theme_version","3.3.6","yes"),
("1440","widget_dokan-best-selling-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1441","widget_dokan-category-menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1442","widget_dokan-store-contact-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1443","widget_dokan-store-location","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1444","widget_dokan-store-menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1445","widget_dokan-top-rated","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1446","widget_dokan-store-open-close-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1447","dokan_seller_data_1","a:7:{i:0;s:20:\"dokan-count-orders-1\";i:1;s:15:\"dokan-earning-1\";i:2;s:22:\"dokan_seller_balance_1\";i:3;s:32:\"d47bfe52b6b1dd44a6a077b22d301461\";i:4;s:25:\"dokan-seller-orders-all-1\";i:5;s:23:\"dokan_seller_earnings_1\";i:6;s:52:\"dokan_seller_orders-ffb3991f16283d620c0a6dbc9d007836\";}","yes"),
("1448","dokan_general","a:9:{s:12:\"site_options\";s:0:\"\";s:12:\"admin_access\";s:2:\"on\";s:16:\"custom_store_url\";s:8:\"teachers\";s:21:\"setup_wizard_logo_url\";s:73:\"https://demo.studiaretheme.ir/academy/wp-content/uploads/2021/10/logo.png\";s:22:\"disable_welcome_wizard\";s:3:\"off\";s:23:\"data_clear_on_uninstall\";s:3:\"off\";s:20:\"vendor_store_options\";s:0:\"\";s:34:\"seller_enable_terms_and_conditions\";s:2:\"on\";s:23:\"store_products_per_page\";s:2:\"12\";}","yes"),
("1449","dokan_selling","a:9:{s:10:\"commission\";s:0:\"\";s:15:\"commission_type\";s:10:\"percentage\";s:16:\"admin_percentage\";s:2:\"20\";s:22:\"shipping_fee_recipient\";s:6:\"seller\";s:17:\"tax_fee_recipient\";s:6:\"seller\";s:17:\"vendor_capability\";s:0:\"\";s:25:\"new_seller_enable_selling\";s:2:\"on\";s:21:\"disable_product_popup\";s:2:\"on\";s:19:\"order_status_change\";s:2:\"on\";}","yes"),
("1450","dokan_withdraw","a:3:{s:16:\"withdraw_methods\";a:1:{s:4:\"bank\";s:4:\"bank\";}s:14:\"withdraw_limit\";i:0;s:21:\"withdraw_order_status\";a:2:{s:12:\"wc-completed\";s:12:\"wc-completed\";s:13:\"wc-processing\";s:13:\"wc-processing\";}}","yes"),
("1451","dokan_pointer_toplevel_page_dokan","1","yes"),
("1467","dokan_appearance","a:9:{s:9:\"store_map\";s:2:\"on\";s:14:\"map_api_source\";s:11:\"google_maps\";s:12:\"gmap_api_key\";s:0:\"\";s:19:\"mapbox_access_token\";s:0:\"\";s:14:\"contact_seller\";s:2:\"on\";s:21:\"store_header_template\";s:7:\"layout1\";s:16:\"store_open_close\";s:2:\"on\";s:26:\"enable_theme_store_sidebar\";s:3:\"off\";s:16:\"hide_vendor_info\";a:3:{s:5:\"email\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:7:\"address\";s:0:\"\";}}","yes"),
("1473","dokan_pro_active_modules","a:16:{i:0;s:25:\"appearance/appearance.php\";i:1;s:19:\"booking/booking.php\";i:2;s:31:\"export-import/export-import.php\";i:3;s:23:\"live-chat/live-chat.php\";i:4;s:27:\"live-search/live-search.php\";i:5;s:44:\"paypal-adaptive-payments/dokan-paypal-ap.php\";i:6;s:27:\"product-enquiry/enquiry.php\";i:7;s:35:\"seller-vacation/seller-vacation.php\";i:8;s:26:\"simple-auction/auction.php\";i:9;s:65:\"single-product-multiple-vendor/single-product-multiple-vendor.php\";i:10;s:31:\"store-reviews/store-reviews.php\";i:11;s:31:\"store-support/store-support.php\";i:12;s:25:\"stripe/gateway-stripe.php\";i:13;s:37:\"subscription/product-subscription.php\";i:14;s:29:\"vendor-staff/vendor-staff.php\";i:15;s:43:\"vendor-verification/vendor-verification.php\";}","yes"),
("1477","dokan_importer_page_created","1","yes"),
("1478","dokan_importer_page_id","623","yes"),
("1479","dokan-customer-support","https://demo.studiaretheme.ir/academy/my-account/support-tickets/","yes"),
("1483","widget_dokna_product_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1484","widget_dokan-verification-list","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1485","widget_dokan-best-seller-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1486","widget_dokan-feature-seller-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1488","dokan_whats_new_versions","a:1:{i:0;s:5:\"2.8.3\";}","yes"),
("1501","dokan_colors","a:10:{s:8:\"btn_text\";s:7:\"#ffffff\";s:11:\"btn_primary\";s:7:\"#f9a134\";s:18:\"btn_primary_border\";s:7:\"#EA9E3C\";s:14:\"btn_hover_text\";s:7:\"#ffffff\";s:9:\"btn_hover\";s:7:\"#FF9000\";s:16:\"btn_hover_border\";s:7:\"#f9a134\";s:13:\"dash_nav_text\";s:7:\"#ffffff\";s:16:\"dash_active_link\";s:7:\"#f9a134\";s:11:\"dash_nav_bg\";s:7:\"#2196F3\";s:15:\"dash_nav_border\";s:7:\"#5bc0de\";}","yes"),
("1526","woocommerce_payir_settings","a:8:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"Pay.ir\";s:11:\"description\";s:108:\"پرداخت امن به وسیله کلیه کارت های عضو شتاب از طریق درگاه Pay.ir\";s:15:\"direct_redirect\";s:2:\"no\";s:3:\"api\";s:0:\"\";s:7:\"sandbox\";s:2:\"no\";s:17:\"completed_massage\";s:81:\"با تشکر از شما. سفارش شما با موفقیت پرداخت شد.\";s:14:\"failed_massage\";s:176:\"پرداخت شما ناموفق بوده است. لطفا مجددا تلاش نمایید یا در صورت بروز اشکال با مدیر سایت تماس بگیرید.\";}","yes"),
("1532","woocommerce_maybe_regenerate_images_hash","991b1ca641921cf0f5baf7a2fe85861b","yes"),
("1649","woocommerce_checkout_company_field","hidden","yes"),
("1650","woocommerce_checkout_address_2_field","hidden","yes"),
("2264","wc_sp_woo_eo_mode","off","yes"),
("2534","woocommerce_default_catalog_orderby","date","yes"),
("5710","show_comments_cookies_opt_in","","yes"),
("5711","db_upgraded","","on"),
("5718","woocommerce_placeholder_image","714","yes"),
("5733","persian_woocommerce_dismissed_notices","a:5:{i:0;b:0;i:1;s:13:\"novin-booster\";i:2;s:14:\"checkout-tools\";i:3;s:3:\"pws\";i:4;s:15:\"tapin-dashboard\";}","yes"),
("5821","thimpress_events_paypal_enable","no","yes"),
("5822","thimpress_events_paypal_email","","yes"),
("5823","thimpress_events_paypal_sandbox_mode","0","yes"),
("5824","thimpress_events_paypal_sanbox_email","","yes"),
("5827","thimpress_events_woo_payment_enable","yes","yes"),
("5828","thimpress_events_woo_event_register_process","checkout","yes"),
("9001","secret_key","+KKww.SBlZaX}[)<>1Mm]Sq/5assFGh:and|gqH4v3+TMU,dH{N ]t8j;jV?3{&&","no"),
("18302","woocommerce_allow_bulk_remove_personal_data","no","no"),
("18303","woocommerce_show_marketplace_suggestions","no","no"),
("18341","recovery_keys","a:0:{}","off"),
("18617","revslider-notices-dc","a:5:{i:0;s:11:\"TPRS5481-03\";i:1;s:11:\"TPRSV656-01\";i:2;s:12:\"TPRSV6518-01\";i:3;s:8:\"TPRSV668\";i:4;s:11:\"TPSNOTR3011\";}","yes"),
("26843","rs-templates-new","","off"),
("26847","rs-templates","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","off");

INSERT IGNORE INTO `wp_options` VALUES 
("27564","recovery_mode_email_last_sent","1730633406","yes"),
("27597","revslider_update_revision_current","6.6.21","yes"),
("27779","revslider-update-hash","d88d60685d6349f5d526e3c43d2bb6c5","yes"),
("27780","revslider-library-hash","324e6ba47fb68dfb7f1bd5b0b203bdc5","yes"),
("27781","revslider-templates-hash","8973f3901dfcbc2b59fbec2f1e11f507","yes"),
("27842","fs_active_plugins","O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:34:\"ajax-search-for-woocommerce/fs/lib\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.12.1\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1757131734;s:11:\"plugin_path\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";}}s:7:\"abspath\";s:45:\"/home/studiar1/demo.studiaretheme.ir/academy/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";s:8:\"sdk_path\";s:34:\"ajax-search-for-woocommerce/fs/lib\";s:7:\"version\";s:6:\"2.12.1\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1757131734;}}","yes"),
("27843","fs_debug_mode","","yes"),
("27844","fs_accounts","a:8:{s:21:\"id_slug_type_path_map\";a:1:{i:700;a:3:{s:4:\"slug\";s:27:\"ajax-search-for-woocommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";}}s:11:\"plugin_data\";a:1:{s:27:\"ajax-search-for-woocommerce\";a:17:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1569537128;s:16:\"sdk_last_version\";s:6:\"2.11.0\";s:11:\"sdk_version\";s:6:\"2.12.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:6:\"1.30.0\";s:14:\"plugin_version\";s:6:\"1.31.0\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:21:\"is_plugin_new_install\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:21:\"studiare.sunthemes.ir\";s:9:\"server_ip\";s:12:\"89.47.66.101\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1569537128;s:7:\"version\";s:5:\"1.5.0\";}s:17:\"was_plugin_loaded\";b:1;s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1618553715;s:7:\"version\";s:5:\"1.9.0\";}s:19:\"last_load_timestamp\";i:1757130253;}}s:13:\"file_slug_map\";a:1:{s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";s:27:\"ajax-search-for-woocommerce\";}s:7:\"plugins\";a:1:{s:27:\"ajax-search-for-woocommerce\";O:9:\"FS_Plugin\":24:{s:2:\"id\";s:3:\"700\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:1;s:10:\"public_key\";s:32:\"pk_f4f2a51dbe0aee43de0692db77a3e\";s:10:\"secret_key\";N;s:16:\"parent_plugin_id\";N;s:5:\"title\";s:40:\"FiboSearch - AJAX Search for WooCommerce\";s:4:\"slug\";s:27:\"ajax-search-for-woocommerce\";s:12:\"premium_slug\";s:35:\"ajax-search-for-woocommerce-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";s:7:\"version\";s:6:\"1.31.0\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:3:\"Pro\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;}}s:9:\"unique_id\";s:32:\"939209493fe487611710ed89450f21b5\";s:13:\"admin_notices\";a:1:{s:27:\"ajax-search-for-woocommerce\";a:0:{}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}}","yes"),
("27845","fs_api_cache","a:0:{}","yes"),
("27846","fs_gdpr","a:1:{s:2:\"u1\";a:1:{s:8:\"required\";b:0;}}","yes"),
("27849","widget_dgwt_wcas_ajax_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("27850","dgwt_wcas_activation_date","1569537130","yes"),
("27851","dgwt_wcas_settings","a:81:{s:34:\"search_in_product_global_unique_id\";s:3:\"off\";s:23:\"bg_input_underlay_color\";s:0:\"\";s:17:\"show_user_history\";s:3:\"off\";s:42:\"analytics_critical_searches_widget_enabled\";s:3:\"off\";s:12:\"search_style\";s:7:\"solaris\";s:25:\"mobile_overlay_breakpoint\";i:992;s:14:\"analytics_head\";s:0:\"\";s:17:\"analytics_enabled\";s:3:\"off\";s:17:\"darken_background\";s:3:\"off\";s:28:\"show_product_tax_product_cat\";s:2:\"on\";s:35:\"show_product_tax_product_cat_images\";s:3:\"off\";s:28:\"show_product_tax_product_tag\";s:2:\"on\";s:33:\"search_in_product_tax_product_cat\";s:3:\"off\";s:33:\"search_in_product_tax_product_tag\";s:3:\"off\";s:20:\"filter_products_mode\";s:7:\"exclude\";s:15:\"rebranding_head\";s:0:\"\";s:15:\"rebranding_desc\";s:0:\"\";s:20:\"filter_products_head\";s:0:\"\";s:21:\"filter_products_rules\";a:0:{}s:20:\"troubleshooting_head\";s:0:\"\";s:26:\"embedding_search_form_head\";s:0:\"\";s:10:\"how_to_use\";s:0:\"\";s:9:\"form_head\";s:0:\"\";s:11:\"layout_head\";s:0:\"\";s:13:\"search_layout\";s:7:\"classic\";s:17:\"mobile_breakpoint\";i:992;s:11:\"search_form\";s:0:\"\";s:17:\"search_icon_color\";s:0:\"\";s:14:\"preloader_head\";s:0:\"\";s:17:\"autocomplete_head\";s:0:\"\";s:23:\"product_suggestion_head\";s:0:\"\";s:33:\"non_products_in_autocomplete_head\";s:0:\"\";s:16:\"details_box_head\";s:0:\"\";s:22:\"suggestions_style_head\";s:0:\"\";s:18:\"search_search_head\";s:0:\"\";s:27:\"search_scope_fuzziness_head\";s:0:\"\";s:20:\"search_synonyms_head\";s:0:\"\";s:12:\"pro_features\";s:0:\"\";s:18:\"search_engine_head\";s:0:\"\";s:19:\"search_engine_build\";s:0:\"\";s:21:\"indexer_schedule_head\";s:0:\"\";s:9:\"min_chars\";s:1:\"3\";s:14:\"max_form_width\";s:3:\"600\";s:18:\"show_submit_button\";s:2:\"on\";s:18:\"search_submit_text\";s:10:\"جستجو\";s:18:\"search_placeholder\";s:42:\"دوست داری چی یاد بگیری؟\";s:14:\"bg_input_color\";s:0:\"\";s:16:\"text_input_color\";s:0:\"\";s:18:\"border_input_color\";s:0:\"\";s:15:\"bg_submit_color\";s:0:\"\";s:17:\"text_submit_color\";s:0:\"\";s:21:\"enable_mobile_overlay\";s:3:\"off\";s:14:\"show_preloader\";s:2:\"on\";s:13:\"preloader_url\";s:0:\"\";s:17:\"suggestions_limit\";s:1:\"5\";s:20:\"show_grouped_results\";s:3:\"off\";s:22:\"search_no_results_text\";s:26:\"موردی یافت نشد\";s:18:\"show_product_image\";s:2:\"on\";s:18:\"show_product_price\";s:2:\"on\";s:17:\"show_product_desc\";s:3:\"off\";s:16:\"show_product_sku\";s:2:\"on\";s:27:\"search_see_all_results_text\";s:34:\"مشاهده همه نتایج ...\";s:19:\"show_matching_posts\";s:3:\"off\";s:19:\"show_matching_pages\";s:3:\"off\";s:16:\"show_details_box\";s:2:\"on\";s:12:\"sug_bg_color\";s:0:\"\";s:15:\"sug_hover_color\";s:0:\"\";s:14:\"sug_text_color\";s:0:\"\";s:19:\"sug_highlight_color\";s:0:\"\";s:16:\"sug_border_color\";s:0:\"\";s:25:\"search_in_product_content\";s:2:\"on\";s:25:\"search_in_product_excerpt\";s:2:\"on\";s:21:\"search_in_product_sku\";s:2:\"on\";s:28:\"search_in_product_attributes\";s:3:\"off\";s:23:\"search_in_custom_fields\";s:0:\"\";s:20:\"exclude_out_of_stock\";s:3:\"off\";s:22:\"fuzziness_enabled_demo\";s:3:\"off\";s:15:\"search_synonyms\";s:0:\"\";s:16:\"indexer_schedule\";s:3:\"off\";s:25:\"indexer_schedule_interval\";s:6:\"weekly\";s:27:\"indexer_schedule_start_time\";s:1:\"3\";}","yes"),
("27852","dgwt_wcas_version","1.31.0","yes"),
("28036","yit_recently_activated","a:1:{i:0;s:38:\"yith-woocommerce-subscription/init.php\";}","yes"),
("28037","yith_wcwl_frontend_css_colors","s:1:\"1\";","yes"),
("28038","yith_wcwl_wishlist_title","لیست علاقه مندی های من در قالب آموزش آنلاین studiare وردپرس","yes"),
("28039","yith_wcwl_version","2.2.13","yes"),
("28040","yith_wcwl_db_version","2.2.0","yes"),
("28043","yith_system_info","a:2:{s:11:\"system_info\";a:13:{s:14:\"min_wp_version\";a:1:{s:5:\"value\";s:3:\"6.0\";}s:14:\"min_wc_version\";a:1:{s:5:\"value\";s:5:\"6.6.1\";}s:15:\"wp_memory_limit\";a:1:{s:5:\"value\";i:536870912;}s:15:\"min_php_version\";a:1:{s:5:\"value\";s:6:\"7.4.30\";}s:15:\"min_tls_version\";a:1:{s:5:\"value\";s:3:\"1.3\";}s:15:\"imagick_version\";a:1:{s:5:\"value\";s:5:\"7.1.0\";}s:15:\"wp_cron_enabled\";a:1:{s:5:\"value\";b:1;}s:16:\"mbstring_enabled\";a:1:{s:5:\"value\";b:1;}s:17:\"simplexml_enabled\";a:1:{s:5:\"value\";b:1;}s:10:\"gd_enabled\";a:1:{s:5:\"value\";b:1;}s:13:\"iconv_enabled\";a:1:{s:5:\"value\";b:1;}s:15:\"opcache_enabled\";a:1:{s:5:\"value\";s:1:\"1\";}s:17:\"url_fopen_enabled\";a:1:{s:5:\"value\";s:1:\"1\";}}s:6:\"errors\";b:0;}","yes"),
("28044","yith_wcwl_general_videobox","a:7:{s:11:\"plugin_name\";s:25:\"YITH WooCommerce Wishlist\";s:18:\"title_first_column\";s:56:\"امکانات پیشرفته را مشاهده کنید\";s:24:\"description_first_column\";s:141:\"ارتقاء دهید به نسخه پولی افزونه علاقه‌مندی تا ازهمه ویژگی‌ها بهره‌مند شوید!\";s:5:\"video\";a:3:{s:8:\"video_id\";s:9:\"118797844\";s:15:\"video_image_url\";s:113:\"https://demo.studiaretheme.ir/academy/wp-content/plugins/yith-woocommerce-wishlist//assets/images/video-thumb.jpg\";s:17:\"video_description\";s:0:\"\";}s:19:\"title_second_column\";s:77:\"در اختیار داشتن ویژگی‌های پولی و پشتیبانی\";s:25:\"description_second_column\";s:337:\"با خرید نسخه حرفه ای این افزونه میتوانید از امکانات پیشرفته این محصول بهره ببرید، همچنین به مدت 1 سال آپدیت های این افزونه را بطور رایگان دریافت کنید و از پشتیبانی 24 ساعته ما استفاده کنید\";s:6:\"button\";a:2:{s:4:\"href\";s:79:\"https://yithemes.com/themes/plugins/yith-woocommerce-wishlist/?refer_id=1030585\";s:5:\"title\";s:28:\"Get Support and Pro Features\";}}","yes"),
("28045","yith_wcwl_enabled","yes","yes"),
("28046","yith_wcwl_wishlist_page_id","771","yes"),
("28047","yith_wcwl_redirect_cart","no","yes"),
("28048","yith_wcwl_remove_after_add_to_cart","yes","yes"),
("28049","yith_wcwl_add_to_wishlist_text","افزودن به علاقه مندی ها","yes"),
("28050","yith_wcwl_browse_wishlist_text","مشاهده لیست علاقه مندی ها","yes"),
("28051","yith_wcwl_already_in_wishlist_text","محصول از قبل به علاقه مندی ها اضافه شده!","yes"),
("28052","yith_wcwl_product_added_text","اضافه شد!","yes"),
("28053","yith_wcwl_add_to_cart_text","افزودن به سبد","yes"),
("28054","yith_wcwl_price_show","yes","yes"),
("28055","yith_wcwl_add_to_cart_show","yes","yes"),
("28056","yith_wcwl_stock_show","yes","yes"),
("28057","yith_wcwl_show_dateadded","no","yes"),
("28058","yith_wcwl_repeat_remove_button","no","yes"),
("28059","yith_wcwl_share_fb","yes","yes"),
("28060","yith_wcwl_share_twitter","yes","yes"),
("28061","yith_wcwl_share_pinterest","yes","yes"),
("28062","yith_wcwl_share_googleplus","yes","yes"),
("28063","yith_wcwl_share_email","yes","yes"),
("28064","yith_wcwl_share_whatsapp","yes","yes"),
("28065","yith_wcwl_share_url","no","yes"),
("28066","yith_wcwl_socials_title","لیست علاقه مندی های من در قالب آموزش آنلاین studiare وردپرس","yes"),
("28067","yith_wcwl_socials_text","","yes"),
("28068","yith_wcwl_socials_image_url","","yes"),
("28069","yith_wfbt_enable_integration","no","yes"),
("28070","yith_wcwl_use_button","no","yes"),
("28071","yith_wcwl_custom_css","","yes"),
("28072","yith_wcwl_frontend_css","yes","yes"),
("28073","yith_wcwl_rounded_corners","yes","yes"),
("28074","yith_wcwl_add_to_wishlist_icon","none","yes"),
("28075","yith_wcwl_add_to_cart_icon","fa-shopping-cart","yes"),
("28076","yit_plugin_fw_panel_wc_default_options_set","a:3:{s:15:\"yith_wcwl_panel\";b:1;s:15:\"yith_wcqv_panel\";b:1;s:29:\"yith_woocommerce_subscription\";b:1;}","yes"),
("28087","yith_wcwl_button_position","thumbnails","yes"),
("28148","yith-wcqv-enable","yes","yes"),
("28149","yith-wcqv-enable-mobile","yes","yes"),
("28150","yith-wcqv-button-label","نمایش سریع","yes"),
("28151","yith-wcqv-enable-lightbox","yes","yes"),
("28152","yith-wcqv-background-modal","#ffffff","yes"),
("28153","yith-wcqv-close-color","#cdcdcd","yes"),
("28154","yith-wcqv-close-color-hover","#ff0000","yes"),
("28223","woosq_button_type","link","yes"),
("28224","woosq_button_text","مشاهده سریع","yes"),
("28225","woosq_button_class","","yes"),
("28226","woosq_button_position","after_add_to_cart","yes"),
("28227","woosq_effect","mfp-move-from-top","yes"),
("28228","_woosq_cats","a:1:{i:0;s:1:\"0\";}","yes"),
("28229","woosq_content_image","all","yes"),
("28230","woosq_content_image_lightbox","no","yes"),
("28231","woosq_summary","a:3:{i:0;s:5:\"title\";i:1;s:5:\"price\";i:2;s:11:\"add_to_cart\";}","yes"),
("28232","woosq_add_to_cart_button","single","yes"),
("28233","woosq_content_view_details_button","yes","yes"),
("28234","woosq_content_view_details_text","مشاهده جزئیات محصول","yes"),
("28255","woosw_page_id","775","yes"),
("28259","woosw_disable_unauthenticated","yes","yes"),
("28260","woosw_auto_remove","no","yes"),
("28261","woosw_page_share","yes","yes"),
("28262","woosw_page_copy","yes","yes"),
("28263","woosw_button_type","button","yes"),
("28264","woosw_button_text","","yes"),
("28265","woosw_button_action","list","yes"),
("28266","woosw_button_text_added","","yes"),
("28267","woosw_button_action_added","popup","yes"),
("28268","woosw_button_class","","yes"),
("28269","woosw_button_position_archive","after_add_to_cart","yes"),
("28270","woosw_button_position_single","31","yes"),
("28271","woosw_cats","a:1:{i:0;s:1:\"0\";}","yes"),
("28272","woosw_color","#000000","yes"),
("28273","woosw_continue_url","","yes"),
("28274","woosw_menus","a:1:{i:0;s:2:\"45\";}","yes"),
("28275","woosw_menu_action","open_popup","yes"),
("28282","woosw_list_FDHD3P","a:3:{i:86;i:1569580103;i:73;i:1569580097;i:64;i:1569580086;}","yes"),
("28300","_wooscp_open_button","","yes"),
("28301","_wooscp_open_button_action","open_popup","yes"),
("28302","_wooscp_button_type","button","yes"),
("28303","_wooscp_button_text","","yes"),
("28304","_wooscp_button_class","","yes"),
("28305","_wooscp_button_archive","after_add_to_cart","yes"),
("28306","_wooscp_button_single","31","yes"),
("28307","_wooscp_open_bar_immediately","","yes"),
("28308","_wooscp_open_immediately","yes","yes"),
("28309","_wooscp_hide_checkout","yes","yes"),
("28310","_wooscp_click_again","no","yes"),
("28311","_wooscp_close_button","yes","yes"),
("28312","_wooscp_hide_empty","no","yes"),
("28313","_wooscp_bar_settings","yes","yes"),
("28314","_wooscp_bar_add","yes","yes"),
("28315","_wooscp_bar_remove","no","yes"),
("28316","_wooscp_bar_bg_color","#292a30","yes"),
("28317","_wooscp_bar_btn_text","","yes"),
("28318","_wooscp_bar_btn_color","#00a0d2","yes"),
("28319","_wooscp_bar_pos","bottom","yes"),
("28320","_wooscp_bar_align","right","yes"),
("28321","_wooscp_click_outside","yes","yes"),
("28322","_wooscp_limit","4","yes"),
("28323","_wooscp_limit_notice","","yes"),
("28324","_wooscp_page_id","","yes"),
("28325","_wooscp_fields","a:7:{i:0;s:5:\"image\";i:1;s:3:\"sku\";i:2;s:6:\"rating\";i:3;s:5:\"price\";i:4;s:11:\"add_to_cart\";i:5;s:11:\"description\";i:6;s:13:\"custom_fields\";}","yes"),
("28326","_wooscp_attributes","","yes"),
("28327","_wooscp_custom_fields","teacher_id","yes"),
("28328","_wooscp_image_size","wooscp-large","yes"),
("28329","_wooscp_freeze_column","yes","yes"),
("28330","_wooscp_freeze_row","yes","yes"),
("28331","_wooscp_search_count","10","yes"),
("28332","_wooscp_search_cats","a:1:{i:0;s:1:\"0\";}","yes"),
("28333","_wooscp_menus","a:1:{i:0;s:2:\"45\";}","yes"),
("28334","_wooscp_menu_action","open_popup","yes"),
("28476","woosw_list_4YBSPO","a:1:{i:77;i:1569664412;}","yes"),
("29250","dgwt_wcas_dismiss_review_notice","1","yes"),
("30009","wp_tab_widget_activated","1665080054","yes"),
("30010","widget_wpt_widget","a:2:{i:2;a:14:{s:4:\"tabs\";a:3:{s:7:\"popular\";s:1:\"1\";s:6:\"recent\";s:1:\"1\";s:8:\"comments\";s:1:\"1\";}s:9:\"tab_order\";a:4:{s:7:\"popular\";s:1:\"1\";s:6:\"recent\";s:1:\"2\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:1:\"4\";}s:16:\"allow_pagination\";s:1:\"1\";s:8:\"post_num\";s:1:\"5\";s:12:\"title_length\";s:2:\"15\";s:11:\"comment_num\";s:1:\"5\";s:10:\"show_thumb\";s:1:\"1\";s:10:\"thumb_size\";s:5:\"small\";s:9:\"show_date\";s:1:\"1\";s:12:\"show_excerpt\";N;s:14:\"excerpt_length\";s:2:\"15\";s:16:\"show_comment_num\";N;s:11:\"show_avatar\";s:1:\"1\";s:9:\"show_love\";N;}s:12:\"_multiwidget\";i:1;}","yes"),
("30013","wp_tab_widget_notice_views","3","yes"),
("30035","woocommerce_tax_classes","","yes"),
("30157","woosw_list_WH7K9T","a:1:{i:77;i:1570759677;}","yes"),
("30685","woosw_list_0RINPU","a:0:{}","yes"),
("31549","sc_cmhc_settings","a:1:{s:22:\"sc_cmhc_selected_color\";s:7:\"#2e3e77\";}","yes"),
("32080","wp_dokan_update_2_9_4_order_post_author_batch_ee3a5bd7aff23f5789","a:1:{i:0;a:2:{s:8:\"updating\";s:22:\"shop_order_post_author\";s:5:\"paged\";i:0;}}","no"),
("32081","dokan_background_processes","a:2:{s:36:\"dokan_update_2_9_4_order_post_author\";s:178:\"/home/demosuncod/domains/demo.suncode.ir/public_html/studiare6/wp-content/plugins/dokan-lite/includes/upgrades/background-processes/class_dokan_update_2_9_4_order_post_author.php\";s:34:\"dokan_update_2_9_16_store_settings\";s:176:\"/home/demosuncod/domains/demo.suncode.ir/public_html/studiare6/wp-content/plugins/dokan-lite/includes/upgrades/background-processes/class_dokan_update_2_9_16_store_settings.php\";}","no"),
("32082","wp_dokan_update_2_9_16_store_settings_batch_1d2926a9243e4ad3407c","a:1:{i:0;a:2:{s:8:\"updating\";s:14:\"store_settings\";s:5:\"paged\";i:0;}}","no"),
("32087","_dokan_free_upgrade_promo","a:6:{s:20:\"product_subscription\";a:2:{s:7:\"display\";i:0;s:14:\"last_displayed\";s:19:\"2019-10-26 23:30:48\";}s:14:\"vendor_reviews\";a:2:{s:7:\"display\";i:0;s:14:\"last_displayed\";s:19:\"2021-10-25 22:49:09\";}s:19:\"vendor_verification\";a:2:{s:7:\"display\";i:0;s:14:\"last_displayed\";s:19:\"2021-11-01 22:57:32\";}s:19:\"multiple_commission\";a:2:{s:7:\"display\";i:0;s:14:\"last_displayed\";s:19:\"2021-11-16 01:27:44\";}s:23:\"ticket_priority_support\";a:2:{s:7:\"display\";i:0;s:14:\"last_displayed\";s:19:\"2021-11-26 01:27:41\";}s:11:\"coupon_code\";a:2:{s:7:\"display\";i:0;s:14:\"last_displayed\";s:19:\"2021-12-03 09:37:10\";}}","yes"),
("32088","_dokan_free_upgrade_promo_displayed_time","2021-12-03 09:37:10","yes"),
("32089","dokan-lite_allow_tracking","no","yes"),
("32750","admin_email_lifespan","1757389589","yes"),
("35928","woocommerce_maxmind_geolocation_settings","a:1:{s:15:\"database_prefix\";s:32:\"oXSuL18NOcKtowA2YtVSkRMBDPYCBv7A\";}","yes"),
("41190","action_scheduler_hybrid_store_demarkation","934","yes"),
("41191","schema-ActionScheduler_StoreSchema","8.0.1757131735","yes"),
("41192","schema-ActionScheduler_LoggerSchema","3.0.1634296137","yes"),
("41193","woocommerce_onboarding_opt_in","no","yes"),
("41196","woocommerce_downloads_add_hash_to_filename","yes","yes"),
("41198","woocommerce_onboarding_profile","a:1:{s:9:\"completed\";b:1;}","yes"),
("41207","woocommerce_admin_install_timestamp","1584844999","yes"),
("41208","woocommerce_admin_last_orders_milestone","10","yes"),
("41221","action_scheduler_lock_async-request-runner","68bbb58e47d1b3.20111280|1757132234","yes"),
("42011","dgwt_wcas_settings_show_advanced","on","yes"),
("42063","woocommerce_sales_record_date","2023-02-19","yes"),
("42064","woocommerce_sales_record_amount","2309000","yes"),
("47552","rs_image_meta_todo","a:0:{}","yes"),
("47832","theme_mods_studiare-child","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:9:\"main-menu\";i:44;s:12:\"top-bar-menu\";i:45;s:11:\"mobile-menu\";i:44;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1708256247;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:10:\"contacts-2\";i:1;s:16:\"namad_carousel-2\";i:2;s:26:\"woocommerce_price_filter-2\";i:3;s:13:\"custom_html-4\";}s:9:\"sidebar-1\";a:4:{i:0;s:8:\"search-3\";i:1;s:13:\"custom_html-1\";i:2;s:12:\"categories-2\";i:3;s:11:\"tag_cloud-1\";}s:17:\"studiare-footer-1\";a:1:{i:0;s:6:\"text-1\";}s:17:\"studiare-footer-2\";a:1:{i:0;s:10:\"nav_menu-1\";}s:17:\"studiare-footer-3\";a:1:{i:0;s:6:\"text-2\";}s:17:\"studiare-footer-4\";a:1:{i:0;s:16:\"namad_carousel-3\";}s:12:\"sidebar_shop\";a:3:{i:0;s:32:\"woocommerce_product_categories-1\";i:1;s:22:\"woocommerce_products-1\";i:2;s:13:\"custom_html-3\";}s:10:\"singleshop\";a:1:{i:0;s:13:\"custom_html-5\";}s:14:\"sidebar_events\";a:2:{i:0;s:8:\"search-4\";i:1;s:13:\"custom_html-6\";}}}}","no"),
("49016","wpb_js_google_fonts_subsets","a:1:{i:0;s:5:\"latin\";}","yes"),
("49017","wpb_js_gutenberg_disable","1","yes"),
("49018","wpb_js_default_template_post_type","a:0:{}","yes"),
("49382","woocommerce_admin_import_stats","a:3:{s:9:\"customers\";a:2:{s:8:\"imported\";i:2;s:5:\"total\";i:2;}s:6:\"orders\";a:2:{s:8:\"imported\";i:4;s:5:\"total\";i:4;}s:13:\"imported_from\";i:-1;}","yes"),
("49531","duplicator_pro_reset_user_settings_required","0","yes"),
("49533","duplicator_pro_license_key","activated","yes"),
("50013","revslider-additions","O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-b.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-b.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}","yes"),
("50977","rs-templates-counter","20","off"),
("52183","woocommerce_schema_version","920","yes"),
("52194","wc_blocks_db_schema_version","260","yes"),
("52391","Redux_plugin_feedback_activation_date","1596619330","no"),
("52452","redux-framework_allow_tracking","yes","yes"),
("60538","disallowed_keys","","no"),
("60539","comment_previously_approved","1","yes"),
("60540","auto_plugin_theme_update_emails","a:0:{}","no"),
("60541","finished_updating_comment_type","1","yes"),
("69929","rs-addons-counter","1","yes"),
("73502","wc_admin_note_home_screen_feedback_homescreen_accessed","1603383946","yes"),
("73507","wc_remote_inbox_notifications_stored_state","O:8:\"stdClass\":3:{s:22:\"there_were_no_products\";b:0;s:22:\"there_are_now_products\";b:1;s:17:\"new_product_count\";i:0;}","yes"),
("75762","woocommerce_version","10.1.2","yes"),
("75763","woocommerce_db_version","10.1.2","yes"),
("76575","auto_update_core_dev","enabled","yes"),
("76576","auto_update_core_minor","enabled","yes"),
("76577","auto_update_core_major","unset","yes"),
("80525","woocommerce_merchant_email_notifications","yes","no"),
("80747","https_detection_errors","a:1:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:35:\"تأیید SSL ناموفق بود.\";}}","off"),
("83801","rewrite_rules","a:640:{s:9:\"events/?$\";s:28:\"index.php?post_type=tp_event\";s:39:\"events/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=tp_event&feed=$matches[1]\";s:34:\"events/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=tp_event&feed=$matches[1]\";s:26:\"events/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=tp_event&paged=$matches[1]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:10:\"teacher/?$\";s:27:\"index.php?post_type=teacher\";s:40:\"teacher/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=teacher&feed=$matches[1]\";s:35:\"teacher/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=teacher&feed=$matches[1]\";s:27:\"teacher/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=teacher&paged=$matches[1]\";s:15:\"studi_footer/?$\";s:32:\"index.php?post_type=studi_footer\";s:45:\"studi_footer/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=studi_footer&feed=$matches[1]\";s:40:\"studi_footer/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=studi_footer&feed=$matches[1]\";s:32:\"studi_footer/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=studi_footer&paged=$matches[1]\";s:15:\"studi_header/?$\";s:32:\"index.php?post_type=studi_header\";s:45:\"studi_header/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=studi_header&feed=$matches[1]\";s:40:\"studi_header/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=studi_header&feed=$matches[1]\";s:32:\"studi_header/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=studi_header&paged=$matches[1]\";s:14:\"sc_megamenu/?$\";s:31:\"index.php?post_type=sc_megamenu\";s:44:\"sc_megamenu/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=sc_megamenu&feed=$matches[1]\";s:39:\"sc_megamenu/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=sc_megamenu&feed=$matches[1]\";s:31:\"sc_megamenu/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=sc_megamenu&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:11:\"sc_story/?$\";s:28:\"index.php?post_type=sc_story\";s:41:\"sc_story/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=sc_story&feed=$matches[1]\";s:36:\"sc_story/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=sc_story&feed=$matches[1]\";s:28:\"sc_story/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=sc_story&paged=$matches[1]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:19:\"^wishlist/([\\w]+)/?\";s:42:\"index.php?page_id=775&woosw_id=$matches[1]\";s:24:\"(.*?)/wishlist/([\\w]+)/?\";s:42:\"index.php?page_id=775&woosw_id=$matches[2]\";s:32:\"events/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"events/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"events/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"events/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"events/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"events/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"events/(.+?)/embed/?$\";s:41:\"index.php?tp_event=$matches[1]&embed=true\";s:25:\"events/(.+?)/trackback/?$\";s:35:\"index.php?tp_event=$matches[1]&tb=1\";s:45:\"events/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?tp_event=$matches[1]&feed=$matches[2]\";s:40:\"events/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?tp_event=$matches[1]&feed=$matches[2]\";s:33:\"events/(.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?tp_event=$matches[1]&paged=$matches[2]\";s:40:\"events/(.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?tp_event=$matches[1]&cpage=$matches[2]\";s:41:\"events/(.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?tp_event=$matches[1]&wc/file/transient=$matches[3]\";s:30:\"events/(.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?tp_event=$matches[1]&wc-api=$matches[3]\";s:47:\"events/.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:58:\"events/.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"events/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"events/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:29:\"events/(.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?tp_event=$matches[1]&page=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"swss_ticket/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"swss_ticket/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"swss_ticket/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"swss_ticket/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"swss_ticket/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"swss_ticket/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"swss_ticket/([^/]+)/embed/?$\";s:44:\"index.php?swss_ticket=$matches[1]&embed=true\";s:32:\"swss_ticket/([^/]+)/trackback/?$\";s:38:\"index.php?swss_ticket=$matches[1]&tb=1\";s:40:\"swss_ticket/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?swss_ticket=$matches[1]&paged=$matches[2]\";s:47:\"swss_ticket/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?swss_ticket=$matches[1]&cpage=$matches[2]\";s:48:\"swss_ticket/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?swss_ticket=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"swss_ticket/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?swss_ticket=$matches[1]&wc-api=$matches[3]\";s:54:\"swss_ticket/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"swss_ticket/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"swss_ticket/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"swss_ticket/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:36:\"swss_ticket/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?swss_ticket=$matches[1]&page=$matches[2]\";s:28:\"swss_ticket/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"swss_ticket/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"swss_ticket/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"swss_ticket/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"swss_ticket/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"swss_ticket/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"swss_ticket_priority/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?swss_ticket_priority=$matches[1]&feed=$matches[2]\";s:56:\"swss_ticket_priority/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?swss_ticket_priority=$matches[1]&feed=$matches[2]\";s:37:\"swss_ticket_priority/([^/]+)/embed/?$\";s:53:\"index.php?swss_ticket_priority=$matches[1]&embed=true\";s:49:\"swss_ticket_priority/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?swss_ticket_priority=$matches[1]&paged=$matches[2]\";s:31:\"swss_ticket_priority/([^/]+)/?$\";s:42:\"index.php?swss_ticket_priority=$matches[1]\";s:46:\"swss_predef_answer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"swss_predef_answer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"swss_predef_answer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"swss_predef_answer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"swss_predef_answer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"swss_predef_answer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"swss_predef_answer/([^/]+)/embed/?$\";s:51:\"index.php?swss_predef_answer=$matches[1]&embed=true\";s:39:\"swss_predef_answer/([^/]+)/trackback/?$\";s:45:\"index.php?swss_predef_answer=$matches[1]&tb=1\";s:47:\"swss_predef_answer/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?swss_predef_answer=$matches[1]&paged=$matches[2]\";s:54:\"swss_predef_answer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?swss_predef_answer=$matches[1]&cpage=$matches[2]\";s:55:\"swss_predef_answer/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?swss_predef_answer=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"swss_predef_answer/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?swss_predef_answer=$matches[1]&wc-api=$matches[3]\";s:61:\"swss_predef_answer/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"swss_predef_answer/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"swss_predef_answer/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"swss_predef_answer/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"swss_predef_answer/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?swss_predef_answer=$matches[1]&page=$matches[2]\";s:35:\"swss_predef_answer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"swss_predef_answer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"swss_predef_answer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"swss_predef_answer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"swss_predef_answer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"swss_predef_answer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"swss_ticket_message/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"swss_ticket_message/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"swss_ticket_message/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"swss_ticket_message/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"swss_ticket_message/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"swss_ticket_message/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"swss_ticket_message/([^/]+)/embed/?$\";s:52:\"index.php?swss_ticket_message=$matches[1]&embed=true\";s:40:\"swss_ticket_message/([^/]+)/trackback/?$\";s:46:\"index.php?swss_ticket_message=$matches[1]&tb=1\";s:48:\"swss_ticket_message/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?swss_ticket_message=$matches[1]&paged=$matches[2]\";s:55:\"swss_ticket_message/([^/]+)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?swss_ticket_message=$matches[1]&cpage=$matches[2]\";s:56:\"swss_ticket_message/([^/]+)/wc/file/transient(/(.*))?/?$\";s:71:\"index.php?swss_ticket_message=$matches[1]&wc/file/transient=$matches[3]\";s:45:\"swss_ticket_message/([^/]+)/wc-api(/(.*))?/?$\";s:60:\"index.php?swss_ticket_message=$matches[1]&wc-api=$matches[3]\";s:62:\"swss_ticket_message/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:73:\"swss_ticket_message/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:51:\"swss_ticket_message/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:62:\"swss_ticket_message/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:44:\"swss_ticket_message/([^/]+)(?:/([0-9]+))?/?$\";s:58:\"index.php?swss_ticket_message=$matches[1]&page=$matches[2]\";s:36:\"swss_ticket_message/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"swss_ticket_message/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"swss_ticket_message/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"swss_ticket_message/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"swss_ticket_message/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"swss_ticket_message/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"brand/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:39:\"brand/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:20:\"brand/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:32:\"brand/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:14:\"brand/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:54:\"course-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:49:\"course-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:30:\"course-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:42:\"course-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:24:\"course-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:51:\"course-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:46:\"course-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:27:\"course-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:39:\"course-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:21:\"course-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"teacher/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"teacher/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"teacher/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"teacher/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"teacher/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"teacher/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"teacher/([^/]+)/embed/?$\";s:40:\"index.php?teacher=$matches[1]&embed=true\";s:28:\"teacher/([^/]+)/trackback/?$\";s:34:\"index.php?teacher=$matches[1]&tb=1\";s:48:\"teacher/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?teacher=$matches[1]&feed=$matches[2]\";s:43:\"teacher/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?teacher=$matches[1]&feed=$matches[2]\";s:36:\"teacher/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?teacher=$matches[1]&paged=$matches[2]\";s:43:\"teacher/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?teacher=$matches[1]&cpage=$matches[2]\";s:44:\"teacher/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?teacher=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"teacher/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?teacher=$matches[1]&wc-api=$matches[3]\";s:50:\"teacher/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"teacher/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"teacher/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"teacher/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"teacher/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?teacher=$matches[1]&page=$matches[2]\";s:24:\"teacher/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"teacher/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"teacher/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"teacher/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"teacher/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"teacher/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"cdownload/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"cdownload/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"cdownload/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"cdownload/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"cdownload/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"cdownload/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"cdownload/([^/]+)/embed/?$\";s:57:\"index.php?post_type=cdownload&name=$matches[1]&embed=true\";s:30:\"cdownload/([^/]+)/trackback/?$\";s:51:\"index.php?post_type=cdownload&name=$matches[1]&tb=1\";s:38:\"cdownload/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?post_type=cdownload&name=$matches[1]&paged=$matches[2]\";s:45:\"cdownload/([^/]+)/comment-page-([0-9]{1,})/?$\";s:64:\"index.php?post_type=cdownload&name=$matches[1]&cpage=$matches[2]\";s:46:\"cdownload/([^/]+)/wc/file/transient(/(.*))?/?$\";s:76:\"index.php?post_type=cdownload&name=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"cdownload/([^/]+)/wc-api(/(.*))?/?$\";s:65:\"index.php?post_type=cdownload&name=$matches[1]&wc-api=$matches[3]\";s:52:\"cdownload/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"cdownload/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"cdownload/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"cdownload/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"cdownload/([^/]+)(?:/([0-9]+))?/?$\";s:63:\"index.php?post_type=cdownload&name=$matches[1]&page=$matches[2]\";s:26:\"cdownload/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"cdownload/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"cdownload/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"cdownload/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"cdownload/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"cdownload/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"studi_footer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"studi_footer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"studi_footer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"studi_footer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"studi_footer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"studi_footer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"studi_footer/([^/]+)/embed/?$\";s:45:\"index.php?studi_footer=$matches[1]&embed=true\";s:33:\"studi_footer/([^/]+)/trackback/?$\";s:39:\"index.php?studi_footer=$matches[1]&tb=1\";s:53:\"studi_footer/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?studi_footer=$matches[1]&feed=$matches[2]\";s:48:\"studi_footer/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?studi_footer=$matches[1]&feed=$matches[2]\";s:41:\"studi_footer/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?studi_footer=$matches[1]&paged=$matches[2]\";s:48:\"studi_footer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?studi_footer=$matches[1]&cpage=$matches[2]\";s:49:\"studi_footer/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?studi_footer=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"studi_footer/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?studi_footer=$matches[1]&wc-api=$matches[3]\";s:55:\"studi_footer/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"studi_footer/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"studi_footer/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"studi_footer/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"studi_footer/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?studi_footer=$matches[1]&page=$matches[2]\";s:29:\"studi_footer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"studi_footer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"studi_footer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"studi_footer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"studi_footer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"studi_footer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"studi_header/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"studi_header/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"studi_header/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"studi_header/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"studi_header/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"studi_header/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"studi_header/([^/]+)/embed/?$\";s:45:\"index.php?studi_header=$matches[1]&embed=true\";s:33:\"studi_header/([^/]+)/trackback/?$\";s:39:\"index.php?studi_header=$matches[1]&tb=1\";s:53:\"studi_header/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?studi_header=$matches[1]&feed=$matches[2]\";s:48:\"studi_header/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?studi_header=$matches[1]&feed=$matches[2]\";s:41:\"studi_header/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?studi_header=$matches[1]&paged=$matches[2]\";s:48:\"studi_header/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?studi_header=$matches[1]&cpage=$matches[2]\";s:49:\"studi_header/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?studi_header=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"studi_header/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?studi_header=$matches[1]&wc-api=$matches[3]\";s:55:\"studi_header/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"studi_header/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"studi_header/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"studi_header/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"studi_header/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?studi_header=$matches[1]&page=$matches[2]\";s:29:\"studi_header/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"studi_header/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"studi_header/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"studi_header/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"studi_header/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"studi_header/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"sc_megamenu/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"sc_megamenu/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"sc_megamenu/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"sc_megamenu/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"sc_megamenu/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"sc_megamenu/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"sc_megamenu/([^/]+)/embed/?$\";s:44:\"index.php?sc_megamenu=$matches[1]&embed=true\";s:32:\"sc_megamenu/([^/]+)/trackback/?$\";s:38:\"index.php?sc_megamenu=$matches[1]&tb=1\";s:52:\"sc_megamenu/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?sc_megamenu=$matches[1]&feed=$matches[2]\";s:47:\"sc_megamenu/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?sc_megamenu=$matches[1]&feed=$matches[2]\";s:40:\"sc_megamenu/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?sc_megamenu=$matches[1]&paged=$matches[2]\";s:47:\"sc_megamenu/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?sc_megamenu=$matches[1]&cpage=$matches[2]\";s:48:\"sc_megamenu/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?sc_megamenu=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"sc_megamenu/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?sc_megamenu=$matches[1]&wc-api=$matches[3]\";s:54:\"sc_megamenu/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"sc_megamenu/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"sc_megamenu/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"sc_megamenu/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:36:\"sc_megamenu/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?sc_megamenu=$matches[1]&page=$matches[2]\";s:28:\"sc_megamenu/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"sc_megamenu/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"sc_megamenu/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"sc_megamenu/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"sc_megamenu/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"sc_megamenu/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"notifications/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"notifications/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"notifications/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"notifications/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"notifications/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"notifications/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"notifications/([^/]+)/embed/?$\";s:48:\"index.php?sc_notification=$matches[1]&embed=true\";s:34:\"notifications/([^/]+)/trackback/?$\";s:42:\"index.php?sc_notification=$matches[1]&tb=1\";s:42:\"notifications/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?sc_notification=$matches[1]&paged=$matches[2]\";s:49:\"notifications/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?sc_notification=$matches[1]&cpage=$matches[2]\";s:50:\"notifications/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?sc_notification=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"notifications/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?sc_notification=$matches[1]&wc-api=$matches[3]\";s:56:\"notifications/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:67:\"notifications/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:45:\"notifications/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"notifications/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"notifications/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?sc_notification=$matches[1]&page=$matches[2]\";s:30:\"notifications/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"notifications/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"notifications/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"notifications/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"notifications/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"notifications/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:54:\"portfolio_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:49:\"portfolio_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:30:\"portfolio_tag/([^/]+)/embed/?$\";s:46:\"index.php?portfolio_tag=$matches[1]&embed=true\";s:42:\"portfolio_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?portfolio_tag=$matches[1]&paged=$matches[2]\";s:24:\"portfolio_tag/([^/]+)/?$\";s:35:\"index.php?portfolio_tag=$matches[1]\";s:36:\"sc_story/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"sc_story/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"sc_story/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"sc_story/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"sc_story/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"sc_story/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"sc_story/([^/]+)/embed/?$\";s:41:\"index.php?sc_story=$matches[1]&embed=true\";s:29:\"sc_story/([^/]+)/trackback/?$\";s:35:\"index.php?sc_story=$matches[1]&tb=1\";s:49:\"sc_story/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?sc_story=$matches[1]&feed=$matches[2]\";s:44:\"sc_story/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?sc_story=$matches[1]&feed=$matches[2]\";s:37:\"sc_story/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?sc_story=$matches[1]&paged=$matches[2]\";s:44:\"sc_story/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?sc_story=$matches[1]&cpage=$matches[2]\";s:45:\"sc_story/([^/]+)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?sc_story=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"sc_story/([^/]+)/wc-api(/(.*))?/?$\";s:49:\"index.php?sc_story=$matches[1]&wc-api=$matches[3]\";s:51:\"sc_story/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"sc_story/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"sc_story/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"sc_story/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:33:\"sc_story/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?sc_story=$matches[1]&page=$matches[2]\";s:25:\"sc_story/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"sc_story/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"sc_story/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"sc_story/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"sc_story/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"sc_story/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"story_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?story_category=$matches[1]&feed=$matches[2]\";s:50:\"story_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?story_category=$matches[1]&feed=$matches[2]\";s:31:\"story_category/([^/]+)/embed/?$\";s:47:\"index.php?story_category=$matches[1]&embed=true\";s:43:\"story_category/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?story_category=$matches[1]&paged=$matches[2]\";s:25:\"story_category/([^/]+)/?$\";s:36:\"index.php?story_category=$matches[1]\";s:50:\"story_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?story_tag=$matches[1]&feed=$matches[2]\";s:45:\"story_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?story_tag=$matches[1]&feed=$matches[2]\";s:26:\"story_tag/([^/]+)/embed/?$\";s:42:\"index.php?story_tag=$matches[1]&embed=true\";s:38:\"story_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?story_tag=$matches[1]&paged=$matches[2]\";s:20:\"story_tag/([^/]+)/?$\";s:31:\"index.php?story_tag=$matches[1]\";s:38:\"event-book/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"event-book/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"event-book/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"event-book/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"event-book/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"event-book/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"event-book/([^/]+)/embed/?$\";s:48:\"index.php?event_auth_book=$matches[1]&embed=true\";s:31:\"event-book/([^/]+)/trackback/?$\";s:42:\"index.php?event_auth_book=$matches[1]&tb=1\";s:39:\"event-book/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?event_auth_book=$matches[1]&paged=$matches[2]\";s:46:\"event-book/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?event_auth_book=$matches[1]&cpage=$matches[2]\";s:47:\"event-book/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?event_auth_book=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"event-book/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?event_auth_book=$matches[1]&wc-api=$matches[3]\";s:53:\"event-book/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"event-book/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"event-book/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"event-book/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"event-book/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?event_auth_book=$matches[1]&page=$matches[2]\";s:27:\"event-book/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"event-book/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"event-book/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"event-book/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"event-book/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"event-book/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"tp-event-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?tp_event_category=$matches[1]&feed=$matches[2]\";s:53:\"tp-event-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?tp_event_category=$matches[1]&feed=$matches[2]\";s:34:\"tp-event-category/([^/]+)/embed/?$\";s:50:\"index.php?tp_event_category=$matches[1]&embed=true\";s:46:\"tp-event-category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?tp_event_category=$matches[1]&paged=$matches[2]\";s:28:\"tp-event-category/([^/]+)/?$\";s:39:\"index.php?tp_event_category=$matches[1]\";s:53:\"tp-event-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tp_event_tag=$matches[1]&feed=$matches[2]\";s:48:\"tp-event-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tp_event_tag=$matches[1]&feed=$matches[2]\";s:29:\"tp-event-tag/([^/]+)/embed/?$\";s:45:\"index.php?tp_event_tag=$matches[1]&embed=true\";s:41:\"tp-event-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?tp_event_tag=$matches[1]&paged=$matches[2]\";s:23:\"tp-event-tag/([^/]+)/?$\";s:34:\"index.php?tp_event_tag=$matches[1]\";s:54:\"tp-event-type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?tp_event_type=$matches[1]&feed=$matches[2]\";s:49:\"tp-event-type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?tp_event_type=$matches[1]&feed=$matches[2]\";s:30:\"tp-event-type/([^/]+)/embed/?$\";s:46:\"index.php?tp_event_type=$matches[1]&embed=true\";s:42:\"tp-event-type/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?tp_event_type=$matches[1]&paged=$matches[2]\";s:24:\"tp-event-type/([^/]+)/?$\";s:35:\"index.php?tp_event_type=$matches[1]\";s:40:\"studi_lesson/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"studi_lesson/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"studi_lesson/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"studi_lesson/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"studi_lesson/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"studi_lesson/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"studi_lesson/([^/]+)/embed/?$\";s:45:\"index.php?studi_lesson=$matches[1]&embed=true\";s:33:\"studi_lesson/([^/]+)/trackback/?$\";s:39:\"index.php?studi_lesson=$matches[1]&tb=1\";s:41:\"studi_lesson/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?studi_lesson=$matches[1]&paged=$matches[2]\";s:48:\"studi_lesson/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?studi_lesson=$matches[1]&cpage=$matches[2]\";s:49:\"studi_lesson/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?studi_lesson=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"studi_lesson/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?studi_lesson=$matches[1]&wc-api=$matches[3]\";s:55:\"studi_lesson/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"studi_lesson/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"studi_lesson/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"studi_lesson/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"studi_lesson/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?studi_lesson=$matches[1]&page=$matches[2]\";s:29:\"studi_lesson/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"studi_lesson/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"studi_lesson/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"studi_lesson/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"studi_lesson/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"studi_lesson/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:47:\"mc4wp-form/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?mc4wp-form=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=4734&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:33:\"swss-user-tickets-area(/(.*))?/?$\";s:45:\"index.php?&swss-user-tickets-area=$matches[2]\";s:23:\"quiz-results(/(.*))?/?$\";s:35:\"index.php?&quiz-results=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:41:\"(.?.+?)/swss-user-tickets-area(/(.*))?/?$\";s:65:\"index.php?pagename=$matches[1]&swss-user-tickets-area=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\"(.?.+?)/quiz-results(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&quiz-results=$matches[3]\";s:27:\"(.?.+?)/wishlist(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&wishlist=$matches[3]\";s:32:\"(.?.+?)/user_comments(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&user_comments=$matches[3]\";s:25:\"(.?.+?)/events(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&events=$matches[3]\";s:37:\"(.?.+?)/purchased-products(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&purchased-products=$matches[3]\";s:32:\"(.?.+?)/notifications(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&notifications=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("84716","dig_hide_countrycode","0","yes"),
("84717","digits_db_migrate7010","1","yes"),
("84718","dig_reg_custom_field_data_backup","e30=","yes"),
("84719","dig_reg_lb_data_backup","","yes"),
("84720","dig_reg_custom_field_data","W10=","yes"),
("84721","digits_do_activation_redirect","1","yes"),
("84725","digits_activation_time","1618420379","yes"),
("84726","digits_addon_update_page_redirect","a:2:{s:4:\"time\";i:1629649920;s:7:\"version\";s:7:\"7.8.0.1\";}","yes"),
("84729","external_updates-digits","O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1629698934;s:14:\"checkedVersion\";s:7:\"7.8.0.1\";s:6:\"update\";O:8:\"stdClass\":10:{s:4:\"slug\";s:6:\"digits\";s:7:\"version\";s:7:\"7.8.0.1\";s:12:\"download_url\";N;s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:29:\"https://digits.unitedover.com\";s:6:\"tested\";s:7:\"5.6.999\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:2:{s:2:\"1x\";s:48:\"https://unitedover.com/images/digits/icon128.png\";s:2:\"2x\";s:48:\"https://unitedover.com/images/digits/icon256.png\";}s:8:\"filename\";s:16:\"digits/digit.php\";}s:11:\"updateClass\";s:22:\"Puc_v4p6_Plugin_Update\";s:15:\"updateBaseClass\";s:13:\"Plugin_Update\";}","no"),
("84748","digits_rtl_license_options","a:6:{s:14:\"digits_rtl_api\";s:88:\"VUJesUuOWcS1QsX1vyqW60TmCOGuwwf3svKXIWvTt1iQpjYRIU1O4Isez6EBSWNrffJGZ2pRvCRPmt15X8yuDQ==\";s:17:\"digits_rtl_domain\";s:64:\"jXENj+j8RU3KWQeOvQChrCBw2xntXWyJA3EIoVMCoWSrriInTlV8AeDxirnfaJVl\";s:18:\"digits_rtl_orderid\";s:44:\"kDDVYGv6TJW5yPNjFEwHS9IGeRy5h0Ni3CqDDSznD+8=\";s:19:\"digits_rtl_username\";s:44:\"/SO91dQWeg1dRJQfBTeVgALcgQK174DvXEoJR0YgAO4=\";s:20:\"digits_rtl_secretkey\";s:88:\"kgYPaKt/dKSRt91BnmHsCV42zYQdn/a9p64VrVwoAfmYrPfGBX+EyVRQsMtk2PDi72btVIHH04PHqpR9JogYpQ==\";s:17:\"digits_rtl_status\";s:64:\"IpS38V+XKV2Zcbjf1BUusIo8yFCEM1azb2ON9sXVtRCyI3xcnR9wd+ilHFWn2Lsh\";}","yes"),
("86966","digits_sameorigin_protection","1","yes"),
("86967","dig_login_rememberme","1","yes"),
("86968","dig_login_fields","a:6:{s:18:\"dig_login_username\";s:1:\"1\";s:15:\"dig_login_email\";s:1:\"1\";s:22:\"dig_login_mobilenumber\";s:1:\"1\";s:13:\"dig_login_otp\";s:1:\"1\";s:18:\"dig_login_password\";s:1:\"1\";s:17:\"dig_login_captcha\";s:1:\"0\";}","yes"),
("86969","dig_reg_fields","a:5:{s:12:\"dig_reg_name\";s:1:\"1\";s:13:\"dig_reg_uname\";s:1:\"0\";s:13:\"dig_reg_email\";s:1:\"1\";s:20:\"dig_reg_mobilenumber\";s:1:\"1\";s:16:\"dig_reg_password\";s:1:\"1\";}","yes"),
("86970","dig_sortorder","","yes"),
("86971","digit_tapp","13","yes"),
("86972","digit_api","a:3:{s:5:\"appid\";s:0:\"\";s:9:\"appsecret\";s:0:\"\";s:15:\"accountkit_type\";s:5:\"modal\";}","yes"),
("86973","digit_twilio_api","a:3:{s:9:\"twiliosid\";s:0:\"\";s:11:\"twiliotoken\";s:0:\"\";s:14:\"twiliosenderid\";s:0:\"\";}","yes"),
("86974","digit_msg91_api","a:3:{s:12:\"msg91authkey\";s:6:\"234234\";s:13:\"msg91senderid\";s:6:\"234234\";s:10:\"msg91route\";s:1:\"2\";}","yes"),
("86975","digit_yunpianapi","","yes"),
("86976","digit_ippanel","a:6:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";s:6:\"sample\";s:1:\"0\";s:11:\"patterncode\";s:0:\"\";s:11:\"patternvars\";s:0:\"\";}","yes"),
("86977","digit_payamresan","a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("86978","digit_kavenegar","a:0:{}","yes"),
("86979","digit_farazsms","a:6:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";s:6:\"sample\";s:1:\"0\";s:11:\"patterncode\";s:0:\"\";s:11:\"patternvars\";s:0:\"\";}","yes"),
("86980","digit_sms_ir","a:7:{s:6:\"apiKey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:6:\"sender\";s:0:\"\";s:6:\"sample\";s:1:\"0\";s:8:\"template\";s:0:\"\";s:9:\"variables\";s:0:\"\";s:8:\"clubsend\";s:1:\"0\";}","yes"),
("86981","digit_smsonline","a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("86982","digit_iransms","a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("86983","digit_niksms","a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("86984","digit_asanak_com","a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("86985","digit_modirpayamak_com","a:6:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";s:6:\"sample\";s:1:\"0\";s:11:\"patterncode\";s:0:\"\";s:11:\"patternvars\";s:0:\"\";}","yes"),
("86986","digit_melipayamak","a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"from\";s:0:\"\";}","yes"),
("86987","digit_farapayamak","a:0:{}","yes"),
("86988","digit_parsgreen_com","a:2:{s:9:\"signature\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("86989","digit_niazpardaz_ir","a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("86990","digit_whatsappغیرفعال","a:0:{}","yes"),
("86991","digit_whatsapptwilio","a:3:{s:11:\"account_sid\";s:6:\"qweqwe\";s:10:\"auth_token\";s:11:\"qweqwe3r232\";s:14:\"whatsappnumber\";s:8:\"56756757\";}","yes"),
("86992","digit_whatsappmessagebird","a:0:{}","yes"),
("86993","digit_whatsappkarix","a:0:{}","yes"),
("86994","digit_whatsappgupshup","a:0:{}","yes"),
("86995","digit_whatsapp_gateway","-1","yes"),
("86996","digonlylogintrans","ورود","yes"),
("86997","diglogintrans","ورود / عضویت","yes"),
("86998","digregistertrans","ورود به صفحه ثبت نام","yes"),
("86999","digforgottrans","رمز عبور را فراموش کرده اید؟","yes"),
("87000","digmyaccounttrans","حساب من","yes"),
("87001","diglogouttrans","خروج","yes"),
("87002","dig_messagetemplate","Your OTP for {NAME} is {OTP}","yes"),
("87003","dig_whatsapp_messagetemplate","576567567","yes"),
("87004","dig_otp_size","6","yes"),
("87005","digit_custom_css","","yes"),
("87006","dig_mobilein_uname","0","yes"),
("87007","dig_wp_login_inte","1","yes"),
("87008","dig_redirect_wc_to_dig","0","yes"),
("87009","dig_mobile_no_formatting","1","yes"),
("87010","digforgotpass","1","yes"),
("87011","dig_overwrite_forgotpass_link","1","yes"),
("87012","dig_enable_registration","1","yes"),
("87013","dig_show_asterisk","1","yes"),
("87014","dig_mob_otp_resend_time","30","yes"),
("87015","dig_use_strongpass","1","yes"),
("87016","login_reg_success_msg","1","yes"),
("87017","dig_reqfieldbilling","0","yes"),
("87018","enable_createcustomeronorder","1","yes"),
("87019","defaultuserrole","customer","yes"),
("87020","dig_default_ccode","Iran","yes"),
("87021","digit_color","a:23:{s:7:\"bgcolor\";s:7:\"#ede6ea\";s:13:\"loginboxcolor\";s:7:\"#ffffff\";s:2:\"sx\";s:1:\"0\";s:2:\"sy\";s:1:\"3\";s:5:\"sblur\";s:1:\"6\";s:7:\"sspread\";s:1:\"0\";s:7:\"sradius\";s:1:\"4\";s:6:\"scolor\";s:7:\"#000000\";s:10:\"fontcolor1\";s:7:\"#6d6d6d\";s:10:\"fontcolor2\";s:19:\"rgba(255,255,255,1)\";s:9:\"backcolor\";s:7:\"#000000\";s:4:\"type\";s:1:\"2\";s:10:\"left_color\";s:19:\"rgba(255,255,255,1)\";s:14:\"input_bg_color\";s:7:\"#ffffff\";s:18:\"input_border_color\";s:7:\"#999999\";s:16:\"input_text_color\";s:7:\"#000000\";s:15:\"button_bg_color\";s:7:\"#ffbc00\";s:19:\"signup_button_color\";s:7:\"#f2f2f2\";s:26:\"signup_button_border_color\";s:7:\"#d6d6d6\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:24:\"signup_button_text_color\";s:7:\"#6d6d6d\";s:12:\"left_bg_size\";s:4:\"auto\";s:16:\"left_bg_position\";s:13:\"Center Center\";}","yes"),
("87022","digit_color_modal","a:22:{s:7:\"bgcolor\";s:7:\"#060606\";s:13:\"loginboxcolor\";s:7:\"#fafafa\";s:2:\"sx\";s:1:\"0\";s:2:\"sy\";s:1:\"0\";s:5:\"sblur\";s:2:\"20\";s:7:\"sspread\";s:1:\"0\";s:7:\"sradius\";s:1:\"4\";s:6:\"scolor\";s:7:\"#000000\";s:10:\"fontcolor1\";s:7:\"#6d6d6d\";s:10:\"fontcolor2\";s:7:\"#333333\";s:4:\"type\";s:1:\"2\";s:10:\"left_color\";s:13:\"rgba(0,0,0,1)\";s:14:\"input_bg_color\";s:7:\"#ffffff\";s:18:\"input_border_color\";s:7:\"#999999\";s:16:\"input_text_color\";s:7:\"#000000\";s:15:\"button_bg_color\";s:7:\"#ffbc00\";s:19:\"signup_button_color\";s:7:\"#f2f2f2\";s:26:\"signup_button_border_color\";s:7:\"#d6d6d6\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:24:\"signup_button_text_color\";s:7:\"#6d6d6d\";s:12:\"left_bg_size\";s:4:\"auto\";s:16:\"left_bg_position\";s:13:\"Center Center\";}","yes"),
("87023","digits_logo_image","","yes"),
("87024","digits_bg_image_modal","","yes"),
("87025","digits_bg_image","","yes"),
("87026","digits_left_bg_image","https://demo.studiaretheme.ir/academy/wp-content/plugins/digits/assets/images/cart.png","yes"),
("87027","digits_left_bg_image_modal","https://demo.studiaretheme.ir/academy/wp-content/plugins/digits/assets/images/cart.png","yes"),
("87028","dig_preset","0","yes"),
("87029","login_page_footer","","yes"),
("87030","login_page_footer_text_color","rgba(255,255,255,1)","yes"),
("87031","digits_myaccount_redirect","","yes"),
("87032","digits_loginred","","yes"),
("87033","digits_regred","","yes"),
("87034","digits_forgotred","","yes"),
("87035","digits_logoutred","","yes"),
("93489","_woo_wallet_recharge_product","2386","yes"),
("93492","widget_woo-wallet-topup","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("93493","_wallet_enpoint_added","1","yes"),
("93494","_wallet_settings_extensions_general","","yes"),
("93495","_wallet_settings_general","","yes"),
("93496","_wallet_settings_credit","","yes"),
("93664","_woo_wallet_promotion_dismissed","1","yes"),
("96861","a3_lazy_load_version","2.4.5","yes"),
("96864","a3_lazy_load_global_settings","a:23:{s:20:\"a3l_apply_lazyloadxt\";b:1;s:19:\"a3l_apply_to_images\";b:1;s:26:\"a3l_apply_image_to_content\";b:1;s:29:\"a3l_apply_image_to_textwidget\";b:1;s:33:\"a3l_apply_image_to_postthumbnails\";b:1;s:28:\"a3l_apply_image_to_gravatars\";b:1;s:26:\"a3l_image_include_noscript\";b:1;s:25:\"a3l_skip_image_with_class\";s:0:\"\";s:33:\"a3l_horizontal_trigger_classnames\";s:0:\"\";s:19:\"a3l_apply_to_videos\";b:1;s:26:\"a3l_apply_video_to_content\";b:1;s:29:\"a3l_apply_video_to_textwidget\";b:1;s:26:\"a3l_video_include_noscript\";b:1;s:25:\"a3l_skip_video_with_class\";s:0:\"\";s:16:\"a3l_uris_exclude\";s:0:\"\";s:19:\"a3l_objects_exclude\";a:17:{s:4:\"home\";i:0;s:5:\"front\";i:0;s:4:\"post\";i:0;s:4:\"page\";i:0;s:8:\"category\";i:0;s:3:\"tag\";i:0;s:6:\"search\";i:0;s:6:\"author\";i:0;s:7:\"archive\";i:0;s:8:\"tp_event\";i:0;s:7:\"product\";i:0;s:7:\"teacher\";i:0;s:9:\"cdownload\";i:0;s:11:\"sc_megamenu\";i:0;s:15:\"sc_notification\";i:0;s:9:\"portfolio\";i:0;s:15:\"event_auth_book\";i:0;}s:16:\"a3l_theme_loader\";s:9:\"wp_footer\";s:27:\"a3l_load_disable_on_wptouch\";b:1;s:31:\"a3l_load_disable_on_mobilepress\";b:1;s:10:\"a3l_effect\";s:6:\"fadein\";s:21:\"a3l_effect_background\";s:7:\"#ffffff\";s:9:\"a3l_edgeY\";s:1:\"0\";s:42:\"a3l_jetpack_site_accelerator_compatibility\";b:0;}","yes"),
("96865","a3_lazy_load_clean_on_deletion","0","yes"),
("96954","a3_lazy_load_toggle_box_open","0","yes"),
("96955","a3_lazy_load_style_version","1619728316","yes"),
("98317","widget_namad_carousel","a:3:{i:2;a:5:{s:5:\"title\";s:12:\"نمادها\";s:9:\"namad_one\";s:189:\"&lt;a target=_blank&quot; href=&quot;https://samandehi.ir/&quot;&gt;&lt;img src=&quot;https://demo.studiaretheme.ir/academy/wp-content/uploads/2021/04/samandehi_logo.png&quot;&gt;&lt;/a&gt;\";s:9:\"namad_two\";s:183:\"&lt;a target=_blank&quot; href=&quot;https://enamad.ir/&quot;&gt;&lt;img src=&quot;https://demo.studiaretheme.ir/academy/wp-content/uploads/2021/04/enamad_logo.png&quot;&gt;&lt;/a&gt;\";s:11:\"namad_three\";s:0:\"\";s:10:\"namad_four\";s:0:\"\";}i:3;a:5:{s:5:\"title\";s:12:\"نمادها\";s:9:\"namad_one\";s:182:\"&lt;a target=&quot;_blank&quot; href=&quot;https://samandehi.ir/&quot;&gt;&lt;img src=&quot;https://studiaretheme.ir/wp-content/uploads/2021/04/samandehi_logo.png&quot;&gt;&lt;/a&gt;\";s:9:\"namad_two\";s:182:\"&lt;a target=&quot;_blank&quot;&quot; href=&quot;https://enamad.ir/&quot;&gt;&lt;img src=&quot;https://studiaretheme.ir/wp-content/uploads/2021/04/enamad_logo.png&quot;&gt;&lt;/a&gt;\";s:11:\"namad_three\";s:0:\"\";s:10:\"namad_four\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("98725","widget_akismet_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("98959","rsssl_remaining_tasks","1","yes"),
("98966","rsssl_current_version","8.1.3","no"),
("98972","rsssl_activation_timestamp","1674147584","no"),
("102643","woosw_list_NTCRSX","a:1:{i:1391;a:2:{s:4:\"time\";i:1620468954;s:4:\"note\";s:0:\"\";}}","yes"),
("103221","woosw_list_82S684","a:1:{i:75;a:2:{s:4:\"time\";i:1620547913;s:4:\"note\";s:0:\"\";}}","yes"),
("104862","woosw_list_5CXEIH","a:1:{i:1743;a:2:{s:4:\"time\";i:1620807742;s:4:\"note\";s:0:\"\";}}","yes"),
("105895","rsssl_mixed_content_scan_dismissed","1","no"),
("105896","rsssl_google_analytics_dismissed","1","no"),
("105899","woocommerce_woo_wallet_endpoint","woo-wallet","yes"),
("105900","woocommerce_woo_wallet_transactions_endpoint","woo-wallet-transactions","yes"),
("105906","wc_remote_inbox_notifications_wca_updated","","no"),
("105928","acf_version","5.9.5","yes"),
("105945","options_wcsts_subject_lenght","100","no"),
("105946","_options_wcsts_subject_lenght","field_57cd9dd76709c","no"),
("105947","options_wcsts_message_lenght","500","no"),
("105948","_options_wcsts_message_lenght","field_57cd9e3e6709d","no"),
("105949","options_wcsts_roles_can_manage_ticket_system","a:1:{i:0;s:0:\"\";}","no"),
("105950","_options_wcsts_roles_can_manage_ticket_system","field_57cda0182d364","no"),
("105951","options_wcsts_ticket_visibility","all_tickets","no"),
("105952","_options_wcsts_ticket_visibility","field_58877a24272d1","no"),
("105953","options_wcsts_display_ticket_status_on_frontend","yes","no"),
("105954","_options_wcsts_display_ticket_status_on_frontend","field_588c682cae593","no"),
("105955","options_wcsts_display_ticket_priority_selector_on_frontend","yes","no"),
("105956","_options_wcsts_display_ticket_priority_selector_on_frontend","field_590c2eb3c826d","no"),
("105957","options_wcsts_frontend_use_tiny_mce","0","no"),
("105958","_options_wcsts_frontend_use_tiny_mce","field_58c6c0b7c608a","no"),
("105959","options_wcsts_ticket_area_pagination","10","no"),
("105960","_options_wcsts_ticket_area_pagination","field_590072b5263f0","no"),
("105961","options_wcsts_display_user_ticket_area_in_my_account_page","yes","no"),
("105962","_options_wcsts_display_user_ticket_area_in_my_account_page","field_5854f7a01dcb2","no"),
("105963","options_wcsts_disable_user_ticket_opening","0","no"),
("105964","_options_wcsts_disable_user_ticket_opening","field_5c933b675f5cb","no"),
("105965","options_wcsts_user_tickect_area_url_endpoint","user-tickets","no"),
("105966","_options_wcsts_user_tickect_area_url_endpoint","field_5ae6c3c50b4eb","no"),
("105967","options_wcsts_is_order_ticket_enabled","yes","no"),
("105968","_options_wcsts_is_order_ticket_enabled","field_57d67d41bcfe7","no"),
("105969","options_wcsts_display_ticket_number_column_on_my_accont_order_table","1","no"),
("105970","_options_wcsts_display_ticket_number_column_on_my_accont_order_table","field_58c6ad3f705cf","no"),
("105971","options_wcsts_mark_ticket_as_closed_on_completed","0","no"),
("105972","_options_wcsts_mark_ticket_as_closed_on_completed","field_5d820a1c21e47","no"),
("105973","options_wcsts_order_ticket_area_position","woocommerce_order_details_after_order_table","no"),
("105974","_options_wcsts_order_ticket_area_position","field_59c29f519e37d","no"),
("105975","options_wcsts_order_ticket_system_disabled_order_statuses","a:1:{i:0;s:0:\"\";}","no"),
("105976","_options_wcsts_order_ticket_system_disabled_order_statuses","field_5847c90f7b40a","no"),
("105977","options_wcsts_display_order_status_on_order_tickets","1","no"),
("105978","_options_wcsts_display_order_status_on_order_tickets","field_59d24e3ef31b1","no"),
("105979","options_wcsts_order_ticket_limit","-1","no"),
("105980","_options_wcsts_order_ticket_limit","field_59df294ed4280","no"),
("105981","options_wcsts_deny_closed_ticket_reply","0","no"),
("105982","_options_wcsts_deny_closed_ticket_reply","field_5a25161211310","no"),
("105983","options_wcsts_order_ticket_disable_user_reply_until_admin_message","0","no"),
("105984","_options_wcsts_order_ticket_disable_user_reply_until_admin_message","field_5f893ca8c1f2c","no"),
("105985","options_wcsts_user_ticket_disable_user_reply_until_admin_message","0","no"),
("105986","_options_wcsts_user_ticket_disable_user_reply_until_admin_message","field_5f893d76c1f2d","no"),
("105987","options_wcsts_order_details_page_smooth_scroll","0","no"),
("105988","_options_wcsts_order_details_page_smooth_scroll","field_5a0eff8e13e9d","no"),
("105989","options_wcsts_disable_get_help_button","0","no"),
("105990","_options_wcsts_disable_get_help_button","field_5c431050ec342","no"),
("105991","options_wcsts_ticket_conversation_is_expansed","0","no"),
("105992","_options_wcsts_ticket_conversation_is_expansed","field_5a66f8ffc4b5c","no"),
("105993","options_wcsts_allow_files_attachment","1","no"),
("105994","_options_wcsts_allow_files_attachment","field_57ceba6a1373e","no"),
("105995","options_wcsts_num_of_uploadable_files","1","no"),
("105996","_options_wcsts_num_of_uploadable_files","field_57ceba931373f","no"),
("105997","options_wcsts_allowed_file_types","jpg, .pdf, .png","no"),
("105998","_options_wcsts_allowed_file_types","field_57cebab813740","no"),
("105999","options_wcsts_max_file_size","4096","no"),
("106000","_options_wcsts_max_file_size","field_57cebb4613741","no"),
("106001","options_wcsts_user_email_notifications","1","no"),
("106002","_options_wcsts_user_email_notifications","field_57d28c39a0404","no"),
("106003","options_wcsts_user_new_ticket_submission_notification","1","no"),
("106004","_options_wcsts_user_new_ticket_submission_notification","field_57d28bf1a0403","no"),
("106005","options_wcsts_user_reply_by_admin_notification","1","no"),
("106006","_options_wcsts_user_reply_by_admin_notification","field_57d28c81a0405","no"),
("106007","options_wcsts_admin_email_notifications","1","no"),
("106008","_options_wcsts_admin_email_notifications","field_57d28cf0a0406","no"),
("106009","options_wcsts_admin_new_ticket_submission_notification","1","no"),
("106010","_options_wcsts_admin_new_ticket_submission_notification","field_57d28d2aa0407","no"),
("106011","options_wcsts_admin_reply_by_user_notification","1","no"),
("106012","_options_wcsts_admin_reply_by_user_notification","field_57d28d90a0408","no"),
("106013","options_wcsts_admin_custom_email_recipiens","","no"),
("106014","_options_wcsts_admin_custom_email_recipiens","field_57d3d61a3ae48","no"),
("106015","options_wcsts_disable_email_header_and_footer","0","no"),
("106016","_options_wcsts_disable_email_header_and_footer","field_5a66f6ca6de96","no"),
("106017","options_wcst_email_from_address","","no"),
("106018","_options_wcst_email_from_address","field_5a66fb598baa6","no"),
("106019","options_wcsts_ppt_disable_payment_detection","0","no"),
("106020","_options_wcsts_ppt_disable_payment_detection","field_5cee5daf526dc","no"),
("106021","options_wcsts_open_ticket_automatically","0","no"),
("106022","_options_wcsts_open_ticket_automatically","field_5901ae40a7bf4","no"),
("106139","taxonomy_87","a:2:{s:16:\"background_color\";s:4:\"none\";s:10:\"text_color\";s:7:\"#000000\";}","yes"),
("106140","taxonomy_88","a:2:{s:16:\"background_color\";s:7:\"#dd3333\";s:10:\"text_color\";s:7:\"#ffffff\";}","yes"),
("106335","RTL-CareUnit-PIL","q1bKSS1LzVGyUnJMLsksSyzJzM9T0lEqLkksKS0GigaXJienFhcDhVJSi5OLMgvACqyUlGoB","no"),
("106339","RTL-CareUnit-PCS","8wkMrazyMSnJN9KucqxKi8pz1Q-oyi1ITYnysSx1S84IDnTxd_X3zg91zk9ODwoI8jIM9UsKN821zAxIzkx2tPTNdakIK69wiwy0MCkNKS4x8LI0Nw9OTXUMci50ighx9A_LzvQydK_U9zWxBQA","off"),
("106769","woocommerce_inbox_variant_assignment","11","yes"),
("107233","options_swss_subject_lenght","100","no"),
("107234","_options_swss_subject_lenght","field_57cd9dd76709c","no"),
("107235","options_swss_message_lenght","500","no"),
("107236","_options_swss_message_lenght","field_57cd9e3e6709d","no"),
("107237","options_swss_roles_can_manage_ticket_system","a:4:{i:0;s:13:\"administrator\";i:1;s:12:\"shop_manager\";i:2;s:17:\"swss_support_user\";i:3;s:0:\"\";}","no"),
("107238","_options_swss_roles_can_manage_ticket_system","field_57cda0182d364","no"),
("107239","options_swss_ticket_visibility","all_tickets","no"),
("107240","_options_swss_ticket_visibility","field_58877a24272d1","no"),
("107241","options_swss_display_ticket_status_on_frontend","yes","no"),
("107242","_options_swss_display_ticket_status_on_frontend","field_588c682cae593","no"),
("107243","options_swss_display_ticket_priority_selector_on_frontend","yes","no"),
("107244","_options_swss_display_ticket_priority_selector_on_frontend","field_590c2eb3c826d","no"),
("107245","options_swss_frontend_use_tiny_mce","0","no"),
("107246","_options_swss_frontend_use_tiny_mce","field_58c6c0b7c608a","no"),
("107247","options_swss_ticket_area_pagination","10","no"),
("107248","_options_swss_ticket_area_pagination","field_590072b5263f0","no"),
("107249","options_swss_display_user_ticket_area_in_my_account_page","yes","no"),
("107250","_options_swss_display_user_ticket_area_in_my_account_page","field_5854f7a01dcb2","no"),
("107251","options_swss_disable_user_ticket_opening","0","no"),
("107252","_options_swss_disable_user_ticket_opening","field_5c933b675f5cb","no"),
("107253","options_swss_user_tickect_area_url_endpoint","swss-user-tickets-area","no"),
("107254","_options_swss_user_tickect_area_url_endpoint","field_5ae6c3c50b4eb","no"),
("107255","options_swss_is_order_ticket_enabled","yes","no"),
("107256","_options_swss_is_order_ticket_enabled","field_57d67d41bcfe7","no"),
("107257","options_swss_display_ticket_number_column_on_my_accont_order_table","1","no"),
("107258","_options_swss_display_ticket_number_column_on_my_accont_order_table","field_58c6ad3f705cf","no"),
("107259","options_swss_mark_ticket_as_closed_on_completed","0","no"),
("107260","_options_swss_mark_ticket_as_closed_on_completed","field_5d820a1c21e47","no"),
("107261","options_swss_order_ticket_area_position","woocommerce_order_details_after_billing_and_shipping_details","no"),
("107262","_options_swss_order_ticket_area_position","field_59c29f519e37d","no"),
("107263","options_swss_order_ticket_system_disabled_order_statuses","a:1:{i:0;s:0:\"\";}","no"),
("107264","_options_swss_order_ticket_system_disabled_order_statuses","field_5847c90f7b40a","no"),
("107265","options_swss_display_order_status_on_order_tickets","1","no"),
("107266","_options_swss_display_order_status_on_order_tickets","field_59d24e3ef31b1","no"),
("107267","options_swss_order_ticket_limit","-1","no"),
("107268","_options_swss_order_ticket_limit","field_59df294ed4280","no"),
("107269","options_swss_deny_closed_ticket_reply","0","no"),
("107270","_options_swss_deny_closed_ticket_reply","field_5a25161211310","no"),
("107271","options_swss_order_ticket_disable_user_reply_until_admin_message","0","no"),
("107272","_options_swss_order_ticket_disable_user_reply_until_admin_message","field_5f893ca8c1f2c","no"),
("107273","options_swss_user_ticket_disable_user_reply_until_admin_message","0","no"),
("107274","_options_swss_user_ticket_disable_user_reply_until_admin_message","field_5f893d76c1f2d","no"),
("107275","options_swss_order_details_page_smooth_scroll","0","no"),
("107276","_options_swss_order_details_page_smooth_scroll","field_5a0eff8e13e9d","no"),
("107277","options_swss_disable_get_help_button","0","no"),
("107278","_options_swss_disable_get_help_button","field_5c431050ec342","no"),
("107279","options_swss_ticket_conversation_is_expansed","0","no"),
("107280","_options_swss_ticket_conversation_is_expansed","field_5a66f8ffc4b5c","no"),
("107281","options_swss_allow_files_attachment","1","no"),
("107282","_options_swss_allow_files_attachment","field_57ceba6a1373e","no"),
("107283","options_swss_user_email_notifications","1","no"),
("107284","_options_swss_user_email_notifications","field_57d28c39a0404","no"),
("107285","options_swss_user_new_ticket_submission_notification","1","no"),
("107286","_options_swss_user_new_ticket_submission_notification","field_57d28bf1a0403","no"),
("107287","options_swss_user_reply_by_admin_notification","1","no"),
("107288","_options_swss_user_reply_by_admin_notification","field_57d28c81a0405","no"),
("107289","options_swss_admin_email_notifications","1","no"),
("107290","_options_swss_admin_email_notifications","field_57d28cf0a0406","no"),
("107291","options_swss_admin_new_ticket_submission_notification","1","no"),
("107292","_options_swss_admin_new_ticket_submission_notification","field_57d28d2aa0407","no"),
("107293","options_swss_admin_reply_by_user_notification","1","no"),
("107294","_options_swss_admin_reply_by_user_notification","field_57d28d90a0408","no"),
("107295","options_swss_admin_custom_email_recipiens","","no"),
("107296","_options_swss_admin_custom_email_recipiens","field_57d3d61a3ae48","no"),
("107297","options_swss_disable_email_header_and_footer","0","no"),
("107298","_options_swss_disable_email_header_and_footer","field_5a66f6ca6de96","no"),
("107299","options_swss_ppt_disable_payment_detection","0","no"),
("107300","_options_swss_ppt_disable_payment_detection","field_5cee5daf526dc","no"),
("107301","options_swss_open_ticket_automatically","0","no"),
("107302","_options_swss_open_ticket_automatically","field_5901ae40a7bf4","no"),
("107309","options_swss_num_of_uploadable_files","4","no"),
("107310","_options_swss_num_of_uploadable_files","field_57ceba931373f","no"),
("107311","options_swss_allowed_file_types","","no"),
("107312","_options_swss_allowed_file_types","field_57cebab813740","no"),
("107313","options_swss_max_file_size","512","no"),
("107314","_options_swss_max_file_size","field_57cebb4613741","no"),
("107572","woocommerce_paypal_settings","a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:21:\"bagher.pebs@yahoo.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:21:\"bagher.pebs@yahoo.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}","yes"),
("107585","widget_block","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("107591","wp_force_deactivated_plugins","a:0:{}","off"),
("107957","redux-framework_tracking_last_send","1663978943","yes"),
("108171","woocommerce_downloads_redirect_fallback_allowed","no","no"),
("109965","woocommerce_analytics_enabled","no","yes"),
("110165","woocommerce_refund_returns_page_id","2628","yes"),
("110187","woo_wallet_product_review_settings","a:3:{s:7:\"enabled\";s:3:\"yes\";s:6:\"amount\";s:4:\"1000\";s:11:\"description\";s:89:\"اختصاص اعتبار برای بررسی هر محصول یا دوره آموزشی.\";}","yes"),
("110194","woo_wallet_referrals_settings","a:17:{s:7:\"enabled\";s:3:\"yes\";i:0;s:0:\"\";s:25:\"referring_visitors_amount\";s:2:\"10\";s:33:\"referring_visitors_limit_duration\";s:1:\"0\";s:24:\"referring_visitors_limit\";s:1:\"0\";s:30:\"referring_visitors_description\";s:63:\"اختصاص اعتبار برای هر بازدید کاربر\";i:1;s:0:\"\";s:24:\"referring_signups_amount\";s:2:\"10\";s:21:\"referral_order_amount\";s:1:\"0\";s:32:\"referring_signups_limit_duration\";s:1:\"0\";s:23:\"referring_signups_limit\";s:1:\"0\";s:29:\"referring_signups_description\";s:54:\"اختصاص اعتبار برای اعضای جدید\";i:2;s:0:\"\";s:12:\"referal_link\";s:2:\"id\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}","yes"),
("110241","woo_wallet_daily_visits_settings","a:4:{s:7:\"enabled\";s:3:\"yes\";s:6:\"amount\";s:2:\"10\";s:12:\"exclude_role\";s:0:\"\";s:11:\"description\";s:46:\"تعادل اعتبار بازدید سایت.\";}","yes"),
("110243","woo_wallet_new_registration_settings","a:3:{s:7:\"enabled\";s:3:\"yes\";s:6:\"amount\";s:5:\"10000\";s:11:\"description\";s:70:\"اختصاص اعتبار برای تبدیل شدن به یک عضو.\";}","yes"),
("110851","digits_survery_pop_redirect","1","yes"),
("110977","digit_firebase","a:1:{s:6:\"config\";s:10:\"سیسیس\";}","yes"),
("110978","digit_facebook","a:0:{}","yes"),
("110979","digit_twilio","a:0:{}","yes"),
("110980","digit_msg91","a:0:{}","yes"),
("110981","digit_messagebird","a:2:{s:9:\"accesskey\";s:0:\"\";s:10:\"originator\";s:0:\"\";}","yes"),
("110982","digit_plivo","a:3:{s:7:\"auth_id\";s:0:\"\";s:10:\"auth_token\";s:0:\"\";s:9:\"sender_id\";s:0:\"\";}","yes"),
("110983","digit_clicksend","a:3:{s:11:\"apiusername\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"from\";s:0:\"\";}","yes"),
("110984","digit_infobip","a:3:{s:8:\"base_url\";s:0:\"\";s:7:\"api_key\";s:0:\"\";s:4:\"from\";s:0:\"\";}","yes"),
("110985","digit_amazon_sns","a:0:{}","yes"),
("110986","digit_amazon_pinpoint","a:0:{}","yes"),
("110987","digit_alibaba","a:0:{}","yes"),
("110988","digit_alibaba_go_china","a:0:{}","yes"),
("110989","digit_clickatell","a:2:{s:7:\"api_key\";s:0:\"\";s:4:\"from\";s:0:\"\";}","yes"),
("110990","digit_clockwork","a:2:{s:12:\"clockworkapi\";s:0:\"\";s:4:\"from\";s:0:\"\";}","yes"),
("110991","digit_kaleyra","a:2:{s:7:\"api_key\";s:0:\"\";s:9:\"sender_id\";s:0:\"\";}","yes"),
("110992","digit_mobily_ws","a:0:{}","yes"),
("110993","digit_alfa_cell","a:0:{}","yes"),
("110994","digit_nexmo","a:3:{s:7:\"api_key\";s:0:\"\";s:10:\"api_secret\";s:0:\"\";s:4:\"from\";s:0:\"\";}","yes"),
("110995","digit_smsapi","a:2:{s:5:\"token\";s:0:\"\";s:4:\"from\";s:0:\"\";}","yes"),
("110996","digit_africas_talking","a:3:{s:8:\"username\";s:0:\"\";s:7:\"api_key\";s:0:\"\";s:4:\"from\";s:0:\"\";}","yes"),
("110997","digit_textlocal","a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("110998","digit_unifonic","a:2:{s:6:\"appsid\";s:0:\"\";s:8:\"senderid\";s:0:\"\";}","yes"),
("110999","digit_adnsms","a:0:{}","yes"),
("111000","digit_netgsm","a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"from\";s:0:\"\";}","yes"),
("111001","digit_smsc_ru","a:3:{s:5:\"login\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("111002","digit_targetsms","a:0:{}","yes"),
("111003","digit_ghasedak","a:0:{}","yes"),
("111004","digit_sendinblue","a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("111005","digit_ibulksms","a:0:{}","yes"),
("111006","digit_yunpian","a:0:{}","yes"),
("111007","digit_sms123","a:0:{}","yes"),
("111008","digit_opersms","a:0:{}","yes"),
("111009","digit_sparrowsms","a:0:{}","yes"),
("111010","digit_adpdigital","a:0:{}","yes"),
("111011","digit_spryng","a:2:{s:12:\"bearer_token\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("111012","digit_karix","a:0:{}","yes"),
("111013","digit_bandwidth","a:5:{s:3:\"uid\";s:0:\"\";s:5:\"token\";s:0:\"\";s:14:\"application_id\";s:0:\"\";s:10:\"account_id\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("111014","digit_cdyne","a:0:{}","yes"),
("111015","digit_engagespark","a:0:{}","yes"),
("111016","digit_kapsystem","a:0:{}","yes"),
("111017","digit_telestax","a:0:{}","yes"),
("111018","digit_ttagsystems","a:0:{}","yes"),
("111019","digit_wavecell","a:0:{}","yes"),
("111020","digit_smsaero","a:0:{}","yes"),
("111021","digit_gatewayapi","a:0:{}","yes"),
("111022","digit_agiletelecom","a:0:{}","yes"),
("111023","digit_greentext","a:0:{}","yes"),
("111024","digit_mnotify","a:0:{}","yes"),
("111025","digit_smsbroadcast","a:0:{}","yes"),
("111026","digit_smsgatewayhub","a:0:{}","yes"),
("111027","digit_thaibulksms","a:0:{}","yes"),
("111028","digit_smscountry","a:0:{}","yes"),
("111029","digit_textmagic","a:0:{}","yes"),
("111030","digit_qsms","a:0:{}","yes"),
("111031","digit_smsfactor","a:0:{}","yes"),
("111032","digit_esms","a:0:{}","yes"),
("111033","digit_isms","a:0:{}","yes"),
("111034","digit_textplode","a:0:{}","yes"),
("111035","digit_routesms","a:0:{}","yes"),
("111036","digit_skebby","a:0:{}","yes"),
("111037","digit_sendhub","a:0:{}","yes"),
("111038","digit_proovl","a:0:{}","yes"),
("111039","digit_tyntec","a:0:{}","yes"),
("111040","digit_bulksmsnigeria","a:0:{}","yes"),
("111041","digit_bulksms","a:0:{}","yes"),
("111042","digit_esendex","a:4:{s:17:\"account_reference\";s:0:\"\";s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("111043","digit_websms","a:0:{}","yes"),
("111044","digit_smsglobal","a:0:{}","yes"),
("111045","digit_fortytwo","a:2:{s:19:\"authorization_token\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("111046","digit_primotexto","a:0:{}","yes"),
("111047","digit_spirius","a:0:{}","yes"),
("111048","digit_experttexting","a:0:{}","yes"),
("111049","digit_jusibe","a:0:{}","yes"),
("111050","digit_mensatek","a:0:{}","yes"),
("111051","digit_speedsms","a:0:{}","yes"),
("111052","digit_smsmisr","a:0:{}","yes"),
("111053","digit_jazzcmt","a:0:{}","yes"),
("111054","digit_moceansms","a:0:{}","yes"),
("111055","digit_sendsms247","a:0:{}","yes"),
("111056","digit_smscua","a:0:{}","yes"),
("111057","digit_cpsms","a:0:{}","yes"),
("111058","digit_1s2u","a:0:{}","yes"),
("111059","digit_textanywhere","a:0:{}","yes"),
("111060","digit_sms77","a:0:{}","yes"),
("111061","digit_verimor","a:0:{}","yes"),
("111062","digit_labsmobile","a:0:{}","yes"),
("111063","digit_unisender","a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("111064","digit_aruba","a:0:{}","yes"),
("111065","digit_comilio","a:0:{}","yes"),
("111066","digit_smshosting","a:0:{}","yes"),
("111067","digit_gateway","a:0:{}","yes"),
("111068","digit_uwaziimobile","a:0:{}","yes"),
("111069","digit_suresms","a:0:{}","yes"),
("111070","digit_easysendsms","a:0:{}","yes"),
("111071","digit_sinch","a:3:{s:12:\"bearer_token\";s:0:\"\";s:15:\"service_plan_id\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("111072","digit_smsala","a:0:{}","yes"),
("111073","digit_smsempresa","a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("111074","digit_semaphore","a:0:{}","yes"),
("111075","digit_wavy","a:2:{s:8:\"username\";s:0:\"\";s:20:\"authentication_token\";s:0:\"\";}","yes"),
("111076","digit_smsto","a:0:{}","yes"),
("111077","digit_telnyx","a:0:{}","yes"),
("111078","digit_telesign","a:0:{}","yes"),
("111079","digit_d7networks","a:0:{}","yes"),
("111080","digit_ismsindonesia","a:0:{}","yes"),
("111081","digit_sendpk","a:0:{}","yes"),
("111082","digit_mimsms","a:0:{}","yes"),
("111083","digit_openmarket","a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("111084","digit_mobyt","a:0:{}","yes"),
("111085","digit_tm4b","a:0:{}","yes"),
("111086","digit_swiftsmsgateway","a:0:{}","yes"),
("111087","digit_2factor","a:0:{}","yes"),
("111088","digit_gupshup","a:0:{}","yes"),
("111089","digit_digimiles","a:0:{}","yes"),
("111090","digit_callfire","a:0:{}","yes"),
("111091","digit_nowsms","a:0:{}","yes"),
("111092","digit_releans","a:0:{}","yes"),
("111093","digit_zipwhip","a:0:{}","yes"),
("111094","digit_messagemedia","a:0:{}","yes"),
("111095","digit_thesmsworks","a:0:{}","yes"),
("111096","digit_mogreet","a:0:{}","yes"),
("111097","digit_46elks","a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}","yes"),
("111098","digit_slicktext","a:0:{}","yes"),
("111099","digit_smsidea","a:0:{}","yes"),
("111100","digit_tatango","a:0:{}","yes"),
("111101","digit_smsedge","a:0:{}","yes"),
("111102","digit_smsmasivos","a:0:{}","yes"),
("111103","digit_commzgate","a:0:{}","yes"),
("111104","digit_sms_ru","a:0:{}","yes"),
("111105","digit_messente","a:0:{}","yes"),
("111106","digit_text_marketer","a:0:{}","yes"),
("111107","digit_spring_edge","a:0:{}","yes"),
("111108","digit_signalwire","a:0:{}","yes"),
("111109","digit_camoo","a:0:{}","yes"),
("111110","digit_cm_com","a:0:{}","yes"),
("111111","digit_ooredoo_sms","a:0:{}","yes"),
("111112","digit_max-sms","a:0:{}","yes"),
("111113","digit_payam_resan","a:0:{}","yes"),
("111114","digit_foxglove","a:0:{}","yes"),
("111115","digit_txtsync","a:0:{}","yes"),
("111116","digit_serwersms","a:0:{}","yes"),
("111117","digit_orange_gateway","a:0:{}","yes"),
("111118","digit_msegat","a:0:{}","yes"),
("111119","digit_altiria","a:0:{}","yes"),
("111120","digit_redsms","a:0:{}","yes"),
("111121","digit_osonsms","a:0:{}","yes"),
("111122","digit_dooae","a:0:{}","yes"),
("111123","digit_smsir_gateway","a:0:{}","yes"),
("111124","digit_notify_lk","a:0:{}","yes"),
("111125","digit_malath","a:0:{}","yes"),
("111126","digit_smsalert","a:0:{}","yes"),
("111127","digit_turkeysms","a:0:{}","yes"),
("111128","digit_sozuri","a:0:{}","yes"),
("111129","digit_kivalo","a:0:{}","yes"),
("111130","digit_sms_ninja","a:0:{}","yes"),
("111131","digit_sms_mode","a:0:{}","yes"),
("111132","digit_brandedsmspakistan","a:0:{}","yes"),
("111133","digit_sms_routee","a:0:{}","yes");

INSERT IGNORE INTO `wp_options` VALUES 
("111134","digit_web2sms237","a:0:{}","yes"),
("111135","digit_beeline","a:0:{}","yes"),
("111136","digit_sms_cc","a:0:{}","yes"),
("111137","digit_nhn_toast","a:0:{}","yes"),
("111138","digit_hubtel","a:0:{}","yes"),
("111139","digit_globelabs","a:0:{}","yes"),
("111140","digit_custom_gateway","a:8:{s:11:\"gateway_url\";s:0:\"\";s:11:\"http_header\";s:0:\"\";s:11:\"http_method\";s:3:\"GET\";s:18:\"gateway_attributes\";s:0:\"\";s:14:\"send_body_data\";s:1:\"0\";s:14:\"encode_message\";s:1:\"0\";s:12:\"phone_number\";s:1:\"1\";s:9:\"sender_id\";s:0:\"\";}","yes"),
("111217","dig_unr","1629698961","no"),
("111409","rsssl_port_check_2082","success","yes"),
("111646","rsssl_all_tasks","","yes"),
("112106","elementor_active_kit","2679","yes"),
("112111","elementor_version","3.31.3","yes"),
("112112","elementor_install_history","a:77:{s:5:\"3.4.1\";i:1639140847;s:5:\"3.4.5\";i:1634296060;s:5:\"3.4.6\";i:1634847780;s:5:\"3.4.7\";i:1635887306;s:5:\"3.4.8\";i:1639140848;s:5:\"3.5.0\";i:1639591260;s:5:\"3.5.2\";i:1650655700;s:5:\"3.5.3\";i:1641462893;s:5:\"3.5.4\";i:1643142335;s:5:\"3.5.5\";i:1643947046;s:5:\"3.5.6\";i:1646990722;s:5:\"3.6.1\";i:1648925940;s:5:\"3.6.2\";i:1649240357;s:5:\"3.6.3\";i:1649836462;s:5:\"3.6.4\";i:1650655701;s:5:\"3.6.5\";i:1651576445;s:5:\"3.6.6\";i:1655361117;s:5:\"3.6.7\";i:1657086672;s:5:\"3.6.8\";i:1659037620;s:5:\"3.7.1\";i:1660902406;s:5:\"3.7.2\";i:1661257075;s:5:\"3.7.4\";i:1662175269;s:5:\"3.7.5\";i:1663173823;s:5:\"3.7.7\";i:1664089778;s:5:\"3.7.8\";i:1664779047;s:5:\"3.8.1\";i:1669969595;s:5:\"3.8.2\";i:1675250778;s:5:\"3.9.2\";i:1672239437;s:6:\"3.10.0\";i:1673470781;s:6:\"3.10.1\";i:1674111953;s:6:\"3.10.2\";i:1675250779;s:6:\"3.11.0\";i:1676289033;s:6:\"3.11.1\";i:1676490333;s:6:\"3.11.2\";i:1677249383;s:6:\"3.11.3\";i:1678215304;s:6:\"3.11.5\";i:1678911229;s:6:\"3.12.1\";i:1682020936;s:6:\"3.12.2\";i:1682275944;s:6:\"3.13.1\";i:1683814480;s:6:\"3.14.0\";i:1687329223;s:6:\"3.14.1\";i:1689058901;s:6:\"3.15.0\";i:1690906806;s:6:\"3.15.1\";i:1691136896;s:6:\"3.15.2\";i:1691602399;s:6:\"3.15.3\";i:1694437715;s:6:\"3.16.2\";i:1694677810;s:6:\"3.16.3\";i:1694721856;s:6:\"3.16.4\";i:1695467408;s:6:\"3.16.5\";i:1697516614;s:6:\"3.16.6\";i:1697823872;s:6:\"3.17.1\";i:1698314957;s:6:\"3.17.2\";i:1699074802;s:6:\"3.17.3\";i:1699736742;s:6:\"3.18.0\";i:1701867064;s:6:\"3.18.1\";i:1701895854;s:6:\"3.18.2\";i:1702184753;s:6:\"3.18.3\";i:1703145827;s:6:\"3.19.0\";i:1707031611;s:6:\"3.19.1\";i:1707195708;s:6:\"3.19.2\";i:1707636056;s:6:\"3.19.3\";i:1709100033;s:6:\"3.19.4\";i:1709212474;s:6:\"3.20.0\";i:1710159482;s:6:\"3.20.1\";i:1710797414;s:6:\"3.20.2\";i:1710970708;s:6:\"3.20.3\";i:1711514023;s:6:\"3.21.0\";i:1713383704;s:6:\"3.21.1\";i:1713458617;s:6:\"3.21.3\";i:1714236128;s:6:\"3.21.7\";i:1716717252;s:6:\"3.21.8\";i:1717663922;s:6:\"3.25.3\";i:1730555563;s:6:\"3.25.4\";i:1730697104;s:6:\"3.26.2\";i:1734850689;s:6:\"3.26.3\";i:1734956600;s:6:\"3.28.4\";i:1745785025;s:6:\"3.31.3\";i:1757131735;}","yes"),
("112113","elementor_pro_version","3.31.2","yes"),
("112114","widget_elementor-library","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("112116","_elementor_pro_installed_time","1634296061","yes"),
("112117","elementor_submissions_db_version","5","yes"),
("112118","_elementor_installed_time","1634296062","yes"),
("112119","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}","off"),
("112120","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:100:\"Introducing Elementor 3.30: new Editor V4 capabilities, full Website Templates in the cloud, & more!\";s:7:\"excerpt\";s:361:\"Elementor 3.30 is here and it includes upgrades that accelerate your workflow, bring you a step closer to the full power of Editor V4, and help you deliver beautiful, accessible websites faster than ever. From advanced styling tools and smarter editing to full Website Templates in the cloud, this release enhances both the way you design and the way you scale.\";s:7:\"created\";i:1751974442;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-330-v4-alpha-website-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","off"),
("112124","_elementor_pro_api_requests_lock","a:2:{s:11:\"get_version\";i:1757131760;s:16:\"get_license_data\";i:1644089726;}","yes"),
("112136","woocommerce_task_list_hidden_lists","a:1:{i:0;s:5:\"setup\";}","yes"),
("112154","elementor_log","a:43:{s:32:\"42e77eb5af0545b1e8bf1cbe09effaab\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-11-04 08:41:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-11-04 08:41:44\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"fa50e18821d73869acba7da6057be4dc\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-11-04 08:41:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-11-04 08:41:44\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"54f6438e30691a6cf1569c2f88e083d5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-11-04 08:41:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.3\";s:2:\"to\";s:6:\"3.25.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-11-04 08:41:44\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.3\";s:2:\"to\";s:6:\"3.25.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ea3934b717d77d39ab758325074f1a8c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-11-04 08:41:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.3\";s:2:\"to\";s:6:\"3.25.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-11-04 08:41:45\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.3\";s:2:\"to\";s:6:\"3.25.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"cafcb78989c50fa5c23f8a737e23b468\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-22 10:28:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-22 10:28:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"db983fd0b1c87e6b0ce57c1d142d98fb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-22 10:28:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-22 10:28:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"3d3587e672201b366d8e3c2f4010f6f7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-22 10:28:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-22 10:28:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"db39db61b9b0b87ba7fbbfb0f9c4ba65\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-22 10:28:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.4\";s:2:\"to\";s:6:\"3.26.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-22 10:28:09\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.4\";s:2:\"to\";s:6:\"3.26.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"eae057eb78b63352fa4c2ddb342297ab\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-22 10:40:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-22 10:40:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"2d3597239867f7f7f2ac5af30ade9df9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-22 10:40:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-22 10:40:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"9e92dc644a9b6d9cf044b2d87e099ee5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-22 10:40:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-22 10:40:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"bd6544122d9ce652d3f631e8ff85538b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-22 10:40:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.25.1\";s:2:\"to\";s:6:\"3.26.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-22 10:40:00\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.25.1\";s:2:\"to\";s:6:\"3.26.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c045397e9738dfbb2f23d44a775530dd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-22 10:40:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.25.1\";s:2:\"to\";s:6:\"3.26.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-22 10:40:02\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.25.1\";s:2:\"to\";s:6:\"3.26.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"284e9189e74f20c250214088cdd0812a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-23 15:53:18\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.26.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-23 15:53:18\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.26.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"57036ca557f25da6921218d792ecaa9f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-23 15:53:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-23 15:53:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"58646214825bd54e23691468dbb4e7a5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-23 15:53:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-23 15:53:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"83c0934576ef9746b9d4bf44d61908ac\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-23 15:53:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-23 15:53:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"358c8a037d232e35d68d9ebc92faf72f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-23 15:53:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.26.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-23 15:53:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.26.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"a537548027342cb28a0f59c33d9db9fe\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-23 15:53:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.26.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-23 15:53:21\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.26.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c1c456cb2b96658dc7f006df8893b17c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-27 23:47:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-27 23:47:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"9434ed9ecb211fc95a66f1da50765270\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-27 23:47:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-27 23:47:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"063a7fed0a932ab142d336048838029b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-27 23:47:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-27 23:47:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"19de244fa613fdc3fe483377b1496b94\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-27 23:47:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-27 23:47:05\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c67a51344ee26005c80687a1d245f929\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 00:04:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 00:04:44\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"dfab24190c60cb4ede2df909a687fd81\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 00:04:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 00:04:44\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"107e352c293ccb6b6813f0e1c4dde12f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 00:04:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 00:04:44\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"f9a604add32159f7291deb33451a1d5b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 00:04:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.26.0\";s:2:\"to\";s:6:\"3.27.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 00:04:44\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.26.0\";s:2:\"to\";s:6:\"3.27.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d6b76c813df44649fc4b9f516f6079aa\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-04-28 21:57:07\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:31:\"Undefined index: condition_type\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:135:\"/home/studiar1/demo.studiaretheme.ir/academy/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:150;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:3:{s:8:\"function\";s:28:\"normalize_template_json_item\";s:5:\"class\";s:65:\"ElementorPro\\Core\\App\\Modules\\SiteEditor\\Data\\Endpoints\\Templates\";s:4:\"type\";s:2:\"->\";}i:2;a:3:{s:4:\"file\";s:135:\"/home/studiar1/demo.studiaretheme.ir/academy/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:120;s:8:\"function\";s:9:\"array_map\";}i:3;a:5:{s:4:\"file\";s:135:\"/home/studiar1/demo.studiaretheme.ir/academy/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:59;s:8:\"function\";s:24:\"normalize_templates_json\";s:5:\"class\";s:65:\"ElementorPro\\Core\\App\\Modules\\SiteEditor\\Data\\Endpoints\\Templates\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:96:\"/home/studiar1/demo.studiaretheme.ir/academy/wp-content/plugins/elementor/data/base/endpoint.php\";s:4:\"line\";i:156;s:8:\"function\";s:9:\"get_items\";s:5:\"class\";s:65:\"ElementorPro\\Core\\App\\Modules\\SiteEditor\\Data\\Endpoints\\Templates\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2025-04-28 21:57:07\";i:1;s:19:\"2025-04-28 23:53:31\";i:2;s:19:\"2025-04-29 09:02:14\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:31:\"Undefined index: condition_type\";s:4:\"file\";s:135:\"/home/studiar1/demo.studiaretheme.ir/academy/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:150;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:135:\"/home/studiar1/demo.studiaretheme.ir/academy/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:7:\"\0*\0line\";i:150;}s:32:\"675acde6085e1e3747b6a336d8e53e6c\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-04-29 08:04:20\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:70:\"Cannot read properties of undefined (reading &#039;isDesignable&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:10;s:14:\"\0*\0times_dates\";a:10:{i:0;s:19:\"2025-04-29 08:04:20\";i:1;s:19:\"2025-04-29 08:25:28\";i:2;s:19:\"2025-04-29 08:28:42\";i:3;s:19:\"2025-04-29 08:29:15\";i:4;s:19:\"2025-04-29 08:30:22\";i:5;s:19:\"2025-04-29 08:30:54\";i:6;s:19:\"2025-04-29 08:33:13\";i:7;s:19:\"2025-04-29 08:39:15\";i:8;s:19:\"2025-04-29 09:01:08\";i:9;s:19:\"2025-04-29 09:03:10\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1745913860\";s:7:\"message\";s:60:\"Cannot read properties of undefined (reading \'isDesignable\')\";s:3:\"url\";s:101: