<?php
/**
 * @since version 12.8
 * 
 * Post type studi_lessons added
 * 
 */
 
class Studiare_Studi_Lesson {
    public function __construct() {
        add_action('init', array($this, 'register_post_type'));
        // Filter by product (post parent)
        add_action('restrict_manage_posts', array($this, 'add_parent_post_filter'));
        add_filter('parse_query', array($this, 'filter_posts_by_parent_post'));
        // Add custom field in the edit screen
        add_action('add_meta_boxes', array($this, 'add_parent_post_meta_box'));
        add_filter('manage_studi_lesson_posts_columns', array($this, 'add_custom_column'));
        add_action('manage_studi_lesson_posts_custom_column', array($this, 'display_custom_column_data'), 10, 2);
        add_action('cmb2_admin_init', array($this, 'course_metaboxes'), 10, 2);
        
        // Add AJAX search functionality
        add_action('admin_enqueue_scripts', array($this, 'enqueue_ajax_scripts'));
        add_action('wp_ajax_sc_download_search', array($this, 'sc_download_search_callback'));
        add_action('wp_ajax_nopriv_sc_download_search', array($this, 'sc_download_search_callback'));
    }
    
    // Enqueue necessary scripts for AJAX search
    public function enqueue_ajax_scripts() {
        $class_file_path = plugins_url('', __FILE__);
        wp_enqueue_script('sc-ajax-search', $class_file_path . '/ajax-search.js', array('jquery'), '1.0', true);
        wp_localize_script('sc-ajax-search', 'sc_ajax', array(
            'ajaxurl' => admin_url('admin-ajax.php'),
        ));
        
        // Check if WooCommerce is active
        if (is_plugin_active('woocommerce/woocommerce.php')) {
            // Check if Select2 is not already enqueued
            if (!wp_script_is('select2', 'enqueued')) {
                // Enqueue Select2 script
                wp_enqueue_script('select2', $class_file_path . '/select2.full.min.js', array('jquery'), '4.0.13', true);
            }
        }
    }

    // AJAX search callback
    public function sc_download_search_callback() {
        $return = array();
        $sched_results = new WP_Query(array(
            's' => sanitize_text_field($_GET['q']),
            'post_type' => 'cdownload',
            'post_status' => 'publish'
        ));
        if ($sched_results->have_posts()) :
            while ($sched_results->have_posts()) : $sched_results->the_post();
                $title = (mb_strlen($sched_results->post->post_title) > 50) ? mb_substr($sched_results->post->post_title, 0, 49) . '...' : $sched_results->post->post_title;
                $return[] = array($sched_results->post->ID, $title);
            endwhile;
        endif;
        echo json_encode($return);
        wp_die();
    }

    public function register_post_type() {
        $labels = array(
            'name' => __('Lessons', 'studiare-core'),
            'singular_name' => __('Lesson', 'studiare-core'),
            'menu_name' => __('Lessons', 'studiare-core'),
            'name_admin_bar' => __('Lesson', 'studiare-core'),
            'add_new' => __('Add New', 'studiare-core'),
            'add_new_item' => __('Add New Lesson', 'studiare-core'),
            'new_item' => __('New Lesson', 'studiare-core'),
            'edit_item' => __('Edit Lesson', 'studiare-core'),
            'view_item' => __('View Lesson', 'studiare-core'),
            'all_items' => __('All Lessons', 'studiare-core'),
            'search_items' => __('Search Lessons', 'studiare-core'),
            'parent_item_colon' => __('Parent Lessons:', 'studiare-core'),
            'not_found' => __('No lessons found.', 'studiare-core'),
            'not_found_in_trash' => __('No lessons found in Trash.', 'studiare-core')
        );

        $args = array(
            'labels' => $labels,
            'public' => false,
            'publicly_queryable' => false,
            'show_ui' => true,
            'show_in_menu' => 'studiare_panel',
            'query_var' => true,
            'rewrite' => array('slug' => 'studi_lesson'),
            'has_archive' => false,
            'hierarchical' => false,
            'menu_position' => null,
            'exclude_from_search' => true,
            'menu_icon' => 'dashicons-welcome-learn-more',
            'supports' => array('title', 'editor', 'author')
        );

        register_post_type('studi_lesson', $args);
    }
    
    public function add_parent_post_filter() {
        global $typenow;
        if ($typenow === 'studi_lesson') {
            $selected_parent = isset($_GET['parent_post']) ? $_GET['parent_post'] : '';
            $parent_args = array(
                'post_type' => 'product',
                'posts_per_page' => -1,
                'exclude' => get_the_ID()
            );
            $parent_posts = get_posts($parent_args);
            ?>
            <label for="filter-by-parent-post"><?php echo __('Filter by Parent Course:', 'studiare-core'); ?></label>
            <select name="parent_post" id="filter-by-parent-post">
                <option value=""><?php echo __('All', 'studiare-core'); ?></option>
                <?php foreach ($parent_posts as $parent_post) { ?>
                    <option value="<?php echo $parent_post->ID; ?>" <?php selected($parent_post->ID, $selected_parent); ?>><?php echo $parent_post->post_title; ?></option>
                <?php } ?>
            </select>
            <?php
        }
    }
    
    public function filter_posts_by_parent_post($query) {
        global $pagenow;
        $post_type = isset($query->query['post_type']) ? $query->query['post_type'] : '';
        $parent_post = isset($_GET['parent_post']) ? $_GET['parent_post'] : '';

        if ($pagenow === 'edit.php' && $post_type === 'studi_lesson' && !empty($parent_post)) {
            $query->query_vars['post_parent'] = $parent_post;
        }
    }
    
    public function add_parent_post_meta_box() {
        add_meta_box('parent_post_meta_box', __('Parent Course', 'studiare-core'), array($this, 'display_parent_post_meta_box'), 'studi_lesson', 'side');
    }
    
    public function display_parent_post_meta_box($post) {
        $parent_id = $post->post_parent;
        ?>
        <label for="post_parent"><?php echo __('Select Parent Course', 'studiare-core'); ?> </label>
        <select name="post_parent" id="post_parent">
            <option value=""><?php echo __('None', 'studiare-core'); ?></option>
            <?php
            $parent_args = array(
                'post_type' => 'product',
                'posts_per_page' => -1,
                'exclude' => $post->ID
            );
            $parent_posts = get_posts($parent_args);
            foreach ($parent_posts as $parent_post) {
                ?>
                <option value="<?php echo $parent_post->ID; ?>" <?php selected($parent_post->ID, $parent_id); ?>><?php echo $parent_post->post_title; ?></option>
                <?php
            }
            ?>
        </select>
        <?php
    }
    
    public function add_custom_column($columns) {
        unset($columns['post_views']); // Remove the 'view' column
        $columns['parent_post'] = __('Parent Course', 'studiare-core');
        return $columns;
    }
    
    public function display_custom_column_data($column, $post_id) {
        if ($column == 'parent_post') {
            $parent_id = wp_get_post_parent_id($post_id);
            $parent_post = get_post($parent_id);
            if ($parent_post && $parent_post->ID != $post_id) {
                echo $parent_post->post_title;
            } else {
                echo '-';
            }
        }
    }
    
    public function course_metaboxes() {
        // Start with an underscore to hide fields from custom fields list
        $prefix = '_studiare_';
        $sc_course_options = new_cmb2_box(array(
            'id' => 'sc_course_options_box',
            'title' => esc_html__('Lesson informations', 'studiare-core'),
            'object_types' => array('studi_lesson'),
            'context' => 'normal',
            'priority' => 'high',
            'show_names' => true,
        ));
        
        $lesson_data = $sc_course_options->add_field(array(
            'id' => 'lesson_data',
            'type' => 'group',
            'repeatable' => false,
            'options' => array(
                'group_title' => esc_html__('Lesson Data', 'studiare-core') . ' {#}',
                'add_button' => esc_html__('New', 'studiare-core'),
                'remove_button' => esc_html__('Remove', 'studiare-core'),
                'closed' => false, // Repeater fields closed by default - neat & compact.
                'sortable' => false, // Allow changing the order of repeated groups.
            ),
        ));
        
        $sc_course_options->add_group_field($lesson_data, array(
            'name' => __('Icon', 'studiare-core'),
            'default' => '',
            'id' => 'icon',
            'type' => 'fontawesome_icon',
        ));
        
        $sc_course_options->add_group_field($lesson_data, array(
            'name' => __('Lesson Title', 'studiare-core'),
            'default' => '',
            'id' => 'lesson_title',
            'type' => 'text',
        ));
        $sc_course_options->add_group_field($lesson_data, array(
            'name' => __('Lesson Subtitle', 'studiare-core'),
            'default' => '',
            'id' => 'lesson_subtitle',
            'type' => 'text',
        ));
        
        $sc_course_options->add_group_field($lesson_data, array(
            'name' => __('Section Badge', 'studiare-core'),
            'id' => 'badge',
            'type' => 'select',
            'show_option_none' => false,
            'default' => 'no_badge',
            'options' => array(
                'no_badge' => __('Select', 'studiare-core'),
                'video' => __('Video', 'studiare-core'),
                'exam' => __('Exam', 'studiare-core'),
                'quiz' => __('Quiz', 'studiare-core'),
                'lecture' => __('Lecture', 'studiare-core'),
                'free' => __('Free', 'studiare-core'),
                'practice' => __('Practice', 'studiare-core'),
            ),
        ));
        $sc_course_options->add_group_field($lesson_data, array(
            'id' => 'lesson_divider_0',
            'type' => 'title',
            'name' => '',
            'desc' => '<hr>',
        ));
        $sc_course_options->add_group_field($lesson_data, array(
            'name' => __('Preview Video', 'studiare-core'),
            'default' => '',
            'desc' => esc_html__('Insert Video File Link to show for sample teaching', 'studiare-core'),
            'id' => 'preview_video',
            'type' => 'text',
        ));
        
        $sc_course_options->add_group_field($lesson_data, array(
            'id' => 'lesson_divider_1',
            'type' => 'title',
            'name' => '',
            'desc' => '<hr>',
        ));
        
        $sc_course_options->add_group_field($lesson_data, array(
            'name' => __('Lesson Video', 'studiare-core'),
            'default' => '',
            'desc' => wp_kses(
                __('Enter the link to an <strong>m3u8</strong> file (recommended for security) or an mp4 file. Example: https://download.site.com/videos/output.m3u8 or https://site.com/video/1.mp4. This is explained in the Studiare theme PDF guide.', 'studiare-core'),
                array('strong' => array())
            ),
            'id' => 'lesson_video',
            'type' => 'text',
            'attributes' => array(
                'placeholder' => 'https://download.site.com/videos/output.m3u8 or https://site.com/video/1.mp4',
            ),
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $sc_course_options->add_group_field($lesson_data, array(
            'name' => __('Lesson Audio', 'studiare-core'),
            'default' => '',
            'desc' => esc_html__('Insert Audio File Link to show for sample teaching', 'studiare-core'),
            'id' => 'lesson_audio',
            'type' => 'text',
        ));
        
        $sc_course_options->add_group_field($lesson_data, array(
            'id' => 'lesson_divider_2',
            'type' => 'title',
            'name' => '',
            'desc' => '<hr>',
        ));
        
        // Fetch the previous value of the field
        $previous_value = get_option('private_lesson');

        // Check if the previous value was true (checkbox enabled)
        if ($previous_value === '1' || $previous_value === true) {
            // Update to the new format
            update_option('private_lesson', 'lesson_protected');
        }
        $sc_course_options->add_group_field($lesson_data, array(
            'name' => __('Private Lesson', 'studiare-core'),
            'default' => 'lesson_protected',
            'class' => 'studi_private_lesson_situ',
            'desc' => esc_html__('Control the accessibility of this lesson. Choose who can view the content based on the options below.', 'studiare-core'),
            'id' => 'private_lesson',
            'type' => 'radio',
            'options' => array(
                'lesson_free_all' => __('Free for all users', 'studiare-core'),
                'lesson_free_users' => __('Free just for logged-in users', 'studiare-core'),
                'lesson_protected' => __('Only buyers', 'studiare-core'),
                'on' => __('Only buyers', 'studiare-core'), // for lessons created with version below 13
            ),
        ));
        
        $download_list = array('' => __('Select', 'studiare-core'));
        
        if (isset($_GET['post'])) {
            $selected_dl = get_post_meta($_GET['post'], 'lesson_data', true);
            // Check if $selected_dl is not empty and is an array
            if ($selected_dl && is_array($selected_dl)) {
                // Ensure $selected_dl[0] exists and is an array
                if (isset($selected_dl[0]) && is_array($selected_dl[0])) {
                    // Ensure 'sc_download_file' exists within $selected_dl[0]
                    if (isset($selected_dl[0]['sc_download_file'])) {
                        $cid = $selected_dl[0]['sc_download_file'];
                        $download_list[$cid] = get_the_title($cid);
                    }
                }
            }
        }
        
        $sc_course_options->add_group_field($lesson_data, array(
            'id' => 'lesson_divider_3',
            'type' => 'title',
            'name' => '',
            'desc' => '<hr>',
        ));
        $sc_course_options->add_group_field($lesson_data, array(
            'name' => __('Download Link', 'studiare-core'),
            'default' => '',
            'desc' => esc_html__('Please search the download title which you create in studiare panel->downloads, for disable download link search and select None option', 'studiare-core'),
            'id' => 'sc_download_file',
            'type' => 'select',
            'options' => $download_list,
        ));
        $sc_course_options->add_group_field($lesson_data, array(
            'name' => esc_html__('Protect download link', 'studiare-core'),
            'desc' => esc_html__('If you activate this option, even after purchasing the product, the direct download link of the file will not be provided to the user, and the system is defined in such a way that the status of the user login and purchase of the product is checked first, and then the download is allowed.', 'studiare-core'),
            'id' => 'sc_pls',
            'type' => 'checkbox',
        ));
        $sc_course_options->add_group_field($lesson_data, array(
            'name' => __('Download Access', 'studiare-core'),
            'default' => '',
            'id' => 'sc_download_access',
            'type' => 'radio',
            'options' => array(
                'free_dl_all' => __('Free for all users', 'studiare-core'),
                'free_dl_users' => __('Free just for logged-in users', 'studiare-core'),
                'protected_dl' => __('Only buyers', 'studiare-core'),
            ),
        ));
    }
}

new Studiare_Studi_Lesson();

// Adding the Duplicate action button to the post list
add_filter('post_row_actions', 'add_duplicate_action', 10, 2);
function add_duplicate_action($actions, $post) {
    // Check if the post type is 'studi_lesson'
    if ($post->post_type === 'studi_lesson') {
        // Add the duplicate action link
        $actions['duplicate'] = '<a href="' . wp_nonce_url('admin.php?action=duplicate_post&post=' . $post->ID, 'duplicate_post_nonce') . '" title="' . __('Duplicate this item', 'studiare-core') . '">' . __('Duplicate', 'studiare-core') . '</a>';
    }
    return $actions;
}

// Handle the duplication process
add_action('admin_action_duplicate_post', 'duplicate_post');
function duplicate_post() {
    // Verify the nonce and post ID
    if (!isset($_GET['post']) || !isset($_GET['_wpnonce']) || !wp_verify_nonce($_GET['_wpnonce'], 'duplicate_post_nonce')) {
        wp_die(__('Invalid request.', 'studiare-core'));
    }

    $post_id = absint($_GET['post']);
    $post = get_post($post_id);

    // Check if the post exists
    if (null === $post) {
        wp_die(__('Post does not exist.', 'studiare-core'));
    }

    // Create a new post object for the duplicate
    $new_post = array(
        'post_title' => $post->post_title . ' (' . __('Copy', 'studiare-core') . ')',
        'post_content' => $post->post_content,
        'post_status' => 'draft', // Change to 'publish' if you want to publish the copy
        'post_type' => $post->post_type,
    );

    // Insert the new post
    $new_post_id = wp_insert_post($new_post);

    // Copy post meta data
    $post_meta = get_post_meta($post_id); // Retrieve all post meta
    foreach ($post_meta as $key => $values) {
        foreach ($values as $value) {
            // Add each meta value to the new post
            add_post_meta($new_post_id, $key, maybe_unserialize($value));
        }
    }

    // Redirect back to the post list
    wp_redirect(admin_url('edit.php?post_type=studi_lesson'));
    exit;
}

function studi_lesson_admin_notice() {
    global $pagenow;
    $post_type = isset($_GET['post_type']) ? $_GET['post_type'] : '';

    if ($pagenow == 'edit.php' && $post_type == 'studi_lesson') {
        echo '<div class="notice notice-warning is-dismissible" style="padding: 10px; margin-top: 20px;">';
        echo '<p>' . esc_html__('Notice: When creating each lesson, make sure to select the related product from the lesson edit page.', 'studiare-core') . '</p>';
        echo '</div>';
    }
}
add_action('admin_notices', 'studi_lesson_admin_notice');
