<?php
/**
 * The Teacher Custom Post Type
 */

if ( !defined( 'ABSPATH' ) )
	die( '-1' );

if ( ! class_exists( 'Studiare_Teacher' ) ) {

	class Studiare_Teacher {

		public static $instance;

		// Setup a single instance using the singleton pattern
		public static function init() {

			if ( is_null( self::$instance ) ) {
				self::$instance = new Studiare_Teacher();
			}
			return self::$instance;

		}

		function __construct() {

			add_action( 'init', array($this, 'register_post_type' ), 5 );
			add_action( 'cmb2_admin_init', array($this,'register_meta_boxes' ));

			if( is_admin() ) {

				add_filter( 'manage_edit-teacher_columns' , array( $this,'add_teacher_columns' ) );
				add_action( 'manage_teacher_posts_custom_column' , array( $this,'set_teacher_columns_content' ), 10, 2 );

			}
			// Add Elementor support since version 13.2
            add_action( 'init', array($this, 'add_elementor_support'), 10 );
		}
		
		
		// since version 13.2
		// Add this method to your Studiare_Teacher class
        function add_elementor_support() {
            // Enable Elementor support for teacher post type
            add_post_type_support('teacher', 'elementor');
            
            // Add teacher to Elementor template types
            add_filter('elementor_pro/utils/get_public_post_types', array($this, 'add_to_elementor_template_types'));
        }
        
        function add_to_elementor_template_types($post_types) {
            $post_types['teacher'] = __('Teacher', 'studiare-core');
            return $post_types;
        }
        
        
        

		function register_post_type() {

			$options = get_option( 'studiare-core-options' );

			if ( post_type_exists( 'teacher' ) ) {
				return;
			}

			$labels = array(
				'name'                => _x( 'Teachers', 'Post Type General Name', 'studiare-core' ),
				'singular_name'       => _x( 'Teacher', 'Post Type Singular Name', 'studiare-core' ),
				'menu_name'           => __( 'Teachers', 'studiare-core' ),
				'parent_item_colon'   => __( 'Parent Teacher:', 'studiare-core' ),
				'all_items'           => __( 'All Teachers', 'studiare-core' ),
				'view_item'           => __( 'View Teacher', 'studiare-core' ),
				'add_new_item'        => __( 'Add New Teacher', 'studiare-core' ),
				'add_new'             => __( 'Add New', 'studiare-core' ),
				'edit_item'           => __( 'Edit Teacher', 'studiare-core' ),
				'update_item'         => __( 'Update Teacher', 'studiare-core' ),
				'search_items'        => __( 'Search Teacher', 'studiare-core' ),
				'not_found'           => __( 'Not found', 'studiare-core' ),
				'not_found_in_trash'  => __( 'Not found in Trash', 'studiare-core' ),
			);
			
			// Default slug
	        $slug = 'teacher';
	        // Check Redux settings for dynamic title and slug
	        if(function_exists("codebean_option")){
            	if ( class_exists( 'Redux' ) && codebean_option( 'enable_dynamic_teacher_name_slug' ) ) {
            		if ( ! empty( codebean_option( 'teachers_archive_page' ) ) ) {
            			$page_id = codebean_option( 'teachers_archive_page' );
            			$page = get_post( $page_id );
            			if ( $page ) {
            				$labels['name'] = $page->post_title; // Use page title as archive name
            				$slug = $page->post_name; // Use page slug as archive slug
            			}
            		} else {
            			$labels['name'] = codebean_option( 'teachers_custom_title' ) ? codebean_option( 'teachers_custom_title' ) : 'Teachers';
            			$slug = codebean_option( 'teachers_custom_slug' ) ? codebean_option( 'teachers_custom_slug' ) : 'teacher';
            		}
            	}
	        }

			$rewrite = array(
        		'slug'       => $slug,
        		'with_front' => false,
        	);

			$args = array(
				'label'               => __( 'teacher', 'studiare-core' ),
				'description'         => __( 'Teacher Post Type', 'studiare-core' ),
				'labels'              => $labels,
				'supports'            => array( 'title', 'editor', 'thumbnail','comments', 'excerpt' ),  //since version 12.6 add comment support
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
                'show_in_menu'       => 'studiare_panel',
				'show_in_nav_menus'   => false,
				'show_in_admin_bar'   => false,
				'menu_position'       => 20,
				'can_export'          => true,
				'has_archive'         => true,
				'exclude_from_search' => false,
				'publicly_queryable'  => true,
				'query_var'           => true,
				'rewrite'             => $rewrite,
				'menu_icon'           => 'dashicons-awards',
				'capability_type'     => 'post',
			);

			register_post_type( 'teacher', $args );

		}

		function register_meta_boxes() {

			$prefix = '_studiare_';

			$teacher_metaboxes = new_cmb2_box( array(
				'id'           => 'teacher_metabox',
				'title'        => esc_html__( 'اطلاعات مدرس', 'studiare' ),
				'object_types' => array( 'teacher' ),
				'context'      => 'normal',
				'priority'     => 'high',
				'show_names'   => true,
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'شغل یا تخصص', 'studiare' ),
				'default' => 'طراح گرافیک',
				'id'   => $prefix . 'teacher_job_title',
				'type' => 'text',
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Facebook', 'studiare' ),
				'id' => 'facebook',
				'type' => 'text',
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Twitter', 'studiare' ),
				'id' => 'twitter',
				'type' => 'text',
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Google +', 'studiare' ),
				'id' => 'google-plus',
				'type' => 'text',
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'LinkedIn', 'studiare' ),
				'id' => 'linkedin',
				'type' => 'text',
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Youtube', 'studiare' ),
				'id' => 'youtube',
				'type' => 'text',
			) );
			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Telegram', 'studiare' ),
				'id' => 'telegram',
				'type' => 'text',
			) );
			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Instagram', 'studiare' ),
				'id' => 'instagram',
				'type' => 'text',
			) );
			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Whatsapp', 'studiare' ),
				'id' => 'whatsapp',
				'type' => 'text',
			) );
		}

		function add_teacher_columns( $cols ) {

			$cols = array(
				'cb'        =>   '<input type="checkbox" />',
				'title'     => __( 'Title', 'studiare-core' ),
				'thumbnail' => __( 'Thumbnail', 'studiare-core')
			);

			return $cols;

		}

		function set_teacher_columns_content( $column, $post_id ) {

			$width = (int) 35;
			$height = (int) 35;

			switch( $column ) {

				case 'thumbnail' :

					$thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true );
					$attachments = get_children( array('post_parent' => $post_id, 'post_type' => 'attachment', 'post_mime_type' => 'image') );

					if ( $thumbnail_id ) {
						$thumb = wp_get_attachment_image( $thumbnail_id, array($width, $height), true );
					} elseif ( $attachments ) {
						foreach ( $attachments as $attachment_id => $attachment ) {
							$thumb = wp_get_attachment_image( $attachment_id, array($width, $height), true );
						}
					}

					if ( isset( $thumb ) && $thumb ) {
						echo wp_kses_post( $thumb );
					} else {
						echo __('None', 'educa-addons');
					}

					break;

			}

		}

	}

	Studiare_Teacher::init();
}
