<?php
namespace SC_Story\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class Story_Widget extends Widget_Base {
    public function get_name() {
        return 'sc_story_widget';
    }

    public function get_title() {
        return __('SC Story', 'studiare-core');
    }

    public function get_icon() {
        return 'sc eicon-instagram-gallery';
    }

    public function get_categories() {
    $categories = \Elementor\Plugin::instance()->elements_manager->get_categories();
    
    if (array_key_exists('studiare', $categories)) {
        return ['studiare'];
    }
    
    return ['general'];
    }
    
    public function get_style_depends() {
        return ['sc-story-style']; // The handle name for your CSS file
    }

    public function get_script_depends() {
        return ['sc-story-script']; // The handle name for your JS file
    }
    
    // add a method to register the style and script
    public static function enqueue_assets() {
        wp_register_style('sc-story-style', SC_STORY_PLUGIN_URL . 'assets/css/style.css');
        wp_register_script('sc-story-script', SC_STORY_PLUGIN_URL . 'assets/js/script.js', ['jquery'], null, true);
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Story Settings', 'studiare-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Number of Stories', 'studiare-core'),
                'description' => __('This section displays the list of the latest stories created in Dashboard > Studyar Panel > Stories. <a href="/wp-admin/admin.php?page=sc-story" target="_blank">Click here</a> to view and manage the stories status.', 'studiare-core'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 100,
                'default' => 10,
            ]
        );

        $this->add_control(
            'display_style',
            [
                'label' => __('Display Style', 'studiare-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid' => __('Grid', 'studiare-core'),
                    'carousel' => __('Carousel', 'studiare-core'),
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        $args = array(
            'post_type'      => 'sc_story',
            'posts_per_page' => $settings['posts_per_page'],
            'orderby'        => 'date',
            'order'          => 'DESC',
        );

        $stories = new \WP_Query($args);
/*
        if ($stories->have_posts()) : ?>
            <div class="sc-story-container <?php echo esc_attr($settings['display_style']); ?>">
                <?php while ($stories->have_posts()) : $stories->the_post(); 
                    $video_url = get_post_meta(get_the_ID(), '_story_video_url', true);
                    $event_date = get_post_meta(get_the_ID(), '_story_event_date', true);
                    ?>
                    <div class="sc-story-item" data-story-id="<?php echo get_the_ID(); ?>">
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="sc-story-thumbnail">
                                <?php the_post_thumbnail('medium'); ?>
                            </div>
                        <?php endif; ?>
                        
                        <div class="sc-story-content">
                            <h3><?php the_title(); ?></h3>
                            <?php if ($event_date) : ?>
                                <div class="sc-story-event-timer" data-event-date="<?php echo esc_attr($event_date); ?>"></div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        <?php endif;
*/        
  //new design start      
  if ($stories->have_posts()) : ?> 
            <div class="demo-stories">
                <?php while ($stories->have_posts()) : $stories->the_post(); 
                    
                    ?>
                    <div class="stor_trigger" >
                      <span class="demo-stories-avatar">
                        <?php the_post_thumbnail('medium'); ?>
                      </span>
                      <span class="demo-stories-name"><?php the_title(); ?></span>
                    </div>
                <?php endwhile; ?>
            </div>
            <div class="stories-slider stories-slider-perspective">
      <div class="swiper swiper-cube swiper-3d swiper-initialized swiper-horizontal swiper-watch-progress">
        <div class="swiper-wrapper" style="transform-origin: 50% 50% -207px; transform: translate3d(0px, 0px, 0px) rotateX(0deg) rotateY(0deg); --swiper-cube-translate-z: 0px; transition-duration: 0ms; transition-delay: 0ms;">
          
          <?php while ($stories->have_posts()) : $stories->the_post(); 
          $media_url = get_post_meta(get_the_ID(), 'story_media', true);
          ?>
          <!-- specific user stories start -->
          <div class="swiper-slide " style="">
            <div class="swiper swiper-initialized swiper-horizontal swiper-backface-hidden">
              <div class="swiper-wrapper" style="">
                  
                 <?php 
                $stories_data = get_post_meta(get_the_ID(), 'sc_story_stories', true);
                if (!empty($stories_data)){ 
                    
                    foreach ($stories_data as $story){ 
                        ?>
                        <!-- user's single story -->
                        <div class="swiper-slide " style="">
                            <div class="stories-slider-actions">
                                <button class="stories-slider-close-button"></button>
                              </div>
                              <a href="#" class="stories-slider-user">
                                <div class="stories-slider-user-avatar">
                                  <?php the_post_thumbnail('medium'); ?>
                                </div>
                                <div class="stories-slider-user-name"><?php the_title(); ?></div>
                                <div class="stories-slider-user-date"></div>
                              </a>
                              
                              <div class="stories-slider-content">
                                  <?php if ($story['type'] === 'image'){ ?>
                                <img src="<?php echo $story['media_url'];?>"> 
                                <?php }else{ ?>
                                <video src="<?php echo $story['media_url'];?>" playsinline="" preload="metadata"></video>
                                <?php }?>
                                
                                </div>
                                <div class="stories_btm_con">
                                    <div class="sbc_info" style="display:none;">
                                        
                                    </div>
                                    <div class="sbc_links" >
                                        
                                        
                                        <?php if(!empty($story['story_link'])){?>
                                            <a class="sbc_title" href="<?php echo $story['story_link'];?>"><i class="fal fa-eye"></i><?php echo $story['title'];?></a>
                                            <?php }else{ ?>
                                            <div class="sbc_title"><i class="fal fa-eye"></i><?php echo $story['title'];?></div>
                                            <?php } ?>
                                        <?php if (!empty($story['date']) && strtotime($story['date']) !== false) { ?>
                                            <div class=""><i class="fal fa-calendar"></i>
                                                <?php echo date_i18n(get_option('date_format'), strtotime($story['date'])); ?>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                        </div>
                        <?php
                        
                    }
                    
                }
                  ?>
                  
                
                
              </div>
            <div class="stories-slider-pagination"></div>
        </div>
          <div class="swiper-slide-shadow-cube swiper-slide-shadow-left" style="opacity: 0;"></div><div class="swiper-slide-shadow-cube swiper-slide-shadow-right" style="opacity: 0;"></div>
		  </div>
		  <!-- specific user stories end -->
		  <?php endwhile; ?>
		  
        </div>
      </div>
    </div>
    
        <?php endif;
  //new design end      
        wp_reset_postdata();
    }
}


// Hook to register styles and scripts within Elementor
add_action('elementor/frontend/after_enqueue_styles', ['SC_Story\Widgets\Story_Widget', 'enqueue_assets']);
add_action('elementor/frontend/after_enqueue_scripts', ['SC_Story\Widgets\Story_Widget', 'enqueue_assets']);