<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if ( !class_exists( 'Studiare_Matching_Db' ) ) {
    class Studiare_Matching_Db { 

        public static function instance() {
            // Store the instance locally to avoid private static replication
            static $instance = null;
            // Only run these methods if they haven't been run previously
            if ( null === $instance ) {
                
                $instance = new Studiare_Matching_Db();
                
            }
            // Always return the instance
            return $instance;
            // The last metroid is in captivity. The galaxy is at peace.
        }
        
        public function __construct() {
    

        }
    
        
        public function create_table() {
    
            global $wpdb;
            
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        
            $charset_collate = $wpdb->get_charset_collate();
            
                $sql_chat =  [ 
                
                "CREATE TABLE `" . stc_get_table('messages') ."` (
                      `id` bigint(20) NOT NULL AUTO_INCREMENT,
                      `thread_id` bigint(20) NOT NULL,
                      `sender_id` bigint(20) NOT NULL,
                      `message` longtext NOT NULL,
                      `date_sent` datetime NOT NULL,
                      `created_at` bigint(20) NOT NULL DEFAULT '0',
                      `updated_at` bigint(20) NOT NULL DEFAULT '0',
                      `temp_id` varchar(50) DEFAULT NULL,
                      PRIMARY KEY (`id`),
                      KEY `sender_id` (`sender_id`),
                      KEY `thread_id` (`thread_id`),
                      KEY `created_at` (`created_at`),
                      KEY `updated_at` (`updated_at`)
                    ) ENGINE=InnoDB;",
                    
                    "CREATE TABLE " . stc_get_table('meta') ." (
                      meta_id bigint(20) NOT NULL AUTO_INCREMENT,
                      message_id bigint(20) NOT NULL,
                      meta_key varchar(255) DEFAULT NULL,
                      meta_value longtext,
                      PRIMARY KEY (meta_id),
                      KEY message_id (message_id),
                      KEY meta_key (meta_key(191))
                    ) ENGINE=InnoDB;", 

                 "CREATE TABLE `" . stc_get_table('recipients') ."` (
                      `id` bigint(20) NOT NULL AUTO_INCREMENT,
                      `user_id` bigint(20) NOT NULL,
                      `thread_id` bigint(20) NOT NULL,
                      `unread_count` int(10) NOT NULL DEFAULT '0',
                      `last_read` datetime NOT NULL DEFAULT '1970-01-01',
                      `last_delivered` datetime NOT NULL DEFAULT '1970-01-01',
                      `last_email` datetime NOT NULL DEFAULT '1970-01-01',
                      `is_muted` tinyint(1) NOT NULL DEFAULT '0',
                      `is_pinned` tinyint(1) NOT NULL DEFAULT '0',
                      `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
                      `last_update` bigint(20) NOT NULL DEFAULT '0',
                      PRIMARY KEY (`id`),
                      UNIQUE KEY `user_thread` (`user_id`,`thread_id`),
                      KEY `user_id` (`user_id`),
                      KEY `thread_id` (`thread_id`),
                      KEY `is_deleted` (`is_deleted`),
                      KEY `unread_count` (`unread_count`),
                      KEY `is_pinned` (`is_pinned`)
                    ) ENGINE=InnoDB;",
                    
                    
                    "CREATE TABLE `" . stc_get_table('threads') ."` (
                      `id` bigint(20) NOT NULL AUTO_INCREMENT,
                      `subject` varchar(255) NOT NULL,
                      `type` enum('thread','group','chat-room') NOT NULL DEFAULT 'thread',
                      `user_start` bigint(20) NOT NULL,
                      `total_messages` bigint(20) NOT NULL,
                      PRIMARY KEY (`id`)
                    ) ENGINE=InnoDB;",
                 
                ];
                
                
                dbDelta($sql_chat);
                $this->update_collate();
              
        }
        
        public function update_collate(){
            global $wpdb;

            $actions = [
                "ALTER TABLE `" . stc_get_table('messages') ."` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;",
                "ALTER TABLE `" . stc_get_table('meta') ."` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;",
                "ALTER TABLE `" . stc_get_table('recipients') ."` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;",
                "ALTER TABLE `" . stc_get_table('threads') ."` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;",
            ];

            foreach( $actions as $sql ){
                $wpdb->query( $sql );
            }

            return null;
        }
 
    }
}



function Studiare_Matching_Db() {
    return Studiare_Matching_Db::instance();
}