/** start add dependencies for toaster by javad **/
var stcThemeModule;
stcThemeModule = (function() {
		return {
		    
		    show_notification: function($content,$role) {   
        
        
        function createCustomToast() {
            var toastContent = document.createElement("div");
            toastContent.innerHTML  = '<div class="mess-inner fs-small">'+$content+'</div>';
              return toastContent;
        }
        
        if($content) {
 
          var bg = '#438f3e';
          
          if($role == 'error') {
             bg = '#bf9537';
          }
          
               Toastify({
                node: createCustomToast(),
                duration: 4000,
                close:true,
                gravity:'bottom',
                position:'center',
                stopOnFocus:true,
                style: {
                    background:bg,
                },
              }).showToast();     
        }

        
     },
		    
		};
}());
/** end add dependencies for toaster by javad **/

'use strict';
window.updateQueryStringParameter = function(uri, key, value) {
   var re = new RegExp("([?&])" + key + "=.*?(&|$)", "i");
   var separator = uri.indexOf('?') !== -1 ? "&" : "?";
   if(uri.match(re)) {
      return uri.replace(re, '$1' + key + "=" + value + '$2');
   }
   else {
      return uri + separator + key + "=" + value;
   }
};


(function($) {
   'use strict';
   $(document).ready(function() {
      function checkInputValues($target) {
         let hasValue = false;
         var $form = $target.parents('form');
         $form.find('.form-input').each(function() {
            if($(this).val().trim() !== '') {
               hasValue = true;
               return false; // Exit loop early
            }
         });
         $form.find('button[type="submit"]').prop('disabled', !hasValue);
      }

      
     
      

      
      // conversation
     
      
      function stc_delete_conversation() { 
        
         
            $(document).on('click', '.conversation-header .delete-conversation', function(e) {
            e.preventDefault();
            var button = $(this),
               thread_id = button.data('conversation'),
               nonce = stc_chat.stc_nonce,
               data = {};
            data.action = 'stc_delete_conversation';
            data.nonce = nonce;
            data.thread_id = thread_id;
            
            if(button.hasClass('loading')) return false;
           
            
            if (confirm(stc_chat.confirm_delete_conversation_text)) {
                
                   button.addClass('loading');
                    if(!button.find('.loader').length) {
                       button.append(
                          '<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>'
                       );
                    }
                
                   $.ajax({
                       url: stc_chat.ajax_url, // javad stc_script.ajax_url,
                       data: data,
                       type: 'POST',
                       dataType: 'json',
                       success: function(response) {
                        
                          if(response.success) {
                            
                             stcThemeModule.show_notification(response.data.message, 'success');
                             window.location = stc_chat.chat_page
                      
                          }
                          else {
                             stcThemeModule.show_notification(response.data[0].message, 'error');
                          }
                       },
                       error: function() {
                          console.log('error');
                       },
                       complete: function() {
                          button.removeClass('loading');
                       },
                   });
            }
         
        
         });
        
      };
      
      stc_delete_conversation();
      

     

      function stc_chat_gifts() {
         $('body').mouseup(function(e) {
            var container = $('#stc-gift-container * , #send-gift *');
            if(!container.is(e.target)) {
               $('#stc-gift-container').removeClass('open');
            }
         });
         $(document).on('click', '#send-gift', function(e) {
            e.preventDefault();
            var button = $(this),
               nonce = stc_chat.stc_nonce,
               gift_container = $('#stc-gift-container'),
               data = {};
            data.action = 'get_stc_gifts';
            data.nonce = nonce;
            if(button.hasClass('loading')) return false;
            if(!button.find('.loader').length) {
               button.append(
                  '<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>'
                  );
            }
            
            if(!gift_container.hasClass('loaded')) {
               button.addClass('loading');
               
               $.ajax({
                  url: stc_chat.ajax_url,
                  data: data,
                  type: 'POST',
                  dataType: 'json',
                  success: function(response) {
                     console.log(response);
                     if(response.success) {
                        stcThemeModule.show_notification(response.data.message, 'success');
                        if(response.data.result) {
                           gift_container.html('<div class="gift-row stc-scrollbar">' + response.data.result + '</div>');
                        }
                     }
                     else {
                        stcThemeModule.show_notification(response.data[0].message, 'error');
                     }
                  },
                  error: function() {
                     console.log('error');
                  },
                  complete: function() {
                     button.removeClass('loading');
                     gift_container.addClass('loaded open');
                  },
               });
            } else {
                gift_container.toggleClass('open');
            }
         });
         $(document).on('click', '.gift-item', function(e) {
            e.preventDefault();
            var button = $(this),
               $form = button.parents('#form-create-messages'),
               gift_container = $('#stc-gift-container'),
               gift_id = button.data('id');
            gift_container.removeClass('open');
            $form.find('#gift-input').val(gift_id);
            $form.submit();
         });
      }
      stc_chat_gifts();



      function stc_add_gif() {
         let searchTimeout;
         $('body').mouseup(function(e) {
            var container = $('#stc-gif-container * , #send-gif , #send-gif *');
            if(!container.is(e.target)) {
               $('#stc-gif-container').removeClass('open');
            }
         });
         $(document).on('keyup', '#search-giphy', function() {
            clearTimeout(searchTimeout);
            let query = $(this).val();
            let url = `https://api.giphy.com/v1/gifs/trending?api_key=DklNS3OkSepMVqbl8yAyOFc5KY7Sh7MC&q=${query}&limit=20`;
            if(query.length > 0) {
               url = `https://api.giphy.com/v1/gifs/search?api_key=DklNS3OkSepMVqbl8yAyOFc5KY7Sh7MC&q=${query}&limit=20`
            }
            searchTimeout = setTimeout(function() {
               $.ajax({
                  url: url,
                  method: 'GET',
                  success: function(response) {
                     let gifs = response.data;
                     $('#stc-gif-container .gif-row').empty();
                     gifs.forEach(gif => {
                        $('#stc-gif-container .gif-row').append(
                           `<img src="${gif.images.fixed_height_small.url}" class="gif-thumbnail" data-id="${gif.id}" />`
                           );
                     });
                  }
               });
            }, 700);
         });
      }
      stc_add_gif();

      function open_gif() {
         $(document).on('click', '#send-gif', function(e) {
            var gif_container = $('#stc-gif-container');
            var button = $(this);
            if(button.hasClass('loading')) return false;
            if(!button.find('.loader').length) {
               button.append(
                  '<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>'
                  );
            }
          
            if(!gif_container.hasClass('loaded')) {
               button.addClass('loading');
               $.ajax({
                  url: 'https://api.giphy.com/v1/gifs/trending?api_key=DklNS3OkSepMVqbl8yAyOFc5KY7Sh7MC&limit=20',
                  method: 'GET',
                  success: function(response) {
                     let gifs = response.data;
                     gifs.forEach(gif => {
                        $('#stc-gif-container .gif-row').append(
                           `<img src="${gif.images.fixed_height_small.url}" class="gif-thumbnail" data-id="${gif.id}" />`);
                     });
                  },
                  complete: function() {
                    
                     button.removeClass('loading');
                     gif_container.addClass('loaded open');
   
                  }
               });
            } else {
                 gif_container.toggleClass('open');
            }
         });
      }
      open_gif();

      function send_gif() {
         $(document).on('click', '.gif-thumbnail', function(e) {
            e.preventDefault();
            var button = $(this),
               $form = button.parents('form'),
               gif_container = $('#stc-gif-container');
            let gifId = $(this).data('id');
            $.ajax({
               url: `https://api.giphy.com/v1/gifs/${gifId}?api_key=DklNS3OkSepMVqbl8yAyOFc5KY7Sh7MC`,
               method: 'GET',
               success: function(response) {
                  let gif = response.data;
                  let gifImages = gif.images;
                  console.log(gifImages);
                  let gifInfo = {
                     image_url: gifImages['480w_still'].url,
                     video_url: gifImages.original.mp4
                  };
                  gif_container.removeClass('open');
                  $form.append('<input id="gif-input" type="hidden" name="message_gif">');
                  $form.find('#gif-input').val(JSON.stringify(gifInfo));
                  $form.submit();
               },
               complete: function() {
                  $form.find('#gif-input').remove();
               }
            });
         });
      };
      send_gif();

      function gif_play() {
         $(document).on('click', '.gif-player', function(event) {
            event.preventDefault();
            var video = $(event.currentTarget).find('video').get(0),
               $button = $(event.currentTarget).find('.gif-play-button');
            if(video.paused == true) {
               // Play the video.
               video.play();
               // Update the button text to 'Pause'.
               $button.hide();
            }
            else {
               // Pause the video.
               video.pause();
               // Update the button text to 'Play'.
               $button.show();
            }
         });
      };
      gif_play();

      function send_file() {
         $('body').mouseup(function(e) {
            var container = $('#stc-file-container * , #send-file * , .uppy-Root *');
            if(!container.is(e.target) && typeof jQuery.prototype.emojioneArea !== 'undefined') {
               $('#stc-file-container').removeClass('open');
            }
         });
         $(document).on('click', '#send-file', function(e) {
            e.preventDefault();
            var button = $(this),
               file_container = $('#stc-file-container'),
               nonce = stc_chat.stc_nonce,
               data = {};
            data.action = 'stc_load_form_media';
            data.nonce = nonce;
            if(button.hasClass('loading')) return false;
            if(!button.find('.loader').length) {
               button.append(
                  '<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>'
                  );
            }
            
            if(!file_container.hasClass('loaded')) {
               button.addClass('loading');
               $.ajax({
                  url: stc_chat.ajax_url,
                  data: data,
                  type: 'POST',
                  dataType: 'json',
                  success: function(response) {
                     console.log(response);
                     if(response.success) {
                        if(response.data.result) {
                           file_container.html(response.data.result);
                        }
                     }
                     else {
                        stcThemeModule.show_notification(response.data[0].message, 'error');
                     }
                  },
                  error: function() {
                     console.log('error');
                  },
                  complete: function() {
                     button.removeClass('loading');
                     file_container.addClass('loaded open');
                  },
               });
            } else {
                
                file_container.toggleClass('open');
                
            }
         });
      };
      send_file();
   });
})(jQuery);