var StudiareChatGlobal;

(function($) {
   'use strict';
   
 var data_conversation;

   
   $(document).ready(function() {
    
      const { __, _x, _n, sprintf } = wp.i18n;
   
      function getItemByThreadId(threadId) {
            if(data_conversation !== undefined) {
                return data_conversation.find(item => item.thread_id == threadId); 
            }  
      }
      
      function updateItemInData(updatedItem) {
            var index = data_conversation.findIndex(item => item.thread_id == updatedItem.thread_id);
            if (index !== -1) {
                data_conversation[index] = updatedItem;
            }
      }
      
       
      function load_data_conversation() {
        
        if(!$('body').hasClass('logged-in')) return false; 
        
         
        var button = $(this),
        nonce = stc_chat.stc_nonce,
        data = {};
        
        data.action = 'stc_load_conversation_data';
        data.nonce = nonce;
       
     
        $('.conversation-list').append(
          '<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>'
        ).addClass('loading');
     
       
         $.ajax({
              url: stc_chat.ajax_url,
              data: data,
              type: 'POST',
              dataType: 'json',
              success: function(response) {
               
                 if(response.success) {
                  
                    data_conversation = response.data.threads;
               
                    $('.conversation-list').html('').removeClass('loading');  
                    data_conversation.forEach(function(thread) { 
                     if(thread.last_message != null)   $('.conversation-list').append(StudiareChatTemplate.conversation_item(thread)); 

                    });
                
                 }
                 else {
                 
                 }
              },
              error: function() {
                 console.log('error');
              },
              complete: function() {
                 
                
              },
           });
        

       };
  
       load_data_conversation();
      
      $('.mess_notificaion').on('mouseenter',function(){
            if($('.mess_notificaion').hasClass('has_messages')) {
                $('.mess_notificaion').removeClass('has_messages');
            }
      });
      
      function load_chat_realtime() {
        
           if($('body').hasClass('user-not-logged-in')) return false; 
           if(data_conversation === undefined || !data_conversation.length) return false;
    
           var form = $('.stc-chat-members'), 
           thread_id = form.attr('data-conversation'),
           nonce = nonce = stc_chat.stc_nonce,
           data = {};
          
           var combinedArray = data_conversation.map(item => ({
                thread_id: item.thread_id,
                last_date: item.last_date,
                sender_id: item.sender_id
            }));
           
           var data_current = getItemByThreadId(thread_id);
        
         data.nonce = nonce;  
         data.action = 'stc_messages_check_data';
         data.conversation = combinedArray;  
   
         $.ajax({
              url: stc_chat.ajax_url,
              data: data,
              type: 'POST',
              dataType: 'json',
              success: function(response) {
             
                 if(response.success && response.data != 'no_data') {
               
                 
                   
                 response.data.forEach(function(data) {  
            
                
                      var thread = data;
                      var messages = data.messages;
                      var thread_global = getItemByThreadId(thread.thread_id); 
                        
                       messages.forEach(function(message) { 
                        
                        
                            if (thread_global) {
                                thread_global.last_message_sender = message.sender_id;
                                thread_global.last_message = message.content;
                                thread_global.display_time = message.display_time; 
                                thread_global.is_me = message.is_me;
                                thread_global.last_date = message.last_date;
                                thread_global.unread = thread.unread;
                                thread_global.total_messages = thread.total_messages;
                                
                                
                                updateItemInData(thread_global);
                                
                                if(thread.unread != '0') {
                                      $('.mess_notificaion').addClass('has_messages'); 
                                }
                                    
                              
                                 
                            }
                       
                           if(data_current !== undefined && thread_id == thread.thread_id) { 
                        
                                $('.message-item[data-id="'+message.id+'"]').remove();
                                $('#messages-inner').append(StudiareChatTemplate.message_item(message,thread_global));
             
                           }   
                       
             
                        });
                        
                        
                        $('.conversation-item[data-conversation="'+thread.thread_id+'"]').remove();
                        $('.conversation-list').prepend(StudiareChatTemplate.conversation_item(thread_global));
     
                 });
           
                 }
                 else {
                 
                 }
              },
              error: function() {
                 console.log('error');
              },
              complete: function() {
           
              },
           });
           
    
      
                
      }
    
      setInterval(load_chat_realtime,5000); 
  
      
      function back_conversation() { 
        
         $(document).on('click', '.back-conversation', function() {
              $(this).parents('.stc-chat-members').removeClass('loaded');
         });
        
      }
      
       back_conversation();
      
      function stc_send_messages() {
        
         $(document).on('input', '#form-create-messages .form-input', function() {
            checkInputValues($(this));
         });
    
         $(document).on('submit', '#form-create-messages', function(e) {
            e.preventDefault();
            var form = $(this);
            var formData = new FormData(this);
            var nonce = stc_chat.stc_nonce;
          
            formData.append("action", "send_messages");
            formData.append("nonce", nonce);
        
            form.find('[type="submit"]').addClass('loading');
            if(!form.find('.loader').length) {
          
               form.find('[type="submit"]').append(
                  '<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>'
                  );
            }
            form.find('input:not([name="thread_id"]):not([name="send_to"]) , textarea').val('');
   
            form.find('#reply_edit_message_text').remove();
            $.ajax({
               url: stc_chat.ajax_url,
               data: formData,
               method: 'POST',
               contentType: false,
               processData: false,
               success: function(response) {
             
                  if(response.success) {
                        
                 
                        var thread = response.data.thread;
                        var message = response.data.thread.messages;
                        var thread_global = getItemByThreadId(thread.thread_id); 
                     
                        if (thread_global) {
                            thread_global.last_message_sender = message.sender_id;
                            thread_global.last_message = message.content;
                            thread_global.display_time = message.display_time; 
                            thread_global.is_me = message.is_me;
                            thread_global.unread = 0;
                            updateItemInData(thread_global); 
                        }
                    
                        
                   
                        $('.conversation-item[data-conversation="'+thread.thread_id+'"]').remove();
                        $('#messages-inner').append(StudiareChatTemplate.message_item(message,thread_global));
                        
     
                        
                        $('.conversation-list').prepend(StudiareChatTemplate.conversation_item(thread_global));
                     
                  }
                  else {
                     stcThemeModule.show_notification(response.data[0].message, 'error');
                  }
               },
               error: function() {
                  console.log('error');
               },
               complete: function() {
                  form.find('[type="submit"]').removeClass('loading');
                  form.find('button[type="submit"]').prop('disabled', true);
               },
            });
         });
      }
      stc_send_messages();
   
   
   
   function create_conversation() {
         
       $(document).on('click', '.send-message[data-user]', function(e) {
            e.preventDefault();
        var button = $(this),
        nonce = stc_chat.stc_nonce,
        user_id = button.data('user'),
        data = {};
        
        data.action = 'stc_get_conversation_create';
        data.sender_id = user_id;
        data.nonce = nonce;
        
     
        button.append(
          '<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>'
        ).addClass('loading');
        
       
         $.ajax({
              url: stc_chat.ajax_url,
              data: data,
              type: 'POST',
              dataType: 'json',
              success: function(response) {
                 if(response.success) {
                 
                      window.location = response.data.url
                     
                 }
                 else {
                     stcThemeModule.show_notification(response.data[0].message, 'error');
                 }
              },
              error: function() {
                 console.log('error');
              },
              complete: function() {
                
                 button.removeClass('loading');
                
              },
           });
        
          });  
          
          function change_select2() {
             //console.log(stc_chat.ajax_url);//javad    
            $('.stc-message-form-search-user .search-user').select2({
                placeholder: stc_chat.scsearchusers,//suncode
                ajax: {
                    url: stc_chat.ajax_url, 
                    dataType: 'json',
                    type: 'POST',
                    delay: 250,
                    data: function(response) {
                        return {
                            action: 'stc_message_search_users', 
                            search: response.term, 
                            nonce: stc_chat.stc_nonce 
                        };
                       
                    },
                    processResults: function(response) {
                        //console.log(response);
                        if(response.success) {
                     
                             return {
                                results: response.data.results
                            };
                             
                         }
                         else {
                             stcThemeModule.show_notification(response.data[0].message, 'error');
                         }
                       
                    },
                    cache: true
                },
                templateResult: formatResult,
                minimumInputLength: 2,
                maximumSelectionLength: 100 
            });
            
       }; 
       
       
        function formatResult(item) {
            if (!item.id) return item.text;
            var $item = $(
                '<span><img src="' + item.image + '" class="select2-result-image" style="width:30px; height:30px; border-radius:50%; margin-right:10px;">' + item.text + '</span>'
            );
            return $item;
        }
         
        
        
       $(document).on('submit', '.stc-message-form-search-user', function(e) {
            e.preventDefault();
            var form = $(this);
            var formData = new FormData(this);
            var nonce = stc_chat.stc_nonce;
          
            formData.append("action", "stc_get_conversation_create_multi");
            formData.append("nonce", nonce);
        
            form.find('[type="submit"]').addClass('loading');
            if(!form.find('.loader').length) {
          
               form.find('[type="submit"]').append(
                  '<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>'
                  );
            }
       
            form.find('#reply_edit_message_text').remove();
            $.ajax({
               url: stc_chat.ajax_url,
               data: formData,
               method: 'POST',
               contentType: false,
               processData: false,
               success: function(response) {
                 
                  if(response.success) {
                    
                     var newURL = updateQueryStringParameter(stc_chat.chat_page, 'conversation', response.data.thread_id);
                     history.pushState(null, null, newURL);
                    
                     location.reload();
                     
                      stcThemeModule.show_notification(response.data.message, 'success')
                  }
                  else {
                     stcThemeModule.show_notification(response.data[0].message, 'error');
                  }
               },
               error: function() {
                  console.log('error');
               },
               complete: function() {
                  form.find('[type="submit"]').removeClass('loading');
               },
            });
         });
         
         $(document).on('click', '.start-conversation .button', function(e) {
            
            $('.start-conversation').slideUp();
            $('.stc-message-form-search-user').slideDown();
            
            change_select2();
            
         });
         
         $(document).on('click', '.create-new-conversation', function(e) {
             $('.stc-chat-members').addClass('loaded');  
            if($('.stc-chat-members').hasClass('loaded') && !$('#messages-list').hasClass('loading')) {
                $('#messages-inner').html(StudiareChatTemplate.tab_create_conversation());
                $('#form-create-messages').empty();
                $('.conversation-header').html('<div class="back-conversation"><i class="stc-icon-caret-left-light"></i></div>');
                $('.stc-message-form-search-user').show();
                change_select2();
                
            }
            
            
         });
          
         
  
       };
       
       
       create_conversation();
       
   

         $('#messages-list').on('scroll', function() {
            
            if($(this).hasClass('loaded_all')) return false;
            
            var 
                thread_id = $('.stc-chat-members').attr('data-conversation'), 
                offset = $(this).find('.message-item').length,
                scroll = $(this).scrollTop(),
                scrollHeight = $(this).prop('scrollHeight'),
                containerHeight = $(this).height();
                
           let scroll_end = scroll + (scrollHeight - containerHeight);
             
          
            if (scroll_end <= 50) {
              load_data_message(thread_id,offset,'loadmore');
            }
        });
 
       
        function load_data_message(thread_id,offset = 0,type = '') {
            
               
         const isSameDay = (timestamp1, timestamp2) => {
            const date1 = new Date(timestamp1 * 1000);
            const date2 = new Date(timestamp2 * 1000);
            return date1.toDateString() === date2.toDateString();
        };
            
        const dateForDay = (timestamp) => {
            const messageDate = new Date(timestamp * 1000);
            const today = new Date();
            /*return isSameDay(messageDate.getTime() / 1000, today.getTime() / 1000) ?
                "Today" :
                messageDate.toLocaleDateString('en-US', { year: 'numeric', month: 'long' , day: 'numeric' }); */
            return isSameDay(messageDate.getTime() / 1000, today.getTime() / 1000) ?
                "امروز" :
                messageDate.toLocaleDateString('fa-IR', { year: 'numeric', month: 'long' , day: 'numeric' });//suncode  
        };
             
            
      
        var 
        nonce = stc_chat.stc_nonce,
        chat_container = $('#messages-list'),
        total_messages = $('.stc-chat-members').data('total'),
        data = {};
       
  
        if(chat_container.find('.stc-filter-empty').length && !thread_id ) return false;  
        
        thread_id = thread_id != '' ? thread_id : $('.stc-chat-members').data('conversation'); 
   
        var data_current = getItemByThreadId(thread_id); 
  
        data.action = 'stc_load_messages_data';
        data.nonce = nonce;
        data.thread_id = thread_id;
        data.offset = offset;
     
        if(!thread_id) return false;

        if(chat_container.hasClass('loading')) return false;
     
         chat_container.addClass('loading');
         
         if(type != 'loadmore') {
             $('.conversation-header').html('');   
             $('#messages-inner').html('');
             chat_container.removeClass('loaded_all');
         } else {
            chat_container.addClass('scroll');
         }
        
        if(!chat_container.find('.loader').length) { 
            chat_container.append(
              '<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>'
            );
        }
         $.ajax({
              url: stc_chat.ajax_url,
              data: data,
              type: 'POST',
              dataType: 'json',
              success: function(response) {
              
                 if(response.success) {
                    
                    
                    
               $('#form-create-messages').find('[name="thread_id"]').val(thread_id);
               
               
               
                var newURL = updateQueryStringParameter(stc_chat.chat_page, 'conversation', thread_id);
                history.pushState(null, null, newURL);
                $(window).bind("popstate", function() {
                    window.location = location.href
                });  
                  
                  var thread = response.data.thread;
                  var messages = response.data.thread.messages;
                  
                  
                  $('.conversation-header').html(StudiareChatTemplate.conversation_header(thread)); 
                  
                  if($('#form-create-messages').find('.stc-messages-action').length <= 0) {
                    $('#form-create-messages').append(StudiareChatTemplate.form_send_chat(thread)); 
                    stc_add_emoji();
                  }
                  
                   if(type != 'loadmore') { messages = messages.reverse(); } 
                  
                   messages.forEach(function(message) { 
               
                    const date = dateForDay(message.last_date);
                 
                    let date_group = '';
                    if($('.group_date[data-date="'+date+'"]').length <= 0) {
                        date_group =  `<div class="group_date" data-date="${date}"><span>${date}</span></div>`;  
                    }
                
                     if(type == 'loadmore') {
                        date_group =  `<div class="group_date" data-date="${date}"><span>${date}</span></div>`;  
                        $('#messages-inner').prepend(StudiareChatTemplate.message_item(message,thread));
                        
                         if($('.group_date[data-date="'+date+'"]').length >= 1) { 
                            if(messages.length > 0) { 
                                  $('.group_date[data-date="'+date+'"]').remove();
                                  $('#messages-inner').prepend(date_group);
                            }     
                         } else {
                            
                             $('#messages-inner').prepend(date_group);
                            
                         }
                        
                       
                     } else {
                        $('#messages-inner').append(date_group);
                        $('#messages-inner').append(StudiareChatTemplate.message_item(message,thread));
                     }

                   });

                   if(messages.length == 0) {
                      chat_container.addClass('loaded_all');
                   }
             
                 }
                 else {
                   
                 }
              },
              error: function() {
                 console.log('error');
              },
              complete: function() {
                 
                 chat_container.removeClass('loading');
                 chat_container.removeClass('scroll');
                
                
              },
           });
           
  
   
       };
  
       load_data_message('');
       
 
       
      function stc_change_conversation() {
         $(document).on('click', '.chat-sidebar .conversation-item', function(e) {
            e.preventDefault();
            var button = $(this),
               thread_id = button.data('conversation'),
               chat_container = $('.stc-chat-members');
               $('.conversation-item').removeClass('active');
               button.addClass('active');
               button.find('.unread').remove();
               chat_container.attr('data-conversation',thread_id); 
               chat_container.addClass('loaded');
               load_data_message(thread_id);
               $('.mess_notificaion').removeClass('has_messages'); 
            
         });
      }
      stc_change_conversation();
      
      function stc_add_emoji() {
         $('body').mouseup(function(e) {
            var container = $('#send-emoji *');
            if(!container.is(e.target) && typeof jQuery.prototype.emojioneArea !== 'undefined') {
               $('#send-emoji').removeClass('active');
               if($("#message-input").data("emojioneArea")) $('#message-input')[0].emojioneArea.hidePicker();
               
            }
         });
         $("#message-input").emojioneArea({
            standalone: true,
            hideSource: false,
            container: jQuery('#send-emoji'),
            autocomplete: false,
            pickerPosition: 'top',
            hidePickerOnBlur: true,
            events: {
               emojibtn_click: function() {
                  $('#message-input')[0].emojioneArea.hidePicker();
                  //	bp.Nouveau.Messages.mediumEditor.checkContentChanged();
                  checkInputValues($("#message-input"));
                  // Enable submit button.
                  $('#message-input').addClass('focus-in--content');
               },
               picker_show: function() {
                  $(this.button[0]).closest('#send-emoji').addClass('active');
               },
               picker_hide: function() {
                  $(this.button[0]).closest('#send-emoji').removeClass('active');
               },
            }
         });
      };
      
     function checkInputValues($target) {
         let hasValue = false;
         var $form = $target.parents('form');
         $form.find('.form-input').each(function() {
            if($(this).val().trim() !== '') {
               hasValue = true;
               return false; // Exit loop early
            }
         });
         $form.find('button[type="submit"]').prop('disabled', !hasValue);
      };
  
      function stc_property_message() { 
        
        let currentItem = null;

        $(document).on('click', '.mess-edit', function(e) {
            
            //event.stopPropagation(); 
            
            var $mess = $(this).parents('.message-item');
          
            let submenu = $(this).find('.action');
    
           
            if (submenu.length === 0) {
              
                if (currentItem) {
                    currentItem.find('.action').slideUp(function() {
                        $(this).remove();
                    });
                }
                
                if($mess.hasClass('me')) {
                    
                    submenu = $('<div class="me_action action"></div>');
                    if(!$mess.hasClass('deleted')) {
                        submenu.append('<div class="delete">Delete</div>');
                    }
             
                        
                } else {
                    
                    submenu = $('<div class="orther_action action"></div>');
                    submenu.append('<div class="reply">Reply</div>');
                    
                }
    
             
                $(this).append(submenu);
                submenu.slideDown();
    
             
                currentItem = $(this);
            } else {
             
                submenu.slideUp(function() {
                    $(this).remove();
                });
    
                currentItem = null;
            }
         });
       
          $('body').click(function() {
                if (currentItem) {
                    currentItem.find('.action').slideUp(function() {
                        $(this).remove();
                    });
                    currentItem = null;
                }
            }); 
            
          $(document).on('click', '.mess-edit .reply', function() {    
              
                var button = $(this),
                $mess = button.parents('.message-item'),
                $id = $mess.data('id'),
                $form = button.parents('.stc-chat-members').find('#form-create-messages'),
                $text = $mess.find('.message').html();
                
                if($mess.find('.gif-player').length) {
                   
                   $text = stc_chat.gif_text;
                   
                }
                
                if($mess.find('.gift-image').length) {
                   
                   $text = stc_chat.gift_text;
                   
                }
                
                if($mess.find('.file-media').length) {
                   
                   $text = stc_chat.file_text;
                   
                }
                
             
                $form.find('#reply_edit_message_text').remove();
                
     
                $form.append(
                   '<div id="reply_edit_message_text">'+
                   '<span class="close"><i class="stc-icon-x-light"></i></span>' +
                   '<strong>'+stc_chat.reply_text+'</strong>'+$text+'</strong>' +
                   '<input id="reply_message" type="hidden" name="reply_message" value="'+$id+'"></div>' 
                );
                
            
          }); 
          
          $(document).on('click', '.like-mess', function() {    
              
               var button = $(this),
                $mess = button.parents('.message-item'),
                thread_id = button.parents('.stc-chat-members').data('conversation'),
                id = $mess.data('id'),
                nonce = stc_chat.stc_nonce,
                data = {};
                
                data.action = 'stc_like_message';
                data.nonce = nonce;
                data.id = id;
                data.thread_id = thread_id;
       
                 $.ajax({
                      url: stc_chat.ajax_url,
                      data: data,
                      type: 'POST',
                      dataType: 'json',
                      success: function(response) {
                       
                         if(response.success) {
                             
                              var thread = response.data;
                              var message = response.data.messages;
                              var thread_global = getItemByThreadId(thread.thread_id); 
                                 
                          
                            
                                if (thread_global) {
                                    thread_global.last_message = message.content;
                                    thread_global.display_time = message.display_time; 
                                    thread_global.is_me = message.is_me;
                                    thread_global.last_date = message.last_date;
                                    thread_global.unread = thread.unread;
                                    
                                    updateItemInData(thread_global); 
                                }
                                
                              
                                $('.message-item[data-id="'+message.id+'"]').replaceWith(StudiareChatTemplate.message_item(message,thread_global));
                               
                           
                                
                         
                          
                         }
                         else {
                            stcThemeModule.show_notification(response.data[0].message, 'error');
                         }
                      },
                      error: function() {
                         console.log('error');
                      },
                      complete: function() {
                        
                      },
                   });
            
          }); 
            
          $(document).on('click', '.mess-edit .delete', function() { 
                            
            var button = $(this),
                $mess = button.parents('.message-item'),
                id = $mess.data('id'),
                thread_id = button.parents('.stc-chat-members').data('conversation'),
                nonce = stc_chat.stc_nonce,
                data = {};
                    data.action = 'stc_delete_message';
                    data.nonce = nonce;
                    data.id = id;
                    data.thread_id = thread_id;
                       $.ajax({
                          url: stc_chat.ajax_url,
                          data: data,
                          type: 'POST',
                          dataType: 'json',
                          success: function(response) {
                            
                             if(response.success) {
                               
                                var thread = response.data;
                                var message = response.data.messages;
                                var thread_global = getItemByThreadId(thread.thread_id); 
                            
                            
                                if (thread_global) {
                                    thread_global.last_message = message.content;
                                    thread_global.display_time = message.display_time; 
                                    thread_global.is_me = message.is_me;
                                    thread_global.last_date = message.last_date;
                                    thread_global.unread = thread.unread;
                                    
                                    updateItemInData(thread_global); 
                                }
                                
                              
                                $('.message-item[data-id="'+message.id+'"]').replaceWith(StudiareChatTemplate.message_item(message,thread_global));
                               
                           
                                
                             }
                             else {
                                stcThemeModule.show_notification(response.data[0].message, 'error');
                             }
                          },
                          error: function() {
                             console.log('error');
                          },
                          complete: function() {
                            
                          },
                       });
                    
                 });
                 
              $(document).on('click', '#reply_edit_message_text .close', function() {  
                
                var $form = $(this).parents('#form-create-messages');
                $form.find('#reply_edit_message_text').remove();
                
             });   

      };
      
      stc_property_message();
      
       $(document).on('click','.btn-dropdown' , function() { 
                    
            var item = $(this).parents('.conversation-action');
            
            if (item.hasClass('opened')) {
                item.removeClass('opened');
            } else {
                $('.conversation-action').removeClass('opened');
                item.addClass('opened');
            }
        });
        
        $('body').mouseup(function(e) {
            var container = $('.conversation-action *');
            if(!container.is(e.target)) {
              $('.conversation-action').removeClass('opened');
            }
         });
      
      
    
   });
})(jQuery);    