<?php

function stc_add_messages_total_count($thread_id) {  
    
    global $wpdb;
    
    $table_messages = stc_get_table('messages'); 
    $table_threads = stc_get_table('threads'); 
    
    
    $total_count = $wpdb->get_var( "SELECT COUNT(id) FROM $table_messages WHERE thread_id = $thread_id" );
    
    
    $data = array(
        'total_messages' => (int) $total_count
    );


    $where = array(
        'id' => $thread_id,
    );
    

    $updated = $wpdb->update(
        $table_threads,
        $data,
        $where
    );
        
    
    return $total_count;
    
}

function stc_get_messages_total_count($thread_id) {  
    
    global $wpdb;
    
  
    $table_name = stc_get_table('threads'); 
    
    
    $query = $wpdb->prepare(
        "SELECT total_messages FROM $table_name WHERE id = %d",
        $thread_id
    );
   
    $result = $wpdb->get_var($query);
    
    return $result;
    
}

function stc_get_all_messages_unread_count($user_id) {  
    
   
        global $wpdb;
    
        $table_recipients = stc_get_table('recipients');
      
        $query = $wpdb->prepare(
            "SELECT SUM(unread_count) AS total_unread 
             FROM $table_recipients 
             WHERE user_id = %d",
            $user_id
        );
        
        $count = $wpdb->get_var($query);
     
        
        return (int) $count;
      
    
}

function stc_get_messages_unread_count($thread_id , $user_id) {  
    
    
    
    
        global $wpdb;
    
        $table_recipients = stc_get_table('recipients');
      
        
      
        $count = $wpdb->get_var("SELECT unread_count  FROM $table_recipients WHERE user_id = $user_id AND thread_id = $thread_id");
        
     
        
        return $count;
      
    
}

function stc_add_messages_unread_count($count , $thread_id , $user_id = '' ) { 
  
        global $wpdb;

        
        
        $user_id = !empty($user_id) ? $user_id : get_current_user_id(); 
        
        $current_count = stc_get_messages_unread_count($thread_id,$user_id);
        
        
        $new_count = $current_count + $count;

        $table_name = stc_get_table('recipients');
        
       
     
        $data = array(
            'unread_count' => (int) $new_count
        );
        
        if($count == '-1') {
            $data = array(
                'unread_count' => 0
            );
        }
        
   
        $where = array(
            'thread_id' => $thread_id,
            'user_id' => $user_id
        );
        
   
        $updated = $wpdb->update(
            $table_name,
            $data,
            $where
        );
        
        return $current_count;
          
}

function stc_get_microtime(){
    $max_int = strlen( PHP_INT_MAX );
    
    $length = 14;
    
    if( $max_int < $length ) $length = $max_int;
    
    //$microtime = str_replace('.', '', (string) microtime(true)) ;
    $microtime = (string) microtime(true);
    if( strlen($microtime) > $length ){
        $microtime = substr( $microtime, 0, $length );
    }
    
    if( strlen( $microtime ) < $length ){
        $microtime = str_pad($microtime, $length, '0', STR_PAD_RIGHT);
    }
    
    return (int) $microtime;
}


function stc_get_user_threads($thread_id){
     
  
     global $wpdb;
     
     $table_recipients = stc_get_table('recipients');
    
     $thread_exists = $wpdb->prepare(
            "SELECT user_id  FROM $table_recipients WHERE thread_id = %d",
            $thread_id
     );
      
     $results = $wpdb->get_col($thread_exists);
     
     
    
     return $results;
}

function stc_get_last_messages($thread_id){ 
    
    $thread_id = (int) $thread_id; 
 
  
    global $wpdb;

    // Replace 'stc_get_table('messages')' with the actual table name if needed
    $table_name = stc_get_table('messages'); 
    
  
    $query = $wpdb->prepare(
        "SELECT * FROM $table_name 
        WHERE thread_id = %d 
        ORDER BY created_at DESC 
        LIMIT 1",
        $thread_id
    );
    
    $latest_message = $wpdb->get_row($query);
   

    if ($latest_message) {
        return $latest_message;
    } else {
        return false;
    }
    
    
}

function stc_get_time_messages($created_at){  
    
    $created_time_in_seconds = $created_at;
    
    $current_time = time();

    $time_difference = $current_time - $created_time_in_seconds;
  
     $time_ago = '';
     if ($time_difference < 60) {
        $time_ago = esc_html__('just now','studiare-core');
    } elseif ($time_difference < 3600) {
        $minutes = floor($time_difference / 60);
        $time_ago = $minutes . ' m';
         if(is_rtl()){$time_ago =$minutes . ' '.esc_html__('Minutes Ago','studiare-core');}else{$time_ago =$minutes . ' m';} //suncode
    } elseif ($time_difference < 86400) {
        $hours = floor($time_difference / 3600);
        $time_ago = $hours . ' h';
        if(is_rtl()){$time_ago =$hours . ' '.esc_html__('Hours Ago','studiare-core');}else{$time_ago =$hours . ' h';} //suncode
    } elseif($time_difference < 172800) {
        $days = floor($time_difference / 86400);
        $time_ago = $days . ' d';
        if(is_rtl()){$time_ago =$days . ' '.esc_html__('Days Ago','studiare-core');}else{$time_ago =$days . ' d';} //suncode 
    } else {
        //$time_ago = date('d-m-Y', $created_time_in_seconds);
        if(is_rtl()){
            $time_ago = date_i18n('Y-m-d', $created_time_in_seconds);//javad
        }else{
            $time_ago = date('d-m-Y', $created_time_in_seconds);
        }
    }
    
    return $time_ago;
    
}

function stc_get_name_messages($user_id){ 
    
    
    return bp_member_name($user_id);
    
}

function stc_get_avatar_messages($user_id){ 
    
    
    $image_url = bp_core_fetch_avatar(array(
        'item_id' => $user_id,
        'type' => 'thumb', 
        'html' => false   
    ));
    
    echo '<img src="'.$image_url.'" />';
    
}

function stc_get_message_item_data($message_id) { 
    
    global $wpdb;

    $table_name = stc_get_table('messages');
    
    $data = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM $table_name WHERE id = %d",
        $message_id
    ));
    
    return $data;
    
}

function stc_get_message_meta($message_id , $meta_key) { 
    
    global $wpdb;

    $table_name = stc_get_table('meta');
    
    $existing_meta = $wpdb->get_var($wpdb->prepare(
        "SELECT meta_value FROM $table_name WHERE message_id = %d AND meta_key = %s",
        $message_id, $meta_key
    ));
    
    return $existing_meta;
    
}

function stc_get_conversation_data($id) { 
    
      $id = (int) $id;
  
     global $wpdb;
     
     $table_recipients = stc_get_table('recipients');
    
     $user_id = get_current_user_id();
    
     $thread_exists = $wpdb->prepare(
            "SELECT * FROM $table_recipients WHERE user_id = %d AND thread_id = %s",
            $user_id , $id
      );
      
      $results = $wpdb->get_row($thread_exists);
      
    
      
      return $results;
    
}


function stc_get_order_conversation() { 
    
  
     global $wpdb;

    $table_recipients = stc_get_table('recipients');
    $table_messages = stc_get_table('messages');
    $user_id = get_current_user_id();
    
  
    $threads = $wpdb->get_col("SELECT thread_id  FROM $table_recipients WHERE user_id = $user_id");
    
    $created_at_array = [];
    
    foreach ($threads as $thread_id) {
     
        $created_at = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT created_at FROM $table_messages WHERE thread_id = %d ORDER BY created_at DESC LIMIT 1",
                $thread_id
            )
        );
    
   
        $created_at_array[] = [
            'thread_id' => $thread_id,
            'created_at' => $created_at
        ];
    }
    
       
    
   
    usort($created_at_array, function($a, $b) {
        return $b['created_at'] - $a['created_at'];
    });
    
    
    
    
    return $created_at_array;
  
}




function stc_update_message_meta($message_id , $meta_key , $value) { 

    global $wpdb;

    $table_name = stc_get_table('meta');

    $existing_meta = $wpdb->get_var($wpdb->prepare(
        "SELECT meta_id FROM $table_name WHERE message_id = %d AND meta_key = %s",
        $message_id, $meta_key
    ));

    if ($existing_meta) {
     
        $wpdb->update(
            $table_name,
            array(
                'meta_value' => $value
            ),
            array(
                'meta_id' => $existing_meta
            ),
            array(
                '%s'
            ),
            array(
                '%d'
            )
        );
        return true;
    } else {
        
        $wpdb->insert(
            $table_name,
            array(
                'message_id' => $message_id,
                'meta_key' => $meta_key,
                'meta_value' => $value
            ),
            array(
                '%d',
                '%s',
                '%s'
            )
        );
        return true;
    }


}

function stc_chat_page_url_thread_id($thread_id) { 
    
  
      
      $function_obj  = Ld_Dashboard_Functions::instance();
      $dashboard_page  = $function_obj->ld_dashboard_get_url( 'dashboard' ).'?tab=messages';
     
      
      if(!empty($thread_id)) {

        return $thread_id ?  add_query_arg( 'conversation', $thread_id , $dashboard_page )  :  $dashboard_page;

      } else {
        
        return $dashboard_page;

      } 
    
}

function stc_chat_page_url($user = '') {
      
  
      $thread_id = stc_check_two_user($user);
      
      //$function_obj  = Ld_Dashboard_Functions::instance();
      //$dashboard_page  = $function_obj->ld_dashboard_get_url( 'dashboard' ).'?tab=messages';
     
      //$dashboard_page = "https://dev.studiaretheme.ir/my-account/chat/";
      $dashboard_page="";
      if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
        $dashboard_page= wc_get_account_endpoint_url( 'chat' );
      }
      
        /*if ( class_exists('Redux')) {
            $dashboard_page = get_option("codebean_option");
            $dashboard_page = $dashboard_page['chat_page_url'];
        }*/
      
      if(!empty($user)) {

        return $thread_id ?  add_query_arg( 'conversation', $thread_id , $dashboard_page )  :  $dashboard_page;

      } else {
        
        return $dashboard_page; // javad

      }  
}


function stc_delete_thread_and_related_data($thread_id) {
    
    global $wpdb;

    
    $message_ids = $wpdb->get_col(
        $wpdb->prepare(
            "SELECT id FROM " . stc_get_table('messages') . " WHERE thread_id = %d",
            $thread_id
        )
    );

  
      if (!empty($message_ids)) {
     
        $meta_rows = $wpdb->get_results(
            "SELECT meta_id, meta_value FROM " . stc_get_table('meta') . " 
             WHERE meta_key = 'send_media'"
        );

       
        foreach ($meta_rows as $meta_row) {
            $meta_value_array = explode(',', $meta_row->meta_value);

          
            $attachment_ids = array_map('intval', $meta_value_array);

          
            foreach ($attachment_ids as $attachment_id) {
                wp_delete_attachment($attachment_id, true);
            }

         
            $wpdb->delete(
                stc_get_table('meta'),
                array('meta_id' => $meta_row->meta_id),
                array('%d')
            );
        }

    
        $wpdb->delete(
            stc_get_table('messages'),
            array('thread_id' => $thread_id),
            array('%d')
        );
    }

    $wpdb->delete(
        stc_get_table('recipients'),
        array('thread_id' => $thread_id),
        array('%d')
    );

    $wpdb->delete(
        stc_get_table('threads'),
        array('id' => $thread_id),
        array('%d')
    );
}



// Check data 

function stc_check_sender_id($id){ 
    global $wpdb;
    $table_name = stc_get_table('messages');
    $user_id = get_current_user_id();
    $query = $wpdb->prepare(
        "SELECT sender_id FROM $table_name WHERE id = %d",
        $id
    );
   
    $result = $wpdb->get_row($query);
    if ($result) {
       return true;
    } else {
      return false;
    }
}

function stc_get_subject_conversation($thread_id){ 
    global $wpdb;
    $table_name = stc_get_table('threads');
    $user_id = get_current_user_id();
    $query = $wpdb->prepare(
        "SELECT subject FROM $table_name WHERE id = %d",
        $thread_id
    );
   
    $result = $wpdb->get_var($query);
    
    return $result;
}

function stc_check_type_conversation($thread_id){ 
    global $wpdb;
    $table_name = stc_get_table('threads');
    $user_id = get_current_user_id();
    $query = $wpdb->prepare(
        "SELECT type FROM $table_name WHERE id = %d",
        $thread_id
    );
   
    $result = $wpdb->get_var($query);
    
    return $result;
}

function stc_check_start_conversation($thread_id){ 
    global $wpdb;
    $table_name = stc_get_table('threads');
    $user_id = get_current_user_id();
    $query = $wpdb->prepare(
        "SELECT user_start FROM $table_name WHERE id = %d",
        $thread_id
    );
   
    $result = $wpdb->get_var($query);
    
    if ($result && $result == $user_id) {
       return true;
    } else {
      return false;
    }
}

function stc_check_owner_conversation($thread_id){ 
    global $wpdb;
    $table_name = stc_get_table('recipients');
    $user_id = get_current_user_id();
    $query = $wpdb->prepare(
        "SELECT * FROM $table_name WHERE user_id = %d AND thread_id = %d",
        $user_id,
        $thread_id
    );
   
    $result = $wpdb->get_row($query);
    if ($result) {
       return true;
    } else {
      return false;
    }
}

function stc_check_two_user($user_recipients) { 
  
  global $wpdb; 
  
  $table_recipients = stc_get_table('recipients');
  $table_threads = stc_get_table('threads');
  $user_id = get_current_user_id();
   
   $query = $wpdb->prepare(
        "SELECT r.thread_id 
        FROM $table_recipients r
        INNER JOIN $table_threads t ON r.thread_id = t.id
        WHERE (r.user_id = %d OR r.user_id = %d)
        AND r.is_deleted = 0
        AND t.type = 'thread'
        GROUP BY r.thread_id 
        HAVING COUNT(DISTINCT r.user_id) = 2",
        $user_id,
        $user_recipients
    ); 
    
    $result = $wpdb->get_row($query);

    if ($result) {
        return $result->thread_id;
    } else {
        return false;
    }
    
}    

function stc_check_many_user($user_recipients) { 
    global $wpdb;
    $table_name = stc_get_table('recipients');
    $user_id = get_current_user_id();
    
  
    $all_users = array_merge([$user_id], $user_recipients);
    $placeholders = implode(',', array_fill(0, count($all_users), '%d'));


    $query = "
        SELECT thread_id 
        FROM $table_name 
        WHERE user_id IN ($placeholders)
        AND is_deleted = 0
        GROUP BY thread_id 
        HAVING COUNT(DISTINCT user_id) = %d
    ";


    $query_args = array_merge($all_users, [count($all_users)]);
    $prepared_query = $wpdb->prepare($query, ...$query_args);

    $result = $wpdb->get_row($prepared_query);

    if ($result) {
        return true;
    } else {
        return false;
    }
}
