<?php 
class SWSS_HtmlHelper
{
	public function __construct()
	{
		add_action('wp_ajax_swss_load_new_custom_status_configuration_box', array(&$this, 'load_new_custom_status_configuration_box'));
	}
	public function render_shortcode_info()
	{
		?>
		<p><?php _e('You can use the following shortcodes that will be replaced with user account and order datails (only if the current ticket is an order ticket type) data.', 'sunticket');?></p>
		<h3><?php _e('Account', 'sunticket');?></h3>
		[account_first_name], [account_last_name], [account_email]
		
		
		<h3><?php _e('Order (<i>only for order type tickets</i>)', 'sunticket');?></h3>
		[order_id], [order_total], [order_date]
		<h3><?php _e('Billing (<i>only for order type tickets</i>)', 'sunticket');?></h3>
		[billing_first_name], [billing_last_name], [billing_email], [billing_company], [billing_company], [billing_phone], [billing_country], [billing_state], [billing_city], [billing_post_code], [billing_address_1], [billing_address_2], [formatted_billing_address]
		<h3><?php _e('Billing (<i>only for order type tickets</i>)', 'sunticket');?></h3>
		[shipping_first_name], [shipping_last_name], [shipping_company], [shipping_phone], [shipping_country], [shipping_state], [shipping_city], [shipping_post_code], [shipping_address_1], [shipping_address_2], [formatted_shipping_address]
		<?php 
	}
	public function render_multile_user_selector($selected = array())
	{
		global $swss_user_model, $swss_option_helper;
		
		wp_enqueue_script('swss-assign-ticket-loader-users', SWSS_PLUGIN_PATH.'/js/backend-ticket-assigner-loader-users.js', array('jquery'));
		$ticket_visibility =  $swss_option_helper->get_all_options('ticket_visibility', 'all_tickets'); 
		?>
		<?php if($swss_user_model->is_current_user_administrator() || $ticket_visibility == 'all_tickets'): ?>
			<p><?php _e('You can optionally let specific user(s) to manage this ticket. Assign this ticket by search by user id, name, surname or email. <strong>NOTE: </strong> Left empty to allow any user to manage the ticket.', 'sunticket');?></p>
			<select class="js-data-users-ajax" id="swss_select2_user_id" name="user_id[]"  multiple="multiple" > 
				<?php if(!empty($selected))
						foreach($selected as $user_id)
						{
							$user_data = $swss_user_model->get_user_data($user_id);
							$first_last_name = $user_data->first_name.$user_data->last_name != "" ? $user_data->first_name." ".$user_data->last_name : __('N/A','sunticket');
							// $user_option_label = "#".$user_data->ID." - Login: ".$user_data->user_login." - First and last name: ".$first_last_name." - Email:".$user_data->user_email ;
							$user_option_label = "#".$user_data->ID." - ".__('Login:','sunticket')." ". $user_data->user_login." - ".__('First and last name:','sunticket')." ".$first_last_name." - ".__('Email:','sunticket')." ".$user_data->user_email ;
							echo '<option value="'.$user_id.'" selected="selected" >'.$user_option_label.'</option>';
						}
				?>
			</select>
			<p>
				<h4><?php _e('Notify users about the ticket assignment?', 'sunticket');?></h4>
				<select name="notification_action">
						<option value="no"><?php _e('No', 'sunticket');?></option>
						<option value="yes"><?php _e('Yes', 'sunticket');?></option>				
				</select>
			</p>
		<?php else: ?> 
			<p><?php _e('Only the administrator can assign the ticket managment.', 'sunticket'); ?></p>
			<input type="hidden" name="user_id[]" value="<?php echo get_current_user_id(); ?>" />
		<?php
			endif;
	}
	
	//add by suncode start
	public function frontend_tikets_count_by_status($user_id,$ticket_status="open"){
	    
	    //$user_id = get_current_user_id();
		if(!$user_id){
			return "0";
		}
	    if($ticket_status=="open"){
	        $ticket_status = array("open","status");
	    }
	    $args = array(
            'post_type' => 'swss_ticket',
            'post_status' => 'publish',
            'author' => $user_id,
            'posts_per_page'    => -1,
            'meta_query' => array(
        	    array(
        			'key'   => 'swss_status',
        			'value' => $ticket_status,
        	    ),
        	    
        	)
            
            );

            $query = new WP_Query( $args );
            return (count($query->posts));
	    wp_reset_query();
	}
	
	public function swss_show_ticket_stats_infront(){
	    
	        $user_id = get_current_user_id();
    		if(!$user_id){
    			return "0";
    		}

    		$args = array(
            'post_type' => 'swss_ticket',
            'post_status' => 'publish',
            'author' => $user_id,
            'posts_per_page'    => -1,
            );

            $query = new WP_Query( $args );
            $current_number_of_opened_order_tickets = (count($query->posts));
    		
			$base_tickets_url = (new SWSS_Option)->get_user_ticket_area_endpoint();
			$base_tickets_url = get_permalink( wc_get_page_id( 'myaccount' ) )."".$base_tickets_url."/?swss_filter_by_status=";
			
		    $open_ticket_count = $this->frontend_tikets_count_by_status($user_id,"open");

		    
		    $closed_ticket_count = $this->frontend_tikets_count_by_status($user_id,"closed");
		    $in_progress_ticket_count = $this->frontend_tikets_count_by_status($user_id,"in_progress");
			
			?>
			<style>
			    .swss_tickets_stats_holder { display: flex; justify-content: space-between;margin:20px 0; }
			    .swss_ticket_stat {transition:.4s; padding: 20px; text-align: center; border-radius: 5px; width: 24%; display: flex; justify-content: space-between; align-items: center; cursor: pointer;}
			    .swss_ticket_stat:hover{filter: hue-rotate(90deg);}
			    .swss_ticket_stat.swss_tickets_all { background: #cff2e1; color: #48ad7b; }
			    .swss_ticket_stat.swss_tickets_open { background: #eae6fe;color:#968ade; }
			    .swss_ticket_stat.swss_tickets_in_progress { background: #fcdfcd; color: #fe852f; }
			    .swss_tickets_in_progress .swss_stat_icon { background: #fe852f; }
			    .swss_ticket_stat.swss_tickets_closed { background: #fff2d9; color: #ffba30; }
			    .swss_tickets_closed .swss_stat_icon { background: #ffba30; }
			    .swss_stat_icon { display: inline-block; background: #48ad7b; border-radius: 12px; padding: 10px; box-shadow: 3px 3px 7px; }
			    .swss_stat_icon i { color: #fff; font-size: 40px; }
			    .swss_tickets_open .swss_stat_icon { background: #968ade; }
                .swss_stats_text { width: 70%; }
			    .swss_stats_text > div:first-child { font-size: 32px; font-weight: bold; }
			    
			    .swss_stat_icon svg { height: 60px; fill: #fff; display: block; }
			    @media screen and (max-width:1004px){
			        .swss_tickets_stats_holder { display: inline-block; }
			        .swss_ticket_stat { width: 100%; margin-bottom: 10px; }
			        .swss_stats_text { width: 65%; }
			        .swss_tickets_stats_holder .swss_ticket_stat { width: calc(50% - 10px); float: right; margin-left: 10px; transform: translateX(-5px);}
			        .swss_stat_icon svg { height: 32px;}
			    }
			    @media screen and (max-width:1004px){
			        .swss_tickets_stats_holder .swss_ticket_stat{padding:12px;}
			    }
			</style>
			<?php 
			$icon_all = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 80 80"> <path style="line-height:normal;text-indent:0;text-align:start;text-decoration-line:none;text-decoration-style:solid;text-decoration-color:#000;text-transform:none;block-progression:tb;isolation:auto;mix-blend-mode:normal" d="M 9 13 C 6.8026661 13 5 14.802666 5 17 L 5 31 L 6 31 C 9.325562 31 12 33.674438 12 37 C 12 40.325562 9.325562 43 6 43 L 5 43 L 5 57 C 5 58.929349 6.390363 60.552233 8.2167969 60.919922 L 8.2070312 60.980469 L 64.310547 70.939453 C 66.474044 71.324134 68.56397 69.86371 68.947266 67.699219 L 70.136719 61 L 71 61 C 73.197334 61 75 59.197334 75 57 L 75 43 L 74 43 C 70.674438 43 68 40.325562 68 37 C 68 33.674438 70.674438 31 74 31 L 75 31 L 75 17 C 75 14.802666 73.197334 13 71 13 L 9 13 z M 9 15 L 21 15 A 1 1 0 0 0 22 16 A 1 1 0 0 0 23 15 L 71 15 C 72.116666 15 73 15.883334 73 17 L 73 29.203125 C 69.084606 29.718014 66 32.947865 66 37 C 66 41.052135 69.084606 44.281986 73 44.796875 L 73 57 C 73 58.116666 72.116666 59 71 59 L 23 59 A 1 1 0 0 0 22 58 A 1 1 0 0 0 21 59 L 9 59 C 7.8833339 59 7 58.116666 7 57 L 7 44.796875 C 10.915394 44.281986 14 41.052135 14 37 C 14 32.947865 10.915394 29.718014 7 29.203125 L 7 17 C 7 15.883334 7.8833339 15 9 15 z M 22 18 A 1 1 0 0 0 21 19 A 1 1 0 0 0 22 20 A 1 1 0 0 0 23 19 A 1 1 0 0 0 22 18 z M 22 22 A 1 1 0 0 0 21 23 A 1 1 0 0 0 22 24 A 1 1 0 0 0 23 23 A 1 1 0 0 0 22 22 z M 22 26 A 1 1 0 0 0 21 27 A 1 1 0 0 0 22 28 A 1 1 0 0 0 23 27 A 1 1 0 0 0 22 26 z M 22 30 A 1 1 0 0 0 21 31 A 1 1 0 0 0 22 32 A 1 1 0 0 0 23 31 A 1 1 0 0 0 22 30 z M 22 34 A 1 1 0 0 0 21 35 A 1 1 0 0 0 22 36 A 1 1 0 0 0 23 35 A 1 1 0 0 0 22 34 z M 22 38 A 1 1 0 0 0 21 39 A 1 1 0 0 0 22 40 A 1 1 0 0 0 23 39 A 1 1 0 0 0 22 38 z M 22 42 A 1 1 0 0 0 21 43 A 1 1 0 0 0 22 44 A 1 1 0 0 0 23 43 A 1 1 0 0 0 22 42 z M 22 46 A 1 1 0 0 0 21 47 A 1 1 0 0 0 22 48 A 1 1 0 0 0 23 47 A 1 1 0 0 0 22 46 z M 22 50 A 1 1 0 0 0 21 51 A 1 1 0 0 0 22 52 A 1 1 0 0 0 23 51 A 1 1 0 0 0 22 50 z M 22 54 A 1 1 0 0 0 21 55 A 1 1 0 0 0 22 56 A 1 1 0 0 0 23 55 A 1 1 0 0 0 22 54 z M 19.759766 61 L 68.105469 61 L 66.978516 67.349609 C 66.783811 68.449118 65.758659 69.164069 64.660156 68.96875 L 19.759766 61 z"/> </svg>';
			$icon_open = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 80 80"> <path style="line-height:normal;text-indent:0;text-align:start;text-decoration-line:none;text-decoration-style:solid;text-decoration-color:#000;text-transform:none;block-progression:tb;isolation:auto;mix-blend-mode:normal" d="M 9 16 C 6.8026661 16 5 17.802666 5 20 L 5 60 C 5 62.197334 6.8026661 64 9 64 L 51 64 C 52.210938 64 53.264444 63.423754 54 62.564453 C 54.735556 63.423754 55.789062 64 57 64 L 71 64 C 73.197334 64 75 62.197334 75 60 L 75 20 C 75 17.802666 73.197334 16 71 16 L 57 16 C 55.789062 16 54.735556 16.576246 54 17.435547 C 53.264444 16.576246 52.210938 16 51 16 L 9 16 z M 9 18 L 51 18 C 52.116666 18 53 18.883334 53 20 A 1 1 0 0 0 54 21 A 1 1 0 0 0 55 20 C 55 18.883334 55.883334 18 57 18 L 71 18 C 72.116666 18 73 18.883334 73 20 L 73 60 C 73 61.116666 72.116666 62 71 62 L 57 62 C 55.883334 62 55 61.116666 55 60 A 1 1 0 0 0 54 59 A 1 1 0 0 0 53 60 C 53 61.116666 52.116666 62 51 62 L 9 62 C 7.8833339 62 7 61.116666 7 60 L 7 20 C 7 18.883334 7.8833339 18 9 18 z M 54 23 A 1 1 0 0 0 53 24 A 1 1 0 0 0 54 25 A 1 1 0 0 0 55 24 A 1 1 0 0 0 54 23 z M 54 27 A 1 1 0 0 0 53 28 A 1 1 0 0 0 54 29 A 1 1 0 0 0 55 28 A 1 1 0 0 0 54 27 z M 15 31 A 1.0001 1.0001 0 1 0 15 33 L 32 33 A 1.0001 1.0001 0 1 0 32 31 L 15 31 z M 39 31 A 1.0001 1.0001 0 1 0 39 33 L 44 33 A 1.0001 1.0001 0 1 0 44 31 L 39 31 z M 54 31 A 1 1 0 0 0 53 32 A 1 1 0 0 0 54 33 A 1 1 0 0 0 55 32 A 1 1 0 0 0 54 31 z M 60 31 A 1.0001 1.0001 0 1 0 60 33 L 68 33 A 1.0001 1.0001 0 1 0 68 31 L 60 31 z M 54 35 A 1 1 0 0 0 53 36 A 1 1 0 0 0 54 37 A 1 1 0 0 0 55 36 A 1 1 0 0 0 54 35 z M 15 39 A 1.0001 1.0001 0 1 0 15 41 L 38 41 A 1.0001 1.0001 0 1 0 38 39 L 15 39 z M 54 39 A 1 1 0 0 0 53 40 A 1 1 0 0 0 54 41 A 1 1 0 0 0 55 40 A 1 1 0 0 0 54 39 z M 60 39 A 1.0001 1.0001 0 1 0 60 41 L 65 41 A 1.0001 1.0001 0 1 0 65 39 L 60 39 z M 54 43 A 1 1 0 0 0 53 44 A 1 1 0 0 0 54 45 A 1 1 0 0 0 55 44 A 1 1 0 0 0 54 43 z M 15 47 A 1.0001 1.0001 0 1 0 15 49 L 32 49 A 1.0001 1.0001 0 1 0 32 47 L 15 47 z M 39 47 A 1.0001 1.0001 0 1 0 39 49 L 44 49 A 1.0001 1.0001 0 1 0 44 47 L 39 47 z M 54 47 A 1 1 0 0 0 53 48 A 1 1 0 0 0 54 49 A 1 1 0 0 0 55 48 A 1 1 0 0 0 54 47 z M 60 47 A 1.0001 1.0001 0 1 0 60 49 L 68 49 A 1.0001 1.0001 0 1 0 68 47 L 60 47 z M 54 51 A 1 1 0 0 0 53 52 A 1 1 0 0 0 54 53 A 1 1 0 0 0 55 52 A 1 1 0 0 0 54 51 z M 54 55 A 1 1 0 0 0 53 56 A 1 1 0 0 0 54 57 A 1 1 0 0 0 55 56 A 1 1 0 0 0 54 55 z"/> </svg>';
			$icon_in_progress = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64"> <path d="M 15 8 C 13.35 8 12 9.35 12 11 L 12 17.230469 C 12 17.500469 12.029609 17.75 12.099609 18 L 3 18 C 1.35 18 0 19.35 0 21 L 0 27.230469 C 0 28.640469 0.95984375 29.840391 2.3398438 30.150391 C 5.0798438 30.770391 7 33.18 7 36 C 7 38.82 5.0798438 41.229609 2.3398438 41.849609 C 0.95984375 42.159609 0 43.359531 0 44.769531 L 0 51 C 0 52.65 1.35 54 3 54 L 49 54 C 50.65 54 52 52.65 52 51 L 52 44.769531 C 52 44.499531 51.970391 44.25 51.900391 44 L 61 44 C 62.65 44 64 42.65 64 41 L 64 34.769531 C 64 33.359531 63.040156 32.159609 61.660156 31.849609 C 58.920156 31.229609 57 28.82 57 26 C 57 23.18 58.920156 20.770391 61.660156 20.150391 C 63.040156 19.840391 64 18.640469 64 17.230469 L 64 11 C 64 9.35 62.65 8 61 8 L 15 8 z M 15 10 L 61 10 C 61.55 10 62 10.45 62 11 L 62 17.230469 C 62 17.700469 61.680703 18.089219 61.220703 18.199219 C 57.560703 19.029219 55 22.24 55 26 C 55 29.76 57.560703 32.970781 61.220703 33.800781 C 61.680703 33.910781 62 34.299531 62 34.769531 L 62 41 C 62 41.55 61.55 42 61 42 L 50.160156 42 L 45.699219 42 L 15 42 C 14.45 42 14 41.55 14 41 L 14 34.769531 C 14 34.299531 14.319297 33.910781 14.779297 33.800781 C 18.439297 32.970781 21 29.76 21 26 C 21 23.63 19.980781 21.47 18.300781 20 C 17.330781 19.14 16.129297 18.509219 14.779297 18.199219 C 14.629297 18.159219 14.489141 18.09 14.369141 18 C 14.139141 17.82 14 17.540469 14 17.230469 L 14 11 C 14 10.45 14.45 10 15 10 z M 25 12 C 24.448 12 24 12.447 24 13 C 24 13.553 24.448 14 25 14 L 27 14 C 27.552 14 28 13.553 28 13 C 28 12.447 27.552 12 27 12 L 25 12 z M 31 12 C 30.448 12 30 12.447 30 13 L 30 39 C 30 39.553 30.448 40 31 40 C 31.552 40 32 39.553 32 39 L 32 13 C 32 12.447 31.552 12 31 12 z M 25 17 C 24.448 17 24 17.447 24 18 C 24 18.553 24.448 19 25 19 L 27 19 C 27.552 19 28 18.553 28 18 C 28 17.447 27.552 17 27 17 L 25 17 z M 3 20 L 13.839844 20 C 13.999844 20.06 14.169844 20.110391 14.339844 20.150391 C 17.079844 20.770391 19 23.18 19 26 C 19 28.82 17.079844 31.229609 14.339844 31.849609 C 12.959844 32.159609 12 33.359531 12 34.769531 L 12 41 C 12 42.65 13.35 44 15 44 L 49.630859 44 C 49.860859 44.18 50 44.459531 50 44.769531 L 50 51 C 50 51.55 49.55 52 49 52 L 3 52 C 2.45 52 2 51.55 2 51 L 2 44.769531 C 2 44.299531 2.3192969 43.910781 2.7792969 43.800781 C 6.4392969 42.970781 9 39.76 9 36 C 9 32.24 6.4392969 29.029219 2.7792969 28.199219 C 2.3192969 28.089219 2 27.700469 2 27.230469 L 2 21 C 2 20.45 2.45 20 3 20 z M 25 22 C 24.448 22 24 22.447 24 23 C 24 23.553 24.448 24 25 24 L 27 24 C 27.552 24 28 23.553 28 23 C 28 22.447 27.552 22 27 22 L 25 22 z M 37 22 C 36.448 22 36 22.447 36 23 C 36 23.553 36.448 24 37 24 L 49 24 C 49.552 24 50 23.553 50 23 C 50 22.447 49.552 22 49 22 L 37 22 z M 25 27 C 24.448 27 24 27.447 24 28 C 24 28.553 24.448 29 25 29 L 27 29 C 27.552 29 28 28.553 28 28 C 28 27.447 27.552 27 27 27 L 25 27 z M 37 28 C 36.448 28 36 28.447 36 29 C 36 29.553 36.448 30 37 30 L 41 30 C 41.552 30 42 29.553 42 29 C 42 28.447 41.552 28 41 28 L 37 28 z M 45 28 C 44.448 28 44 28.447 44 29 C 44 29.553 44.448 30 45 30 L 47 30 C 47.552 30 48 29.553 48 29 C 48 28.447 47.552 28 47 28 L 45 28 z M 25 32 C 24.448 32 24 32.447 24 33 C 24 33.553 24.448 34 25 34 L 27 34 C 27.552 34 28 33.553 28 33 C 28 32.447 27.552 32 27 32 L 25 32 z M 25 37 C 24.448 37 24 37.447 24 38 C 24 38.553 24.448 39 25 39 L 27 39 C 27.552 39 28 38.553 28 38 C 28 37.447 27.552 37 27 37 L 25 37 z"/> </svg>';
			$icon_closed = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 80 80"> <path d="M 9 16 C 6.794 16 5 17.794 5 20 L 5 34 L 6 34 C 9.309 34 12 36.691 12 40 C 12 43.309 9.309 46 6 46 L 5 46 L 5 60 C 5 62.206 6.794 64 9 64 L 45 64 C 45 63.323 45.044187 62.658 45.117188 62 L 26 62 A 1 1 0 0 0 25 61 A 1 1 0 0 0 24 62 L 9 62 C 7.897 62 7 61.103 7 60 L 7 47.9375 C 10.941 47.4445 14 44.073 14 40 C 14 35.927 10.941 32.5565 7 32.0625 L 7 20 C 7 18.897 7.897 18 9 18 L 24 18 A 1 1 0 0 0 25 19 A 1 1 0 0 0 26 18 L 71 18 C 72.103 18 73 18.897 73 20 L 73 32.0625 C 69.059 32.5555 66 35.927 66 40 C 66 44.073 69.059 47.4435 73 47.9375 L 75 47.9375 L 75 46 L 74 46 C 70.691 46 68 43.309 68 40 C 68 36.691 70.691 34 74 34 L 75 34 L 75 20 C 75 17.794 73.206 16 71 16 L 9 16 z M 25 21 A 1 1 0 0 0 24 22 A 1 1 0 0 0 25 23 A 1 1 0 0 0 26 22 A 1 1 0 0 0 25 21 z M 25 25 A 1 1 0 0 0 24 26 A 1 1 0 0 0 25 27 A 1 1 0 0 0 26 26 A 1 1 0 0 0 25 25 z M 25 29 A 1 1 0 0 0 24 30 A 1 1 0 0 0 25 31 A 1 1 0 0 0 26 30 A 1 1 0 0 0 25 29 z M 25 33 A 1 1 0 0 0 24 34 A 1 1 0 0 0 25 35 A 1 1 0 0 0 26 34 A 1 1 0 0 0 25 33 z M 25 37 A 1 1 0 0 0 24 38 A 1 1 0 0 0 25 39 A 1 1 0 0 0 26 38 A 1 1 0 0 0 25 37 z M 25 41 A 1 1 0 0 0 24 42 A 1 1 0 0 0 25 43 A 1 1 0 0 0 26 42 A 1 1 0 0 0 25 41 z M 25 45 A 1 1 0 0 0 24 46 A 1 1 0 0 0 25 47 A 1 1 0 0 0 26 46 A 1 1 0 0 0 25 45 z M 64 48 C 55.175289 48 48 55.175289 48 64 C 48 72.824711 55.175289 80 64 80 C 72.824711 80 80 72.824711 80 64 C 80 55.175289 72.824711 48 64 48 z M 25 49 A 1 1 0 0 0 24 50 A 1 1 0 0 0 25 51 A 1 1 0 0 0 26 50 A 1 1 0 0 0 25 49 z M 64 50 C 71.743831 50 78 56.256169 78 64 C 78 71.743831 71.743831 78 64 78 C 56.256169 78 50 71.743831 50 64 C 50 56.256169 56.256169 50 64 50 z M 25 53 A 1 1 0 0 0 24 54 A 1 1 0 0 0 25 55 A 1 1 0 0 0 26 54 A 1 1 0 0 0 25 53 z M 25 57 A 1 1 0 0 0 24 58 A 1 1 0 0 0 25 59 A 1 1 0 0 0 26 58 A 1 1 0 0 0 25 57 z M 59.707031 58.292969 L 58.292969 59.707031 L 62.585938 64 L 58.292969 68.292969 L 59.707031 69.707031 L 64 65.414062 L 68.292969 69.707031 L 69.707031 68.292969 L 65.414062 64 L 69.707031 59.707031 L 68.292969 58.292969 L 64 62.585938 L 59.707031 58.292969 z"/> </svg>';
			?>
			<div class="swss_tickets_stats_holder">
			    
			    <div onclick="javascript:window.location.href='<?php echo $base_tickets_url."all";?>'" class="swss_ticket_stat swss_tickets_all">
			        <div class="swss_stat_icon"><?php echo $icon_all; ?></div>
			        <div class="swss_stats_text">
			            <div><?php echo $current_number_of_opened_order_tickets; ?></div>
			            <div><?php _e("Ticket","sunticket") ?></div>
			        </div>
			    </div>
			    
			    <div onclick="javascript:window.location.href='<?php echo $base_tickets_url."open";?>'"  class="swss_ticket_stat swss_tickets_open">
			        <div class="swss_stat_icon"><?php echo $icon_open; ?></div>
			        <div class="swss_stats_text">
			            <div><?php echo $open_ticket_count; ?></div>
			            <div><?php _e("Open","sunticket") ?></div>
			        </div>
			    </div>
			    
			    <div onclick="javascript:window.location.href='<?php echo $base_tickets_url."in_progress";?>'"  class="swss_ticket_stat swss_tickets_in_progress">
			        <div class="swss_stat_icon"><?php echo $icon_in_progress; ?></div>
			        <div class="swss_stats_text">
			            <div><?php echo $in_progress_ticket_count; ?></div>
			            <div><?php _e("In Progress","sunticket") ?></div>
			        </div>       
			    </div>
			    
			    <div onclick="javascript:window.location.href='<?php echo $base_tickets_url."closed";?>'"  class="swss_ticket_stat swss_tickets_closed">
			        <div class="swss_stat_icon"><?php echo $icon_closed; ?></div>
			        <div class="swss_stats_text">
			            <div><?php echo $closed_ticket_count; ?></div>
			            <div><?php _e("Closed","sunticket") ?></div>
			        </div>
			    </div>
			    
			</div>    
	    <?php
	    
	}
	//add by suncode end
	
	public function frontend_ticket_area($order = null, $is_ajax = false, $display_header = true, $extra_parameters = array())
	{	
		

		if(!is_user_logged_in())
		{
			$not_logged_message = isset( $extra_parameters['not_logged_message']) ?  $extra_parameters['not_logged_message'] : "";
			if($not_logged_message == "")
				echo sprintf(__('Please <a href="%s">login</a>.', 'sunticket'), get_permalink( get_option('woocommerce_myaccount_page_id') ) );
			else 
				echo $not_logged_message;
			return;
		}
		
		global $swss_ticket_model, $swss_ticket_message_model, $swss_text_helper, $swss_option_helper,$sitepress;
		$user_id = get_current_user_id();
		if(!$user_id){
			return;
		}
		$sorting_order = isset($_GET['swss_sort_by_date']) ? $_GET['swss_sort_by_date'] : 'desc';
		$current_visible_status = isset($_GET['swss_filter_by_status']) ? $_GET['swss_filter_by_status'] : 'all';
		$default_sorting = 'desc';
		
		if(isset($extra_parameters['ticket_type']))
		{
			$ticket_type = $extra_parameters['ticket_type'];
			$messages_by_ticket = $swss_ticket_model->get_ticket_messages_by_user_id_and_type($user_id, $sorting_order, $ticket_type);
		}
		else	
		{
			$ticket_type = isset($order) ? 'order' : 'user';
			$messages_by_ticket = isset($order) ? $swss_ticket_model->get_ticket_messages_by_order_id(SWSS_Order::get_id($order), $sorting_order) : $swss_ticket_model->get_ticket_messages_by_user_id_and_type($user_id, $sorting_order);
		}
		
		
		//suncode extra parameters start
		if(isset($extra_parameters['ticket_id'])){
			$ticket_id = $extra_parameters['ticket_id'];
		}else{
			$ticket_id = isset( $_GET["ticket_id"] ) ? $_GET["ticket_id"] : "";
		}
		if(isset($extra_parameters['swss_action'])){
			$swss_action = $extra_parameters['swss_action'];
		}else{
			$swss_action = isset( $_GET["swss_action"] ) ? $_GET["swss_action"] : "";
		}
		//suncode extra parameters end
		
		$date_format = get_option( 'date_format' );
		$time_format = get_option( 'time_format' );
		$customized_texts = $swss_text_helper->get_texts();
		$options = $swss_option_helper->get_all_options();
		$attachment_box_id = 0;
		$staff_label = $customized_texts['staff_label_text'];
		$order_ticket_max_number = $options['order_ticket_limit'];
		$current_number_of_opened_order_tickets = count($messages_by_ticket); 

		$new_tickets_can_be_opened = $ticket_type != 'order' || $order_ticket_max_number < 0 ||  $current_number_of_opened_order_tickets < $order_ticket_max_number ;
		$new_tickets_can_be_opened = $ticket_type == 'user' && $options['disable_user_ticket_opening'] ? false : $new_tickets_can_be_opened ;
		$disable_user_reply_until_admin_message = array('order' => $options['order_ticket_disable_user_reply_until_admin_message'], 'user' => $options['user_ticket_disable_user_reply_until_admin_message'], 'ppt' => false);
		
		$subject_type = $swss_text_helper->get_topic_type($ticket_type.'_ticket_subject_type');
		
		$display_ticket_status = $options['display_ticket_status_on_frontend'] == 'yes' ? true : false;
		$available_ticket_statueses = $swss_ticket_model->get_available_statuses();
		
		$show_order_status =  $options['display_order_status_on_order_tickets']; 

		$max_file_size_text = ($options['max_file_size']/1024) < 1 ? floor($options['max_file_size'])."kb" : floor($options['max_file_size']/1024)."MB";
		
		//suncode
		global $wp;
		$current_url = home_url( add_query_arg( array(), $wp->request ) );
		//suncode
		
		if(!$is_ajax)
		{
			//CSS
			wp_enqueue_style('swss-ticket-area', SWSS_PLUGIN_PATH. '/css/frontend-ticket-area.css' );
			wp_enqueue_style('swss-ticket-area-pagination', SWSS_PLUGIN_PATH. '/css/frontend-pagination.css' );
			wp_enqueue_style( 'dashicons' ); 
			
			//JS
			wp_enqueue_script( 'tinymce_js', includes_url( 'js/tinymce/' ) . 'wp-tinymce.php', array( 'jquery' ), false, true );
			wp_register_script('swss-ticket-area', SWSS_PLUGIN_PATH. '/js/frontend-ticket-area.js', array('jquery') );
			wp_register_script('swss-ticket-area-new-message', SWSS_PLUGIN_PATH. '/js/frontend-ticket-area-new-message.js', array('jquery') );
			wp_register_script('swss-ticket-area-new-ticket', SWSS_PLUGIN_PATH. '/js/frontend-ticket-area-new-ticket.js', array('jquery') );
			wp_register_script('swss-paging', SWSS_PLUGIN_PATH. '/js/vendor/paging/paging.js', array('jquery') );
			wp_register_script('swss-frontend-upload-manager', SWSS_PLUGIN_PATH. '/js/frontend-upload-manager.js', array('jquery') );
			wp_register_script('swss-frontend-uploader', SWSS_PLUGIN_PATH. '/js/frontend-uploader.js', array('jquery') );
			
			$js_variables = array(
				'swss_ajax_url' => admin_url('admin-ajax.php'),
				'swss_empty_message_error' => __('Message cannot be empty','sunticket'),
				'swss_empty_subject_error' => __('Subject cannot be empty','sunticket'),
				'swss_file_size_error' => __('The file size excedes the size limit of: ','sunticket'),
				'swss_browser_compliant_error' => __('Your browser is not HTML5 compliant ','sunticket'),
				'swss_extension_error' => __('You are trying to upload files with a not allowed extension','sunticket'), //suncode
				'swss_upload_still_in_progress' => __('Please wait, upload still in progress.','sunticket'),
				'swss_new_ticket_result_message' => $customized_texts['new_ticket_succesfully_submitted_message'] /* str_replace('"', '\"', $customized_texts['new_ticket_succesfully_submitted_message']) */,
				'subject_max_chars'=> $options['subject_lenght'],
				'message_max_chars'=> $options['message_lenght'],
				'wpml_language' => isset($sitepress) ? $sitepress->get_current_language() : "en",
				'expand_button_text' => __('Expand','sunticket'),
				'collapse_button_text' => __('Collapse','sunticket'),
				'current_sort' => $sorting_order,
				'tiny_mce' => $options['frontend_use_tiny_mce'],
				'item_per_page' => $options['ticket_area_pagination'],
				'order_ticket_max_number' => $order_ticket_max_number,
				'current_number_of_opened_order_tickets'  => $current_number_of_opened_order_tickets,
				'next_page_text'  =>  __('Next','sunticket'),//suncode
				'prev_page_text'  =>  __('Previous','sunticket'),//suncode
				
				
			);
			wp_localize_script( 'swss-ticket-area', 'swss', $js_variables );
			wp_localize_script( 'swss-ticket-area-new-message', 'swss', $js_variables );
			wp_localize_script( 'swss-ticket-area-new-ticket', 'swss', $js_variables );
			wp_localize_script( 'swss-frontend-uploader', 'swss', $js_variables );
			wp_localize_script( 'swss-paging', 'swss', $js_variables );//suncode
			
			wp_enqueue_script( 'swss-ticket-area' );
			wp_enqueue_script( 'swss-ticket-area-new-message' );
			wp_enqueue_script( 'swss-ticket-area-new-ticket' );
			wp_enqueue_script( 'swss-paging' );
			wp_enqueue_script( 'swss-frontend-upload-manager' );
			wp_enqueue_script( 'swss-frontend-uploader' );
			
		}
		
		
		if(!$is_ajax){?>
		<?php if( $swss_action == "" ){ ?>
			<!--
			<?php if($display_header){?>
			<header class="swss_contact_us_header">
				<h2 class="swss_contact_us_title"><?php _e('Contact us','sunticket'); ?></h2>
			</header>
			<?php }//endif; ?>
			-->
			<?php 
			$this->swss_show_ticket_stats_infront();
			?>
	
			
			<h2 class="swss_st_title"><?php _e("Support Tickets","sunticket"); ?></h2>
			
			<!-- start top form filter -->
			<div class="swss_top_filter">
			<!-- /Options block -->
			<form id="swss_ticket_area_options_form" action="">
				<input type="hidden" name="swss_get_help" value="true"></input>
				<div class="swss_option_block">
					<label for="swss_sort_by_date_menu" class="swss_option_label"><?php _e('Sort tickets from:','sunticket'); ?></label>
					<select name="swss_sort_by_date" id="swss_sort_by_date_menu">
						<!-- <option value="default" <?php if($sorting_order == '') echo 'selected="selected"';?>><?php _e('Default sorting','sunticket'); ?></option> -->
						<option value="desc" <?php if($sorting_order == 'desc') echo 'selected="selected"';?>><?php _e('Newer to older','sunticket'); ?></option>
						<option value="asc" <?php if($sorting_order == 'asc') echo 'selected="selected"';?>><?php _e('Older to newer','sunticket'); ?></option>
					</select>
				</div>
				<?php if($display_ticket_status){ ?>
				<div class="swss_option_block">
					<label for="swss_filter_by_status_menu" class="swss_option_label"><?php _e('Filter by status:','sunticket'); ?></label>
					<select name="swss_filter_by_status" id="swss_filter_by_status_menu">
						<option value="all" <?php if($current_visible_status == 'all') echo 'selected="selected"';?>><?php _e('Show all','sunticket'); ?>
						<?php foreach($available_ticket_statueses as $available_status_code => $available_status_text)	
						{
							$is_selected = $current_visible_status == $available_status_code ? ' selected="selected" ' : "";
							echo '<option value="'.$available_status_code.'" '.$is_selected.' >'.$available_status_text["label"][$available_status_text['current_lang']].'</option>';
						}
						?>
					</select>
				</div>
				<?php }//endif; ?>
			</form>
			<!-- /Options block -->
			<?php
			/* suncode add new ticket button start */
			if( $swss_action == "" ){
				if($ticket_type != 'ppt' && $new_tickets_can_be_opened){ ?>
						<button id="swss_new_ticket_button_redirect" class="button swss_button" style="display:none;" ><?php _e('New ticket','sunticket'); ?></button>
						<a href="<?php echo $current_url."/?swss_action=NewTicket"?>" class="swss_new_ticket_btn swss_button" ><?php _e('New ticket','sunticket'); ?></a>
				<?php }
			}
			/* suncode add new ticket button end */
			?>
			</div> <!-- end top form filter -->
		<?php } ?>	
			<?php
		} //end !is_ajax
		
		?>
		<div id="swss_tickets_container">
		
			<input id="swss_type_id" type="hidden" value="<?php echo $ticket_type == 'order' ? SWSS_Order::get_id($order) : $user_id; ?>"></input>
			<input id="swss_type" type="hidden" value="<?php echo $ticket_type; ?>"></input>
			
			<div id="swss_ticket_pagination_container">
			
				<?php if( $swss_action == "" ){ ?>
				<div class="swss_table_holder table-responsive">
					<!-- start top head of tickets -->
					<table  class="table">
					<thead>
					<tr>
						<th class="swss_ticket_id"><?php echo __("Id","sunticket"); ?></th>
						<th class="swss_ticket_subject_title"><?php echo __("Subject","sunticket"); ?></th>
						
						<?php if(!is_wc_endpoint_url( 'view-order' )){ ?>
						<th class="swss_product_name"><?php echo __("Associated Product","sunticket"); ?></th>
						<?php } ?>
						
						<?php if($display_ticket_status){ ?>
						<th class="swss_t_status"><?php echo __("Status","sunticket"); ?></th>
						<?php } ?>
						<?php if($options['display_ticket_priority_selector_on_frontend'] == 'yes'){ ?>
						<th class="swss_t_priority"><?php echo __("Priority","sunticket"); ?></th>
						<?php } ?>
						<th class="swss_t_last_update"><?php echo __("Last Update","sunticket"); ?></th>
						<th></th>
					</tr>
					</thead>
					<!-- end top head of tickets -->
					<tbody id="swss_list_of_tickets_table">
					<!-- start list of tickets -->
					<?php $message_box_id = 0;
					$mainDateFormat = get_option('date_format')." (".get_option('time_format').")"; //suncode
					foreach($messages_by_ticket as $ticket_id => $messages): 
							
							$ticket_status_data = $swss_ticket_model->get_status_data($ticket_id);
							$status_text = $ticket_status_data['label'][$ticket_status_data['current_lang']];
							$ticket_status = $ticket_status_data['id'];
							// $creation_date =  $swss_ticket_model->get_creation_date($ticket_id) ;
							
							$creation_date =  get_the_modified_date($mainDateFormat,$ticket_id) ;
							$ppt_questions_left = $swss_ticket_model->get_attributes($ticket_id, 'number_of_questions_left', 0);
							$ppt_product_name = $swss_ticket_model->get_attributes($ticket_id, 'ppt_product_name', "");
							$unread_messages = $swss_ticket_model->count_new_admin_messages($ticket_id);
							$can_reply = $options['deny_closed_ticket_reply'] && $ticket_status == 'closed' ? false : true;
							
							$related_product = $swss_ticket_model->get_attributes($ticket_id, 'related_product', "-");
							if($related_product=="-"){
								$pro_title="-";
							}else{
							    $wc_product = wc_get_product( $related_product );
							    if($wc_product){
								$pro_name = $wc_product->get_title();
								$pro_title = "<a target='_blank' href='".get_permalink($related_product)."'>".$pro_name."</a>";
							    }
							    else{
							        	$pro_title="-";
							    }
							}
							
							//Unread messages managment
							$admin_total_replies = $admin_replies_counter = 0;
							foreach($messages as $message)
								if(!$message->is_customer_message)
									$admin_total_replies++;
								
							$admin_unread_message_base_index = $admin_total_replies - $unread_messages + 1; 
							$admin_replies_counter = 0;
							
							$order_status_text = $ticket_type == 'order' && $show_order_status ? sprintf(", <strong>%s</strong>", __('Order status: ','sunticket')).wc_get_order_status_name($order->get_status())." ": "";
							
							//Filter by status (if active)
							if($current_visible_status != 'all' && $current_visible_status != $ticket_status)
								continue;
							?>
						<!-- single ticket container -->
						<tr class="swss_single_ticket_container">
						
						
						<td class="swss_ticket_id"><?php echo $ticket_id;?>
						<?php if($unread_messages > 0) echo '<span class="swss_unread_admin_messages">'.$unread_messages.'</span> '; ?>  
						</td>
						<td class="swss_ticket_subject_title">
						    <a href="<?php echo $current_url.'/?swss_action=ViewTicket&ticket_id='.$ticket_id;?>" >
						    <?php if($ticket_type=='ppt') echo "#".$ticket_id." - ".$ppt_product_name; else echo $swss_ticket_model->get_subject($ticket_id);?>
						    </a>
						    </td>
						
						<?php if(!is_wc_endpoint_url( 'view-order' )){ ?>
						<td class="swss_product_name"><?php echo $pro_title;?></td>
						<?php } ?>
						
						<?php if($display_ticket_status){ ?>
						<td class="swss_t_status">
								<?php if($display_ticket_status) echo '<span style="background:'.$ticket_status_data['background_color'].'; color:'.$ticket_status_data['text_color'].';" class="swss_status_box swss_status_'.$ticket_status.'">'.$status_text.'</span> '; 
								//echo "<strong>".__('ID:','sunticket')."</strong>.".$ticket_id.", <strong>".__('Number of messages:','sunticket')."</strong> ".count($messages).", <strong>".__('Created on:','sunticket')."</strong> ".$creation_date.$order_status_text;  ?> 
								
								<?php if($ticket_type == 'ppt') 
										//echo ", <strong>".__('Questions left:','sunticket')."</strong> ".$ppt_questions_left ?> 
								
							</td>
						<?php } ?>	
						<?php if($options['display_ticket_priority_selector_on_frontend'] == 'yes'): ?>
							<td class="swss_t_priority">
								
									<?php	echo $swss_ticket_model->get_priority($ticket_id); ?>
								
							</td>
						<?php endif; ?>	
						
						<td class="swss_t_last_update">
						<?php echo $creation_date; ?>
						</td>	
						<td class="swss_view_btn">
						
							<a class="wcts_expand_button  swss_button" href="<?php echo $current_url.'/?swss_action=ViewTicket&ticket_id='.$ticket_id;?>" ><?php _e('View','sunticket');?></a>
							
							
						</td>
						
							<td class="swss_ticket_subject" style="display:none">
							<?php //if($ticket_type=='ppt') echo "#".$ticket_id." - ".$ppt_product_name; else echo $swss_ticket_model->get_subject($ticket_id); ?> 
							
							</td>
							
							<!-- old message was here -->
						</tr> <!-- end single ticket container -->
					<?php $message_box_id++; endforeach; //messages_by_ticket ?>
				</tbody>	
			</table>
				</div>						
					<!-- end list of tickets -->
					</tbody>
					</table>
				</div>
				<?php } ?>
<?php 

/* suncode view ticket start */
			if( $swss_action == "ViewTicket" ){
				/* start show ticket content in new page by suncode */


if( !empty($ticket_id) ){
	//$ticket_id = $_GET["ticket_id"];
	$ticket_status_data = $swss_ticket_model->get_status_data($ticket_id);
	$status_text = $ticket_status_data['label'][$ticket_status_data['current_lang']];
	$ticket_status = $ticket_status_data['id'];
	$creation_date =  $swss_ticket_model->get_creation_date($ticket_id) ;
	$ppt_questions_left = $swss_ticket_model->get_attributes($ticket_id, 'number_of_questions_left', 0);
	$ppt_product_name = $swss_ticket_model->get_attributes($ticket_id, 'ppt_product_name', "");
	
	$mainDateFormat = get_option('date_format').' ('.get_option('time_format').')'; //suncode
	$last_update_date =  get_the_modified_date($mainDateFormat,$ticket_id) ;
	
	$unread_messages = $swss_ticket_model->count_new_admin_messages($ticket_id);
	$can_reply = $options['deny_closed_ticket_reply'] && $ticket_status == 'closed' ? false : true;
	
	$messages = $swss_ticket_message_model->get_messages_by_ticket_id($ticket_id);
	krsort($messages);  //suncode
	//Unread messages managment
	$admin_total_replies = $admin_replies_counter = 0;
	foreach($messages as $message)
		if(!$message->is_customer_message)
			$admin_total_replies++;
		
	$admin_unread_message_base_index = $admin_total_replies - $unread_messages + 1; 
								

?>
							<div  class="swss_messages_box_single" >
							<h2 class="swss_single_ticket_title"><?php echo "<span class='swss_st_id'>#$ticket_id</span> "; if($ticket_type=='ppt') echo "#".$ticket_id." - ".$ppt_product_name; else echo $swss_ticket_model->get_subject($ticket_id) ;?></h2>
							
<?php
	$swss_woo_url = get_permalink( wc_get_page_id( 'myaccount' ) );
	$swss_alias = get_option("swss-user-tickets-area") ? : "swss-user-tickets-area";
if($ticket_type=='user'){
	echo "<span class=''><a target='' href='$swss_woo_url$swss_alias' class='swss_button swss_return_to_tickets' >".__('Return','sunticket')."</a></span>";
}
if($ticket_type=='order'){
	$swss_woo_url = wc_get_account_endpoint_url( 'orders' ) ;
	echo "<span class=''><a target='' href='$swss_woo_url' class='swss_button swss_return_to_tickets' >".__('Return','sunticket')."</a></span>";
}
	?>
							
							<div class="swss_single_ticket_info">
							
							<?php if($ticket_type=='user'){
							
							$related_product = $swss_ticket_model->get_attributes($ticket_id, 'related_product', "-");
							if($related_product=="-"){
								$pro_title="-";
							}else{
								$pro_title = "<a target='_blank' href='".get_permalink($related_product)."'>".get_the_title($related_product)."</a>";
							}
								?>
							<span><?php echo  "<strong>".__('Related Product:','sunticket')."</strong> ".$pro_title;?></span>
							<?php } ?>
							
							<span><?php echo  "<strong>".__('Created On:','sunticket')."</strong> ".$creation_date;?></span>
							<span><?php echo  "<strong>".__('Last Update On:','sunticket')."</strong> ".$last_update_date;?></span>
							<span><?php echo  "<strong>".__("Status","sunticket").":</strong> ";
							if($display_ticket_status){ echo "<span class='swss_single_status' style='background:".$ticket_status_data['background_color']."; color:".$ticket_status_data['text_color'].";' >$status_text</span>";} ?></span>
							</div>
							<!-- Top ticket notice start -->
							<?php 
							$top_message_show = get_field("swss_show_ticket_top_message","option") ? get_field("swss_show_ticket_top_message","option") : 0;
							if($top_message_show==1){
								$top_message = get_field("swss_ticket_top_message","option");
							?>
							<div class="swss_ticket_top_notice">
							<?php echo $top_message; ?>
							</div>
							<?php } ?>
							<!-- Top ticket notice end -->
							<!-- Reply area -->	
								<?php 
									$can_reply = $disable_user_reply_until_admin_message[$ticket_type] && !$last_reply_from_admin ? false : $can_reply;
									if( ($ticket_type != 'ppt' || $ppt_questions_left > 0) && $can_reply): ?>	
									<div class="swss_new_message_container" id="swss_new_message_container_<?php echo $ticket_id;?>">
										<span class="swss_new_message_label"><?php _e('New message','sunticket'); ?> (<?php _e('Max:','sunticket'); ?> <span id="swss_message_max_char_left_<?php echo $ticket_id;?>" class="swss_message_max_char_left"><?php echo $options['message_lenght']; ?></span>)</span>
										<textarea id="swss_new_message_textarea_<?php echo $ticket_id;?>" class="swss_new_message_textarea tinymce-enabled" data-id="<?php echo $ticket_id;?>" maxlength="<?php echo $options['message_lenght']; ?>"></textarea>
										<!-- attachment area -->
										<?php if($options['allow_files_attachment']): ?>
											<span class="swss_attachments_label"><?php _e('Attachment(s)','sunticket'); ?> <?php if($options['max_file_size'] > 0) echo sprintf(__('(Max size: %s)','sunticket'), $max_file_size_text); ?></span>
											<?php for($i = 0; $i<$options['num_of_uploadable_files']; $i++):
												 $current_file_id = $ticket_id."_".$i;?>
												 <div class="swss_input_attachment_container">
													 <input type="file" <?php if($options['allowed_file_types'] != '') echo 'accept="'.$options['allowed_file_types'].'"';?>
														   data-max-size="<?php echo $options['max_file_size']; //is already expressed in kb (otherwise it should be multiplied for *1024) ?>"
														   class="swss_attachment_input swss_new_message_attachment swss_new_message_attachment_group_<?php echo $ticket_id;?>" 
														   data-clear-button="<?php echo  $current_file_id;?>"
														   data-id="<?php echo  $current_file_id;?>"
														   data-upload-button-id = "#swss_file_upload_button_<?php echo  $current_file_id; ?>"
														   data-delete-button-id = "#swss_file_tmp_delete_button_<?php echo  $current_file_id; ?>"
														   id="swss_input_file_<?php echo  $current_file_id;?>" 
														   data-hide-index="<?php echo $i;?>"
														   data-main-container=".swss_new_message_container" >
													 </input>
													<!-- <button class="swss_clear_file_button swss_button" 
															 id="swss_clear_file_button_<?php echo  $current_file_id;?>" 
															 data-input-file="swss_input_file_<?php echo  $current_file_id;?>" ><?php _e('Clear','sunticket'); ?></button> -->
													
													<!-- New managment -->
													<input type="hidden" class="swss_file_metadata_<?php echo  $ticket_id; ?>" id="swss-filename-<?php echo $current_file_id; ?>" name="swss_files[<?php echo  $current_file_id; ?>][file_name]" value=""></input>
													<input type="hidden" class="swss_file_metadata_<?php echo  $ticket_id; ?>" id="swss-filenameprefix-<?php echo  $current_file_id; ?>" name="swss_files[<?php echo  $current_file_id; ?>][file_name_tmp_prefix]" value=""></input>
													<input type="hidden" class="swss_file_metadata_<?php echo  $ticket_id; ?>" id="swss-complete-name-<?php echo  $current_file_id; ?>" name="swss_files[<?php echo  $current_file_id; ?>][file_complete_name]" value=""></input>
													<!-- File name display after upload -->
													<div class="swss_file_name_display_after_upload" id="swss-filename-display-<?php echo $current_file_id;?>"></div>
													<!-- Upload button -->
													<button class="button swss_file_upload_button"  
															id="swss_file_upload_button_<?php echo  $current_file_id; ?>"
														   data-id="<?php echo  $current_file_id; ?>"  
														   data-upload-field-id="#swss_input_file_<?php echo  $current_file_id; ?>"><?php _e('Upload', 'sunticket') ?></button>
													<button class="button swss_file_tmp_delete_button"  
															id="swss_file_tmp_delete_button_<?php echo  $current_file_id; ?>"
														   data-id="<?php echo  $current_file_id; ?>"  
														   data-file-to-delete=""><?php _e('Delete', 'sunticket') ?> </button>
													<!-- Upload progress managment -->
													<div id="swss_upload_progress_status_container_<?php echo  $current_file_id; ?>" class="swss_upload_progress_status_container">
														<div class="swss_upload_progressbar" id="swss_upload_progressbar_<?php echo  $current_file_id; ?>"></div >
														<div class="swss_upload_progressbar_percent" id="swss_upload_progressbar_percent_<?php echo  $current_file_id; ?>">0%</div>
													</div>
												 
												 </div>
											<?php endfor; ?>
										<?php endif; ?>
										
										<button class="swss_submit_new_message_button swss_button" data-id="<?php echo $ticket_id;?>" data-message-box-id="<?php //echo $message_box_id; ?>"><?php _e('Submit new message','sunticket'); ?></button >
										<button class="swss_hide_new_message_button swss_button" ><?php _e('Cancel','sunticket'); ?></button >
									</div>
															
								<div class="swss_sending_message_status" id="swss_sending_message_status_<?php echo $ticket_id;?>"><img class="swss_preloader_image" src="<?php echo SWSS_PLUGIN_PATH.'/images/loader.gif' ?>" ></img></div>
								<button class=" swss_show_new_message_area_button swss_button" id="swss_show_new_message_area_button_<?php echo $ticket_id;?>" data-id="<?php echo $ticket_id;?>" ><?php _e('Add new message','sunticket'); ?></button >
								
									<?php 
									$last_reply_from_admin = false; 
									foreach($messages as $message):
										if($message->is_customer_message): 
											$last_reply_from_admin = false;
											$attachments = $swss_ticket_message_model->get_attachments($message->ID); ?>
											<div class="swss_ticket_message_content swss_customer_ticket_message_content">
												<span class="swss_customer_message_details swss_message_details">
												
												<div class="swss_user_icon">
												<?php 
												$get_author_id = get_the_author_meta('ID');
												$get_author_gravatar = get_avatar_url($get_author_id, array('size' => 450));
												echo '<img src="'.$get_author_gravatar.'" alt="" />';
												?>
												
												</div>
												
													<div class="swss_message_responser_title"><?php _e('You','sunticket'); ?></div>
													<?php //echo date_i18n($date_format." ".$time_format, strtotime($message->post_date)); ?>
												</span>
												<div class="swss_customer_message swss_message">
												<div class="swss_c_message_time"><?php echo date_i18n($date_format." (".$time_format.")", strtotime($message->post_date)); ?></div>
												<p><?php echo swss_restore_paragraph_breaks($message->post_content); ?></p>
												<?php if(!empty($attachments)):?>
														<div class="swss_attachments_container">
															<?php $attachment_counter = 0;
															foreach($attachments as $attachment_unique_value => $attachment_url): 
															$attachment_box_id++; ?>
															<div class="wcts_single_attachment" id="swss_single_attachment_<?php echo $attachment_box_id; ?>">
																<span class="wcts_attachment_title"><?php echo sprintf(__('Attachment %d','sunticket'), ++$attachment_counter); ?>: </span>
																<a class="dashicons dashicons-paperclip" href="<?php echo $attachment_url; ?>" target="_blank" download></a>
															</div>
															<?php endforeach; //attachments ?>
														</div>
													<?php endif; //!empty($attachments) ?>
												</div>
											</div>
										<?php //Admin replies
											else: 
											$admin_replies_counter++; 
											$last_reply_from_admin = true; 
											?>
											<div class="swss_ticket_message_content swss_admin_ticket_message_content <?php if($unread_messages != 0 && $admin_replies_counter >= $admin_unread_message_base_index) //echo 'swss_ticket_unread_message_content'; ?>">
												<span class="swss_admin_message_details swss_message_details">
												<div class="swss_admin_icon">
												<svg xmlns="http://www.w3.org/2000/svg" data-name="Layer 1" viewBox="0 0 66 66"><path d="M59.85,52.26a12,12,0,0,0-7.23-10.55l-9.79-3.93L41.14,35V33.38a13.54,13.54,0,0,0,2.6-4.23,21.08,21.08,0,0,0,.85-3.38l.22,0H45a2,2,0,0,0,1.91-1.49H47l1,.11h.14a1.46,1.46,0,0,0,1-.36A1.61,1.61,0,0,0,49.65,23L50,18.82a1.58,1.58,0,0,0-1.39-1.72l-1-.1h-.06a2,2,0,0,0-1.14-1.4l0-.14C47.51,11,46,8.54,44,5.43,41.85,1.88,35.86.3,28.43,1.29a6.73,6.73,0,0,0-4.66,2.25,3.91,3.91,0,0,0-.71,1.53,3.56,3.56,0,0,0-2.13,1.14c-2,2.21-1.92,6.94-1.52,9.49A2,2,0,0,0,18.48,17H18.4l-1,.1A1.59,1.59,0,0,0,16,18.82L16.38,23A1.6,1.6,0,0,0,17,24.08a1.48,1.48,0,0,0,1,.35h.15l1-.1h0a1.91,1.91,0,0,0,.65,1A2,2,0,0,0,21,25.8h.18l.16,0a19.26,19.26,0,0,0,.85,3.37,13.41,13.41,0,0,0,2.6,4.24V35L23,37.83l-9.31,3.76a12.57,12.57,0,0,0-7.54,11L5.7,64a1,1,0,0,0,1,1H59.3a1,1,0,0,0,1-1ZM32.18,40.14c-1.85-1.52-3.84-3.28-4.8-4.28a9.05,9.05,0,0,0,11,.1c-1,1-3,2.72-4.81,4.18Zm3.38,1a48.28,48.28,0,0,0,4.52-4l1,1.57L38.6,44.45A19,19,0,0,0,35.56,41.12ZM45,23.8l-.88-.06h0l.57-6.4.27,0H45l.58,0Zm3-4.75-.28,3.34-.45-.05h-.12L47.43,19h0ZM22.39,7.57A1.68,1.68,0,0,1,23.88,7a1,1,0,0,0,.81-.3A1,1,0,0,0,25,5.92c0-.21-.1-2.13,3.72-2.64,6.55-.88,11.91.38,13.66,3.2s3,4.87,2.11,8.5c0,.13-.05.26-.08.39a2,2,0,0,0-1.16.61,13.89,13.89,0,0,0-1.08-3.15c-1.73-3.22-4.32-3.13-6.22-3.06l-.46,0a17.89,17.89,0,0,0-1.85.18c-2,.27-4.73.63-7.37-.48a1,1,0,0,0-.94.09,9.25,9.25,0,0,0-3.7,5.78h-.22C21,12.85,21.06,9,22.39,7.57ZM18.34,22.39l-.28-3.34.47-.05h0l.31,3.35a.4.4,0,0,0-.11,0ZM21,23.8l-.61-6.38.89-.1.62,6.4Zm2.25,1.38.17-.17a2,2,0,0,0,.45-1.45l-.47-5.13c0-.72.06-1.45.09-2.12A6.91,6.91,0,0,1,26,11.55a16.16,16.16,0,0,0,7.85.41c.65-.09,1.21-.16,1.64-.18H36c1.82-.06,3.25-.12,4.39,2,1,1.9,1.64,6.42,1.81,8.89l-.08.9a1.89,1.89,0,0,0,.22,1.1l0,0a1.3,1.3,0,0,0-.1.25c-.63,2.62-4.5,4.22-6.73,4.85a2.51,2.51,0,1,0,.17,2,17.2,17.2,0,0,0,6-2.77,14.78,14.78,0,0,1-4.19,5.16,7.08,7.08,0,0,1-8.92,0,14.2,14.2,0,0,1-4.43-5.73A17.62,17.62,0,0,1,23.27,25.18ZM33.8,31a.51.51,0,1,1-.51-.51A.51.51,0,0,1,33.8,31Zm-8,6.12A45.06,45.06,0,0,0,30.13,41a14.71,14.71,0,0,0-3,3l-2.35-5.34ZM8.13,52.69a10.44,10.44,0,0,1,2.14-6,10.56,10.56,0,0,1,4.17-3.28l8.69-3.52,2.46,5.57a1.47,1.47,0,0,0,1.12,1.12,1.84,1.84,0,0,0,.33,0,1.5,1.5,0,0,0,1.29-.74,10,10,0,0,1,1-1.33l1.4,1.53L29,63H7.74ZM31,63l1.67-17.15a1,1,0,0,0-.25-.77L30.7,43.16a15.19,15.19,0,0,1,1.33-1h1.64c.26.21.68.56,1.16,1l-1.52,1.93a1,1,0,0,0-.21.72L34.83,63Zm5.8,0L35.13,46l1.09-1.38a13.45,13.45,0,0,1,1.2,1.68,1.48,1.48,0,0,0,1.29.75A1.86,1.86,0,0,0,39,47a1.47,1.47,0,0,0,1.12-1.13l2.52-6,9.17,3.68a10.09,10.09,0,0,1,3.92,3,10,10,0,0,1,2.08,5.73L58.26,63Z"/></svg>
												</div>
													<div class="swss_message_responser_title"><?php echo $staff_label;//.__(' on','sunticket') 
													$support_user = get_userdata($message->post_author);
													echo "<div class='swss_support_user'>".$support_user->data->display_name."</div>";
													?></div>
													<?php //echo date_i18n($date_format." ".$time_format, strtotime($message->post_date)); ?>
												</span>
												<div class="swss_admin_message swss_message ">
												<div class="swss_a_message_time"><?php echo date_i18n($date_format." (".$time_format.")", strtotime($message->post_date)); ?></div>
												<p><?php echo swss_restore_paragraph_breaks($message->post_content); ?></p>
												<?php 
													$attachments = $swss_ticket_message_model->get_attachments($message->ID); 
													if(!empty($attachments)):?>
														<div class="swss_attachments_container">
															<?php $attachment_counter = 0;
															foreach($attachments as $attachment_unique_value => $attachment_url): 
															$attachment_box_id++; ?>
															<div class="wcts_single_attachment" id="swss_single_attachment_<?php echo $attachment_box_id; ?>">
																<span class="wcts_attachment_title"><?php echo sprintf(__('Attachment %d','sunticket'), ++$attachment_counter); ?>: </span>
																<a class="dashicons dashicons-paperclip" href="<?php echo $attachment_url; ?>" target="_blank" download></a>
															</div>
															<?php endforeach; //attachments ?>
														</div>
													<?php endif; //!empty($attachments) ?>
												</div>
											</div>
									<?php  endif;
									$swss_ticket_model->reset_new_admin_messages_counter($ticket_id); //suncode reset counter	
									endforeach; //messages ?>
								
							<?php else: ?>
								<div class="wcst_no_more_questions_message"><?php if($ticket_type == 'ppt') echo $customized_texts['ppt_no_more_questions_left_message']; ?></div>
							<?php endif; //end $ticket_type ?>
								
							
							</div>

<?php	
	
}
/* end show ticket content in new page by suncode */
		
?>
<?php				
			}
			/* suncode view ticket end */
			
					?>
				
				
			
			</div> <!-- end swss_ticket_pagination_container -->
			
			<div id="swss_pagination_navigation"></div>
			
			<?php 
if( $swss_action == "NewTicketAdded" ){?>
	<div id="swss_new_ticket_box">
	<?php 
	$swss_woo_url = get_permalink( wc_get_page_id( 'myaccount' ) );
	$swss_alias = get_option("swss-user-tickets-area") ? : "swss-user-tickets-area";
	echo "<div class='swss_new_ticket_added'>".$customized_texts['new_ticket_succesfully_submitted_message'].""; 
	
	if($ticket_type=='order'){
	$swss_woo_url = wc_get_account_endpoint_url( 'orders' ) ;
	echo "<a target='' href='$swss_woo_url' class='swss_button swss_view_all_tickets' >".__('View Orders','sunticket')."</a>";
	}
	if($ticket_type=='user'){
	echo "<a target='' href='$swss_woo_url$swss_alias' class='swss_button swss_view_all_tickets' >".__('View Tickets','sunticket')."</a>";
	}
	echo "</div>";
	?>
	</div>
<?php  }			
			/* suncode new ticket start */
			if( $swss_action == "NewTicket" ){
?>				
<!-- New Ticket Box start -->


				<?php if($ticket_type != 'ppt' && $new_tickets_can_be_opened){ ?>
					<div id="swss_new_ticket_box">
						<span id="swss_new_ticket_box_title"><?php _e('Submit a new ticket','sunticket'); ?></span>
						<div id="swss_new_ticket_content">
							<div id="swss_new_ticket_description_box">
								<?php echo $customized_texts['new_ticket_description_text']; ?>
							</div>
							
							<?php 
							global $swss_option_helper, $swss_text_helper;
							$faq_list = $swss_text_helper->get_faq_data();
							
							$show_faqs = $options['show_faqs'];
							if( $show_faqs ){
							if( is_array($faq_list) && !empty($faq_list )){
								
								$faq_titles   = $faq_list['faq_title'];
								$faq_contents = $faq_list['faq_content'];
								
								echo "<div id='swss_faq_questions'>";
								
								$ij=0;
								foreach($faq_titles as $faq_title){
									
									// print_r($faqs);
									$title   = $faq_title;
									$content = $faq_contents[$ij];
									echo "<button class='swss_accordion'>$title</button>";
									echo "<div class='swss_panel'>$content</div>";
									$ij++;
									
								}
								
								echo "</div>";
								
							}
							}
// print_r($faq_list);

							?>
							
							<!-- Subject -->
							<label class="swss_new_ticket_label"><?php _e('Subject','sunticket'); ?> <?php if($subject_type == 'text_input'): ?> (<?php _e('Max:','sunticket'); ?> <span id="swss_subject_max_char_left"><?php echo $options['subject_lenght']; ?></span>) <?php endif; ?></label>
							<?php if($subject_type == 'text_input'): ?>
									<input type="text" id="swss_new_ticket_subject" value="" maxlength="<?php echo $options['subject_lenght']; ?>"></input>
							<?php else: 
									$topics = $swss_ticket_model->get_subject_topics_by_type($ticket_type); ?>
									<select id="swss_new_ticket_subject" name="swss_subject" class="swss_select" required="required">
								<?php foreach($topics as $topic_id => $topic):  ?>
										<option value="<?php echo $topic_id; ?>" ><?php echo $topic; ?></value>
								 <?php endforeach; ?>
									</select>
							<?php endif; ?>
							
							
							<?php if($ticket_type != 'order' ){?>
							<!-- related product start -->
							<label for="related_product"><?php echo __("Related Product","sunticket");?></label>
							<select id="swss_ticket_related_product" name="related_product" class="swss_select">
							<option value="-"><?php echo __("Select","sunticket");?></option>
							<?php 
							$buy_by_user = $this->swss_products_bought_by_curr_user();
							if($buy_by_user){
								sort($buy_by_user);
								foreach($buy_by_user as $product){
								    $wc_product = wc_get_product( $product );
									if($wc_product){
									    $pro_title = $wc_product->get_title();
									    echo "<option value='$product'>$pro_title</option>";
									}
								}
							}
							?>
							
							</select>
							<!-- related product end -->
							<?php }?>
							
							<!-- Priority -->
							<?php if($options['display_ticket_priority_selector_on_frontend'] == 'yes'): ?>
								<?php 
									$priority_list = $swss_ticket_model->get_priority_list();
									if(!empty($priority_list)): ?>
										<label class="swss_new_ticket_label"><?php echo __('Priority','sunticket'); ?> </label>
										<select id="swss_new_ticket_priority" name="swss_priority" class="swss_select" required="required">
										<?php foreach($priority_list as $priority_code => $priority_name): ?>
											<option value="<?php echo $priority_code; ?>"><?php echo $priority_name; ?></option>
										<?php endforeach; ?>
										</select>
									<?php endif; ?>
							<?php endif; ?>
							
							<!-- Message -->
							<label class="swss_new_ticket_label"><?php _e('Message','sunticket'); ?> (<?php _e('Max:','sunticket'); ?> <span id="swss_new_ticket_message_max_char_left"><?php echo $options['message_lenght']; ?></span>)</label>
							<textarea id="swss_new_ticket_message" class="swss_new_ticket_message tinymce-enabled" maxlength="<?php echo $options['message_lenght']; ?>"></textarea>
							<!-- Attachment area -->
							<?php if($options['allow_files_attachment']): ?>
								<span class="swss_attachments_label"><?php _e('Attachment(s)','sunticket'); ?> <?php if($options['max_file_size'] > 0) echo sprintf(__('(Max size: %s)','sunticket'), $max_file_size_text); ?></span>
								<?php for($i = 0; $i<$options['num_of_uploadable_files']; $i++):
									$current_file_id = "new_ticket_file_".$i?>
									 <div class="swss_input_attachment_container">
										 <input type="file" <?php if($options['allowed_file_types'] != '') echo 'accept="'.$options['allowed_file_types'].'"';?>
											   data-max-size="<?php echo $options['max_file_size']; ?>"
											   class="swss_attachment_input swss_new_ticket_attachment" 
											   data-clear-button="swss_clear_file_button_new_ticket_<?php echo $current_file_id;?>"
											   data-upload-button-id = "#swss_file_upload_button_<?php echo  $current_file_id; ?>"
											   data-delete-button-id = "#swss_file_tmp_delete_button_<?php echo  $current_file_id; ?>"
											   id="swss_input_file_<?php echo $current_file_id;?>" 
											   data-id="<?php echo  $current_file_id;?>" 
											   data-hide-index="<?php echo $i;?>" 
											   data-main-container="#swss_new_ticket_content" >
										 </input>
										 <!-- <button class="swss_clear_file_button swss_button" 
												  id="swss_clear_file_button_new_ticket_<?php echo $current_file_id;?>"
												  data-input-file="swss_input_file_<?php echo $current_file_id;?>" ><?php _e('Clear','sunticket'); ?></button>
										-->
										<!-- New managment -->
										<input type="hidden" class="swss_file_metadata" id="swss-filename-<?php echo  $current_file_id; ?>" name="swss_files[<?php echo  $current_file_id; ?>][file_name]" value=""></input>
										<input type="hidden" class="swss_file_metadata" id="swss-filenameprefix-<?php echo  $current_file_id; ?>" name="swss_files[<?php echo  $current_file_id; ?>][file_name_tmp_prefix]" value=""></input>
										<input type="hidden" class="swss_file_metadata" id="swss-complete-name-<?php echo  $current_file_id; ?>" name="swss_files[<?php echo  $current_file_id; ?>][file_complete_name]" value=""></input>
										<!-- Upload button -->
										<button class="button swss_file_upload_button"  
												id="swss_file_upload_button_<?php echo  $current_file_id; ?>"
											   data-id="<?php echo  $current_file_id; ?>"  
											   data-upload-field-id="#swss_input_file_<?php echo  $current_file_id; ?>"><?php _e('Upload', 'sunticket') ?></button>
										<button class="button swss_file_tmp_delete_button"  
												id="swss_file_tmp_delete_button_<?php echo  $current_file_id; ?>"
											   data-id="<?php echo  $current_file_id; ?>"  
											   data-file-to-delete=""><?php _e('Delete', 'sunticket') ?> </button>
										<!-- Upload progress managment -->
										<div id="swss_upload_progress_status_container_<?php echo  $current_file_id; ?>" class="swss_upload_progress_status_container">
											<div class="swss_upload_progressbar" id="swss_upload_progressbar_<?php echo  $current_file_id; ?>"></div >
											<div class="swss_upload_progressbar_percent" id="swss_upload_progressbar_percent_<?php echo  $current_file_id; ?>">0%</div>
										</div>
									  </div>
								<?php endfor; ?>
							<?php endif; ?>
							
							<div id="swss_new_ticket_loader"><img class="swss_preloader_image" src="<?php echo SWSS_PLUGIN_PATH.'/images/loader.gif' ?>" ></img></div>
							<div id="swss_new_ticket_status"></div>
							<button class="swss_button" id="swss_open_new_ticket_button" class="swss_clear_file_button"><?php _e('Open new ticket','sunticket'); ?></button >
						</div>
					</div>
				<?php }//endif; //ticket type check ?>
				<!-- New Ticket Box end -->
<?php				
			}
			/* suncode new ticket end */
			
			
			
?>
			
		<?php if( !is_wc_endpoint_url( 'view-order' ) ){ ?>
		</div> <!-- end swss_tickets_container -->
		<?php } ?>
		
		<?php
		
	}
	
	function load_new_custom_status_configuration_box()
	{
		$this->render_status_configuration();
		wp_die();
	}
	function render_status_configuration($status = null)
	{
		global $swss_wpml_helper,$swss_ticket_model;
		$id = isset($status) ? $status['id'] : swss_random_string();
		$is_custom = isset($status) ? $status['is_custom'] : true;
		$default_name = isset($status) ? $status["label"][$status['def_lang']] : "";
		$def_lang = $swss_wpml_helper->get_default_locale();
		$background_color = isset($status) ? $status['background_color'] : "#ffffff";
		$text_color = isset($status) ? $status['text_color'] : "#000000";
		$automatic_switch_to_selected_status = isset($status) ? $status['automatic_switch_to_selected_status'] : false;
		$statuses = $swss_ticket_model->get_available_statuses();
		wp_enqueue_style( 'jquery-color' ); 
		wp_enqueue_script('swss-color-picker',  SWSS_PLUGIN_PATH.'/js/vendor/color-picker/jscolor.js', array('jquery'));
		
		?>
		<div class="swss_status_configuration_container" id="swss_status_configuration_container_<?php echo  $id;?>">
			<input type="hidden" name="wcts_statuses[<?php echo $id; ?>][id]"  value="<?php echo $id ; ?>"></input>
			<input type="hidden" name="wcts_statuses[<?php echo $id; ?>][is_custom]"  value="<?php if($is_custom) echo 'true'; else echo 'false' ; ?>"></input>
			
			<div class="swss_full_container">
				<label><?php _e('Name','sunticket'); ?></label>
				<input type="text" placeholder="<?php if(!$is_custom) echo $default_name; else _e('Name','sunticket'); ?>" name="wcts_statuses[<?php echo $id; ?>][label][<?php echo $def_lang ;?>]"  value="<?php echo $default_name; ?>" <?php /* if(!$is_custom) echo 'disabled="disabled"'; else  */echo 'required="required"';?>></input>
			</div>
			<div class="swss_inline_container">
				<label><?php _e('Background color','sunticket'); ?></label>
				<input name="wcts_statuses[<?php echo $id; ?>][background_color]" id="color-picker-<?php echo $id;?>" class="jscolor"  value="<?php echo $background_color; ?>"></input>
			</div>
			
			<div class="swss_inline_container">
				<label><?php _e('Text color','sunticket'); ?></label>
				<input type="text" name="wcts_statuses[<?php echo $id; ?>][text_color]" id="color-picker-<?php echo $id;?>" class="jscolor" value="<?php echo $text_color; ?>"></input>
			</div>
			<?php if(true /* $is_custom */): ?>
			<div class="swss_block_container">
				<label><?php _e('Automatic switch to selected status in case of reply','sunticket'); ?></label>
				<p class="swss_option_description"><?php _e('If enabled, when the user posts a reply, the current ticket status will be switched to the selected one.','sunticket'); ?>
				<?php if($status['id'] == 'closed'): ?>
				<br><strong><?php _e('Note: ','sunticket'); ?></strong><?php _e('If a ticket is marked as closed, the user will not be able to reply. To allow that, enable the special option in the <strong>Ticket System Options</strong> menu.','sunticket'); ?>
				<?php endif; ?>
				</p>
				
				<!-- <input type="checkbox" name="wcts_statuses[<?php echo $id; ?>][automatic_switch_to_selected_status]"  value="true" <?php if($automatic_switch_to_selected_status) echo 'checked="checked"';?> ><?php _e('Enable','sunticket'); ?></input>-->
				<?php //swss_var_dump( $automatic_switch_to_selected_status); ?>
				<select name="wcts_statuses[<?php echo $id; ?>][automatic_switch_to_selected_status]">
					<option value="false" <?php selected( $automatic_switch_to_selected_status, false); ?> ><?php _e('Disabled','sunticket'); ?></option>
				<?php 
					foreach($statuses as $staus_code => $status_name)
						echo '<option value="'.$staus_code.'" '.selected( $automatic_switch_to_selected_status, $staus_code).' >'.$status_name["label"][$status_name["def_lang"]].'</option>';
				?>
				</select>
			</div>
			<?php endif; ?>
			
			<!-- WPML -->
			<?php if($swss_wpml_helper->wpml_is_active())
			{ 
			?>
			<div class="swss_language_container">
			<span class="swss_title"><?php _e('WPML','sunticket'); ?></span>
			<?php 
				$langs = $swss_wpml_helper->get_langauges_list($status);
				if($langs)
					foreach($langs as $lang_data): 
						if($lang_data['default_locale'] == $def_lang)
							continue;
						$current_lang_name = isset($status) ? $status["label"][$lang_data['default_locale']] : "";
					?>
					<div class="swss_inline_container">
						<label><img src="<?php echo $lang_data['country_flag_url']; ?>"/> <?php echo $lang_data['translated_name']; ?></label>
						<input type="text" placeholder="<?php echo printf(__('Name for %s language','sunticket'), $lang_data['translated_name']); ?>" name="wcts_statuses[<?php echo $id; ?>][label][<?php echo $lang_data['default_locale'] ;?>]"  value="<?php echo $current_lang_name; ?>" required="required"></input>
					</div>
					<?php endforeach; ?>
			</div>		
			<?php }
		
			if($is_custom ): ?>
			<div class="swss_delete_button_container">
				<button class="swss_delete_custom_status button-delete" data-id-to-delete="swss_status_configuration_container_<?php echo  $id;?>" ><?php _e('Delete','sunticket'); ?></button>
			</div>
			<?php endif; ?>
			
		</div>
		<?php
	}
	
	function swss_products_bought_by_curr_user() {
   
    // GET CURR USER
    $current_user = wp_get_current_user();
    if ( 0 == $current_user->ID ) return;
   
    // GET USER ORDERS (COMPLETED + PROCESSING)
    $customer_orders = get_posts( array(
        'numberposts' => -1,
        'meta_key'    => '_customer_user',
        'meta_value'  => $current_user->ID,
        'post_type'   => wc_get_order_types(),
        'post_status' => array_keys( wc_get_is_paid_statuses() ),
    ) );
   
    // LOOP THROUGH ORDERS AND GET PRODUCT IDS
    if ( ! $customer_orders ) return;
    $product_ids = array();
    foreach ( $customer_orders as $customer_order ) {
        $order = wc_get_order( $customer_order->ID );
        $items = $order->get_items();
        foreach ( $items as $item ) {
            $product_id = $item->get_product_id();
            $product_ids[] = $product_id;
        }
    }
    $product_ids = array_unique( $product_ids );
    $product_ids_str = implode( ",", $product_ids );
   
    // PASS PRODUCT IDS TO PRODUCTS SHORTCODE
    return $product_ids;
   
	}
}
?>