<?php  
class SWSS_Ticket
{
	var $all_options = array();
	private $previousErrorReporting;//add by suncode to prevent warnign adn notic in this class

	public function __construct()
	{
		//add by suncode to prevent warnign adn notic in this class start
    		// Store the previous error reporting level
            $this->previousErrorReporting = error_reporting();
            
            // Disable warnings and notices
            error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
        //add by suncode to prevent warnign adn notic in this class end
        
		add_action( 'init', array(&$this, 'register_custom_post_type'), 0 );
		
		//On delete:
		// -- delete all the associated swss_ticket_message 
		add_action('before_delete_post', array( &$this,'before_delete_ticket'), 10);
		 
		add_action('wp_ajax_swss_submit_new_message', array(&$this, 'ajax_add_new_message'));
		add_action('wp_ajax_swss_delete_message', array(&$this, 'ajax_delete_message'));
		add_action('wp_ajax_swss_submit_new_ticket', array(&$this, 'ajax_open_new_ticket'));
		add_action('wp_ajax_swss_delete_attachment', array(&$this, 'ajax_swss_delete_attachment'));
		add_action('wp_ajax_swss_get_tickets_list', array(&$this, 'ajax_swss_get_tickets_list'));
		add_action('wp_ajax_swss_reset_admin_unread_messages_counter', array(&$this, 'ajax_reset_admin_unread_messages_counter'));
		
		add_action( 'admin_init',  array( &$this, 'add_custom_capabilities' ));
		
		//
		add_action( 'save_post', array( &$this, 'update_ticket_associated_user_on_order_update' ), 999, 2 );
		//add_action( 'publish_swss_ticket', array( &$this, 'on_admin_ticket_creation' ), 10, 2 );
		//add_action( 'draft_to_publish', array( &$this, 'on_admin_ticket_creation' ));
	}
	
	//add by suncode to prevent warnign adn notic in this class start
	public function __destruct() {
        // Restore the previous error reporting level
        error_reporting($this->previousErrorReporting);
    }
    //add by suncode to prevent warnign adn notic in this class end
	
	function add_custom_capabilities()
	{
		global $swss_user_model ;
		//$roles = array('administrator','shop_manager');
		$capabilities = array('edit_swss_ticket', 
							  'edit_swss_tickets',
							  'publish_swss_tickets',
							  'read_swss_ticket',
							  'read_private_swss_tickets',
							  'delete_swss_tickets',
							  'delete_swss_ticket',
							  'create_swss_tickets',
							  'edit_others_swss_tickets');
		$roles = $swss_user_model->get_roles_that_can();
		$roles_that_can_not = $swss_user_model->get_roles_that_cannot();
		
		foreach($roles as $role)
		{
			$admin = get_role( $role );
			
			if(isset($admin))
			{
				//$admin->add_cap( 'manage_swss_ticket' );
				foreach($capabilities as $cap) 
					$admin->add_cap( $cap );
			}
		}
		foreach($roles_that_can_not as $role)
		{
			$not_admin = get_role( $role );
			if(isset($not_admin))
				foreach($capabilities as $cap) 
					$not_admin->remove_cap( $cap );
		}
	}
	function register_custom_post_type() 
	{
		global $swss_option_helper, $swss_user_model;
		$role_who_can_manage = isset($swss_option_helper) ? $swss_option_helper->get_all_options('roles_can_manage_ticket_system', array()) : array();
		
		$is_autorized_user = $swss_user_model->current_users_belongs_to_roles($role_who_can_manage);
		//swss_var_dump($is_autorized_user);
		$labels = array(
			'name'                => __( 'Support Ticket', 'sunticket' ),
			'singular_name'       => __( 'Support Ticket', 'sunticket' ),
			'menu_name'           => __( 'Sunticket', 'sunticket' ),
			'name_admin_bar'      => __( 'Sunticket', 'sunticket' ),
			'parent_item_colon'   => __( 'Parent Item:', 'sunticket' ),
			'all_items'           => __( 'All Tickets', 'sunticket' ),
			'add_new_item'        => __( 'Add Ticket', 'sunticket' ),
			'add_new'             => __( 'Add Ticket', 'sunticket' ),
			'new_item'            => __( 'New Ticket', 'sunticket' ),
			'edit_item'           => __( 'Edit Ticket', 'sunticket' ),
			'update_item'         => __( 'Update Ticket', 'sunticket' ),
			'view_item'           => __( 'View Ticket', 'sunticket' ),
			'search_items'        => __( 'Search Tickets', 'sunticket' ),
			'not_found'           => __( 'Not found', 'sunticket' ),
			'not_found_in_trash'  => __( 'Not found in Trash', 'sunticket' ),
		);
		$args = array(
			'label'               => __( 'Suntickets', 'sunticket' ),
			'description'         => __( 'Sunticket System', 'sunticket' ),
			'labels'              => $labels,
			//'menu_icon'           => 'dashicons-media-document',
			'menu_icon'           => SWSS_PLUGIN_PATH.'/images/icon.png',
			/*  'supports'            =>  array('author'),  */
			'taxonomies'          => array( /*'category' , 'post_tag' */ ),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,                                      //'woocommerce': rendered in WooCommerce menu
			'show_in_menu'        => $is_autorized_user /* current_user_can( 'manage_woocommerce' ) ? true : false */,
			/* 'menu_position'       => swss_get_free_menu_position(5), */
			'show_in_admin_bar'   => $is_autorized_user,
			'show_in_nav_menus'   => $is_autorized_user,
			'can_export'          => true,
			'has_archive'         => false,		
			'exclude_from_search' => true,
			'publicly_queryable'  => false,
			//'map_meta_cap'		  => true,
			//'capability_type'     => array('swss_manage_ticket', 'swss_manage_tickets'),/* 'shop_order' */  ////review-> shop_order raises error
			'capabilities' => array(
				'edit_post' => 'edit_swss_ticket',
				'edit_posts' => 'edit_swss_tickets',
				//'edit_others_posts' => 'edit_swss_tickets',
				'publish_posts' => 'publish_swss_tickets',
				'read_post' => 'read_swss_ticket',
				'read_private_posts' => 'read_private_swss_tickets',
				'delete_posts' => 'delete_swss_tickets',
				'delete_post' => 'delete_swss_ticket',
				'create_posts'       => 'create_swss_tickets',
				 'edit_others_posts'  => 'edit_others_swss_tickets', 
			), 
			/* 'rewrite'             => array( 'slug' => 'wppas_photo' ) */
		);
		register_post_type( 'swss_ticket', $args );
		remove_post_type_support('swss_ticket', 'title' );
		remove_post_type_support( 'swss_ticket', 'editor' ); 
		flush_rewrite_rules();
		
		//Custom taxonomy
		$labels = array(
		'name'              => _x( 'Status', 'sunticket' ),
		'singular_name'     => _x( 'Status', 'sunticket' ),
		'search_items'      => __( 'Search Status','sunticket' ),
		'all_items'         => __( 'All Statuses','sunticket' ),
		'parent_item'       => __( 'Parent Status' ,'sunticket'),
		'parent_item_colon' => __( 'Parent Status:' ),
		'edit_item'         => __( 'Edit Status','sunticket' ),
		'update_item'       => __( 'Update Status','sunticket' ),
		'add_new_item'      => __( 'Add New Status','sunticket' ),
		'new_item_name'     => __( 'New Status Name','sunticket' ),
		'menu_name'         => __( 'Statuses','sunticket' ),
		);
		$args = array(
			'hierarchical'      => false,
			'labels'            => $labels,
			'show_ui'           => $is_autorized_user,
			'show_admin_column' => $is_autorized_user,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'swss_ticket_status' ),
		);
		//register_taxonomy( 'swss_ticket_status', array( 'swss_ticket' ), $args );
		
		//Custom taxonomy
		$labels = array(
		'name'              => __( 'Priority', 'sunticket' ),
		'singular_name'     => __( 'Priority', 'sunticket' ),
		'search_items'      => __( 'Search Priority','sunticket' ),
		'all_items'         => __( 'All Priorities','sunticket' ),
		'parent_item'       => __( 'Parent Priority' ,'sunticket'),
		'parent_item_colon' => __( 'Parent Priority:' ),
		'edit_item'         => __( 'Edit Priority','sunticket' ),
		'update_item'       => __( 'Update Priority','sunticket' ),
		'add_new_item'      => __( 'Add New Priority','sunticket' ),
		'new_item_name'     => __( 'New Priority Name','sunticket' ),
		'menu_name'         => __( 'Priorities','sunticket' ),
		);
		$args = array(
			'hierarchical'      => false,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'swss_ticket_priority' ),
		);
		register_taxonomy( 'swss_ticket_priority', array( 'swss_ticket' ), $args );
	}
	//the ones with open status;
	public function count_new_tickets()
	{
		global $swss_option_helper, $swss_user_model;
		
		$ticket_visibility = $swss_option_helper->get_all_options('ticket_visibility', 'all_tickets');
		/* $count_posts = wp_count_posts('swss_ticket');
		 
		if(isset($count_posts->publish))
			foreach( */
		$result = 0;
		$args = array('post_status'   => 'publish',
					  'post_type'     => 'swss_ticket',
					  'fields' => 'ids',
					  'meta_query'	=> array(
						//'relation'		=> 'AND',
						array(
							'key'	 	=> 'wcst_new_messages_counter',
							'value'	  	=> 0,
							'compare' 	=> '>',
						)/*,
						 array(
							'key'	  	=> 'featured',
							'value'	  	=> '1',
							'compare' 	=> '=',
						), */
					),
				);
				
			
		if(!$swss_user_model->is_current_user_administrator() && $ticket_visibility != 'all_tickets')
		{
			//swss_var_dump($args);
			$args['meta_query']['relation'] = 'AND';
			$args['meta_query'][] = 
			     array(
				   'relation' => 'OR',
					  array(
						'key' => 'swss_manager_user_id',
						'compare' => '=',
						 'value' => get_current_user_id() //assigned 
					  ),
					  array(
						'key' => 'swss_manager_user_id',
						'compare' => 'NOT EXISTS',
						'value' => ''
					  ),
					  array(
						'key' => 'swss_manager_user_id',
						'compare' => '=',
						'value' => null
					  )
				  );
			//swss_var_dump($args);  
		}
		$ticket_ids = get_posts( $args ); //num of post with new messages
		foreach((array)$ticket_ids as $ticket_id)
		{
				//swss_var_dump($ticket_id);
				//swss_var_dump($this->count_new_messages($ticket_id));
				$result += $this->count_new_messages($ticket_id);
		}
		//return is_array($ticket_ids) ? count($ticket_ids) : 0; 
		return $result; 
	}
	public function get_order_ticket_number($order_id)
	{
		global $swss_order_model;
		$result = $swss_order_model->get_ticket_ids_by_order_id($order_id);
		$result = $result && is_array($result ) ? count($result ) : 0;
		/*$result = 0;
		$args = array('post_status'   => 'publish',
					  'post_type'     => 'swss_ticket',
					 'fields' => 'ids',
					  'meta_query'	=> array(
						'relation'		=> 'AND',
						array(
							'key'	 	=> 'swss_associated_order',
							'value'	  	=> $order_id,
							'compare' 	=> '=',
						),
						 array(
							'key'	  	=> 'swss_ticket_type',
							'value'	  	=> 'order',
							'compare' 	=> '=',
						)
					),
				);
		
		$ticket_ids = get_posts( $args ); //num of post with new messages
		
		foreach((array)$ticket_ids as $ticket_id)
		{
				//swss_var_dump($ticket_id);
				$result += $this->count_new_messages($ticket_id);
		}
		return is_array($ticket_ids) ? count($ticket_ids) : 0; */
		return $result ;
	}
	public function count_new_messages($ticket_id)
	{
		$result =  get_post_meta($ticket_id, 'wcst_new_messages_counter', true);
		return $result ? $result : 0;
	}
	public function count_total_messages($ticket_id)
	{
		$args = array(
				'posts_per_page'   => -1,
				'category'         => '',
				'category_name'    => '',
				'post_type'        => 'swss_ticket_message',
				'post_parent'      =>  $ticket_id,
				'post_status'      => 'publish',
				'suppress_filters' => true,
				'fields'
			);
		$messages = get_posts( $args );
		return isset($messages) && is_array($messages) ? count($messages) : 0;
	}
	public function delete_ticket($ticket_id, $force_delete = true)
	{
		wp_delete_post( $ticket_id, $force_delete );
	}
	public function reset_new_messages_counter($ticket_id)
	{
		delete_post_meta($ticket_id, 'wcst_new_messages_counter');
		update_post_meta($ticket_id, 'wcst_new_messages_counter', 0, true);
	}
	public function update_new_messages_counter($ticket_id, $new_messages_counter = 1)
	{
		$old_value = get_post_meta($ticket_id, 'wcst_new_messages_counter', true);
		$new_value = isset($old_value) && is_numeric($old_value) ? $new_messages_counter + $old_value : $new_messages_counter;
		update_post_meta($ticket_id, 'wcst_new_messages_counter', $new_value, $old_value);
	}
	// Updated on the add_reply() method defined on TicketMessage model
	public function update_new_admin_messages($ticket_id, $new_messages_counter = 1)
	{
		$old_value = get_post_meta($ticket_id, 'wcst_new_admin_messages_counter', true);
		$new_value = isset($old_value) && is_numeric($old_value) ? $new_messages_counter + $old_value : $new_messages_counter;
		update_post_meta($ticket_id, 'wcst_new_admin_messages_counter', $new_value, $old_value);
	}
	public function reset_new_admin_messages_counter($ticket_id)
	{
		delete_post_meta($ticket_id, 'wcst_new_admin_messages_counter');
		update_post_meta($ticket_id, 'wcst_new_admin_messages_counter', 0, true);
	}
	public function count_new_admin_messages($ticket_id)
	{
		$result =  get_post_meta($ticket_id, 'wcst_new_admin_messages_counter', true);
		return $result ? $result : 0;
	}
	public function count_total_new_admin_messages_per_type($id = null, $ticket_type = "user") //order, user, ppt
	{
		$id = !$id ? get_current_user_id() : $id;
		if(!$id)
			return 0;
		$messages_by_ticket = $ticket_type == 'user' ? $this->get_ticket_messages_by_user_id_and_type($id, 'asc', $ticket_type) : $this->get_ticket_messages_by_order_id($id, 'asc');
		$admin_total_replies =  0;
		
		foreach((array)$messages_by_ticket as $ticket_id => $messages)
			$admin_total_replies += $this->count_new_admin_messages($ticket_id);
				
		return $admin_total_replies;
	}	
	public function get_who_replied_latest($ticket_id)
	{
		global $swss_ticket_message_model;
		$result = $swss_ticket_message_model->get_messages_by_ticket_id($ticket_id);
		$who = 'N/A';
		if(isset($result) && !empty($result))
		{
			$last = end($result);
			$who = $last->is_customer_message ? 'customer' : 'staff'; 
		}
		//swss_var_dump($result);
		return $who;
	}
	public function ajax_swss_get_tickets_list()
	{
		$resultCount = 50;
		$search_string = isset($_GET['search_string']) ? $_GET['search_string'] : null;
		$page = isset($_GET['page']) ? $_GET['page'] : null;
		$offset = isset($page) ? ($page - 1) * $resultCount : null;
		$tickets = $this->get_tickets_list($search_string ,$offset, $resultCount);
		echo json_encode( $tickets); 
		wp_die();
	}
	public function ajax_reset_admin_unread_messages_counter()
	{
		$ticket_id = isset($_POST['ticket_id']) ? $_POST['ticket_id'] : null;
		if($ticket_id != null)
		{
			$this->reset_new_admin_messages_counter($ticket_id);
		}
		wp_die();
	}
	public function ajax_open_new_ticket()
	{
		$this->open_new_ticket(true); 
	}
	public function get_ticket_types()
	{
		return array('order' => __('Order','sunticket'), 'user'=> __('User','sunticket') , 'ppt'=> __('Pay per ticket','sunticket'));
	}
	public function open_new_ticket($is_ajax = true, $subject = '', $message = '', $type = 'order', $order = null, $current_user_id = null, $additional_params = array())
	{
		global $swss_ticket_message_model,$swss_frontend_order_details_page_addon,
		$swss_order_model,$swss_file_model,$swss_email_model, $swss_html_helper, 
		$swss_user_model;
		
		if($is_ajax)
		{
			$subject = isset($_POST['subject']) ? wp_strip_all_tags($_POST['subject']) : null;
			$message = isset($_POST['message']) ? swss_remove_script_tag($_POST['message']) : null;
			$type = isset($_POST['type']) ? $_POST['type'] : null;
			$priority = isset($_POST['priority']) ? $_POST['priority'] : null;
			$related_product = isset($_POST['related_product']) ? $_POST['related_product'] : null;//suncode
			$order = isset($_POST['type_id']) && isset($type) && $type == 'order' ? wc_get_order($_POST['type_id']) : null; //it is the user/order id
			//$user_id = isset($_POST['type_id']) && isset($type) && $type == 'user' ? $_POST['type_id'] : null;
		}
		
		$user_id = isset($current_user_id) ? $current_user_id : get_current_user_id();
		if($user_id && isset($subject) && isset($message) && isset($type) && (($type == 'order' && isset($order)) || ($type != 'order' /*$type == 'user'*/ /* && isset($user_id) */)))
		{
			
			$current_user = $type == 'order' ? $order->get_user() : new WP_User($user_id);
			$args = array('post_status'   => 'publish',
				'post_author'   => $user_id,
				'post_type'     => 'swss_ticket',
			);
			$ticket_id = wp_insert_post( $args );
			
			
			//attrtibutes
			
			$this->set_attribute($ticket_id, 'related_product', $related_product);//suncode
			$this->set_attribute($ticket_id, 'open_status_date', current_time('F j, Y g:i a'));
			$this->set_status($ticket_id, 'open');
			if($type == 'order')
			{
				$this->set_attribute($ticket_id, 'associated_order', SWSS_Order::get_id($order));
				$this->set_attribute($ticket_id, 'associated_user', $order->get_user_id()); //new: this is used to filter ticket by user
			}
			else 
				$this->set_attribute($ticket_id, 'associated_user', $user_id);
			
			$this->set_attribute($ticket_id, 'subject', $subject);
			
			//Type 
			$this->set_attribute($ticket_id,'ticket_type', $type);
			
			//Is an automatic ticket?
			$this->set_attribute($ticket_id,'was_automatically_opened', !$is_ajax);
		
			if($type == 'ppt')
			{
				$this->set_attribute($ticket_id,'number_of_questions_left', $additional_params['questions_number']);
				$this->set_attribute($ticket_id,'ppt_order_id', $additional_params['order_id']);
				$this->set_attribute($ticket_id,'ppt_product_name', $additional_params['product_name']);
				$this->set_attribute($ticket_id,'ppt_product_id', $additional_params['product_id']."_".$additional_params['variation_id']);
			}
			
			//associating order to ticket 
			if($type == 'order')
			{
				$swss_order_model->assign_ticket_id_to_order($ticket_id, SWSS_Order::get_id($order));
				
			}
			else 
				$swss_user_model->assign_ticket_id_to_user($ticket_id, $user_id); 
			
			//Priority 
			if(isset($priority))
				$this->set_priority($ticket_id, $priority);
			
			//Message 
			$message_id = $message != '' ? $swss_ticket_message_model->add_reply($ticket_id, $message, true) : null; 
			$this->update_modified_date($ticket_id);
			
			//Notification
			if($is_ajax)
			{
				//Admin notification
				$overriden_recipients = $type == 'order' || $type == 'user' ? $this->get_topic_recipients($ticket_id, $type) : "";
				$swss_email_model->send_new_ticket_notification_to_admin($ticket_id, $message, $overriden_recipients);
				//User notification
				$swss_email_model->send_new_ticket_notification_to_user($ticket_id, $message, $current_user,$type, $order);
			}
			
			//Attachments
			if(/* isset($_FILES) */ isset($_POST['swss_files']) && is_numeric($message_id))
				$swss_file_model->save_uploaded_files($_POST['swss_files'],$ticket_id, $message_id);
			
			//update new message counter
			$this->update_new_messages_counter($ticket_id, 1);
			
			//Html
			if($is_ajax)
			{
				if($type == 'order')
					// $swss_html_helper->frontend_ticket_area($order, true);
					// $swss_html_helper->frontend_ticket_area($order, true,null,array("ticket_id"=>$ticket_id,"swss_action" => "NewTicket") );//suncode
					$swss_html_helper->frontend_ticket_area($order, true,null,array("ticket_id"=>$ticket_id,"swss_action" => "NewTicketAdded") );//suncode
				else
					// $swss_html_helper->frontend_ticket_area(null, true);
					// $swss_html_helper->frontend_ticket_area(null, true,null,array("ticket_id"=>$ticket_id,"swss_action" => "NewTicket") );//suncode
					$swss_html_helper->frontend_ticket_area(null, true,null,array("ticket_id"=>$ticket_id,"swss_action" => "NewTicketAdded") );//suncode
			}
		}
		else
			_e('Error','sunticket');
		
		if($is_ajax)
			wp_die();
		
		return $ticket_id;
	}
	public function ajax_add_new_message()
	{
		global $swss_ticket_message_model,$swss_frontend_order_details_page_addon,$swss_file_model,$swss_email_model, $swss_html_helper, $swss_option_helper;
		$ticket_id = isset($_POST['ticket_id']) ? $_POST['ticket_id'] : null;
		$message = isset($_POST['message']) ? swss_remove_script_tag($_POST['message']) : null;
		$type = isset($_POST['type']) ? $_POST['type'] : null;
		$order = isset($_POST['type_id']) && isset($type) && $type == 'order' ? wc_get_order($_POST['type_id']) : null;
		$user_id = isset($_POST['type_id']) && isset($type) && $type == 'user' ? $_POST['type_id'] : null;
		$options = $swss_option_helper->get_all_options();
		
		if(isset($ticket_id) && isset($message) && isset($type) && (($type == 'order' && isset($order)) || ($type == 'user' && isset($user_id)) || $type == 'ppt'))
		{
			//Message 
			$message_id = $swss_ticket_message_model->add_reply($ticket_id, $message, true);
			
			//Notification
			$overriden_recipients = $type == 'order' || $type == 'user' ? $this->get_topic_recipients($ticket_id, $type) : "";
			$swss_email_model->send_reply_notification_to_admin($ticket_id, $message, $overriden_recipients);
			
			//Date
			$this->update_modified_date($ticket_id);
			
			//Counter
			$this->update_new_messages_counter($ticket_id, 1);
			
			if(/* isset($_FILES) */ isset($_POST['swss_files']) && is_numeric($message_id))
				$swss_file_model->save_uploaded_files($_POST['swss_files'],$ticket_id, $message_id);
			//PPT
			if($type == 'ppt')
			{
				$number_of_questions_left = $this->ppt_decrease_question_left_counter($ticket_id);
				if($number_of_questions_left == 0)
					$this->set_status($ticket_id, 'closed');
			}
			//Status switch
			if(/* ($options['automatic_tickect_status_switch_from_closed_to_open'] && $this->get_status($ticket_id) == 'closed') || */
				($status_to_switch = $this->get_status_to_which_automatically_swith_in_case_of_reply($ticket_id)) != false)
			{
				$this->set_status($ticket_id, $status_to_switch);
			}
			
			//HTML
			if($type == 'order')
				// $swss_html_helper->frontend_ticket_area($order, true);
				$swss_html_helper->frontend_ticket_area($order, true,null,array("ticket_id"=>$ticket_id,"swss_action" => "ViewTicket") );
			else if($type == 'user')
				$swss_html_helper->frontend_ticket_area(null, true,null,array("ticket_id"=>$ticket_id,"swss_action" => "ViewTicket") );//suncode
			else
				$swss_html_helper->frontend_ticket_area(null, true, true, array('ticket_type' => $type));
		}
		else
			_e('Error','sunticket');
		wp_die();
	}
	public function ajax_delete_message()
	{
		global $swss_ticket_message_model;
		$ticket_message_id = isset($_POST['ticket_message_id']) ? $_POST['ticket_message_id'] : null;
		if(isset($ticket_message_id))
		{
			$swss_ticket_message_model->delete($ticket_message_id);
		}
		wp_die();
	}
	public function ajax_swss_delete_attachment()
	{
		global $swss_file_model, $swss_ticket_message_model;
		$attachment_unique_value = isset($_POST['attachment_unique_value']) ? $_POST['attachment_unique_value'] : null;
		$message_id = isset($_POST['message_id']) ? $_POST['message_id'] : null;
		if(isset($message_id) && isset($attachment_unique_value))
		{
			$swss_ticket_message_model->delete_attachment($message_id, $attachment_unique_value);
		}
		wp_die();
	}
	
	public function get_tickets_list($search_string, $offset, $resultCount)
	{
		global $wpdb;
		$limit_query = isset($offset) && isset($resultCount) ? " LIMIT {$resultCount} OFFSET {$offset}": "";
		 $query_string = "SELECT tickets.ID, ticket_status.meta_value as ticket_status, ticket_open_date.meta_value as ticket_open_date, ticket_type.meta_value as ticket_type
							 FROM {$wpdb->posts} AS tickets 
							 INNER JOIN {$wpdb->postmeta} AS ticket_status ON ticket_status.post_id = tickets.ID 
							 INNER JOIN {$wpdb->postmeta} AS ticket_open_date ON ticket_open_date.post_id = tickets.ID 
							 INNER JOIN {$wpdb->postmeta} AS ticket_type ON ticket_type.post_id = tickets.ID 
							 WHERE tickets.post_type = 'swss_ticket' AND 
							 ticket_status.meta_key = 'swss_status'  AND 
							 ticket_open_date.meta_key = 'swss_open_status_date'  AND 
							 ticket_type.meta_key = 'swss_ticket_type' 
							 ";
		
		if($search_string)
		{
			$offset = null;
			$limit_query = "";
			$query_string .=  " AND ( tickets.ID LIKE '%{$search_string}%'   
									  )";
		}
		$query_string .=  " GROUP BY tickets.ID ORDER BY tickets.ID ASC ".$limit_query ;
		$wpdb->query('SET MAX_JOIN_SIZE=99999999999999999');
		$wpdb->query('SET SQL_BIG_SELECTS=1');
		$results = $wpdb->get_results($query_string );
		
		if(isset($offset) && isset($resultCount))
		{
			$query_string = "SELECT COUNT(*) as tot
							 FROM {$wpdb->posts} AS tickets
							 WHERE tickets.post_type = 'swss_ticket' ";
			$num_order = $wpdb->get_col($query_string);
			$num_order = isset($num_order[0]) ? $num_order[0] : 0;
			$endCount = $offset + $resultCount;
			$morePages = $num_order > $endCount;
			$results = array(
				  "results" => $results,
				  "pagination" => array(
					  "more" => $morePages
				  )
			  );
		}
		else
			$results = array(
				  "results" => $results,
				  "pagination" => array(
					  "more" => $false
				  )
			  );
		
		return $results;
	}
	public function update_ticket_associated_user_on_order_update($order_id, $post )
	{
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
        return;
		// AJAX? Not used here
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) 
				return;
		if($post->post_type != 'shop_order') //ok!
			return;
		
		global $swss_order_model;
		$order = wc_get_order($order_id);
		if(empty($order)){return;}//add by suncode since version 13.1
		$order->get_user_id();
		
		//If the admin assings the order to another users, in this way also the associated user to the ticked is updated
		$orders_ticket = $swss_order_model->get_ticket_ids_by_order_id($order_id);
		foreach((array)$orders_ticket as $ticket_obj)
			$this->set_attribute($ticket_obj->ticket_id, 'associated_user', $order->get_user_id());
			
	}
	public function on_admin_ticket_creation($ticket_id, $post)
	{
		global $swss_user_model;
		/* if($post->post_type != "swss_ticket")
			return; */
		
		swss_var_dump($post->post_type );
		swss_var_dump($ticket_id);
		swss_var_dump(get_current_user_id());
		wp_die();
		//$swss_user_model->assign_ticket_id_to_user($ticket_id, get_current_user_id());
	}
	private function update_modified_date($ticket_id)
	{
		/* global $wpdb;
		$query = "UPDATE {$wpdb->posts}.post_modified 
				  WHERE {$wpdb->posts}.ID = {$ticket_id} ";
				  
		$wpdb->get_results($query); */
		$my_post = array(
			  'ID'           => $ticket_id,
			  'post_modified'   => current_time('mysql')
		  );

		// Update the post into the database
		  wp_update_post( $my_post );
	}
	public function get_creation_date($ticket_id)
	{
		return get_the_date( get_option('date_format'), $ticket_id );
	}
	public function before_delete_ticket($ticket_id)
	{
		global $swss_ticket_message_model,$swss_file_model,$swss_order_model,$swss_user_model;
		$ticket = get_post($ticket_id);
		if ($ticket->post_type != 'swss_ticket')
			return;
		$swss_ticket_message_model->delete_all_ticket_messages($ticket_id);
		
		$swss_file_model->delete_directory($ticket_id);
		
		$swss_order_model->delete_tickets_assigned_to_order($ticket_id);
		$swss_user_model->delete_tickets_assigned_to_user($ticket_id);
		
	}
	public function get_ticket_messages_by_order_id($order_id, $order = 'asc')
	{
		global $swss_order_model, $swss_ticket_message_model;
		$ticket_ids = $swss_order_model->get_ticket_ids_by_order_id($order_id);
		
		$result = array();
		foreach((array)$ticket_ids as $ticket_obj)
			$result[$ticket_obj->ticket_id] =  $swss_ticket_message_model->get_messages_by_ticket_id($ticket_obj->ticket_id);
		
		if(is_array($result) && !empty($result))
		{
			if($order == 'asc')
				ksort($result);
			else
				krsort($result);
		}
			
		return $result;
	}
	public function get_ticket_messages_by_user_id_and_type($user_id, $order = 'asc', $type = 'user')
	{
		global $swss_user_model, $swss_ticket_message_model;
		$ticket_ids = $swss_user_model->get_ticket_ids_by_user_id_and_type($user_id, $type);
		
		/* suncode start  */
		if($ticket_ids){
			if($order == 'asc'){
					krsort($ticket_ids);
			}else{
					ksort($ticket_ids);
			}
		}
		/* suncode end  */
		
		$result = array();
		foreach((array)$ticket_ids as $ticket_obj)
			$result[$ticket_obj->ticket_id] =  $swss_ticket_message_model->get_messages_by_ticket_id($ticket_obj->ticket_id);
		
		if(is_array($result) && !empty($result))
		{
			/* 
			commented by suncode
			if($order == 'asc')
				ksort($result);
			else
				krsort($result); */
		}
		
		return $result;
	}
	//Note: This method returns alwaus the topic content. Use the get_attributes('subject') return the selected topic index ( in case of select topic)
	public function get_subject($ticket_id)
	{
		global $swss_option_helper, $swss_text_helper;
		$ticket_type = $this->get_attributes($ticket_id,'ticket_type');
		$was_automatically_opened = $this->get_attributes($ticket_id,'was_automatically_opened');
		//$subject_type = $swss_option_helper->get_all_options($ticket_type.'_ticket_subject_type');
		$subject_type = $swss_text_helper->get_topic_type($ticket_type.'_ticket_subject_type');
		
		$result = "";
		if($was_automatically_opened)
		{
			return $this->get_attributes( $ticket_id, 'subject', "");
		}
		switch($subject_type)
		{
			case 'text_input': $result = $this->get_attributes( $ticket_id, 'subject', ""); break;
			case 'admin_defined_topics': 
							$topic_id = $this->get_attributes( $ticket_id, 'subject', "");
							//$topics = $swss_option_helper->get_all_options($ticket_type.'_ticket_subject_topics');
							$topics = $swss_text_helper->get_topics_data($ticket_type.'_ticket_subject_topics');;
							$result = isset($topics[$topic_id]) ? $topics[$topic_id]: "";
							break;
		}
		return $result /* $this->get_attributes( $ticket_id, 'subject', "") */;
	}
	public function set_subject($ticket_id, $subject)
	{
		if ( ! add_post_meta( $ticket_id, 'swss_subject',  $subject, true ) )  
			   update_post_meta( $ticket_id, 'swss_subject',  $subject );
	}
	public function get_subject_topics($ticket_id)
	{
		global $swss_option_helper, $swss_text_helper;
		$ticket_type = $this->get_attributes($ticket_id,'ticket_type');
		//$topics = $swss_option_helper->get_all_options($ticket_type.'_ticket_subject_topics');
		$topics = $swss_text_helper->get_topics_data($ticket_type.'_ticket_subject_topics');
		return $topics;
	}
	public function get_subject_topics_by_type($ticket_type)
	{
		global $swss_option_helper, $swss_text_helper;
		//$topics = $swss_option_helper->get_all_options($ticket_type.'_ticket_subject_topics');
		$topics = $swss_text_helper->get_topics_data($ticket_type.'_ticket_subject_topics');
		return $topics;
	}
	public function get_topic_recipients($ticket_id, $topic_type = 'user') //$topic_type = 'user' || 'order'
	{
		if(!isset($ticket_id))
			return "";
		
		global $swss_text_helper;
		$subject_id = $this->get_attributes( $ticket_id, 'subject', "");
		/* $ticket_type = $this->get_attributes($ticket_id,'ticket_type');
		$subject_type = $swss_text_helper->get_topic_type($ticket_type.'_ticket_subject_type'); */
		$topic_data = $swss_text_helper->get_topic_recipents_data();
		return swss_get_value_if_set($topic_data, array("{$topic_type}_ticket_recipients", $subject_id), '');
	}
	public function get_priority($ticket_id)
	{
		$priority = __("N/A", "sunticket");
		$result = wp_get_post_terms($ticket_id, 'swss_ticket_priority' );
		if($result && isset($result[0]))
		{
			$priority = $result[0]->name;
		}
		return $priority;
	}
	public function get_priority_id($ticket_id)
	{
		$priority_id = false;
		$result = wp_get_post_terms($ticket_id, 'swss_ticket_priority' );
		if($result && isset($result[0]))
		{
			$priority_id = $result[0]->term_id;
		}
		
		return $priority_id;
	}
	public function set_priority($ticket_id, $priority_id)
	{
		//$id = is_numeric ($priority_id) ? $priority_id : intval($priority_id);
		//wp_set_post_terms( $ticket_id, array($id), 'swss_ticket_priority' );
		wp_set_object_terms( $ticket_id, $priority_id, 'swss_ticket_priority' ); //slug
	}
	public function get_priority_list()
	{
		$priorities = array();
		$terms = get_terms( array(
			'taxonomy' => 'swss_ticket_priority',
			'hide_empty' => false,
		) );
		 
		//swss_var_dump($terms);
		if($terms)
			foreach($terms as $term)
			{
				$priorities[$term->slug] = $term->name;
				//$priorities[$term->term_id] = $term->name;
			}
		return $priorities;
	}
	
	public function ppt_reset_question_left_counter($ticket_id, $order)
	{
		global $swss_order_model;
		$id = $this->get_attributes($ticket_id,'ppt_product_id', 0);
		if($id == 0)
			return;
		/* swss_write_log("ppt_reset_question_left_counter");
		swss_write_log($ticket_id);
		swss_write_log($order->get_id()); */
		$key = SWSS_Order::$ORDER_PPT_ORDER_KEY_PREFIX.$id;
		$number = $swss_order_model->get_meta($order, $key);
		//swss_write_log($number);
		if(!isset($number) || !is_numeric($number))
			return;
		
		$this->set_attribute($ticket_id,'number_of_questions_left', $number);
		
		//cache
		$this->all_options[$ticket_id]['number_of_questions_left'] = $number;	
	}
	public function ppt_decrease_question_left_counter($ticket_id)
	{
		$number_of_questions_left = $this->get_attributes($ticket_id,'number_of_questions_left', 0);
		$number_of_questions_left = $number_of_questions_left > 0 ? $number_of_questions_left - 1 : $number_of_questions_left;
		//cache
		$this->all_options[$ticket_id]['number_of_questions_left'] = $number_of_questions_left;
		$this->set_attribute($ticket_id,'number_of_questions_left', $number_of_questions_left);
		
		return $number_of_questions_left;
	}
	/* public function get_available_statuses()
	{
		return array('open' => __('Open', 'sunticket'), 'in_progress' => __('In Progress', 'sunticket'), 'closed' => __('Closed', 'sunticket'));
	} */
	
	//Status managment
	public function get_status_data($ticket_id)
	{
		$status_id =  $this->get_attributes( $ticket_id, 'status', "open");
		$field = get_field_object('swss_status');
		//$statuses = $this->get_available_statuses();
		$status_data = $this->get_status_by_id( $status_id , $ticket_id);
		
		return $status_data;
	}
	public function get_status($ticket_id)
	{
		return $this->get_attributes($ticket_id, 'status', "open");
	}
	public function set_status($ticket_id, $default_value = 'open')
	{
		$this->set_attribute($ticket_id, 'status', $default_value);
	}
	public function get_status_to_which_automatically_swith_in_case_of_reply($ticket_id)
	{
		$status_data = $this->get_status_data($ticket_id);
		return $status_data['automatic_switch_to_selected_status'];
	}
	public function get_status_by_id($status_id, $ticket_id = null)
	{
		global $swss_wpml_helper;
		$lang_code = $swss_wpml_helper->get_current_locale();
		$statuses = $this->get_available_statuses();
		
		
		if(!isset($statuses[$status_id]) && isset($ticket_id))
			$this->set_status($ticket_id, 'status', 'open');
		
		return isset($statuses[$status_id]) ? $statuses[$status_id] : $statuses['open'];
	}
	public function get_available_statuses()
	{
		global $swss_wpml_helper;
		$statuses_option = get_option('swss_statuses');
		$statuses = array();
		$default_satuses = array(
			'open' => array('background_color'=> '#16a085', 'text_color' => '#ffffff', 'automatic_switch_to_selected_status' => false, 'label'=>__('Open', 'sunticket')),
			'in_progress' => array('background_color'=> '#e67e22', 'text_color' => '#ffffff', 'automatic_switch_to_selected_status' => false, 'label'=>__('In Progress', 'sunticket')),
			'closed' => array('background_color'=> '#c0392b', 'text_color' => '#ffffff', 'automatic_switch_to_selected_status' => false, 'label'=>__('Closed', 'sunticket'))
		);
		if($statuses_option)
			foreach((array)$statuses_option as $status_id => $status_option)
			{
				$statuses[$status_id] = $status_option;
			}
		
		$lang_list = $swss_wpml_helper->get_langauges_list();
		$curr_lang_code = $swss_wpml_helper->get_current_locale();
		$curr_def_code = $swss_wpml_helper->get_default_locale();
		//Default statuses managment. Format:
		/* 
			 ["open"]=>
			  array(3) {
				["background_color"]=>
				string(7) "#e67e22"
				["text_color"]=>
				string(7) "#000000"
				["label"]=>
				array(2) {
				  ["it_IT"]=>
				  string(4) "Open"
				  ["en_US"]=>
				  string(4) "Open"
				}
			  }
		  */
		foreach($default_satuses as $default_code => $default_status)
		{
			//Set defaults
			if(!isset($statuses[$default_code]))
			{
				$statuses[$default_code] = array('background_color'=> $default_status['background_color'], 
												  'text_color' => $default_status['text_color'], 
												  'automatic_switch_to_selected_status' => $default_status['automatic_switch_to_selected_status'],
												  'label'=>array());
				
			}
			if($lang_list !== false)
			{
				foreach($lang_list as $lang)
				{
					if(!isset($statuses[$default_code]['label'][$lang['default_locale']]))
						$statuses[$default_code]['label'][$lang['default_locale']] = $default_status['label'];
				}
			}
			else if(!isset($statuses[$default_code]['label'][$swss_wpml_helper->get_default_locale()]))
				$statuses[$default_code]['label'][$swss_wpml_helper->get_default_locale()] = $default_status['label'];
			
			$statuses[$default_code]['current_lang'] = $curr_lang_code;
			$statuses[$default_code]['def_lang'] = $curr_def_code;
			$statuses[$default_code]['is_custom'] = false; //redundant
			$statuses[$default_code]['id'] = $default_code;
			$statuses[$default_code]['automatic_switch_to_selected_status'] = swss_get_value_if_set($statuses, array($default_code, 'automatic_switch_to_selected_status'), null) ? $statuses[$default_code]['automatic_switch_to_selected_status'] : $default_status['automatic_switch_to_selected_status'];
			$statuses[$default_code]['background_color'] =  strpos($statuses[$default_code]['background_color'], '#') === false ? "#".$statuses[$default_code]['background_color'] :  $statuses[$default_code]['background_color'];
			$statuses[$default_code]['text_color'] =  strpos($statuses[$default_code]['text_color'], '#') === false ? "#".$statuses[$default_code]['text_color'] :  $statuses[$default_code]['text_color'];
		}
		
		//Custom statuses languages managment (if multilanguage): in case a translation does not exists an empty string is setted
		if($statuses)
			foreach((array)$statuses as $status_id => $status_option)
			{
				if(array_key_exists($status_id, $default_satuses))
					continue;
				
				$statuses[$status_id]['current_lang'] = $curr_lang_code;
				$statuses[$status_id]['def_lang'] = $curr_def_code;
				$statuses[$status_id]['is_custom'] = true; //redundant
				$statuses[$status_id]['background_color'] =  strpos($statuses[$status_id]['background_color'], '#') === false ? "#".$statuses[$status_id]['background_color'] :  $statuses[$status_id]['background_color'];
				$statuses[$status_id]['text_color'] =  strpos($statuses[$status_id]['text_color'], '#') === false ? "#".$statuses[$status_id]['text_color'] :  $statuses[$status_id]['text_color'];
				$statuses[$status_id]['automatic_switch_to_selected_status'] =  swss_get_value_if_set($statuses, array($status_id, 'automatic_switch_to_selected_status'), false) ? $statuses[$status_id]['automatic_switch_to_selected_status']  : false;
				
				if($lang_list !== false)
					{
						foreach($lang_list as $lang)
							if(!isset($statuses[$status_id]['label'][$lang['default_locale']]))
								$statuses[$status_id]['label'][$lang['default_locale']] = "";
					}
					else
						if(!isset($statuses[$status_id]['label'][$swss_wpml_helper->get_default_locale()]))
							$statuses[$status_id]['label'][$swss_wpml_helper->get_default_locale()] = "";
			}
		
		return $statuses;
		
	}
	function save_statuses($statuses)
	{
		update_option('swss_statuses', $statuses);
	}
	//End status managment
	
	
	//Note: get_attributes('subject'), in case of select topic, return the selected topic index
	public function get_attributes($ticket_id, $option_name = null, $default = null)
	{
		add_filter('acf/settings/current_language',  array(&$this, 'cl_acf_set_language'), 100);
			
//print_r($ticket_id) ;
		if(is_array($ticket_id)){return;} //edit by suncode
		if(!isset($this->all_options[$ticket_id])) //edit by suncode
		//if($this->all_options && !isset($this->all_options[$ticket_id])) 
		{
			$this->all_options[$ticket_id] = array();
			//Type
			$this->all_options[$ticket_id]['ticket_type'] = get_field('swss_ticket_type', $ticket_id); 
			$this->all_options[$ticket_id]['ticket_type'] = $this->all_options[$ticket_id]['ticket_type'] != null ? $this->all_options[$ticket_id]['ticket_type'] : 'order'; 
			
			$this->all_options[$ticket_id]['was_automatically_opened'] = get_field('swss_was_automatically_opened', $ticket_id); 
			$this->all_options[$ticket_id]['was_automatically_opened'] = $this->all_options[$ticket_id]['was_automatically_opened'] != null ? $this->all_options[$ticket_id]['was_automatically_opened'] : false; 
			
			$this->all_options[$ticket_id]['associated_order'] = get_field('swss_associated_order', $ticket_id); 
			$this->all_options[$ticket_id]['associated_order'] = $this->all_options[$ticket_id]['associated_order'] != null ? $this->all_options[$ticket_id]['associated_order'] : null; 
			
			$this->all_options[$ticket_id]['associated_user'] = @get_field('swss_associated_user', $ticket_id); 
			$this->all_options[$ticket_id]['associated_user'] = $this->all_options[$ticket_id]['associated_user'] != null ? $this->all_options[$ticket_id]['associated_user'] : null; 
			$this->all_options[$ticket_id]['associated_user'] = is_array($this->all_options[$ticket_id]['associated_user']) ? $this->all_options[$ticket_id]['associated_user']['ID'] : $this->all_options[$ticket_id]['associated_user'];
			
			
			//Status
			$this->all_options[$ticket_id]['status'] = get_field('swss_status', $ticket_id); 
			$this->all_options[$ticket_id]['status'] = $this->all_options[$ticket_id]['status'] != null ? $this->all_options[$ticket_id]['status'] : "open"; 
			
			//Related Product by suncode
			$this->all_options[$ticket_id]['related_product'] = get_field('swss_related_product', $ticket_id); 
			$this->all_options[$ticket_id]['related_product'] = $this->all_options[$ticket_id]['related_product'] != null ? $this->all_options[$ticket_id]['related_product'] : ""; 
			
			/* $this->all_options[$ticket_id]['subject'] = get_field('swss_subject', $ticket_id); */
			$this->all_options[$ticket_id]['subject'] = get_post_meta($ticket_id, 'swss_subject', true ); 
			$this->all_options[$ticket_id]['subject'] = isset($this->all_options[$ticket_id]['subject']) ? $this->all_options[$ticket_id]['subject'] : "";  
			
			$this->all_options[$ticket_id]['open_status_date'] = get_field('swss_open_status_date', $ticket_id);  //F j, Y g:i a
			$this->all_options[$ticket_id]['open_status_date'] = $this->all_options[$ticket_id]['open_status_date'] != null ? $this->all_options[$ticket_id]['open_status_date'] : ""; 
			
			$this->all_options[$ticket_id]['closed_status_date'] = get_field('swss_closed_status_date', $ticket_id);  //F j, Y g:i a
			$this->all_options[$ticket_id]['closed_status_date'] = $this->all_options[$ticket_id]['closed_status_date'] != null ? $this->all_options[$ticket_id]['closed_status_date'] : ""; 
			
			$this->all_options[$ticket_id]['notification_recipients_override'] = get_field('wcst_notification_recipients_override', $ticket_id);  
			$this->all_options[$ticket_id]['notification_recipients_override'] = $this->all_options[$ticket_id]['notification_recipients_override'] != null ? $this->all_options[$ticket_id]['notification_recipients_override'] : ""; 
			
			$this->all_options[$ticket_id]['number_of_questions_left'] = get_field('swss_number_of_questions_left', $ticket_id);  
			$this->all_options[$ticket_id]['number_of_questions_left'] = $this->all_options[$ticket_id]['number_of_questions_left'] != null ? $this->all_options[$ticket_id]['number_of_questions_left'] : ""; 
			
			$this->all_options[$ticket_id]['ppt_product_name'] = get_field('swss_ppt_product_name', $ticket_id);  
			$this->all_options[$ticket_id]['ppt_product_name'] = $this->all_options[$ticket_id]['ppt_product_name'] != null ? $this->all_options[$ticket_id]['ppt_product_name'] : ""; 
			
			$this->all_options[$ticket_id]['ppt_product_id'] = get_field('swss_ppt_product_id', $ticket_id);  
			$this->all_options[$ticket_id]['ppt_product_id'] = $this->all_options[$ticket_id]['ppt_product_id'] != null ? $this->all_options[$ticket_id]['ppt_product_id'] : "";
			
			$this->all_options[$ticket_id]['ppt_order_id'] = get_field('swss_ppt_order_id', $ticket_id);  
			$this->all_options[$ticket_id]['ppt_order_id'] = $this->all_options[$ticket_id]['ppt_order_id'] != null ? $this->all_options[$ticket_id]['ppt_order_id'] : 0; 
		}
		
		remove_filter('acf/settings/current_language', array(&$this,'cl_acf_set_language'), 100);
		
		if(isset($option_name))
			return isset($this->all_options[$ticket_id][$option_name]) ? $this->all_options[$ticket_id][$option_name] : $default ;
		
		return $this->all_options[$ticket_id];
	}
	function set_attribute($ticket_id, $option_name, $value)
	{
		add_filter('acf/settings/current_language',  array(&$this, 'cl_acf_set_language'), 100);
		
		//Update
		update_field('swss_'.$option_name, $value, $ticket_id); 
		
		//special open/close data fields
		if(	$option_name == 'open_status_date')
		{
			$this->set_special_standard_date_field_format('open_status_date', $ticket_id, $value);  
		}
		elseif ( $option_name =='closed_status_date')
		{
			$this->set_special_standard_date_field_format('closed_status_date', $ticket_id, $value); 
		}
		//Cache
		if(isset($this->all_options[$ticket_id]))
			$this->all_options[$ticket_id][$option_name] = $value;
		remove_filter('acf/settings/current_language', array(&$this,'cl_acf_set_language'), 100);
	}
	//open_status_date || closed_status_date
	function set_special_standard_date_field_format($option_name, $ticket_id, $value)
	{
		$myDateTime = DateTime::createFromFormat('F j, Y g:i a', $value);
		if(!is_object($myDateTime))
			return;
		$newDateString = $myDateTime->format('Y-m-d H:i:s');
		update_post_meta($ticket_id, 'swss_'.$option_name.'_standard_format', $newDateString); 
	}
	
	function cl_acf_set_language() 
	{
	  return acf_get_setting('default_language');
	}
	public function remove_manager_user_assigned_to_any_ticket($user_ids)
	{
		$user_ids = !is_array($user_ids) ? array($user_ids) : $user_ids;
		
		if(empty($user_ids))
			return;
		
		global $wpdb;
		$query_string = "DELETE  
						  FROM {$wpdb->postmeta} 
						  WHERE meta_key = 'swss_manager_user_id' AND meta_value IN ('".implode("','",$user_ids)."')"; 
			
		$wpdb->query('SET MAX_JOIN_SIZE=99999999999999999');
		$wpdb->query('SET SQL_BIG_SELECTS=1');
		$wpdb->get_results($query_string);
	}
	public function remove_all_manager_users_assigned_to_tickets($ticket_ids)
	{
		$ticket_ids = !is_array($ticket_ids) ? array($ticket_ids) : $ticket_ids;
		
		if(empty($ticket_ids))
			return;
		
		foreach($ticket_ids as $ticket_id)
			delete_post_meta($ticket_id, 'swss_manager_user_id');
	}
	public function assign_manager_users_to_tickets($ticket_ids,$user_ids)
	{
		$ticket_ids = !is_array($ticket_ids) ? array($ticket_ids) : $ticket_ids;
		$user_ids = !is_array($user_ids) ? array($user_ids) : $user_ids;
		
		if(empty($ticket_ids) || empty($user_ids))
			return;
		
		foreach($ticket_ids as $ticket_id)
			foreach($user_ids as $user_id)
				add_post_meta($ticket_id, 'swss_manager_user_id', $user_id, false);
	}
	public function get_manager_user_ids($ticket_id)
	{
		if(!isset($ticket_id))
			return array();
		
		$result = get_post_meta($ticket_id, 'swss_manager_user_id');
		
		/* Format
		array(2) {
		  [0]=>
		  string(4) "7969"
		  [1]=>
		  string(1) "1"
		}
		*/
		return $result ? $result : array();
	}
	public function get_tickets_managed_by_user($user_id)
	{
		if(!isset($user_id))
			return array();
		
		
		global $wpdb;
		$query_string = " SELECT  post_id AS ticket_id
						  FROM {$wpdb->postmeta} 
						  WHERE meta_key = 'swss_manager_user_id' AND meta_value = {$user_id} "; 
		 
		$wpdb->query('SET MAX_JOIN_SIZE=99999999999999999');
		$wpdb->query('SET SQL_BIG_SELECTS=1');
		$result = $wpdb->get_results($query_string, ARRAY_A );
		
		/* 
		array(3) {
		  [0]=>
		  array(1) {
			["ticket_id"]=>
			string(4) "24"
		  }
		  [1]=>
		  array(1) {
			["ticket_id"]=>
			string(4) "22"
		  }
		  [2]=>
		  array(1) {
			["ticket_id"]=>
			string(4) "1"
		  }
		}
		*/
		
		return $result ? $result : array();
	}
}
?>