<?php
// Elementor header start 
$contentElementor = "";
$gen_page_id = isset($args['header_page_id']) ? $args['header_page_id'] : '';

if (class_exists("\\Elementor\\Plugin")) {
    $plugin = \Elementor\Plugin::instance();
    
    // Check if the page is built with Elementor
    if (\Elementor\Plugin::$instance->db->is_built_with_elementor($gen_page_id)) {
        // Get the document
        $document = $plugin->documents->get($gen_page_id);
        
        // Enqueue styles and scripts the proper way
        $plugin->frontend->enqueue_styles();
        $plugin->frontend->enqueue_scripts();
        
        // Get the content
        $contentElementor = $plugin->frontend->get_builder_content_for_display($gen_page_id, true); // Set to true to ensure CSS is printed
    } else {
        $contentElementor = get_the_content(null, false, $gen_page_id);
    }
} else {
    $contentElementor = '<!-- Elementor not found -->';
}
?>
<header class="site-header studi_el_head">
    <?php echo $contentElementor; ?>
    <?php 
    $search_placeholder_text = '';
    if ( class_exists( 'Redux') ) {$search_placeholder_text = codebean_option('search_placeholder_text');}
    $placeholder = !empty($search_placeholder_text) ? esc_attr($search_placeholder_text) : esc_attr__('Search for courses, products, teachers, posts and ...', 'studiare');
    ?>
    <div class="site-search-wrapper">
                <form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <input type="search" class="search-input" placeholder="<?php echo $placeholder; ?>" value="<?php echo esc_attr(get_search_query()); ?>" name="s">
                    <button type="submit" class="submit">
                        <?php get_template_part( 'assets/images/search-icon.svg' ); ?>
                    </button>
                </form>
            </div>
</header>
<?php
// Elementor header end
?>