<?php
namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Sc_Search extends Widget_Base {

    public function get_name() {
        return 'sc-search';
    }

    public function get_title() {
        return __('Header Search', 'studiare');
    }

    public function get_icon() {
        return 'sc eicon-search';
    }

    public function get_categories() {
        return ['studiare'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Search Settings', 'studiare'),
            ]
        );

        $this->add_control(
            'search_note',
            [
                'label' => __('Note', 'studiare'),
                'type' => \Elementor\Controls_Manager::RAW_HTML,
                'raw' => __('This widget displays a customizable search form.', 'studiare'),
                'content_classes' => 'elementor-descriptor',
            ]
        );

        $this->add_control(
            'show_search_icon',
            [
                'label' => __('Show Search Icon', 'studiare'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'studiare'),
                'label_off' => __('No', 'studiare'),
                'default' => 'yes',
                'description' => __('Toggle to show or hide the search icon.', 'studiare'),
            ]
        );

        $this->add_control(
            'search_icon_style',
            [
                'label' => __('Search Icon Style', 'studiare'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'svg',
                'options' => [
                    'svg' => __('SVG Icon', 'studiare'),
                    'font' => __('Font Icon', 'studiare'),
                ],
                'condition' => [
                    'show_search_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'search_svg_icon',
            [
                'label' => __('SVG Code for Search Icon', 'studiare'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 128 128" style="enable-background:new 0 0 128 128;transform: rotateY(180deg);" xml:space="preserve"> <g> <path d="M82.348,77.986l19.25,19.25l-5.264,5.264l-19.25-21.055c-5.715,4.714-12.133,7.068-19.25,7.068 c-8.624,0-16.017-3.083-22.183-9.249s-9.249-13.61-9.249-22.333s3.083-16.141,9.249-22.258C41.817,28.56,49.21,25.5,57.834,25.5 c8.723,0,16.167,3.06,22.333,9.174c6.166,6.117,9.249,13.535,9.249,22.258C89.416,65.153,87.059,72.173,82.348,77.986z M40.539,74.302c4.812,4.764,10.577,7.144,17.295,7.144c6.716,0,12.482-2.38,17.295-7.144c4.812-4.761,7.219-10.551,7.219-17.37 c0-6.716-2.406-12.457-7.219-17.22c-4.812-4.761-10.579-7.144-17.295-7.144c-6.718,0-12.482,2.383-17.295,7.144 c-4.812,4.763-7.219,10.504-7.219,17.22C33.32,63.751,35.727,69.541,40.539,74.302z"/> </g> </svg>',
                'condition' => [
                    'search_icon_style' => 'svg',
                    'show_search_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'search_font_icon',
            [
                'label' => __('Font Icon for Search', 'studiare'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fal fa-search',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'search_icon_style' => 'font',
                    'show_search_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'placeholder_text',
            [
                'label' => __('Placeholder Text', 'studiare'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Search for courses, products, teachers, posts and ...', 'studiare'),
                'placeholder' => __('Enter custom placeholder text', 'studiare'),
            ]
        );

        $this->add_control(
            'enable_ajax_search',
            [
                'label' => __('Enable AJAX Search', 'studiare'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'studiare'),
                'label_off' => __('No', 'studiare'),
                'default' => 'no',
                'description' => __('Requires a compatible AJAX search plugin (e.g., WooCommerce AJAX Search).', 'studiare'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => __('Style', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Icon Size', 'studiare'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .search-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .search-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_search_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Icon Color', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#6c8d9d',
                'selectors' => [
                    '{{WRAPPER}} .search-form-opener' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_search_icon' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'form_width',
            [
                'label' => __('Form Width', 'studiare'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vw'],
                'range' => [
                    'px' => [
                        'min' => 200,
                        'max' => 600,
                    ],
                    '%' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 300,
                ],
                'selectors' => [
                    '{{WRAPPER}} .site-search-wrapper' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'input_background',
            [
                'label' => __('Input Background', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .search-input' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'input_text_color',
            [
                'label' => __('Input Text Color', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .search-input' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $placeholder = esc_attr($settings['placeholder_text']);
        $enable_ajax_search = $settings['enable_ajax_search'] === 'yes';
        ?>
        <div class="studi_el_search top-bar-search top-bar-search-main-header">
            <?php if ($settings['show_search_icon'] === 'yes') : ?>
                <a href="#" class="search-form-opener">
                    <span class="search-icon">
                        <?php if ($settings['search_icon_style'] === 'svg') : ?>
                            <?php echo $settings['search_svg_icon']; ?>
                        <?php else : ?>
                            <?php \Elementor\Icons_Manager::render_icon($settings['search_font_icon'], ['aria-hidden' => 'true']); ?>
                        <?php endif; ?>
                    </span>
                </a>
            <?php endif; ?>
<!--
            <?php if ($enable_ajax_search && shortcode_exists('wcas-search-form')) : ?>
                <div class="site-search-wrapper sc-ajax-search full-width-search">
                    <?php echo do_shortcode('[wcas-search-form]'); ?>
                </div>
            <?php else : ?>
                <div class="site-search-wrapper full-width-search">
                    <form method="get" class="search-form" action="<?php echo esc_url(home_url('/')); ?>">
                        <input type="search" class="search-input" placeholder="<?php echo $placeholder; ?>" value="<?php echo esc_attr(get_search_query()); ?>" name="s">
                        <button type="submit" class="submit">
                            <?php if ($settings['search_icon_style'] === 'svg') : ?>
                                <?php echo $settings['search_svg_icon']; ?>
                            <?php else : ?>
                                <?php \Elementor\Icons_Manager::render_icon($settings['search_font_icon'], ['aria-hidden' => 'true']); ?>
                            <?php endif; ?>
                        </button>
                    </form>
                </div>
            <?php endif; ?>
-->            
        </div>
        <style>
            .elementor-widget-sc-search.scs_el_active { width: 100%; position: absolute; }
            .studi_el_head .site-search-wrapper { transform: translateY(-60%) !important; background: #fff; }
        </style>
<!--        <script>
            jQuery(document).ready(function(){
                var el = jQuery(".studi_el_search .search-form-opener");
                el.click(function(){
                    jQuery(".elementor-widget-sc-search").toggleClass("scs_el_active");
                });
                jQuery(document).on('click', '#stHsearchCloser', function(){
    jQuery(".elementor-widget-sc-search").toggleClass("scs_el_active");
});
            });
        </script> -->
        <?php
    }

    protected function content_template() {
        ?>
        <div class="top-bar-search top-bar-search-main-header">
            <# if ( settings.show_search_icon === 'yes' ) { #>
                <a href="#" class="search-form-opener">
                    <span class="search-icon">
                        <# if ( settings.search_icon_style === 'svg' ) { #>
                            {{{ settings.search_svg_icon }}}
                        <# } else { #>
                            <i class="{{ settings.search_font_icon.value }}" aria-hidden="true"></i>
                        <# } #>
                    </span>
                </a>
            <# } #>

            <div class="site-search-wrapper full-width-search">
                <form method="get" class="search-form" action="/">
                    <input type="search" class="search-input" placeholder="{{ settings.placeholder_text }}" value="" name="s">
                    <button type="submit" class="submit">
                        <# if ( settings.search_icon_style === 'svg' ) { #>
                            {{{ settings.search_svg_icon }}}
                        <# } else { #>
                            <i class="{{ settings.search_font_icon.value }}" aria-hidden="true"></i>
                        <# } #>
                    </button>
                </form>
            </div>
        </div>
        <?php
    }
}