<?php
# Styling
Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'Style', 'studiare' ),
	'id' => 'colors',
	'icon' => 'fal fa-highlighter',
) );


Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'Style', 'studiare' ),
	'id' => 'light_mode',
	'subsection' => true,
	'icon' => 'fal fa-highlighter',
	'fields' => array(
	    array(
			'id'       => 'siteb_backgrount_color',
			'type'     => 'background',
			'title'    => esc_html__( 'Site Background', 'studiare' ),
			'output'   => array('.main-page-content.default-margin, body, .wrap, .main-page-content'),
			'default'  => array(
				'background-color' => '#f8f9fa'
			)
		),
		array(
			'id'       => 'primary_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Primary Color', 'studiare' ),
			'validate' => 'color',
			'transparent' => false,
			'output'   => $studiare_selectors['primary_color'],
			'default'  => '#26a69a', //'#f9a134'
			'output_variables' => true,
		),
		array(
			'id'       => 'secondary_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Secondary Color', 'studiare' ),
			'validate' => 'color',
			'transparent' => false,
			'output'   => $studiare_selectors['secondary_color'],
			'default'  => '#4ecdc4', //'#1e83f0'
			'output_variables' => true,
		),
		array(
			'id'       => 'eshare_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Tooltips Color', 'studiare' ),
			'validate' => 'color',
			'transparent' => false,
			'output'   => $studiare_selectors['eshare_color'],
			'default'  => '#494949' //'#484848'
		)
	)
) );
#Dark_Mode
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'Dark Mode', 'studiare' ),
    'id'                => 'sc_darkmode',
    'subsection' => true,
    'icon' => 'fal fa-moon',
    'fields'            => array(
        array(
            'id'        => 'sc_darkmode_ready',
            'type'      => 'switch',
            'title'     => esc_html__( 'Dark Mode', 'studiare' ),
            'subtitle'  => esc_html__( 'By this option you can enable or disable dark mode functionality.', 'studiare' ),
            'default'   => false,
        ),
        array(
            'id'        => 'sc_darkmode_always',
            'type'      => 'switch',
            'title'     => esc_html__( 'Always Dark Mode', 'studiare' ),
            'subtitle'  => esc_html__( 'If enabled, the site will always stay in dark mode regardless of user preference. If disabled, users can switch between light and dark modes using the toggle.', 'studiare' ),
            'default'   => true,
            'required'  => array('sc_darkmode_ready', '=', true),
        ),
        array(
            'id'       => 'dark_mode_default_type',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Default Dark Mode Type', 'studiare' ),
            'subtitle' => esc_html__( 'Choose the default mode for the site when "Always Dark Mode" is disabled. Users can still toggle between light and dark modes on the frontend.', 'studiare' ),
            'options'  => array(
                'light'   => esc_html__( 'Light', 'studiare' ),
                'dark'    => esc_html__( 'Dark', 'studiare' ),
                'system'  => esc_html__( 'System (Browser Preference)', 'studiare' ),
            ),
            'default'  => 'dark',
            'required' => array('sc_darkmode_always', '=', false),
        ),
        array(
            'id'       => 'show_darkmode_icon_in_header',
            'type'     => 'switch',
            'title'    => esc_html__('Display the Dark Mode icon on the header', 'studiare'),
            'default'  => true,
            'required'  => array('sc_darkmode_ready', '=', true),
        ),
        array(
			'id'       => 'dark_siteb_backgrount_color',
			'type'     => 'background',
			'title'    => esc_html__( 'Dark Site Background', 'studiare' ),
			'output'   => array('body.scdarkcolors .main-page-content.default-margin, body.scdarkcolors, body.scdarkcolors .wrap, body.scdarkcolors .main-page-content'),
			'default'  => array(
				'background-color' => '#020134'
			),
			'required'  => array('sc_darkmode_ready', '=', true),
		),
        array(
            'id'       => 'dark_primary_color',
            'type'     => 'color',
            'title'    => esc_html__( 'Primary Dark Color', 'studiare' ),
            'validate' => 'color',
            'transparent' => false,
            'required'  => array('sc_darkmode_ready', '=', true),
            'output_variables' => true,
            'default'  => '#150550' 
        ),
        array(
            'id'       => 'dark_secondary_color',
            'type'     => 'color',
            'title'    => esc_html__( 'Secondary Dark Color', 'studiare' ),
            'validate' => 'color',
            'transparent' => false,
            'required'  => array('sc_darkmode_ready', '=', true),
            'output_variables' => true,
            'default'  => '#020134' 
        ),
        array(
            'id'       => 'dark_light_color',
            'type'     => 'color',
            'title'    => esc_html__( 'Text Light Color for Dark Mode', 'studiare' ),
            'validate' => 'color',
            'transparent' => false,
            'required'  => array('sc_darkmode_ready', '=', true),
            'output_variables' => true,
            'default'  => '#fff' 
        ),
        array(
            'id'       => 'dark_headings_color',
            'type'     => 'color',
            'title'    => esc_html__( 'Dark Headings Color', 'studiare' ),
            'validate' => 'color',
            'transparent' => false,
            'required'  => array('sc_darkmode_ready', '=', true),
            'output'   => array('body.scdarkcolors h1, body.scdarkcolors .h1, body.scdarkcolors h2, body.scdarkcolors .h2, body.scdarkcolors h3, body.scdarkcolors .h3, body.scdarkcolors h4, body.scdarkcolors .h4, body.scdarkcolors h5, body.scdarkcolors .h5, body.scdarkcolors h6, body.scdarkcolors .h6'),
            'default'  => '#fff' 
        ),
        array(
            'id'       => 'dark_links_color',
            'type'     => 'color',
            'title'    => esc_html__( 'Dark Links Color', 'studiare' ),
            'validate' => 'color',
            'transparent' => false,
            'required'  => array('sc_darkmode_ready', '=', true),
            'output'   => array('body.scdarkcolors a:not(.studiare-navigation ul.menu > li > a, .studiare-navigation .menu > ul > li > a)'),
            'default'  => '#fff' 
        ),
    ),  
) );