<?php
# Teachers Settings Subsection
Redux::setSection( $opt_name, array(
	'title'      => esc_html__( 'Teachers', 'studiare' ),
	'id'         => 'teachers_settings',
	'subsection' => false,
	'icon'       => 'fal fa-users-cog',
	'fields'     => array(
		// Field for number of teachers per page
		array(
			'id'       => 'teachers_per_page',
			'type'     => 'text',
			'title'    => esc_html__( 'Teachers Per Page', 'studiare' ),
			'subtitle' => esc_html__( 'Set the number of teachers to display per page.', 'studiare' ),
			'default'  => '6',
			'validate' => 'numeric', // Ensures only numbers are entered
		),
		
		// Field for selecting custom archive page
		array(
			'id'       => 'teachers_archive_page',
			'type'     => 'select',
			'data'     => 'posts',
			'args'     => array( 
				'post_type'   => array( 'page' ), 
				'numberposts' => -1,
				'post_status' => array( 'publish', 'private' )
			),
			'title'    => esc_html__( 'Teachers Archive Page', 'studiare' ),
			'desc'     => esc_html__( 'If this field is left empty, the default archive page will be displayed.', 'studiare' ),
			'default'  => '',
			'select2'  => array( 'allowClear' => true ), // Allows clearing the selection
		),
		
		// Switch for dynamic title and slug
		array(
			'id'       => 'enable_dynamic_teacher_name_slug',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable Dynamic Title and Slug', 'studiare' ),
			'subtitle' => esc_html__( 'If enabled, customize the archive title and slug dynamically.', 'studiare' ),
			'default'  => false,
		),
		
		// Field for custom archive title (shown if switch is enabled and no page is selected)
		array(
			'id'       => 'teachers_custom_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Custom Archive Title', 'studiare' ),
			'subtitle' => esc_html__( 'Set a custom title for the teachers archive.', 'studiare' ),
			'default'  => 'Teachers',
			'required' => array( 
				array( 'enable_dynamic_teacher_name_slug', '=', true ),
				array( 'teachers_archive_page', '=', '' )
			), // Show only if switch is on and no archive page is selected
		),
		
		// Field for custom archive slug (shown if switch is enabled and no page is selected)
		array(
			'id'       => 'teachers_custom_slug',
			'type'     => 'text',
			'title'    => esc_html__( 'Custom Archive Slug', 'studiare' ),
			'subtitle' => esc_html__( 'Set a custom slug for the teachers archive.', 'studiare' ),
			'default'  => 'teacher',
			'required' => array( 
				array( 'enable_dynamic_teacher_name_slug', '=', true ),
				array( 'teachers_archive_page', '=', '' )
			), // Show only if switch is on and no archive page is selected
		),
		// Enable Instructor Role
        // array(
        //     'id'       => 'enable_instructor_role',
        //     'type'     => 'switch',
        //     'title'    => esc_html__( 'Enable Instructor Role', 'studiare' ),
        //     'subtitle' => esc_html__( 'Enable or disable the custom instructor role for teachers.', 'studiare' ),
        //     'default'  => false,
        // ),
        
        // // Instructor Role Capabilities
        // array(
        //     'id'       => 'instructor_role_capabilities',
        //     'type'     => 'checkbox',
        //     'title'    => esc_html__( 'Instructor Role Capabilities', 'studiare' ),
        //     'subtitle' => esc_html__( 'Select capabilities for the instructor role.', 'studiare' ),
        //     'options'  => array(
        //         'read'                   => 'Read',
        //         'edit_posts'            => 'Edit Posts',
        //         'edit_published_posts'  => 'Edit Published Posts',
        //         'publish_posts'         => 'Publish Posts',
        //         'upload_files'          => 'Upload Files',
        //         'delete_posts'          => 'Delete Posts',
        //     ),
        //     'default'  => array(),
        //     'required' => array( 'enable_instructor_role', '=', true ),
        // ),
	)
) );