<?php
/**
 * Codebean WooCommerce functions, actions and filters
 */

function studi_theme_quantity_buttons() {
    if (!is_plugin_active('woocommerce/woocommerce.php')) return;
    if (!is_product() && !is_cart()) return;
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            // Add buttons dynamically
            $('.quantity input[type="number"]').each(function() {
                var $quantityInput = $(this);
                // Skip if buttons already added
                if ($quantityInput.data('buttons-added')) return;
                $quantityInput.data('buttons-added', true);

                // Create buttons
                var $decrementButton = $('<button type="button" class="quantity-decrement">-</button>');
                var $incrementButton = $('<button type="button" class="quantity-increment">+</button>');
                $quantityInput.before($decrementButton).after($incrementButton);

                // Function to check button status
                function checkButtonStatus() {
                    var val = parseFloat($quantityInput.val()) || 0;
                    var max = parseFloat($quantityInput.attr('max')) || Infinity;
                    var min = parseFloat($quantityInput.attr('min')) || 0;
                    $incrementButton.prop('disabled', val >= max);
                    $decrementButton.prop('disabled', val <= min);
                }

                // Event listeners
                $decrementButton.add($incrementButton).on('click', function(e) {
                    e.preventDefault();
                    var val = parseFloat($quantityInput.val()) || 0;
                    var max = parseFloat($quantityInput.attr('max')) || Infinity;
                    var min = parseFloat($quantityInput.attr('min')) || 0;
                    var step = parseFloat($quantityInput.attr('step')) || 1;

                    if ($(this).hasClass('quantity-increment')) {
                        if (val < max) {
                            $quantityInput.val(val + step);
                        }
                    } else {
                        if (val > min) {
                            $quantityInput.val(val - step);
                        }
                    }
                    $quantityInput.trigger('change');
                    checkButtonStatus();
                    $('button[name="update_cart"]').prop('disabled', false);
                });

                // Initial check
                checkButtonStatus();
            });

            // Re-run after WooCommerce AJAX updates
            $(document.body).on('updated_cart_totals updated_checkout', function() {
                $('.quantity input[type="number"]').each(function() {
                    var $quantityInput = $(this);
                    if ($quantityInput.data('buttons-added')) return;
                    $quantityInput.data('buttons-added', true);

                    var $decrementButton = $('<button type="button" class="quantity-decrement">-</button>');
                    var $incrementButton = $('<button type="button" class="quantity-increment">+</button>');
                    $quantityInput.before($decrementButton).after($incrementButton);

                    function checkButtonStatus() {
                        var val = parseFloat($quantityInput.val()) || 0;
                        var max = parseFloat($quantityInput.attr('max')) || Infinity;
                        var min = parseFloat($quantityInput.attr('min')) || 0;
                        $incrementButton.prop('disabled', val >= max);
                        $decrementButton.prop('disabled', val <= min);
                    }

                    $decrementButton.add($incrementButton).on('click', function(e) {
                        e.preventDefault();
                        var val = parseFloat($quantityInput.val()) || 0;
                        var max = parseFloat($quantityInput.attr('max')) || Infinity;
                        var min = parseFloat($quantityInput.attr('min')) || 0;
                        var step = parseFloat($quantityInput.attr('step')) || 1;

                        if ($(this).hasClass('quantity-increment')) {
                            if (val < max) {
                                $quantityInput.val(val + step);
                            }
                        } else {
                            if (val > min) {
                                $quantityInput.val(val - step);
                            }
                        }
                        $quantityInput.trigger('change');
                        checkButtonStatus();
                        $('button[name="update_cart"]').prop('disabled', false);
                    });

                    checkButtonStatus();
                });
            });
        });
    </script>
    <?php
}
add_action('wp_footer', 'studi_theme_quantity_buttons');



/**
 * Backend validation to ensure max quantity of 1
 */
function validate_grouped_product_quantities($passed, $product_id, $quantity) {
    $product = wc_get_product($product_id);
    
    if ($product->is_type('grouped') && $quantity > 1) {
        wc_add_notice(__('You can only add maximum 1 quantity of each item in grouped products.', 'your-text-domain'), 'error');
        return false;
    }
    
    return $passed;
}
add_filter('woocommerce_add_to_cart_validation', 'validate_grouped_product_quantities', 10, 3);



//add filter by teacher id since version 13.1
add_filter('query_vars', 'add_teacher_query_var');
function add_teacher_query_var($vars) {
    $vars[] = 'te'; // 'te' for teacher
    return $vars;
}
add_action('pre_get_posts', 'filter_products_by_teacher_url');
function filter_products_by_teacher_url($query) {
    if (is_plugin_active('woocommerce/woocommerce.php')) {
        // Only modify the main query on the shop page
        if (is_admin() || !$query->is_main_query() || !is_shop() && !is_product_category() && !is_product_tag()) {
            return;
        }
    
        $teacher_id = get_query_var('te');
        
        if (!empty($teacher_id) && is_numeric($teacher_id)) {
            $meta_query = $query->get('meta_query') ?: [];
            
            $meta_query[] = [
                'key' => '_studiare_course_teachers',
                'value' => serialize(strval($teacher_id)),
                'compare' => 'LIKE'
            ];
            
            $query->set('meta_query', $meta_query);
        }
    }
}

/* studiare lessons and course builder */
require get_parent_theme_file_path('/inc/studi_lessons.php');

/* studiare subscriptions system */
//require_once get_parent_theme_file_path('/inc/lib/wc-subscriptions/woocommerce-subscriptions.php');


/**
 * Remove general buttons from single product
 * since v12.6 add ability to enable/disable some buttons in product single page
 */
function get_generalBtnsSinglePro_situ() {
    

    if (is_plugin_active('woocommerce/woocommerce.php')) {
    	if ( is_singular('product') ) {
    	    $prefix = '_studiare_'	;
    	    $sc_sections_off = get_post_meta( get_the_ID(), $prefix . 'sc_sections_off', false );
    	    
    	    //print_r($sc_sections_off);
    	    if(!empty($sc_sections_off)){
        	    $sc_sections_off=$sc_sections_off[0];
        	    
        	    if(in_array('contact',$sc_sections_off)){
        	        remove_action("wp_footer","studi_custom_floating_btn_gen");
        	    }
        	    if(in_array('float',$sc_sections_off)){
        	        remove_action("wp_footer","sc_studi_smart_nav_builder");
        	    }
        	    if(in_array('floating_add_to_cart',$sc_sections_off)){
        	        remove_action("wp_footer","sc_studi_add_to_cart_fixed_btn");
        	    }
        	    if(in_array('fullscreen_viewer',$sc_sections_off)){
        	        remove_action('woocommerce_single_product_summary','sc_add_fullscreen_btn_to_course_area');
        	    }
        	    if(in_array('support',$sc_sections_off)){
        	        remove_action("wp_footer","swss_add_floating_button_to_frontend");
        	    }
    	    }
    	
    	} 
    }
}
add_action('woocommerce_before_single_product', 'get_generalBtnsSinglePro_situ');


/** remove show full screen mode **/
function sc_remove_full_viewer(){
    
    if ( class_exists('Redux') ) {
		$fullview = codebean_option('show_fullscreen_mode_button');
		if(!$fullview){
		     remove_action('woocommerce_single_product_summary','sc_add_fullscreen_btn_to_course_area');
		}
	}
    
}
add_action('woocommerce_before_single_product', 'sc_remove_full_viewer');

//add edit button to notifications
function sc_notifs_edit_link_to_admin_bar() {
    if (isset($_GET['item_id'])) {
        $item_id = sanitize_text_field($_GET['item_id']);
        $edit_link = admin_url('post.php?post=' . $item_id . '&action=edit');
        global $wp_admin_bar;
        $wp_admin_bar->add_menu(array(
            'id' => 'sc-notifs-edit-link',
            'icon' => 'custom-edit-link',
            'title' => esc_html__( 'Edit Notification', 'studiare' ),
            'href' => $edit_link
        ));
    }
}
add_action('admin_bar_menu', 'sc_notifs_edit_link_to_admin_bar', 999);


// Remove Woo Styles
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );

// Remove result count and catalog ordering
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

// Remove Cross-Sells from the shopping cart page
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');

// Change out of stock text
add_filter( 'woocommerce_get_availability', 'studiare_custom_get_availability', 1, 2);

// Our hooked in function $availablity is passed via the filter!
function studiare_custom_get_availability( $availability, $_product ) {
    $product_single_outstock_message    = codebean_option('product_single_outstock_message');
	if ( !$_product->is_in_stock() ) $availability['availability'] = $product_single_outstock_message;
	return $availability;
}

//Change the breadcrumb separator
add_filter( 'woocommerce_breadcrumb_defaults', 'jk_change_breadcrumb_delimiter' );
function jk_change_breadcrumb_delimiter( $defaults ) {
	// Change the breadcrumb delimeter from '/' to '>'
	$defaults['delimiter'] = '<i class="fa fa-angle-right"></i>';
	return $defaults;
}

// Remove breadcrumb before content add it on page title
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

// Remove tabs & upsell display
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );

// Remove functions before single product summary
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );

// Remove thumbnails from product single
remove_action( 'woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20 );


/**
 * Get Teachers List and Return it as array
 */
if (!function_exists('studiare_get_teachers_list')) {
    function studiare_get_teachers_list() {
        $teachers = array();  // Start with an empty array

        $teachers_args = array(
            'post_type'      => 'teacher',
            'post_status'    => 'publish',
            'posts_per_page' => -1,
        );

        // Makes a query for the teacher post type
        $teachers_query = new WP_Query($teachers_args);

        // Adds every teacher to the $teachers array
        foreach ($teachers_query->posts as $teacher) {
            $teachers[$teacher->ID] = $teacher->post_title;
        }

        // Return these teachers
        return $teachers;
    }
}

/**
 * Shop products per page
 */
function studiare_shop_products_per_page() {

	$shop_per_page = '12';

	if ( class_exists('Redux') ) {
		$shop_per_page = codebean_option('shop_per_page');
	}

	$per_page = 12;
	$number = apply_filters('studiare_shop_per_page', $shop_per_page );
	if( is_numeric( $number )  &&  $number > 0) {
		$per_page = $number;
	}

	return $per_page;
}

add_filter( 'loop_shop_per_page', 'studiare_shop_products_per_page', 20 );


if( ! function_exists( 'studiare_cart_data' ) ) {
	add_filter('woocommerce_add_to_cart_fragments', 'studiare_cart_data', 30);
	function studiare_cart_data( $array ) {
		ob_start();
		studiare_cart_count();
		$count = ob_get_clean();

		ob_start();
		studiare_cart_subtotal();
		$subtotal = ob_get_clean();

		$array['span.studiare-cart-number'] = $count;
		$array['span.studiare-cart-subtotal'] = $subtotal;

		return $array;
	}
}

if( ! function_exists( 'studiare_cart_count' ) ) {
	function studiare_cart_count() {
		$count = WC()->cart->cart_contents_count;
		?>
		<span class="studiare-cart-number"><?php echo esc_html($count); ?></span>
		<?php
	}
}

if( ! function_exists( 'studiare_cart_subtotal' ) ) {
	function studiare_cart_subtotal() {
		?>
		<span class="studiare-cart-subtotal"><?php echo WC()->cart->get_cart_subtotal(); ?></span>
		<?php
	}
}

/**
 * Remove sidebar from single product
 */
function remove_sidebar_shop() {
	if ( is_singular('product') ) {
		remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar');
	}
}
add_action('template_redirect', 'remove_sidebar_shop');

/**
 * Render custom price html
 */
function studiare_custom_get_price_html( $price, $product ) {
    
	if ( $product->get_price() == 0 ) {
		if ( $product->is_on_sale() && $product->get_regular_price() ) {
			$regular_price = wc_get_price_to_display( $product, array( 'qty' => 1, 'price' => $product->get_regular_price() ) );

			//$price = wc_format_price_range( $regular_price, esc_html__( 'Free!', 'studiare' ) );
			$price = "<del><span class='woocommerce-Price-amount amount'>$regular_price" .get_woocommerce_currency_symbol()."</span></del> <ins><span class='woocommerce-Price-amount amount'>".esc_html__( 'Free!', 'studiare' )."</span></ins>";
		} 
		else {
		    $price = '<span class="amount">' . esc_html__( 'Free!', 'studiare' ) . '</span>';
		}
	}
	if('' === $product->get_price() ){
		   
            if(codebean_option('free_or_call_for_price')){
			    $price = '<span class="amount">' . esc_html__( 'Free!', 'studiare' ) . '</span>';
		    }else{
		        $price = '<span class="amount">' . esc_html__( 'Call for price', 'studiare' ) . '</span>';
		    }
                        
		}

	return $price;
	
	
    

}

add_filter( 'woocommerce_get_price_html', 'studiare_custom_get_price_html', 10, 2 );




/**
 * Cart Page markup
 */
add_action( 'woocommerce_before_cart', function() {
	echo '<div class="cart-page-inner row">';
}, 1);

add_action( 'woocommerce_after_cart', function() {
	echo '</div><!--.cart-totals-inner-->';
}, 200);

/**
 * Custom Excerpt for Products
 */
function studiare_product_custom_excerpt_length( $length ) {
	global $post;
	if ($post->post_type == 'product') {
		return 20;
	}
}

/**
 * Cart Mobile Menu Item
 */
function studiare_get_menu_item_cart() {
    $show_cart_item = true;

	if ( class_exists( 'Redux' ) ) {
		$show_cart_item = codebean_option('off_canvas_cart');
	}

	if ( ! $show_cart_item || ! function_exists( 'WC' ) ) {
		return;
	}

	$cart_items = WC()->cart->get_cart_contents_count();

	?>
    <div class="off-canvas-cart">
        <a href="<?php echo wc_get_cart_url(); ?>" class="cart-icon-link">
            <span class="bag-icon"><?php get_template_part( 'assets/images/shop-bag-two.svg' ); ?></span>
            <span class="cart-text"><?php esc_html_e( 'Cart', 'studiare' ); ?></span>
            <?php studiare_cart_count(); ?>
        </a>
    </div>
    <?php
}

/**
 * ------------------------------------------------------------------------------------------------
 * Determine is it product attribute archieve page
 * ------------------------------------------------------------------------------------------------
 */

if( ! function_exists( 'studiare_is_product_attribute_archieve' ) ) {
	function studiare_is_product_attribute_archieve() {
		$queried_object = get_queried_object();
		if( $queried_object && property_exists( $queried_object, 'taxonomy' ) ) {
			$taxonomy = $queried_object->taxonomy;
			return substr($taxonomy, 0, 3) == 'pa_';
		}
		return false;
	}
}

/**
 * ------------------------------------------------------------------------------------------------
 * Disable address fields for downloadable products checkout
 * ------------------------------------------------------------------------------------------------
 */
add_filter('woocommerce_checkout_fields', 'custom_checkout_fields_based_on_cart');
function custom_checkout_fields_based_on_cart($fields) {
    // Get the value of the Redux option
    $enable_address_fields = get_option('codebean_option')['course_checkout_address_fields'] ?? false;

    // If the option is disabled, do nothing
    if (!$enable_address_fields) {
        return $fields;
    }

    // Initialize product type flags
    $has_virtual_product = false;
    $has_physical_product = false;

    // Check the cart items to determine product types
    foreach (WC()->cart->get_cart() as $cart_item) {
        if ($cart_item['data']->is_virtual()) {
            $has_virtual_product = true;
        } else {
            $has_physical_product = true;
        }
    }

    // Remove address fields if only virtual products are in the cart
    if ($has_virtual_product && !$has_physical_product) {
        // Unset billing fields
        unset($fields['billing']['billing_address_1']);
        unset($fields['billing']['billing_address_2']);
        unset($fields['billing']['billing_city']);
        unset($fields['billing']['billing_postcode']);
        unset($fields['billing']['billing_state']);
        unset($fields['billing']['billing_country']);

        // Unset shipping fields
        unset($fields['shipping']['shipping_address_1']);
        unset($fields['shipping']['shipping_address_2']);
        unset($fields['shipping']['shipping_city']);
        unset($fields['shipping']['shipping_postcode']);
        unset($fields['shipping']['shipping_state']);
        unset($fields['shipping']['shipping_country']);
    }

    return $fields;
}

/**
 * ------------------------------------------------------------------------------------------------
 * exclude products in shop
 * ------------------------------------------------------------------------------------------------
 */
$exclude_products_shop = get_option('codebean_option')['exclude_products_shop'] ?? false;
$exclude_product_cats  = get_option('codebean_option')['exclude_product_cats'] ?? array();
$exclude_specific_products = get_option('codebean_option')['exclude_specific_products'] ?? array();
$show_excluded_in_archive  = get_option('codebean_option')['show_excluded_in_archive'] ?? false;

function custom_exclude_products_from_shop($query) {
    if (is_plugin_active('woocommerce/woocommerce.php')) {
        if (is_admin() || !$query->is_main_query() || !is_shop()) {
            return;
        }
    
        $options = get_option('codebean_option') ?: array();
        $exclude_products_shop = $options['exclude_products_shop'] ?? false;
        $exclude_product_cats = $options['exclude_product_cats'] ?? array();
        $exclude_specific_products = array_map('intval', (array) ($options['exclude_specific_products'] ?? array()));
    
        if ($exclude_products_shop) {
            $tax_query = $query->get('tax_query') ?: array();
    
            if (!empty($exclude_product_cats)) {
                $tax_query[] = array(
                    'taxonomy' => 'product_cat',
                    'field'    => 'term_id',
                    'terms'    => $exclude_product_cats,
                    'operator' => 'NOT IN',
                );
            }
    
            if (!empty($exclude_specific_products)) {
                $query->set('post__not_in', $exclude_specific_products);
            }
    
            if (!empty($tax_query)) {
                $query->set('tax_query', $tax_query);
            }
        }
    }
}
add_action('pre_get_posts', 'custom_exclude_products_from_shop');

function custom_exclude_products_from_category_archive($query) {
    if (is_admin() || !$query->is_main_query() || !is_tax('product_cat')) {
        return;
    }

    $options = get_option('codebean_option');
    $show_excluded_in_archive = $options['show_excluded_in_archive'] ?? false;
    $exclude_specific_products = $options['exclude_specific_products'] ?? array();

    if (!$show_excluded_in_archive && !empty($exclude_specific_products)) {
        $query->set('post__not_in', $exclude_specific_products);
    }
}
add_action('pre_get_posts', 'custom_exclude_products_from_category_archive');


/**
 * ------------------------------------------------------------------------------------------------
 * shop page description
 * ------------------------------------------------------------------------------------------------
 */
function add_custom_shop_description_to_end_of_loop() {
    if ( is_shop() && !is_product_category() ) {
        if ( class_exists('Redux') ) {
            $position = Redux::get_option('codebean_option', 'show_custom_shop_description');
            
            if ($position !== 'disabled') {
                $custom_shop_description_content = Redux::get_option('codebean_option', 'custom_shop_description_content');
                
                if ($position === 'top') {
                    echo '<section class="term-description">' . wpautop($custom_shop_description_content) . '</section>';
                }

                if ($position === 'bottom') {
                    add_action('woocommerce_after_shop_loop', function() use ($custom_shop_description_content) {
                        echo '<section class="term-description">' . wpautop($custom_shop_description_content) . '</section>';
                    }, 20);
                }
            }
        }
    }
}

add_action('woocommerce_before_shop_loop', 'add_custom_shop_description_to_end_of_loop', 20);

/**
 * ------------------------------------------------------------------------------------------------
 * single product stock texts
 * ------------------------------------------------------------------------------------------------
 */
function custom_stock_class_and_text($availability, $product) {
    $custom_in_stock_before = get_post_meta($product->get_id(), '_studiare_product_single_sc_in_stock_before_text', true);
    $custom_in_stock_after  = get_post_meta($product->get_id(), '_studiare_product_single_sc_in_stock_after_text', true);
    $custom_out_stock       = get_post_meta($product->get_id(), '_studiare_product_single_sc_out_stock_text', true);

    $stock_quantity = $product->get_stock_quantity();

    if  ($product->is_in_stock() && !empty($custom_in_stock_before)) {
        $availability['availability'] = trim($custom_in_stock_before . ' ' . $stock_quantity . ' ' . $custom_in_stock_after);
        
        if (!empty($custom_in_stock_before)) {
            $availability['class'] .= ' scinstock';
        }
    } elseif (!$product->is_in_stock() && !empty($custom_out_stock)) {
        $availability['availability'] = $custom_out_stock;
    }

    return $availability;
}
add_filter('woocommerce_get_availability', 'custom_stock_class_and_text', 10, 2);

/**
 * ------------------------------------------------------------------------------------------------
 * disable selected account page menus
 * ------------------------------------------------------------------------------------------------
 */
function disable_selected_account_page_endpoints($items) {
    if (class_exists('Redux') && function_exists('codebean_option') && !is_admin()) { 
        $disabled_menus = Redux::get_option('codebean_option', 'sc_select_account_page_menus');
        $remove_from_endpoint = Redux::get_option('codebean_option', 'sc_disable_menu_from_endpoint');

        if (!empty($disabled_menus)) {
            foreach ($items as $key => $item) {
                if (in_array($key, $disabled_menus)) {
                    unset($items[$key]);
                }
            }
        }
    }

    return $items;
}
add_filter('woocommerce_account_menu_items', 'disable_selected_account_page_endpoints', 99);


function studi_disable_woocommerce_account_endpoints() {
    if (class_exists('Redux') && function_exists('codebean_option') && !is_admin()) { 
        $remove_from_endpoint = Redux::get_option('codebean_option', 'sc_disable_menu_from_endpoint');
        $disabled_menus = Redux::get_option('codebean_option', 'sc_select_account_page_menus');
        
        if ($remove_from_endpoint && !empty($disabled_menus)) {  
            // Get the current URL endpoint
            $current_endpoint = WC()->query->get_current_endpoint();
            
            // Check if the current endpoint is in the disabled list
            if (in_array($current_endpoint, $disabled_menus)) {
                wp_redirect(home_url()); // Redirect to the homepage
                exit;
            }
            
            // Handle custom endpoints

            foreach ($disabled_menus as $custom_endpoint) {
                if (strpos($_SERVER['REQUEST_URI'], $custom_endpoint) !== false) {
                    wp_redirect(home_url()); // Redirect to the homepage
                    exit;
                }
            }
        }
    }
}
add_action('template_redirect', 'studi_disable_woocommerce_account_endpoints');








/**
 * ------------------------------------------------------------------------------------------------
 * custom account menu
 * ------------------------------------------------------------------------------------------------
 */
function add_custom_account_menus($items) {
    if (class_exists('Redux') && function_exists('codebean_option')) { 
       
       
        
        $custom_account_menus = codebean_option("custom_account_menus");
        
        
        if (!empty($custom_account_menus)) {
            unset($custom_account_menus['redux_repeater_data']);
            $i=0;
            foreach ($custom_account_menus as $menu_data ) {
                if(!empty($custom_account_menus['menu_title'][$i])){

                        $menu_title = $custom_account_menus['menu_title'][$i];
                        $menu_slug  = $custom_account_menus['menu_slug'][$i];

                        if (!empty($menu_slug) && !empty($menu_title)) {
                            $items[$menu_slug] = $menu_title;
                        }
                }
                $i++;
            }
        }
        
    }
    return $items;
}
add_filter('woocommerce_account_menu_items', 'add_custom_account_menus', 50);




function register_custom_account_endpoints() {
    if (class_exists('Redux') && function_exists('codebean_option')) { 
        
        
        $custom_account_menus = codebean_option("custom_account_menus");
        //unset($custom_account_menus['redux_repeater_data']);
        
        if (!empty($custom_account_menus)) {
            $i=0;
            foreach ($custom_account_menus as $menu_data ) {
                if(!empty($custom_account_menus['menu_title'][$i])){

                        $menu_slug  = $custom_account_menus['menu_slug'][$i];

                        if (!empty($menu_slug) ) {
                             add_rewrite_endpoint($menu_slug, EP_PAGES);
                        }
                }
                $i++;
            }
        }
        
    }
}
add_action('init', 'register_custom_account_endpoints');


function display_custom_account_menu_content() {
    if (class_exists('Redux') && function_exists('codebean_option')) { 
        $custom_account_menus = codebean_option('custom_account_menus');
        
        if (!empty($custom_account_menus) && is_array($custom_account_menus)) {
            unset($custom_account_menus['redux_repeater_data']); // Remove unwanted data
            
            $i=0;
            foreach ($custom_account_menus as $menu) {
                
                if(!empty($custom_account_menus['menu_title'][$i])){
                    $menu_slug  = $custom_account_menus['menu_slug'][$i];
                    $menu_content_type = $custom_account_menus['menu_content_type'][$i] ?? '';
                    $menu_content_editor = $custom_account_menus['menu_content_editor'][$i] ?? '';
                    $menu_content_page = $custom_account_menus['menu_content_page'][$i] ?? '';
    
                    add_action('woocommerce_account_' . $menu_slug . '_endpoint', function() use ($menu_slug,$menu_content_type, $menu_content_editor, $menu_content_page) {
    
                        echo '<div class="woocommerce-MyAccount-content-inner">';
    
                        if ($menu_content_type === 'editor' && !empty($menu_content_editor)) {
                            echo wpautop(wp_kses_post($menu_content_editor));
                        } elseif ($menu_content_type === 'page' && !empty($menu_content_page)) {
    
                            echo \Elementor\Plugin::instance()->frontend->get_builder_content($menu_content_page);
                        }
                        
                        echo '</div>';
                    });
                }
            
             $i++;   
            }
        }
    }
}
add_action('init', 'display_custom_account_menu_content', 99); //woocommerce_account_dashboard


//add icons
 add_filter('studi_custom_dynamic_css', function($css){
     
     if (class_exists('Redux') && function_exists('codebean_option')) { 
       
       
        
        $custom_account_menus = codebean_option("custom_account_menus");
        
        
        if (!empty($custom_account_menus)) {
            unset($custom_account_menus['redux_repeater_data']);
            $i=0;
            foreach ($custom_account_menus as $menu_data ) {
                if(!empty($custom_account_menus['menu_title'][$i])){
                        
                        $menu_slug  = $custom_account_menus['menu_slug'][$i];
                        $menu_icon  = $custom_account_menus['menu_icon'][$i];

                        if (!empty($menu_icon) ) {
                            $menu_icon = "\\$menu_icon";
                           $css .="i.$menu_slug:before { content: '".$menu_icon."'; }";
                           $css .=".woocommerce-account .woocommerce-MyAccount-navigation ul li.woocommerce-MyAccount-navigation-link--$menu_slug:before { content: '".$menu_icon."'; }";
                        }
                }
                $i++;
            }
        }
        return $css;
        
    }
     
     
 });

// Add custom section after default account fields for profile picture
add_action('woocommerce_after_edit_account_form', 'add_profile_picture_section');
function add_profile_picture_section() {
    if (class_exists('Redux') && function_exists('codebean_option')) { 
        
    $enable_profile_picture = codebean_option('enable_profile_picture_upload') ?? true;
    

    if (!$enable_profile_picture) {
        return;
    }
    $user_id = get_current_user_id();
    $current_picture = get_user_meta($user_id, 'profile_picture', true);
    ?>
    <div class="profile-picture-section" style="margin-top: 40px; padding-top: 20px; border-top: 1px solid #eee;">
        <h3><?php esc_html_e('Profile Picture', 'studiare'); ?></h3>
        
        <div class="current-profile-picture" style="margin-bottom: 20px;">
            <?php if ($current_picture): ?>
                <img src="<?php echo esc_url($current_picture); ?>" style="width: 140px; height: 140px; object-fit: cover; border-radius: 50%;">
            <?php else: ?>
                <p><?php esc_html_e('No profile picture set', 'studiare'); ?></p>
            <?php endif; ?>
        </div>

        <form action="" method="post" enctype="multipart/form-data" class="profile-picture-form" style="margin-bottom: 10px;">
            <?php wp_nonce_field('update_profile_picture', 'profile_picture_nonce'); ?>
            
            <p class="form-row">
                <input type="file" 
                       class="woocommerce-Input" 
                       name="profile_picture" 
                       id="profile_picture" 
                       accept="image/*"
                       style="margin-bottom: 10px;">
                <br>
                <span><em><?php esc_html_e('Allowed formats: JPG, PNG, GIF', 'studiare'); ?></em></span>
            </p>

            <p class="form-row">
                <button type="submit" 
                        class="woocommerce-Button button" 
                        name="update_profile_picture">
                    <?php esc_html_e('Update Profile Picture', 'studiare'); ?>
                </button>
            </p>
        </form>

        <?php if ($current_picture): ?>
            <form action="" method="post">
                <?php wp_nonce_field('remove_profile_picture', 'remove_profile_picture_nonce'); ?>
                <button type="submit" name="remove_profile_picture" class="button" style="background: #dc3545; color: white;">
                    <?php esc_html_e('Remove Profile Picture', 'studiare'); ?>
                </button>
            </form>
        <?php endif; ?>
    </div>
    <?php
    }
}

// Handle the profile picture upload
add_action('template_redirect', 'handle_profile_picture_upload');
function handle_profile_picture_upload() {
    if (class_exists('Redux') && function_exists('codebean_option')) { 
$enable_profile_picture = codebean_option('enable_profile_picture_upload') ?? true;

if (!$enable_profile_picture) {
return;
}
    if (!isset($_POST['update_profile_picture']) && !isset($_POST['remove_profile_picture'])) {
        return;
    }

    // Handle profile picture removal
    if (isset($_POST['remove_profile_picture'])) {
        // Verify nonce
        if (!isset($_POST['remove_profile_picture_nonce']) || 
            !wp_verify_nonce($_POST['remove_profile_picture_nonce'], 'remove_profile_picture')) {
            wc_add_notice(__('Security check failed.', 'studiare'), 'error');
            return;
        }

        // Check if user is logged in
        if (!is_user_logged_in()) {
            wc_add_notice(__('You must be logged in to remove your profile picture.', 'studiare'), 'error');
            return;
        }

        $user_id = get_current_user_id();
        $profile_picture = get_user_meta($user_id, 'profile_picture', true);

        if ($profile_picture) {
            // Get upload directory info
            $upload_dir = wp_upload_dir();
            
            // Get the file path from URL
            $file_path = str_replace($upload_dir['baseurl'], $upload_dir['basedir'], $profile_picture);
            
            // Delete the file if it exists
            if (file_exists($file_path)) {
                wp_delete_file($file_path);
            }
            
            // Remove the meta data
            delete_user_meta($user_id, 'profile_picture');
            
            wc_add_notice(__('Profile picture removed successfully.', 'studiare'), 'success');
        }

        wp_safe_redirect(wc_get_account_endpoint_url('edit-account'));
        exit;
    }

    // Handle profile picture upload
    if (isset($_POST['update_profile_picture'])) {
        // Verify nonce
        if (!isset($_POST['profile_picture_nonce']) || 
            !wp_verify_nonce($_POST['profile_picture_nonce'], 'update_profile_picture')) {
            wc_add_notice(__('Security check failed.', 'studiare'), 'error');
            return;
        }

        // Check if user is logged in
        if (!is_user_logged_in()) {
            wc_add_notice(__('You must be logged in to update your profile picture.', 'studiare'), 'error');
            return;
        }

        $user_id = get_current_user_id();

        // Check if file was uploaded
        if (!isset($_FILES['profile_picture']) || !$_FILES['profile_picture']['size']) {
            wc_add_notice(__('Please select an image to upload.', 'studiare'), 'error');
            return;
        }

        // Load WordPress file handling functions
        if (!function_exists('wp_handle_upload')) {
            require_once(ABSPATH . 'wp-admin/includes/file.php');
        }

        // Check file type
        $file = $_FILES['profile_picture'];
        $allowed_types = array('image/jpeg', 'image/png', 'image/gif');
        
        if (!in_array($file['type'], $allowed_types)) {
            wc_add_notice(__('Only image files (JPG, PNG, GIF) are allowed.', 'studiare'), 'error');
            return;
        }

        // Additional file type verification
        $file_info = wp_check_filetype($file['name']);
        if (!$file_info['ext']) {
            wc_add_notice(__('Invalid file type.', 'studiare'), 'error');
            return;
        }

        // Set up upload parameters
        $upload_dir = wp_upload_dir();
        
        // Generate random filename
        $random_filename = 'profile_' . $user_id . '_' . wp_generate_password(32, false) . '.' . $file_info['ext'];
        
        // Prepare upload overrides
        $upload_overrides = array(
            'test_form' => false,
            'unique_filename_callback' => function($dir, $name, $ext) use ($random_filename) {
                return $random_filename;
            }
        );

        // Handle the upload
        $movefile = wp_handle_upload($file, $upload_overrides);

        if ($movefile && !isset($movefile['error'])) {
            // Process the uploaded image
            $image_path = $movefile['file'];
            
            // Load image editor
            $image_editor = wp_get_image_editor($image_path);
            
            if (!is_wp_error($image_editor)) {
                // Get current image dimensions
                $size = $image_editor->get_size();
                $orig_width = $size['width'];
                $orig_height = $size['height'];
                
                // Calculate crop dimensions
                $crop_size = min($orig_width, $orig_height);
                $crop_x = ($orig_width - $crop_size) / 2;
                $crop_y = ($orig_height - $crop_size) / 2;
                
                // Crop to square
                $image_editor->crop($crop_x, $crop_y, $crop_size, $crop_size);
                
                // Resize to 140x140
                $image_editor->resize(140, 140, true);
                
                // Set quality
                $image_editor->set_quality(90);
                
                // Generate new filename for processed image
                $processed_filename = 'profile_' . $user_id . '_' . wp_generate_password(32, false) . '_processed.' . $file_info['ext'];
                $processed_path = $upload_dir['path'] . '/' . $processed_filename;
                
                // Save the processed image
                $saved = $image_editor->save($processed_path);
                
                if (!is_wp_error($saved)) {
                    // Delete the original uploaded file
                    wp_delete_file($image_path);
                    
                    // Delete old profile picture if exists
                    $old_picture = get_user_meta($user_id, 'profile_picture', true);
                    if ($old_picture) {
                        $old_file_path = str_replace($upload_dir['baseurl'], $upload_dir['basedir'], $old_picture);
                        if (file_exists($old_file_path)) {
                            wp_delete_file($old_file_path);
                        }
                    }
                    
                    // Save new profile picture URL
                    $new_url = $upload_dir['url'] . '/' . $processed_filename;
                    update_user_meta($user_id, 'profile_picture', $new_url);
                    wc_add_notice(__('Profile picture updated successfully.', 'studiare'), 'success');
                } else {
                    wp_delete_file($image_path);
                    wc_add_notice(__('Error processing image. Please try again.', 'studiare'), 'error');
                }
            } else {
                wp_delete_file($image_path);
                wc_add_notice(__('Error processing image. Please try again.', 'studiare'), 'error');
            }
        } else {
            wc_add_notice(__('Error uploading profile picture. Please try again.', 'studiare'), 'error');
        }

        // Redirect back to the account page
        wp_safe_redirect(wc_get_account_endpoint_url('edit-account'));
        exit;
    }
}    
}


// Filter for avatar URLs to replace with custom profile picture
add_filter('get_avatar_url', 'replace_avatar_with_custom_profile', 10, 3);
function replace_avatar_with_custom_profile($url, $id_or_email, $args) {
    $user_id = 0;
    
    // Determine user ID from different input types
    if (is_numeric($id_or_email)) {
        $user_id = (int) $id_or_email;
    } elseif (is_object($id_or_email)) {
        if (!empty($id_or_email->user_id)) {
            $user_id = (int) $id_or_email->user_id;
        } elseif (!empty($id_or_email->comment_author_email)) {
            $user = get_user_by('email', $id_or_email->comment_author_email);
            if ($user) {
                $user_id = $user->ID;
            }
        }
    } elseif (is_string($id_or_email) && strpos($id_or_email, '@') !== false) {
        $user = get_user_by('email', $id_or_email);
        if ($user) {
            $user_id = $user->ID;
        }
    }
    
    // If we have a valid user ID, check for custom profile picture
    if ($user_id > 0) {
        $profile_picture = get_user_meta($user_id, 'profile_picture', true);
        if (!empty($profile_picture)) {
            return $profile_picture; // Return custom profile picture
        }
    }
    
    return $url; // Return original URL if no custom picture
}

// Keep your existing get_avatar filter for complete coverage
add_filter('get_avatar', 'custom_avatar', 10, 6);
function custom_avatar($avatar, $id_or_email, $size, $default, $alt, $args) {
    $user_id = 0;
    
    // Determine user ID from different input types
    if (is_numeric($id_or_email)) {
        $user_id = (int) $id_or_email;
    } elseif (is_object($id_or_email)) {
        if (!empty($id_or_email->user_id)) {
            $user_id = (int) $id_or_email->user_id;
        } elseif (!empty($id_or_email->comment_author_email)) {
            $user = get_user_by('email', $id_or_email->comment_author_email);
            if ($user) {
                $user_id = $user->ID;
            }
        }
    } elseif (is_string($id_or_email) && strpos($id_or_email, '@') !== false) {
        $user = get_user_by('email', $id_or_email);
        if ($user) {
            $user_id = $user->ID;
        }
    }
    
    // If we have a user ID and they have a custom profile picture
    if ($user_id > 0) {
        $profile_picture = get_user_meta($user_id, 'profile_picture', true);
        if (!empty($profile_picture)) {
            // Return custom profile picture with proper attributes
            $avatar = sprintf(
                '<img alt="%s" src="%s" class="avatar avatar-%d photo" height="%d" width="%d" %s />',
                esc_attr($alt),
                esc_url($profile_picture),
                esc_attr($size),
                esc_attr($size),
                esc_attr($size),
                !empty($args['extra_attr']) ? $args['extra_attr'] : ''
            );
            return $avatar;
        }
    }
    
    return $avatar;
}

// Add some CSS to style the profile picture section
add_action('wp_head', 'add_profile_picture_styles');
function add_profile_picture_styles() {
    if (class_exists('Redux') && function_exists('codebean_option')) { 
    $enable_profile_picture = codebean_option('enable_profile_picture_upload') ?? true;
    
    if (!$enable_profile_picture) {
        return;
    }
    ?>
    <style>
        .profile-picture-section {
            background: #f8f8f8;
            padding: 20px;
            border-radius: 5px;
            margin-top: 30px;
        }
        .profile-picture-section h3 {
            margin-bottom: 20px;
        }
        .current-profile-picture img {
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
    </style>
    <?php
    }
}



require_once get_parent_theme_file_path('/inc/lib/prerequisite/prerequisite_lessons.php');
