<?php
// In the 'Icon library' dropdown for an icon content type, add a new family of icons.
function fapro_add_to_iconbox() {
    $param = WPBMap::getParam( 'vc_icon', 'type' );
    $param['value'][ __( 'FontAwesome Pro icons', 'js_composer' ) ] = 'fapro';

    vc_update_shortcode_param( 'vc_icon', $param );
}
add_filter( 'vc_after_init', 'fapro_add_to_iconbox', 40 );


// This adds a new parameter to the vc_icon content block.
// This parameter is an icon_picker element,
// that displays when fapro is picked from the dropdown.
function fapro_add_font_picker() {

    $settings = array(
        'type'        => 'iconpicker',
        'heading'     => __( 'Icon', 'js_composer' ),
        'param_name'  => 'icon_fapro',
        'settings'    => array(
            'emptyIcon'    => false,
            'type'         => 'fapro',
            'iconsPerPage' => 20,
        ),
        'dependency'  => array(
            'element' => 'type',
            'value'   => 'fapro',
        ),
        'weight'      => '1',
        'description' => __( 'Select icon from library.', 'js_composer' ),
    );

    vc_add_param( 'vc_icon', $settings );
}
add_filter( 'vc_after_init', 'fapro_add_font_picker', 50 );


// Add all the icons we want to display in our font family.
function vc_iconpicker_type_fapro( $icons ) {
    // Add custom icons to array.
    $fapro_icons = array(
        'Light Icons' => array(
array('fal fa-abacus'=>'abacus'),
array('fal fa-acorn'=>'acorn'),
array('fal fa-ad'=>'ad'),
array('fal fa-address-book'=>'address-book'),
array('fal fa-address-card'=>'address-card'),
array('fal fa-adjust'=>'adjust'),
array('fal fa-air-conditioner'=>'air-conditioner'),
array('fal fa-air-freshener'=>'air-freshener'),
array('fal fa-alarm-clock'=>'alarm-clock'),
array('fal fa-alarm-exclamation'=>'alarm-exclamation'),
array('fal fa-alarm-plus'=>'alarm-plus'),
array('fal fa-alarm-snooze'=>'alarm-snooze'),
array('fal fa-album'=>'album'),
array('fal fa-album-collection'=>'album-collection'),
array('fal fa-alicorn'=>'alicorn'),
array('fal fa-alien'=>'alien'),
array('fal fa-alien-monster'=>'alien-monster'),
array('fal fa-align-center'=>'align-center'),
array('fal fa-align-justify'=>'align-justify'),
array('fal fa-align-left'=>'align-left'),
array('fal fa-align-right'=>'align-right'),
array('fal fa-align-slash'=>'align-slash'),
array('fal fa-allergies'=>'allergies'),
array('fal fa-ambulance'=>'ambulance'),
array('fal fa-american-sign-language-interpreting'=>'american-sign-language-interpreting'),
array('fal fa-amp-guitar'=>'amp-guitar'),
array('fal fa-analytics'=>'analytics'),
array('fal fa-anchor'=>'anchor'),
array('fal fa-angel'=>'angel'),
array('fal fa-angle-double-down'=>'angle-double-down'),
array('fal fa-angle-double-left'=>'angle-double-left'),
array('fal fa-angle-double-right'=>'angle-double-right'),
array('fal fa-angle-double-up'=>'angle-double-up'),
array('fal fa-angle-down'=>'angle-down'),
array('fal fa-angle-left'=>'angle-left'),
array('fal fa-angle-right'=>'angle-right'),
array('fal fa-angle-up'=>'angle-up'),
array('fal fa-angry'=>'angry'),
array('fal fa-ankh'=>'ankh'),
array('fal fa-apple-alt'=>'apple-alt'),
array('fal fa-apple-crate'=>'apple-crate'),
array('fal fa-archive'=>'archive'),
array('fal fa-archway'=>'archway'),
array('fal fa-arrow-alt-circle-down'=>'arrow-alt-circle-down'),
array('fal fa-arrow-alt-circle-left'=>'arrow-alt-circle-left'),
array('fal fa-arrow-alt-circle-right'=>'arrow-alt-circle-right'),
array('fal fa-arrow-alt-circle-up'=>'arrow-alt-circle-up'),
array('fal fa-arrow-alt-down'=>'arrow-alt-down'),
array('fal fa-arrow-alt-from-bottom'=>'arrow-alt-from-bottom'),
array('fal fa-arrow-alt-from-left'=>'arrow-alt-from-left'),
array('fal fa-arrow-alt-from-right'=>'arrow-alt-from-right'),
array('fal fa-arrow-alt-from-top'=>'arrow-alt-from-top'),
array('fal fa-arrow-alt-left'=>'arrow-alt-left'),
array('fal fa-arrow-alt-right'=>'arrow-alt-right'),
array('fal fa-arrow-alt-square-down'=>'arrow-alt-square-down'),
array('fal fa-arrow-alt-square-left'=>'arrow-alt-square-left'),
array('fal fa-arrow-alt-square-right'=>'arrow-alt-square-right'),
array('fal fa-arrow-alt-square-up'=>'arrow-alt-square-up'),
array('fal fa-arrow-alt-to-bottom'=>'arrow-alt-to-bottom'),
array('fal fa-arrow-alt-to-left'=>'arrow-alt-to-left'),
array('fal fa-arrow-alt-to-right'=>'arrow-alt-to-right'),
array('fal fa-arrow-alt-to-top'=>'arrow-alt-to-top'),
array('fal fa-arrow-alt-up'=>'arrow-alt-up'),
array('fal fa-arrow-circle-down'=>'arrow-circle-down'),
array('fal fa-arrow-circle-left'=>'arrow-circle-left'),
array('fal fa-arrow-circle-right'=>'arrow-circle-right'),
array('fal fa-arrow-circle-up'=>'arrow-circle-up'),
array('fal fa-arrow-down'=>'arrow-down'),
array('fal fa-arrow-from-bottom'=>'arrow-from-bottom'),
array('fal fa-arrow-from-left'=>'arrow-from-left'),
array('fal fa-arrow-from-right'=>'arrow-from-right'),
array('fal fa-arrow-from-top'=>'arrow-from-top'),
array('fal fa-arrow-left'=>'arrow-left'),
array('fal fa-arrow-right'=>'arrow-right'),
array('fal fa-arrow-square-down'=>'arrow-square-down'),
array('fal fa-arrow-square-left'=>'arrow-square-left'),
array('fal fa-arrow-square-right'=>'arrow-square-right'),
array('fal fa-arrow-square-up'=>'arrow-square-up'),
array('fal fa-arrow-to-bottom'=>'arrow-to-bottom'),
array('fal fa-arrow-to-left'=>'arrow-to-left'),
array('fal fa-arrow-to-right'=>'arrow-to-right'),
array('fal fa-arrow-to-top'=>'arrow-to-top'),
array('fal fa-arrow-up'=>'arrow-up'),
array('fal fa-arrows'=>'arrows'),
array('fal fa-arrows-alt'=>'arrows-alt'),
array('fal fa-arrows-alt-h'=>'arrows-alt-h'),
array('fal fa-arrows-alt-v'=>'arrows-alt-v'),
array('fal fa-arrows-h'=>'arrows-h'),
array('fal fa-arrows-v'=>'arrows-v'),
array('fal fa-assistive-listening-systems'=>'assistive-listening-systems'),
array('fal fa-asterisk'=>'asterisk'),
array('fal fa-at'=>'at'),
array('fal fa-atlas'=>'atlas'),
array('fal fa-atom'=>'atom'),
array('fal fa-atom-alt'=>'atom-alt'),
array('fal fa-audio-description'=>'audio-description'),
array('fal fa-award'=>'award'),
array('fal fa-axe'=>'axe'),
array('fal fa-axe-battle'=>'axe-battle'),
array('fal fa-baby'=>'baby'),
array('fal fa-baby-carriage'=>'baby-carriage'),
array('fal fa-backpack'=>'backpack'),
array('fal fa-backspace'=>'backspace'),
array('fal fa-backward'=>'backward'),
array('fal fa-bacon'=>'bacon'),
array('fal fa-badge'=>'badge'),
array('fal fa-badge-check'=>'badge-check'),
array('fal fa-badge-dollar'=>'badge-dollar'),
array('fal fa-badge-percent'=>'badge-percent'),
array('fal fa-badge-sheriff'=>'badge-sheriff'),
array('fal fa-badger-honey'=>'badger-honey'),
array('fal fa-bags-shopping'=>'bags-shopping'),
array('fal fa-bahai'=>'bahai'),
array('fal fa-balance-scale'=>'balance-scale'),
array('fal fa-balance-scale-left'=>'balance-scale-left'),
array('fal fa-balance-scale-right'=>'balance-scale-right'),
array('fal fa-ball-pile'=>'ball-pile'),
array('fal fa-ballot'=>'ballot'),
array('fal fa-ballot-check'=>'ballot-check'),
array('fal fa-ban'=>'ban'),
array('fal fa-band-aid'=>'band-aid'),
array('fal fa-banjo'=>'banjo'),
array('fal fa-barcode'=>'barcode'),
array('fal fa-barcode-alt'=>'barcode-alt'),
array('fal fa-barcode-read'=>'barcode-read'),
array('fal fa-barcode-scan'=>'barcode-scan'),
array('fal fa-bars'=>'bars'),
array('fal fa-baseball'=>'baseball'),
array('fal fa-baseball-ball'=>'baseball-ball'),
array('fal fa-basketball-ball'=>'basketball-ball'),
array('fal fa-basketball-hoop'=>'basketball-hoop'),
array('fal fa-bat'=>'bat'),
array('fal fa-bath'=>'bath'),
array('fal fa-battery-bolt'=>'battery-bolt'),
array('fal fa-battery-empty'=>'battery-empty'),
array('fal fa-battery-full'=>'battery-full'),
array('fal fa-battery-half'=>'battery-half'),
array('fal fa-battery-quarter'=>'battery-quarter'),
array('fal fa-battery-slash'=>'battery-slash'),
array('fal fa-battery-three-quarters'=>'battery-three-quarters'),
array('fal fa-bed'=>'bed'),
array('fal fa-bed-alt'=>'bed-alt'),
array('fal fa-bed-bunk'=>'bed-bunk'),
array('fal fa-bed-empty'=>'bed-empty'),
array('fal fa-beer'=>'beer'),
array('fal fa-bell'=>'bell'),
array('fal fa-bell-exclamation'=>'bell-exclamation'),
array('fal fa-bell-on'=>'bell-on'),
array('fal fa-bell-plus'=>'bell-plus'),
array('fal fa-bell-school'=>'bell-school'),
array('fal fa-bell-school-slash'=>'bell-school-slash'),
array('fal fa-bell-slash'=>'bell-slash'),
array('fal fa-bells'=>'bells'),
array('fal fa-betamax'=>'betamax'),
array('fal fa-bezier-curve'=>'bezier-curve'),
array('fal fa-bible'=>'bible'),
array('fal fa-bicycle'=>'bicycle'),
array('fal fa-biking'=>'biking'),
array('fal fa-biking-mountain'=>'biking-mountain'),
array('fal fa-binoculars'=>'binoculars'),
array('fal fa-biohazard'=>'biohazard'),
array('fal fa-birthday-cake'=>'birthday-cake'),
array('fal fa-blanket'=>'blanket'),
array('fal fa-blender'=>'blender'),
array('fal fa-blender-phone'=>'blender-phone'),
array('fal fa-blind'=>'blind'),
array('fal fa-blinds'=>'blinds'),
array('fal fa-blinds-open'=>'blinds-open'),
array('fal fa-blinds-raised'=>'blinds-raised'),
array('fal fa-blog'=>'blog'),
array('fal fa-bold'=>'bold'),
array('fal fa-bolt'=>'bolt'),
array('fal fa-bomb'=>'bomb'),
array('fal fa-bone'=>'bone'),
array('fal fa-bone-break'=>'bone-break'),
array('fal fa-bong'=>'bong'),
array('fal fa-book'=>'book'),
array('fal fa-book-alt'=>'book-alt'),
array('fal fa-book-dead'=>'book-dead'),
array('fal fa-book-heart'=>'book-heart'),
array('fal fa-book-medical'=>'book-medical'),
array('fal fa-book-open'=>'book-open'),
array('fal fa-book-reader'=>'book-reader'),
array('fal fa-book-spells'=>'book-spells'),
array('fal fa-book-user'=>'book-user'),
array('fal fa-bookmark'=>'bookmark'),
array('fal fa-books'=>'books'),
array('fal fa-books-medical'=>'books-medical'),
array('fal fa-boombox'=>'boombox'),
array('fal fa-boot'=>'boot'),
array('fal fa-booth-curtain'=>'booth-curtain'),
array('fal fa-border-all'=>'border-all'),
array('fal fa-border-bottom'=>'border-bottom'),
array('fal fa-border-center-h'=>'border-center-h'),
array('fal fa-border-center-v'=>'border-center-v'),
array('fal fa-border-inner'=>'border-inner'),
array('fal fa-border-left'=>'border-left'),
array('fal fa-border-none'=>'border-none'),
array('fal fa-border-outer'=>'border-outer'),
array('fal fa-border-right'=>'border-right'),
array('fal fa-border-style'=>'border-style'),
array('fal fa-border-style-alt'=>'border-style-alt'),
array('fal fa-border-top'=>'border-top'),
array('fal fa-bow-arrow'=>'bow-arrow'),
array('fal fa-bowling-ball'=>'bowling-ball'),
array('fal fa-bowling-pins'=>'bowling-pins'),
array('fal fa-box'=>'box'),
array('fal fa-box-alt'=>'box-alt'),
array('fal fa-box-ballot'=>'box-ballot'),
array('fal fa-box-check'=>'box-check'),
array('fal fa-box-fragile'=>'box-fragile'),
array('fal fa-box-full'=>'box-full'),
array('fal fa-box-heart'=>'box-heart'),
array('fal fa-box-open'=>'box-open'),
array('fal fa-box-up'=>'box-up'),
array('fal fa-box-usd'=>'box-usd'),
array('fal fa-boxes'=>'boxes'),
array('fal fa-boxes-alt'=>'boxes-alt'),
array('fal fa-boxing-glove'=>'boxing-glove'),
array('fal fa-brackets'=>'brackets'),
array('fal fa-brackets-curly'=>'brackets-curly'),
array('fal fa-braille'=>'braille'),
array('fal fa-brain'=>'brain'),
array('fal fa-bread-loaf'=>'bread-loaf'),
array('fal fa-bread-slice'=>'bread-slice'),
array('fal fa-briefcase'=>'briefcase'),
array('fal fa-briefcase-medical'=>'briefcase-medical'),
array('fal fa-bring-forward'=>'bring-forward'),
array('fal fa-bring-front'=>'bring-front'),
array('fal fa-broadcast-tower'=>'broadcast-tower'),
array('fal fa-broom'=>'broom'),
array('fal fa-browser'=>'browser'),
array('fal fa-brush'=>'brush'),
array('fal fa-bug'=>'bug'),
array('fal fa-building'=>'building'),
array('fal fa-bullhorn'=>'bullhorn'),
array('fal fa-bullseye'=>'bullseye'),
array('fal fa-bullseye-arrow'=>'bullseye-arrow'),
array('fal fa-bullseye-pointer'=>'bullseye-pointer'),
array('fal fa-burger-soda'=>'burger-soda'),
array('fal fa-burn'=>'burn'),
array('fal fa-burrito'=>'burrito'),
array('fal fa-bus'=>'bus'),
array('fal fa-bus-alt'=>'bus-alt'),
array('fal fa-bus-school'=>'bus-school'),
array('fal fa-business-time'=>'business-time'),
array('fal fa-cabinet-filing'=>'cabinet-filing'),
array('fal fa-cactus'=>'cactus'),
array('fal fa-calculator'=>'calculator'),
array('fal fa-calculator-alt'=>'calculator-alt'),
array('fal fa-calendar'=>'calendar'),
array('fal fa-calendar-alt'=>'calendar-alt'),
array('fal fa-calendar-check'=>'calendar-check'),
array('fal fa-calendar-day'=>'calendar-day'),
array('fal fa-calendar-edit'=>'calendar-edit'),
array('fal fa-calendar-exclamation'=>'calendar-exclamation'),
array('fal fa-calendar-minus'=>'calendar-minus'),
array('fal fa-calendar-plus'=>'calendar-plus'),
array('fal fa-calendar-star'=>'calendar-star'),
array('fal fa-calendar-times'=>'calendar-times'),
array('fal fa-calendar-week'=>'calendar-week'),
array('fal fa-camcorder'=>'camcorder'),
array('fal fa-camera'=>'camera'),
array('fal fa-camera-alt'=>'camera-alt'),
array('fal fa-camera-home'=>'camera-home'),
array('fal fa-camera-movie'=>'camera-movie'),
array('fal fa-camera-polaroid'=>'camera-polaroid'),
array('fal fa-camera-retro'=>'camera-retro'),
array('fal fa-campfire'=>'campfire'),
array('fal fa-campground'=>'campground'),
array('fal fa-candle-holder'=>'candle-holder'),
array('fal fa-candy-cane'=>'candy-cane'),
array('fal fa-candy-corn'=>'candy-corn'),
array('fal fa-cannabis'=>'cannabis'),
array('fal fa-capsules'=>'capsules'),
array('fal fa-car'=>'car'),
array('fal fa-car-alt'=>'car-alt'),
array('fal fa-car-battery'=>'car-battery'),
array('fal fa-car-building'=>'car-building'),
array('fal fa-car-bump'=>'car-bump'),
array('fal fa-car-bus'=>'car-bus'),
array('fal fa-car-crash'=>'car-crash'),
array('fal fa-car-garage'=>'car-garage'),
array('fal fa-car-mechanic'=>'car-mechanic'),
array('fal fa-car-side'=>'car-side'),
array('fal fa-car-tilt'=>'car-tilt'),
array('fal fa-car-wash'=>'car-wash'),
array('fal fa-caravan'=>'caravan'),
array('fal fa-caravan-alt'=>'caravan-alt'),
array('fal fa-caret-circle-down'=>'caret-circle-down'),
array('fal fa-caret-circle-left'=>'caret-circle-left'),
array('fal fa-caret-circle-right'=>'caret-circle-right'),
array('fal fa-caret-circle-up'=>'caret-circle-up'),
array('fal fa-caret-down'=>'caret-down'),
array('fal fa-caret-left'=>'caret-left'),
array('fal fa-caret-right'=>'caret-right'),
array('fal fa-caret-square-down'=>'caret-square-down'),
array('fal fa-caret-square-left'=>'caret-square-left'),
array('fal fa-caret-square-right'=>'caret-square-right'),
array('fal fa-caret-square-up'=>'caret-square-up'),
array('fal fa-caret-up'=>'caret-up'),
array('fal fa-carrot'=>'carrot'),
array('fal fa-cars'=>'cars'),
array('fal fa-cart-arrow-down'=>'cart-arrow-down'),
array('fal fa-cart-plus'=>'cart-plus'),
array('fal fa-cash-register'=>'cash-register'),
array('fal fa-cassette-tape'=>'cassette-tape'),
array('fal fa-cat'=>'cat'),
array('fal fa-cat-space'=>'cat-space'),
array('fal fa-cauldron'=>'cauldron'),
array('fal fa-cctv'=>'cctv'),
array('fal fa-certificate'=>'certificate'),
array('fal fa-chair'=>'chair'),
array('fal fa-chair-office'=>'chair-office'),
array('fal fa-chalkboard'=>'chalkboard'),
array('fal fa-chalkboard-teacher'=>'chalkboard-teacher'),
array('fal fa-charging-station'=>'charging-station'),
array('fal fa-chart-area'=>'chart-area'),
array('fal fa-chart-bar'=>'chart-bar'),
array('fal fa-chart-line'=>'chart-line'),
array('fal fa-chart-line-down'=>'chart-line-down'),
array('fal fa-chart-network'=>'chart-network'),
array('fal fa-chart-pie'=>'chart-pie'),
array('fal fa-chart-pie-alt'=>'chart-pie-alt'),
array('fal fa-chart-scatter'=>'chart-scatter'),
array('fal fa-check'=>'check'),
array('fal fa-check-circle'=>'check-circle'),
array('fal fa-check-double'=>'check-double'),
array('fal fa-check-square'=>'check-square'),
array('fal fa-cheese'=>'cheese'),
array('fal fa-cheese-swiss'=>'cheese-swiss'),
array('fal fa-cheeseburger'=>'cheeseburger'),
array('fal fa-chess'=>'chess'),
array('fal fa-chess-bishop'=>'chess-bishop'),
array('fal fa-chess-bishop-alt'=>'chess-bishop-alt'),
array('fal fa-chess-board'=>'chess-board'),
array('fal fa-chess-clock'=>'chess-clock'),
array('fal fa-chess-clock-alt'=>'chess-clock-alt'),
array('fal fa-chess-king'=>'chess-king'),
array('fal fa-chess-king-alt'=>'chess-king-alt'),
array('fal fa-chess-knight'=>'chess-knight'),
array('fal fa-chess-knight-alt'=>'chess-knight-alt'),
array('fal fa-chess-pawn'=>'chess-pawn'),
array('fal fa-chess-pawn-alt'=>'chess-pawn-alt'),
array('fal fa-chess-queen'=>'chess-queen'),
array('fal fa-chess-queen-alt'=>'chess-queen-alt'),
array('fal fa-chess-rook'=>'chess-rook'),
array('fal fa-chess-rook-alt'=>'chess-rook-alt'),
array('fal fa-chevron-circle-down'=>'chevron-circle-down'),
array('fal fa-chevron-circle-left'=>'chevron-circle-left'),
array('fal fa-chevron-circle-right'=>'chevron-circle-right'),
array('fal fa-chevron-circle-up'=>'chevron-circle-up'),
array('fal fa-chevron-double-down'=>'chevron-double-down'),
array('fal fa-chevron-double-left'=>'chevron-double-left'),
array('fal fa-chevron-double-right'=>'chevron-double-right'),
array('fal fa-chevron-double-up'=>'chevron-double-up'),
array('fal fa-chevron-down'=>'chevron-down'),
array('fal fa-chevron-left'=>'chevron-left'),
array('fal fa-chevron-right'=>'chevron-right'),
array('fal fa-chevron-square-down'=>'chevron-square-down'),
array('fal fa-chevron-square-left'=>'chevron-square-left'),
array('fal fa-chevron-square-right'=>'chevron-square-right'),
array('fal fa-chevron-square-up'=>'chevron-square-up'),
array('fal fa-chevron-up'=>'chevron-up'),
array('fal fa-child'=>'child'),
array('fal fa-chimney'=>'chimney'),
array('fal fa-church'=>'church'),
array('fal fa-circle'=>'circle'),
array('fal fa-circle-notch'=>'circle-notch'),
array('fal fa-city'=>'city'),
array('fal fa-clarinet'=>'clarinet'),
array('fal fa-claw-marks'=>'claw-marks'),
array('fal fa-clinic-medical'=>'clinic-medical'),
array('fal fa-clipboard'=>'clipboard'),
array('fal fa-clipboard-check'=>'clipboard-check'),
array('fal fa-clipboard-list'=>'clipboard-list'),
array('fal fa-clipboard-list-check'=>'clipboard-list-check'),
array('fal fa-clipboard-prescription'=>'clipboard-prescription'),
array('fal fa-clipboard-user'=>'clipboard-user'),
array('fal fa-clock'=>'clock'),
array('fal fa-clone'=>'clone'),
array('fal fa-closed-captioning'=>'closed-captioning'),
array('fal fa-cloud'=>'cloud'),
array('fal fa-cloud-download'=>'cloud-download'),
array('fal fa-cloud-download-alt'=>'cloud-download-alt'),
array('fal fa-cloud-drizzle'=>'cloud-drizzle'),
array('fal fa-cloud-hail'=>'cloud-hail'),
array('fal fa-cloud-hail-mixed'=>'cloud-hail-mixed'),
array('fal fa-cloud-meatball'=>'cloud-meatball'),
array('fal fa-cloud-moon'=>'cloud-moon'),
array('fal fa-cloud-moon-rain'=>'cloud-moon-rain'),
array('fal fa-cloud-music'=>'cloud-music'),
array('fal fa-cloud-rain'=>'cloud-rain'),
array('fal fa-cloud-rainbow'=>'cloud-rainbow'),
array('fal fa-cloud-showers'=>'cloud-showers'),
array('fal fa-cloud-showers-heavy'=>'cloud-showers-heavy'),
array('fal fa-cloud-sleet'=>'cloud-sleet'),
array('fal fa-cloud-snow'=>'cloud-snow'),
array('fal fa-cloud-sun'=>'cloud-sun'),
array('fal fa-cloud-sun-rain'=>'cloud-sun-rain'),
array('fal fa-cloud-upload'=>'cloud-upload'),
array('fal fa-cloud-upload-alt'=>'cloud-upload-alt'),
array('fal fa-clouds'=>'clouds'),
array('fal fa-clouds-moon'=>'clouds-moon'),
array('fal fa-clouds-sun'=>'clouds-sun'),
array('fal fa-club'=>'club'),
array('fal fa-cocktail'=>'cocktail'),
array('fal fa-code'=>'code'),
array('fal fa-code-branch'=>'code-branch'),
array('fal fa-code-commit'=>'code-commit'),
array('fal fa-code-merge'=>'code-merge'),
array('fal fa-coffee'=>'coffee'),
array('fal fa-coffee-pot'=>'coffee-pot'),
array('fal fa-coffee-togo'=>'coffee-togo'),
array('fal fa-coffin'=>'coffin'),
array('fal fa-coffin-cross'=>'coffin-cross'),
array('fal fa-cog'=>'cog'),
array('fal fa-cogs'=>'cogs'),
array('fal fa-coin'=>'coin'),
array('fal fa-coins'=>'coins'),
array('fal fa-columns'=>'columns'),
array('fal fa-comet'=>'comet'),
array('fal fa-comment'=>'comment'),
array('fal fa-comment-alt'=>'comment-alt'),
array('fal fa-comment-alt-check'=>'comment-alt-check'),
array('fal fa-comment-alt-dollar'=>'comment-alt-dollar'),
array('fal fa-comment-alt-dots'=>'comment-alt-dots'),
array('fal fa-comment-alt-edit'=>'comment-alt-edit'),
array('fal fa-comment-alt-exclamation'=>'comment-alt-exclamation'),
array('fal fa-comment-alt-lines'=>'comment-alt-lines'),
array('fal fa-comment-alt-medical'=>'comment-alt-medical'),
array('fal fa-comment-alt-minus'=>'comment-alt-minus'),
array('fal fa-comment-alt-music'=>'comment-alt-music'),
array('fal fa-comment-alt-plus'=>'comment-alt-plus'),
array('fal fa-comment-alt-slash'=>'comment-alt-slash'),
array('fal fa-comment-alt-smile'=>'comment-alt-smile'),
array('fal fa-comment-alt-times'=>'comment-alt-times'),
array('fal fa-comment-check'=>'comment-check'),
array('fal fa-comment-dollar'=>'comment-dollar'),
array('fal fa-comment-dots'=>'comment-dots'),
array('fal fa-comment-edit'=>'comment-edit'),
array('fal fa-comment-exclamation'=>'comment-exclamation'),
array('fal fa-comment-lines'=>'comment-lines'),
array('fal fa-comment-medical'=>'comment-medical'),
array('fal fa-comment-minus'=>'comment-minus'),
array('fal fa-comment-music'=>'comment-music'),
array('fal fa-comment-plus'=>'comment-plus'),
array('fal fa-comment-slash'=>'comment-slash'),
array('fal fa-comment-smile'=>'comment-smile'),
array('fal fa-comment-times'=>'comment-times'),
array('fal fa-comments'=>'comments'),
array('fal fa-comments-alt'=>'comments-alt'),
array('fal fa-comments-alt-dollar'=>'comments-alt-dollar'),
array('fal fa-comments-dollar'=>'comments-dollar'),
array('fal fa-compact-disc'=>'compact-disc'),
array('fal fa-compass'=>'compass'),
array('fal fa-compass-slash'=>'compass-slash'),
array('fal fa-compress'=>'compress'),
array('fal fa-compress-alt'=>'compress-alt'),
array('fal fa-compress-arrows-alt'=>'compress-arrows-alt'),
array('fal fa-compress-wide'=>'compress-wide'),
array('fal fa-computer-classic'=>'computer-classic'),
array('fal fa-computer-speaker'=>'computer-speaker'),
array('fal fa-concierge-bell'=>'concierge-bell'),
array('fal fa-construction'=>'construction'),
array('fal fa-container-storage'=>'container-storage'),
array('fal fa-conveyor-belt'=>'conveyor-belt'),
array('fal fa-conveyor-belt-alt'=>'conveyor-belt-alt'),
array('fal fa-cookie'=>'cookie'),
array('fal fa-cookie-bite'=>'cookie-bite'),
array('fal fa-copy'=>'copy'),
array('fal fa-copyright'=>'copyright'),
array('fal fa-corn'=>'corn'),
array('fal fa-couch'=>'couch'),
array('fal fa-cow'=>'cow'),
array('fal fa-cowbell'=>'cowbell'),
array('fal fa-cowbell-more'=>'cowbell-more'),
array('fal fa-credit-card'=>'credit-card'),
array('fal fa-credit-card-blank'=>'credit-card-blank'),
array('fal fa-credit-card-front'=>'credit-card-front'),
array('fal fa-cricket'=>'cricket'),
array('fal fa-croissant'=>'croissant'),
array('fal fa-crop'=>'crop'),
array('fal fa-crop-alt'=>'crop-alt'),
array('fal fa-cross'=>'cross'),
array('fal fa-crosshairs'=>'crosshairs'),
array('fal fa-crow'=>'crow'),
array('fal fa-crown'=>'crown'),
array('fal fa-crutch'=>'crutch'),
array('fal fa-crutches'=>'crutches'),
array('fal fa-cube'=>'cube'),
array('fal fa-cubes'=>'cubes'),
array('fal fa-curling'=>'curling'),
array('fal fa-cut'=>'cut'),
array('fal fa-dagger'=>'dagger'),
array('fal fa-database'=>'database'),
array('fal fa-deaf'=>'deaf'),
array('fal fa-debug'=>'debug'),
array('fal fa-deer'=>'deer'),
array('fal fa-deer-rudolph'=>'deer-rudolph'),
array('fal fa-democrat'=>'democrat'),
array('fal fa-desktop'=>'desktop'),
array('fal fa-desktop-alt'=>'desktop-alt'),
array('fal fa-dewpoint'=>'dewpoint'),
array('fal fa-dharmachakra'=>'dharmachakra'),
array('fal fa-diagnoses'=>'diagnoses'),
array('fal fa-diamond'=>'diamond'),
array('fal fa-dice'=>'dice'),
array('fal fa-dice-d10'=>'dice-d10'),
array('fal fa-dice-d12'=>'dice-d12'),
array('fal fa-dice-d20'=>'dice-d20'),
array('fal fa-dice-d4'=>'dice-d4'),
array('fal fa-dice-d6'=>'dice-d6'),
array('fal fa-dice-d8'=>'dice-d8'),
array('fal fa-dice-five'=>'dice-five'),
array('fal fa-dice-four'=>'dice-four'),
array('fal fa-dice-one'=>'dice-one'),
array('fal fa-dice-six'=>'dice-six'),
array('fal fa-dice-three'=>'dice-three'),
array('fal fa-dice-two'=>'dice-two'),
array('fal fa-digging'=>'digging'),
array('fal fa-digital-tachograph'=>'digital-tachograph'),
array('fal fa-diploma'=>'diploma'),
array('fal fa-directions'=>'directions'),
array('fal fa-disc-drive'=>'disc-drive'),
array('fal fa-disease'=>'disease'),
array('fal fa-divide'=>'divide'),
array('fal fa-dizzy'=>'dizzy'),
array('fal fa-dna'=>'dna'),
array('fal fa-do-not-enter'=>'do-not-enter'),
array('fal fa-dog'=>'dog'),
array('fal fa-dog-leashed'=>'dog-leashed'),
array('fal fa-dollar-sign'=>'dollar-sign'),
array('fal fa-dolly'=>'dolly'),
array('fal fa-dolly-empty'=>'dolly-empty'),
array('fal fa-dolly-flatbed'=>'dolly-flatbed'),
array('fal fa-dolly-flatbed-alt'=>'dolly-flatbed-alt'),
array('fal fa-dolly-flatbed-empty'=>'dolly-flatbed-empty'),
array('fal fa-donate'=>'donate'),
array('fal fa-door-closed'=>'door-closed'),
array('fal fa-door-open'=>'door-open'),
array('fal fa-dot-circle'=>'dot-circle'),
array('fal fa-dove'=>'dove'),
array('fal fa-download'=>'download'),
array('fal fa-drafting-compass'=>'drafting-compass'),
array('fal fa-dragon'=>'dragon'),
array('fal fa-draw-circle'=>'draw-circle'),
array('fal fa-draw-polygon'=>'draw-polygon'),
array('fal fa-draw-square'=>'draw-square'),
array('fal fa-dreidel'=>'dreidel'),
array('fal fa-drone'=>'drone'),
array('fal fa-drone-alt'=>'drone-alt'),
array('fal fa-drum'=>'drum'),
array('fal fa-drum-steelpan'=>'drum-steelpan'),
array('fal fa-drumstick'=>'drumstick'),
array('fal fa-drumstick-bite'=>'drumstick-bite'),
array('fal fa-dryer'=>'dryer'),
array('fal fa-dryer-alt'=>'dryer-alt'),
array('fal fa-duck'=>'duck'),
array('fal fa-dumbbell'=>'dumbbell'),
array('fal fa-dumpster'=>'dumpster'),
array('fal fa-dumpster-fire'=>'dumpster-fire'),
array('fal fa-dungeon'=>'dungeon'),
array('fal fa-ear'=>'ear'),
array('fal fa-ear-muffs'=>'ear-muffs'),
array('fal fa-eclipse'=>'eclipse'),
array('fal fa-eclipse-alt'=>'eclipse-alt'),
array('fal fa-edit'=>'edit'),
array('fal fa-egg'=>'egg'),
array('fal fa-egg-fried'=>'egg-fried'),
array('fal fa-eject'=>'eject'),
array('fal fa-elephant'=>'elephant'),
array('fal fa-ellipsis-h'=>'ellipsis-h'),
array('fal fa-ellipsis-h-alt'=>'ellipsis-h-alt'),
array('fal fa-ellipsis-v'=>'ellipsis-v'),
array('fal fa-ellipsis-v-alt'=>'ellipsis-v-alt'),
array('fal fa-empty-set'=>'empty-set'),
array('fal fa-engine-warning'=>'engine-warning'),
array('fal fa-envelope'=>'envelope'),
array('fal fa-envelope-open'=>'envelope-open'),
array('fal fa-envelope-open-dollar'=>'envelope-open-dollar'),
array('fal fa-envelope-open-text'=>'envelope-open-text'),
array('fal fa-envelope-square'=>'envelope-square'),
array('fal fa-equals'=>'equals'),
array('fal fa-eraser'=>'eraser'),
array('fal fa-ethernet'=>'ethernet'),
array('fal fa-euro-sign'=>'euro-sign'),
array('fal fa-exchange'=>'exchange'),
array('fal fa-exchange-alt'=>'exchange-alt'),
array('fal fa-exclamation'=>'exclamation'),
array('fal fa-exclamation-circle'=>'exclamation-circle'),
array('fal fa-exclamation-square'=>'exclamation-square'),
array('fal fa-exclamation-triangle'=>'exclamation-triangle'),
array('fal fa-expand'=>'expand'),
array('fal fa-expand-alt'=>'expand-alt'),
array('fal fa-expand-arrows'=>'expand-arrows'),
array('fal fa-expand-arrows-alt'=>'expand-arrows-alt'),
array('fal fa-expand-wide'=>'expand-wide'),
array('fal fa-external-link'=>'external-link'),
array('fal fa-external-link-alt'=>'external-link-alt'),
array('fal fa-external-link-square'=>'external-link-square'),
array('fal fa-external-link-square-alt'=>'external-link-square-alt'),
array('fal fa-eye'=>'eye'),
array('fal fa-eye-dropper'=>'eye-dropper'),
array('fal fa-eye-evil'=>'eye-evil'),
array('fal fa-eye-slash'=>'eye-slash'),
array('fal fa-fan'=>'fan'),
array('fal fa-fan-table'=>'fan-table'),
array('fal fa-farm'=>'farm'),
array('fal fa-fast-backward'=>'fast-backward'),
array('fal fa-fast-forward'=>'fast-forward'),
array('fal fa-faucet'=>'faucet'),
array('fal fa-faucet-drip'=>'faucet-drip'),
array('fal fa-fax'=>'fax'),
array('fal fa-feather'=>'feather'),
array('fal fa-feather-alt'=>'feather-alt'),
array('fal fa-female'=>'female'),
array('fal fa-field-hockey'=>'field-hockey'),
array('fal fa-fighter-jet'=>'fighter-jet'),
array('fal fa-file'=>'file'),
array('fal fa-file-alt'=>'file-alt'),
array('fal fa-file-archive'=>'file-archive'),
array('fal fa-file-audio'=>'file-audio'),
array('fal fa-file-certificate'=>'file-certificate'),
array('fal fa-file-chart-line'=>'file-chart-line'),
array('fal fa-file-chart-pie'=>'file-chart-pie'),
array('fal fa-file-check'=>'file-check'),
array('fal fa-file-code'=>'file-code'),
array('fal fa-file-contract'=>'file-contract'),
array('fal fa-file-csv'=>'file-csv'),
array('fal fa-file-download'=>'file-download'),
array('fal fa-file-edit'=>'file-edit'),
array('fal fa-file-excel'=>'file-excel'),
array('fal fa-file-exclamation'=>'file-exclamation'),
array('fal fa-file-export'=>'file-export'),
array('fal fa-file-image'=>'file-image'),
array('fal fa-file-import'=>'file-import'),
array('fal fa-file-invoice'=>'file-invoice'),
array('fal fa-file-invoice-dollar'=>'file-invoice-dollar'),
array('fal fa-file-medical'=>'file-medical'),
array('fal fa-file-medical-alt'=>'file-medical-alt'),
array('fal fa-file-minus'=>'file-minus'),
array('fal fa-file-music'=>'file-music'),
array('fal fa-file-pdf'=>'file-pdf'),
array('fal fa-file-plus'=>'file-plus'),
array('fal fa-file-powerpoint'=>'file-powerpoint'),
array('fal fa-file-prescription'=>'file-prescription'),
array('fal fa-file-search'=>'file-search'),
array('fal fa-file-signature'=>'file-signature'),
array('fal fa-file-spreadsheet'=>'file-spreadsheet'),
array('fal fa-file-times'=>'file-times'),
array('fal fa-file-upload'=>'file-upload'),
array('fal fa-file-user'=>'file-user'),
array('fal fa-file-video'=>'file-video'),
array('fal fa-file-word'=>'file-word'),
array('fal fa-files-medical'=>'files-medical'),
array('fal fa-fill'=>'fill'),
array('fal fa-fill-drip'=>'fill-drip'),
array('fal fa-film'=>'film'),
array('fal fa-film-alt'=>'film-alt'),
array('fal fa-film-canister'=>'film-canister'),
array('fal fa-filter'=>'filter'),
array('fal fa-fingerprint'=>'fingerprint'),
array('fal fa-fire'=>'fire'),
array('fal fa-fire-alt'=>'fire-alt'),
array('fal fa-fire-extinguisher'=>'fire-extinguisher'),
array('fal fa-fire-smoke'=>'fire-smoke'),
array('fal fa-fireplace'=>'fireplace'),
array('fal fa-first-aid'=>'first-aid'),
array('fal fa-fish'=>'fish'),
array('fal fa-fish-cooked'=>'fish-cooked'),
array('fal fa-fist-raised'=>'fist-raised'),
array('fal fa-flag'=>'flag'),
array('fal fa-flag-alt'=>'flag-alt'),
array('fal fa-flag-checkered'=>'flag-checkered'),
array('fal fa-flag-usa'=>'flag-usa'),
array('fal fa-flame'=>'flame'),
array('fal fa-flashlight'=>'flashlight'),
array('fal fa-flask'=>'flask'),
array('fal fa-flask-poison'=>'flask-poison'),
array('fal fa-flask-potion'=>'flask-potion'),
array('fal fa-flower'=>'flower'),
array('fal fa-flower-daffodil'=>'flower-daffodil'),
array('fal fa-flower-tulip'=>'flower-tulip'),
array('fal fa-flushed'=>'flushed'),
array('fal fa-flute'=>'flute'),
array('fal fa-flux-capacitor'=>'flux-capacitor'),
array('fal fa-fog'=>'fog'),
array('fal fa-folder'=>'folder'),
array('fal fa-folder-download'=>'folder-download'),
array('fal fa-folder-minus'=>'folder-minus'),
array('fal fa-folder-open'=>'folder-open'),
array('fal fa-folder-plus'=>'folder-plus'),
array('fal fa-folder-times'=>'folder-times'),
array('fal fa-folder-tree'=>'folder-tree'),
array('fal fa-folder-upload'=>'folder-upload'),
array('fal fa-folders'=>'folders'),
array('fal fa-font'=>'font'),
array('fal fa-font-case'=>'font-case'),
array('fal fa-football-ball'=>'football-ball'),
array('fal fa-football-helmet'=>'football-helmet'),
array('fal fa-forklift'=>'forklift'),
array('fal fa-forward'=>'forward'),
array('fal fa-fragile'=>'fragile'),
array('fal fa-french-fries'=>'french-fries'),
array('fal fa-frog'=>'frog'),
array('fal fa-frosty-head'=>'frosty-head'),
array('fal fa-frown'=>'frown'),
array('fal fa-frown-open'=>'frown-open'),
array('fal fa-function'=>'function'),
array('fal fa-funnel-dollar'=>'funnel-dollar'),
array('fal fa-futbol'=>'futbol'),
array('fal fa-galaxy'=>'galaxy'),
array('fal fa-game-board'=>'game-board'),
array('fal fa-game-board-alt'=>'game-board-alt'),
array('fal fa-game-console-handheld'=>'game-console-handheld'),
array('fal fa-gamepad'=>'gamepad'),
array('fal fa-gamepad-alt'=>'gamepad-alt'),
array('fal fa-garage'=>'garage'),
array('fal fa-garage-car'=>'garage-car'),
array('fal fa-garage-open'=>'garage-open'),
array('fal fa-gas-pump'=>'gas-pump'),
array('fal fa-gas-pump-slash'=>'gas-pump-slash'),
array('fal fa-gavel'=>'gavel'),
array('fal fa-gem'=>'gem'),
array('fal fa-genderless'=>'genderless'),
array('fal fa-ghost'=>'ghost'),
array('fal fa-gift'=>'gift'),
array('fal fa-gift-card'=>'gift-card'),
array('fal fa-gifts'=>'gifts'),
array('fal fa-gingerbread-man'=>'gingerbread-man'),
array('fal fa-glass'=>'glass'),
array('fal fa-glass-champagne'=>'glass-champagne'),
array('fal fa-glass-cheers'=>'glass-cheers'),
array('fal fa-glass-citrus'=>'glass-citrus'),
array('fal fa-glass-martini'=>'glass-martini'),
array('fal fa-glass-martini-alt'=>'glass-martini-alt'),
array('fal fa-glass-whiskey'=>'glass-whiskey'),
array('fal fa-glass-whiskey-rocks'=>'glass-whiskey-rocks'),
array('fal fa-glasses'=>'glasses'),
array('fal fa-glasses-alt'=>'glasses-alt'),
array('fal fa-globe'=>'globe'),
array('fal fa-globe-africa'=>'globe-africa'),
array('fal fa-globe-americas'=>'globe-americas'),
array('fal fa-globe-asia'=>'globe-asia'),
array('fal fa-globe-europe'=>'globe-europe'),
array('fal fa-globe-snow'=>'globe-snow'),
array('fal fa-globe-stand'=>'globe-stand'),
array('fal fa-golf-ball'=>'golf-ball'),
array('fal fa-golf-club'=>'golf-club'),
array('fal fa-gopuram'=>'gopuram'),
array('fal fa-graduation-cap'=>'graduation-cap'),
array('fal fa-gramophone'=>'gramophone'),
array('fal fa-greater-than'=>'greater-than'),
array('fal fa-greater-than-equal'=>'greater-than-equal'),
array('fal fa-grimace'=>'grimace'),
array('fal fa-grin'=>'grin'),
array('fal fa-grin-alt'=>'grin-alt'),
array('fal fa-grin-beam'=>'grin-beam'),
array('fal fa-grin-beam-sweat'=>'grin-beam-sweat'),
array('fal fa-grin-hearts'=>'grin-hearts'),
array('fal fa-grin-squint'=>'grin-squint'),
array('fal fa-grin-squint-tears'=>'grin-squint-tears'),
array('fal fa-grin-stars'=>'grin-stars'),
array('fal fa-grin-tears'=>'grin-tears'),
array('fal fa-grin-tongue'=>'grin-tongue'),
array('fal fa-grin-tongue-squint'=>'grin-tongue-squint'),
array('fal fa-grin-tongue-wink'=>'grin-tongue-wink'),
array('fal fa-grin-wink'=>'grin-wink'),
array('fal fa-grip-horizontal'=>'grip-horizontal'),
array('fal fa-grip-lines'=>'grip-lines'),
array('fal fa-grip-lines-vertical'=>'grip-lines-vertical'),
array('fal fa-grip-vertical'=>'grip-vertical'),
array('fal fa-guitar'=>'guitar'),
array('fal fa-guitar-electric'=>'guitar-electric'),
array('fal fa-guitars'=>'guitars'),
array('fal fa-h-square'=>'h-square'),
array('fal fa-h1'=>'h1'),
array('fal fa-h2'=>'h2'),
array('fal fa-h3'=>'h3'),
array('fal fa-h4'=>'h4'),
array('fal fa-hamburger'=>'hamburger'),
array('fal fa-hammer'=>'hammer'),
array('fal fa-hammer-war'=>'hammer-war'),
array('fal fa-hamsa'=>'hamsa'),
array('fal fa-hand-heart'=>'hand-heart'),
array('fal fa-hand-holding'=>'hand-holding'),
array('fal fa-hand-holding-box'=>'hand-holding-box'),
array('fal fa-hand-holding-heart'=>'hand-holding-heart'),
array('fal fa-hand-holding-magic'=>'hand-holding-magic'),
array('fal fa-hand-holding-seedling'=>'hand-holding-seedling'),
array('fal fa-hand-holding-usd'=>'hand-holding-usd'),
array('fal fa-hand-holding-water'=>'hand-holding-water'),
array('fal fa-hand-lizard'=>'hand-lizard'),
array('fal fa-hand-middle-finger'=>'hand-middle-finger'),
array('fal fa-hand-paper'=>'hand-paper'),
array('fal fa-hand-peace'=>'hand-peace'),
array('fal fa-hand-point-down'=>'hand-point-down'),
array('fal fa-hand-point-left'=>'hand-point-left'),
array('fal fa-hand-point-right'=>'hand-point-right'),
array('fal fa-hand-point-up'=>'hand-point-up'),
array('fal fa-hand-pointer'=>'hand-pointer'),
array('fal fa-hand-receiving'=>'hand-receiving'),
array('fal fa-hand-rock'=>'hand-rock'),
array('fal fa-hand-scissors'=>'hand-scissors'),
array('fal fa-hand-spock'=>'hand-spock'),
array('fal fa-hands'=>'hands'),
array('fal fa-hands-heart'=>'hands-heart'),
array('fal fa-hands-helping'=>'hands-helping'),
array('fal fa-hands-usd'=>'hands-usd'),
array('fal fa-handshake'=>'handshake'),
array('fal fa-handshake-alt'=>'handshake-alt'),
array('fal fa-hanukiah'=>'hanukiah'),
array('fal fa-hard-hat'=>'hard-hat'),
array('fal fa-hashtag'=>'hashtag'),
array('fal fa-hat-chef'=>'hat-chef'),
array('fal fa-hat-cowboy'=>'hat-cowboy'),
array('fal fa-hat-cowboy-side'=>'hat-cowboy-side'),
array('fal fa-hat-santa'=>'hat-santa'),
array('fal fa-hat-winter'=>'hat-winter'),
array('fal fa-hat-witch'=>'hat-witch'),
array('fal fa-hat-wizard'=>'hat-wizard'),
array('fal fa-hdd'=>'hdd'),
array('fal fa-head-side'=>'head-side'),
array('fal fa-head-side-brain'=>'head-side-brain'),
array('fal fa-head-side-headphones'=>'head-side-headphones'),
array('fal fa-head-side-medical'=>'head-side-medical'),
array('fal fa-head-vr'=>'head-vr'),
array('fal fa-heading'=>'heading'),
array('fal fa-headphones'=>'headphones'),
array('fal fa-headphones-alt'=>'headphones-alt'),
array('fal fa-headset'=>'headset'),
array('fal fa-heart'=>'heart'),
array('fal fa-heart-broken'=>'heart-broken'),
array('fal fa-heart-circle'=>'heart-circle'),
array('fal fa-heart-rate'=>'heart-rate'),
array('fal fa-heart-square'=>'heart-square'),
array('fal fa-heartbeat'=>'heartbeat'),
array('fal fa-heat'=>'heat'),
array('fal fa-helicopter'=>'helicopter'),
array('fal fa-helmet-battle'=>'helmet-battle'),
array('fal fa-hexagon'=>'hexagon'),
array('fal fa-highlighter'=>'highlighter'),
array('fal fa-hiking'=>'hiking'),
array('fal fa-hippo'=>'hippo'),
array('fal fa-history'=>'history'),
array('fal fa-hockey-mask'=>'hockey-mask'),
array('fal fa-hockey-puck'=>'hockey-puck'),
array('fal fa-hockey-sticks'=>'hockey-sticks'),
array('fal fa-holly-berry'=>'holly-berry'),
array('fal fa-home'=>'home'),
array('fal fa-home-alt'=>'home-alt'),
array('fal fa-home-heart'=>'home-heart'),
array('fal fa-home-lg'=>'home-lg'),
array('fal fa-home-lg-alt'=>'home-lg-alt'),
array('fal fa-hood-cloak'=>'hood-cloak'),
array('fal fa-horizontal-rule'=>'horizontal-rule'),
array('fal fa-horse'=>'horse'),
array('fal fa-horse-head'=>'horse-head'),
array('fal fa-horse-saddle'=>'horse-saddle'),
array('fal fa-hospital'=>'hospital'),
array('fal fa-hospital-alt'=>'hospital-alt'),
array('fal fa-hospital-symbol'=>'hospital-symbol'),
array('fal fa-hospital-user'=>'hospital-user'),
array('fal fa-hospitals'=>'hospitals'),
array('fal fa-hot-tub'=>'hot-tub'),
array('fal fa-hotdog'=>'hotdog'),
array('fal fa-hotel'=>'hotel'),
array('fal fa-hourglass'=>'hourglass'),
array('fal fa-hourglass-end'=>'hourglass-end'),
array('fal fa-hourglass-half'=>'hourglass-half'),
array('fal fa-hourglass-start'=>'hourglass-start'),
array('fal fa-house'=>'house'),
array('fal fa-house-damage'=>'house-damage'),
array('fal fa-house-day'=>'house-day'),
array('fal fa-house-flood'=>'house-flood'),
array('fal fa-house-leave'=>'house-leave'),
array('fal fa-house-night'=>'house-night'),
array('fal fa-house-return'=>'house-return'),
array('fal fa-house-signal'=>'house-signal'),
array('fal fa-hryvnia'=>'hryvnia'),
array('fal fa-humidity'=>'humidity'),
array('fal fa-hurricane'=>'hurricane'),
array('fal fa-i-cursor'=>'i-cursor'),
array('fal fa-ice-cream'=>'ice-cream'),
array('fal fa-ice-skate'=>'ice-skate'),
array('fal fa-icicles'=>'icicles'),
array('fal fa-icons'=>'icons'),
array('fal fa-icons-alt'=>'icons-alt'),
array('fal fa-id-badge'=>'id-badge'),
array('fal fa-id-card'=>'id-card'),
array('fal fa-id-card-alt'=>'id-card-alt'),
array('fal fa-igloo'=>'igloo'),
array('fal fa-image'=>'image'),
array('fal fa-image-polaroid'=>'image-polaroid'),
array('fal fa-images'=>'images'),
array('fal fa-inbox'=>'inbox'),
array('fal fa-inbox-in'=>'inbox-in'),
array('fal fa-inbox-out'=>'inbox-out'),
array('fal fa-indent'=>'indent'),
array('fal fa-industry'=>'industry'),
array('fal fa-industry-alt'=>'industry-alt'),
array('fal fa-infinity'=>'infinity'),
array('fal fa-info'=>'info'),
array('fal fa-info-circle'=>'info-circle'),
array('fal fa-info-square'=>'info-square'),
array('fal fa-inhaler'=>'inhaler'),
array('fal fa-integral'=>'integral'),
array('fal fa-intersection'=>'intersection'),
array('fal fa-inventory'=>'inventory'),
array('fal fa-island-tropical'=>'island-tropical'),
array('fal fa-italic'=>'italic'),
array('fal fa-jack-o-lantern'=>'jack-o-lantern'),
array('fal fa-jedi'=>'jedi'),
array('fal fa-joint'=>'joint'),
array('fal fa-journal-whills'=>'journal-whills'),
array('fal fa-joystick'=>'joystick'),
array('fal fa-jug'=>'jug'),
array('fal fa-kaaba'=>'kaaba'),
array('fal fa-kazoo'=>'kazoo'),
array('fal fa-kerning'=>'kerning'),
array('fal fa-key'=>'key'),
array('fal fa-key-skeleton'=>'key-skeleton'),
array('fal fa-keyboard'=>'keyboard'),
array('fal fa-keynote'=>'keynote'),
array('fal fa-khanda'=>'khanda'),
array('fal fa-kidneys'=>'kidneys'),
array('fal fa-kiss'=>'kiss'),
array('fal fa-kiss-beam'=>'kiss-beam'),
array('fal fa-kiss-wink-heart'=>'kiss-wink-heart'),
array('fal fa-kite'=>'kite'),
array('fal fa-kiwi-bird'=>'kiwi-bird'),
array('fal fa-knife-kitchen'=>'knife-kitchen'),
array('fal fa-lambda'=>'lambda'),
array('fal fa-lamp'=>'lamp'),
array('fal fa-lamp-desk'=>'lamp-desk'),
array('fal fa-lamp-floor'=>'lamp-floor'),
array('fal fa-landmark'=>'landmark'),
array('fal fa-landmark-alt'=>'landmark-alt'),
array('fal fa-language'=>'language'),
array('fal fa-laptop'=>'laptop'),
array('fal fa-laptop-code'=>'laptop-code'),
array('fal fa-laptop-medical'=>'laptop-medical'),
array('fal fa-lasso'=>'lasso'),
array('fal fa-laugh'=>'laugh'),
array('fal fa-laugh-beam'=>'laugh-beam'),
array('fal fa-laugh-squint'=>'laugh-squint'),
array('fal fa-laugh-wink'=>'laugh-wink'),
array('fal fa-layer-group'=>'layer-group'),
array('fal fa-layer-minus'=>'layer-minus'),
array('fal fa-layer-plus'=>'layer-plus'),
array('fal fa-leaf'=>'leaf'),
array('fal fa-leaf-heart'=>'leaf-heart'),
array('fal fa-leaf-maple'=>'leaf-maple'),
array('fal fa-leaf-oak'=>'leaf-oak'),
array('fal fa-lemon'=>'lemon'),
array('fal fa-less-than'=>'less-than'),
array('fal fa-less-than-equal'=>'less-than-equal'),
array('fal fa-level-down'=>'level-down'),
array('fal fa-level-down-alt'=>'level-down-alt'),
array('fal fa-level-up'=>'level-up'),
array('fal fa-level-up-alt'=>'level-up-alt'),
array('fal fa-life-ring'=>'life-ring'),
array('fal fa-light-ceiling'=>'light-ceiling'),
array('fal fa-light-switch'=>'light-switch'),
array('fal fa-light-switch-off'=>'light-switch-off'),
array('fal fa-light-switch-on'=>'light-switch-on'),
array('fal fa-lightbulb'=>'lightbulb'),
array('fal fa-lightbulb-dollar'=>'lightbulb-dollar'),
array('fal fa-lightbulb-exclamation'=>'lightbulb-exclamation'),
array('fal fa-lightbulb-on'=>'lightbulb-on'),
array('fal fa-lightbulb-slash'=>'lightbulb-slash'),
array('fal fa-lights-holiday'=>'lights-holiday'),
array('fal fa-line-columns'=>'line-columns'),
array('fal fa-line-height'=>'line-height'),
array('fal fa-link'=>'link'),
array('fal fa-lips'=>'lips'),
array('fal fa-lira-sign'=>'lira-sign'),
array('fal fa-list'=>'list'),
array('fal fa-list-alt'=>'list-alt'),
array('fal fa-list-music'=>'list-music'),
array('fal fa-list-ol'=>'list-ol'),
array('fal fa-list-ul'=>'list-ul'),
array('fal fa-location'=>'location'),
array('fal fa-location-arrow'=>'location-arrow'),
array('fal fa-location-circle'=>'location-circle'),
array('fal fa-location-slash'=>'location-slash'),
array('fal fa-lock'=>'lock'),
array('fal fa-lock-alt'=>'lock-alt'),
array('fal fa-lock-open'=>'lock-open'),
array('fal fa-lock-open-alt'=>'lock-open-alt'),
array('fal fa-long-arrow-alt-down'=>'long-arrow-alt-down'),
array('fal fa-long-arrow-alt-left'=>'long-arrow-alt-left'),
array('fal fa-long-arrow-alt-right'=>'long-arrow-alt-right'),
array('fal fa-long-arrow-alt-up'=>'long-arrow-alt-up'),
array('fal fa-long-arrow-down'=>'long-arrow-down'),
array('fal fa-long-arrow-left'=>'long-arrow-left'),
array('fal fa-long-arrow-right'=>'long-arrow-right'),
array('fal fa-long-arrow-up'=>'long-arrow-up'),
array('fal fa-loveseat'=>'loveseat'),
array('fal fa-low-vision'=>'low-vision'),
array('fal fa-luchador'=>'luchador'),
array('fal fa-luggage-cart'=>'luggage-cart'),
array('fal fa-lungs'=>'lungs'),
array('fal fa-mace'=>'mace'),
array('fal fa-magic'=>'magic'),
array('fal fa-magnet'=>'magnet'),
array('fal fa-mail-bulk'=>'mail-bulk'),
array('fal fa-mailbox'=>'mailbox'),
array('fal fa-male'=>'male'),
array('fal fa-mandolin'=>'mandolin'),
array('fal fa-map'=>'map'),
array('fal fa-map-marked'=>'map-marked'),
array('fal fa-map-marked-alt'=>'map-marked-alt'),
array('fal fa-map-marker'=>'map-marker'),
array('fal fa-map-marker-alt'=>'map-marker-alt'),
array('fal fa-map-marker-alt-slash'=>'map-marker-alt-slash'),
array('fal fa-map-marker-check'=>'map-marker-check'),
array('fal fa-map-marker-edit'=>'map-marker-edit'),
array('fal fa-map-marker-exclamation'=>'map-marker-exclamation'),
array('fal fa-map-marker-minus'=>'map-marker-minus'),
array('fal fa-map-marker-plus'=>'map-marker-plus'),
array('fal fa-map-marker-question'=>'map-marker-question'),
array('fal fa-map-marker-slash'=>'map-marker-slash'),
array('fal fa-map-marker-smile'=>'map-marker-smile'),
array('fal fa-map-marker-times'=>'map-marker-times'),
array('fal fa-map-pin'=>'map-pin'),
array('fal fa-map-signs'=>'map-signs'),
array('fal fa-marker'=>'marker'),
array('fal fa-mars'=>'mars'),
array('fal fa-mars-double'=>'mars-double'),
array('fal fa-mars-stroke'=>'mars-stroke'),
array('fal fa-mars-stroke-h'=>'mars-stroke-h'),
array('fal fa-mars-stroke-v'=>'mars-stroke-v'),
array('fal fa-mask'=>'mask'),
array('fal fa-meat'=>'meat'),
array('fal fa-medal'=>'medal'),
array('fal fa-medkit'=>'medkit'),
array('fal fa-megaphone'=>'megaphone'),
array('fal fa-meh'=>'meh'),
array('fal fa-meh-blank'=>'meh-blank'),
array('fal fa-meh-rolling-eyes'=>'meh-rolling-eyes'),
array('fal fa-memory'=>'memory'),
array('fal fa-menorah'=>'menorah'),
array('fal fa-mercury'=>'mercury'),
array('fal fa-meteor'=>'meteor'),
array('fal fa-microchip'=>'microchip'),
array('fal fa-microphone'=>'microphone'),
array('fal fa-microphone-alt'=>'microphone-alt'),
array('fal fa-microphone-alt-slash'=>'microphone-alt-slash'),
array('fal fa-microphone-slash'=>'microphone-slash'),
array('fal fa-microphone-stand'=>'microphone-stand'),
array('fal fa-microscope'=>'microscope'),
array('fal fa-microwave'=>'microwave'),
array('fal fa-mind-share'=>'mind-share'),
array('fal fa-minus'=>'minus'),
array('fal fa-minus-circle'=>'minus-circle'),
array('fal fa-minus-hexagon'=>'minus-hexagon'),
array('fal fa-minus-octagon'=>'minus-octagon'),
array('fal fa-minus-square'=>'minus-square'),
array('fal fa-mistletoe'=>'mistletoe'),
array('fal fa-mitten'=>'mitten'),
array('fal fa-mobile'=>'mobile'),
array('fal fa-mobile-alt'=>'mobile-alt'),
array('fal fa-mobile-android'=>'mobile-android'),
array('fal fa-mobile-android-alt'=>'mobile-android-alt'),
array('fal fa-money-bill'=>'money-bill'),
array('fal fa-money-bill-alt'=>'money-bill-alt'),
array('fal fa-money-bill-wave'=>'money-bill-wave'),
array('fal fa-money-bill-wave-alt'=>'money-bill-wave-alt'),
array('fal fa-money-check'=>'money-check'),
array('fal fa-money-check-alt'=>'money-check-alt'),
array('fal fa-money-check-edit'=>'money-check-edit'),
array('fal fa-money-check-edit-alt'=>'money-check-edit-alt'),
array('fal fa-monitor-heart-rate'=>'monitor-heart-rate'),
array('fal fa-monkey'=>'monkey'),
array('fal fa-monument'=>'monument'),
array('fal fa-moon'=>'moon'),
array('fal fa-moon-cloud'=>'moon-cloud'),
array('fal fa-moon-stars'=>'moon-stars'),
array('fal fa-mortar-pestle'=>'mortar-pestle'),
array('fal fa-mosque'=>'mosque'),
array('fal fa-motorcycle'=>'motorcycle'),
array('fal fa-mountain'=>'mountain'),
array('fal fa-mountains'=>'mountains'),
array('fal fa-mouse'=>'mouse'),
array('fal fa-mouse-alt'=>'mouse-alt'),
array('fal fa-mouse-pointer'=>'mouse-pointer'),
array('fal fa-mp3-player'=>'mp3-player'),
array('fal fa-mug'=>'mug'),
array('fal fa-mug-hot'=>'mug-hot'),
array('fal fa-mug-marshmallows'=>'mug-marshmallows'),
array('fal fa-mug-tea'=>'mug-tea'),
array('fal fa-music'=>'music'),
array('fal fa-music-alt'=>'music-alt'),
array('fal fa-music-alt-slash'=>'music-alt-slash'),
array('fal fa-music-slash'=>'music-slash'),
array('fal fa-narwhal'=>'narwhal'),
array('fal fa-network-wired'=>'network-wired'),
array('fal fa-neuter'=>'neuter'),
array('fal fa-newspaper'=>'newspaper'),
array('fal fa-not-equal'=>'not-equal'),
array('fal fa-notes-medical'=>'notes-medical'),
array('fal fa-object-group'=>'object-group'),
array('fal fa-object-ungroup'=>'object-ungroup'),
array('fal fa-octagon'=>'octagon'),
array('fal fa-oil-can'=>'oil-can'),
array('fal fa-oil-temp'=>'oil-temp'),
array('fal fa-om'=>'om'),
array('fal fa-omega'=>'omega'),
array('fal fa-ornament'=>'ornament'),
array('fal fa-otter'=>'otter'),
array('fal fa-outdent'=>'outdent'),
array('fal fa-outlet'=>'outlet'),
array('fal fa-oven'=>'oven'),
array('fal fa-overline'=>'overline'),
array('fal fa-page-break'=>'page-break'),
array('fal fa-pager'=>'pager'),
array('fal fa-paint-brush'=>'paint-brush'),
array('fal fa-paint-brush-alt'=>'paint-brush-alt'),
array('fal fa-paint-roller'=>'paint-roller'),
array('fal fa-palette'=>'palette'),
array('fal fa-pallet'=>'pallet'),
array('fal fa-pallet-alt'=>'pallet-alt'),
array('fal fa-paper-plane'=>'paper-plane'),
array('fal fa-paperclip'=>'paperclip'),
array('fal fa-parachute-box'=>'parachute-box'),
array('fal fa-paragraph'=>'paragraph'),
array('fal fa-paragraph-rtl'=>'paragraph-rtl'),
array('fal fa-parking'=>'parking'),
array('fal fa-parking-circle'=>'parking-circle'),
array('fal fa-parking-circle-slash'=>'parking-circle-slash'),
array('fal fa-parking-slash'=>'parking-slash'),
array('fal fa-passport'=>'passport'),
array('fal fa-pastafarianism'=>'pastafarianism'),
array('fal fa-paste'=>'paste'),
array('fal fa-pause'=>'pause'),
array('fal fa-pause-circle'=>'pause-circle'),
array('fal fa-paw'=>'paw'),
array('fal fa-paw-alt'=>'paw-alt'),
array('fal fa-paw-claws'=>'paw-claws'),
array('fal fa-peace'=>'peace'),
array('fal fa-pegasus'=>'pegasus'),
array('fal fa-pen'=>'pen'),
array('fal fa-pen-alt'=>'pen-alt'),
array('fal fa-pen-fancy'=>'pen-fancy'),
array('fal fa-pen-nib'=>'pen-nib'),
array('fal fa-pen-square'=>'pen-square'),
array('fal fa-pencil'=>'pencil'),
array('fal fa-pencil-alt'=>'pencil-alt'),
array('fal fa-pencil-paintbrush'=>'pencil-paintbrush'),
array('fal fa-pencil-ruler'=>'pencil-ruler'),
array('fal fa-pennant'=>'pennant'),
array('fal fa-people-carry'=>'people-carry'),
array('fal fa-pepper-hot'=>'pepper-hot'),
array('fal fa-percent'=>'percent'),
array('fal fa-percentage'=>'percentage'),
array('fal fa-person-booth'=>'person-booth'),
array('fal fa-person-carry'=>'person-carry'),
array('fal fa-person-dolly'=>'person-dolly'),
array('fal fa-person-dolly-empty'=>'person-dolly-empty'),
array('fal fa-person-sign'=>'person-sign'),
array('fal fa-phone'=>'phone'),
array('fal fa-phone-alt'=>'phone-alt'),
array('fal fa-phone-laptop'=>'phone-laptop'),
array('fal fa-phone-office'=>'phone-office'),
array('fal fa-phone-plus'=>'phone-plus'),
array('fal fa-phone-rotary'=>'phone-rotary'),
array('fal fa-phone-slash'=>'phone-slash'),
array('fal fa-phone-square'=>'phone-square'),
array('fal fa-phone-square-alt'=>'phone-square-alt'),
array('fal fa-phone-volume'=>'phone-volume'),
array('fal fa-photo-video'=>'photo-video'),
array('fal fa-pi'=>'pi'),
array('fal fa-piano'=>'piano'),
array('fal fa-piano-keyboard'=>'piano-keyboard'),
array('fal fa-pie'=>'pie'),
array('fal fa-pig'=>'pig'),
array('fal fa-piggy-bank'=>'piggy-bank'),
array('fal fa-pills'=>'pills'),
array('fal fa-pizza'=>'pizza'),
array('fal fa-pizza-slice'=>'pizza-slice'),
array('fal fa-place-of-worship'=>'place-of-worship'),
array('fal fa-plane'=>'plane'),
array('fal fa-plane-alt'=>'plane-alt'),
array('fal fa-plane-arrival'=>'plane-arrival'),
array('fal fa-plane-departure'=>'plane-departure'),
array('fal fa-planet-moon'=>'planet-moon'),
array('fal fa-planet-ringed'=>'planet-ringed'),
array('fal fa-play'=>'play'),
array('fal fa-play-circle'=>'play-circle'),
array('fal fa-plug'=>'plug'),
array('fal fa-plus'=>'plus'),
array('fal fa-plus-circle'=>'plus-circle'),
array('fal fa-plus-hexagon'=>'plus-hexagon'),
array('fal fa-plus-octagon'=>'plus-octagon'),
array('fal fa-plus-square'=>'plus-square'),
array('fal fa-podcast'=>'podcast'),
array('fal fa-podium'=>'podium'),
array('fal fa-podium-star'=>'podium-star'),
array('fal fa-police-box'=>'police-box'),
array('fal fa-poll'=>'poll'),
array('fal fa-poll-h'=>'poll-h'),
array('fal fa-poll-people'=>'poll-people'),
array('fal fa-poo'=>'poo'),
array('fal fa-poo-storm'=>'poo-storm'),
array('fal fa-poop'=>'poop'),
array('fal fa-popcorn'=>'popcorn'),
array('fal fa-portal-enter'=>'portal-enter'),
array('fal fa-portal-exit'=>'portal-exit'),
array('fal fa-portrait'=>'portrait'),
array('fal fa-pound-sign'=>'pound-sign'),
array('fal fa-power-off'=>'power-off'),
array('fal fa-pray'=>'pray'),
array('fal fa-praying-hands'=>'praying-hands'),
array('fal fa-prescription'=>'prescription'),
array('fal fa-prescription-bottle'=>'prescription-bottle'),
array('fal fa-prescription-bottle-alt'=>'prescription-bottle-alt'),
array('fal fa-presentation'=>'presentation'),
array('fal fa-print'=>'print'),
array('fal fa-print-search'=>'print-search'),
array('fal fa-print-slash'=>'print-slash'),
array('fal fa-procedures'=>'procedures'),
array('fal fa-project-diagram'=>'project-diagram'),
array('fal fa-projector'=>'projector'),
array('fal fa-pumpkin'=>'pumpkin'),
array('fal fa-puzzle-piece'=>'puzzle-piece'),
array('fal fa-qrcode'=>'qrcode'),
array('fal fa-question'=>'question'),
array('fal fa-question-circle'=>'question-circle'),
array('fal fa-question-square'=>'question-square'),
array('fal fa-quidditch'=>'quidditch'),
array('fal fa-quote-left'=>'quote-left'),
array('fal fa-quote-right'=>'quote-right'),
array('fal fa-quran'=>'quran'),
array('fal fa-rabbit'=>'rabbit'),
array('fal fa-rabbit-fast'=>'rabbit-fast'),
array('fal fa-racquet'=>'racquet'),
array('fal fa-radar'=>'radar'),
array('fal fa-radiation'=>'radiation'),
array('fal fa-radiation-alt'=>'radiation-alt'),
array('fal fa-radio'=>'radio'),
array('fal fa-radio-alt'=>'radio-alt'),
array('fal fa-rainbow'=>'rainbow'),
array('fal fa-raindrops'=>'raindrops'),
array('fal fa-ram'=>'ram'),
array('fal fa-ramp-loading'=>'ramp-loading'),
array('fal fa-random'=>'random'),
array('fal fa-raygun'=>'raygun'),
array('fal fa-receipt'=>'receipt'),
array('fal fa-record-vinyl'=>'record-vinyl'),
array('fal fa-rectangle-landscape'=>'rectangle-landscape'),
array('fal fa-rectangle-portrait'=>'rectangle-portrait'),
array('fal fa-rectangle-wide'=>'rectangle-wide'),
array('fal fa-recycle'=>'recycle'),
array('fal fa-redo'=>'redo'),
array('fal fa-redo-alt'=>'redo-alt'),
array('fal fa-refrigerator'=>'refrigerator'),
array('fal fa-registered'=>'registered'),
array('fal fa-remove-format'=>'remove-format'),
array('fal fa-repeat'=>'repeat'),
array('fal fa-repeat-1'=>'repeat-1'),
array('fal fa-repeat-1-alt'=>'repeat-1-alt'),
array('fal fa-repeat-alt'=>'repeat-alt'),
array('fal fa-reply'=>'reply'),
array('fal fa-reply-all'=>'reply-all'),
array('fal fa-republican'=>'republican'),
array('fal fa-restroom'=>'restroom'),
array('fal fa-retweet'=>'retweet'),
array('fal fa-retweet-alt'=>'retweet-alt'),
array('fal fa-ribbon'=>'ribbon'),
array('fal fa-ring'=>'ring'),
array('fal fa-rings-wedding'=>'rings-wedding'),
array('fal fa-road'=>'road'),
array('fal fa-robot'=>'robot'),
array('fal fa-rocket'=>'rocket'),
array('fal fa-rocket-launch'=>'rocket-launch'),
array('fal fa-route'=>'route'),
array('fal fa-route-highway'=>'route-highway'),
array('fal fa-route-interstate'=>'route-interstate'),
array('fal fa-router'=>'router'),
array('fal fa-rss'=>'rss'),
array('fal fa-rss-square'=>'rss-square'),
array('fal fa-ruble-sign'=>'ruble-sign'),
array('fal fa-ruler'=>'ruler'),
array('fal fa-ruler-combined'=>'ruler-combined'),
array('fal fa-ruler-horizontal'=>'ruler-horizontal'),
array('fal fa-ruler-triangle'=>'ruler-triangle'),
array('fal fa-ruler-vertical'=>'ruler-vertical'),
array('fal fa-running'=>'running'),
array('fal fa-rupee-sign'=>'rupee-sign'),
array('fal fa-rv'=>'rv'),
array('fal fa-sack'=>'sack'),
array('fal fa-sack-dollar'=>'sack-dollar'),
array('fal fa-sad-cry'=>'sad-cry'),
array('fal fa-sad-tear'=>'sad-tear'),
array('fal fa-salad'=>'salad'),
array('fal fa-sandwich'=>'sandwich'),
array('fal fa-satellite'=>'satellite'),
array('fal fa-satellite-dish'=>'satellite-dish'),
array('fal fa-sausage'=>'sausage'),
array('fal fa-save'=>'save'),
array('fal fa-sax-hot'=>'sax-hot'),
array('fal fa-saxophone'=>'saxophone'),
array('fal fa-scalpel'=>'scalpel'),
array('fal fa-scalpel-path'=>'scalpel-path'),
array('fal fa-scanner'=>'scanner'),
array('fal fa-scanner-image'=>'scanner-image'),
array('fal fa-scanner-keyboard'=>'scanner-keyboard'),
array('fal fa-scanner-touchscreen'=>'scanner-touchscreen'),
array('fal fa-scarecrow'=>'scarecrow'),
array('fal fa-scarf'=>'scarf'),
array('fal fa-school'=>'school'),
array('fal fa-screwdriver'=>'screwdriver'),
array('fal fa-scroll'=>'scroll'),
array('fal fa-scroll-old'=>'scroll-old'),
array('fal fa-scrubber'=>'scrubber'),
array('fal fa-scythe'=>'scythe'),
array('fal fa-sd-card'=>'sd-card'),
array('fal fa-search'=>'search'),
array('fal fa-search-dollar'=>'search-dollar'),
array('fal fa-search-location'=>'search-location'),
array('fal fa-search-minus'=>'search-minus'),
array('fal fa-search-plus'=>'search-plus'),
array('fal fa-seedling'=>'seedling'),
array('fal fa-send-back'=>'send-back'),
array('fal fa-send-backward'=>'send-backward'),
array('fal fa-sensor'=>'sensor'),
array('fal fa-sensor-alert'=>'sensor-alert'),
array('fal fa-sensor-fire'=>'sensor-fire'),
array('fal fa-sensor-on'=>'sensor-on'),
array('fal fa-sensor-smoke'=>'sensor-smoke'),
array('fal fa-server'=>'server'),
array('fal fa-shapes'=>'shapes'),
array('fal fa-share'=>'share'),
array('fal fa-share-all'=>'share-all'),
array('fal fa-share-alt'=>'share-alt'),
array('fal fa-share-alt-square'=>'share-alt-square'),
array('fal fa-share-square'=>'share-square'),
array('fal fa-sheep'=>'sheep'),
array('fal fa-shekel-sign'=>'shekel-sign'),
array('fal fa-shield'=>'shield'),
array('fal fa-shield-alt'=>'shield-alt'),
array('fal fa-shield-check'=>'shield-check'),
array('fal fa-shield-cross'=>'shield-cross'),
array('fal fa-ship'=>'ship'),
array('fal fa-shipping-fast'=>'shipping-fast'),
array('fal fa-shipping-timed'=>'shipping-timed'),
array('fal fa-shish-kebab'=>'shish-kebab'),
array('fal fa-shoe-prints'=>'shoe-prints'),
array('fal fa-shopping-bag'=>'shopping-bag'),
array('fal fa-shopping-basket'=>'shopping-basket'),
array('fal fa-shopping-cart'=>'shopping-cart'),
array('fal fa-shovel'=>'shovel'),
array('fal fa-shovel-snow'=>'shovel-snow'),
array('fal fa-shower'=>'shower'),
array('fal fa-shredder'=>'shredder'),
array('fal fa-shuttle-van'=>'shuttle-van'),
array('fal fa-shuttlecock'=>'shuttlecock'),
array('fal fa-sickle'=>'sickle'),
array('fal fa-sigma'=>'sigma'),
array('fal fa-sign'=>'sign'),
array('fal fa-sign-in'=>'sign-in'),
array('fal fa-sign-in-alt'=>'sign-in-alt'),
array('fal fa-sign-language'=>'sign-language'),
array('fal fa-sign-out'=>'sign-out'),
array('fal fa-sign-out-alt'=>'sign-out-alt'),
array('fal fa-signal'=>'signal'),
array('fal fa-signal-1'=>'signal-1'),
array('fal fa-signal-2'=>'signal-2'),
array('fal fa-signal-3'=>'signal-3'),
array('fal fa-signal-4'=>'signal-4'),
array('fal fa-signal-alt'=>'signal-alt'),
array('fal fa-signal-alt-1'=>'signal-alt-1'),
array('fal fa-signal-alt-2'=>'signal-alt-2'),
array('fal fa-signal-alt-3'=>'signal-alt-3'),
array('fal fa-signal-alt-slash'=>'signal-alt-slash'),
array('fal fa-signal-slash'=>'signal-slash'),
array('fal fa-signal-stream'=>'signal-stream'),
array('fal fa-signature'=>'signature'),
array('fal fa-sim-card'=>'sim-card'),
array('fal fa-siren'=>'siren'),
array('fal fa-siren-on'=>'siren-on'),
array('fal fa-sitemap'=>'sitemap'),
array('fal fa-skating'=>'skating'),
array('fal fa-skeleton'=>'skeleton'),
array('fal fa-ski-jump'=>'ski-jump'),
array('fal fa-ski-lift'=>'ski-lift'),
array('fal fa-skiing'=>'skiing'),
array('fal fa-skiing-nordic'=>'skiing-nordic'),
array('fal fa-skull'=>'skull'),
array('fal fa-skull-cow'=>'skull-cow'),
array('fal fa-skull-crossbones'=>'skull-crossbones'),
array('fal fa-slash'=>'slash'),
array('fal fa-sledding'=>'sledding'),
array('fal fa-sleigh'=>'sleigh'),
array('fal fa-sliders-h'=>'sliders-h'),
array('fal fa-sliders-h-square'=>'sliders-h-square'),
array('fal fa-sliders-v'=>'sliders-v'),
array('fal fa-sliders-v-square'=>'sliders-v-square'),
array('fal fa-smile'=>'smile'),
array('fal fa-smile-beam'=>'smile-beam'),
array('fal fa-smile-plus'=>'smile-plus'),
array('fal fa-smile-wink'=>'smile-wink'),
array('fal fa-smog'=>'smog'),
array('fal fa-smoke'=>'smoke'),
array('fal fa-smoking'=>'smoking'),
array('fal fa-smoking-ban'=>'smoking-ban'),
array('fal fa-sms'=>'sms'),
array('fal fa-snake'=>'snake'),
array('fal fa-snooze'=>'snooze'),
array('fal fa-snow-blowing'=>'snow-blowing'),
array('fal fa-snowboarding'=>'snowboarding'),
array('fal fa-snowflake'=>'snowflake'),
array('fal fa-snowflakes'=>'snowflakes'),
array('fal fa-snowman'=>'snowman'),
array('fal fa-snowmobile'=>'snowmobile'),
array('fal fa-snowplow'=>'snowplow'),
array('fal fa-socks'=>'socks'),
array('fal fa-solar-panel'=>'solar-panel'),
array('fal fa-solar-system'=>'solar-system'),
array('fal fa-sort'=>'sort'),
array('fal fa-sort-alpha-down'=>'sort-alpha-down'),
array('fal fa-sort-alpha-down-alt'=>'sort-alpha-down-alt'),
array('fal fa-sort-alpha-up'=>'sort-alpha-up'),
array('fal fa-sort-alpha-up-alt'=>'sort-alpha-up-alt'),
array('fal fa-sort-alt'=>'sort-alt'),
array('fal fa-sort-amount-down'=>'sort-amount-down'),
array('fal fa-sort-amount-down-alt'=>'sort-amount-down-alt'),
array('fal fa-sort-amount-up'=>'sort-amount-up'),
array('fal fa-sort-amount-up-alt'=>'sort-amount-up-alt'),
array('fal fa-sort-circle'=>'sort-circle'),
array('fal fa-sort-circle-down'=>'sort-circle-down'),
array('fal fa-sort-circle-up'=>'sort-circle-up'),
array('fal fa-sort-down'=>'sort-down'),
array('fal fa-sort-numeric-down'=>'sort-numeric-down'),
array('fal fa-sort-numeric-down-alt'=>'sort-numeric-down-alt'),
array('fal fa-sort-numeric-up'=>'sort-numeric-up'),
array('fal fa-sort-numeric-up-alt'=>'sort-numeric-up-alt'),
array('fal fa-sort-shapes-down'=>'sort-shapes-down'),
array('fal fa-sort-shapes-down-alt'=>'sort-shapes-down-alt'),
array('fal fa-sort-shapes-up'=>'sort-shapes-up'),
array('fal fa-sort-shapes-up-alt'=>'sort-shapes-up-alt'),
array('fal fa-sort-size-down'=>'sort-size-down'),
array('fal fa-sort-size-down-alt'=>'sort-size-down-alt'),
array('fal fa-sort-size-up'=>'sort-size-up'),
array('fal fa-sort-size-up-alt'=>'sort-size-up-alt'),
array('fal fa-sort-up'=>'sort-up'),
array('fal fa-soup'=>'soup'),
array('fal fa-spa'=>'spa'),
array('fal fa-space-shuttle'=>'space-shuttle'),
array('fal fa-space-station-moon'=>'space-station-moon'),
array('fal fa-space-station-moon-alt'=>'space-station-moon-alt'),
array('fal fa-spade'=>'spade'),
array('fal fa-sparkles'=>'sparkles'),
array('fal fa-speaker'=>'speaker'),
array('fal fa-speakers'=>'speakers'),
array('fal fa-spell-check'=>'spell-check'),
array('fal fa-spider'=>'spider'),
array('fal fa-spider-black-widow'=>'spider-black-widow'),
array('fal fa-spider-web'=>'spider-web'),
array('fal fa-spinner'=>'spinner'),
array('fal fa-spinner-third'=>'spinner-third'),
array('fal fa-splotch'=>'splotch'),
array('fal fa-spray-can'=>'spray-can'),
array('fal fa-sprinkler'=>'sprinkler'),
array('fal fa-square'=>'square'),
array('fal fa-square-full'=>'square-full'),
array('fal fa-square-root'=>'square-root'),
array('fal fa-square-root-alt'=>'square-root-alt'),
array('fal fa-squirrel'=>'squirrel'),
array('fal fa-staff'=>'staff'),
array('fal fa-stamp'=>'stamp'),
array('fal fa-star'=>'star'),
array('fal fa-star-and-crescent'=>'star-and-crescent'),
array('fal fa-star-christmas'=>'star-christmas'),
array('fal fa-star-exclamation'=>'star-exclamation'),
array('fal fa-star-half'=>'star-half'),
array('fal fa-star-half-alt'=>'star-half-alt'),
array('fal fa-star-of-david'=>'star-of-david'),
array('fal fa-star-of-life'=>'star-of-life'),
array('fal fa-star-shooting'=>'star-shooting'),
array('fal fa-starfighter'=>'starfighter'),
array('fal fa-starfighter-alt'=>'starfighter-alt'),
array('fal fa-stars'=>'stars'),
array('fal fa-starship'=>'starship'),
array('fal fa-starship-freighter'=>'starship-freighter'),
array('fal fa-steak'=>'steak'),
array('fal fa-steering-wheel'=>'steering-wheel'),
array('fal fa-step-backward'=>'step-backward'),
array('fal fa-step-forward'=>'step-forward'),
array('fal fa-stethoscope'=>'stethoscope'),
array('fal fa-sticky-note'=>'sticky-note'),
array('fal fa-stocking'=>'stocking'),
array('fal fa-stomach'=>'stomach'),
array('fal fa-stop'=>'stop'),
array('fal fa-stop-circle'=>'stop-circle'),
array('fal fa-stopwatch'=>'stopwatch'),
array('fal fa-store'=>'store'),
array('fal fa-store-alt'=>'store-alt'),
array('fal fa-stream'=>'stream'),
array('fal fa-street-view'=>'street-view'),
array('fal fa-stretcher'=>'stretcher'),
array('fal fa-strikethrough'=>'strikethrough'),
array('fal fa-stroopwafel'=>'stroopwafel'),
array('fal fa-subscript'=>'subscript'),
array('fal fa-subway'=>'subway'),
array('fal fa-suitcase'=>'suitcase'),
array('fal fa-suitcase-rolling'=>'suitcase-rolling'),
array('fal fa-sun'=>'sun'),
array('fal fa-sun-cloud'=>'sun-cloud'),
array('fal fa-sun-dust'=>'sun-dust'),
array('fal fa-sun-haze'=>'sun-haze'),
array('fal fa-sunglasses'=>'sunglasses'),
array('fal fa-sunrise'=>'sunrise'),
array('fal fa-sunset'=>'sunset'),
array('fal fa-superscript'=>'superscript'),
array('fal fa-surprise'=>'surprise'),
array('fal fa-swatchbook'=>'swatchbook'),
array('fal fa-swimmer'=>'swimmer'),
array('fal fa-swimming-pool'=>'swimming-pool'),
array('fal fa-sword'=>'sword'),
array('fal fa-sword-laser'=>'sword-laser'),
array('fal fa-sword-laser-alt'=>'sword-laser-alt'),
array('fal fa-swords'=>'swords'),
array('fal fa-swords-laser'=>'swords-laser'),
array('fal fa-synagogue'=>'synagogue'),
array('fal fa-sync'=>'sync'),
array('fal fa-sync-alt'=>'sync-alt'),
array('fal fa-syringe'=>'syringe'),
array('fal fa-table'=>'table'),
array('fal fa-table-tennis'=>'table-tennis'),
array('fal fa-tablet'=>'tablet'),
array('fal fa-tablet-alt'=>'tablet-alt'),
array('fal fa-tablet-android'=>'tablet-android'),
array('fal fa-tablet-android-alt'=>'tablet-android-alt'),
array('fal fa-tablet-rugged'=>'tablet-rugged'),
array('fal fa-tablets'=>'tablets'),
array('fal fa-tachometer'=>'tachometer'),
array('fal fa-tachometer-alt'=>'tachometer-alt'),
array('fal fa-tachometer-alt-average'=>'tachometer-alt-average'),
array('fal fa-tachometer-alt-fast'=>'tachometer-alt-fast'),
array('fal fa-tachometer-alt-fastest'=>'tachometer-alt-fastest'),
array('fal fa-tachometer-alt-slow'=>'tachometer-alt-slow'),
array('fal fa-tachometer-alt-slowest'=>'tachometer-alt-slowest'),
array('fal fa-tachometer-average'=>'tachometer-average'),
array('fal fa-tachometer-fast'=>'tachometer-fast'),
array('fal fa-tachometer-fastest'=>'tachometer-fastest'),
array('fal fa-tachometer-slow'=>'tachometer-slow'),
array('fal fa-tachometer-slowest'=>'tachometer-slowest'),
array('fal fa-taco'=>'taco'),
array('fal fa-tag'=>'tag'),
array('fal fa-tags'=>'tags'),
array('fal fa-tally'=>'tally'),
array('fal fa-tanakh'=>'tanakh'),
array('fal fa-tape'=>'tape'),
array('fal fa-tasks'=>'tasks'),
array('fal fa-tasks-alt'=>'tasks-alt'),
array('fal fa-taxi'=>'taxi'),
array('fal fa-teeth'=>'teeth'),
array('fal fa-teeth-open'=>'teeth-open'),
array('fal fa-telescope'=>'telescope'),
array('fal fa-temperature-down'=>'temperature-down'),
array('fal fa-temperature-frigid'=>'temperature-frigid'),
array('fal fa-temperature-high'=>'temperature-high'),
array('fal fa-temperature-hot'=>'temperature-hot'),
array('fal fa-temperature-low'=>'temperature-low'),
array('fal fa-temperature-up'=>'temperature-up'),
array('fal fa-tenge'=>'tenge'),
array('fal fa-tennis-ball'=>'tennis-ball'),
array('fal fa-terminal'=>'terminal'),
array('fal fa-text'=>'text'),
array('fal fa-text-height'=>'text-height'),
array('fal fa-text-size'=>'text-size'),
array('fal fa-text-width'=>'text-width'),
array('fal fa-th'=>'th'),
array('fal fa-th-large'=>'th-large'),
array('fal fa-th-list'=>'th-list'),
array('fal fa-theater-masks'=>'theater-masks'),
array('fal fa-thermometer'=>'thermometer'),
array('fal fa-thermometer-empty'=>'thermometer-empty'),
array('fal fa-thermometer-full'=>'thermometer-full'),
array('fal fa-thermometer-half'=>'thermometer-half'),
array('fal fa-thermometer-quarter'=>'thermometer-quarter'),
array('fal fa-thermometer-three-quarters'=>'thermometer-three-quarters'),
array('fal fa-theta'=>'theta'),
array('fal fa-thumbs-down'=>'thumbs-down'),
array('fal fa-thumbs-up'=>'thumbs-up'),
array('fal fa-thumbtack'=>'thumbtack'),
array('fal fa-thunderstorm'=>'thunderstorm'),
array('fal fa-thunderstorm-moon'=>'thunderstorm-moon'),
array('fal fa-thunderstorm-sun'=>'thunderstorm-sun'),
array('fal fa-ticket'=>'ticket'),
array('fal fa-ticket-alt'=>'ticket-alt'),
array('fal fa-tilde'=>'tilde'),
array('fal fa-times'=>'times'),
array('fal fa-times-circle'=>'times-circle'),
array('fal fa-times-hexagon'=>'times-hexagon'),
array('fal fa-times-octagon'=>'times-octagon'),
array('fal fa-times-square'=>'times-square'),
array('fal fa-tint'=>'tint'),
array('fal fa-tint-slash'=>'tint-slash'),
array('fal fa-tire'=>'tire'),
array('fal fa-tire-flat'=>'tire-flat'),
array('fal fa-tire-pressure-warning'=>'tire-pressure-warning'),
array('fal fa-tire-rugged'=>'tire-rugged'),
array('fal fa-tired'=>'tired'),
array('fal fa-toggle-off'=>'toggle-off'),
array('fal fa-toggle-on'=>'toggle-on'),
array('fal fa-toilet'=>'toilet'),
array('fal fa-toilet-paper'=>'toilet-paper'),
array('fal fa-toilet-paper-alt'=>'toilet-paper-alt'),
array('fal fa-tombstone'=>'tombstone'),
array('fal fa-tombstone-alt'=>'tombstone-alt'),
array('fal fa-toolbox'=>'toolbox'),
array('fal fa-tools'=>'tools'),
array('fal fa-tooth'=>'tooth'),
array('fal fa-toothbrush'=>'toothbrush'),
array('fal fa-torah'=>'torah'),
array('fal fa-torii-gate'=>'torii-gate'),
array('fal fa-tornado'=>'tornado'),
array('fal fa-tractor'=>'tractor'),
array('fal fa-trademark'=>'trademark'),
array('fal fa-traffic-cone'=>'traffic-cone'),
array('fal fa-traffic-light'=>'traffic-light'),
array('fal fa-traffic-light-go'=>'traffic-light-go'),
array('fal fa-traffic-light-slow'=>'traffic-light-slow'),
array('fal fa-traffic-light-stop'=>'traffic-light-stop'),
array('fal fa-trailer'=>'trailer'),
array('fal fa-train'=>'train'),
array('fal fa-tram'=>'tram'),
array('fal fa-transgender'=>'transgender'),
array('fal fa-transgender-alt'=>'transgender-alt'),
array('fal fa-transporter'=>'transporter'),
array('fal fa-transporter-1'=>'transporter-1'),
array('fal fa-transporter-2'=>'transporter-2'),
array('fal fa-transporter-3'=>'transporter-3'),
array('fal fa-transporter-empty'=>'transporter-empty'),
array('fal fa-trash'=>'trash'),
array('fal fa-trash-alt'=>'trash-alt'),
array('fal fa-trash-restore'=>'trash-restore'),
array('fal fa-trash-restore-alt'=>'trash-restore-alt'),
array('fal fa-trash-undo'=>'trash-undo'),
array('fal fa-trash-undo-alt'=>'trash-undo-alt'),
array('fal fa-treasure-chest'=>'treasure-chest'),
array('fal fa-tree'=>'tree'),
array('fal fa-tree-alt'=>'tree-alt'),
array('fal fa-tree-christmas'=>'tree-christmas'),
array('fal fa-tree-decorated'=>'tree-decorated'),
array('fal fa-tree-large'=>'tree-large'),
array('fal fa-tree-palm'=>'tree-palm'),
array('fal fa-trees'=>'trees'),
array('fal fa-triangle'=>'triangle'),
array('fal fa-triangle-music'=>'triangle-music'),
array('fal fa-trophy'=>'trophy'),
array('fal fa-trophy-alt'=>'trophy-alt'),
array('fal fa-truck'=>'truck'),
array('fal fa-truck-container'=>'truck-container'),
array('fal fa-truck-couch'=>'truck-couch'),
array('fal fa-truck-loading'=>'truck-loading'),
array('fal fa-truck-monster'=>'truck-monster'),
array('fal fa-truck-moving'=>'truck-moving'),
array('fal fa-truck-pickup'=>'truck-pickup'),
array('fal fa-truck-plow'=>'truck-plow'),
array('fal fa-truck-ramp'=>'truck-ramp'),
array('fal fa-trumpet'=>'trumpet'),
array('fal fa-tshirt'=>'tshirt'),
array('fal fa-tty'=>'tty'),
array('fal fa-turkey'=>'turkey'),
array('fal fa-turntable'=>'turntable'),
array('fal fa-turtle'=>'turtle'),
array('fal fa-tv'=>'tv'),
array('fal fa-tv-alt'=>'tv-alt'),
array('fal fa-tv-music'=>'tv-music'),
array('fal fa-tv-retro'=>'tv-retro'),
array('fal fa-typewriter'=>'typewriter'),
array('fal fa-ufo'=>'ufo'),
array('fal fa-ufo-beam'=>'ufo-beam'),
array('fal fa-umbrella'=>'umbrella'),
array('fal fa-umbrella-beach'=>'umbrella-beach'),
array('fal fa-underline'=>'underline'),
array('fal fa-undo'=>'undo'),
array('fal fa-undo-alt'=>'undo-alt'),
array('fal fa-unicorn'=>'unicorn'),
array('fal fa-union'=>'union'),
array('fal fa-universal-access'=>'universal-access'),
array('fal fa-university'=>'university'),
array('fal fa-unlink'=>'unlink'),
array('fal fa-unlock'=>'unlock'),
array('fal fa-unlock-alt'=>'unlock-alt'),
array('fal fa-upload'=>'upload'),
array('fal fa-usb-drive'=>'usb-drive'),
array('fal fa-usd-circle'=>'usd-circle'),
array('fal fa-usd-square'=>'usd-square'),
array('fal fa-user'=>'user'),
array('fal fa-user-alien'=>'user-alien'),
array('fal fa-user-alt'=>'user-alt'),
array('fal fa-user-alt-slash'=>'user-alt-slash'),
array('fal fa-user-astronaut'=>'user-astronaut'),
array('fal fa-user-chart'=>'user-chart'),
array('fal fa-user-check'=>'user-check'),
array('fal fa-user-circle'=>'user-circle'),
array('fal fa-user-clock'=>'user-clock'),
array('fal fa-user-cog'=>'user-cog'),
array('fal fa-user-cowboy'=>'user-cowboy'),
array('fal fa-user-crown'=>'user-crown'),
array('fal fa-user-edit'=>'user-edit'),
array('fal fa-user-friends'=>'user-friends'),
array('fal fa-user-graduate'=>'user-graduate'),
array('fal fa-user-hard-hat'=>'user-hard-hat'),
array('fal fa-user-headset'=>'user-headset'),
array('fal fa-user-injured'=>'user-injured'),
array('fal fa-user-lock'=>'user-lock'),
array('fal fa-user-md'=>'user-md'),
array('fal fa-user-md-chat'=>'user-md-chat'),
array('fal fa-user-minus'=>'user-minus'),
array('fal fa-user-music'=>'user-music'),
array('fal fa-user-ninja'=>'user-ninja'),
array('fal fa-user-nurse'=>'user-nurse'),
array('fal fa-user-plus'=>'user-plus'),
array('fal fa-user-robot'=>'user-robot'),
array('fal fa-user-secret'=>'user-secret'),
array('fal fa-user-shield'=>'user-shield'),
array('fal fa-user-slash'=>'user-slash'),
array('fal fa-user-tag'=>'user-tag'),
array('fal fa-user-tie'=>'user-tie'),
array('fal fa-user-times'=>'user-times'),
array('fal fa-user-unlock'=>'user-unlock'),
array('fal fa-user-visor'=>'user-visor'),
array('fal fa-users'=>'users'),
array('fal fa-users-class'=>'users-class'),
array('fal fa-users-cog'=>'users-cog'),
array('fal fa-users-crown'=>'users-crown'),
array('fal fa-users-medical'=>'users-medical'),
array('fal fa-utensil-fork'=>'utensil-fork'),
array('fal fa-utensil-knife'=>'utensil-knife'),
array('fal fa-utensil-spoon'=>'utensil-spoon'),
array('fal fa-utensils'=>'utensils'),
array('fal fa-utensils-alt'=>'utensils-alt'),
array('fal fa-vacuum'=>'vacuum'),
array('fal fa-vacuum-robot'=>'vacuum-robot'),
array('fal fa-value-absolute'=>'value-absolute'),
array('fal fa-vector-square'=>'vector-square'),
array('fal fa-venus'=>'venus'),
array('fal fa-venus-double'=>'venus-double'),
array('fal fa-venus-mars'=>'venus-mars'),
array('fal fa-vhs'=>'vhs'),
array('fal fa-vial'=>'vial'),
array('fal fa-vials'=>'vials'),
array('fal fa-video'=>'video'),
array('fal fa-video-plus'=>'video-plus'),
array('fal fa-video-slash'=>'video-slash'),
array('fal fa-vihara'=>'vihara'),
array('fal fa-violin'=>'violin'),
array('fal fa-voicemail'=>'voicemail'),
array('fal fa-volcano'=>'volcano'),
array('fal fa-volleyball-ball'=>'volleyball-ball'),
array('fal fa-volume'=>'volume'),
array('fal fa-volume-down'=>'volume-down'),
array('fal fa-volume-mute'=>'volume-mute'),
array('fal fa-volume-off'=>'volume-off'),
array('fal fa-volume-slash'=>'volume-slash'),
array('fal fa-volume-up'=>'volume-up'),
array('fal fa-vote-nay'=>'vote-nay'),
array('fal fa-vote-yea'=>'vote-yea'),
array('fal fa-vr-cardboard'=>'vr-cardboard'),
array('fal fa-wagon-covered'=>'wagon-covered'),
array('fal fa-walker'=>'walker'),
array('fal fa-walkie-talkie'=>'walkie-talkie'),
array('fal fa-walking'=>'walking'),
array('fal fa-wallet'=>'wallet'),
array('fal fa-wand'=>'wand'),
array('fal fa-wand-magic'=>'wand-magic'),
array('fal fa-warehouse'=>'warehouse'),
array('fal fa-warehouse-alt'=>'warehouse-alt'),
array('fal fa-washer'=>'washer'),
array('fal fa-watch'=>'watch'),
array('fal fa-watch-calculator'=>'watch-calculator'),
array('fal fa-watch-fitness'=>'watch-fitness'),
array('fal fa-water'=>'water'),
array('fal fa-water-lower'=>'water-lower'),
array('fal fa-water-rise'=>'water-rise'),
array('fal fa-wave-sine'=>'wave-sine'),
array('fal fa-wave-square'=>'wave-square'),
array('fal fa-wave-triangle'=>'wave-triangle'),
array('fal fa-waveform'=>'waveform'),
array('fal fa-waveform-path'=>'waveform-path'),
array('fal fa-webcam'=>'webcam'),
array('fal fa-webcam-slash'=>'webcam-slash'),
array('fal fa-weight'=>'weight'),
array('fal fa-weight-hanging'=>'weight-hanging'),
array('fal fa-whale'=>'whale'),
array('fal fa-wheat'=>'wheat'),
array('fal fa-wheelchair'=>'wheelchair'),
array('fal fa-whistle'=>'whistle'),
array('fal fa-wifi'=>'wifi'),
array('fal fa-wifi-1'=>'wifi-1'),
array('fal fa-wifi-2'=>'wifi-2'),
array('fal fa-wifi-slash'=>'wifi-slash'),
array('fal fa-wind'=>'wind'),
array('fal fa-wind-turbine'=>'wind-turbine'),
array('fal fa-wind-warning'=>'wind-warning'),
array('fal fa-window'=>'window'),
array('fal fa-window-alt'=>'window-alt'),
array('fal fa-window-close'=>'window-close'),
array('fal fa-window-frame'=>'window-frame'),
array('fal fa-window-frame-open'=>'window-frame-open'),
array('fal fa-window-maximize'=>'window-maximize'),
array('fal fa-window-minimize'=>'window-minimize'),
array('fal fa-window-restore'=>'window-restore'),
array('fal fa-windsock'=>'windsock'),
array('fal fa-wine-bottle'=>'wine-bottle'),
array('fal fa-wine-glass'=>'wine-glass'),
array('fal fa-wine-glass-alt'=>'wine-glass-alt'),
array('fal fa-won-sign'=>'won-sign'),
array('fal fa-wreath'=>'wreath'),
array('fal fa-wrench'=>'wrench'),
array('fal fa-x-ray'=>'x-ray'),
array('fal fa-yen-sign'=>'yen-sign'),
array('fal fa-yin-yang'=>'yin-yang'),
),
'Solid Icons' => array(
array('fas fa-abacus'=>'abacus'),
array('fas fa-acorn'=>'acorn'),
array('fas fa-ad'=>'ad'),
array('fas fa-address-book'=>'address-book'),
array('fas fa-address-card'=>'address-card'),
array('fas fa-adjust'=>'adjust'),
array('fas fa-air-conditioner'=>'air-conditioner'),
array('fas fa-air-freshener'=>'air-freshener'),
array('fas fa-alarm-clock'=>'alarm-clock'),
array('fas fa-alarm-exclamation'=>'alarm-exclamation'),
array('fas fa-alarm-plus'=>'alarm-plus'),
array('fas fa-alarm-snooze'=>'alarm-snooze'),
array('fas fa-album'=>'album'),
array('fas fa-album-collection'=>'album-collection'),
array('fas fa-alicorn'=>'alicorn'),
array('fas fa-alien'=>'alien'),
array('fas fa-alien-monster'=>'alien-monster'),
array('fas fa-align-center'=>'align-center'),
array('fas fa-align-justify'=>'align-justify'),
array('fas fa-align-left'=>'align-left'),
array('fas fa-align-right'=>'align-right'),
array('fas fa-align-slash'=>'align-slash'),
array('fas fa-allergies'=>'allergies'),
array('fas fa-ambulance'=>'ambulance'),
array('fas fa-american-sign-language-interpreting'=>'american-sign-language-interpreting'),
array('fas fa-amp-guitar'=>'amp-guitar'),
array('fas fa-analytics'=>'analytics'),
array('fas fa-anchor'=>'anchor'),
array('fas fa-angel'=>'angel'),
array('fas fa-angle-double-down'=>'angle-double-down'),
array('fas fa-angle-double-left'=>'angle-double-left'),
array('fas fa-angle-double-right'=>'angle-double-right'),
array('fas fa-angle-double-up'=>'angle-double-up'),
array('fas fa-angle-down'=>'angle-down'),
array('fas fa-angle-left'=>'angle-left'),
array('fas fa-angle-right'=>'angle-right'),
array('fas fa-angle-up'=>'angle-up'),
array('fas fa-angry'=>'angry'),
array('fas fa-ankh'=>'ankh'),
array('fas fa-apple-alt'=>'apple-alt'),
array('fas fa-apple-crate'=>'apple-crate'),
array('fas fa-archive'=>'archive'),
array('fas fa-archway'=>'archway'),
array('fas fa-arrow-alt-circle-down'=>'arrow-alt-circle-down'),
array('fas fa-arrow-alt-circle-left'=>'arrow-alt-circle-left'),
array('fas fa-arrow-alt-circle-right'=>'arrow-alt-circle-right'),
array('fas fa-arrow-alt-circle-up'=>'arrow-alt-circle-up'),
array('fas fa-arrow-alt-down'=>'arrow-alt-down'),
array('fas fa-arrow-alt-from-bottom'=>'arrow-alt-from-bottom'),
array('fas fa-arrow-alt-from-left'=>'arrow-alt-from-left'),
array('fas fa-arrow-alt-from-right'=>'arrow-alt-from-right'),
array('fas fa-arrow-alt-from-top'=>'arrow-alt-from-top'),
array('fas fa-arrow-alt-left'=>'arrow-alt-left'),
array('fas fa-arrow-alt-right'=>'arrow-alt-right'),
array('fas fa-arrow-alt-square-down'=>'arrow-alt-square-down'),
array('fas fa-arrow-alt-square-left'=>'arrow-alt-square-left'),
array('fas fa-arrow-alt-square-right'=>'arrow-alt-square-right'),
array('fas fa-arrow-alt-square-up'=>'arrow-alt-square-up'),
array('fas fa-arrow-alt-to-bottom'=>'arrow-alt-to-bottom'),
array('fas fa-arrow-alt-to-left'=>'arrow-alt-to-left'),
array('fas fa-arrow-alt-to-right'=>'arrow-alt-to-right'),
array('fas fa-arrow-alt-to-top'=>'arrow-alt-to-top'),
array('fas fa-arrow-alt-up'=>'arrow-alt-up'),
array('fas fa-arrow-circle-down'=>'arrow-circle-down'),
array('fas fa-arrow-circle-left'=>'arrow-circle-left'),
array('fas fa-arrow-circle-right'=>'arrow-circle-right'),
array('fas fa-arrow-circle-up'=>'arrow-circle-up'),
array('fas fa-arrow-down'=>'arrow-down'),
array('fas fa-arrow-from-bottom'=>'arrow-from-bottom'),
array('fas fa-arrow-from-left'=>'arrow-from-left'),
array('fas fa-arrow-from-right'=>'arrow-from-right'),
array('fas fa-arrow-from-top'=>'arrow-from-top'),
array('fas fa-arrow-left'=>'arrow-left'),
array('fas fa-arrow-right'=>'arrow-right'),
array('fas fa-arrow-square-down'=>'arrow-square-down'),
array('fas fa-arrow-square-left'=>'arrow-square-left'),
array('fas fa-arrow-square-right'=>'arrow-square-right'),
array('fas fa-arrow-square-up'=>'arrow-square-up'),
array('fas fa-arrow-to-bottom'=>'arrow-to-bottom'),
array('fas fa-arrow-to-left'=>'arrow-to-left'),
array('fas fa-arrow-to-right'=>'arrow-to-right'),
array('fas fa-arrow-to-top'=>'arrow-to-top'),
array('fas fa-arrow-up'=>'arrow-up'),
array('fas fa-arrows'=>'arrows'),
array('fas fa-arrows-alt'=>'arrows-alt'),
array('fas fa-arrows-alt-h'=>'arrows-alt-h'),
array('fas fa-arrows-alt-v'=>'arrows-alt-v'),
array('fas fa-arrows-h'=>'arrows-h'),
array('fas fa-arrows-v'=>'arrows-v'),
array('fas fa-assistive-listening-systems'=>'assistive-listening-systems'),
array('fas fa-asterisk'=>'asterisk'),
array('fas fa-at'=>'at'),
array('fas fa-atlas'=>'atlas'),
array('fas fa-atom'=>'atom'),
array('fas fa-atom-alt'=>'atom-alt'),
array('fas fa-audio-description'=>'audio-description'),
array('fas fa-award'=>'award'),
array('fas fa-axe'=>'axe'),
array('fas fa-axe-battle'=>'axe-battle'),
array('fas fa-baby'=>'baby'),
array('fas fa-baby-carriage'=>'baby-carriage'),
array('fas fa-backpack'=>'backpack'),
array('fas fa-backspace'=>'backspace'),
array('fas fa-backward'=>'backward'),
array('fas fa-bacon'=>'bacon'),
array('fas fa-badge'=>'badge'),
array('fas fa-badge-check'=>'badge-check'),
array('fas fa-badge-dollar'=>'badge-dollar'),
array('fas fa-badge-percent'=>'badge-percent'),
array('fas fa-badge-sheriff'=>'badge-sheriff'),
array('fas fa-badger-honey'=>'badger-honey'),
array('fas fa-bags-shopping'=>'bags-shopping'),
array('fas fa-bahai'=>'bahai'),
array('fas fa-balance-scale'=>'balance-scale'),
array('fas fa-balance-scale-left'=>'balance-scale-left'),
array('fas fa-balance-scale-right'=>'balance-scale-right'),
array('fas fa-ball-pile'=>'ball-pile'),
array('fas fa-ballot'=>'ballot'),
array('fas fa-ballot-check'=>'ballot-check'),
array('fas fa-ban'=>'ban'),
array('fas fa-band-aid'=>'band-aid'),
array('fas fa-banjo'=>'banjo'),
array('fas fa-barcode'=>'barcode'),
array('fas fa-barcode-alt'=>'barcode-alt'),
array('fas fa-barcode-read'=>'barcode-read'),
array('fas fa-barcode-scan'=>'barcode-scan'),
array('fas fa-bars'=>'bars'),
array('fas fa-baseball'=>'baseball'),
array('fas fa-baseball-ball'=>'baseball-ball'),
array('fas fa-basketball-ball'=>'basketball-ball'),
array('fas fa-basketball-hoop'=>'basketball-hoop'),
array('fas fa-bat'=>'bat'),
array('fas fa-bath'=>'bath'),
array('fas fa-battery-bolt'=>'battery-bolt'),
array('fas fa-battery-empty'=>'battery-empty'),
array('fas fa-battery-full'=>'battery-full'),
array('fas fa-battery-half'=>'battery-half'),
array('fas fa-battery-quarter'=>'battery-quarter'),
array('fas fa-battery-slash'=>'battery-slash'),
array('fas fa-battery-three-quarters'=>'battery-three-quarters'),
array('fas fa-bed'=>'bed'),
array('fas fa-bed-alt'=>'bed-alt'),
array('fas fa-bed-bunk'=>'bed-bunk'),
array('fas fa-bed-empty'=>'bed-empty'),
array('fas fa-beer'=>'beer'),
array('fas fa-bell'=>'bell'),
array('fas fa-bell-exclamation'=>'bell-exclamation'),
array('fas fa-bell-on'=>'bell-on'),
array('fas fa-bell-plus'=>'bell-plus'),
array('fas fa-bell-school'=>'bell-school'),
array('fas fa-bell-school-slash'=>'bell-school-slash'),
array('fas fa-bell-slash'=>'bell-slash'),
array('fas fa-bells'=>'bells'),
array('fas fa-betamax'=>'betamax'),
array('fas fa-bezier-curve'=>'bezier-curve'),
array('fas fa-bible'=>'bible'),
array('fas fa-bicycle'=>'bicycle'),
array('fas fa-biking'=>'biking'),
array('fas fa-biking-mountain'=>'biking-mountain'),
array('fas fa-binoculars'=>'binoculars'),
array('fas fa-biohazard'=>'biohazard'),
array('fas fa-birthday-cake'=>'birthday-cake'),
array('fas fa-blanket'=>'blanket'),
array('fas fa-blender'=>'blender'),
array('fas fa-blender-phone'=>'blender-phone'),
array('fas fa-blind'=>'blind'),
array('fas fa-blinds'=>'blinds'),
array('fas fa-blinds-open'=>'blinds-open'),
array('fas fa-blinds-raised'=>'blinds-raised'),
array('fas fa-blog'=>'blog'),
array('fas fa-bold'=>'bold'),
array('fas fa-bolt'=>'bolt'),
array('fas fa-bomb'=>'bomb'),
array('fas fa-bone'=>'bone'),
array('fas fa-bone-break'=>'bone-break'),
array('fas fa-bong'=>'bong'),
array('fas fa-book'=>'book'),
array('fas fa-book-alt'=>'book-alt'),
array('fas fa-book-dead'=>'book-dead'),
array('fas fa-book-heart'=>'book-heart'),
array('fas fa-book-medical'=>'book-medical'),
array('fas fa-book-open'=>'book-open'),
array('fas fa-book-reader'=>'book-reader'),
array('fas fa-book-spells'=>'book-spells'),
array('fas fa-book-user'=>'book-user'),
array('fas fa-bookmark'=>'bookmark'),
array('fas fa-books'=>'books'),
array('fas fa-books-medical'=>'books-medical'),
array('fas fa-boombox'=>'boombox'),
array('fas fa-boot'=>'boot'),
array('fas fa-booth-curtain'=>'booth-curtain'),
array('fas fa-border-all'=>'border-all'),
array('fas fa-border-bottom'=>'border-bottom'),
array('fas fa-border-center-h'=>'border-center-h'),
array('fas fa-border-center-v'=>'border-center-v'),
array('fas fa-border-inner'=>'border-inner'),
array('fas fa-border-left'=>'border-left'),
array('fas fa-border-none'=>'border-none'),
array('fas fa-border-outer'=>'border-outer'),
array('fas fa-border-right'=>'border-right'),
array('fas fa-border-style'=>'border-style'),
array('fas fa-border-style-alt'=>'border-style-alt'),
array('fas fa-border-top'=>'border-top'),
array('fas fa-bow-arrow'=>'bow-arrow'),
array('fas fa-bowling-ball'=>'bowling-ball'),
array('fas fa-bowling-pins'=>'bowling-pins'),
array('fas fa-box'=>'box'),
array('fas fa-box-alt'=>'box-alt'),
array('fas fa-box-ballot'=>'box-ballot'),
array('fas fa-box-check'=>'box-check'),
array('fas fa-box-fragile'=>'box-fragile'),
array('fas fa-box-full'=>'box-full'),
array('fas fa-box-heart'=>'box-heart'),
array('fas fa-box-open'=>'box-open'),
array('fas fa-box-up'=>'box-up'),
array('fas fa-box-usd'=>'box-usd'),
array('fas fa-boxes'=>'boxes'),
array('fas fa-boxes-alt'=>'boxes-alt'),
array('fas fa-boxing-glove'=>'boxing-glove'),
array('fas fa-brackets'=>'brackets'),
array('fas fa-brackets-curly'=>'brackets-curly'),
array('fas fa-braille'=>'braille'),
array('fas fa-brain'=>'brain'),
array('fas fa-bread-loaf'=>'bread-loaf'),
array('fas fa-bread-slice'=>'bread-slice'),
array('fas fa-briefcase'=>'briefcase'),
array('fas fa-briefcase-medical'=>'briefcase-medical'),
array('fas fa-bring-forward'=>'bring-forward'),
array('fas fa-bring-front'=>'bring-front'),
array('fas fa-broadcast-tower'=>'broadcast-tower'),
array('fas fa-broom'=>'broom'),
array('fas fa-browser'=>'browser'),
array('fas fa-brush'=>'brush'),
array('fas fa-bug'=>'bug'),
array('fas fa-building'=>'building'),
array('fas fa-bullhorn'=>'bullhorn'),
array('fas fa-bullseye'=>'bullseye'),
array('fas fa-bullseye-arrow'=>'bullseye-arrow'),
array('fas fa-bullseye-pointer'=>'bullseye-pointer'),
array('fas fa-burger-soda'=>'burger-soda'),
array('fas fa-burn'=>'burn'),
array('fas fa-burrito'=>'burrito'),
array('fas fa-bus'=>'bus'),
array('fas fa-bus-alt'=>'bus-alt'),
array('fas fa-bus-school'=>'bus-school'),
array('fas fa-business-time'=>'business-time'),
array('fas fa-cabinet-filing'=>'cabinet-filing'),
array('fas fa-cactus'=>'cactus'),
array('fas fa-calculator'=>'calculator'),
array('fas fa-calculator-alt'=>'calculator-alt'),
array('fas fa-calendar'=>'calendar'),
array('fas fa-calendar-alt'=>'calendar-alt'),
array('fas fa-calendar-check'=>'calendar-check'),
array('fas fa-calendar-day'=>'calendar-day'),
array('fas fa-calendar-edit'=>'calendar-edit'),
array('fas fa-calendar-exclamation'=>'calendar-exclamation'),
array('fas fa-calendar-minus'=>'calendar-minus'),
array('fas fa-calendar-plus'=>'calendar-plus'),
array('fas fa-calendar-star'=>'calendar-star'),
array('fas fa-calendar-times'=>'calendar-times'),
array('fas fa-calendar-week'=>'calendar-week'),
array('fas fa-camcorder'=>'camcorder'),
array('fas fa-camera'=>'camera'),
array('fas fa-camera-alt'=>'camera-alt'),
array('fas fa-camera-home'=>'camera-home'),
array('fas fa-camera-movie'=>'camera-movie'),
array('fas fa-camera-polaroid'=>'camera-polaroid'),
array('fas fa-camera-retro'=>'camera-retro'),
array('fas fa-campfire'=>'campfire'),
array('fas fa-campground'=>'campground'),
array('fas fa-candle-holder'=>'candle-holder'),
array('fas fa-candy-cane'=>'candy-cane'),
array('fas fa-candy-corn'=>'candy-corn'),
array('fas fa-cannabis'=>'cannabis'),
array('fas fa-capsules'=>'capsules'),
array('fas fa-car'=>'car'),
array('fas fa-car-alt'=>'car-alt'),
array('fas fa-car-battery'=>'car-battery'),
array('fas fa-car-building'=>'car-building'),
array('fas fa-car-bump'=>'car-bump'),
array('fas fa-car-bus'=>'car-bus'),
array('fas fa-car-crash'=>'car-crash'),
array('fas fa-car-garage'=>'car-garage'),
array('fas fa-car-mechanic'=>'car-mechanic'),
array('fas fa-car-side'=>'car-side'),
array('fas fa-car-tilt'=>'car-tilt'),
array('fas fa-car-wash'=>'car-wash'),
array('fas fa-caravan'=>'caravan'),
array('fas fa-caravan-alt'=>'caravan-alt'),
array('fas fa-caret-circle-down'=>'caret-circle-down'),
array('fas fa-caret-circle-left'=>'caret-circle-left'),
array('fas fa-caret-circle-right'=>'caret-circle-right'),
array('fas fa-caret-circle-up'=>'caret-circle-up'),
array('fas fa-caret-down'=>'caret-down'),
array('fas fa-caret-left'=>'caret-left'),
array('fas fa-caret-right'=>'caret-right'),
array('fas fa-caret-square-down'=>'caret-square-down'),
array('fas fa-caret-square-left'=>'caret-square-left'),
array('fas fa-caret-square-right'=>'caret-square-right'),
array('fas fa-caret-square-up'=>'caret-square-up'),
array('fas fa-caret-up'=>'caret-up'),
array('fas fa-carrot'=>'carrot'),
array('fas fa-cars'=>'cars'),
array('fas fa-cart-arrow-down'=>'cart-arrow-down'),
array('fas fa-cart-plus'=>'cart-plus'),
array('fas fa-cash-register'=>'cash-register'),
array('fas fa-cassette-tape'=>'cassette-tape'),
array('fas fa-cat'=>'cat'),
array('fas fa-cat-space'=>'cat-space'),
array('fas fa-cauldron'=>'cauldron'),
array('fas fa-cctv'=>'cctv'),
array('fas fa-certificate'=>'certificate'),
array('fas fa-chair'=>'chair'),
array('fas fa-chair-office'=>'chair-office'),
array('fas fa-chalkboard'=>'chalkboard'),
array('fas fa-chalkboard-teacher'=>'chalkboard-teacher'),
array('fas fa-charging-station'=>'charging-station'),
array('fas fa-chart-area'=>'chart-area'),
array('fas fa-chart-bar'=>'chart-bar'),
array('fas fa-chart-line'=>'chart-line'),
array('fas fa-chart-line-down'=>'chart-line-down'),
array('fas fa-chart-network'=>'chart-network'),
array('fas fa-chart-pie'=>'chart-pie'),
array('fas fa-chart-pie-alt'=>'chart-pie-alt'),
array('fas fa-chart-scatter'=>'chart-scatter'),
array('fas fa-check'=>'check'),
array('fas fa-check-circle'=>'check-circle'),
array('fas fa-check-double'=>'check-double'),
array('fas fa-check-square'=>'check-square'),
array('fas fa-cheese'=>'cheese'),
array('fas fa-cheese-swiss'=>'cheese-swiss'),
array('fas fa-cheeseburger'=>'cheeseburger'),
array('fas fa-chess'=>'chess'),
array('fas fa-chess-bishop'=>'chess-bishop'),
array('fas fa-chess-bishop-alt'=>'chess-bishop-alt'),
array('fas fa-chess-board'=>'chess-board'),
array('fas fa-chess-clock'=>'chess-clock'),
array('fas fa-chess-clock-alt'=>'chess-clock-alt'),
array('fas fa-chess-king'=>'chess-king'),
array('fas fa-chess-king-alt'=>'chess-king-alt'),
array('fas fa-chess-knight'=>'chess-knight'),
array('fas fa-chess-knight-alt'=>'chess-knight-alt'),
array('fas fa-chess-pawn'=>'chess-pawn'),
array('fas fa-chess-pawn-alt'=>'chess-pawn-alt'),
array('fas fa-chess-queen'=>'chess-queen'),
array('fas fa-chess-queen-alt'=>'chess-queen-alt'),
array('fas fa-chess-rook'=>'chess-rook'),
array('fas fa-chess-rook-alt'=>'chess-rook-alt'),
array('fas fa-chevron-circle-down'=>'chevron-circle-down'),
array('fas fa-chevron-circle-left'=>'chevron-circle-left'),
array('fas fa-chevron-circle-right'=>'chevron-circle-right'),
array('fas fa-chevron-circle-up'=>'chevron-circle-up'),
array('fas fa-chevron-double-down'=>'chevron-double-down'),
array('fas fa-chevron-double-left'=>'chevron-double-left'),
array('fas fa-chevron-double-right'=>'chevron-double-right'),
array('fas fa-chevron-double-up'=>'chevron-double-up'),
array('fas fa-chevron-down'=>'chevron-down'),
array('fas fa-chevron-left'=>'chevron-left'),
array('fas fa-chevron-right'=>'chevron-right'),
array('fas fa-chevron-square-down'=>'chevron-square-down'),
array('fas fa-chevron-square-left'=>'chevron-square-left'),
array('fas fa-chevron-square-right'=>'chevron-square-right'),
array('fas fa-chevron-square-up'=>'chevron-square-up'),
array('fas fa-chevron-up'=>'chevron-up'),
array('fas fa-child'=>'child'),
array('fas fa-chimney'=>'chimney'),
array('fas fa-church'=>'church'),
array('fas fa-circle'=>'circle'),
array('fas fa-circle-notch'=>'circle-notch'),
array('fas fa-city'=>'city'),
array('fas fa-clarinet'=>'clarinet'),
array('fas fa-claw-marks'=>'claw-marks'),
array('fas fa-clinic-medical'=>'clinic-medical'),
array('fas fa-clipboard'=>'clipboard'),
array('fas fa-clipboard-check'=>'clipboard-check'),
array('fas fa-clipboard-list'=>'clipboard-list'),
array('fas fa-clipboard-list-check'=>'clipboard-list-check'),
array('fas fa-clipboard-prescription'=>'clipboard-prescription'),
array('fas fa-clipboard-user'=>'clipboard-user'),
array('fas fa-clock'=>'clock'),
array('fas fa-clone'=>'clone'),
array('fas fa-closed-captioning'=>'closed-captioning'),
array('fas fa-cloud'=>'cloud'),
array('fas fa-cloud-download'=>'cloud-download'),
array('fas fa-cloud-download-alt'=>'cloud-download-alt'),
array('fas fa-cloud-drizzle'=>'cloud-drizzle'),
array('fas fa-cloud-hail'=>'cloud-hail'),
array('fas fa-cloud-hail-mixed'=>'cloud-hail-mixed'),
array('fas fa-cloud-meatball'=>'cloud-meatball'),
array('fas fa-cloud-moon'=>'cloud-moon'),
array('fas fa-cloud-moon-rain'=>'cloud-moon-rain'),
array('fas fa-cloud-music'=>'cloud-music'),
array('fas fa-cloud-rain'=>'cloud-rain'),
array('fas fa-cloud-rainbow'=>'cloud-rainbow'),
array('fas fa-cloud-showers'=>'cloud-showers'),
array('fas fa-cloud-showers-heavy'=>'cloud-showers-heavy'),
array('fas fa-cloud-sleet'=>'cloud-sleet'),
array('fas fa-cloud-snow'=>'cloud-snow'),
array('fas fa-cloud-sun'=>'cloud-sun'),
array('fas fa-cloud-sun-rain'=>'cloud-sun-rain'),
array('fas fa-cloud-upload'=>'cloud-upload'),
array('fas fa-cloud-upload-alt'=>'cloud-upload-alt'),
array('fas fa-clouds'=>'clouds'),
array('fas fa-clouds-moon'=>'clouds-moon'),
array('fas fa-clouds-sun'=>'clouds-sun'),
array('fas fa-club'=>'club'),
array('fas fa-cocktail'=>'cocktail'),
array('fas fa-code'=>'code'),
array('fas fa-code-branch'=>'code-branch'),
array('fas fa-code-commit'=>'code-commit'),
array('fas fa-code-merge'=>'code-merge'),
array('fas fa-coffee'=>'coffee'),
array('fas fa-coffee-pot'=>'coffee-pot'),
array('fas fa-coffee-togo'=>'coffee-togo'),
array('fas fa-coffin'=>'coffin'),
array('fas fa-coffin-cross'=>'coffin-cross'),
array('fas fa-cog'=>'cog'),
array('fas fa-cogs'=>'cogs'),
array('fas fa-coin'=>'coin'),
array('fas fa-coins'=>'coins'),
array('fas fa-columns'=>'columns'),
array('fas fa-comet'=>'comet'),
array('fas fa-comment'=>'comment'),
array('fas fa-comment-alt'=>'comment-alt'),
array('fas fa-comment-alt-check'=>'comment-alt-check'),
array('fas fa-comment-alt-dollar'=>'comment-alt-dollar'),
array('fas fa-comment-alt-dots'=>'comment-alt-dots'),
array('fas fa-comment-alt-edit'=>'comment-alt-edit'),
array('fas fa-comment-alt-exclamation'=>'comment-alt-exclamation'),
array('fas fa-comment-alt-lines'=>'comment-alt-lines'),
array('fas fa-comment-alt-medical'=>'comment-alt-medical'),
array('fas fa-comment-alt-minus'=>'comment-alt-minus'),
array('fas fa-comment-alt-music'=>'comment-alt-music'),
array('fas fa-comment-alt-plus'=>'comment-alt-plus'),
array('fas fa-comment-alt-slash'=>'comment-alt-slash'),
array('fas fa-comment-alt-smile'=>'comment-alt-smile'),
array('fas fa-comment-alt-times'=>'comment-alt-times'),
array('fas fa-comment-check'=>'comment-check'),
array('fas fa-comment-dollar'=>'comment-dollar'),
array('fas fa-comment-dots'=>'comment-dots'),
array('fas fa-comment-edit'=>'comment-edit'),
array('fas fa-comment-exclamation'=>'comment-exclamation'),
array('fas fa-comment-lines'=>'comment-lines'),
array('fas fa-comment-medical'=>'comment-medical'),
array('fas fa-comment-minus'=>'comment-minus'),
array('fas fa-comment-music'=>'comment-music'),
array('fas fa-comment-plus'=>'comment-plus'),
array('fas fa-comment-slash'=>'comment-slash'),
array('fas fa-comment-smile'=>'comment-smile'),
array('fas fa-comment-times'=>'comment-times'),
array('fas fa-comments'=>'comments'),
array('fas fa-comments-alt'=>'comments-alt'),
array('fas fa-comments-alt-dollar'=>'comments-alt-dollar'),
array('fas fa-comments-dollar'=>'comments-dollar'),
array('fas fa-compact-disc'=>'compact-disc'),
array('fas fa-compass'=>'compass'),
array('fas fa-compass-slash'=>'compass-slash'),
array('fas fa-compress'=>'compress'),
array('fas fa-compress-alt'=>'compress-alt'),
array('fas fa-compress-arrows-alt'=>'compress-arrows-alt'),
array('fas fa-compress-wide'=>'compress-wide'),
array('fas fa-computer-classic'=>'computer-classic'),
array('fas fa-computer-speaker'=>'computer-speaker'),
array('fas fa-concierge-bell'=>'concierge-bell'),
array('fas fa-construction'=>'construction'),
array('fas fa-container-storage'=>'container-storage'),
array('fas fa-conveyor-belt'=>'conveyor-belt'),
array('fas fa-conveyor-belt-alt'=>'conveyor-belt-alt'),
array('fas fa-cookie'=>'cookie'),
array('fas fa-cookie-bite'=>'cookie-bite'),
array('fas fa-copy'=>'copy'),
array('fas fa-copyright'=>'copyright'),
array('fas fa-corn'=>'corn'),
array('fas fa-couch'=>'couch'),
array('fas fa-cow'=>'cow'),
array('fas fa-cowbell'=>'cowbell'),
array('fas fa-cowbell-more'=>'cowbell-more'),
array('fas fa-credit-card'=>'credit-card'),
array('fas fa-credit-card-blank'=>'credit-card-blank'),
array('fas fa-credit-card-front'=>'credit-card-front'),
array('fas fa-cricket'=>'cricket'),
array('fas fa-croissant'=>'croissant'),
array('fas fa-crop'=>'crop'),
array('fas fa-crop-alt'=>'crop-alt'),
array('fas fa-cross'=>'cross'),
array('fas fa-crosshairs'=>'crosshairs'),
array('fas fa-crow'=>'crow'),
array('fas fa-crown'=>'crown'),
array('fas fa-crutch'=>'crutch'),
array('fas fa-crutches'=>'crutches'),
array('fas fa-cube'=>'cube'),
array('fas fa-cubes'=>'cubes'),
array('fas fa-curling'=>'curling'),
array('fas fa-cut'=>'cut'),
array('fas fa-dagger'=>'dagger'),
array('fas fa-database'=>'database'),
array('fas fa-deaf'=>'deaf'),
array('fas fa-debug'=>'debug'),
array('fas fa-deer'=>'deer'),
array('fas fa-deer-rudolph'=>'deer-rudolph'),
array('fas fa-democrat'=>'democrat'),
array('fas fa-desktop'=>'desktop'),
array('fas fa-desktop-alt'=>'desktop-alt'),
array('fas fa-dewpoint'=>'dewpoint'),
array('fas fa-dharmachakra'=>'dharmachakra'),
array('fas fa-diagnoses'=>'diagnoses'),
array('fas fa-diamond'=>'diamond'),
array('fas fa-dice'=>'dice'),
array('fas fa-dice-d10'=>'dice-d10'),
array('fas fa-dice-d12'=>'dice-d12'),
array('fas fa-dice-d20'=>'dice-d20'),
array('fas fa-dice-d4'=>'dice-d4'),
array('fas fa-dice-d6'=>'dice-d6'),
array('fas fa-dice-d8'=>'dice-d8'),
array('fas fa-dice-five'=>'dice-five'),
array('fas fa-dice-four'=>'dice-four'),
array('fas fa-dice-one'=>'dice-one'),
array('fas fa-dice-six'=>'dice-six'),
array('fas fa-dice-three'=>'dice-three'),
array('fas fa-dice-two'=>'dice-two'),
array('fas fa-digging'=>'digging'),
array('fas fa-digital-tachograph'=>'digital-tachograph'),
array('fas fa-diploma'=>'diploma'),
array('fas fa-directions'=>'directions'),
array('fas fa-disc-drive'=>'disc-drive'),
array('fas fa-disease'=>'disease'),
array('fas fa-divide'=>'divide'),
array('fas fa-dizzy'=>'dizzy'),
array('fas fa-dna'=>'dna'),
array('fas fa-do-not-enter'=>'do-not-enter'),
array('fas fa-dog'=>'dog'),
array('fas fa-dog-leashed'=>'dog-leashed'),
array('fas fa-dollar-sign'=>'dollar-sign'),
array('fas fa-dolly'=>'dolly'),
array('fas fa-dolly-empty'=>'dolly-empty'),
array('fas fa-dolly-flatbed'=>'dolly-flatbed'),
array('fas fa-dolly-flatbed-alt'=>'dolly-flatbed-alt'),
array('fas fa-dolly-flatbed-empty'=>'dolly-flatbed-empty'),
array('fas fa-donate'=>'donate'),
array('fas fa-door-closed'=>'door-closed'),
array('fas fa-door-open'=>'door-open'),
array('fas fa-dot-circle'=>'dot-circle'),
array('fas fa-dove'=>'dove'),
array('fas fa-download'=>'download'),
array('fas fa-drafting-compass'=>'drafting-compass'),
array('fas fa-dragon'=>'dragon'),
array('fas fa-draw-circle'=>'draw-circle'),
array('fas fa-draw-polygon'=>'draw-polygon'),
array('fas fa-draw-square'=>'draw-square'),
array('fas fa-dreidel'=>'dreidel'),
array('fas fa-drone'=>'drone'),
array('fas fa-drone-alt'=>'drone-alt'),
array('fas fa-drum'=>'drum'),
array('fas fa-drum-steelpan'=>'drum-steelpan'),
array('fas fa-drumstick'=>'drumstick'),
array('fas fa-drumstick-bite'=>'drumstick-bite'),
array('fas fa-dryer'=>'dryer'),
array('fas fa-dryer-alt'=>'dryer-alt'),
array('fas fa-duck'=>'duck'),
array('fas fa-dumbbell'=>'dumbbell'),
array('fas fa-dumpster'=>'dumpster'),
array('fas fa-dumpster-fire'=>'dumpster-fire'),
array('fas fa-dungeon'=>'dungeon'),
array('fas fa-ear'=>'ear'),
array('fas fa-ear-muffs'=>'ear-muffs'),
array('fas fa-eclipse'=>'eclipse'),
array('fas fa-eclipse-alt'=>'eclipse-alt'),
array('fas fa-edit'=>'edit'),
array('fas fa-egg'=>'egg'),
array('fas fa-egg-fried'=>'egg-fried'),
array('fas fa-eject'=>'eject'),
array('fas fa-elephant'=>'elephant'),
array('fas fa-ellipsis-h'=>'ellipsis-h'),
array('fas fa-ellipsis-h-alt'=>'ellipsis-h-alt'),
array('fas fa-ellipsis-v'=>'ellipsis-v'),
array('fas fa-ellipsis-v-alt'=>'ellipsis-v-alt'),
array('fas fa-empty-set'=>'empty-set'),
array('fas fa-engine-warning'=>'engine-warning'),
array('fas fa-envelope'=>'envelope'),
array('fas fa-envelope-open'=>'envelope-open'),
array('fas fa-envelope-open-dollar'=>'envelope-open-dollar'),
array('fas fa-envelope-open-text'=>'envelope-open-text'),
array('fas fa-envelope-square'=>'envelope-square'),
array('fas fa-equals'=>'equals'),
array('fas fa-eraser'=>'eraser'),
array('fas fa-ethernet'=>'ethernet'),
array('fas fa-euro-sign'=>'euro-sign'),
array('fas fa-exchange'=>'exchange'),
array('fas fa-exchange-alt'=>'exchange-alt'),
array('fas fa-exclamation'=>'exclamation'),
array('fas fa-exclamation-circle'=>'exclamation-circle'),
array('fas fa-exclamation-square'=>'exclamation-square'),
array('fas fa-exclamation-triangle'=>'exclamation-triangle'),
array('fas fa-expand'=>'expand'),
array('fas fa-expand-alt'=>'expand-alt'),
array('fas fa-expand-arrows'=>'expand-arrows'),
array('fas fa-expand-arrows-alt'=>'expand-arrows-alt'),
array('fas fa-expand-wide'=>'expand-wide'),
array('fas fa-external-link'=>'external-link'),
array('fas fa-external-link-alt'=>'external-link-alt'),
array('fas fa-external-link-square'=>'external-link-square'),
array('fas fa-external-link-square-alt'=>'external-link-square-alt'),
array('fas fa-eye'=>'eye'),
array('fas fa-eye-dropper'=>'eye-dropper'),
array('fas fa-eye-evil'=>'eye-evil'),
array('fas fa-eye-slash'=>'eye-slash'),
array('fas fa-fan'=>'fan'),
array('fas fa-fan-table'=>'fan-table'),
array('fas fa-farm'=>'farm'),
array('fas fa-fast-backward'=>'fast-backward'),
array('fas fa-fast-forward'=>'fast-forward'),
array('fas fa-faucet'=>'faucet'),
array('fas fa-faucet-drip'=>'faucet-drip'),
array('fas fa-fax'=>'fax'),
array('fas fa-feather'=>'feather'),
array('fas fa-feather-alt'=>'feather-alt'),
array('fas fa-female'=>'female'),
array('fas fa-field-hockey'=>'field-hockey'),
array('fas fa-fighter-jet'=>'fighter-jet'),
array('fas fa-file'=>'file'),
array('fas fa-file-alt'=>'file-alt'),
array('fas fa-file-archive'=>'file-archive'),
array('fas fa-file-audio'=>'file-audio'),
array('fas fa-file-certificate'=>'file-certificate'),
array('fas fa-file-chart-line'=>'file-chart-line'),
array('fas fa-file-chart-pie'=>'file-chart-pie'),
array('fas fa-file-check'=>'file-check'),
array('fas fa-file-code'=>'file-code'),
array('fas fa-file-contract'=>'file-contract'),
array('fas fa-file-csv'=>'file-csv'),
array('fas fa-file-download'=>'file-download'),
array('fas fa-file-edit'=>'file-edit'),
array('fas fa-file-excel'=>'file-excel'),
array('fas fa-file-exclamation'=>'file-exclamation'),
array('fas fa-file-export'=>'file-export'),
array('fas fa-file-image'=>'file-image'),
array('fas fa-file-import'=>'file-import'),
array('fas fa-file-invoice'=>'file-invoice'),
array('fas fa-file-invoice-dollar'=>'file-invoice-dollar'),
array('fas fa-file-medical'=>'file-medical'),
array('fas fa-file-medical-alt'=>'file-medical-alt'),
array('fas fa-file-minus'=>'file-minus'),
array('fas fa-file-music'=>'file-music'),
array('fas fa-file-pdf'=>'file-pdf'),
array('fas fa-file-plus'=>'file-plus'),
array('fas fa-file-powerpoint'=>'file-powerpoint'),
array('fas fa-file-prescription'=>'file-prescription'),
array('fas fa-file-search'=>'file-search'),
array('fas fa-file-signature'=>'file-signature'),
array('fas fa-file-spreadsheet'=>'file-spreadsheet'),
array('fas fa-file-times'=>'file-times'),
array('fas fa-file-upload'=>'file-upload'),
array('fas fa-file-user'=>'file-user'),
array('fas fa-file-video'=>'file-video'),
array('fas fa-file-word'=>'file-word'),
array('fas fa-files-medical'=>'files-medical'),
array('fas fa-fill'=>'fill'),
array('fas fa-fill-drip'=>'fill-drip'),
array('fas fa-film'=>'film'),
array('fas fa-film-alt'=>'film-alt'),
array('fas fa-film-canister'=>'film-canister'),
array('fas fa-filter'=>'filter'),
array('fas fa-fingerprint'=>'fingerprint'),
array('fas fa-fire'=>'fire'),
array('fas fa-fire-alt'=>'fire-alt'),
array('fas fa-fire-extinguisher'=>'fire-extinguisher'),
array('fas fa-fire-smoke'=>'fire-smoke'),
array('fas fa-fireplace'=>'fireplace'),
array('fas fa-first-aid'=>'first-aid'),
array('fas fa-fish'=>'fish'),
array('fas fa-fish-cooked'=>'fish-cooked'),
array('fas fa-fist-raised'=>'fist-raised'),
array('fas fa-flag'=>'flag'),
array('fas fa-flag-alt'=>'flag-alt'),
array('fas fa-flag-checkered'=>'flag-checkered'),
array('fas fa-flag-usa'=>'flag-usa'),
array('fas fa-flame'=>'flame'),
array('fas fa-flashlight'=>'flashlight'),
array('fas fa-flask'=>'flask'),
array('fas fa-flask-poison'=>'flask-poison'),
array('fas fa-flask-potion'=>'flask-potion'),
array('fas fa-flower'=>'flower'),
array('fas fa-flower-daffodil'=>'flower-daffodil'),
array('fas fa-flower-tulip'=>'flower-tulip'),
array('fas fa-flushed'=>'flushed'),
array('fas fa-flute'=>'flute'),
array('fas fa-flux-capacitor'=>'flux-capacitor'),
array('fas fa-fog'=>'fog'),
array('fas fa-folder'=>'folder'),
array('fas fa-folder-download'=>'folder-download'),
array('fas fa-folder-minus'=>'folder-minus'),
array('fas fa-folder-open'=>'folder-open'),
array('fas fa-folder-plus'=>'folder-plus'),
array('fas fa-folder-times'=>'folder-times'),
array('fas fa-folder-tree'=>'folder-tree'),
array('fas fa-folder-upload'=>'folder-upload'),
array('fas fa-folders'=>'folders'),
array('fas fa-font'=>'font'),
array('fas fa-font-case'=>'font-case'),
array('fas fa-football-ball'=>'football-ball'),
array('fas fa-football-helmet'=>'football-helmet'),
array('fas fa-forklift'=>'forklift'),
array('fas fa-forward'=>'forward'),
array('fas fa-fragile'=>'fragile'),
array('fas fa-french-fries'=>'french-fries'),
array('fas fa-frog'=>'frog'),
array('fas fa-frosty-head'=>'frosty-head'),
array('fas fa-frown'=>'frown'),
array('fas fa-frown-open'=>'frown-open'),
array('fas fa-function'=>'function'),
array('fas fa-funnel-dollar'=>'funnel-dollar'),
array('fas fa-futbol'=>'futbol'),
array('fas fa-galaxy'=>'galaxy'),
array('fas fa-game-board'=>'game-board'),
array('fas fa-game-board-alt'=>'game-board-alt'),
array('fas fa-game-console-handheld'=>'game-console-handheld'),
array('fas fa-gamepad'=>'gamepad'),
array('fas fa-gamepad-alt'=>'gamepad-alt'),
array('fas fa-garage'=>'garage'),
array('fas fa-garage-car'=>'garage-car'),
array('fas fa-garage-open'=>'garage-open'),
array('fas fa-gas-pump'=>'gas-pump'),
array('fas fa-gas-pump-slash'=>'gas-pump-slash'),
array('fas fa-gavel'=>'gavel'),
array('fas fa-gem'=>'gem'),
array('fas fa-genderless'=>'genderless'),
array('fas fa-ghost'=>'ghost'),
array('fas fa-gift'=>'gift'),
array('fas fa-gift-card'=>'gift-card'),
array('fas fa-gifts'=>'gifts'),
array('fas fa-gingerbread-man'=>'gingerbread-man'),
array('fas fa-glass'=>'glass'),
array('fas fa-glass-champagne'=>'glass-champagne'),
array('fas fa-glass-cheers'=>'glass-cheers'),
array('fas fa-glass-citrus'=>'glass-citrus'),
array('fas fa-glass-martini'=>'glass-martini'),
array('fas fa-glass-martini-alt'=>'glass-martini-alt'),
array('fas fa-glass-whiskey'=>'glass-whiskey'),
array('fas fa-glass-whiskey-rocks'=>'glass-whiskey-rocks'),
array('fas fa-glasses'=>'glasses'),
array('fas fa-glasses-alt'=>'glasses-alt'),
array('fas fa-globe'=>'globe'),
array('fas fa-globe-africa'=>'globe-africa'),
array('fas fa-globe-americas'=>'globe-americas'),
array('fas fa-globe-asia'=>'globe-asia'),
array('fas fa-globe-europe'=>'globe-europe'),
array('fas fa-globe-snow'=>'globe-snow'),
array('fas fa-globe-stand'=>'globe-stand'),
array('fas fa-golf-ball'=>'golf-ball'),
array('fas fa-golf-club'=>'golf-club'),
array('fas fa-gopuram'=>'gopuram'),
array('fas fa-graduation-cap'=>'graduation-cap'),
array('fas fa-gramophone'=>'gramophone'),
array('fas fa-greater-than'=>'greater-than'),
array('fas fa-greater-than-equal'=>'greater-than-equal'),
array('fas fa-grimace'=>'grimace'),
array('fas fa-grin'=>'grin'),
array('fas fa-grin-alt'=>'grin-alt'),
array('fas fa-grin-beam'=>'grin-beam'),
array('fas fa-grin-beam-sweat'=>'grin-beam-sweat'),
array('fas fa-grin-hearts'=>'grin-hearts'),
array('fas fa-grin-squint'=>'grin-squint'),
array('fas fa-grin-squint-tears'=>'grin-squint-tears'),
array('fas fa-grin-stars'=>'grin-stars'),
array('fas fa-grin-tears'=>'grin-tears'),
array('fas fa-grin-tongue'=>'grin-tongue'),
array('fas fa-grin-tongue-squint'=>'grin-tongue-squint'),
array('fas fa-grin-tongue-wink'=>'grin-tongue-wink'),
array('fas fa-grin-wink'=>'grin-wink'),
array('fas fa-grip-horizontal'=>'grip-horizontal'),
array('fas fa-grip-lines'=>'grip-lines'),
array('fas fa-grip-lines-vertical'=>'grip-lines-vertical'),
array('fas fa-grip-vertical'=>'grip-vertical'),
array('fas fa-guitar'=>'guitar'),
array('fas fa-guitar-electric'=>'guitar-electric'),
array('fas fa-guitars'=>'guitars'),
array('fas fa-h-square'=>'h-square'),
array('fas fa-h1'=>'h1'),
array('fas fa-h2'=>'h2'),
array('fas fa-h3'=>'h3'),
array('fas fa-h4'=>'h4'),
array('fas fa-hamburger'=>'hamburger'),
array('fas fa-hammer'=>'hammer'),
array('fas fa-hammer-war'=>'hammer-war'),
array('fas fa-hamsa'=>'hamsa'),
array('fas fa-hand-heart'=>'hand-heart'),
array('fas fa-hand-holding'=>'hand-holding'),
array('fas fa-hand-holding-box'=>'hand-holding-box'),
array('fas fa-hand-holding-heart'=>'hand-holding-heart'),
array('fas fa-hand-holding-magic'=>'hand-holding-magic'),
array('fas fa-hand-holding-seedling'=>'hand-holding-seedling'),
array('fas fa-hand-holding-usd'=>'hand-holding-usd'),
array('fas fa-hand-holding-water'=>'hand-holding-water'),
array('fas fa-hand-lizard'=>'hand-lizard'),
array('fas fa-hand-middle-finger'=>'hand-middle-finger'),
array('fas fa-hand-paper'=>'hand-paper'),
array('fas fa-hand-peace'=>'hand-peace'),
array('fas fa-hand-point-down'=>'hand-point-down'),
array('fas fa-hand-point-left'=>'hand-point-left'),
array('fas fa-hand-point-right'=>'hand-point-right'),
array('fas fa-hand-point-up'=>'hand-point-up'),
array('fas fa-hand-pointer'=>'hand-pointer'),
array('fas fa-hand-receiving'=>'hand-receiving'),
array('fas fa-hand-rock'=>'hand-rock'),
array('fas fa-hand-scissors'=>'hand-scissors'),
array('fas fa-hand-spock'=>'hand-spock'),
array('fas fa-hands'=>'hands'),
array('fas fa-hands-heart'=>'hands-heart'),
array('fas fa-hands-helping'=>'hands-helping'),
array('fas fa-hands-usd'=>'hands-usd'),
array('fas fa-handshake'=>'handshake'),
array('fas fa-handshake-alt'=>'handshake-alt'),
array('fas fa-hanukiah'=>'hanukiah'),
array('fas fa-hard-hat'=>'hard-hat'),
array('fas fa-hashtag'=>'hashtag'),
array('fas fa-hat-chef'=>'hat-chef'),
array('fas fa-hat-cowboy'=>'hat-cowboy'),
array('fas fa-hat-cowboy-side'=>'hat-cowboy-side'),
array('fas fa-hat-santa'=>'hat-santa'),
array('fas fa-hat-winter'=>'hat-winter'),
array('fas fa-hat-witch'=>'hat-witch'),
array('fas fa-hat-wizard'=>'hat-wizard'),
array('fas fa-hdd'=>'hdd'),
array('fas fa-head-side'=>'head-side'),
array('fas fa-head-side-brain'=>'head-side-brain'),
array('fas fa-head-side-headphones'=>'head-side-headphones'),
array('fas fa-head-side-medical'=>'head-side-medical'),
array('fas fa-head-vr'=>'head-vr'),
array('fas fa-heading'=>'heading'),
array('fas fa-headphones'=>'headphones'),
array('fas fa-headphones-alt'=>'headphones-alt'),
array('fas fa-headset'=>'headset'),
array('fas fa-heart'=>'heart'),
array('fas fa-heart-broken'=>'heart-broken'),
array('fas fa-heart-circle'=>'heart-circle'),
array('fas fa-heart-rate'=>'heart-rate'),
array('fas fa-heart-square'=>'heart-square'),
array('fas fa-heartbeat'=>'heartbeat'),
array('fas fa-heat'=>'heat'),
array('fas fa-helicopter'=>'helicopter'),
array('fas fa-helmet-battle'=>'helmet-battle'),
array('fas fa-hexagon'=>'hexagon'),
array('fas fa-highlighter'=>'highlighter'),
array('fas fa-hiking'=>'hiking'),
array('fas fa-hippo'=>'hippo'),
array('fas fa-history'=>'history'),
array('fas fa-hockey-mask'=>'hockey-mask'),
array('fas fa-hockey-puck'=>'hockey-puck'),
array('fas fa-hockey-sticks'=>'hockey-sticks'),
array('fas fa-holly-berry'=>'holly-berry'),
array('fas fa-home'=>'home'),
array('fas fa-home-alt'=>'home-alt'),
array('fas fa-home-heart'=>'home-heart'),
array('fas fa-home-lg'=>'home-lg'),
array('fas fa-home-lg-alt'=>'home-lg-alt'),
array('fas fa-hood-cloak'=>'hood-cloak'),
array('fas fa-horizontal-rule'=>'horizontal-rule'),
array('fas fa-horse'=>'horse'),
array('fas fa-horse-head'=>'horse-head'),
array('fas fa-horse-saddle'=>'horse-saddle'),
array('fas fa-hospital'=>'hospital'),
array('fas fa-hospital-alt'=>'hospital-alt'),
array('fas fa-hospital-symbol'=>'hospital-symbol'),
array('fas fa-hospital-user'=>'hospital-user'),
array('fas fa-hospitals'=>'hospitals'),
array('fas fa-hot-tub'=>'hot-tub'),
array('fas fa-hotdog'=>'hotdog'),
array('fas fa-hotel'=>'hotel'),
array('fas fa-hourglass'=>'hourglass'),
array('fas fa-hourglass-end'=>'hourglass-end'),
array('fas fa-hourglass-half'=>'hourglass-half'),
array('fas fa-hourglass-start'=>'hourglass-start'),
array('fas fa-house'=>'house'),
array('fas fa-house-damage'=>'house-damage'),
array('fas fa-house-day'=>'house-day'),
array('fas fa-house-flood'=>'house-flood'),
array('fas fa-house-leave'=>'house-leave'),
array('fas fa-house-night'=>'house-night'),
array('fas fa-house-return'=>'house-return'),
array('fas fa-house-signal'=>'house-signal'),
array('fas fa-hryvnia'=>'hryvnia'),
array('fas fa-humidity'=>'humidity'),
array('fas fa-hurricane'=>'hurricane'),
array('fas fa-i-cursor'=>'i-cursor'),
array('fas fa-ice-cream'=>'ice-cream'),
array('fas fa-ice-skate'=>'ice-skate'),
array('fas fa-icicles'=>'icicles'),
array('fas fa-icons'=>'icons'),
array('fas fa-icons-alt'=>'icons-alt'),
array('fas fa-id-badge'=>'id-badge'),
array('fas fa-id-card'=>'id-card'),
array('fas fa-id-card-alt'=>'id-card-alt'),
array('fas fa-igloo'=>'igloo'),
array('fas fa-image'=>'image'),
array('fas fa-image-polaroid'=>'image-polaroid'),
array('fas fa-images'=>'images'),
array('fas fa-inbox'=>'inbox'),
array('fas fa-inbox-in'=>'inbox-in'),
array('fas fa-inbox-out'=>'inbox-out'),
array('fas fa-indent'=>'indent'),
array('fas fa-industry'=>'industry'),
array('fas fa-industry-alt'=>'industry-alt'),
array('fas fa-infinity'=>'infinity'),
array('fas fa-info'=>'info'),
array('fas fa-info-circle'=>'info-circle'),
array('fas fa-info-square'=>'info-square'),
array('fas fa-inhaler'=>'inhaler'),
array('fas fa-integral'=>'integral'),
array('fas fa-intersection'=>'intersection'),
array('fas fa-inventory'=>'inventory'),
array('fas fa-island-tropical'=>'island-tropical'),
array('fas fa-italic'=>'italic'),
array('fas fa-jack-o-lantern'=>'jack-o-lantern'),
array('fas fa-jedi'=>'jedi'),
array('fas fa-joint'=>'joint'),
array('fas fa-journal-whills'=>'journal-whills'),
array('fas fa-joystick'=>'joystick'),
array('fas fa-jug'=>'jug'),
array('fas fa-kaaba'=>'kaaba'),
array('fas fa-kazoo'=>'kazoo'),
array('fas fa-kerning'=>'kerning'),
array('fas fa-key'=>'key'),
array('fas fa-key-skeleton'=>'key-skeleton'),
array('fas fa-keyboard'=>'keyboard'),
array('fas fa-keynote'=>'keynote'),
array('fas fa-khanda'=>'khanda'),
array('fas fa-kidneys'=>'kidneys'),
array('fas fa-kiss'=>'kiss'),
array('fas fa-kiss-beam'=>'kiss-beam'),
array('fas fa-kiss-wink-heart'=>'kiss-wink-heart'),
array('fas fa-kite'=>'kite'),
array('fas fa-kiwi-bird'=>'kiwi-bird'),
array('fas fa-knife-kitchen'=>'knife-kitchen'),
array('fas fa-lambda'=>'lambda'),
array('fas fa-lamp'=>'lamp'),
array('fas fa-lamp-desk'=>'lamp-desk'),
array('fas fa-lamp-floor'=>'lamp-floor'),
array('fas fa-landmark'=>'landmark'),
array('fas fa-landmark-alt'=>'landmark-alt'),
array('fas fa-language'=>'language'),
array('fas fa-laptop'=>'laptop'),
array('fas fa-laptop-code'=>'laptop-code'),
array('fas fa-laptop-medical'=>'laptop-medical'),
array('fas fa-lasso'=>'lasso'),
array('fas fa-laugh'=>'laugh'),
array('fas fa-laugh-beam'=>'laugh-beam'),
array('fas fa-laugh-squint'=>'laugh-squint'),
array('fas fa-laugh-wink'=>'laugh-wink'),
array('fas fa-layer-group'=>'layer-group'),
array('fas fa-layer-minus'=>'layer-minus'),
array('fas fa-layer-plus'=>'layer-plus'),
array('fas fa-leaf'=>'leaf'),
array('fas fa-leaf-heart'=>'leaf-heart'),
array('fas fa-leaf-maple'=>'leaf-maple'),
array('fas fa-leaf-oak'=>'leaf-oak'),
array('fas fa-lemon'=>'lemon'),
array('fas fa-less-than'=>'less-than'),
array('fas fa-less-than-equal'=>'less-than-equal'),
array('fas fa-level-down'=>'level-down'),
array('fas fa-level-down-alt'=>'level-down-alt'),
array('fas fa-level-up'=>'level-up'),
array('fas fa-level-up-alt'=>'level-up-alt'),
array('fas fa-life-ring'=>'life-ring'),
array('fas fa-light-ceiling'=>'light-ceiling'),
array('fas fa-light-switch'=>'light-switch'),
array('fas fa-light-switch-off'=>'light-switch-off'),
array('fas fa-light-switch-on'=>'light-switch-on'),
array('fas fa-lightbulb'=>'lightbulb'),
array('fas fa-lightbulb-dollar'=>'lightbulb-dollar'),
array('fas fa-lightbulb-exclamation'=>'lightbulb-exclamation'),
array('fas fa-lightbulb-on'=>'lightbulb-on'),
array('fas fa-lightbulb-slash'=>'lightbulb-slash'),
array('fas fa-lights-holiday'=>'lights-holiday'),
array('fas fa-line-columns'=>'line-columns'),
array('fas fa-line-height'=>'line-height'),
array('fas fa-link'=>'link'),
array('fas fa-lips'=>'lips'),
array('fas fa-lira-sign'=>'lira-sign'),
array('fas fa-list'=>'list'),
array('fas fa-list-alt'=>'list-alt'),
array('fas fa-list-music'=>'list-music'),
array('fas fa-list-ol'=>'list-ol'),
array('fas fa-list-ul'=>'list-ul'),
array('fas fa-location'=>'location'),
array('fas fa-location-arrow'=>'location-arrow'),
array('fas fa-location-circle'=>'location-circle'),
array('fas fa-location-slash'=>'location-slash'),
array('fas fa-lock'=>'lock'),
array('fas fa-lock-alt'=>'lock-alt'),
array('fas fa-lock-open'=>'lock-open'),
array('fas fa-lock-open-alt'=>'lock-open-alt'),
array('fas fa-long-arrow-alt-down'=>'long-arrow-alt-down'),
array('fas fa-long-arrow-alt-left'=>'long-arrow-alt-left'),
array('fas fa-long-arrow-alt-right'=>'long-arrow-alt-right'),
array('fas fa-long-arrow-alt-up'=>'long-arrow-alt-up'),
array('fas fa-long-arrow-down'=>'long-arrow-down'),
array('fas fa-long-arrow-left'=>'long-arrow-left'),
array('fas fa-long-arrow-right'=>'long-arrow-right'),
array('fas fa-long-arrow-up'=>'long-arrow-up'),
array('fas fa-loveseat'=>'loveseat'),
array('fas fa-low-vision'=>'low-vision'),
array('fas fa-luchador'=>'luchador'),
array('fas fa-luggage-cart'=>'luggage-cart'),
array('fas fa-lungs'=>'lungs'),
array('fas fa-mace'=>'mace'),
array('fas fa-magic'=>'magic'),
array('fas fa-magnet'=>'magnet'),
array('fas fa-mail-bulk'=>'mail-bulk'),
array('fas fa-mailbox'=>'mailbox'),
array('fas fa-male'=>'male'),
array('fas fa-mandolin'=>'mandolin'),
array('fas fa-map'=>'map'),
array('fas fa-map-marked'=>'map-marked'),
array('fas fa-map-marked-alt'=>'map-marked-alt'),
array('fas fa-map-marker'=>'map-marker'),
array('fas fa-map-marker-alt'=>'map-marker-alt'),
array('fas fa-map-marker-alt-slash'=>'map-marker-alt-slash'),
array('fas fa-map-marker-check'=>'map-marker-check'),
array('fas fa-map-marker-edit'=>'map-marker-edit'),
array('fas fa-map-marker-exclamation'=>'map-marker-exclamation'),
array('fas fa-map-marker-minus'=>'map-marker-minus'),
array('fas fa-map-marker-plus'=>'map-marker-plus'),
array('fas fa-map-marker-question'=>'map-marker-question'),
array('fas fa-map-marker-slash'=>'map-marker-slash'),
array('fas fa-map-marker-smile'=>'map-marker-smile'),
array('fas fa-map-marker-times'=>'map-marker-times'),
array('fas fa-map-pin'=>'map-pin'),
array('fas fa-map-signs'=>'map-signs'),
array('fas fa-marker'=>'marker'),
array('fas fa-mars'=>'mars'),
array('fas fa-mars-double'=>'mars-double'),
array('fas fa-mars-stroke'=>'mars-stroke'),
array('fas fa-mars-stroke-h'=>'mars-stroke-h'),
array('fas fa-mars-stroke-v'=>'mars-stroke-v'),
array('fas fa-mask'=>'mask'),
array('fas fa-meat'=>'meat'),
array('fas fa-medal'=>'medal'),
array('fas fa-medkit'=>'medkit'),
array('fas fa-megaphone'=>'megaphone'),
array('fas fa-meh'=>'meh'),
array('fas fa-meh-blank'=>'meh-blank'),
array('fas fa-meh-rolling-eyes'=>'meh-rolling-eyes'),
array('fas fa-memory'=>'memory'),
array('fas fa-menorah'=>'menorah'),
array('fas fa-mercury'=>'mercury'),
array('fas fa-meteor'=>'meteor'),
array('fas fa-microchip'=>'microchip'),
array('fas fa-microphone'=>'microphone'),
array('fas fa-microphone-alt'=>'microphone-alt'),
array('fas fa-microphone-alt-slash'=>'microphone-alt-slash'),
array('fas fa-microphone-slash'=>'microphone-slash'),
array('fas fa-microphone-stand'=>'microphone-stand'),
array('fas fa-microscope'=>'microscope'),
array('fas fa-microwave'=>'microwave'),
array('fas fa-mind-share'=>'mind-share'),
array('fas fa-minus'=>'minus'),
array('fas fa-minus-circle'=>'minus-circle'),
array('fas fa-minus-hexagon'=>'minus-hexagon'),
array('fas fa-minus-octagon'=>'minus-octagon'),
array('fas fa-minus-square'=>'minus-square'),
array('fas fa-mistletoe'=>'mistletoe'),
array('fas fa-mitten'=>'mitten'),
array('fas fa-mobile'=>'mobile'),
array('fas fa-mobile-alt'=>'mobile-alt'),
array('fas fa-mobile-android'=>'mobile-android'),
array('fas fa-mobile-android-alt'=>'mobile-android-alt'),
array('fas fa-money-bill'=>'money-bill'),
array('fas fa-money-bill-alt'=>'money-bill-alt'),
array('fas fa-money-bill-wave'=>'money-bill-wave'),
array('fas fa-money-bill-wave-alt'=>'money-bill-wave-alt'),
array('fas fa-money-check'=>'money-check'),
array('fas fa-money-check-alt'=>'money-check-alt'),
array('fas fa-money-check-edit'=>'money-check-edit'),
array('fas fa-money-check-edit-alt'=>'money-check-edit-alt'),
array('fas fa-monitor-heart-rate'=>'monitor-heart-rate'),
array('fas fa-monkey'=>'monkey'),
array('fas fa-monument'=>'monument'),
array('fas fa-moon'=>'moon'),
array('fas fa-moon-cloud'=>'moon-cloud'),
array('fas fa-moon-stars'=>'moon-stars'),
array('fas fa-mortar-pestle'=>'mortar-pestle'),
array('fas fa-mosque'=>'mosque'),
array('fas fa-motorcycle'=>'motorcycle'),
array('fas fa-mountain'=>'mountain'),
array('fas fa-mountains'=>'mountains'),
array('fas fa-mouse'=>'mouse'),
array('fas fa-mouse-alt'=>'mouse-alt'),
array('fas fa-mouse-pointer'=>'mouse-pointer'),
array('fas fa-mp3-player'=>'mp3-player'),
array('fas fa-mug'=>'mug'),
array('fas fa-mug-hot'=>'mug-hot'),
array('fas fa-mug-marshmallows'=>'mug-marshmallows'),
array('fas fa-mug-tea'=>'mug-tea'),
array('fas fa-music'=>'music'),
array('fas fa-music-alt'=>'music-alt'),
array('fas fa-music-alt-slash'=>'music-alt-slash'),
array('fas fa-music-slash'=>'music-slash'),
array('fas fa-narwhal'=>'narwhal'),
array('fas fa-network-wired'=>'network-wired'),
array('fas fa-neuter'=>'neuter'),
array('fas fa-newspaper'=>'newspaper'),
array('fas fa-not-equal'=>'not-equal'),
array('fas fa-notes-medical'=>'notes-medical'),
array('fas fa-object-group'=>'object-group'),
array('fas fa-object-ungroup'=>'object-ungroup'),
array('fas fa-octagon'=>'octagon'),
array('fas fa-oil-can'=>'oil-can'),
array('fas fa-oil-temp'=>'oil-temp'),
array('fas fa-om'=>'om'),
array('fas fa-omega'=>'omega'),
array('fas fa-ornament'=>'ornament'),
array('fas fa-otter'=>'otter'),
array('fas fa-outdent'=>'outdent'),
array('fas fa-outlet'=>'outlet'),
array('fas fa-oven'=>'oven'),
array('fas fa-overline'=>'overline'),
array('fas fa-page-break'=>'page-break'),
array('fas fa-pager'=>'pager'),
array('fas fa-paint-brush'=>'paint-brush'),
array('fas fa-paint-brush-alt'=>'paint-brush-alt'),
array('fas fa-paint-roller'=>'paint-roller'),
array('fas fa-palette'=>'palette'),
array('fas fa-pallet'=>'pallet'),
array('fas fa-pallet-alt'=>'pallet-alt'),
array('fas fa-paper-plane'=>'paper-plane'),
array('fas fa-paperclip'=>'paperclip'),
array('fas fa-parachute-box'=>'parachute-box'),
array('fas fa-paragraph'=>'paragraph'),
array('fas fa-paragraph-rtl'=>'paragraph-rtl'),
array('fas fa-parking'=>'parking'),
array('fas fa-parking-circle'=>'parking-circle'),
array('fas fa-parking-circle-slash'=>'parking-circle-slash'),
array('fas fa-parking-slash'=>'parking-slash'),
array('fas fa-passport'=>'passport'),
array('fas fa-pastafarianism'=>'pastafarianism'),
array('fas fa-paste'=>'paste'),
array('fas fa-pause'=>'pause'),
array('fas fa-pause-circle'=>'pause-circle'),
array('fas fa-paw'=>'paw'),
array('fas fa-paw-alt'=>'paw-alt'),
array('fas fa-paw-claws'=>'paw-claws'),
array('fas fa-peace'=>'peace'),
array('fas fa-pegasus'=>'pegasus'),
array('fas fa-pen'=>'pen'),
array('fas fa-pen-alt'=>'pen-alt'),
array('fas fa-pen-fancy'=>'pen-fancy'),
array('fas fa-pen-nib'=>'pen-nib'),
array('fas fa-pen-square'=>'pen-square'),
array('fas fa-pencil'=>'pencil'),
array('fas fa-pencil-alt'=>'pencil-alt'),
array('fas fa-pencil-paintbrush'=>'pencil-paintbrush'),
array('fas fa-pencil-ruler'=>'pencil-ruler'),
array('fas fa-pennant'=>'pennant'),
array('fas fa-people-carry'=>'people-carry'),
array('fas fa-pepper-hot'=>'pepper-hot'),
array('fas fa-percent'=>'percent'),
array('fas fa-percentage'=>'percentage'),
array('fas fa-person-booth'=>'person-booth'),
array('fas fa-person-carry'=>'person-carry'),
array('fas fa-person-dolly'=>'person-dolly'),
array('fas fa-person-dolly-empty'=>'person-dolly-empty'),
array('fas fa-person-sign'=>'person-sign'),
array('fas fa-phone'=>'phone'),
array('fas fa-phone-alt'=>'phone-alt'),
array('fas fa-phone-laptop'=>'phone-laptop'),
array('fas fa-phone-office'=>'phone-office'),
array('fas fa-phone-plus'=>'phone-plus'),
array('fas fa-phone-rotary'=>'phone-rotary'),
array('fas fa-phone-slash'=>'phone-slash'),
array('fas fa-phone-square'=>'phone-square'),
array('fas fa-phone-square-alt'=>'phone-square-alt'),
array('fas fa-phone-volume'=>'phone-volume'),
array('fas fa-photo-video'=>'photo-video'),
array('fas fa-pi'=>'pi'),
array('fas fa-piano'=>'piano'),
array('fas fa-piano-keyboard'=>'piano-keyboard'),
array('fas fa-pie'=>'pie'),
array('fas fa-pig'=>'pig'),
array('fas fa-piggy-bank'=>'piggy-bank'),
array('fas fa-pills'=>'pills'),
array('fas fa-pizza'=>'pizza'),
array('fas fa-pizza-slice'=>'pizza-slice'),
array('fas fa-place-of-worship'=>'place-of-worship'),
array('fas fa-plane'=>'plane'),
array('fas fa-plane-alt'=>'plane-alt'),
array('fas fa-plane-arrival'=>'plane-arrival'),
array('fas fa-plane-departure'=>'plane-departure'),
array('fas fa-planet-moon'=>'planet-moon'),
array('fas fa-planet-ringed'=>'planet-ringed'),
array('fas fa-play'=>'play'),
array('fas fa-play-circle'=>'play-circle'),
array('fas fa-plug'=>'plug'),
array('fas fa-plus'=>'plus'),
array('fas fa-plus-circle'=>'plus-circle'),
array('fas fa-plus-hexagon'=>'plus-hexagon'),
array('fas fa-plus-octagon'=>'plus-octagon'),
array('fas fa-plus-square'=>'plus-square'),
array('fas fa-podcast'=>'podcast'),
array('fas fa-podium'=>'podium'),
array('fas fa-podium-star'=>'podium-star'),
array('fas fa-police-box'=>'police-box'),
array('fas fa-poll'=>'poll'),
array('fas fa-poll-h'=>'poll-h'),
array('fas fa-poll-people'=>'poll-people'),
array('fas fa-poo'=>'poo'),
array('fas fa-poo-storm'=>'poo-storm'),
array('fas fa-poop'=>'poop'),
array('fas fa-popcorn'=>'popcorn'),
array('fas fa-portal-enter'=>'portal-enter'),
array('fas fa-portal-exit'=>'portal-exit'),
array('fas fa-portrait'=>'portrait'),
array('fas fa-pound-sign'=>'pound-sign'),
array('fas fa-power-off'=>'power-off'),
array('fas fa-pray'=>'pray'),
array('fas fa-praying-hands'=>'praying-hands'),
array('fas fa-prescription'=>'prescription'),
array('fas fa-prescription-bottle'=>'prescription-bottle'),
array('fas fa-prescription-bottle-alt'=>'prescription-bottle-alt'),
array('fas fa-presentation'=>'presentation'),
array('fas fa-print'=>'print'),
array('fas fa-print-search'=>'print-search'),
array('fas fa-print-slash'=>'print-slash'),
array('fas fa-procedures'=>'procedures'),
array('fas fa-project-diagram'=>'project-diagram'),
array('fas fa-projector'=>'projector'),
array('fas fa-pumpkin'=>'pumpkin'),
array('fas fa-puzzle-piece'=>'puzzle-piece'),
array('fas fa-qrcode'=>'qrcode'),
array('fas fa-question'=>'question'),
array('fas fa-question-circle'=>'question-circle'),
array('fas fa-question-square'=>'question-square'),
array('fas fa-quidditch'=>'quidditch'),
array('fas fa-quote-left'=>'quote-left'),
array('fas fa-quote-right'=>'quote-right'),
array('fas fa-quran'=>'quran'),
array('fas fa-rabbit'=>'rabbit'),
array('fas fa-rabbit-fast'=>'rabbit-fast'),
array('fas fa-racquet'=>'racquet'),
array('fas fa-radar'=>'radar'),
array('fas fa-radiation'=>'radiation'),
array('fas fa-radiation-alt'=>'radiation-alt'),
array('fas fa-radio'=>'radio'),
array('fas fa-radio-alt'=>'radio-alt'),
array('fas fa-rainbow'=>'rainbow'),
array('fas fa-raindrops'=>'raindrops'),
array('fas fa-ram'=>'ram'),
array('fas fa-ramp-loading'=>'ramp-loading'),
array('fas fa-random'=>'random'),
array('fas fa-raygun'=>'raygun'),
array('fas fa-receipt'=>'receipt'),
array('fas fa-record-vinyl'=>'record-vinyl'),
array('fas fa-rectangle-landscape'=>'rectangle-landscape'),
array('fas fa-rectangle-portrait'=>'rectangle-portrait'),
array('fas fa-rectangle-wide'=>'rectangle-wide'),
array('fas fa-recycle'=>'recycle'),
array('fas fa-redo'=>'redo'),
array('fas fa-redo-alt'=>'redo-alt'),
array('fas fa-refrigerator'=>'refrigerator'),
array('fas fa-registered'=>'registered'),
array('fas fa-remove-format'=>'remove-format'),
array('fas fa-repeat'=>'repeat'),
array('fas fa-repeat-1'=>'repeat-1'),
array('fas fa-repeat-1-alt'=>'repeat-1-alt'),
array('fas fa-repeat-alt'=>'repeat-alt'),
array('fas fa-reply'=>'reply'),
array('fas fa-reply-all'=>'reply-all'),
array('fas fa-republican'=>'republican'),
array('fas fa-restroom'=>'restroom'),
array('fas fa-retweet'=>'retweet'),
array('fas fa-retweet-alt'=>'retweet-alt'),
array('fas fa-ribbon'=>'ribbon'),
array('fas fa-ring'=>'ring'),
array('fas fa-rings-wedding'=>'rings-wedding'),
array('fas fa-road'=>'road'),
array('fas fa-robot'=>'robot'),
array('fas fa-rocket'=>'rocket'),
array('fas fa-rocket-launch'=>'rocket-launch'),
array('fas fa-route'=>'route'),
array('fas fa-route-highway'=>'route-highway'),
array('fas fa-route-interstate'=>'route-interstate'),
array('fas fa-router'=>'router'),
array('fas fa-rss'=>'rss'),
array('fas fa-rss-square'=>'rss-square'),
array('fas fa-ruble-sign'=>'ruble-sign'),
array('fas fa-ruler'=>'ruler'),
array('fas fa-ruler-combined'=>'ruler-combined'),
array('fas fa-ruler-horizontal'=>'ruler-horizontal'),
array('fas fa-ruler-triangle'=>'ruler-triangle'),
array('fas fa-ruler-vertical'=>'ruler-vertical'),
array('fas fa-running'=>'running'),
array('fas fa-rupee-sign'=>'rupee-sign'),
array('fas fa-rv'=>'rv'),
array('fas fa-sack'=>'sack'),
array('fas fa-sack-dollar'=>'sack-dollar'),
array('fas fa-sad-cry'=>'sad-cry'),
array('fas fa-sad-tear'=>'sad-tear'),
array('fas fa-salad'=>'salad'),
array('fas fa-sandwich'=>'sandwich'),
array('fas fa-satellite'=>'satellite'),
array('fas fa-satellite-dish'=>'satellite-dish'),
array('fas fa-sausage'=>'sausage'),
array('fas fa-save'=>'save'),
array('fas fa-sax-hot'=>'sax-hot'),
array('fas fa-saxophone'=>'saxophone'),
array('fas fa-scalpel'=>'scalpel'),
array('fas fa-scalpel-path'=>'scalpel-path'),
array('fas fa-scanner'=>'scanner'),
array('fas fa-scanner-image'=>'scanner-image'),
array('fas fa-scanner-keyboard'=>'scanner-keyboard'),
array('fas fa-scanner-touchscreen'=>'scanner-touchscreen'),
array('fas fa-scarecrow'=>'scarecrow'),
array('fas fa-scarf'=>'scarf'),
array('fas fa-school'=>'school'),
array('fas fa-screwdriver'=>'screwdriver'),
array('fas fa-scroll'=>'scroll'),
array('fas fa-scroll-old'=>'scroll-old'),
array('fas fa-scrubber'=>'scrubber'),
array('fas fa-scythe'=>'scythe'),
array('fas fa-sd-card'=>'sd-card'),
array('fas fa-search'=>'search'),
array('fas fa-search-dollar'=>'search-dollar'),
array('fas fa-search-location'=>'search-location'),
array('fas fa-search-minus'=>'search-minus'),
array('fas fa-search-plus'=>'search-plus'),
array('fas fa-seedling'=>'seedling'),
array('fas fa-send-back'=>'send-back'),
array('fas fa-send-backward'=>'send-backward'),
array('fas fa-sensor'=>'sensor'),
array('fas fa-sensor-alert'=>'sensor-alert'),
array('fas fa-sensor-fire'=>'sensor-fire'),
array('fas fa-sensor-on'=>'sensor-on'),
array('fas fa-sensor-smoke'=>'sensor-smoke'),
array('fas fa-server'=>'server'),
array('fas fa-shapes'=>'shapes'),
array('fas fa-share'=>'share'),
array('fas fa-share-all'=>'share-all'),
array('fas fa-share-alt'=>'share-alt'),
array('fas fa-share-alt-square'=>'share-alt-square'),
array('fas fa-share-square'=>'share-square'),
array('fas fa-sheep'=>'sheep'),
array('fas fa-shekel-sign'=>'shekel-sign'),
array('fas fa-shield'=>'shield'),
array('fas fa-shield-alt'=>'shield-alt'),
array('fas fa-shield-check'=>'shield-check'),
array('fas fa-shield-cross'=>'shield-cross'),
array('fas fa-ship'=>'ship'),
array('fas fa-shipping-fast'=>'shipping-fast'),
array('fas fa-shipping-timed'=>'shipping-timed'),
array('fas fa-shish-kebab'=>'shish-kebab'),
array('fas fa-shoe-prints'=>'shoe-prints'),
array('fas fa-shopping-bag'=>'shopping-bag'),
array('fas fa-shopping-basket'=>'shopping-basket'),
array('fas fa-shopping-cart'=>'shopping-cart'),
array('fas fa-shovel'=>'shovel'),
array('fas fa-shovel-snow'=>'shovel-snow'),
array('fas fa-shower'=>'shower'),
array('fas fa-shredder'=>'shredder'),
array('fas fa-shuttle-van'=>'shuttle-van'),
array('fas fa-shuttlecock'=>'shuttlecock'),
array('fas fa-sickle'=>'sickle'),
array('fas fa-sigma'=>'sigma'),
array('fas fa-sign'=>'sign'),
array('fas fa-sign-in'=>'sign-in'),
array('fas fa-sign-in-alt'=>'sign-in-alt'),
array('fas fa-sign-language'=>'sign-language'),
array('fas fa-sign-out'=>'sign-out'),
array('fas fa-sign-out-alt'=>'sign-out-alt'),
array('fas fa-signal'=>'signal'),
array('fas fa-signal-1'=>'signal-1'),
array('fas fa-signal-2'=>'signal-2'),
array('fas fa-signal-3'=>'signal-3'),
array('fas fa-signal-4'=>'signal-4'),
array('fas fa-signal-alt'=>'signal-alt'),
array('fas fa-signal-alt-1'=>'signal-alt-1'),
array('fas fa-signal-alt-2'=>'signal-alt-2'),
array('fas fa-signal-alt-3'=>'signal-alt-3'),
array('fas fa-signal-alt-slash'=>'signal-alt-slash'),
array('fas fa-signal-slash'=>'signal-slash'),
array('fas fa-signal-stream'=>'signal-stream'),
array('fas fa-signature'=>'signature'),
array('fas fa-sim-card'=>'sim-card'),
array('fas fa-siren'=>'siren'),
array('fas fa-siren-on'=>'siren-on'),
array('fas fa-sitemap'=>'sitemap'),
array('fas fa-skating'=>'skating'),
array('fas fa-skeleton'=>'skeleton'),
array('fas fa-ski-jump'=>'ski-jump'),
array('fas fa-ski-lift'=>'ski-lift'),
array('fas fa-skiing'=>'skiing'),
array('fas fa-skiing-nordic'=>'skiing-nordic'),
array('fas fa-skull'=>'skull'),
array('fas fa-skull-cow'=>'skull-cow'),
array('fas fa-skull-crossbones'=>'skull-crossbones'),
array('fas fa-slash'=>'slash'),
array('fas fa-sledding'=>'sledding'),
array('fas fa-sleigh'=>'sleigh'),
array('fas fa-sliders-h'=>'sliders-h'),
array('fas fa-sliders-h-square'=>'sliders-h-square'),
array('fas fa-sliders-v'=>'sliders-v'),
array('fas fa-sliders-v-square'=>'sliders-v-square'),
array('fas fa-smile'=>'smile'),
array('fas fa-smile-beam'=>'smile-beam'),
array('fas fa-smile-plus'=>'smile-plus'),
array('fas fa-smile-wink'=>'smile-wink'),
array('fas fa-smog'=>'smog'),
array('fas fa-smoke'=>'smoke'),
array('fas fa-smoking'=>'smoking'),
array('fas fa-smoking-ban'=>'smoking-ban'),
array('fas fa-sms'=>'sms'),
array('fas fa-snake'=>'snake'),
array('fas fa-snooze'=>'snooze'),
array('fas fa-snow-blowing'=>'snow-blowing'),
array('fas fa-snowboarding'=>'snowboarding'),
array('fas fa-snowflake'=>'snowflake'),
array('fas fa-snowflakes'=>'snowflakes'),
array('fas fa-snowman'=>'snowman'),
array('fas fa-snowmobile'=>'snowmobile'),
array('fas fa-snowplow'=>'snowplow'),
array('fas fa-socks'=>'socks'),
array('fas fa-solar-panel'=>'solar-panel'),
array('fas fa-solar-system'=>'solar-system'),
array('fas fa-sort'=>'sort'),
array('fas fa-sort-alpha-down'=>'sort-alpha-down'),
array('fas fa-sort-alpha-down-alt'=>'sort-alpha-down-alt'),
array('fas fa-sort-alpha-up'=>'sort-alpha-up'),
array('fas fa-sort-alpha-up-alt'=>'sort-alpha-up-alt'),
array('fas fa-sort-alt'=>'sort-alt'),
array('fas fa-sort-amount-down'=>'sort-amount-down'),
array('fas fa-sort-amount-down-alt'=>'sort-amount-down-alt'),
array('fas fa-sort-amount-up'=>'sort-amount-up'),
array('fas fa-sort-amount-up-alt'=>'sort-amount-up-alt'),
array('fas fa-sort-circle'=>'sort-circle'),
array('fas fa-sort-circle-down'=>'sort-circle-down'),
array('fas fa-sort-circle-up'=>'sort-circle-up'),
array('fas fa-sort-down'=>'sort-down'),
array('fas fa-sort-numeric-down'=>'sort-numeric-down'),
array('fas fa-sort-numeric-down-alt'=>'sort-numeric-down-alt'),
array('fas fa-sort-numeric-up'=>'sort-numeric-up'),
array('fas fa-sort-numeric-up-alt'=>'sort-numeric-up-alt'),
array('fas fa-sort-shapes-down'=>'sort-shapes-down'),
array('fas fa-sort-shapes-down-alt'=>'sort-shapes-down-alt'),
array('fas fa-sort-shapes-up'=>'sort-shapes-up'),
array('fas fa-sort-shapes-up-alt'=>'sort-shapes-up-alt'),
array('fas fa-sort-size-down'=>'sort-size-down'),
array('fas fa-sort-size-down-alt'=>'sort-size-down-alt'),
array('fas fa-sort-size-up'=>'sort-size-up'),
array('fas fa-sort-size-up-alt'=>'sort-size-up-alt'),
array('fas fa-sort-up'=>'sort-up'),
array('fas fa-soup'=>'soup'),
array('fas fa-spa'=>'spa'),
array('fas fa-space-shuttle'=>'space-shuttle'),
array('fas fa-space-station-moon'=>'space-station-moon'),
array('fas fa-space-station-moon-alt'=>'space-station-moon-alt'),
array('fas fa-spade'=>'spade'),
array('fas fa-sparkles'=>'sparkles'),
array('fas fa-speaker'=>'speaker'),
array('fas fa-speakers'=>'speakers'),
array('fas fa-spell-check'=>'spell-check'),
array('fas fa-spider'=>'spider'),
array('fas fa-spider-black-widow'=>'spider-black-widow'),
array('fas fa-spider-web'=>'spider-web'),
array('fas fa-spinner'=>'spinner'),
array('fas fa-spinner-third'=>'spinner-third'),
array('fas fa-splotch'=>'splotch'),
array('fas fa-spray-can'=>'spray-can'),
array('fas fa-sprinkler'=>'sprinkler'),
array('fas fa-square'=>'square'),
array('fas fa-square-full'=>'square-full'),
array('fas fa-square-root'=>'square-root'),
array('fas fa-square-root-alt'=>'square-root-alt'),
array('fas fa-squirrel'=>'squirrel'),
array('fas fa-staff'=>'staff'),
array('fas fa-stamp'=>'stamp'),
array('fas fa-star'=>'star'),
array('fas fa-star-and-crescent'=>'star-and-crescent'),
array('fas fa-star-christmas'=>'star-christmas'),
array('fas fa-star-exclamation'=>'star-exclamation'),
array('fas fa-star-half'=>'star-half'),
array('fas fa-star-half-alt'=>'star-half-alt'),
array('fas fa-star-of-david'=>'star-of-david'),
array('fas fa-star-of-life'=>'star-of-life'),
array('fas fa-star-shooting'=>'star-shooting'),
array('fas fa-starfighter'=>'starfighter'),
array('fas fa-starfighter-alt'=>'starfighter-alt'),
array('fas fa-stars'=>'stars'),
array('fas fa-starship'=>'starship'),
array('fas fa-starship-freighter'=>'starship-freighter'),
array('fas fa-steak'=>'steak'),
array('fas fa-steering-wheel'=>'steering-wheel'),
array('fas fa-step-backward'=>'step-backward'),
array('fas fa-step-forward'=>'step-forward'),
array('fas fa-stethoscope'=>'stethoscope'),
array('fas fa-sticky-note'=>'sticky-note'),
array('fas fa-stocking'=>'stocking'),
array('fas fa-stomach'=>'stomach'),
array('fas fa-stop'=>'stop'),
array('fas fa-stop-circle'=>'stop-circle'),
array('fas fa-stopwatch'=>'stopwatch'),
array('fas fa-store'=>'store'),
array('fas fa-store-alt'=>'store-alt'),
array('fas fa-stream'=>'stream'),
array('fas fa-street-view'=>'street-view'),
array('fas fa-stretcher'=>'stretcher'),
array('fas fa-strikethrough'=>'strikethrough'),
array('fas fa-stroopwafel'=>'stroopwafel'),
array('fas fa-subscript'=>'subscript'),
array('fas fa-subway'=>'subway'),
array('fas fa-suitcase'=>'suitcase'),
array('fas fa-suitcase-rolling'=>'suitcase-rolling'),
array('fas fa-sun'=>'sun'),
array('fas fa-sun-cloud'=>'sun-cloud'),
array('fas fa-sun-dust'=>'sun-dust'),
array('fas fa-sun-haze'=>'sun-haze'),
array('fas fa-sunglasses'=>'sunglasses'),
array('fas fa-sunrise'=>'sunrise'),
array('fas fa-sunset'=>'sunset'),
array('fas fa-superscript'=>'superscript'),
array('fas fa-surprise'=>'surprise'),
array('fas fa-swatchbook'=>'swatchbook'),
array('fas fa-swimmer'=>'swimmer'),
array('fas fa-swimming-pool'=>'swimming-pool'),
array('fas fa-sword'=>'sword'),
array('fas fa-sword-laser'=>'sword-laser'),
array('fas fa-sword-laser-alt'=>'sword-laser-alt'),
array('fas fa-swords'=>'swords'),
array('fas fa-swords-laser'=>'swords-laser'),
array('fas fa-synagogue'=>'synagogue'),
array('fas fa-sync'=>'sync'),
array('fas fa-sync-alt'=>'sync-alt'),
array('fas fa-syringe'=>'syringe'),
array('fas fa-table'=>'table'),
array('fas fa-table-tennis'=>'table-tennis'),
array('fas fa-tablet'=>'tablet'),
array('fas fa-tablet-alt'=>'tablet-alt'),
array('fas fa-tablet-android'=>'tablet-android'),
array('fas fa-tablet-android-alt'=>'tablet-android-alt'),
array('fas fa-tablet-rugged'=>'tablet-rugged'),
array('fas fa-tablets'=>'tablets'),
array('fas fa-tachometer'=>'tachometer'),
array('fas fa-tachometer-alt'=>'tachometer-alt'),
array('fas fa-tachometer-alt-average'=>'tachometer-alt-average'),
array('fas fa-tachometer-alt-fast'=>'tachometer-alt-fast'),
array('fas fa-tachometer-alt-fastest'=>'tachometer-alt-fastest'),
array('fas fa-tachometer-alt-slow'=>'tachometer-alt-slow'),
array('fas fa-tachometer-alt-slowest'=>'tachometer-alt-slowest'),
array('fas fa-tachometer-average'=>'tachometer-average'),
array('fas fa-tachometer-fast'=>'tachometer-fast'),
array('fas fa-tachometer-fastest'=>'tachometer-fastest'),
array('fas fa-tachometer-slow'=>'tachometer-slow'),
array('fas fa-tachometer-slowest'=>'tachometer-slowest'),
array('fas fa-taco'=>'taco'),
array('fas fa-tag'=>'tag'),
array('fas fa-tags'=>'tags'),
array('fas fa-tally'=>'tally'),
array('fas fa-tanakh'=>'tanakh'),
array('fas fa-tape'=>'tape'),
array('fas fa-tasks'=>'tasks'),
array('fas fa-tasks-alt'=>'tasks-alt'),
array('fas fa-taxi'=>'taxi'),
array('fas fa-teeth'=>'teeth'),
array('fas fa-teeth-open'=>'teeth-open'),
array('fas fa-telescope'=>'telescope'),
array('fas fa-temperature-down'=>'temperature-down'),
array('fas fa-temperature-frigid'=>'temperature-frigid'),
array('fas fa-temperature-high'=>'temperature-high'),
array('fas fa-temperature-hot'=>'temperature-hot'),
array('fas fa-temperature-low'=>'temperature-low'),
array('fas fa-temperature-up'=>'temperature-up'),
array('fas fa-tenge'=>'tenge'),
array('fas fa-tennis-ball'=>'tennis-ball'),
array('fas fa-terminal'=>'terminal'),
array('fas fa-text'=>'text'),
array('fas fa-text-height'=>'text-height'),
array('fas fa-text-size'=>'text-size'),
array('fas fa-text-width'=>'text-width'),
array('fas fa-th'=>'th'),
array('fas fa-th-large'=>'th-large'),
array('fas fa-th-list'=>'th-list'),
array('fas fa-theater-masks'=>'theater-masks'),
array('fas fa-thermometer'=>'thermometer'),
array('fas fa-thermometer-empty'=>'thermometer-empty'),
array('fas fa-thermometer-full'=>'thermometer-full'),
array('fas fa-thermometer-half'=>'thermometer-half'),
array('fas fa-thermometer-quarter'=>'thermometer-quarter'),
array('fas fa-thermometer-three-quarters'=>'thermometer-three-quarters'),
array('fas fa-theta'=>'theta'),
array('fas fa-thumbs-down'=>'thumbs-down'),
array('fas fa-thumbs-up'=>'thumbs-up'),
array('fas fa-thumbtack'=>'thumbtack'),
array('fas fa-thunderstorm'=>'thunderstorm'),
array('fas fa-thunderstorm-moon'=>'thunderstorm-moon'),
array('fas fa-thunderstorm-sun'=>'thunderstorm-sun'),
array('fas fa-ticket'=>'ticket'),
array('fas fa-ticket-alt'=>'ticket-alt'),
array('fas fa-tilde'=>'tilde'),
array('fas fa-times'=>'times'),
array('fas fa-times-circle'=>'times-circle'),
array('fas fa-times-hexagon'=>'times-hexagon'),
array('fas fa-times-octagon'=>'times-octagon'),
array('fas fa-times-square'=>'times-square'),
array('fas fa-tint'=>'tint'),
array('fas fa-tint-slash'=>'tint-slash'),
array('fas fa-tire'=>'tire'),
array('fas fa-tire-flat'=>'tire-flat'),
array('fas fa-tire-pressure-warning'=>'tire-pressure-warning'),
array('fas fa-tire-rugged'=>'tire-rugged'),
array('fas fa-tired'=>'tired'),
array('fas fa-toggle-off'=>'toggle-off'),
array('fas fa-toggle-on'=>'toggle-on'),
array('fas fa-toilet'=>'toilet'),
array('fas fa-toilet-paper'=>'toilet-paper'),
array('fas fa-toilet-paper-alt'=>'toilet-paper-alt'),
array('fas fa-tombstone'=>'tombstone'),
array('fas fa-tombstone-alt'=>'tombstone-alt'),
array('fas fa-toolbox'=>'toolbox'),
array('fas fa-tools'=>'tools'),
array('fas fa-tooth'=>'tooth'),
array('fas fa-toothbrush'=>'toothbrush'),
array('fas fa-torah'=>'torah'),
array('fas fa-torii-gate'=>'torii-gate'),
array('fas fa-tornado'=>'tornado'),
array('fas fa-tractor'=>'tractor'),
array('fas fa-trademark'=>'trademark'),
array('fas fa-traffic-cone'=>'traffic-cone'),
array('fas fa-traffic-light'=>'traffic-light'),
array('fas fa-traffic-light-go'=>'traffic-light-go'),
array('fas fa-traffic-light-slow'=>'traffic-light-slow'),
array('fas fa-traffic-light-stop'=>'traffic-light-stop'),
array('fas fa-trailer'=>'trailer'),
array('fas fa-train'=>'train'),
array('fas fa-tram'=>'tram'),
array('fas fa-transgender'=>'transgender'),
array('fas fa-transgender-alt'=>'transgender-alt'),
array('fas fa-transporter'=>'transporter'),
array('fas fa-transporter-1'=>'transporter-1'),
array('fas fa-transporter-2'=>'transporter-2'),
array('fas fa-transporter-3'=>'transporter-3'),
array('fas fa-transporter-empty'=>'transporter-empty'),
array('fas fa-trash'=>'trash'),
array('fas fa-trash-alt'=>'trash-alt'),
array('fas fa-trash-restore'=>'trash-restore'),
array('fas fa-trash-restore-alt'=>'trash-restore-alt'),
array('fas fa-trash-undo'=>'trash-undo'),
array('fas fa-trash-undo-alt'=>'trash-undo-alt'),
array('fas fa-treasure-chest'=>'treasure-chest'),
array('fas fa-tree'=>'tree'),
array('fas fa-tree-alt'=>'tree-alt'),
array('fas fa-tree-christmas'=>'tree-christmas'),
array('fas fa-tree-decorated'=>'tree-decorated'),
array('fas fa-tree-large'=>'tree-large'),
array('fas fa-tree-palm'=>'tree-palm'),
array('fas fa-trees'=>'trees'),
array('fas fa-triangle'=>'triangle'),
array('fas fa-triangle-music'=>'triangle-music'),
array('fas fa-trophy'=>'trophy'),
array('fas fa-trophy-alt'=>'trophy-alt'),
array('fas fa-truck'=>'truck'),
array('fas fa-truck-container'=>'truck-container'),
array('fas fa-truck-couch'=>'truck-couch'),
array('fas fa-truck-loading'=>'truck-loading'),
array('fas fa-truck-monster'=>'truck-monster'),
array('fas fa-truck-moving'=>'truck-moving'),
array('fas fa-truck-pickup'=>'truck-pickup'),
array('fas fa-truck-plow'=>'truck-plow'),
array('fas fa-truck-ramp'=>'truck-ramp'),
array('fas fa-trumpet'=>'trumpet'),
array('fas fa-tshirt'=>'tshirt'),
array('fas fa-tty'=>'tty'),
array('fas fa-turkey'=>'turkey'),
array('fas fa-turntable'=>'turntable'),
array('fas fa-turtle'=>'turtle'),
array('fas fa-tv'=>'tv'),
array('fas fa-tv-alt'=>'tv-alt'),
array('fas fa-tv-music'=>'tv-music'),
array('fas fa-tv-retro'=>'tv-retro'),
array('fas fa-typewriter'=>'typewriter'),
array('fas fa-ufo'=>'ufo'),
array('fas fa-ufo-beam'=>'ufo-beam'),
array('fas fa-umbrella'=>'umbrella'),
array('fas fa-umbrella-beach'=>'umbrella-beach'),
array('fas fa-underline'=>'underline'),
array('fas fa-undo'=>'undo'),
array('fas fa-undo-alt'=>'undo-alt'),
array('fas fa-unicorn'=>'unicorn'),
array('fas fa-union'=>'union'),
array('fas fa-universal-access'=>'universal-access'),
array('fas fa-university'=>'university'),
array('fas fa-unlink'=>'unlink'),
array('fas fa-unlock'=>'unlock'),
array('fas fa-unlock-alt'=>'unlock-alt'),
array('fas fa-upload'=>'upload'),
array('fas fa-usb-drive'=>'usb-drive'),
array('fas fa-usd-circle'=>'usd-circle'),
array('fas fa-usd-square'=>'usd-square'),
array('fas fa-user'=>'user'),
array('fas fa-user-alien'=>'user-alien'),
array('fas fa-user-alt'=>'user-alt'),
array('fas fa-user-alt-slash'=>'user-alt-slash'),
array('fas fa-user-astronaut'=>'user-astronaut'),
array('fas fa-user-chart'=>'user-chart'),
array('fas fa-user-check'=>'user-check'),
array('fas fa-user-circle'=>'user-circle'),
array('fas fa-user-clock'=>'user-clock'),
array('fas fa-user-cog'=>'user-cog'),
array('fas fa-user-cowboy'=>'user-cowboy'),
array('fas fa-user-crown'=>'user-crown'),
array('fas fa-user-edit'=>'user-edit'),
array('fas fa-user-friends'=>'user-friends'),
array('fas fa-user-graduate'=>'user-graduate'),
array('fas fa-user-hard-hat'=>'user-hard-hat'),
array('fas fa-user-headset'=>'user-headset'),
array('fas fa-user-injured'=>'user-injured'),
array('fas fa-user-lock'=>'user-lock'),
array('fas fa-user-md'=>'user-md'),
array('fas fa-user-md-chat'=>'user-md-chat'),
array('fas fa-user-minus'=>'user-minus'),
array('fas fa-user-music'=>'user-music'),
array('fas fa-user-ninja'=>'user-ninja'),
array('fas fa-user-nurse'=>'user-nurse'),
array('fas fa-user-plus'=>'user-plus'),
array('fas fa-user-robot'=>'user-robot'),
array('fas fa-user-secret'=>'user-secret'),
array('fas fa-user-shield'=>'user-shield'),
array('fas fa-user-slash'=>'user-slash'),
array('fas fa-user-tag'=>'user-tag'),
array('fas fa-user-tie'=>'user-tie'),
array('fas fa-user-times'=>'user-times'),
array('fas fa-user-unlock'=>'user-unlock'),
array('fas fa-user-visor'=>'user-visor'),
array('fas fa-users'=>'users'),
array('fas fa-users-class'=>'users-class'),
array('fas fa-users-cog'=>'users-cog'),
array('fas fa-users-crown'=>'users-crown'),
array('fas fa-users-medical'=>'users-medical'),
array('fas fa-utensil-fork'=>'utensil-fork'),
array('fas fa-utensil-knife'=>'utensil-knife'),
array('fas fa-utensil-spoon'=>'utensil-spoon'),
array('fas fa-utensils'=>'utensils'),
array('fas fa-utensils-alt'=>'utensils-alt'),
array('fas fa-vacuum'=>'vacuum'),
array('fas fa-vacuum-robot'=>'vacuum-robot'),
array('fas fa-value-absolute'=>'value-absolute'),
array('fas fa-vector-square'=>'vector-square'),
array('fas fa-venus'=>'venus'),
array('fas fa-venus-double'=>'venus-double'),
array('fas fa-venus-mars'=>'venus-mars'),
array('fas fa-vhs'=>'vhs'),
array('fas fa-vial'=>'vial'),
array('fas fa-vials'=>'vials'),
array('fas fa-video'=>'video'),
array('fas fa-video-plus'=>'video-plus'),
array('fas fa-video-slash'=>'video-slash'),
array('fas fa-vihara'=>'vihara'),
array('fas fa-violin'=>'violin'),
array('fas fa-voicemail'=>'voicemail'),
array('fas fa-volcano'=>'volcano'),
array('fas fa-volleyball-ball'=>'volleyball-ball'),
array('fas fa-volume'=>'volume'),
array('fas fa-volume-down'=>'volume-down'),
array('fas fa-volume-mute'=>'volume-mute'),
array('fas fa-volume-off'=>'volume-off'),
array('fas fa-volume-slash'=>'volume-slash'),
array('fas fa-volume-up'=>'volume-up'),
array('fas fa-vote-nay'=>'vote-nay'),
array('fas fa-vote-yea'=>'vote-yea'),
array('fas fa-vr-cardboard'=>'vr-cardboard'),
array('fas fa-wagon-covered'=>'wagon-covered'),
array('fas fa-walker'=>'walker'),
array('fas fa-walkie-talkie'=>'walkie-talkie'),
array('fas fa-walking'=>'walking'),
array('fas fa-wallet'=>'wallet'),
array('fas fa-wand'=>'wand'),
array('fas fa-wand-magic'=>'wand-magic'),
array('fas fa-warehouse'=>'warehouse'),
array('fas fa-warehouse-alt'=>'warehouse-alt'),
array('fas fa-washer'=>'washer'),
array('fas fa-watch'=>'watch'),
array('fas fa-watch-calculator'=>'watch-calculator'),
array('fas fa-watch-fitness'=>'watch-fitness'),
array('fas fa-water'=>'water'),
array('fas fa-water-lower'=>'water-lower'),
array('fas fa-water-rise'=>'water-rise'),
array('fas fa-wave-sine'=>'wave-sine'),
array('fas fa-wave-square'=>'wave-square'),
array('fas fa-wave-triangle'=>'wave-triangle'),
array('fas fa-waveform'=>'waveform'),
array('fas fa-waveform-path'=>'waveform-path'),
array('fas fa-webcam'=>'webcam'),
array('fas fa-webcam-slash'=>'webcam-slash'),
array('fas fa-weight'=>'weight'),
array('fas fa-weight-hanging'=>'weight-hanging'),
array('fas fa-whale'=>'whale'),
array('fas fa-wheat'=>'wheat'),
array('fas fa-wheelchair'=>'wheelchair'),
array('fas fa-whistle'=>'whistle'),
array('fas fa-wifi'=>'wifi'),
array('fas fa-wifi-1'=>'wifi-1'),
array('fas fa-wifi-2'=>'wifi-2'),
array('fas fa-wifi-slash'=>'wifi-slash'),
array('fas fa-wind'=>'wind'),
array('fas fa-wind-turbine'=>'wind-turbine'),
array('fas fa-wind-warning'=>'wind-warning'),
array('fas fa-window'=>'window'),
array('fas fa-window-alt'=>'window-alt'),
array('fas fa-window-close'=>'window-close'),
array('fas fa-window-frame'=>'window-frame'),
array('fas fa-window-frame-open'=>'window-frame-open'),
array('fas fa-window-maximize'=>'window-maximize'),
array('fas fa-window-minimize'=>'window-minimize'),
array('fas fa-window-restore'=>'window-restore'),
array('fas fa-windsock'=>'windsock'),
array('fas fa-wine-bottle'=>'wine-bottle'),
array('fas fa-wine-glass'=>'wine-glass'),
array('fas fa-wine-glass-alt'=>'wine-glass-alt'),
array('fas fa-won-sign'=>'won-sign'),
array('fas fa-wreath'=>'wreath'),
array('fas fa-wrench'=>'wrench'),
array('fas fa-x-ray'=>'x-ray'),
array('fas fa-yen-sign'=>'yen-sign'),
array('fas fa-yin-yang'=>'yin-yang'),
),
'Regular Icons' => array(
array('far fa-abacus'=>'abacus'),
array('far fa-acorn'=>'acorn'),
array('far fa-ad'=>'ad'),
array('far fa-address-book'=>'address-book'),
array('far fa-address-card'=>'address-card'),
array('far fa-adjust'=>'adjust'),
array('far fa-air-conditioner'=>'air-conditioner'),
array('far fa-air-freshener'=>'air-freshener'),
array('far fa-alarm-clock'=>'alarm-clock'),
array('far fa-alarm-exclamation'=>'alarm-exclamation'),
array('far fa-alarm-plus'=>'alarm-plus'),
array('far fa-alarm-snooze'=>'alarm-snooze'),
array('far fa-album'=>'album'),
array('far fa-album-collection'=>'album-collection'),
array('far fa-alicorn'=>'alicorn'),
array('far fa-alien'=>'alien'),
array('far fa-alien-monster'=>'alien-monster'),
array('far fa-align-center'=>'align-center'),
array('far fa-align-justify'=>'align-justify'),
array('far fa-align-left'=>'align-left'),
array('far fa-align-right'=>'align-right'),
array('far fa-align-slash'=>'align-slash'),
array('far fa-allergies'=>'allergies'),
array('far fa-ambulance'=>'ambulance'),
array('far fa-american-sign-language-interpreting'=>'american-sign-language-interpreting'),
array('far fa-amp-guitar'=>'amp-guitar'),
array('far fa-analytics'=>'analytics'),
array('far fa-anchor'=>'anchor'),
array('far fa-angel'=>'angel'),
array('far fa-angle-double-down'=>'angle-double-down'),
array('far fa-angle-double-left'=>'angle-double-left'),
array('far fa-angle-double-right'=>'angle-double-right'),
array('far fa-angle-double-up'=>'angle-double-up'),
array('far fa-angle-down'=>'angle-down'),
array('far fa-angle-left'=>'angle-left'),
array('far fa-angle-right'=>'angle-right'),
array('far fa-angle-up'=>'angle-up'),
array('far fa-angry'=>'angry'),
array('far fa-ankh'=>'ankh'),
array('far fa-apple-alt'=>'apple-alt'),
array('far fa-apple-crate'=>'apple-crate'),
array('far fa-archive'=>'archive'),
array('far fa-archway'=>'archway'),
array('far fa-arrow-alt-circle-down'=>'arrow-alt-circle-down'),
array('far fa-arrow-alt-circle-left'=>'arrow-alt-circle-left'),
array('far fa-arrow-alt-circle-right'=>'arrow-alt-circle-right'),
array('far fa-arrow-alt-circle-up'=>'arrow-alt-circle-up'),
array('far fa-arrow-alt-down'=>'arrow-alt-down'),
array('far fa-arrow-alt-from-bottom'=>'arrow-alt-from-bottom'),
array('far fa-arrow-alt-from-left'=>'arrow-alt-from-left'),
array('far fa-arrow-alt-from-right'=>'arrow-alt-from-right'),
array('far fa-arrow-alt-from-top'=>'arrow-alt-from-top'),
array('far fa-arrow-alt-left'=>'arrow-alt-left'),
array('far fa-arrow-alt-right'=>'arrow-alt-right'),
array('far fa-arrow-alt-square-down'=>'arrow-alt-square-down'),
array('far fa-arrow-alt-square-left'=>'arrow-alt-square-left'),
array('far fa-arrow-alt-square-right'=>'arrow-alt-square-right'),
array('far fa-arrow-alt-square-up'=>'arrow-alt-square-up'),
array('far fa-arrow-alt-to-bottom'=>'arrow-alt-to-bottom'),
array('far fa-arrow-alt-to-left'=>'arrow-alt-to-left'),
array('far fa-arrow-alt-to-right'=>'arrow-alt-to-right'),
array('far fa-arrow-alt-to-top'=>'arrow-alt-to-top'),
array('far fa-arrow-alt-up'=>'arrow-alt-up'),
array('far fa-arrow-circle-down'=>'arrow-circle-down'),
array('far fa-arrow-circle-left'=>'arrow-circle-left'),
array('far fa-arrow-circle-right'=>'arrow-circle-right'),
array('far fa-arrow-circle-up'=>'arrow-circle-up'),
array('far fa-arrow-down'=>'arrow-down'),
array('far fa-arrow-from-bottom'=>'arrow-from-bottom'),
array('far fa-arrow-from-left'=>'arrow-from-left'),
array('far fa-arrow-from-right'=>'arrow-from-right'),
array('far fa-arrow-from-top'=>'arrow-from-top'),
array('far fa-arrow-left'=>'arrow-left'),
array('far fa-arrow-right'=>'arrow-right'),
array('far fa-arrow-square-down'=>'arrow-square-down'),
array('far fa-arrow-square-left'=>'arrow-square-left'),
array('far fa-arrow-square-right'=>'arrow-square-right'),
array('far fa-arrow-square-up'=>'arrow-square-up'),
array('far fa-arrow-to-bottom'=>'arrow-to-bottom'),
array('far fa-arrow-to-left'=>'arrow-to-left'),
array('far fa-arrow-to-right'=>'arrow-to-right'),
array('far fa-arrow-to-top'=>'arrow-to-top'),
array('far fa-arrow-up'=>'arrow-up'),
array('far fa-arrows'=>'arrows'),
array('far fa-arrows-alt'=>'arrows-alt'),
array('far fa-arrows-alt-h'=>'arrows-alt-h'),
array('far fa-arrows-alt-v'=>'arrows-alt-v'),
array('far fa-arrows-h'=>'arrows-h'),
array('far fa-arrows-v'=>'arrows-v'),
array('far fa-assistive-listening-systems'=>'assistive-listening-systems'),
array('far fa-asterisk'=>'asterisk'),
array('far fa-at'=>'at'),
array('far fa-atlas'=>'atlas'),
array('far fa-atom'=>'atom'),
array('far fa-atom-alt'=>'atom-alt'),
array('far fa-audio-description'=>'audio-description'),
array('far fa-award'=>'award'),
array('far fa-axe'=>'axe'),
array('far fa-axe-battle'=>'axe-battle'),
array('far fa-baby'=>'baby'),
array('far fa-baby-carriage'=>'baby-carriage'),
array('far fa-backpack'=>'backpack'),
array('far fa-backspace'=>'backspace'),
array('far fa-backward'=>'backward'),
array('far fa-bacon'=>'bacon'),
array('far fa-badge'=>'badge'),
array('far fa-badge-check'=>'badge-check'),
array('far fa-badge-dollar'=>'badge-dollar'),
array('far fa-badge-percent'=>'badge-percent'),
array('far fa-badge-sheriff'=>'badge-sheriff'),
array('far fa-badger-honey'=>'badger-honey'),
array('far fa-bags-shopping'=>'bags-shopping'),
array('far fa-bahai'=>'bahai'),
array('far fa-balance-scale'=>'balance-scale'),
array('far fa-balance-scale-left'=>'balance-scale-left'),
array('far fa-balance-scale-right'=>'balance-scale-right'),
array('far fa-ball-pile'=>'ball-pile'),
array('far fa-ballot'=>'ballot'),
array('far fa-ballot-check'=>'ballot-check'),
array('far fa-ban'=>'ban'),
array('far fa-band-aid'=>'band-aid'),
array('far fa-banjo'=>'banjo'),
array('far fa-barcode'=>'barcode'),
array('far fa-barcode-alt'=>'barcode-alt'),
array('far fa-barcode-read'=>'barcode-read'),
array('far fa-barcode-scan'=>'barcode-scan'),
array('far fa-bars'=>'bars'),
array('far fa-baseball'=>'baseball'),
array('far fa-baseball-ball'=>'baseball-ball'),
array('far fa-basketball-ball'=>'basketball-ball'),
array('far fa-basketball-hoop'=>'basketball-hoop'),
array('far fa-bat'=>'bat'),
array('far fa-bath'=>'bath'),
array('far fa-battery-bolt'=>'battery-bolt'),
array('far fa-battery-empty'=>'battery-empty'),
array('far fa-battery-full'=>'battery-full'),
array('far fa-battery-half'=>'battery-half'),
array('far fa-battery-quarter'=>'battery-quarter'),
array('far fa-battery-slash'=>'battery-slash'),
array('far fa-battery-three-quarters'=>'battery-three-quarters'),
array('far fa-bed'=>'bed'),
array('far fa-bed-alt'=>'bed-alt'),
array('far fa-bed-bunk'=>'bed-bunk'),
array('far fa-bed-empty'=>'bed-empty'),
array('far fa-beer'=>'beer'),
array('far fa-bell'=>'bell'),
array('far fa-bell-exclamation'=>'bell-exclamation'),
array('far fa-bell-on'=>'bell-on'),
array('far fa-bell-plus'=>'bell-plus'),
array('far fa-bell-school'=>'bell-school'),
array('far fa-bell-school-slash'=>'bell-school-slash'),
array('far fa-bell-slash'=>'bell-slash'),
array('far fa-bells'=>'bells'),
array('far fa-betamax'=>'betamax'),
array('far fa-bezier-curve'=>'bezier-curve'),
array('far fa-bible'=>'bible'),
array('far fa-bicycle'=>'bicycle'),
array('far fa-biking'=>'biking'),
array('far fa-biking-mountain'=>'biking-mountain'),
array('far fa-binoculars'=>'binoculars'),
array('far fa-biohazard'=>'biohazard'),
array('far fa-birthday-cake'=>'birthday-cake'),
array('far fa-blanket'=>'blanket'),
array('far fa-blender'=>'blender'),
array('far fa-blender-phone'=>'blender-phone'),
array('far fa-blind'=>'blind'),
array('far fa-blinds'=>'blinds'),
array('far fa-blinds-open'=>'blinds-open'),
array('far fa-blinds-raised'=>'blinds-raised'),
array('far fa-blog'=>'blog'),
array('far fa-bold'=>'bold'),
array('far fa-bolt'=>'bolt'),
array('far fa-bomb'=>'bomb'),
array('far fa-bone'=>'bone'),
array('far fa-bone-break'=>'bone-break'),
array('far fa-bong'=>'bong'),
array('far fa-book'=>'book'),
array('far fa-book-alt'=>'book-alt'),
array('far fa-book-dead'=>'book-dead'),
array('far fa-book-heart'=>'book-heart'),
array('far fa-book-medical'=>'book-medical'),
array('far fa-book-open'=>'book-open'),
array('far fa-book-reader'=>'book-reader'),
array('far fa-book-spells'=>'book-spells'),
array('far fa-book-user'=>'book-user'),
array('far fa-bookmark'=>'bookmark'),
array('far fa-books'=>'books'),
array('far fa-books-medical'=>'books-medical'),
array('far fa-boombox'=>'boombox'),
array('far fa-boot'=>'boot'),
array('far fa-booth-curtain'=>'booth-curtain'),
array('far fa-border-all'=>'border-all'),
array('far fa-border-bottom'=>'border-bottom'),
array('far fa-border-center-h'=>'border-center-h'),
array('far fa-border-center-v'=>'border-center-v'),
array('far fa-border-inner'=>'border-inner'),
array('far fa-border-left'=>'border-left'),
array('far fa-border-none'=>'border-none'),
array('far fa-border-outer'=>'border-outer'),
array('far fa-border-right'=>'border-right'),
array('far fa-border-style'=>'border-style'),
array('far fa-border-style-alt'=>'border-style-alt'),
array('far fa-border-top'=>'border-top'),
array('far fa-bow-arrow'=>'bow-arrow'),
array('far fa-bowling-ball'=>'bowling-ball'),
array('far fa-bowling-pins'=>'bowling-pins'),
array('far fa-box'=>'box'),
array('far fa-box-alt'=>'box-alt'),
array('far fa-box-ballot'=>'box-ballot'),
array('far fa-box-check'=>'box-check'),
array('far fa-box-fragile'=>'box-fragile'),
array('far fa-box-full'=>'box-full'),
array('far fa-box-heart'=>'box-heart'),
array('far fa-box-open'=>'box-open'),
array('far fa-box-up'=>'box-up'),
array('far fa-box-usd'=>'box-usd'),
array('far fa-boxes'=>'boxes'),
array('far fa-boxes-alt'=>'boxes-alt'),
array('far fa-boxing-glove'=>'boxing-glove'),
array('far fa-brackets'=>'brackets'),
array('far fa-brackets-curly'=>'brackets-curly'),
array('far fa-braille'=>'braille'),
array('far fa-brain'=>'brain'),
array('far fa-bread-loaf'=>'bread-loaf'),
array('far fa-bread-slice'=>'bread-slice'),
array('far fa-briefcase'=>'briefcase'),
array('far fa-briefcase-medical'=>'briefcase-medical'),
array('far fa-bring-forward'=>'bring-forward'),
array('far fa-bring-front'=>'bring-front'),
array('far fa-broadcast-tower'=>'broadcast-tower'),
array('far fa-broom'=>'broom'),
array('far fa-browser'=>'browser'),
array('far fa-brush'=>'brush'),
array('far fa-bug'=>'bug'),
array('far fa-building'=>'building'),
array('far fa-bullhorn'=>'bullhorn'),
array('far fa-bullseye'=>'bullseye'),
array('far fa-bullseye-arrow'=>'bullseye-arrow'),
array('far fa-bullseye-pointer'=>'bullseye-pointer'),
array('far fa-burger-soda'=>'burger-soda'),
array('far fa-burn'=>'burn'),
array('far fa-burrito'=>'burrito'),
array('far fa-bus'=>'bus'),
array('far fa-bus-alt'=>'bus-alt'),
array('far fa-bus-school'=>'bus-school'),
array('far fa-business-time'=>'business-time'),
array('far fa-cabinet-filing'=>'cabinet-filing'),
array('far fa-cactus'=>'cactus'),
array('far fa-calculator'=>'calculator'),
array('far fa-calculator-alt'=>'calculator-alt'),
array('far fa-calendar'=>'calendar'),
array('far fa-calendar-alt'=>'calendar-alt'),
array('far fa-calendar-check'=>'calendar-check'),
array('far fa-calendar-day'=>'calendar-day'),
array('far fa-calendar-edit'=>'calendar-edit'),
array('far fa-calendar-exclamation'=>'calendar-exclamation'),
array('far fa-calendar-minus'=>'calendar-minus'),
array('far fa-calendar-plus'=>'calendar-plus'),
array('far fa-calendar-star'=>'calendar-star'),
array('far fa-calendar-times'=>'calendar-times'),
array('far fa-calendar-week'=>'calendar-week'),
array('far fa-camcorder'=>'camcorder'),
array('far fa-camera'=>'camera'),
array('far fa-camera-alt'=>'camera-alt'),
array('far fa-camera-home'=>'camera-home'),
array('far fa-camera-movie'=>'camera-movie'),
array('far fa-camera-polaroid'=>'camera-polaroid'),
array('far fa-camera-retro'=>'camera-retro'),
array('far fa-campfire'=>'campfire'),
array('far fa-campground'=>'campground'),
array('far fa-candle-holder'=>'candle-holder'),
array('far fa-candy-cane'=>'candy-cane'),
array('far fa-candy-corn'=>'candy-corn'),
array('far fa-cannabis'=>'cannabis'),
array('far fa-capsules'=>'capsules'),
array('far fa-car'=>'car'),
array('far fa-car-alt'=>'car-alt'),
array('far fa-car-battery'=>'car-battery'),
array('far fa-car-building'=>'car-building'),
array('far fa-car-bump'=>'car-bump'),
array('far fa-car-bus'=>'car-bus'),
array('far fa-car-crash'=>'car-crash'),
array('far fa-car-garage'=>'car-garage'),
array('far fa-car-mechanic'=>'car-mechanic'),
array('far fa-car-side'=>'car-side'),
array('far fa-car-tilt'=>'car-tilt'),
array('far fa-car-wash'=>'car-wash'),
array('far fa-caravan'=>'caravan'),
array('far fa-caravan-alt'=>'caravan-alt'),
array('far fa-caret-circle-down'=>'caret-circle-down'),
array('far fa-caret-circle-left'=>'caret-circle-left'),
array('far fa-caret-circle-right'=>'caret-circle-right'),
array('far fa-caret-circle-up'=>'caret-circle-up'),
array('far fa-caret-down'=>'caret-down'),
array('far fa-caret-left'=>'caret-left'),
array('far fa-caret-right'=>'caret-right'),
array('far fa-caret-square-down'=>'caret-square-down'),
array('far fa-caret-square-left'=>'caret-square-left'),
array('far fa-caret-square-right'=>'caret-square-right'),
array('far fa-caret-square-up'=>'caret-square-up'),
array('far fa-caret-up'=>'caret-up'),
array('far fa-carrot'=>'carrot'),
array('far fa-cars'=>'cars'),
array('far fa-cart-arrow-down'=>'cart-arrow-down'),
array('far fa-cart-plus'=>'cart-plus'),
array('far fa-cash-register'=>'cash-register'),
array('far fa-cassette-tape'=>'cassette-tape'),
array('far fa-cat'=>'cat'),
array('far fa-cat-space'=>'cat-space'),
array('far fa-cauldron'=>'cauldron'),
array('far fa-cctv'=>'cctv'),
array('far fa-certificate'=>'certificate'),
array('far fa-chair'=>'chair'),
array('far fa-chair-office'=>'chair-office'),
array('far fa-chalkboard'=>'chalkboard'),
array('far fa-chalkboard-teacher'=>'chalkboard-teacher'),
array('far fa-charging-station'=>'charging-station'),
array('far fa-chart-area'=>'chart-area'),
array('far fa-chart-bar'=>'chart-bar'),
array('far fa-chart-line'=>'chart-line'),
array('far fa-chart-line-down'=>'chart-line-down'),
array('far fa-chart-network'=>'chart-network'),
array('far fa-chart-pie'=>'chart-pie'),
array('far fa-chart-pie-alt'=>'chart-pie-alt'),
array('far fa-chart-scatter'=>'chart-scatter'),
array('far fa-check'=>'check'),
array('far fa-check-circle'=>'check-circle'),
array('far fa-check-double'=>'check-double'),
array('far fa-check-square'=>'check-square'),
array('far fa-cheese'=>'cheese'),
array('far fa-cheese-swiss'=>'cheese-swiss'),
array('far fa-cheeseburger'=>'cheeseburger'),
array('far fa-chess'=>'chess'),
array('far fa-chess-bishop'=>'chess-bishop'),
array('far fa-chess-bishop-alt'=>'chess-bishop-alt'),
array('far fa-chess-board'=>'chess-board'),
array('far fa-chess-clock'=>'chess-clock'),
array('far fa-chess-clock-alt'=>'chess-clock-alt'),
array('far fa-chess-king'=>'chess-king'),
array('far fa-chess-king-alt'=>'chess-king-alt'),
array('far fa-chess-knight'=>'chess-knight'),
array('far fa-chess-knight-alt'=>'chess-knight-alt'),
array('far fa-chess-pawn'=>'chess-pawn'),
array('far fa-chess-pawn-alt'=>'chess-pawn-alt'),
array('far fa-chess-queen'=>'chess-queen'),
array('far fa-chess-queen-alt'=>'chess-queen-alt'),
array('far fa-chess-rook'=>'chess-rook'),
array('far fa-chess-rook-alt'=>'chess-rook-alt'),
array('far fa-chevron-circle-down'=>'chevron-circle-down'),
array('far fa-chevron-circle-left'=>'chevron-circle-left'),
array('far fa-chevron-circle-right'=>'chevron-circle-right'),
array('far fa-chevron-circle-up'=>'chevron-circle-up'),
array('far fa-chevron-double-down'=>'chevron-double-down'),
array('far fa-chevron-double-left'=>'chevron-double-left'),
array('far fa-chevron-double-right'=>'chevron-double-right'),
array('far fa-chevron-double-up'=>'chevron-double-up'),
array('far fa-chevron-down'=>'chevron-down'),
array('far fa-chevron-left'=>'chevron-left'),
array('far fa-chevron-right'=>'chevron-right'),
array('far fa-chevron-square-down'=>'chevron-square-down'),
array('far fa-chevron-square-left'=>'chevron-square-left'),
array('far fa-chevron-square-right'=>'chevron-square-right'),
array('far fa-chevron-square-up'=>'chevron-square-up'),
array('far fa-chevron-up'=>'chevron-up'),
array('far fa-child'=>'child'),
array('far fa-chimney'=>'chimney'),
array('far fa-church'=>'church'),
array('far fa-circle'=>'circle'),
array('far fa-circle-notch'=>'circle-notch'),
array('far fa-city'=>'city'),
array('far fa-clarinet'=>'clarinet'),
array('far fa-claw-marks'=>'claw-marks'),
array('far fa-clinic-medical'=>'clinic-medical'),
array('far fa-clipboard'=>'clipboard'),
array('far fa-clipboard-check'=>'clipboard-check'),
array('far fa-clipboard-list'=>'clipboard-list'),
array('far fa-clipboard-list-check'=>'clipboard-list-check'),
array('far fa-clipboard-prescription'=>'clipboard-prescription'),
array('far fa-clipboard-user'=>'clipboard-user'),
array('far fa-clock'=>'clock'),
array('far fa-clone'=>'clone'),
array('far fa-closed-captioning'=>'closed-captioning'),
array('far fa-cloud'=>'cloud'),
array('far fa-cloud-download'=>'cloud-download'),
array('far fa-cloud-download-alt'=>'cloud-download-alt'),
array('far fa-cloud-drizzle'=>'cloud-drizzle'),
array('far fa-cloud-hail'=>'cloud-hail'),
array('far fa-cloud-hail-mixed'=>'cloud-hail-mixed'),
array('far fa-cloud-meatball'=>'cloud-meatball'),
array('far fa-cloud-moon'=>'cloud-moon'),
array('far fa-cloud-moon-rain'=>'cloud-moon-rain'),
array('far fa-cloud-music'=>'cloud-music'),
array('far fa-cloud-rain'=>'cloud-rain'),
array('far fa-cloud-rainbow'=>'cloud-rainbow'),
array('far fa-cloud-showers'=>'cloud-showers'),
array('far fa-cloud-showers-heavy'=>'cloud-showers-heavy'),
array('far fa-cloud-sleet'=>'cloud-sleet'),
array('far fa-cloud-snow'=>'cloud-snow'),
array('far fa-cloud-sun'=>'cloud-sun'),
array('far fa-cloud-sun-rain'=>'cloud-sun-rain'),
array('far fa-cloud-upload'=>'cloud-upload'),
array('far fa-cloud-upload-alt'=>'cloud-upload-alt'),
array('far fa-clouds'=>'clouds'),
array('far fa-clouds-moon'=>'clouds-moon'),
array('far fa-clouds-sun'=>'clouds-sun'),
array('far fa-club'=>'club'),
array('far fa-cocktail'=>'cocktail'),
array('far fa-code'=>'code'),
array('far fa-code-branch'=>'code-branch'),
array('far fa-code-commit'=>'code-commit'),
array('far fa-code-merge'=>'code-merge'),
array('far fa-coffee'=>'coffee'),
array('far fa-coffee-pot'=>'coffee-pot'),
array('far fa-coffee-togo'=>'coffee-togo'),
array('far fa-coffin'=>'coffin'),
array('far fa-coffin-cross'=>'coffin-cross'),
array('far fa-cog'=>'cog'),
array('far fa-cogs'=>'cogs'),
array('far fa-coin'=>'coin'),
array('far fa-coins'=>'coins'),
array('far fa-columns'=>'columns'),
array('far fa-comet'=>'comet'),
array('far fa-comment'=>'comment'),
array('far fa-comment-alt'=>'comment-alt'),
array('far fa-comment-alt-check'=>'comment-alt-check'),
array('far fa-comment-alt-dollar'=>'comment-alt-dollar'),
array('far fa-comment-alt-dots'=>'comment-alt-dots'),
array('far fa-comment-alt-edit'=>'comment-alt-edit'),
array('far fa-comment-alt-exclamation'=>'comment-alt-exclamation'),
array('far fa-comment-alt-lines'=>'comment-alt-lines'),
array('far fa-comment-alt-medical'=>'comment-alt-medical'),
array('far fa-comment-alt-minus'=>'comment-alt-minus'),
array('far fa-comment-alt-music'=>'comment-alt-music'),
array('far fa-comment-alt-plus'=>'comment-alt-plus'),
array('far fa-comment-alt-slash'=>'comment-alt-slash'),
array('far fa-comment-alt-smile'=>'comment-alt-smile'),
array('far fa-comment-alt-times'=>'comment-alt-times'),
array('far fa-comment-check'=>'comment-check'),
array('far fa-comment-dollar'=>'comment-dollar'),
array('far fa-comment-dots'=>'comment-dots'),
array('far fa-comment-edit'=>'comment-edit'),
array('far fa-comment-exclamation'=>'comment-exclamation'),
array('far fa-comment-lines'=>'comment-lines'),
array('far fa-comment-medical'=>'comment-medical'),
array('far fa-comment-minus'=>'comment-minus'),
array('far fa-comment-music'=>'comment-music'),
array('far fa-comment-plus'=>'comment-plus'),
array('far fa-comment-slash'=>'comment-slash'),
array('far fa-comment-smile'=>'comment-smile'),
array('far fa-comment-times'=>'comment-times'),
array('far fa-comments'=>'comments'),
array('far fa-comments-alt'=>'comments-alt'),
array('far fa-comments-alt-dollar'=>'comments-alt-dollar'),
array('far fa-comments-dollar'=>'comments-dollar'),
array('far fa-compact-disc'=>'compact-disc'),
array('far fa-compass'=>'compass'),
array('far fa-compass-slash'=>'compass-slash'),
array('far fa-compress'=>'compress'),
array('far fa-compress-alt'=>'compress-alt'),
array('far fa-compress-arrows-alt'=>'compress-arrows-alt'),
array('far fa-compress-wide'=>'compress-wide'),
array('far fa-computer-classic'=>'computer-classic'),
array('far fa-computer-speaker'=>'computer-speaker'),
array('far fa-concierge-bell'=>'concierge-bell'),
array('far fa-construction'=>'construction'),
array('far fa-container-storage'=>'container-storage'),
array('far fa-conveyor-belt'=>'conveyor-belt'),
array('far fa-conveyor-belt-alt'=>'conveyor-belt-alt'),
array('far fa-cookie'=>'cookie'),
array('far fa-cookie-bite'=>'cookie-bite'),
array('far fa-copy'=>'copy'),
array('far fa-copyright'=>'copyright'),
array('far fa-corn'=>'corn'),
array('far fa-couch'=>'couch'),
array('far fa-cow'=>'cow'),
array('far fa-cowbell'=>'cowbell'),
array('far fa-cowbell-more'=>'cowbell-more'),
array('far fa-credit-card'=>'credit-card'),
array('far fa-credit-card-blank'=>'credit-card-blank'),
array('far fa-credit-card-front'=>'credit-card-front'),
array('far fa-cricket'=>'cricket'),
array('far fa-croissant'=>'croissant'),
array('far fa-crop'=>'crop'),
array('far fa-crop-alt'=>'crop-alt'),
array('far fa-cross'=>'cross'),
array('far fa-crosshairs'=>'crosshairs'),
array('far fa-crow'=>'crow'),
array('far fa-crown'=>'crown'),
array('far fa-crutch'=>'crutch'),
array('far fa-crutches'=>'crutches'),
array('far fa-cube'=>'cube'),
array('far fa-cubes'=>'cubes'),
array('far fa-curling'=>'curling'),
array('far fa-cut'=>'cut'),
array('far fa-dagger'=>'dagger'),
array('far fa-database'=>'database'),
array('far fa-deaf'=>'deaf'),
array('far fa-debug'=>'debug'),
array('far fa-deer'=>'deer'),
array('far fa-deer-rudolph'=>'deer-rudolph'),
array('far fa-democrat'=>'democrat'),
array('far fa-desktop'=>'desktop'),
array('far fa-desktop-alt'=>'desktop-alt'),
array('far fa-dewpoint'=>'dewpoint'),
array('far fa-dharmachakra'=>'dharmachakra'),
array('far fa-diagnoses'=>'diagnoses'),
array('far fa-diamond'=>'diamond'),
array('far fa-dice'=>'dice'),
array('far fa-dice-d10'=>'dice-d10'),
array('far fa-dice-d12'=>'dice-d12'),
array('far fa-dice-d20'=>'dice-d20'),
array('far fa-dice-d4'=>'dice-d4'),
array('far fa-dice-d6'=>'dice-d6'),
array('far fa-dice-d8'=>'dice-d8'),
array('far fa-dice-five'=>'dice-five'),
array('far fa-dice-four'=>'dice-four'),
array('far fa-dice-one'=>'dice-one'),
array('far fa-dice-six'=>'dice-six'),
array('far fa-dice-three'=>'dice-three'),
array('far fa-dice-two'=>'dice-two'),
array('far fa-digging'=>'digging'),
array('far fa-digital-tachograph'=>'digital-tachograph'),
array('far fa-diploma'=>'diploma'),
array('far fa-directions'=>'directions'),
array('far fa-disc-drive'=>'disc-drive'),
array('far fa-disease'=>'disease'),
array('far fa-divide'=>'divide'),
array('far fa-dizzy'=>'dizzy'),
array('far fa-dna'=>'dna'),
array('far fa-do-not-enter'=>'do-not-enter'),
array('far fa-dog'=>'dog'),
array('far fa-dog-leashed'=>'dog-leashed'),
array('far fa-dollar-sign'=>'dollar-sign'),
array('far fa-dolly'=>'dolly'),
array('far fa-dolly-empty'=>'dolly-empty'),
array('far fa-dolly-flatbed'=>'dolly-flatbed'),
array('far fa-dolly-flatbed-alt'=>'dolly-flatbed-alt'),
array('far fa-dolly-flatbed-empty'=>'dolly-flatbed-empty'),
array('far fa-donate'=>'donate'),
array('far fa-door-closed'=>'door-closed'),
array('far fa-door-open'=>'door-open'),
array('far fa-dot-circle'=>'dot-circle'),
array('far fa-dove'=>'dove'),
array('far fa-download'=>'download'),
array('far fa-drafting-compass'=>'drafting-compass'),
array('far fa-dragon'=>'dragon'),
array('far fa-draw-circle'=>'draw-circle'),
array('far fa-draw-polygon'=>'draw-polygon'),
array('far fa-draw-square'=>'draw-square'),
array('far fa-dreidel'=>'dreidel'),
array('far fa-drone'=>'drone'),
array('far fa-drone-alt'=>'drone-alt'),
array('far fa-drum'=>'drum'),
array('far fa-drum-steelpan'=>'drum-steelpan'),
array('far fa-drumstick'=>'drumstick'),
array('far fa-drumstick-bite'=>'drumstick-bite'),
array('far fa-dryer'=>'dryer'),
array('far fa-dryer-alt'=>'dryer-alt'),
array('far fa-duck'=>'duck'),
array('far fa-dumbbell'=>'dumbbell'),
array('far fa-dumpster'=>'dumpster'),
array('far fa-dumpster-fire'=>'dumpster-fire'),
array('far fa-dungeon'=>'dungeon'),
array('far fa-ear'=>'ear'),
array('far fa-ear-muffs'=>'ear-muffs'),
array('far fa-eclipse'=>'eclipse'),
array('far fa-eclipse-alt'=>'eclipse-alt'),
array('far fa-edit'=>'edit'),
array('far fa-egg'=>'egg'),
array('far fa-egg-fried'=>'egg-fried'),
array('far fa-eject'=>'eject'),
array('far fa-elephant'=>'elephant'),
array('far fa-ellipsis-h'=>'ellipsis-h'),
array('far fa-ellipsis-h-alt'=>'ellipsis-h-alt'),
array('far fa-ellipsis-v'=>'ellipsis-v'),
array('far fa-ellipsis-v-alt'=>'ellipsis-v-alt'),
array('far fa-empty-set'=>'empty-set'),
array('far fa-engine-warning'=>'engine-warning'),
array('far fa-envelope'=>'envelope'),
array('far fa-envelope-open'=>'envelope-open'),
array('far fa-envelope-open-dollar'=>'envelope-open-dollar'),
array('far fa-envelope-open-text'=>'envelope-open-text'),
array('far fa-envelope-square'=>'envelope-square'),
array('far fa-equals'=>'equals'),
array('far fa-eraser'=>'eraser'),
array('far fa-ethernet'=>'ethernet'),
array('far fa-euro-sign'=>'euro-sign'),
array('far fa-exchange'=>'exchange'),
array('far fa-exchange-alt'=>'exchange-alt'),
array('far fa-exclamation'=>'exclamation'),
array('far fa-exclamation-circle'=>'exclamation-circle'),
array('far fa-exclamation-square'=>'exclamation-square'),
array('far fa-exclamation-triangle'=>'exclamation-triangle'),
array('far fa-expand'=>'expand'),
array('far fa-expand-alt'=>'expand-alt'),
array('far fa-expand-arrows'=>'expand-arrows'),
array('far fa-expand-arrows-alt'=>'expand-arrows-alt'),
array('far fa-expand-wide'=>'expand-wide'),
array('far fa-external-link'=>'external-link'),
array('far fa-external-link-alt'=>'external-link-alt'),
array('far fa-external-link-square'=>'external-link-square'),
array('far fa-external-link-square-alt'=>'external-link-square-alt'),
array('far fa-eye'=>'eye'),
array('far fa-eye-dropper'=>'eye-dropper'),
array('far fa-eye-evil'=>'eye-evil'),
array('far fa-eye-slash'=>'eye-slash'),
array('far fa-fan'=>'fan'),
array('far fa-fan-table'=>'fan-table'),
array('far fa-farm'=>'farm'),
array('far fa-fast-backward'=>'fast-backward'),
array('far fa-fast-forward'=>'fast-forward'),
array('far fa-faucet'=>'faucet'),
array('far fa-faucet-drip'=>'faucet-drip'),
array('far fa-fax'=>'fax'),
array('far fa-feather'=>'feather'),
array('far fa-feather-alt'=>'feather-alt'),
array('far fa-female'=>'female'),
array('far fa-field-hockey'=>'field-hockey'),
array('far fa-fighter-jet'=>'fighter-jet'),
array('far fa-file'=>'file'),
array('far fa-file-alt'=>'file-alt'),
array('far fa-file-archive'=>'file-archive'),
array('far fa-file-audio'=>'file-audio'),
array('far fa-file-certificate'=>'file-certificate'),
array('far fa-file-chart-line'=>'file-chart-line'),
array('far fa-file-chart-pie'=>'file-chart-pie'),
array('far fa-file-check'=>'file-check'),
array('far fa-file-code'=>'file-code'),
array('far fa-file-contract'=>'file-contract'),
array('far fa-file-csv'=>'file-csv'),
array('far fa-file-download'=>'file-download'),
array('far fa-file-edit'=>'file-edit'),
array('far fa-file-excel'=>'file-excel'),
array('far fa-file-exclamation'=>'file-exclamation'),
array('far fa-file-export'=>'file-export'),
array('far fa-file-image'=>'file-image'),
array('far fa-file-import'=>'file-import'),
array('far fa-file-invoice'=>'file-invoice'),
array('far fa-file-invoice-dollar'=>'file-invoice-dollar'),
array('far fa-file-medical'=>'file-medical'),
array('far fa-file-medical-alt'=>'file-medical-alt'),
array('far fa-file-minus'=>'file-minus'),
array('far fa-file-music'=>'file-music'),
array('far fa-file-pdf'=>'file-pdf'),
array('far fa-file-plus'=>'file-plus'),
array('far fa-file-powerpoint'=>'file-powerpoint'),
array('far fa-file-prescription'=>'file-prescription'),
array('far fa-file-search'=>'file-search'),
array('far fa-file-signature'=>'file-signature'),
array('far fa-file-spreadsheet'=>'file-spreadsheet'),
array('far fa-file-times'=>'file-times'),
array('far fa-file-upload'=>'file-upload'),
array('far fa-file-user'=>'file-user'),
array('far fa-file-video'=>'file-video'),
array('far fa-file-word'=>'file-word'),
array('far fa-files-medical'=>'files-medical'),
array('far fa-fill'=>'fill'),
array('far fa-fill-drip'=>'fill-drip'),
array('far fa-film'=>'film'),
array('far fa-film-alt'=>'film-alt'),
array('far fa-film-canister'=>'film-canister'),
array('far fa-filter'=>'filter'),
array('far fa-fingerprint'=>'fingerprint'),
array('far fa-fire'=>'fire'),
array('far fa-fire-alt'=>'fire-alt'),
array('far fa-fire-extinguisher'=>'fire-extinguisher'),
array('far fa-fire-smoke'=>'fire-smoke'),
array('far fa-fireplace'=>'fireplace'),
array('far fa-first-aid'=>'first-aid'),
array('far fa-fish'=>'fish'),
array('far fa-fish-cooked'=>'fish-cooked'),
array('far fa-fist-raised'=>'fist-raised'),
array('far fa-flag'=>'flag'),
array('far fa-flag-alt'=>'flag-alt'),
array('far fa-flag-checkered'=>'flag-checkered'),
array('far fa-flag-usa'=>'flag-usa'),
array('far fa-flame'=>'flame'),
array('far fa-flashlight'=>'flashlight'),
array('far fa-flask'=>'flask'),
array('far fa-flask-poison'=>'flask-poison'),
array('far fa-flask-potion'=>'flask-potion'),
array('far fa-flower'=>'flower'),
array('far fa-flower-daffodil'=>'flower-daffodil'),
array('far fa-flower-tulip'=>'flower-tulip'),
array('far fa-flushed'=>'flushed'),
array('far fa-flute'=>'flute'),
array('far fa-flux-capacitor'=>'flux-capacitor'),
array('far fa-fog'=>'fog'),
array('far fa-folder'=>'folder'),
array('far fa-folder-download'=>'folder-download'),
array('far fa-folder-minus'=>'folder-minus'),
array('far fa-folder-open'=>'folder-open'),
array('far fa-folder-plus'=>'folder-plus'),
array('far fa-folder-times'=>'folder-times'),
array('far fa-folder-tree'=>'folder-tree'),
array('far fa-folder-upload'=>'folder-upload'),
array('far fa-folders'=>'folders'),
array('far fa-font'=>'font'),
array('far fa-font-case'=>'font-case'),
array('far fa-football-ball'=>'football-ball'),
array('far fa-football-helmet'=>'football-helmet'),
array('far fa-forklift'=>'forklift'),
array('far fa-forward'=>'forward'),
array('far fa-fragile'=>'fragile'),
array('far fa-french-fries'=>'french-fries'),
array('far fa-frog'=>'frog'),
array('far fa-frosty-head'=>'frosty-head'),
array('far fa-frown'=>'frown'),
array('far fa-frown-open'=>'frown-open'),
array('far fa-function'=>'function'),
array('far fa-funnel-dollar'=>'funnel-dollar'),
array('far fa-futbol'=>'futbol'),
array('far fa-galaxy'=>'galaxy'),
array('far fa-game-board'=>'game-board'),
array('far fa-game-board-alt'=>'game-board-alt'),
array('far fa-game-console-handheld'=>'game-console-handheld'),
array('far fa-gamepad'=>'gamepad'),
array('far fa-gamepad-alt'=>'gamepad-alt'),
array('far fa-garage'=>'garage'),
array('far fa-garage-car'=>'garage-car'),
array('far fa-garage-open'=>'garage-open'),
array('far fa-gas-pump'=>'gas-pump'),
array('far fa-gas-pump-slash'=>'gas-pump-slash'),
array('far fa-gavel'=>'gavel'),
array('far fa-gem'=>'gem'),
array('far fa-genderless'=>'genderless'),
array('far fa-ghost'=>'ghost'),
array('far fa-gift'=>'gift'),
array('far fa-gift-card'=>'gift-card'),
array('far fa-gifts'=>'gifts'),
array('far fa-gingerbread-man'=>'gingerbread-man'),
array('far fa-glass'=>'glass'),
array('far fa-glass-champagne'=>'glass-champagne'),
array('far fa-glass-cheers'=>'glass-cheers'),
array('far fa-glass-citrus'=>'glass-citrus'),
array('far fa-glass-martini'=>'glass-martini'),
array('far fa-glass-martini-alt'=>'glass-martini-alt'),
array('far fa-glass-whiskey'=>'glass-whiskey'),
array('far fa-glass-whiskey-rocks'=>'glass-whiskey-rocks'),
array('far fa-glasses'=>'glasses'),
array('far fa-glasses-alt'=>'glasses-alt'),
array('far fa-globe'=>'globe'),
array('far fa-globe-africa'=>'globe-africa'),
array('far fa-globe-americas'=>'globe-americas'),
array('far fa-globe-asia'=>'globe-asia'),
array('far fa-globe-europe'=>'globe-europe'),
array('far fa-globe-snow'=>'globe-snow'),
array('far fa-globe-stand'=>'globe-stand'),
array('far fa-golf-ball'=>'golf-ball'),
array('far fa-golf-club'=>'golf-club'),
array('far fa-gopuram'=>'gopuram'),
array('far fa-graduation-cap'=>'graduation-cap'),
array('far fa-gramophone'=>'gramophone'),
array('far fa-greater-than'=>'greater-than'),
array('far fa-greater-than-equal'=>'greater-than-equal'),
array('far fa-grimace'=>'grimace'),
array('far fa-grin'=>'grin'),
array('far fa-grin-alt'=>'grin-alt'),
array('far fa-grin-beam'=>'grin-beam'),
array('far fa-grin-beam-sweat'=>'grin-beam-sweat'),
array('far fa-grin-hearts'=>'grin-hearts'),
array('far fa-grin-squint'=>'grin-squint'),
array('far fa-grin-squint-tears'=>'grin-squint-tears'),
array('far fa-grin-stars'=>'grin-stars'),
array('far fa-grin-tears'=>'grin-tears'),
array('far fa-grin-tongue'=>'grin-tongue'),
array('far fa-grin-tongue-squint'=>'grin-tongue-squint'),
array('far fa-grin-tongue-wink'=>'grin-tongue-wink'),
array('far fa-grin-wink'=>'grin-wink'),
array('far fa-grip-horizontal'=>'grip-horizontal'),
array('far fa-grip-lines'=>'grip-lines'),
array('far fa-grip-lines-vertical'=>'grip-lines-vertical'),
array('far fa-grip-vertical'=>'grip-vertical'),
array('far fa-guitar'=>'guitar'),
array('far fa-guitar-electric'=>'guitar-electric'),
array('far fa-guitars'=>'guitars'),
array('far fa-h-square'=>'h-square'),
array('far fa-h1'=>'h1'),
array('far fa-h2'=>'h2'),
array('far fa-h3'=>'h3'),
array('far fa-h4'=>'h4'),
array('far fa-hamburger'=>'hamburger'),
array('far fa-hammer'=>'hammer'),
array('far fa-hammer-war'=>'hammer-war'),
array('far fa-hamsa'=>'hamsa'),
array('far fa-hand-heart'=>'hand-heart'),
array('far fa-hand-holding'=>'hand-holding'),
array('far fa-hand-holding-box'=>'hand-holding-box'),
array('far fa-hand-holding-heart'=>'hand-holding-heart'),
array('far fa-hand-holding-magic'=>'hand-holding-magic'),
array('far fa-hand-holding-seedling'=>'hand-holding-seedling'),
array('far fa-hand-holding-usd'=>'hand-holding-usd'),
array('far fa-hand-holding-water'=>'hand-holding-water'),
array('far fa-hand-lizard'=>'hand-lizard'),
array('far fa-hand-middle-finger'=>'hand-middle-finger'),
array('far fa-hand-paper'=>'hand-paper'),
array('far fa-hand-peace'=>'hand-peace'),
array('far fa-hand-point-down'=>'hand-point-down'),
array('far fa-hand-point-left'=>'hand-point-left'),
array('far fa-hand-point-right'=>'hand-point-right'),
array('far fa-hand-point-up'=>'hand-point-up'),
array('far fa-hand-pointer'=>'hand-pointer'),
array('far fa-hand-receiving'=>'hand-receiving'),
array('far fa-hand-rock'=>'hand-rock'),
array('far fa-hand-scissors'=>'hand-scissors'),
array('far fa-hand-spock'=>'hand-spock'),
array('far fa-hands'=>'hands'),
array('far fa-hands-heart'=>'hands-heart'),
array('far fa-hands-helping'=>'hands-helping'),
array('far fa-hands-usd'=>'hands-usd'),
array('far fa-handshake'=>'handshake'),
array('far fa-handshake-alt'=>'handshake-alt'),
array('far fa-hanukiah'=>'hanukiah'),
array('far fa-hard-hat'=>'hard-hat'),
array('far fa-hashtag'=>'hashtag'),
array('far fa-hat-chef'=>'hat-chef'),
array('far fa-hat-cowboy'=>'hat-cowboy'),
array('far fa-hat-cowboy-side'=>'hat-cowboy-side'),
array('far fa-hat-santa'=>'hat-santa'),
array('far fa-hat-winter'=>'hat-winter'),
array('far fa-hat-witch'=>'hat-witch'),
array('far fa-hat-wizard'=>'hat-wizard'),
array('far fa-hdd'=>'hdd'),
array('far fa-head-side'=>'head-side'),
array('far fa-head-side-brain'=>'head-side-brain'),
array('far fa-head-side-headphones'=>'head-side-headphones'),
array('far fa-head-side-medical'=>'head-side-medical'),
array('far fa-head-vr'=>'head-vr'),
array('far fa-heading'=>'heading'),
array('far fa-headphones'=>'headphones'),
array('far fa-headphones-alt'=>'headphones-alt'),
array('far fa-headset'=>'headset'),
array('far fa-heart'=>'heart'),
array('far fa-heart-broken'=>'heart-broken'),
array('far fa-heart-circle'=>'heart-circle'),
array('far fa-heart-rate'=>'heart-rate'),
array('far fa-heart-square'=>'heart-square'),
array('far fa-heartbeat'=>'heartbeat'),
array('far fa-heat'=>'heat'),
array('far fa-helicopter'=>'helicopter'),
array('far fa-helmet-battle'=>'helmet-battle'),
array('far fa-hexagon'=>'hexagon'),
array('far fa-highlighter'=>'highlighter'),
array('far fa-hiking'=>'hiking'),
array('far fa-hippo'=>'hippo'),
array('far fa-history'=>'history'),
array('far fa-hockey-mask'=>'hockey-mask'),
array('far fa-hockey-puck'=>'hockey-puck'),
array('far fa-hockey-sticks'=>'hockey-sticks'),
array('far fa-holly-berry'=>'holly-berry'),
array('far fa-home'=>'home'),
array('far fa-home-alt'=>'home-alt'),
array('far fa-home-heart'=>'home-heart'),
array('far fa-home-lg'=>'home-lg'),
array('far fa-home-lg-alt'=>'home-lg-alt'),
array('far fa-hood-cloak'=>'hood-cloak'),
array('far fa-horizontal-rule'=>'horizontal-rule'),
array('far fa-horse'=>'horse'),
array('far fa-horse-head'=>'horse-head'),
array('far fa-horse-saddle'=>'horse-saddle'),
array('far fa-hospital'=>'hospital'),
array('far fa-hospital-alt'=>'hospital-alt'),
array('far fa-hospital-symbol'=>'hospital-symbol'),
array('far fa-hospital-user'=>'hospital-user'),
array('far fa-hospitals'=>'hospitals'),
array('far fa-hot-tub'=>'hot-tub'),
array('far fa-hotdog'=>'hotdog'),
array('far fa-hotel'=>'hotel'),
array('far fa-hourglass'=>'hourglass'),
array('far fa-hourglass-end'=>'hourglass-end'),
array('far fa-hourglass-half'=>'hourglass-half'),
array('far fa-hourglass-start'=>'hourglass-start'),
array('far fa-house'=>'house'),
array('far fa-house-damage'=>'house-damage'),
array('far fa-house-day'=>'house-day'),
array('far fa-house-flood'=>'house-flood'),
array('far fa-house-leave'=>'house-leave'),
array('far fa-house-night'=>'house-night'),
array('far fa-house-return'=>'house-return'),
array('far fa-house-signal'=>'house-signal'),
array('far fa-hryvnia'=>'hryvnia'),
array('far fa-humidity'=>'humidity'),
array('far fa-hurricane'=>'hurricane'),
array('far fa-i-cursor'=>'i-cursor'),
array('far fa-ice-cream'=>'ice-cream'),
array('far fa-ice-skate'=>'ice-skate'),
array('far fa-icicles'=>'icicles'),
array('far fa-icons'=>'icons'),
array('far fa-icons-alt'=>'icons-alt'),
array('far fa-id-badge'=>'id-badge'),
array('far fa-id-card'=>'id-card'),
array('far fa-id-card-alt'=>'id-card-alt'),
array('far fa-igloo'=>'igloo'),
array('far fa-image'=>'image'),
array('far fa-image-polaroid'=>'image-polaroid'),
array('far fa-images'=>'images'),
array('far fa-inbox'=>'inbox'),
array('far fa-inbox-in'=>'inbox-in'),
array('far fa-inbox-out'=>'inbox-out'),
array('far fa-indent'=>'indent'),
array('far fa-industry'=>'industry'),
array('far fa-industry-alt'=>'industry-alt'),
array('far fa-infinity'=>'infinity'),
array('far fa-info'=>'info'),
array('far fa-info-circle'=>'info-circle'),
array('far fa-info-square'=>'info-square'),
array('far fa-inhaler'=>'inhaler'),
array('far fa-integral'=>'integral'),
array('far fa-intersection'=>'intersection'),
array('far fa-inventory'=>'inventory'),
array('far fa-island-tropical'=>'island-tropical'),
array('far fa-italic'=>'italic'),
array('far fa-jack-o-lantern'=>'jack-o-lantern'),
array('far fa-jedi'=>'jedi'),
array('far fa-joint'=>'joint'),
array('far fa-journal-whills'=>'journal-whills'),
array('far fa-joystick'=>'joystick'),
array('far fa-jug'=>'jug'),
array('far fa-kaaba'=>'kaaba'),
array('far fa-kazoo'=>'kazoo'),
array('far fa-kerning'=>'kerning'),
array('far fa-key'=>'key'),
array('far fa-key-skeleton'=>'key-skeleton'),
array('far fa-keyboard'=>'keyboard'),
array('far fa-keynote'=>'keynote'),
array('far fa-khanda'=>'khanda'),
array('far fa-kidneys'=>'kidneys'),
array('far fa-kiss'=>'kiss'),
array('far fa-kiss-beam'=>'kiss-beam'),
array('far fa-kiss-wink-heart'=>'kiss-wink-heart'),
array('far fa-kite'=>'kite'),
array('far fa-kiwi-bird'=>'kiwi-bird'),
array('far fa-knife-kitchen'=>'knife-kitchen'),
array('far fa-lambda'=>'lambda'),
array('far fa-lamp'=>'lamp'),
array('far fa-lamp-desk'=>'lamp-desk'),
array('far fa-lamp-floor'=>'lamp-floor'),
array('far fa-landmark'=>'landmark'),
array('far fa-landmark-alt'=>'landmark-alt'),
array('far fa-language'=>'language'),
array('far fa-laptop'=>'laptop'),
array('far fa-laptop-code'=>'laptop-code'),
array('far fa-laptop-medical'=>'laptop-medical'),
array('far fa-lasso'=>'lasso'),
array('far fa-laugh'=>'laugh'),
array('far fa-laugh-beam'=>'laugh-beam'),
array('far fa-laugh-squint'=>'laugh-squint'),
array('far fa-laugh-wink'=>'laugh-wink'),
array('far fa-layer-group'=>'layer-group'),
array('far fa-layer-minus'=>'layer-minus'),
array('far fa-layer-plus'=>'layer-plus'),
array('far fa-leaf'=>'leaf'),
array('far fa-leaf-heart'=>'leaf-heart'),
array('far fa-leaf-maple'=>'leaf-maple'),
array('far fa-leaf-oak'=>'leaf-oak'),
array('far fa-lemon'=>'lemon'),
array('far fa-less-than'=>'less-than'),
array('far fa-less-than-equal'=>'less-than-equal'),
array('far fa-level-down'=>'level-down'),
array('far fa-level-down-alt'=>'level-down-alt'),
array('far fa-level-up'=>'level-up'),
array('far fa-level-up-alt'=>'level-up-alt'),
array('far fa-life-ring'=>'life-ring'),
array('far fa-light-ceiling'=>'light-ceiling'),
array('far fa-light-switch'=>'light-switch'),
array('far fa-light-switch-off'=>'light-switch-off'),
array('far fa-light-switch-on'=>'light-switch-on'),
array('far fa-lightbulb'=>'lightbulb'),
array('far fa-lightbulb-dollar'=>'lightbulb-dollar'),
array('far fa-lightbulb-exclamation'=>'lightbulb-exclamation'),
array('far fa-lightbulb-on'=>'lightbulb-on'),
array('far fa-lightbulb-slash'=>'lightbulb-slash'),
array('far fa-lights-holiday'=>'lights-holiday'),
array('far fa-line-columns'=>'line-columns'),
array('far fa-line-height'=>'line-height'),
array('far fa-link'=>'link'),
array('far fa-lips'=>'lips'),
array('far fa-lira-sign'=>'lira-sign'),
array('far fa-list'=>'list'),
array('far fa-list-alt'=>'list-alt'),
array('far fa-list-music'=>'list-music'),
array('far fa-list-ol'=>'list-ol'),
array('far fa-list-ul'=>'list-ul'),
array('far fa-location'=>'location'),
array('far fa-location-arrow'=>'location-arrow'),
array('far fa-location-circle'=>'location-circle'),
array('far fa-location-slash'=>'location-slash'),
array('far fa-lock'=>'lock'),
array('far fa-lock-alt'=>'lock-alt'),
array('far fa-lock-open'=>'lock-open'),
array('far fa-lock-open-alt'=>'lock-open-alt'),
array('far fa-long-arrow-alt-down'=>'long-arrow-alt-down'),
array('far fa-long-arrow-alt-left'=>'long-arrow-alt-left'),
array('far fa-long-arrow-alt-right'=>'long-arrow-alt-right'),
array('far fa-long-arrow-alt-up'=>'long-arrow-alt-up'),
array('far fa-long-arrow-down'=>'long-arrow-down'),
array('far fa-long-arrow-left'=>'long-arrow-left'),
array('far fa-long-arrow-right'=>'long-arrow-right'),
array('far fa-long-arrow-up'=>'long-arrow-up'),
array('far fa-loveseat'=>'loveseat'),
array('far fa-low-vision'=>'low-vision'),
array('far fa-luchador'=>'luchador'),
array('far fa-luggage-cart'=>'luggage-cart'),
array('far fa-lungs'=>'lungs'),
array('far fa-mace'=>'mace'),
array('far fa-magic'=>'magic'),
array('far fa-magnet'=>'magnet'),
array('far fa-mail-bulk'=>'mail-bulk'),
array('far fa-mailbox'=>'mailbox'),
array('far fa-male'=>'male'),
array('far fa-mandolin'=>'mandolin'),
array('far fa-map'=>'map'),
array('far fa-map-marked'=>'map-marked'),
array('far fa-map-marked-alt'=>'map-marked-alt'),
array('far fa-map-marker'=>'map-marker'),
array('far fa-map-marker-alt'=>'map-marker-alt'),
array('far fa-map-marker-alt-slash'=>'map-marker-alt-slash'),
array('far fa-map-marker-check'=>'map-marker-check'),
array('far fa-map-marker-edit'=>'map-marker-edit'),
array('far fa-map-marker-exclamation'=>'map-marker-exclamation'),
array('far fa-map-marker-minus'=>'map-marker-minus'),
array('far fa-map-marker-plus'=>'map-marker-plus'),
array('far fa-map-marker-question'=>'map-marker-question'),
array('far fa-map-marker-slash'=>'map-marker-slash'),
array('far fa-map-marker-smile'=>'map-marker-smile'),
array('far fa-map-marker-times'=>'map-marker-times'),
array('far fa-map-pin'=>'map-pin'),
array('far fa-map-signs'=>'map-signs'),
array('far fa-marker'=>'marker'),
array('far fa-mars'=>'mars'),
array('far fa-mars-double'=>'mars-double'),
array('far fa-mars-stroke'=>'mars-stroke'),
array('far fa-mars-stroke-h'=>'mars-stroke-h'),
array('far fa-mars-stroke-v'=>'mars-stroke-v'),
array('far fa-mask'=>'mask'),
array('far fa-meat'=>'meat'),
array('far fa-medal'=>'medal'),
array('far fa-medkit'=>'medkit'),
array('far fa-megaphone'=>'megaphone'),
array('far fa-meh'=>'meh'),
array('far fa-meh-blank'=>'meh-blank'),
array('far fa-meh-rolling-eyes'=>'meh-rolling-eyes'),
array('far fa-memory'=>'memory'),
array('far fa-menorah'=>'menorah'),
array('far fa-mercury'=>'mercury'),
array('far fa-meteor'=>'meteor'),
array('far fa-microchip'=>'microchip'),
array('far fa-microphone'=>'microphone'),
array('far fa-microphone-alt'=>'microphone-alt'),
array('far fa-microphone-alt-slash'=>'microphone-alt-slash'),
array('far fa-microphone-slash'=>'microphone-slash'),
array('far fa-microphone-stand'=>'microphone-stand'),
array('far fa-microscope'=>'microscope'),
array('far fa-microwave'=>'microwave'),
array('far fa-mind-share'=>'mind-share'),
array('far fa-minus'=>'minus'),
array('far fa-minus-circle'=>'minus-circle'),
array('far fa-minus-hexagon'=>'minus-hexagon'),
array('far fa-minus-octagon'=>'minus-octagon'),
array('far fa-minus-square'=>'minus-square'),
array('far fa-mistletoe'=>'mistletoe'),
array('far fa-mitten'=>'mitten'),
array('far fa-mobile'=>'mobile'),
array('far fa-mobile-alt'=>'mobile-alt'),
array('far fa-mobile-android'=>'mobile-android'),
array('far fa-mobile-android-alt'=>'mobile-android-alt'),
array('far fa-money-bill'=>'money-bill'),
array('far fa-money-bill-alt'=>'money-bill-alt'),
array('far fa-money-bill-wave'=>'money-bill-wave'),
array('far fa-money-bill-wave-alt'=>'money-bill-wave-alt'),
array('far fa-money-check'=>'money-check'),
array('far fa-money-check-alt'=>'money-check-alt'),
array('far fa-money-check-edit'=>'money-check-edit'),
array('far fa-money-check-edit-alt'=>'money-check-edit-alt'),
array('far fa-monitor-heart-rate'=>'monitor-heart-rate'),
array('far fa-monkey'=>'monkey'),
array('far fa-monument'=>'monument'),
array('far fa-moon'=>'moon'),
array('far fa-moon-cloud'=>'moon-cloud'),
array('far fa-moon-stars'=>'moon-stars'),
array('far fa-mortar-pestle'=>'mortar-pestle'),
array('far fa-mosque'=>'mosque'),
array('far fa-motorcycle'=>'motorcycle'),
array('far fa-mountain'=>'mountain'),
array('far fa-mountains'=>'mountains'),
array('far fa-mouse'=>'mouse'),
array('far fa-mouse-alt'=>'mouse-alt'),
array('far fa-mouse-pointer'=>'mouse-pointer'),
array('far fa-mp3-player'=>'mp3-player'),
array('far fa-mug'=>'mug'),
array('far fa-mug-hot'=>'mug-hot'),
array('far fa-mug-marshmallows'=>'mug-marshmallows'),
array('far fa-mug-tea'=>'mug-tea'),
array('far fa-music'=>'music'),
array('far fa-music-alt'=>'music-alt'),
array('far fa-music-alt-slash'=>'music-alt-slash'),
array('far fa-music-slash'=>'music-slash'),
array('far fa-narwhal'=>'narwhal'),
array('far fa-network-wired'=>'network-wired'),
array('far fa-neuter'=>'neuter'),
array('far fa-newspaper'=>'newspaper'),
array('far fa-not-equal'=>'not-equal'),
array('far fa-notes-medical'=>'notes-medical'),
array('far fa-object-group'=>'object-group'),
array('far fa-object-ungroup'=>'object-ungroup'),
array('far fa-octagon'=>'octagon'),
array('far fa-oil-can'=>'oil-can'),
array('far fa-oil-temp'=>'oil-temp'),
array('far fa-om'=>'om'),
array('far fa-omega'=>'omega'),
array('far fa-ornament'=>'ornament'),
array('far fa-otter'=>'otter'),
array('far fa-outdent'=>'outdent'),
array('far fa-outlet'=>'outlet'),
array('far fa-oven'=>'oven'),
array('far fa-overline'=>'overline'),
array('far fa-page-break'=>'page-break'),
array('far fa-pager'=>'pager'),
array('far fa-paint-brush'=>'paint-brush'),
array('far fa-paint-brush-alt'=>'paint-brush-alt'),
array('far fa-paint-roller'=>'paint-roller'),
array('far fa-palette'=>'palette'),
array('far fa-pallet'=>'pallet'),
array('far fa-pallet-alt'=>'pallet-alt'),
array('far fa-paper-plane'=>'paper-plane'),
array('far fa-paperclip'=>'paperclip'),
array('far fa-parachute-box'=>'parachute-box'),
array('far fa-paragraph'=>'paragraph'),
array('far fa-paragraph-rtl'=>'paragraph-rtl'),
array('far fa-parking'=>'parking'),
array('far fa-parking-circle'=>'parking-circle'),
array('far fa-parking-circle-slash'=>'parking-circle-slash'),
array('far fa-parking-slash'=>'parking-slash'),
array('far fa-passport'=>'passport'),
array('far fa-pastafarianism'=>'pastafarianism'),
array('far fa-paste'=>'paste'),
array('far fa-pause'=>'pause'),
array('far fa-pause-circle'=>'pause-circle'),
array('far fa-paw'=>'paw'),
array('far fa-paw-alt'=>'paw-alt'),
array('far fa-paw-claws'=>'paw-claws'),
array('far fa-peace'=>'peace'),
array('far fa-pegasus'=>'pegasus'),
array('far fa-pen'=>'pen'),
array('far fa-pen-alt'=>'pen-alt'),
array('far fa-pen-fancy'=>'pen-fancy'),
array('far fa-pen-nib'=>'pen-nib'),
array('far fa-pen-square'=>'pen-square'),
array('far fa-pencil'=>'pencil'),
array('far fa-pencil-alt'=>'pencil-alt'),
array('far fa-pencil-paintbrush'=>'pencil-paintbrush'),
array('far fa-pencil-ruler'=>'pencil-ruler'),
array('far fa-pennant'=>'pennant'),
array('far fa-people-carry'=>'people-carry'),
array('far fa-pepper-hot'=>'pepper-hot'),
array('far fa-percent'=>'percent'),
array('far fa-percentage'=>'percentage'),
array('far fa-person-booth'=>'person-booth'),
array('far fa-person-carry'=>'person-carry'),
array('far fa-person-dolly'=>'person-dolly'),
array('far fa-person-dolly-empty'=>'person-dolly-empty'),
array('far fa-person-sign'=>'person-sign'),
array('far fa-phone'=>'phone'),
array('far fa-phone-alt'=>'phone-alt'),
array('far fa-phone-laptop'=>'phone-laptop'),
array('far fa-phone-office'=>'phone-office'),
array('far fa-phone-plus'=>'phone-plus'),
array('far fa-phone-rotary'=>'phone-rotary'),
array('far fa-phone-slash'=>'phone-slash'),
array('far fa-phone-square'=>'phone-square'),
array('far fa-phone-square-alt'=>'phone-square-alt'),
array('far fa-phone-volume'=>'phone-volume'),
array('far fa-photo-video'=>'photo-video'),
array('far fa-pi'=>'pi'),
array('far fa-piano'=>'piano'),
array('far fa-piano-keyboard'=>'piano-keyboard'),
array('far fa-pie'=>'pie'),
array('far fa-pig'=>'pig'),
array('far fa-piggy-bank'=>'piggy-bank'),
array('far fa-pills'=>'pills'),
array('far fa-pizza'=>'pizza'),
array('far fa-pizza-slice'=>'pizza-slice'),
array('far fa-place-of-worship'=>'place-of-worship'),
array('far fa-plane'=>'plane'),
array('far fa-plane-alt'=>'plane-alt'),
array('far fa-plane-arrival'=>'plane-arrival'),
array('far fa-plane-departure'=>'plane-departure'),
array('far fa-planet-moon'=>'planet-moon'),
array('far fa-planet-ringed'=>'planet-ringed'),
array('far fa-play'=>'play'),
array('far fa-play-circle'=>'play-circle'),
array('far fa-plug'=>'plug'),
array('far fa-plus'=>'plus'),
array('far fa-plus-circle'=>'plus-circle'),
array('far fa-plus-hexagon'=>'plus-hexagon'),
array('far fa-plus-octagon'=>'plus-octagon'),
array('far fa-plus-square'=>'plus-square'),
array('far fa-podcast'=>'podcast'),
array('far fa-podium'=>'podium'),
array('far fa-podium-star'=>'podium-star'),
array('far fa-police-box'=>'police-box'),
array('far fa-poll'=>'poll'),
array('far fa-poll-h'=>'poll-h'),
array('far fa-poll-people'=>'poll-people'),
array('far fa-poo'=>'poo'),
array('far fa-poo-storm'=>'poo-storm'),
array('far fa-poop'=>'poop'),
array('far fa-popcorn'=>'popcorn'),
array('far fa-portal-enter'=>'portal-enter'),
array('far fa-portal-exit'=>'portal-exit'),
array('far fa-portrait'=>'portrait'),
array('far fa-pound-sign'=>'pound-sign'),
array('far fa-power-off'=>'power-off'),
array('far fa-pray'=>'pray'),
array('far fa-praying-hands'=>'praying-hands'),
array('far fa-prescription'=>'prescription'),
array('far fa-prescription-bottle'=>'prescription-bottle'),
array('far fa-prescription-bottle-alt'=>'prescription-bottle-alt'),
array('far fa-presentation'=>'presentation'),
array('far fa-print'=>'print'),
array('far fa-print-search'=>'print-search'),
array('far fa-print-slash'=>'print-slash'),
array('far fa-procedures'=>'procedures'),
array('far fa-project-diagram'=>'project-diagram'),
array('far fa-projector'=>'projector'),
array('far fa-pumpkin'=>'pumpkin'),
array('far fa-puzzle-piece'=>'puzzle-piece'),
array('far fa-qrcode'=>'qrcode'),
array('far fa-question'=>'question'),
array('far fa-question-circle'=>'question-circle'),
array('far fa-question-square'=>'question-square'),
array('far fa-quidditch'=>'quidditch'),
array('far fa-quote-left'=>'quote-left'),
array('far fa-quote-right'=>'quote-right'),
array('far fa-quran'=>'quran'),
array('far fa-rabbit'=>'rabbit'),
array('far fa-rabbit-fast'=>'rabbit-fast'),
array('far fa-racquet'=>'racquet'),
array('far fa-radar'=>'radar'),
array('far fa-radiation'=>'radiation'),
array('far fa-radiation-alt'=>'radiation-alt'),
array('far fa-radio'=>'radio'),
array('far fa-radio-alt'=>'radio-alt'),
array('far fa-rainbow'=>'rainbow'),
array('far fa-raindrops'=>'raindrops'),
array('far fa-ram'=>'ram'),
array('far fa-ramp-loading'=>'ramp-loading'),
array('far fa-random'=>'random'),
array('far fa-raygun'=>'raygun'),
array('far fa-receipt'=>'receipt'),
array('far fa-record-vinyl'=>'record-vinyl'),
array('far fa-rectangle-landscape'=>'rectangle-landscape'),
array('far fa-rectangle-portrait'=>'rectangle-portrait'),
array('far fa-rectangle-wide'=>'rectangle-wide'),
array('far fa-recycle'=>'recycle'),
array('far fa-redo'=>'redo'),
array('far fa-redo-alt'=>'redo-alt'),
array('far fa-refrigerator'=>'refrigerator'),
array('far fa-registered'=>'registered'),
array('far fa-remove-format'=>'remove-format'),
array('far fa-repeat'=>'repeat'),
array('far fa-repeat-1'=>'repeat-1'),
array('far fa-repeat-1-alt'=>'repeat-1-alt'),
array('far fa-repeat-alt'=>'repeat-alt'),
array('far fa-reply'=>'reply'),
array('far fa-reply-all'=>'reply-all'),
array('far fa-republican'=>'republican'),
array('far fa-restroom'=>'restroom'),
array('far fa-retweet'=>'retweet'),
array('far fa-retweet-alt'=>'retweet-alt'),
array('far fa-ribbon'=>'ribbon'),
array('far fa-ring'=>'ring'),
array('far fa-rings-wedding'=>'rings-wedding'),
array('far fa-road'=>'road'),
array('far fa-robot'=>'robot'),
array('far fa-rocket'=>'rocket'),
array('far fa-rocket-launch'=>'rocket-launch'),
array('far fa-route'=>'route'),
array('far fa-route-highway'=>'route-highway'),
array('far fa-route-interstate'=>'route-interstate'),
array('far fa-router'=>'router'),
array('far fa-rss'=>'rss'),
array('far fa-rss-square'=>'rss-square'),
array('far fa-ruble-sign'=>'ruble-sign'),
array('far fa-ruler'=>'ruler'),
array('far fa-ruler-combined'=>'ruler-combined'),
array('far fa-ruler-horizontal'=>'ruler-horizontal'),
array('far fa-ruler-triangle'=>'ruler-triangle'),
array('far fa-ruler-vertical'=>'ruler-vertical'),
array('far fa-running'=>'running'),
array('far fa-rupee-sign'=>'rupee-sign'),
array('far fa-rv'=>'rv'),
array('far fa-sack'=>'sack'),
array('far fa-sack-dollar'=>'sack-dollar'),
array('far fa-sad-cry'=>'sad-cry'),
array('far fa-sad-tear'=>'sad-tear'),
array('far fa-salad'=>'salad'),
array('far fa-sandwich'=>'sandwich'),
array('far fa-satellite'=>'satellite'),
array('far fa-satellite-dish'=>'satellite-dish'),
array('far fa-sausage'=>'sausage'),
array('far fa-save'=>'save'),
array('far fa-sax-hot'=>'sax-hot'),
array('far fa-saxophone'=>'saxophone'),
array('far fa-scalpel'=>'scalpel'),
array('far fa-scalpel-path'=>'scalpel-path'),
array('far fa-scanner'=>'scanner'),
array('far fa-scanner-image'=>'scanner-image'),
array('far fa-scanner-keyboard'=>'scanner-keyboard'),
array('far fa-scanner-touchscreen'=>'scanner-touchscreen'),
array('far fa-scarecrow'=>'scarecrow'),
array('far fa-scarf'=>'scarf'),
array('far fa-school'=>'school'),
array('far fa-screwdriver'=>'screwdriver'),
array('far fa-scroll'=>'scroll'),
array('far fa-scroll-old'=>'scroll-old'),
array('far fa-scrubber'=>'scrubber'),
array('far fa-scythe'=>'scythe'),
array('far fa-sd-card'=>'sd-card'),
array('far fa-search'=>'search'),
array('far fa-search-dollar'=>'search-dollar'),
array('far fa-search-location'=>'search-location'),
array('far fa-search-minus'=>'search-minus'),
array('far fa-search-plus'=>'search-plus'),
array('far fa-seedling'=>'seedling'),
array('far fa-send-back'=>'send-back'),
array('far fa-send-backward'=>'send-backward'),
array('far fa-sensor'=>'sensor'),
array('far fa-sensor-alert'=>'sensor-alert'),
array('far fa-sensor-fire'=>'sensor-fire'),
array('far fa-sensor-on'=>'sensor-on'),
array('far fa-sensor-smoke'=>'sensor-smoke'),
array('far fa-server'=>'server'),
array('far fa-shapes'=>'shapes'),
array('far fa-share'=>'share'),
array('far fa-share-all'=>'share-all'),
array('far fa-share-alt'=>'share-alt'),
array('far fa-share-alt-square'=>'share-alt-square'),
array('far fa-share-square'=>'share-square'),
array('far fa-sheep'=>'sheep'),
array('far fa-shekel-sign'=>'shekel-sign'),
array('far fa-shield'=>'shield'),
array('far fa-shield-alt'=>'shield-alt'),
array('far fa-shield-check'=>'shield-check'),
array('far fa-shield-cross'=>'shield-cross'),
array('far fa-ship'=>'ship'),
array('far fa-shipping-fast'=>'shipping-fast'),
array('far fa-shipping-timed'=>'shipping-timed'),
array('far fa-shish-kebab'=>'shish-kebab'),
array('far fa-shoe-prints'=>'shoe-prints'),
array('far fa-shopping-bag'=>'shopping-bag'),
array('far fa-shopping-basket'=>'shopping-basket'),
array('far fa-shopping-cart'=>'shopping-cart'),
array('far fa-shovel'=>'shovel'),
array('far fa-shovel-snow'=>'shovel-snow'),
array('far fa-shower'=>'shower'),
array('far fa-shredder'=>'shredder'),
array('far fa-shuttle-van'=>'shuttle-van'),
array('far fa-shuttlecock'=>'shuttlecock'),
array('far fa-sickle'=>'sickle'),
array('far fa-sigma'=>'sigma'),
array('far fa-sign'=>'sign'),
array('far fa-sign-in'=>'sign-in'),
array('far fa-sign-in-alt'=>'sign-in-alt'),
array('far fa-sign-language'=>'sign-language'),
array('far fa-sign-out'=>'sign-out'),
array('far fa-sign-out-alt'=>'sign-out-alt'),
array('far fa-signal'=>'signal'),
array('far fa-signal-1'=>'signal-1'),
array('far fa-signal-2'=>'signal-2'),
array('far fa-signal-3'=>'signal-3'),
array('far fa-signal-4'=>'signal-4'),
array('far fa-signal-alt'=>'signal-alt'),
array('far fa-signal-alt-1'=>'signal-alt-1'),
array('far fa-signal-alt-2'=>'signal-alt-2'),
array('far fa-signal-alt-3'=>'signal-alt-3'),
array('far fa-signal-alt-slash'=>'signal-alt-slash'),
array('far fa-signal-slash'=>'signal-slash'),
array('far fa-signal-stream'=>'signal-stream'),
array('far fa-signature'=>'signature'),
array('far fa-sim-card'=>'sim-card'),
array('far fa-siren'=>'siren'),
array('far fa-siren-on'=>'siren-on'),
array('far fa-sitemap'=>'sitemap'),
array('far fa-skating'=>'skating'),
array('far fa-skeleton'=>'skeleton'),
array('far fa-ski-jump'=>'ski-jump'),
array('far fa-ski-lift'=>'ski-lift'),
array('far fa-skiing'=>'skiing'),
array('far fa-skiing-nordic'=>'skiing-nordic'),
array('far fa-skull'=>'skull'),
array('far fa-skull-cow'=>'skull-cow'),
array('far fa-skull-crossbones'=>'skull-crossbones'),
array('far fa-slash'=>'slash'),
array('far fa-sledding'=>'sledding'),
array('far fa-sleigh'=>'sleigh'),
array('far fa-sliders-h'=>'sliders-h'),
array('far fa-sliders-h-square'=>'sliders-h-square'),
array('far fa-sliders-v'=>'sliders-v'),
array('far fa-sliders-v-square'=>'sliders-v-square'),
array('far fa-smile'=>'smile'),
array('far fa-smile-beam'=>'smile-beam'),
array('far fa-smile-plus'=>'smile-plus'),
array('far fa-smile-wink'=>'smile-wink'),
array('far fa-smog'=>'smog'),
array('far fa-smoke'=>'smoke'),
array('far fa-smoking'=>'smoking'),
array('far fa-smoking-ban'=>'smoking-ban'),
array('far fa-sms'=>'sms'),
array('far fa-snake'=>'snake'),
array('far fa-snooze'=>'snooze'),
array('far fa-snow-blowing'=>'snow-blowing'),
array('far fa-snowboarding'=>'snowboarding'),
array('far fa-snowflake'=>'snowflake'),
array('far fa-snowflakes'=>'snowflakes'),
array('far fa-snowman'=>'snowman'),
array('far fa-snowmobile'=>'snowmobile'),
array('far fa-snowplow'=>'snowplow'),
array('far fa-socks'=>'socks'),
array('far fa-solar-panel'=>'solar-panel'),
array('far fa-solar-system'=>'solar-system'),
array('far fa-sort'=>'sort'),
array('far fa-sort-alpha-down'=>'sort-alpha-down'),
array('far fa-sort-alpha-down-alt'=>'sort-alpha-down-alt'),
array('far fa-sort-alpha-up'=>'sort-alpha-up'),
array('far fa-sort-alpha-up-alt'=>'sort-alpha-up-alt'),
array('far fa-sort-alt'=>'sort-alt'),
array('far fa-sort-amount-down'=>'sort-amount-down'),
array('far fa-sort-amount-down-alt'=>'sort-amount-down-alt'),
array('far fa-sort-amount-up'=>'sort-amount-up'),
array('far fa-sort-amount-up-alt'=>'sort-amount-up-alt'),
array('far fa-sort-circle'=>'sort-circle'),
array('far fa-sort-circle-down'=>'sort-circle-down'),
array('far fa-sort-circle-up'=>'sort-circle-up'),
array('far fa-sort-down'=>'sort-down'),
array('far fa-sort-numeric-down'=>'sort-numeric-down'),
array('far fa-sort-numeric-down-alt'=>'sort-numeric-down-alt'),
array('far fa-sort-numeric-up'=>'sort-numeric-up'),
array('far fa-sort-numeric-up-alt'=>'sort-numeric-up-alt'),
array('far fa-sort-shapes-down'=>'sort-shapes-down'),
array('far fa-sort-shapes-down-alt'=>'sort-shapes-down-alt'),
array('far fa-sort-shapes-up'=>'sort-shapes-up'),
array('far fa-sort-shapes-up-alt'=>'sort-shapes-up-alt'),
array('far fa-sort-size-down'=>'sort-size-down'),
array('far fa-sort-size-down-alt'=>'sort-size-down-alt'),
array('far fa-sort-size-up'=>'sort-size-up'),
array('far fa-sort-size-up-alt'=>'sort-size-up-alt'),
array('far fa-sort-up'=>'sort-up'),
array('far fa-soup'=>'soup'),
array('far fa-spa'=>'spa'),
array('far fa-space-shuttle'=>'space-shuttle'),
array('far fa-space-station-moon'=>'space-station-moon'),
array('far fa-space-station-moon-alt'=>'space-station-moon-alt'),
array('far fa-spade'=>'spade'),
array('far fa-sparkles'=>'sparkles'),
array('far fa-speaker'=>'speaker'),
array('far fa-speakers'=>'speakers'),
array('far fa-spell-check'=>'spell-check'),
array('far fa-spider'=>'spider'),
array('far fa-spider-black-widow'=>'spider-black-widow'),
array('far fa-spider-web'=>'spider-web'),
array('far fa-spinner'=>'spinner'),
array('far fa-spinner-third'=>'spinner-third'),
array('far fa-splotch'=>'splotch'),
array('far fa-spray-can'=>'spray-can'),
array('far fa-sprinkler'=>'sprinkler'),
array('far fa-square'=>'square'),
array('far fa-square-full'=>'square-full'),
array('far fa-square-root'=>'square-root'),
array('far fa-square-root-alt'=>'square-root-alt'),
array('far fa-squirrel'=>'squirrel'),
array('far fa-staff'=>'staff'),
array('far fa-stamp'=>'stamp'),
array('far fa-star'=>'star'),
array('far fa-star-and-crescent'=>'star-and-crescent'),
array('far fa-star-christmas'=>'star-christmas'),
array('far fa-star-exclamation'=>'star-exclamation'),
array('far fa-star-half'=>'star-half'),
array('far fa-star-half-alt'=>'star-half-alt'),
array('far fa-star-of-david'=>'star-of-david'),
array('far fa-star-of-life'=>'star-of-life'),
array('far fa-star-shooting'=>'star-shooting'),
array('far fa-starfighter'=>'starfighter'),
array('far fa-starfighter-alt'=>'starfighter-alt'),
array('far fa-stars'=>'stars'),
array('far fa-starship'=>'starship'),
array('far fa-starship-freighter'=>'starship-freighter'),
array('far fa-steak'=>'steak'),
array('far fa-steering-wheel'=>'steering-wheel'),
array('far fa-step-backward'=>'step-backward'),
array('far fa-step-forward'=>'step-forward'),
array('far fa-stethoscope'=>'stethoscope'),
array('far fa-sticky-note'=>'sticky-note'),
array('far fa-stocking'=>'stocking'),
array('far fa-stomach'=>'stomach'),
array('far fa-stop'=>'stop'),
array('far fa-stop-circle'=>'stop-circle'),
array('far fa-stopwatch'=>'stopwatch'),
array('far fa-store'=>'store'),
array('far fa-store-alt'=>'store-alt'),
array('far fa-stream'=>'stream'),
array('far fa-street-view'=>'street-view'),
array('far fa-stretcher'=>'stretcher'),
array('far fa-strikethrough'=>'strikethrough'),
array('far fa-stroopwafel'=>'stroopwafel'),
array('far fa-subscript'=>'subscript'),
array('far fa-subway'=>'subway'),
array('far fa-suitcase'=>'suitcase'),
array('far fa-suitcase-rolling'=>'suitcase-rolling'),
array('far fa-sun'=>'sun'),
array('far fa-sun-cloud'=>'sun-cloud'),
array('far fa-sun-dust'=>'sun-dust'),
array('far fa-sun-haze'=>'sun-haze'),
array('far fa-sunglasses'=>'sunglasses'),
array('far fa-sunrise'=>'sunrise'),
array('far fa-sunset'=>'sunset'),
array('far fa-superscript'=>'superscript'),
array('far fa-surprise'=>'surprise'),
array('far fa-swatchbook'=>'swatchbook'),
array('far fa-swimmer'=>'swimmer'),
array('far fa-swimming-pool'=>'swimming-pool'),
array('far fa-sword'=>'sword'),
array('far fa-sword-laser'=>'sword-laser'),
array('far fa-sword-laser-alt'=>'sword-laser-alt'),
array('far fa-swords'=>'swords'),
array('far fa-swords-laser'=>'swords-laser'),
array('far fa-synagogue'=>'synagogue'),
array('far fa-sync'=>'sync'),
array('far fa-sync-alt'=>'sync-alt'),
array('far fa-syringe'=>'syringe'),
array('far fa-table'=>'table'),
array('far fa-table-tennis'=>'table-tennis'),
array('far fa-tablet'=>'tablet'),
array('far fa-tablet-alt'=>'tablet-alt'),
array('far fa-tablet-android'=>'tablet-android'),
array('far fa-tablet-android-alt'=>'tablet-android-alt'),
array('far fa-tablet-rugged'=>'tablet-rugged'),
array('far fa-tablets'=>'tablets'),
array('far fa-tachometer'=>'tachometer'),
array('far fa-tachometer-alt'=>'tachometer-alt'),
array('far fa-tachometer-alt-average'=>'tachometer-alt-average'),
array('far fa-tachometer-alt-fast'=>'tachometer-alt-fast'),
array('far fa-tachometer-alt-fastest'=>'tachometer-alt-fastest'),
array('far fa-tachometer-alt-slow'=>'tachometer-alt-slow'),
array('far fa-tachometer-alt-slowest'=>'tachometer-alt-slowest'),
array('far fa-tachometer-average'=>'tachometer-average'),
array('far fa-tachometer-fast'=>'tachometer-fast'),
array('far fa-tachometer-fastest'=>'tachometer-fastest'),
array('far fa-tachometer-slow'=>'tachometer-slow'),
array('far fa-tachometer-slowest'=>'tachometer-slowest'),
array('far fa-taco'=>'taco'),
array('far fa-tag'=>'tag'),
array('far fa-tags'=>'tags'),
array('far fa-tally'=>'tally'),
array('far fa-tanakh'=>'tanakh'),
array('far fa-tape'=>'tape'),
array('far fa-tasks'=>'tasks'),
array('far fa-tasks-alt'=>'tasks-alt'),
array('far fa-taxi'=>'taxi'),
array('far fa-teeth'=>'teeth'),
array('far fa-teeth-open'=>'teeth-open'),
array('far fa-telescope'=>'telescope'),
array('far fa-temperature-down'=>'temperature-down'),
array('far fa-temperature-frigid'=>'temperature-frigid'),
array('far fa-temperature-high'=>'temperature-high'),
array('far fa-temperature-hot'=>'temperature-hot'),
array('far fa-temperature-low'=>'temperature-low'),
array('far fa-temperature-up'=>'temperature-up'),
array('far fa-tenge'=>'tenge'),
array('far fa-tennis-ball'=>'tennis-ball'),
array('far fa-terminal'=>'terminal'),
array('far fa-text'=>'text'),
array('far fa-text-height'=>'text-height'),
array('far fa-text-size'=>'text-size'),
array('far fa-text-width'=>'text-width'),
array('far fa-th'=>'th'),
array('far fa-th-large'=>'th-large'),
array('far fa-th-list'=>'th-list'),
array('far fa-theater-masks'=>'theater-masks'),
array('far fa-thermometer'=>'thermometer'),
array('far fa-thermometer-empty'=>'thermometer-empty'),
array('far fa-thermometer-full'=>'thermometer-full'),
array('far fa-thermometer-half'=>'thermometer-half'),
array('far fa-thermometer-quarter'=>'thermometer-quarter'),
array('far fa-thermometer-three-quarters'=>'thermometer-three-quarters'),
array('far fa-theta'=>'theta'),
array('far fa-thumbs-down'=>'thumbs-down'),
array('far fa-thumbs-up'=>'thumbs-up'),
array('far fa-thumbtack'=>'thumbtack'),
array('far fa-thunderstorm'=>'thunderstorm'),
array('far fa-thunderstorm-moon'=>'thunderstorm-moon'),
array('far fa-thunderstorm-sun'=>'thunderstorm-sun'),
array('far fa-ticket'=>'ticket'),
array('far fa-ticket-alt'=>'ticket-alt'),
array('far fa-tilde'=>'tilde'),
array('far fa-times'=>'times'),
array('far fa-times-circle'=>'times-circle'),
array('far fa-times-hexagon'=>'times-hexagon'),
array('far fa-times-octagon'=>'times-octagon'),
array('far fa-times-square'=>'times-square'),
array('far fa-tint'=>'tint'),
array('far fa-tint-slash'=>'tint-slash'),
array('far fa-tire'=>'tire'),
array('far fa-tire-flat'=>'tire-flat'),
array('far fa-tire-pressure-warning'=>'tire-pressure-warning'),
array('far fa-tire-rugged'=>'tire-rugged'),
array('far fa-tired'=>'tired'),
array('far fa-toggle-off'=>'toggle-off'),
array('far fa-toggle-on'=>'toggle-on'),
array('far fa-toilet'=>'toilet'),
array('far fa-toilet-paper'=>'toilet-paper'),
array('far fa-toilet-paper-alt'=>'toilet-paper-alt'),
array('far fa-tombstone'=>'tombstone'),
array('far fa-tombstone-alt'=>'tombstone-alt'),
array('far fa-toolbox'=>'toolbox'),
array('far fa-tools'=>'tools'),
array('far fa-tooth'=>'tooth'),
array('far fa-toothbrush'=>'toothbrush'),
array('far fa-torah'=>'torah'),
array('far fa-torii-gate'=>'torii-gate'),
array('far fa-tornado'=>'tornado'),
array('far fa-tractor'=>'tractor'),
array('far fa-trademark'=>'trademark'),
array('far fa-traffic-cone'=>'traffic-cone'),
array('far fa-traffic-light'=>'traffic-light'),
array('far fa-traffic-light-go'=>'traffic-light-go'),
array('far fa-traffic-light-slow'=>'traffic-light-slow'),
array('far fa-traffic-light-stop'=>'traffic-light-stop'),
array('far fa-trailer'=>'trailer'),
array('far fa-train'=>'train'),
array('far fa-tram'=>'tram'),
array('far fa-transgender'=>'transgender'),
array('far fa-transgender-alt'=>'transgender-alt'),
array('far fa-transporter'=>'transporter'),
array('far fa-transporter-1'=>'transporter-1'),
array('far fa-transporter-2'=>'transporter-2'),
array('far fa-transporter-3'=>'transporter-3'),
array('far fa-transporter-empty'=>'transporter-empty'),
array('far fa-trash'=>'trash'),
array('far fa-trash-alt'=>'trash-alt'),
array('far fa-trash-restore'=>'trash-restore'),
array('far fa-trash-restore-alt'=>'trash-restore-alt'),
array('far fa-trash-undo'=>'trash-undo'),
array('far fa-trash-undo-alt'=>'trash-undo-alt'),
array('far fa-treasure-chest'=>'treasure-chest'),
array('far fa-tree'=>'tree'),
array('far fa-tree-alt'=>'tree-alt'),
array('far fa-tree-christmas'=>'tree-christmas'),
array('far fa-tree-decorated'=>'tree-decorated'),
array('far fa-tree-large'=>'tree-large'),
array('far fa-tree-palm'=>'tree-palm'),
array('far fa-trees'=>'trees'),
array('far fa-triangle'=>'triangle'),
array('far fa-triangle-music'=>'triangle-music'),
array('far fa-trophy'=>'trophy'),
array('far fa-trophy-alt'=>'trophy-alt'),
array('far fa-truck'=>'truck'),
array('far fa-truck-container'=>'truck-container'),
array('far fa-truck-couch'=>'truck-couch'),
array('far fa-truck-loading'=>'truck-loading'),
array('far fa-truck-monster'=>'truck-monster'),
array('far fa-truck-moving'=>'truck-moving'),
array('far fa-truck-pickup'=>'truck-pickup'),
array('far fa-truck-plow'=>'truck-plow'),
array('far fa-truck-ramp'=>'truck-ramp'),
array('far fa-trumpet'=>'trumpet'),
array('far fa-tshirt'=>'tshirt'),
array('far fa-tty'=>'tty'),
array('far fa-turkey'=>'turkey'),
array('far fa-turntable'=>'turntable'),
array('far fa-turtle'=>'turtle'),
array('far fa-tv'=>'tv'),
array('far fa-tv-alt'=>'tv-alt'),
array('far fa-tv-music'=>'tv-music'),
array('far fa-tv-retro'=>'tv-retro'),
array('far fa-typewriter'=>'typewriter'),
array('far fa-ufo'=>'ufo'),
array('far fa-ufo-beam'=>'ufo-beam'),
array('far fa-umbrella'=>'umbrella'),
array('far fa-umbrella-beach'=>'umbrella-beach'),
array('far fa-underline'=>'underline'),
array('far fa-undo'=>'undo'),
array('far fa-undo-alt'=>'undo-alt'),
array('far fa-unicorn'=>'unicorn'),
array('far fa-union'=>'union'),
array('far fa-universal-access'=>'universal-access'),
array('far fa-university'=>'university'),
array('far fa-unlink'=>'unlink'),
array('far fa-unlock'=>'unlock'),
array('far fa-unlock-alt'=>'unlock-alt'),
array('far fa-upload'=>'upload'),
array('far fa-usb-drive'=>'usb-drive'),
array('far fa-usd-circle'=>'usd-circle'),
array('far fa-usd-square'=>'usd-square'),
array('far fa-user'=>'user'),
array('far fa-user-alien'=>'user-alien'),
array('far fa-user-alt'=>'user-alt'),
array('far fa-user-alt-slash'=>'user-alt-slash'),
array('far fa-user-astronaut'=>'user-astronaut'),
array('far fa-user-chart'=>'user-chart'),
array('far fa-user-check'=>'user-check'),
array('far fa-user-circle'=>'user-circle'),
array('far fa-user-clock'=>'user-clock'),
array('far fa-user-cog'=>'user-cog'),
array('far fa-user-cowboy'=>'user-cowboy'),
array('far fa-user-crown'=>'user-crown'),
array('far fa-user-edit'=>'user-edit'),
array('far fa-user-friends'=>'user-friends'),
array('far fa-user-graduate'=>'user-graduate'),
array('far fa-user-hard-hat'=>'user-hard-hat'),
array('far fa-user-headset'=>'user-headset'),
array('far fa-user-injured'=>'user-injured'),
array('far fa-user-lock'=>'user-lock'),
array('far fa-user-md'=>'user-md'),
array('far fa-user-md-chat'=>'user-md-chat'),
array('far fa-user-minus'=>'user-minus'),
array('far fa-user-music'=>'user-music'),
array('far fa-user-ninja'=>'user-ninja'),
array('far fa-user-nurse'=>'user-nurse'),
array('far fa-user-plus'=>'user-plus'),
array('far fa-user-robot'=>'user-robot'),
array('far fa-user-secret'=>'user-secret'),
array('far fa-user-shield'=>'user-shield'),
array('far fa-user-slash'=>'user-slash'),
array('far fa-user-tag'=>'user-tag'),
array('far fa-user-tie'=>'user-tie'),
array('far fa-user-times'=>'user-times'),
array('far fa-user-unlock'=>'user-unlock'),
array('far fa-user-visor'=>'user-visor'),
array('far fa-users'=>'users'),
array('far fa-users-class'=>'users-class'),
array('far fa-users-cog'=>'users-cog'),
array('far fa-users-crown'=>'users-crown'),
array('far fa-users-medical'=>'users-medical'),
array('far fa-utensil-fork'=>'utensil-fork'),
array('far fa-utensil-knife'=>'utensil-knife'),
array('far fa-utensil-spoon'=>'utensil-spoon'),
array('far fa-utensils'=>'utensils'),
array('far fa-utensils-alt'=>'utensils-alt'),
array('far fa-vacuum'=>'vacuum'),
array('far fa-vacuum-robot'=>'vacuum-robot'),
array('far fa-value-absolute'=>'value-absolute'),
array('far fa-vector-square'=>'vector-square'),
array('far fa-venus'=>'venus'),
array('far fa-venus-double'=>'venus-double'),
array('far fa-venus-mars'=>'venus-mars'),
array('far fa-vhs'=>'vhs'),
array('far fa-vial'=>'vial'),
array('far fa-vials'=>'vials'),
array('far fa-video'=>'video'),
array('far fa-video-plus'=>'video-plus'),
array('far fa-video-slash'=>'video-slash'),
array('far fa-vihara'=>'vihara'),
array('far fa-violin'=>'violin'),
array('far fa-voicemail'=>'voicemail'),
array('far fa-volcano'=>'volcano'),
array('far fa-volleyball-ball'=>'volleyball-ball'),
array('far fa-volume'=>'volume'),
array('far fa-volume-down'=>'volume-down'),
array('far fa-volume-mute'=>'volume-mute'),
array('far fa-volume-off'=>'volume-off'),
array('far fa-volume-slash'=>'volume-slash'),
array('far fa-volume-up'=>'volume-up'),
array('far fa-vote-nay'=>'vote-nay'),
array('far fa-vote-yea'=>'vote-yea'),
array('far fa-vr-cardboard'=>'vr-cardboard'),
array('far fa-wagon-covered'=>'wagon-covered'),
array('far fa-walker'=>'walker'),
array('far fa-walkie-talkie'=>'walkie-talkie'),
array('far fa-walking'=>'walking'),
array('far fa-wallet'=>'wallet'),
array('far fa-wand'=>'wand'),
array('far fa-wand-magic'=>'wand-magic'),
array('far fa-warehouse'=>'warehouse'),
array('far fa-warehouse-alt'=>'warehouse-alt'),
array('far fa-washer'=>'washer'),
array('far fa-watch'=>'watch'),
array('far fa-watch-calculator'=>'watch-calculator'),
array('far fa-watch-fitness'=>'watch-fitness'),
array('far fa-water'=>'water'),
array('far fa-water-lower'=>'water-lower'),
array('far fa-water-rise'=>'water-rise'),
array('far fa-wave-sine'=>'wave-sine'),
array('far fa-wave-square'=>'wave-square'),
array('far fa-wave-triangle'=>'wave-triangle'),
array('far fa-waveform'=>'waveform'),
array('far fa-waveform-path'=>'waveform-path'),
array('far fa-webcam'=>'webcam'),
array('far fa-webcam-slash'=>'webcam-slash'),
array('far fa-weight'=>'weight'),
array('far fa-weight-hanging'=>'weight-hanging'),
array('far fa-whale'=>'whale'),
array('far fa-wheat'=>'wheat'),
array('far fa-wheelchair'=>'wheelchair'),
array('far fa-whistle'=>'whistle'),
array('far fa-wifi'=>'wifi'),
array('far fa-wifi-1'=>'wifi-1'),
array('far fa-wifi-2'=>'wifi-2'),
array('far fa-wifi-slash'=>'wifi-slash'),
array('far fa-wind'=>'wind'),
array('far fa-wind-turbine'=>'wind-turbine'),
array('far fa-wind-warning'=>'wind-warning'),
array('far fa-window'=>'window'),
array('far fa-window-alt'=>'window-alt'),
array('far fa-window-close'=>'window-close'),
array('far fa-window-frame'=>'window-frame'),
array('far fa-window-frame-open'=>'window-frame-open'),
array('far fa-window-maximize'=>'window-maximize'),
array('far fa-window-minimize'=>'window-minimize'),
array('far fa-window-restore'=>'window-restore'),
array('far fa-windsock'=>'windsock'),
array('far fa-wine-bottle'=>'wine-bottle'),
array('far fa-wine-glass'=>'wine-glass'),
array('far fa-wine-glass-alt'=>'wine-glass-alt'),
array('far fa-won-sign'=>'won-sign'),
array('far fa-wreath'=>'wreath'),
array('far fa-wrench'=>'wrench'),
array('far fa-x-ray'=>'x-ray'),
array('far fa-yen-sign'=>'yen-sign'),
array('far fa-yin-yang'=>'yin-yang'),
),
'Duotone Icons' => array(
array('fad fa-abacus'=>'abacus'),
array('fad fa-acorn'=>'acorn'),
array('fad fa-ad'=>'ad'),
array('fad fa-address-book'=>'address-book'),
array('fad fa-address-card'=>'address-card'),
array('fad fa-adjust'=>'adjust'),
array('fad fa-air-conditioner'=>'air-conditioner'),
array('fad fa-air-freshener'=>'air-freshener'),
array('fad fa-alarm-clock'=>'alarm-clock'),
array('fad fa-alarm-exclamation'=>'alarm-exclamation'),
array('fad fa-alarm-plus'=>'alarm-plus'),
array('fad fa-alarm-snooze'=>'alarm-snooze'),
array('fad fa-album'=>'album'),
array('fad fa-album-collection'=>'album-collection'),
array('fad fa-alicorn'=>'alicorn'),
array('fad fa-alien'=>'alien'),
array('fad fa-alien-monster'=>'alien-monster'),
array('fad fa-align-center'=>'align-center'),
array('fad fa-align-justify'=>'align-justify'),
array('fad fa-align-left'=>'align-left'),
array('fad fa-align-right'=>'align-right'),
array('fad fa-align-slash'=>'align-slash'),
array('fad fa-allergies'=>'allergies'),
array('fad fa-ambulance'=>'ambulance'),
array('fad fa-american-sign-language-interpreting'=>'american-sign-language-interpreting'),
array('fad fa-amp-guitar'=>'amp-guitar'),
array('fad fa-analytics'=>'analytics'),
array('fad fa-anchor'=>'anchor'),
array('fad fa-angel'=>'angel'),
array('fad fa-angle-double-down'=>'angle-double-down'),
array('fad fa-angle-double-left'=>'angle-double-left'),
array('fad fa-angle-double-right'=>'angle-double-right'),
array('fad fa-angle-double-up'=>'angle-double-up'),
array('fad fa-angle-down'=>'angle-down'),
array('fad fa-angle-left'=>'angle-left'),
array('fad fa-angle-right'=>'angle-right'),
array('fad fa-angle-up'=>'angle-up'),
array('fad fa-angry'=>'angry'),
array('fad fa-ankh'=>'ankh'),
array('fad fa-apple-alt'=>'apple-alt'),
array('fad fa-apple-crate'=>'apple-crate'),
array('fad fa-archive'=>'archive'),
array('fad fa-archway'=>'archway'),
array('fad fa-arrow-alt-circle-down'=>'arrow-alt-circle-down'),
array('fad fa-arrow-alt-circle-left'=>'arrow-alt-circle-left'),
array('fad fa-arrow-alt-circle-right'=>'arrow-alt-circle-right'),
array('fad fa-arrow-alt-circle-up'=>'arrow-alt-circle-up'),
array('fad fa-arrow-alt-down'=>'arrow-alt-down'),
array('fad fa-arrow-alt-from-bottom'=>'arrow-alt-from-bottom'),
array('fad fa-arrow-alt-from-left'=>'arrow-alt-from-left'),
array('fad fa-arrow-alt-from-right'=>'arrow-alt-from-right'),
array('fad fa-arrow-alt-from-top'=>'arrow-alt-from-top'),
array('fad fa-arrow-alt-left'=>'arrow-alt-left'),
array('fad fa-arrow-alt-right'=>'arrow-alt-right'),
array('fad fa-arrow-alt-square-down'=>'arrow-alt-square-down'),
array('fad fa-arrow-alt-square-left'=>'arrow-alt-square-left'),
array('fad fa-arrow-alt-square-right'=>'arrow-alt-square-right'),
array('fad fa-arrow-alt-square-up'=>'arrow-alt-square-up'),
array('fad fa-arrow-alt-to-bottom'=>'arrow-alt-to-bottom'),
array('fad fa-arrow-alt-to-left'=>'arrow-alt-to-left'),
array('fad fa-arrow-alt-to-right'=>'arrow-alt-to-right'),
array('fad fa-arrow-alt-to-top'=>'arrow-alt-to-top'),
array('fad fa-arrow-alt-up'=>'arrow-alt-up'),
array('fad fa-arrow-circle-down'=>'arrow-circle-down'),
array('fad fa-arrow-circle-left'=>'arrow-circle-left'),
array('fad fa-arrow-circle-right'=>'arrow-circle-right'),
array('fad fa-arrow-circle-up'=>'arrow-circle-up'),
array('fad fa-arrow-down'=>'arrow-down'),
array('fad fa-arrow-from-bottom'=>'arrow-from-bottom'),
array('fad fa-arrow-from-left'=>'arrow-from-left'),
array('fad fa-arrow-from-right'=>'arrow-from-right'),
array('fad fa-arrow-from-top'=>'arrow-from-top'),
array('fad fa-arrow-left'=>'arrow-left'),
array('fad fa-arrow-right'=>'arrow-right'),
array('fad fa-arrow-square-down'=>'arrow-square-down'),
array('fad fa-arrow-square-left'=>'arrow-square-left'),
array('fad fa-arrow-square-right'=>'arrow-square-right'),
array('fad fa-arrow-square-up'=>'arrow-square-up'),
array('fad fa-arrow-to-bottom'=>'arrow-to-bottom'),
array('fad fa-arrow-to-left'=>'arrow-to-left'),
array('fad fa-arrow-to-right'=>'arrow-to-right'),
array('fad fa-arrow-to-top'=>'arrow-to-top'),
array('fad fa-arrow-up'=>'arrow-up'),
array('fad fa-arrows'=>'arrows'),
array('fad fa-arrows-alt'=>'arrows-alt'),
array('fad fa-arrows-alt-h'=>'arrows-alt-h'),
array('fad fa-arrows-alt-v'=>'arrows-alt-v'),
array('fad fa-arrows-h'=>'arrows-h'),
array('fad fa-arrows-v'=>'arrows-v'),
array('fad fa-assistive-listening-systems'=>'assistive-listening-systems'),
array('fad fa-asterisk'=>'asterisk'),
array('fad fa-at'=>'at'),
array('fad fa-atlas'=>'atlas'),
array('fad fa-atom'=>'atom'),
array('fad fa-atom-alt'=>'atom-alt'),
array('fad fa-audio-description'=>'audio-description'),
array('fad fa-award'=>'award'),
array('fad fa-axe'=>'axe'),
array('fad fa-axe-battle'=>'axe-battle'),
array('fad fa-baby'=>'baby'),
array('fad fa-baby-carriage'=>'baby-carriage'),
array('fad fa-backpack'=>'backpack'),
array('fad fa-backspace'=>'backspace'),
array('fad fa-backward'=>'backward'),
array('fad fa-bacon'=>'bacon'),
array('fad fa-badge'=>'badge'),
array('fad fa-badge-check'=>'badge-check'),
array('fad fa-badge-dollar'=>'badge-dollar'),
array('fad fa-badge-percent'=>'badge-percent'),
array('fad fa-badge-sheriff'=>'badge-sheriff'),
array('fad fa-badger-honey'=>'badger-honey'),
array('fad fa-bags-shopping'=>'bags-shopping'),
array('fad fa-bahai'=>'bahai'),
array('fad fa-balance-scale'=>'balance-scale'),
array('fad fa-balance-scale-left'=>'balance-scale-left'),
array('fad fa-balance-scale-right'=>'balance-scale-right'),
array('fad fa-ball-pile'=>'ball-pile'),
array('fad fa-ballot'=>'ballot'),
array('fad fa-ballot-check'=>'ballot-check'),
array('fad fa-ban'=>'ban'),
array('fad fa-band-aid'=>'band-aid'),
array('fad fa-banjo'=>'banjo'),
array('fad fa-barcode'=>'barcode'),
array('fad fa-barcode-alt'=>'barcode-alt'),
array('fad fa-barcode-read'=>'barcode-read'),
array('fad fa-barcode-scan'=>'barcode-scan'),
array('fad fa-bars'=>'bars'),
array('fad fa-baseball'=>'baseball'),
array('fad fa-baseball-ball'=>'baseball-ball'),
array('fad fa-basketball-ball'=>'basketball-ball'),
array('fad fa-basketball-hoop'=>'basketball-hoop'),
array('fad fa-bat'=>'bat'),
array('fad fa-bath'=>'bath'),
array('fad fa-battery-bolt'=>'battery-bolt'),
array('fad fa-battery-empty'=>'battery-empty'),
array('fad fa-battery-full'=>'battery-full'),
array('fad fa-battery-half'=>'battery-half'),
array('fad fa-battery-quarter'=>'battery-quarter'),
array('fad fa-battery-slash'=>'battery-slash'),
array('fad fa-battery-three-quarters'=>'battery-three-quarters'),
array('fad fa-bed'=>'bed'),
array('fad fa-bed-alt'=>'bed-alt'),
array('fad fa-bed-bunk'=>'bed-bunk'),
array('fad fa-bed-empty'=>'bed-empty'),
array('fad fa-beer'=>'beer'),
array('fad fa-bell'=>'bell'),
array('fad fa-bell-exclamation'=>'bell-exclamation'),
array('fad fa-bell-on'=>'bell-on'),
array('fad fa-bell-plus'=>'bell-plus'),
array('fad fa-bell-school'=>'bell-school'),
array('fad fa-bell-school-slash'=>'bell-school-slash'),
array('fad fa-bell-slash'=>'bell-slash'),
array('fad fa-bells'=>'bells'),
array('fad fa-betamax'=>'betamax'),
array('fad fa-bezier-curve'=>'bezier-curve'),
array('fad fa-bible'=>'bible'),
array('fad fa-bicycle'=>'bicycle'),
array('fad fa-biking'=>'biking'),
array('fad fa-biking-mountain'=>'biking-mountain'),
array('fad fa-binoculars'=>'binoculars'),
array('fad fa-biohazard'=>'biohazard'),
array('fad fa-birthday-cake'=>'birthday-cake'),
array('fad fa-blanket'=>'blanket'),
array('fad fa-blender'=>'blender'),
array('fad fa-blender-phone'=>'blender-phone'),
array('fad fa-blind'=>'blind'),
array('fad fa-blinds'=>'blinds'),
array('fad fa-blinds-open'=>'blinds-open'),
array('fad fa-blinds-raised'=>'blinds-raised'),
array('fad fa-blog'=>'blog'),
array('fad fa-bold'=>'bold'),
array('fad fa-bolt'=>'bolt'),
array('fad fa-bomb'=>'bomb'),
array('fad fa-bone'=>'bone'),
array('fad fa-bone-break'=>'bone-break'),
array('fad fa-bong'=>'bong'),
array('fad fa-book'=>'book'),
array('fad fa-book-alt'=>'book-alt'),
array('fad fa-book-dead'=>'book-dead'),
array('fad fa-book-heart'=>'book-heart'),
array('fad fa-book-medical'=>'book-medical'),
array('fad fa-book-open'=>'book-open'),
array('fad fa-book-reader'=>'book-reader'),
array('fad fa-book-spells'=>'book-spells'),
array('fad fa-book-user'=>'book-user'),
array('fad fa-bookmark'=>'bookmark'),
array('fad fa-books'=>'books'),
array('fad fa-books-medical'=>'books-medical'),
array('fad fa-boombox'=>'boombox'),
array('fad fa-boot'=>'boot'),
array('fad fa-booth-curtain'=>'booth-curtain'),
array('fad fa-border-all'=>'border-all'),
array('fad fa-border-bottom'=>'border-bottom'),
array('fad fa-border-center-h'=>'border-center-h'),
array('fad fa-border-center-v'=>'border-center-v'),
array('fad fa-border-inner'=>'border-inner'),
array('fad fa-border-left'=>'border-left'),
array('fad fa-border-none'=>'border-none'),
array('fad fa-border-outer'=>'border-outer'),
array('fad fa-border-right'=>'border-right'),
array('fad fa-border-style'=>'border-style'),
array('fad fa-border-style-alt'=>'border-style-alt'),
array('fad fa-border-top'=>'border-top'),
array('fad fa-bow-arrow'=>'bow-arrow'),
array('fad fa-bowling-ball'=>'bowling-ball'),
array('fad fa-bowling-pins'=>'bowling-pins'),
array('fad fa-box'=>'box'),
array('fad fa-box-alt'=>'box-alt'),
array('fad fa-box-ballot'=>'box-ballot'),
array('fad fa-box-check'=>'box-check'),
array('fad fa-box-fragile'=>'box-fragile'),
array('fad fa-box-full'=>'box-full'),
array('fad fa-box-heart'=>'box-heart'),
array('fad fa-box-open'=>'box-open'),
array('fad fa-box-up'=>'box-up'),
array('fad fa-box-usd'=>'box-usd'),
array('fad fa-boxes'=>'boxes'),
array('fad fa-boxes-alt'=>'boxes-alt'),
array('fad fa-boxing-glove'=>'boxing-glove'),
array('fad fa-brackets'=>'brackets'),
array('fad fa-brackets-curly'=>'brackets-curly'),
array('fad fa-braille'=>'braille'),
array('fad fa-brain'=>'brain'),
array('fad fa-bread-loaf'=>'bread-loaf'),
array('fad fa-bread-slice'=>'bread-slice'),
array('fad fa-briefcase'=>'briefcase'),
array('fad fa-briefcase-medical'=>'briefcase-medical'),
array('fad fa-bring-forward'=>'bring-forward'),
array('fad fa-bring-front'=>'bring-front'),
array('fad fa-broadcast-tower'=>'broadcast-tower'),
array('fad fa-broom'=>'broom'),
array('fad fa-browser'=>'browser'),
array('fad fa-brush'=>'brush'),
array('fad fa-bug'=>'bug'),
array('fad fa-building'=>'building'),
array('fad fa-bullhorn'=>'bullhorn'),
array('fad fa-bullseye'=>'bullseye'),
array('fad fa-bullseye-arrow'=>'bullseye-arrow'),
array('fad fa-bullseye-pointer'=>'bullseye-pointer'),
array('fad fa-burger-soda'=>'burger-soda'),
array('fad fa-burn'=>'burn'),
array('fad fa-burrito'=>'burrito'),
array('fad fa-bus'=>'bus'),
array('fad fa-bus-alt'=>'bus-alt'),
array('fad fa-bus-school'=>'bus-school'),
array('fad fa-business-time'=>'business-time'),
array('fad fa-cabinet-filing'=>'cabinet-filing'),
array('fad fa-cactus'=>'cactus'),
array('fad fa-calculator'=>'calculator'),
array('fad fa-calculator-alt'=>'calculator-alt'),
array('fad fa-calendar'=>'calendar'),
array('fad fa-calendar-alt'=>'calendar-alt'),
array('fad fa-calendar-check'=>'calendar-check'),
array('fad fa-calendar-day'=>'calendar-day'),
array('fad fa-calendar-edit'=>'calendar-edit'),
array('fad fa-calendar-exclamation'=>'calendar-exclamation'),
array('fad fa-calendar-minus'=>'calendar-minus'),
array('fad fa-calendar-plus'=>'calendar-plus'),
array('fad fa-calendar-star'=>'calendar-star'),
array('fad fa-calendar-times'=>'calendar-times'),
array('fad fa-calendar-week'=>'calendar-week'),
array('fad fa-camcorder'=>'camcorder'),
array('fad fa-camera'=>'camera'),
array('fad fa-camera-alt'=>'camera-alt'),
array('fad fa-camera-home'=>'camera-home'),
array('fad fa-camera-movie'=>'camera-movie'),
array('fad fa-camera-polaroid'=>'camera-polaroid'),
array('fad fa-camera-retro'=>'camera-retro'),
array('fad fa-campfire'=>'campfire'),
array('fad fa-campground'=>'campground'),
array('fad fa-candle-holder'=>'candle-holder'),
array('fad fa-candy-cane'=>'candy-cane'),
array('fad fa-candy-corn'=>'candy-corn'),
array('fad fa-cannabis'=>'cannabis'),
array('fad fa-capsules'=>'capsules'),
array('fad fa-car'=>'car'),
array('fad fa-car-alt'=>'car-alt'),
array('fad fa-car-battery'=>'car-battery'),
array('fad fa-car-building'=>'car-building'),
array('fad fa-car-bump'=>'car-bump'),
array('fad fa-car-bus'=>'car-bus'),
array('fad fa-car-crash'=>'car-crash'),
array('fad fa-car-garage'=>'car-garage'),
array('fad fa-car-mechanic'=>'car-mechanic'),
array('fad fa-car-side'=>'car-side'),
array('fad fa-car-tilt'=>'car-tilt'),
array('fad fa-car-wash'=>'car-wash'),
array('fad fa-caravan'=>'caravan'),
array('fad fa-caravan-alt'=>'caravan-alt'),
array('fad fa-caret-circle-down'=>'caret-circle-down'),
array('fad fa-caret-circle-left'=>'caret-circle-left'),
array('fad fa-caret-circle-right'=>'caret-circle-right'),
array('fad fa-caret-circle-up'=>'caret-circle-up'),
array('fad fa-caret-down'=>'caret-down'),
array('fad fa-caret-left'=>'caret-left'),
array('fad fa-caret-right'=>'caret-right'),
array('fad fa-caret-square-down'=>'caret-square-down'),
array('fad fa-caret-square-left'=>'caret-square-left'),
array('fad fa-caret-square-right'=>'caret-square-right'),
array('fad fa-caret-square-up'=>'caret-square-up'),
array('fad fa-caret-up'=>'caret-up'),
array('fad fa-carrot'=>'carrot'),
array('fad fa-cars'=>'cars'),
array('fad fa-cart-arrow-down'=>'cart-arrow-down'),
array('fad fa-cart-plus'=>'cart-plus'),
array('fad fa-cash-register'=>'cash-register'),
array('fad fa-cassette-tape'=>'cassette-tape'),
array('fad fa-cat'=>'cat'),
array('fad fa-cat-space'=>'cat-space'),
array('fad fa-cauldron'=>'cauldron'),
array('fad fa-cctv'=>'cctv'),
array('fad fa-certificate'=>'certificate'),
array('fad fa-chair'=>'chair'),
array('fad fa-chair-office'=>'chair-office'),
array('fad fa-chalkboard'=>'chalkboard'),
array('fad fa-chalkboard-teacher'=>'chalkboard-teacher'),
array('fad fa-charging-station'=>'charging-station'),
array('fad fa-chart-area'=>'chart-area'),
array('fad fa-chart-bar'=>'chart-bar'),
array('fad fa-chart-line'=>'chart-line'),
array('fad fa-chart-line-down'=>'chart-line-down'),
array('fad fa-chart-network'=>'chart-network'),
array('fad fa-chart-pie'=>'chart-pie'),
array('fad fa-chart-pie-alt'=>'chart-pie-alt'),
array('fad fa-chart-scatter'=>'chart-scatter'),
array('fad fa-check'=>'check'),
array('fad fa-check-circle'=>'check-circle'),
array('fad fa-check-double'=>'check-double'),
array('fad fa-check-square'=>'check-square'),
array('fad fa-cheese'=>'cheese'),
array('fad fa-cheese-swiss'=>'cheese-swiss'),
array('fad fa-cheeseburger'=>'cheeseburger'),
array('fad fa-chess'=>'chess'),
array('fad fa-chess-bishop'=>'chess-bishop'),
array('fad fa-chess-bishop-alt'=>'chess-bishop-alt'),
array('fad fa-chess-board'=>'chess-board'),
array('fad fa-chess-clock'=>'chess-clock'),
array('fad fa-chess-clock-alt'=>'chess-clock-alt'),
array('fad fa-chess-king'=>'chess-king'),
array('fad fa-chess-king-alt'=>'chess-king-alt'),
array('fad fa-chess-knight'=>'chess-knight'),
array('fad fa-chess-knight-alt'=>'chess-knight-alt'),
array('fad fa-chess-pawn'=>'chess-pawn'),
array('fad fa-chess-pawn-alt'=>'chess-pawn-alt'),
array('fad fa-chess-queen'=>'chess-queen'),
array('fad fa-chess-queen-alt'=>'chess-queen-alt'),
array('fad fa-chess-rook'=>'chess-rook'),
array('fad fa-chess-rook-alt'=>'chess-rook-alt'),
array('fad fa-chevron-circle-down'=>'chevron-circle-down'),
array('fad fa-chevron-circle-left'=>'chevron-circle-left'),
array('fad fa-chevron-circle-right'=>'chevron-circle-right'),
array('fad fa-chevron-circle-up'=>'chevron-circle-up'),
array('fad fa-chevron-double-down'=>'chevron-double-down'),
array('fad fa-chevron-double-left'=>'chevron-double-left'),
array('fad fa-chevron-double-right'=>'chevron-double-right'),
array('fad fa-chevron-double-up'=>'chevron-double-up'),
array('fad fa-chevron-down'=>'chevron-down'),
array('fad fa-chevron-left'=>'chevron-left'),
array('fad fa-chevron-right'=>'chevron-right'),
array('fad fa-chevron-square-down'=>'chevron-square-down'),
array('fad fa-chevron-square-left'=>'chevron-square-left'),
array('fad fa-chevron-square-right'=>'chevron-square-right'),
array('fad fa-chevron-square-up'=>'chevron-square-up'),
array('fad fa-chevron-up'=>'chevron-up'),
array('fad fa-child'=>'child'),
array('fad fa-chimney'=>'chimney'),
array('fad fa-church'=>'church'),
array('fad fa-circle'=>'circle'),
array('fad fa-circle-notch'=>'circle-notch'),
array('fad fa-city'=>'city'),
array('fad fa-clarinet'=>'clarinet'),
array('fad fa-claw-marks'=>'claw-marks'),
array('fad fa-clinic-medical'=>'clinic-medical'),
array('fad fa-clipboard'=>'clipboard'),
array('fad fa-clipboard-check'=>'clipboard-check'),
array('fad fa-clipboard-list'=>'clipboard-list'),
array('fad fa-clipboard-list-check'=>'clipboard-list-check'),
array('fad fa-clipboard-prescription'=>'clipboard-prescription'),
array('fad fa-clipboard-user'=>'clipboard-user'),
array('fad fa-clock'=>'clock'),
array('fad fa-clone'=>'clone'),
array('fad fa-closed-captioning'=>'closed-captioning'),
array('fad fa-cloud'=>'cloud'),
array('fad fa-cloud-download'=>'cloud-download'),
array('fad fa-cloud-download-alt'=>'cloud-download-alt'),
array('fad fa-cloud-drizzle'=>'cloud-drizzle'),
array('fad fa-cloud-hail'=>'cloud-hail'),
array('fad fa-cloud-hail-mixed'=>'cloud-hail-mixed'),
array('fad fa-cloud-meatball'=>'cloud-meatball'),
array('fad fa-cloud-moon'=>'cloud-moon'),
array('fad fa-cloud-moon-rain'=>'cloud-moon-rain'),
array('fad fa-cloud-music'=>'cloud-music'),
array('fad fa-cloud-rain'=>'cloud-rain'),
array('fad fa-cloud-rainbow'=>'cloud-rainbow'),
array('fad fa-cloud-showers'=>'cloud-showers'),
array('fad fa-cloud-showers-heavy'=>'cloud-showers-heavy'),
array('fad fa-cloud-sleet'=>'cloud-sleet'),
array('fad fa-cloud-snow'=>'cloud-snow'),
array('fad fa-cloud-sun'=>'cloud-sun'),
array('fad fa-cloud-sun-rain'=>'cloud-sun-rain'),
array('fad fa-cloud-upload'=>'cloud-upload'),
array('fad fa-cloud-upload-alt'=>'cloud-upload-alt'),
array('fad fa-clouds'=>'clouds'),
array('fad fa-clouds-moon'=>'clouds-moon'),
array('fad fa-clouds-sun'=>'clouds-sun'),
array('fad fa-club'=>'club'),
array('fad fa-cocktail'=>'cocktail'),
array('fad fa-code'=>'code'),
array('fad fa-code-branch'=>'code-branch'),
array('fad fa-code-commit'=>'code-commit'),
array('fad fa-code-merge'=>'code-merge'),
array('fad fa-coffee'=>'coffee'),
array('fad fa-coffee-pot'=>'coffee-pot'),
array('fad fa-coffee-togo'=>'coffee-togo'),
array('fad fa-coffin'=>'coffin'),
array('fad fa-coffin-cross'=>'coffin-cross'),
array('fad fa-cog'=>'cog'),
array('fad fa-cogs'=>'cogs'),
array('fad fa-coin'=>'coin'),
array('fad fa-coins'=>'coins'),
array('fad fa-columns'=>'columns'),
array('fad fa-comet'=>'comet'),
array('fad fa-comment'=>'comment'),
array('fad fa-comment-alt'=>'comment-alt'),
array('fad fa-comment-alt-check'=>'comment-alt-check'),
array('fad fa-comment-alt-dollar'=>'comment-alt-dollar'),
array('fad fa-comment-alt-dots'=>'comment-alt-dots'),
array('fad fa-comment-alt-edit'=>'comment-alt-edit'),
array('fad fa-comment-alt-exclamation'=>'comment-alt-exclamation'),
array('fad fa-comment-alt-lines'=>'comment-alt-lines'),
array('fad fa-comment-alt-medical'=>'comment-alt-medical'),
array('fad fa-comment-alt-minus'=>'comment-alt-minus'),
array('fad fa-comment-alt-music'=>'comment-alt-music'),
array('fad fa-comment-alt-plus'=>'comment-alt-plus'),
array('fad fa-comment-alt-slash'=>'comment-alt-slash'),
array('fad fa-comment-alt-smile'=>'comment-alt-smile'),
array('fad fa-comment-alt-times'=>'comment-alt-times'),
array('fad fa-comment-check'=>'comment-check'),
array('fad fa-comment-dollar'=>'comment-dollar'),
array('fad fa-comment-dots'=>'comment-dots'),
array('fad fa-comment-edit'=>'comment-edit'),
array('fad fa-comment-exclamation'=>'comment-exclamation'),
array('fad fa-comment-lines'=>'comment-lines'),
array('fad fa-comment-medical'=>'comment-medical'),
array('fad fa-comment-minus'=>'comment-minus'),
array('fad fa-comment-music'=>'comment-music'),
array('fad fa-comment-plus'=>'comment-plus'),
array('fad fa-comment-slash'=>'comment-slash'),
array('fad fa-comment-smile'=>'comment-smile'),
array('fad fa-comment-times'=>'comment-times'),
array('fad fa-comments'=>'comments'),
array('fad fa-comments-alt'=>'comments-alt'),
array('fad fa-comments-alt-dollar'=>'comments-alt-dollar'),
array('fad fa-comments-dollar'=>'comments-dollar'),
array('fad fa-compact-disc'=>'compact-disc'),
array('fad fa-compass'=>'compass'),
array('fad fa-compass-slash'=>'compass-slash'),
array('fad fa-compress'=>'compress'),
array('fad fa-compress-alt'=>'compress-alt'),
array('fad fa-compress-arrows-alt'=>'compress-arrows-alt'),
array('fad fa-compress-wide'=>'compress-wide'),
array('fad fa-computer-classic'=>'computer-classic'),
array('fad fa-computer-speaker'=>'computer-speaker'),
array('fad fa-concierge-bell'=>'concierge-bell'),
array('fad fa-construction'=>'construction'),
array('fad fa-container-storage'=>'container-storage'),
array('fad fa-conveyor-belt'=>'conveyor-belt'),
array('fad fa-conveyor-belt-alt'=>'conveyor-belt-alt'),
array('fad fa-cookie'=>'cookie'),
array('fad fa-cookie-bite'=>'cookie-bite'),
array('fad fa-copy'=>'copy'),
array('fad fa-copyright'=>'copyright'),
array('fad fa-corn'=>'corn'),
array('fad fa-couch'=>'couch'),
array('fad fa-cow'=>'cow'),
array('fad fa-cowbell'=>'cowbell'),
array('fad fa-cowbell-more'=>'cowbell-more'),
array('fad fa-credit-card'=>'credit-card'),
array('fad fa-credit-card-blank'=>'credit-card-blank'),
array('fad fa-credit-card-front'=>'credit-card-front'),
array('fad fa-cricket'=>'cricket'),
array('fad fa-croissant'=>'croissant'),
array('fad fa-crop'=>'crop'),
array('fad fa-crop-alt'=>'crop-alt'),
array('fad fa-cross'=>'cross'),
array('fad fa-crosshairs'=>'crosshairs'),
array('fad fa-crow'=>'crow'),
array('fad fa-crown'=>'crown'),
array('fad fa-crutch'=>'crutch'),
array('fad fa-crutches'=>'crutches'),
array('fad fa-cube'=>'cube'),
array('fad fa-cubes'=>'cubes'),
array('fad fa-curling'=>'curling'),
array('fad fa-cut'=>'cut'),
array('fad fa-dagger'=>'dagger'),
array('fad fa-database'=>'database'),
array('fad fa-deaf'=>'deaf'),
array('fad fa-debug'=>'debug'),
array('fad fa-deer'=>'deer'),
array('fad fa-deer-rudolph'=>'deer-rudolph'),
array('fad fa-democrat'=>'democrat'),
array('fad fa-desktop'=>'desktop'),
array('fad fa-desktop-alt'=>'desktop-alt'),
array('fad fa-dewpoint'=>'dewpoint'),
array('fad fa-dharmachakra'=>'dharmachakra'),
array('fad fa-diagnoses'=>'diagnoses'),
array('fad fa-diamond'=>'diamond'),
array('fad fa-dice'=>'dice'),
array('fad fa-dice-d10'=>'dice-d10'),
array('fad fa-dice-d12'=>'dice-d12'),
array('fad fa-dice-d20'=>'dice-d20'),
array('fad fa-dice-d4'=>'dice-d4'),
array('fad fa-dice-d6'=>'dice-d6'),
array('fad fa-dice-d8'=>'dice-d8'),
array('fad fa-dice-five'=>'dice-five'),
array('fad fa-dice-four'=>'dice-four'),
array('fad fa-dice-one'=>'dice-one'),
array('fad fa-dice-six'=>'dice-six'),
array('fad fa-dice-three'=>'dice-three'),
array('fad fa-dice-two'=>'dice-two'),
array('fad fa-digging'=>'digging'),
array('fad fa-digital-tachograph'=>'digital-tachograph'),
array('fad fa-diploma'=>'diploma'),
array('fad fa-directions'=>'directions'),
array('fad fa-disc-drive'=>'disc-drive'),
array('fad fa-disease'=>'disease'),
array('fad fa-divide'=>'divide'),
array('fad fa-dizzy'=>'dizzy'),
array('fad fa-dna'=>'dna'),
array('fad fa-do-not-enter'=>'do-not-enter'),
array('fad fa-dog'=>'dog'),
array('fad fa-dog-leashed'=>'dog-leashed'),
array('fad fa-dollar-sign'=>'dollar-sign'),
array('fad fa-dolly'=>'dolly'),
array('fad fa-dolly-empty'=>'dolly-empty'),
array('fad fa-dolly-flatbed'=>'dolly-flatbed'),
array('fad fa-dolly-flatbed-alt'=>'dolly-flatbed-alt'),
array('fad fa-dolly-flatbed-empty'=>'dolly-flatbed-empty'),
array('fad fa-donate'=>'donate'),
array('fad fa-door-closed'=>'door-closed'),
array('fad fa-door-open'=>'door-open'),
array('fad fa-dot-circle'=>'dot-circle'),
array('fad fa-dove'=>'dove'),
array('fad fa-download'=>'download'),
array('fad fa-drafting-compass'=>'drafting-compass'),
array('fad fa-dragon'=>'dragon'),
array('fad fa-draw-circle'=>'draw-circle'),
array('fad fa-draw-polygon'=>'draw-polygon'),
array('fad fa-draw-square'=>'draw-square'),
array('fad fa-dreidel'=>'dreidel'),
array('fad fa-drone'=>'drone'),
array('fad fa-drone-alt'=>'drone-alt'),
array('fad fa-drum'=>'drum'),
array('fad fa-drum-steelpan'=>'drum-steelpan'),
array('fad fa-drumstick'=>'drumstick'),
array('fad fa-drumstick-bite'=>'drumstick-bite'),
array('fad fa-dryer'=>'dryer'),
array('fad fa-dryer-alt'=>'dryer-alt'),
array('fad fa-duck'=>'duck'),
array('fad fa-dumbbell'=>'dumbbell'),
array('fad fa-dumpster'=>'dumpster'),
array('fad fa-dumpster-fire'=>'dumpster-fire'),
array('fad fa-dungeon'=>'dungeon'),
array('fad fa-ear'=>'ear'),
array('fad fa-ear-muffs'=>'ear-muffs'),
array('fad fa-eclipse'=>'eclipse'),
array('fad fa-eclipse-alt'=>'eclipse-alt'),
array('fad fa-edit'=>'edit'),
array('fad fa-egg'=>'egg'),
array('fad fa-egg-fried'=>'egg-fried'),
array('fad fa-eject'=>'eject'),
array('fad fa-elephant'=>'elephant'),
array('fad fa-ellipsis-h'=>'ellipsis-h'),
array('fad fa-ellipsis-h-alt'=>'ellipsis-h-alt'),
array('fad fa-ellipsis-v'=>'ellipsis-v'),
array('fad fa-ellipsis-v-alt'=>'ellipsis-v-alt'),
array('fad fa-empty-set'=>'empty-set'),
array('fad fa-engine-warning'=>'engine-warning'),
array('fad fa-envelope'=>'envelope'),
array('fad fa-envelope-open'=>'envelope-open'),
array('fad fa-envelope-open-dollar'=>'envelope-open-dollar'),
array('fad fa-envelope-open-text'=>'envelope-open-text'),
array('fad fa-envelope-square'=>'envelope-square'),
array('fad fa-equals'=>'equals'),
array('fad fa-eraser'=>'eraser'),
array('fad fa-ethernet'=>'ethernet'),
array('fad fa-euro-sign'=>'euro-sign'),
array('fad fa-exchange'=>'exchange'),
array('fad fa-exchange-alt'=>'exchange-alt'),
array('fad fa-exclamation'=>'exclamation'),
array('fad fa-exclamation-circle'=>'exclamation-circle'),
array('fad fa-exclamation-square'=>'exclamation-square'),
array('fad fa-exclamation-triangle'=>'exclamation-triangle'),
array('fad fa-expand'=>'expand'),
array('fad fa-expand-alt'=>'expand-alt'),
array('fad fa-expand-arrows'=>'expand-arrows'),
array('fad fa-expand-arrows-alt'=>'expand-arrows-alt'),
array('fad fa-expand-wide'=>'expand-wide'),
array('fad fa-external-link'=>'external-link'),
array('fad fa-external-link-alt'=>'external-link-alt'),
array('fad fa-external-link-square'=>'external-link-square'),
array('fad fa-external-link-square-alt'=>'external-link-square-alt'),
array('fad fa-eye'=>'eye'),
array('fad fa-eye-dropper'=>'eye-dropper'),
array('fad fa-eye-evil'=>'eye-evil'),
array('fad fa-eye-slash'=>'eye-slash'),
array('fad fa-fan'=>'fan'),
array('fad fa-fan-table'=>'fan-table'),
array('fad fa-farm'=>'farm'),
array('fad fa-fast-backward'=>'fast-backward'),
array('fad fa-fast-forward'=>'fast-forward'),
array('fad fa-faucet'=>'faucet'),
array('fad fa-faucet-drip'=>'faucet-drip'),
array('fad fa-fax'=>'fax'),
array('fad fa-feather'=>'feather'),
array('fad fa-feather-alt'=>'feather-alt'),
array('fad fa-female'=>'female'),
array('fad fa-field-hockey'=>'field-hockey'),
array('fad fa-fighter-jet'=>'fighter-jet'),
array('fad fa-file'=>'file'),
array('fad fa-file-alt'=>'file-alt'),
array('fad fa-file-archive'=>'file-archive'),
array('fad fa-file-audio'=>'file-audio'),
array('fad fa-file-certificate'=>'file-certificate'),
array('fad fa-file-chart-line'=>'file-chart-line'),
array('fad fa-file-chart-pie'=>'file-chart-pie'),
array('fad fa-file-check'=>'file-check'),
array('fad fa-file-code'=>'file-code'),
array('fad fa-file-contract'=>'file-contract'),
array('fad fa-file-csv'=>'file-csv'),
array('fad fa-file-download'=>'file-download'),
array('fad fa-file-edit'=>'file-edit'),
array('fad fa-file-excel'=>'file-excel'),
array('fad fa-file-exclamation'=>'file-exclamation'),
array('fad fa-file-export'=>'file-export'),
array('fad fa-file-image'=>'file-image'),
array('fad fa-file-import'=>'file-import'),
array('fad fa-file-invoice'=>'file-invoice'),
array('fad fa-file-invoice-dollar'=>'file-invoice-dollar'),
array('fad fa-file-medical'=>'file-medical'),
array('fad fa-file-medical-alt'=>'file-medical-alt'),
array('fad fa-file-minus'=>'file-minus'),
array('fad fa-file-music'=>'file-music'),
array('fad fa-file-pdf'=>'file-pdf'),
array('fad fa-file-plus'=>'file-plus'),
array('fad fa-file-powerpoint'=>'file-powerpoint'),
array('fad fa-file-prescription'=>'file-prescription'),
array('fad fa-file-search'=>'file-search'),
array('fad fa-file-signature'=>'file-signature'),
array('fad fa-file-spreadsheet'=>'file-spreadsheet'),
array('fad fa-file-times'=>'file-times'),
array('fad fa-file-upload'=>'file-upload'),
array('fad fa-file-user'=>'file-user'),
array('fad fa-file-video'=>'file-video'),
array('fad fa-file-word'=>'file-word'),
array('fad fa-files-medical'=>'files-medical'),
array('fad fa-fill'=>'fill'),
array('fad fa-fill-drip'=>'fill-drip'),
array('fad fa-film'=>'film'),
array('fad fa-film-alt'=>'film-alt'),
array('fad fa-film-canister'=>'film-canister'),
array('fad fa-filter'=>'filter'),
array('fad fa-fingerprint'=>'fingerprint'),
array('fad fa-fire'=>'fire'),
array('fad fa-fire-alt'=>'fire-alt'),
array('fad fa-fire-extinguisher'=>'fire-extinguisher'),
array('fad fa-fire-smoke'=>'fire-smoke'),
array('fad fa-fireplace'=>'fireplace'),
array('fad fa-first-aid'=>'first-aid'),
array('fad fa-fish'=>'fish'),
array('fad fa-fish-cooked'=>'fish-cooked'),
array('fad fa-fist-raised'=>'fist-raised'),
array('fad fa-flag'=>'flag'),
array('fad fa-flag-alt'=>'flag-alt'),
array('fad fa-flag-checkered'=>'flag-checkered'),
array('fad fa-flag-usa'=>'flag-usa'),
array('fad fa-flame'=>'flame'),
array('fad fa-flashlight'=>'flashlight'),
array('fad fa-flask'=>'flask'),
array('fad fa-flask-poison'=>'flask-poison'),
array('fad fa-flask-potion'=>'flask-potion'),
array('fad fa-flower'=>'flower'),
array('fad fa-flower-daffodil'=>'flower-daffodil'),
array('fad fa-flower-tulip'=>'flower-tulip'),
array('fad fa-flushed'=>'flushed'),
array('fad fa-flute'=>'flute'),
array('fad fa-flux-capacitor'=>'flux-capacitor'),
array('fad fa-fog'=>'fog'),
array('fad fa-folder'=>'folder'),
array('fad fa-folder-download'=>'folder-download'),
array('fad fa-folder-minus'=>'folder-minus'),
array('fad fa-folder-open'=>'folder-open'),
array('fad fa-folder-plus'=>'folder-plus'),
array('fad fa-folder-times'=>'folder-times'),
array('fad fa-folder-tree'=>'folder-tree'),
array('fad fa-folder-upload'=>'folder-upload'),
array('fad fa-folders'=>'folders'),
array('fad fa-font'=>'font'),
array('fad fa-font-case'=>'font-case'),
array('fad fa-football-ball'=>'football-ball'),
array('fad fa-football-helmet'=>'football-helmet'),
array('fad fa-forklift'=>'forklift'),
array('fad fa-forward'=>'forward'),
array('fad fa-fragile'=>'fragile'),
array('fad fa-french-fries'=>'french-fries'),
array('fad fa-frog'=>'frog'),
array('fad fa-frosty-head'=>'frosty-head'),
array('fad fa-frown'=>'frown'),
array('fad fa-frown-open'=>'frown-open'),
array('fad fa-function'=>'function'),
array('fad fa-funnel-dollar'=>'funnel-dollar'),
array('fad fa-futbol'=>'futbol'),
array('fad fa-galaxy'=>'galaxy'),
array('fad fa-game-board'=>'game-board'),
array('fad fa-game-board-alt'=>'game-board-alt'),
array('fad fa-game-console-handheld'=>'game-console-handheld'),
array('fad fa-gamepad'=>'gamepad'),
array('fad fa-gamepad-alt'=>'gamepad-alt'),
array('fad fa-garage'=>'garage'),
array('fad fa-garage-car'=>'garage-car'),
array('fad fa-garage-open'=>'garage-open'),
array('fad fa-gas-pump'=>'gas-pump'),
array('fad fa-gas-pump-slash'=>'gas-pump-slash'),
array('fad fa-gavel'=>'gavel'),
array('fad fa-gem'=>'gem'),
array('fad fa-genderless'=>'genderless'),
array('fad fa-ghost'=>'ghost'),
array('fad fa-gift'=>'gift'),
array('fad fa-gift-card'=>'gift-card'),
array('fad fa-gifts'=>'gifts'),
array('fad fa-gingerbread-man'=>'gingerbread-man'),
array('fad fa-glass'=>'glass'),
array('fad fa-glass-champagne'=>'glass-champagne'),
array('fad fa-glass-cheers'=>'glass-cheers'),
array('fad fa-glass-citrus'=>'glass-citrus'),
array('fad fa-glass-martini'=>'glass-martini'),
array('fad fa-glass-martini-alt'=>'glass-martini-alt'),
array('fad fa-glass-whiskey'=>'glass-whiskey'),
array('fad fa-glass-whiskey-rocks'=>'glass-whiskey-rocks'),
array('fad fa-glasses'=>'glasses'),
array('fad fa-glasses-alt'=>'glasses-alt'),
array('fad fa-globe'=>'globe'),
array('fad fa-globe-africa'=>'globe-africa'),
array('fad fa-globe-americas'=>'globe-americas'),
array('fad fa-globe-asia'=>'globe-asia'),
array('fad fa-globe-europe'=>'globe-europe'),
array('fad fa-globe-snow'=>'globe-snow'),
array('fad fa-globe-stand'=>'globe-stand'),
array('fad fa-golf-ball'=>'golf-ball'),
array('fad fa-golf-club'=>'golf-club'),
array('fad fa-gopuram'=>'gopuram'),
array('fad fa-graduation-cap'=>'graduation-cap'),
array('fad fa-gramophone'=>'gramophone'),
array('fad fa-greater-than'=>'greater-than'),
array('fad fa-greater-than-equal'=>'greater-than-equal'),
array('fad fa-grimace'=>'grimace'),
array('fad fa-grin'=>'grin'),
array('fad fa-grin-alt'=>'grin-alt'),
array('fad fa-grin-beam'=>'grin-beam'),
array('fad fa-grin-beam-sweat'=>'grin-beam-sweat'),
array('fad fa-grin-hearts'=>'grin-hearts'),
array('fad fa-grin-squint'=>'grin-squint'),
array('fad fa-grin-squint-tears'=>'grin-squint-tears'),
array('fad fa-grin-stars'=>'grin-stars'),
array('fad fa-grin-tears'=>'grin-tears'),
array('fad fa-grin-tongue'=>'grin-tongue'),
array('fad fa-grin-tongue-squint'=>'grin-tongue-squint'),
array('fad fa-grin-tongue-wink'=>'grin-tongue-wink'),
array('fad fa-grin-wink'=>'grin-wink'),
array('fad fa-grip-horizontal'=>'grip-horizontal'),
array('fad fa-grip-lines'=>'grip-lines'),
array('fad fa-grip-lines-vertical'=>'grip-lines-vertical'),
array('fad fa-grip-vertical'=>'grip-vertical'),
array('fad fa-guitar'=>'guitar'),
array('fad fa-guitar-electric'=>'guitar-electric'),
array('fad fa-guitars'=>'guitars'),
array('fad fa-h-square'=>'h-square'),
array('fad fa-h1'=>'h1'),
array('fad fa-h2'=>'h2'),
array('fad fa-h3'=>'h3'),
array('fad fa-h4'=>'h4'),
array('fad fa-hamburger'=>'hamburger'),
array('fad fa-hammer'=>'hammer'),
array('fad fa-hammer-war'=>'hammer-war'),
array('fad fa-hamsa'=>'hamsa'),
array('fad fa-hand-heart'=>'hand-heart'),
array('fad fa-hand-holding'=>'hand-holding'),
array('fad fa-hand-holding-box'=>'hand-holding-box'),
array('fad fa-hand-holding-heart'=>'hand-holding-heart'),
array('fad fa-hand-holding-magic'=>'hand-holding-magic'),
array('fad fa-hand-holding-seedling'=>'hand-holding-seedling'),
array('fad fa-hand-holding-usd'=>'hand-holding-usd'),
array('fad fa-hand-holding-water'=>'hand-holding-water'),
array('fad fa-hand-lizard'=>'hand-lizard'),
array('fad fa-hand-middle-finger'=>'hand-middle-finger'),
array('fad fa-hand-paper'=>'hand-paper'),
array('fad fa-hand-peace'=>'hand-peace'),
array('fad fa-hand-point-down'=>'hand-point-down'),
array('fad fa-hand-point-left'=>'hand-point-left'),
array('fad fa-hand-point-right'=>'hand-point-right'),
array('fad fa-hand-point-up'=>'hand-point-up'),
array('fad fa-hand-pointer'=>'hand-pointer'),
array('fad fa-hand-receiving'=>'hand-receiving'),
array('fad fa-hand-rock'=>'hand-rock'),
array('fad fa-hand-scissors'=>'hand-scissors'),
array('fad fa-hand-spock'=>'hand-spock'),
array('fad fa-hands'=>'hands'),
array('fad fa-hands-heart'=>'hands-heart'),
array('fad fa-hands-helping'=>'hands-helping'),
array('fad fa-hands-usd'=>'hands-usd'),
array('fad fa-handshake'=>'handshake'),
array('fad fa-handshake-alt'=>'handshake-alt'),
array('fad fa-hanukiah'=>'hanukiah'),
array('fad fa-hard-hat'=>'hard-hat'),
array('fad fa-hashtag'=>'hashtag'),
array('fad fa-hat-chef'=>'hat-chef'),
array('fad fa-hat-cowboy'=>'hat-cowboy'),
array('fad fa-hat-cowboy-side'=>'hat-cowboy-side'),
array('fad fa-hat-santa'=>'hat-santa'),
array('fad fa-hat-winter'=>'hat-winter'),
array('fad fa-hat-witch'=>'hat-witch'),
array('fad fa-hat-wizard'=>'hat-wizard'),
array('fad fa-hdd'=>'hdd'),
array('fad fa-head-side'=>'head-side'),
array('fad fa-head-side-brain'=>'head-side-brain'),
array('fad fa-head-side-headphones'=>'head-side-headphones'),
array('fad fa-head-side-medical'=>'head-side-medical'),
array('fad fa-head-vr'=>'head-vr'),
array('fad fa-heading'=>'heading'),
array('fad fa-headphones'=>'headphones'),
array('fad fa-headphones-alt'=>'headphones-alt'),
array('fad fa-headset'=>'headset'),
array('fad fa-heart'=>'heart'),
array('fad fa-heart-broken'=>'heart-broken'),
array('fad fa-heart-circle'=>'heart-circle'),
array('fad fa-heart-rate'=>'heart-rate'),
array('fad fa-heart-square'=>'heart-square'),
array('fad fa-heartbeat'=>'heartbeat'),
array('fad fa-heat'=>'heat'),
array('fad fa-helicopter'=>'helicopter'),
array('fad fa-helmet-battle'=>'helmet-battle'),
array('fad fa-hexagon'=>'hexagon'),
array('fad fa-highlighter'=>'highlighter'),
array('fad fa-hiking'=>'hiking'),
array('fad fa-hippo'=>'hippo'),
array('fad fa-history'=>'history'),
array('fad fa-hockey-mask'=>'hockey-mask'),
array('fad fa-hockey-puck'=>'hockey-puck'),
array('fad fa-hockey-sticks'=>'hockey-sticks'),
array('fad fa-holly-berry'=>'holly-berry'),
array('fad fa-home'=>'home'),
array('fad fa-home-alt'=>'home-alt'),
array('fad fa-home-heart'=>'home-heart'),
array('fad fa-home-lg'=>'home-lg'),
array('fad fa-home-lg-alt'=>'home-lg-alt'),
array('fad fa-hood-cloak'=>'hood-cloak'),
array('fad fa-horizontal-rule'=>'horizontal-rule'),
array('fad fa-horse'=>'horse'),
array('fad fa-horse-head'=>'horse-head'),
array('fad fa-horse-saddle'=>'horse-saddle'),
array('fad fa-hospital'=>'hospital'),
array('fad fa-hospital-alt'=>'hospital-alt'),
array('fad fa-hospital-symbol'=>'hospital-symbol'),
array('fad fa-hospital-user'=>'hospital-user'),
array('fad fa-hospitals'=>'hospitals'),
array('fad fa-hot-tub'=>'hot-tub'),
array('fad fa-hotdog'=>'hotdog'),
array('fad fa-hotel'=>'hotel'),
array('fad fa-hourglass'=>'hourglass'),
array('fad fa-hourglass-end'=>'hourglass-end'),
array('fad fa-hourglass-half'=>'hourglass-half'),
array('fad fa-hourglass-start'=>'hourglass-start'),
array('fad fa-house'=>'house'),
array('fad fa-house-damage'=>'house-damage'),
array('fad fa-house-day'=>'house-day'),
array('fad fa-house-flood'=>'house-flood'),
array('fad fa-house-leave'=>'house-leave'),
array('fad fa-house-night'=>'house-night'),
array('fad fa-house-return'=>'house-return'),
array('fad fa-house-signal'=>'house-signal'),
array('fad fa-hryvnia'=>'hryvnia'),
array('fad fa-humidity'=>'humidity'),
array('fad fa-hurricane'=>'hurricane'),
array('fad fa-i-cursor'=>'i-cursor'),
array('fad fa-ice-cream'=>'ice-cream'),
array('fad fa-ice-skate'=>'ice-skate'),
array('fad fa-icicles'=>'icicles'),
array('fad fa-icons'=>'icons'),
array('fad fa-icons-alt'=>'icons-alt'),
array('fad fa-id-badge'=>'id-badge'),
array('fad fa-id-card'=>'id-card'),
array('fad fa-id-card-alt'=>'id-card-alt'),
array('fad fa-igloo'=>'igloo'),
array('fad fa-image'=>'image'),
array('fad fa-image-polaroid'=>'image-polaroid'),
array('fad fa-images'=>'images'),
array('fad fa-inbox'=>'inbox'),
array('fad fa-inbox-in'=>'inbox-in'),
array('fad fa-inbox-out'=>'inbox-out'),
array('fad fa-indent'=>'indent'),
array('fad fa-industry'=>'industry'),
array('fad fa-industry-alt'=>'industry-alt'),
array('fad fa-infinity'=>'infinity'),
array('fad fa-info'=>'info'),
array('fad fa-info-circle'=>'info-circle'),
array('fad fa-info-square'=>'info-square'),
array('fad fa-inhaler'=>'inhaler'),
array('fad fa-integral'=>'integral'),
array('fad fa-intersection'=>'intersection'),
array('fad fa-inventory'=>'inventory'),
array('fad fa-island-tropical'=>'island-tropical'),
array('fad fa-italic'=>'italic'),
array('fad fa-jack-o-lantern'=>'jack-o-lantern'),
array('fad fa-jedi'=>'jedi'),
array('fad fa-joint'=>'joint'),
array('fad fa-journal-whills'=>'journal-whills'),
array('fad fa-joystick'=>'joystick'),
array('fad fa-jug'=>'jug'),
array('fad fa-kaaba'=>'kaaba'),
array('fad fa-kazoo'=>'kazoo'),
array('fad fa-kerning'=>'kerning'),
array('fad fa-key'=>'key'),
array('fad fa-key-skeleton'=>'key-skeleton'),
array('fad fa-keyboard'=>'keyboard'),
array('fad fa-keynote'=>'keynote'),
array('fad fa-khanda'=>'khanda'),
array('fad fa-kidneys'=>'kidneys'),
array('fad fa-kiss'=>'kiss'),
array('fad fa-kiss-beam'=>'kiss-beam'),
array('fad fa-kiss-wink-heart'=>'kiss-wink-heart'),
array('fad fa-kite'=>'kite'),
array('fad fa-kiwi-bird'=>'kiwi-bird'),
array('fad fa-knife-kitchen'=>'knife-kitchen'),
array('fad fa-lambda'=>'lambda'),
array('fad fa-lamp'=>'lamp'),
array('fad fa-lamp-desk'=>'lamp-desk'),
array('fad fa-lamp-floor'=>'lamp-floor'),
array('fad fa-landmark'=>'landmark'),
array('fad fa-landmark-alt'=>'landmark-alt'),
array('fad fa-language'=>'language'),
array('fad fa-laptop'=>'laptop'),
array('fad fa-laptop-code'=>'laptop-code'),
array('fad fa-laptop-medical'=>'laptop-medical'),
array('fad fa-lasso'=>'lasso'),
array('fad fa-laugh'=>'laugh'),
array('fad fa-laugh-beam'=>'laugh-beam'),
array('fad fa-laugh-squint'=>'laugh-squint'),
array('fad fa-laugh-wink'=>'laugh-wink'),
array('fad fa-layer-group'=>'layer-group'),
array('fad fa-layer-minus'=>'layer-minus'),
array('fad fa-layer-plus'=>'layer-plus'),
array('fad fa-leaf'=>'leaf'),
array('fad fa-leaf-heart'=>'leaf-heart'),
array('fad fa-leaf-maple'=>'leaf-maple'),
array('fad fa-leaf-oak'=>'leaf-oak'),
array('fad fa-lemon'=>'lemon'),
array('fad fa-less-than'=>'less-than'),
array('fad fa-less-than-equal'=>'less-than-equal'),
array('fad fa-level-down'=>'level-down'),
array('fad fa-level-down-alt'=>'level-down-alt'),
array('fad fa-level-up'=>'level-up'),
array('fad fa-level-up-alt'=>'level-up-alt'),
array('fad fa-life-ring'=>'life-ring'),
array('fad fa-light-ceiling'=>'light-ceiling'),
array('fad fa-light-switch'=>'light-switch'),
array('fad fa-light-switch-off'=>'light-switch-off'),
array('fad fa-light-switch-on'=>'light-switch-on'),
array('fad fa-lightbulb'=>'lightbulb'),
array('fad fa-lightbulb-dollar'=>'lightbulb-dollar'),
array('fad fa-lightbulb-exclamation'=>'lightbulb-exclamation'),
array('fad fa-lightbulb-on'=>'lightbulb-on'),
array('fad fa-lightbulb-slash'=>'lightbulb-slash'),
array('fad fa-lights-holiday'=>'lights-holiday'),
array('fad fa-line-columns'=>'line-columns'),
array('fad fa-line-height'=>'line-height'),
array('fad fa-link'=>'link'),
array('fad fa-lips'=>'lips'),
array('fad fa-lira-sign'=>'lira-sign'),
array('fad fa-list'=>'list'),
array('fad fa-list-alt'=>'list-alt'),
array('fad fa-list-music'=>'list-music'),
array('fad fa-list-ol'=>'list-ol'),
array('fad fa-list-ul'=>'list-ul'),
array('fad fa-location'=>'location'),
array('fad fa-location-arrow'=>'location-arrow'),
array('fad fa-location-circle'=>'location-circle'),
array('fad fa-location-slash'=>'location-slash'),
array('fad fa-lock'=>'lock'),
array('fad fa-lock-alt'=>'lock-alt'),
array('fad fa-lock-open'=>'lock-open'),
array('fad fa-lock-open-alt'=>'lock-open-alt'),
array('fad fa-long-arrow-alt-down'=>'long-arrow-alt-down'),
array('fad fa-long-arrow-alt-left'=>'long-arrow-alt-left'),
array('fad fa-long-arrow-alt-right'=>'long-arrow-alt-right'),
array('fad fa-long-arrow-alt-up'=>'long-arrow-alt-up'),
array('fad fa-long-arrow-down'=>'long-arrow-down'),
array('fad fa-long-arrow-left'=>'long-arrow-left'),
array('fad fa-long-arrow-right'=>'long-arrow-right'),
array('fad fa-long-arrow-up'=>'long-arrow-up'),
array('fad fa-loveseat'=>'loveseat'),
array('fad fa-low-vision'=>'low-vision'),
array('fad fa-luchador'=>'luchador'),
array('fad fa-luggage-cart'=>'luggage-cart'),
array('fad fa-lungs'=>'lungs'),
array('fad fa-mace'=>'mace'),
array('fad fa-magic'=>'magic'),
array('fad fa-magnet'=>'magnet'),
array('fad fa-mail-bulk'=>'mail-bulk'),
array('fad fa-mailbox'=>'mailbox'),
array('fad fa-male'=>'male'),
array('fad fa-mandolin'=>'mandolin'),
array('fad fa-map'=>'map'),
array('fad fa-map-marked'=>'map-marked'),
array('fad fa-map-marked-alt'=>'map-marked-alt'),
array('fad fa-map-marker'=>'map-marker'),
array('fad fa-map-marker-alt'=>'map-marker-alt'),
array('fad fa-map-marker-alt-slash'=>'map-marker-alt-slash'),
array('fad fa-map-marker-check'=>'map-marker-check'),
array('fad fa-map-marker-edit'=>'map-marker-edit'),
array('fad fa-map-marker-exclamation'=>'map-marker-exclamation'),
array('fad fa-map-marker-minus'=>'map-marker-minus'),
array('fad fa-map-marker-plus'=>'map-marker-plus'),
array('fad fa-map-marker-question'=>'map-marker-question'),
array('fad fa-map-marker-slash'=>'map-marker-slash'),
array('fad fa-map-marker-smile'=>'map-marker-smile'),
array('fad fa-map-marker-times'=>'map-marker-times'),
array('fad fa-map-pin'=>'map-pin'),
array('fad fa-map-signs'=>'map-signs'),
array('fad fa-marker'=>'marker'),
array('fad fa-mars'=>'mars'),
array('fad fa-mars-double'=>'mars-double'),
array('fad fa-mars-stroke'=>'mars-stroke'),
array('fad fa-mars-stroke-h'=>'mars-stroke-h'),
array('fad fa-mars-stroke-v'=>'mars-stroke-v'),
array('fad fa-mask'=>'mask'),
array('fad fa-meat'=>'meat'),
array('fad fa-medal'=>'medal'),
array('fad fa-medkit'=>'medkit'),
array('fad fa-megaphone'=>'megaphone'),
array('fad fa-meh'=>'meh'),
array('fad fa-meh-blank'=>'meh-blank'),
array('fad fa-meh-rolling-eyes'=>'meh-rolling-eyes'),
array('fad fa-memory'=>'memory'),
array('fad fa-menorah'=>'menorah'),
array('fad fa-mercury'=>'mercury'),
array('fad fa-meteor'=>'meteor'),
array('fad fa-microchip'=>'microchip'),
array('fad fa-microphone'=>'microphone'),
array('fad fa-microphone-alt'=>'microphone-alt'),
array('fad fa-microphone-alt-slash'=>'microphone-alt-slash'),
array('fad fa-microphone-slash'=>'microphone-slash'),
array('fad fa-microphone-stand'=>'microphone-stand'),
array('fad fa-microscope'=>'microscope'),
array('fad fa-microwave'=>'microwave'),
array('fad fa-mind-share'=>'mind-share'),
array('fad fa-minus'=>'minus'),
array('fad fa-minus-circle'=>'minus-circle'),
array('fad fa-minus-hexagon'=>'minus-hexagon'),
array('fad fa-minus-octagon'=>'minus-octagon'),
array('fad fa-minus-square'=>'minus-square'),
array('fad fa-mistletoe'=>'mistletoe'),
array('fad fa-mitten'=>'mitten'),
array('fad fa-mobile'=>'mobile'),
array('fad fa-mobile-alt'=>'mobile-alt'),
array('fad fa-mobile-android'=>'mobile-android'),
array('fad fa-mobile-android-alt'=>'mobile-android-alt'),
array('fad fa-money-bill'=>'money-bill'),
array('fad fa-money-bill-alt'=>'money-bill-alt'),
array('fad fa-money-bill-wave'=>'money-bill-wave'),
array('fad fa-money-bill-wave-alt'=>'money-bill-wave-alt'),
array('fad fa-money-check'=>'money-check'),
array('fad fa-money-check-alt'=>'money-check-alt'),
array('fad fa-money-check-edit'=>'money-check-edit'),
array('fad fa-money-check-edit-alt'=>'money-check-edit-alt'),
array('fad fa-monitor-heart-rate'=>'monitor-heart-rate'),
array('fad fa-monkey'=>'monkey'),
array('fad fa-monument'=>'monument'),
array('fad fa-moon'=>'moon'),
array('fad fa-moon-cloud'=>'moon-cloud'),
array('fad fa-moon-stars'=>'moon-stars'),
array('fad fa-mortar-pestle'=>'mortar-pestle'),
array('fad fa-mosque'=>'mosque'),
array('fad fa-motorcycle'=>'motorcycle'),
array('fad fa-mountain'=>'mountain'),
array('fad fa-mountains'=>'mountains'),
array('fad fa-mouse'=>'mouse'),
array('fad fa-mouse-alt'=>'mouse-alt'),
array('fad fa-mouse-pointer'=>'mouse-pointer'),
array('fad fa-mp3-player'=>'mp3-player'),
array('fad fa-mug'=>'mug'),
array('fad fa-mug-hot'=>'mug-hot'),
array('fad fa-mug-marshmallows'=>'mug-marshmallows'),
array('fad fa-mug-tea'=>'mug-tea'),
array('fad fa-music'=>'music'),
array('fad fa-music-alt'=>'music-alt'),
array('fad fa-music-alt-slash'=>'music-alt-slash'),
array('fad fa-music-slash'=>'music-slash'),
array('fad fa-narwhal'=>'narwhal'),
array('fad fa-network-wired'=>'network-wired'),
array('fad fa-neuter'=>'neuter'),
array('fad fa-newspaper'=>'newspaper'),
array('fad fa-not-equal'=>'not-equal'),
array('fad fa-notes-medical'=>'notes-medical'),
array('fad fa-object-group'=>'object-group'),
array('fad fa-object-ungroup'=>'object-ungroup'),
array('fad fa-octagon'=>'octagon'),
array('fad fa-oil-can'=>'oil-can'),
array('fad fa-oil-temp'=>'oil-temp'),
array('fad fa-om'=>'om'),
array('fad fa-omega'=>'omega'),
array('fad fa-ornament'=>'ornament'),
array('fad fa-otter'=>'otter'),
array('fad fa-outdent'=>'outdent'),
array('fad fa-outlet'=>'outlet'),
array('fad fa-oven'=>'oven'),
array('fad fa-overline'=>'overline'),
array('fad fa-page-break'=>'page-break'),
array('fad fa-pager'=>'pager'),
array('fad fa-paint-brush'=>'paint-brush'),
array('fad fa-paint-brush-alt'=>'paint-brush-alt'),
array('fad fa-paint-roller'=>'paint-roller'),
array('fad fa-palette'=>'palette'),
array('fad fa-pallet'=>'pallet'),
array('fad fa-pallet-alt'=>'pallet-alt'),
array('fad fa-paper-plane'=>'paper-plane'),
array('fad fa-paperclip'=>'paperclip'),
array('fad fa-parachute-box'=>'parachute-box'),
array('fad fa-paragraph'=>'paragraph'),
array('fad fa-paragraph-rtl'=>'paragraph-rtl'),
array('fad fa-parking'=>'parking'),
array('fad fa-parking-circle'=>'parking-circle'),
array('fad fa-parking-circle-slash'=>'parking-circle-slash'),
array('fad fa-parking-slash'=>'parking-slash'),
array('fad fa-passport'=>'passport'),
array('fad fa-pastafarianism'=>'pastafarianism'),
array('fad fa-paste'=>'paste'),
array('fad fa-pause'=>'pause'),
array('fad fa-pause-circle'=>'pause-circle'),
array('fad fa-paw'=>'paw'),
array('fad fa-paw-alt'=>'paw-alt'),
array('fad fa-paw-claws'=>'paw-claws'),
array('fad fa-peace'=>'peace'),
array('fad fa-pegasus'=>'pegasus'),
array('fad fa-pen'=>'pen'),
array('fad fa-pen-alt'=>'pen-alt'),
array('fad fa-pen-fancy'=>'pen-fancy'),
array('fad fa-pen-nib'=>'pen-nib'),
array('fad fa-pen-square'=>'pen-square'),
array('fad fa-pencil'=>'pencil'),
array('fad fa-pencil-alt'=>'pencil-alt'),
array('fad fa-pencil-paintbrush'=>'pencil-paintbrush'),
array('fad fa-pencil-ruler'=>'pencil-ruler'),
array('fad fa-pennant'=>'pennant'),
array('fad fa-people-carry'=>'people-carry'),
array('fad fa-pepper-hot'=>'pepper-hot'),
array('fad fa-percent'=>'percent'),
array('fad fa-percentage'=>'percentage'),
array('fad fa-person-booth'=>'person-booth'),
array('fad fa-person-carry'=>'person-carry'),
array('fad fa-person-dolly'=>'person-dolly'),
array('fad fa-person-dolly-empty'=>'person-dolly-empty'),
array('fad fa-person-sign'=>'person-sign'),
array('fad fa-phone'=>'phone'),
array('fad fa-phone-alt'=>'phone-alt'),
array('fad fa-phone-laptop'=>'phone-laptop'),
array('fad fa-phone-office'=>'phone-office'),
array('fad fa-phone-plus'=>'phone-plus'),
array('fad fa-phone-rotary'=>'phone-rotary'),
array('fad fa-phone-slash'=>'phone-slash'),
array('fad fa-phone-square'=>'phone-square'),
array('fad fa-phone-square-alt'=>'phone-square-alt'),
array('fad fa-phone-volume'=>'phone-volume'),
array('fad fa-photo-video'=>'photo-video'),
array('fad fa-pi'=>'pi'),
array('fad fa-piano'=>'piano'),
array('fad fa-piano-keyboard'=>'piano-keyboard'),
array('fad fa-pie'=>'pie'),
array('fad fa-pig'=>'pig'),
array('fad fa-piggy-bank'=>'piggy-bank'),
array('fad fa-pills'=>'pills'),
array('fad fa-pizza'=>'pizza'),
array('fad fa-pizza-slice'=>'pizza-slice'),
array('fad fa-place-of-worship'=>'place-of-worship'),
array('fad fa-plane'=>'plane'),
array('fad fa-plane-alt'=>'plane-alt'),
array('fad fa-plane-arrival'=>'plane-arrival'),
array('fad fa-plane-departure'=>'plane-departure'),
array('fad fa-planet-moon'=>'planet-moon'),
array('fad fa-planet-ringed'=>'planet-ringed'),
array('fad fa-play'=>'play'),
array('fad fa-play-circle'=>'play-circle'),
array('fad fa-plug'=>'plug'),
array('fad fa-plus'=>'plus'),
array('fad fa-plus-circle'=>'plus-circle'),
array('fad fa-plus-hexagon'=>'plus-hexagon'),
array('fad fa-plus-octagon'=>'plus-octagon'),
array('fad fa-plus-square'=>'plus-square'),
array('fad fa-podcast'=>'podcast'),
array('fad fa-podium'=>'podium'),
array('fad fa-podium-star'=>'podium-star'),
array('fad fa-police-box'=>'police-box'),
array('fad fa-poll'=>'poll'),
array('fad fa-poll-h'=>'poll-h'),
array('fad fa-poll-people'=>'poll-people'),
array('fad fa-poo'=>'poo'),
array('fad fa-poo-storm'=>'poo-storm'),
array('fad fa-poop'=>'poop'),
array('fad fa-popcorn'=>'popcorn'),
array('fad fa-portal-enter'=>'portal-enter'),
array('fad fa-portal-exit'=>'portal-exit'),
array('fad fa-portrait'=>'portrait'),
array('fad fa-pound-sign'=>'pound-sign'),
array('fad fa-power-off'=>'power-off'),
array('fad fa-pray'=>'pray'),
array('fad fa-praying-hands'=>'praying-hands'),
array('fad fa-prescription'=>'prescription'),
array('fad fa-prescription-bottle'=>'prescription-bottle'),
array('fad fa-prescription-bottle-alt'=>'prescription-bottle-alt'),
array('fad fa-presentation'=>'presentation'),
array('fad fa-print'=>'print'),
array('fad fa-print-search'=>'print-search'),
array('fad fa-print-slash'=>'print-slash'),
array('fad fa-procedures'=>'procedures'),
array('fad fa-project-diagram'=>'project-diagram'),
array('fad fa-projector'=>'projector'),
array('fad fa-pumpkin'=>'pumpkin'),
array('fad fa-puzzle-piece'=>'puzzle-piece'),
array('fad fa-qrcode'=>'qrcode'),
array('fad fa-question'=>'question'),
array('fad fa-question-circle'=>'question-circle'),
array('fad fa-question-square'=>'question-square'),
array('fad fa-quidditch'=>'quidditch'),
array('fad fa-quote-left'=>'quote-left'),
array('fad fa-quote-right'=>'quote-right'),
array('fad fa-quran'=>'quran'),
array('fad fa-rabbit'=>'rabbit'),
array('fad fa-rabbit-fast'=>'rabbit-fast'),
array('fad fa-racquet'=>'racquet'),
array('fad fa-radar'=>'radar'),
array('fad fa-radiation'=>'radiation'),
array('fad fa-radiation-alt'=>'radiation-alt'),
array('fad fa-radio'=>'radio'),
array('fad fa-radio-alt'=>'radio-alt'),
array('fad fa-rainbow'=>'rainbow'),
array('fad fa-raindrops'=>'raindrops'),
array('fad fa-ram'=>'ram'),
array('fad fa-ramp-loading'=>'ramp-loading'),
array('fad fa-random'=>'random'),
array('fad fa-raygun'=>'raygun'),
array('fad fa-receipt'=>'receipt'),
array('fad fa-record-vinyl'=>'record-vinyl'),
array('fad fa-rectangle-landscape'=>'rectangle-landscape'),
array('fad fa-rectangle-portrait'=>'rectangle-portrait'),
array('fad fa-rectangle-wide'=>'rectangle-wide'),
array('fad fa-recycle'=>'recycle'),
array('fad fa-redo'=>'redo'),
array('fad fa-redo-alt'=>'redo-alt'),
array('fad fa-refrigerator'=>'refrigerator'),
array('fad fa-registered'=>'registered'),
array('fad fa-remove-format'=>'remove-format'),
array('fad fa-repeat'=>'repeat'),
array('fad fa-repeat-1'=>'repeat-1'),
array('fad fa-repeat-1-alt'=>'repeat-1-alt'),
array('fad fa-repeat-alt'=>'repeat-alt'),
array('fad fa-reply'=>'reply'),
array('fad fa-reply-all'=>'reply-all'),
array('fad fa-republican'=>'republican'),
array('fad fa-restroom'=>'restroom'),
array('fad fa-retweet'=>'retweet'),
array('fad fa-retweet-alt'=>'retweet-alt'),
array('fad fa-ribbon'=>'ribbon'),
array('fad fa-ring'=>'ring'),
array('fad fa-rings-wedding'=>'rings-wedding'),
array('fad fa-road'=>'road'),
array('fad fa-robot'=>'robot'),
array('fad fa-rocket'=>'rocket'),
array('fad fa-rocket-launch'=>'rocket-launch'),
array('fad fa-route'=>'route'),
array('fad fa-route-highway'=>'route-highway'),
array('fad fa-route-interstate'=>'route-interstate'),
array('fad fa-router'=>'router'),
array('fad fa-rss'=>'rss'),
array('fad fa-rss-square'=>'rss-square'),
array('fad fa-ruble-sign'=>'ruble-sign'),
array('fad fa-ruler'=>'ruler'),
array('fad fa-ruler-combined'=>'ruler-combined'),
array('fad fa-ruler-horizontal'=>'ruler-horizontal'),
array('fad fa-ruler-triangle'=>'ruler-triangle'),
array('fad fa-ruler-vertical'=>'ruler-vertical'),
array('fad fa-running'=>'running'),
array('fad fa-rupee-sign'=>'rupee-sign'),
array('fad fa-rv'=>'rv'),
array('fad fa-sack'=>'sack'),
array('fad fa-sack-dollar'=>'sack-dollar'),
array('fad fa-sad-cry'=>'sad-cry'),
array('fad fa-sad-tear'=>'sad-tear'),
array('fad fa-salad'=>'salad'),
array('fad fa-sandwich'=>'sandwich'),
array('fad fa-satellite'=>'satellite'),
array('fad fa-satellite-dish'=>'satellite-dish'),
array('fad fa-sausage'=>'sausage'),
array('fad fa-save'=>'save'),
array('fad fa-sax-hot'=>'sax-hot'),
array('fad fa-saxophone'=>'saxophone'),
array('fad fa-scalpel'=>'scalpel'),
array('fad fa-scalpel-path'=>'scalpel-path'),
array('fad fa-scanner'=>'scanner'),
array('fad fa-scanner-image'=>'scanner-image'),
array('fad fa-scanner-keyboard'=>'scanner-keyboard'),
array('fad fa-scanner-touchscreen'=>'scanner-touchscreen'),
array('fad fa-scarecrow'=>'scarecrow'),
array('fad fa-scarf'=>'scarf'),
array('fad fa-school'=>'school'),
array('fad fa-screwdriver'=>'screwdriver'),
array('fad fa-scroll'=>'scroll'),
array('fad fa-scroll-old'=>'scroll-old'),
array('fad fa-scrubber'=>'scrubber'),
array('fad fa-scythe'=>'scythe'),
array('fad fa-sd-card'=>'sd-card'),
array('fad fa-search'=>'search'),
array('fad fa-search-dollar'=>'search-dollar'),
array('fad fa-search-location'=>'search-location'),
array('fad fa-search-minus'=>'search-minus'),
array('fad fa-search-plus'=>'search-plus'),
array('fad fa-seedling'=>'seedling'),
array('fad fa-send-back'=>'send-back'),
array('fad fa-send-backward'=>'send-backward'),
array('fad fa-sensor'=>'sensor'),
array('fad fa-sensor-alert'=>'sensor-alert'),
array('fad fa-sensor-fire'=>'sensor-fire'),
array('fad fa-sensor-on'=>'sensor-on'),
array('fad fa-sensor-smoke'=>'sensor-smoke'),
array('fad fa-server'=>'server'),
array('fad fa-shapes'=>'shapes'),
array('fad fa-share'=>'share'),
array('fad fa-share-all'=>'share-all'),
array('fad fa-share-alt'=>'share-alt'),
array('fad fa-share-alt-square'=>'share-alt-square'),
array('fad fa-share-square'=>'share-square'),
array('fad fa-sheep'=>'sheep'),
array('fad fa-shekel-sign'=>'shekel-sign'),
array('fad fa-shield'=>'shield'),
array('fad fa-shield-alt'=>'shield-alt'),
array('fad fa-shield-check'=>'shield-check'),
array('fad fa-shield-cross'=>'shield-cross'),
array('fad fa-ship'=>'ship'),
array('fad fa-shipping-fast'=>'shipping-fast'),
array('fad fa-shipping-timed'=>'shipping-timed'),
array('fad fa-shish-kebab'=>'shish-kebab'),
array('fad fa-shoe-prints'=>'shoe-prints'),
array('fad fa-shopping-bag'=>'shopping-bag'),
array('fad fa-shopping-basket'=>'shopping-basket'),
array('fad fa-shopping-cart'=>'shopping-cart'),
array('fad fa-shovel'=>'shovel'),
array('fad fa-shovel-snow'=>'shovel-snow'),
array('fad fa-shower'=>'shower'),
array('fad fa-shredder'=>'shredder'),
array('fad fa-shuttle-van'=>'shuttle-van'),
array('fad fa-shuttlecock'=>'shuttlecock'),
array('fad fa-sickle'=>'sickle'),
array('fad fa-sigma'=>'sigma'),
array('fad fa-sign'=>'sign'),
array('fad fa-sign-in'=>'sign-in'),
array('fad fa-sign-in-alt'=>'sign-in-alt'),
array('fad fa-sign-language'=>'sign-language'),
array('fad fa-sign-out'=>'sign-out'),
array('fad fa-sign-out-alt'=>'sign-out-alt'),
array('fad fa-signal'=>'signal'),
array('fad fa-signal-1'=>'signal-1'),
array('fad fa-signal-2'=>'signal-2'),
array('fad fa-signal-3'=>'signal-3'),
array('fad fa-signal-4'=>'signal-4'),
array('fad fa-signal-alt'=>'signal-alt'),
array('fad fa-signal-alt-1'=>'signal-alt-1'),
array('fad fa-signal-alt-2'=>'signal-alt-2'),
array('fad fa-signal-alt-3'=>'signal-alt-3'),
array('fad fa-signal-alt-slash'=>'signal-alt-slash'),
array('fad fa-signal-slash'=>'signal-slash'),
array('fad fa-signal-stream'=>'signal-stream'),
array('fad fa-signature'=>'signature'),
array('fad fa-sim-card'=>'sim-card'),
array('fad fa-siren'=>'siren'),
array('fad fa-siren-on'=>'siren-on'),
array('fad fa-sitemap'=>'sitemap'),
array('fad fa-skating'=>'skating'),
array('fad fa-skeleton'=>'skeleton'),
array('fad fa-ski-jump'=>'ski-jump'),
array('fad fa-ski-lift'=>'ski-lift'),
array('fad fa-skiing'=>'skiing'),
array('fad fa-skiing-nordic'=>'skiing-nordic'),
array('fad fa-skull'=>'skull'),
array('fad fa-skull-cow'=>'skull-cow'),
array('fad fa-skull-crossbones'=>'skull-crossbones'),
array('fad fa-slash'=>'slash'),
array('fad fa-sledding'=>'sledding'),
array('fad fa-sleigh'=>'sleigh'),
array('fad fa-sliders-h'=>'sliders-h'),
array('fad fa-sliders-h-square'=>'sliders-h-square'),
array('fad fa-sliders-v'=>'sliders-v'),
array('fad fa-sliders-v-square'=>'sliders-v-square'),
array('fad fa-smile'=>'smile'),
array('fad fa-smile-beam'=>'smile-beam'),
array('fad fa-smile-plus'=>'smile-plus'),
array('fad fa-smile-wink'=>'smile-wink'),
array('fad fa-smog'=>'smog'),
array('fad fa-smoke'=>'smoke'),
array('fad fa-smoking'=>'smoking'),
array('fad fa-smoking-ban'=>'smoking-ban'),
array('fad fa-sms'=>'sms'),
array('fad fa-snake'=>'snake'),
array('fad fa-snooze'=>'snooze'),
array('fad fa-snow-blowing'=>'snow-blowing'),
array('fad fa-snowboarding'=>'snowboarding'),
array('fad fa-snowflake'=>'snowflake'),
array('fad fa-snowflakes'=>'snowflakes'),
array('fad fa-snowman'=>'snowman'),
array('fad fa-snowmobile'=>'snowmobile'),
array('fad fa-snowplow'=>'snowplow'),
array('fad fa-socks'=>'socks'),
array('fad fa-solar-panel'=>'solar-panel'),
array('fad fa-solar-system'=>'solar-system'),
array('fad fa-sort'=>'sort'),
array('fad fa-sort-alpha-down'=>'sort-alpha-down'),
array('fad fa-sort-alpha-down-alt'=>'sort-alpha-down-alt'),
array('fad fa-sort-alpha-up'=>'sort-alpha-up'),
array('fad fa-sort-alpha-up-alt'=>'sort-alpha-up-alt'),
array('fad fa-sort-alt'=>'sort-alt'),
array('fad fa-sort-amount-down'=>'sort-amount-down'),
array('fad fa-sort-amount-down-alt'=>'sort-amount-down-alt'),
array('fad fa-sort-amount-up'=>'sort-amount-up'),
array('fad fa-sort-amount-up-alt'=>'sort-amount-up-alt'),
array('fad fa-sort-circle'=>'sort-circle'),
array('fad fa-sort-circle-down'=>'sort-circle-down'),
array('fad fa-sort-circle-up'=>'sort-circle-up'),
array('fad fa-sort-down'=>'sort-down'),
array('fad fa-sort-numeric-down'=>'sort-numeric-down'),
array('fad fa-sort-numeric-down-alt'=>'sort-numeric-down-alt'),
array('fad fa-sort-numeric-up'=>'sort-numeric-up'),
array('fad fa-sort-numeric-up-alt'=>'sort-numeric-up-alt'),
array('fad fa-sort-shapes-down'=>'sort-shapes-down'),
array('fad fa-sort-shapes-down-alt'=>'sort-shapes-down-alt'),
array('fad fa-sort-shapes-up'=>'sort-shapes-up'),
array('fad fa-sort-shapes-up-alt'=>'sort-shapes-up-alt'),
array('fad fa-sort-size-down'=>'sort-size-down'),
array('fad fa-sort-size-down-alt'=>'sort-size-down-alt'),
array('fad fa-sort-size-up'=>'sort-size-up'),
array('fad fa-sort-size-up-alt'=>'sort-size-up-alt'),
array('fad fa-sort-up'=>'sort-up'),
array('fad fa-soup'=>'soup'),
array('fad fa-spa'=>'spa'),
array('fad fa-space-shuttle'=>'space-shuttle'),
array('fad fa-space-station-moon'=>'space-station-moon'),
array('fad fa-space-station-moon-alt'=>'space-station-moon-alt'),
array('fad fa-spade'=>'spade'),
array('fad fa-sparkles'=>'sparkles'),
array('fad fa-speaker'=>'speaker'),
array('fad fa-speakers'=>'speakers'),
array('fad fa-spell-check'=>'spell-check'),
array('fad fa-spider'=>'spider'),
array('fad fa-spider-black-widow'=>'spider-black-widow'),
array('fad fa-spider-web'=>'spider-web'),
array('fad fa-spinner'=>'spinner'),
array('fad fa-spinner-third'=>'spinner-third'),
array('fad fa-splotch'=>'splotch'),
array('fad fa-spray-can'=>'spray-can'),
array('fad fa-sprinkler'=>'sprinkler'),
array('fad fa-square'=>'square'),
array('fad fa-square-full'=>'square-full'),
array('fad fa-square-root'=>'square-root'),
array('fad fa-square-root-alt'=>'square-root-alt'),
array('fad fa-squirrel'=>'squirrel'),
array('fad fa-staff'=>'staff'),
array('fad fa-stamp'=>'stamp'),
array('fad fa-star'=>'star'),
array('fad fa-star-and-crescent'=>'star-and-crescent'),
array('fad fa-star-christmas'=>'star-christmas'),
array('fad fa-star-exclamation'=>'star-exclamation'),
array('fad fa-star-half'=>'star-half'),
array('fad fa-star-half-alt'=>'star-half-alt'),
array('fad fa-star-of-david'=>'star-of-david'),
array('fad fa-star-of-life'=>'star-of-life'),
array('fad fa-star-shooting'=>'star-shooting'),
array('fad fa-starfighter'=>'starfighter'),
array('fad fa-starfighter-alt'=>'starfighter-alt'),
array('fad fa-stars'=>'stars'),
array('fad fa-starship'=>'starship'),
array('fad fa-starship-freighter'=>'starship-freighter'),
array('fad fa-steak'=>'steak'),
array('fad fa-steering-wheel'=>'steering-wheel'),
array('fad fa-step-backward'=>'step-backward'),
array('fad fa-step-forward'=>'step-forward'),
array('fad fa-stethoscope'=>'stethoscope'),
array('fad fa-sticky-note'=>'sticky-note'),
array('fad fa-stocking'=>'stocking'),
array('fad fa-stomach'=>'stomach'),
array('fad fa-stop'=>'stop'),
array('fad fa-stop-circle'=>'stop-circle'),
array('fad fa-stopwatch'=>'stopwatch'),
array('fad fa-store'=>'store'),
array('fad fa-store-alt'=>'store-alt'),
array('fad fa-stream'=>'stream'),
array('fad fa-street-view'=>'street-view'),
array('fad fa-stretcher'=>'stretcher'),
array('fad fa-strikethrough'=>'strikethrough'),
array('fad fa-stroopwafel'=>'stroopwafel'),
array('fad fa-subscript'=>'subscript'),
array('fad fa-subway'=>'subway'),
array('fad fa-suitcase'=>'suitcase'),
array('fad fa-suitcase-rolling'=>'suitcase-rolling'),
array('fad fa-sun'=>'sun'),
array('fad fa-sun-cloud'=>'sun-cloud'),
array('fad fa-sun-dust'=>'sun-dust'),
array('fad fa-sun-haze'=>'sun-haze'),
array('fad fa-sunglasses'=>'sunglasses'),
array('fad fa-sunrise'=>'sunrise'),
array('fad fa-sunset'=>'sunset'),
array('fad fa-superscript'=>'superscript'),
array('fad fa-surprise'=>'surprise'),
array('fad fa-swatchbook'=>'swatchbook'),
array('fad fa-swimmer'=>'swimmer'),
array('fad fa-swimming-pool'=>'swimming-pool'),
array('fad fa-sword'=>'sword'),
array('fad fa-sword-laser'=>'sword-laser'),
array('fad fa-sword-laser-alt'=>'sword-laser-alt'),
array('fad fa-swords'=>'swords'),
array('fad fa-swords-laser'=>'swords-laser'),
array('fad fa-synagogue'=>'synagogue'),
array('fad fa-sync'=>'sync'),
array('fad fa-sync-alt'=>'sync-alt'),
array('fad fa-syringe'=>'syringe'),
array('fad fa-table'=>'table'),
array('fad fa-table-tennis'=>'table-tennis'),
array('fad fa-tablet'=>'tablet'),
array('fad fa-tablet-alt'=>'tablet-alt'),
array('fad fa-tablet-android'=>'tablet-android'),
array('fad fa-tablet-android-alt'=>'tablet-android-alt'),
array('fad fa-tablet-rugged'=>'tablet-rugged'),
array('fad fa-tablets'=>'tablets'),
array('fad fa-tachometer'=>'tachometer'),
array('fad fa-tachometer-alt'=>'tachometer-alt'),
array('fad fa-tachometer-alt-average'=>'tachometer-alt-average'),
array('fad fa-tachometer-alt-fast'=>'tachometer-alt-fast'),
array('fad fa-tachometer-alt-fastest'=>'tachometer-alt-fastest'),
array('fad fa-tachometer-alt-slow'=>'tachometer-alt-slow'),
array('fad fa-tachometer-alt-slowest'=>'tachometer-alt-slowest'),
array('fad fa-tachometer-average'=>'tachometer-average'),
array('fad fa-tachometer-fast'=>'tachometer-fast'),
array('fad fa-tachometer-fastest'=>'tachometer-fastest'),
array('fad fa-tachometer-slow'=>'tachometer-slow'),
array('fad fa-tachometer-slowest'=>'tachometer-slowest'),
array('fad fa-taco'=>'taco'),
array('fad fa-tag'=>'tag'),
array('fad fa-tags'=>'tags'),
array('fad fa-tally'=>'tally'),
array('fad fa-tanakh'=>'tanakh'),
array('fad fa-tape'=>'tape'),
array('fad fa-tasks'=>'tasks'),
array('fad fa-tasks-alt'=>'tasks-alt'),
array('fad fa-taxi'=>'taxi'),
array('fad fa-teeth'=>'teeth'),
array('fad fa-teeth-open'=>'teeth-open'),
array('fad fa-telescope'=>'telescope'),
array('fad fa-temperature-down'=>'temperature-down'),
array('fad fa-temperature-frigid'=>'temperature-frigid'),
array('fad fa-temperature-high'=>'temperature-high'),
array('fad fa-temperature-hot'=>'temperature-hot'),
array('fad fa-temperature-low'=>'temperature-low'),
array('fad fa-temperature-up'=>'temperature-up'),
array('fad fa-tenge'=>'tenge'),
array('fad fa-tennis-ball'=>'tennis-ball'),
array('fad fa-terminal'=>'terminal'),
array('fad fa-text'=>'text'),
array('fad fa-text-height'=>'text-height'),
array('fad fa-text-size'=>'text-size'),
array('fad fa-text-width'=>'text-width'),
array('fad fa-th'=>'th'),
array('fad fa-th-large'=>'th-large'),
array('fad fa-th-list'=>'th-list'),
array('fad fa-theater-masks'=>'theater-masks'),
array('fad fa-thermometer'=>'thermometer'),
array('fad fa-thermometer-empty'=>'thermometer-empty'),
array('fad fa-thermometer-full'=>'thermometer-full'),
array('fad fa-thermometer-half'=>'thermometer-half'),
array('fad fa-thermometer-quarter'=>'thermometer-quarter'),
array('fad fa-thermometer-three-quarters'=>'thermometer-three-quarters'),
array('fad fa-theta'=>'theta'),
array('fad fa-thumbs-down'=>'thumbs-down'),
array('fad fa-thumbs-up'=>'thumbs-up'),
array('fad fa-thumbtack'=>'thumbtack'),
array('fad fa-thunderstorm'=>'thunderstorm'),
array('fad fa-thunderstorm-moon'=>'thunderstorm-moon'),
array('fad fa-thunderstorm-sun'=>'thunderstorm-sun'),
array('fad fa-ticket'=>'ticket'),
array('fad fa-ticket-alt'=>'ticket-alt'),
array('fad fa-tilde'=>'tilde'),
array('fad fa-times'=>'times'),
array('fad fa-times-circle'=>'times-circle'),
array('fad fa-times-hexagon'=>'times-hexagon'),
array('fad fa-times-octagon'=>'times-octagon'),
array('fad fa-times-square'=>'times-square'),
array('fad fa-tint'=>'tint'),
array('fad fa-tint-slash'=>'tint-slash'),
array('fad fa-tire'=>'tire'),
array('fad fa-tire-flat'=>'tire-flat'),
array('fad fa-tire-pressure-warning'=>'tire-pressure-warning'),
array('fad fa-tire-rugged'=>'tire-rugged'),
array('fad fa-tired'=>'tired'),
array('fad fa-toggle-off'=>'toggle-off'),
array('fad fa-toggle-on'=>'toggle-on'),
array('fad fa-toilet'=>'toilet'),
array('fad fa-toilet-paper'=>'toilet-paper'),
array('fad fa-toilet-paper-alt'=>'toilet-paper-alt'),
array('fad fa-tombstone'=>'tombstone'),
array('fad fa-tombstone-alt'=>'tombstone-alt'),
array('fad fa-toolbox'=>'toolbox'),
array('fad fa-tools'=>'tools'),
array('fad fa-tooth'=>'tooth'),
array('fad fa-toothbrush'=>'toothbrush'),
array('fad fa-torah'=>'torah'),
array('fad fa-torii-gate'=>'torii-gate'),
array('fad fa-tornado'=>'tornado'),
array('fad fa-tractor'=>'tractor'),
array('fad fa-trademark'=>'trademark'),
array('fad fa-traffic-cone'=>'traffic-cone'),
array('fad fa-traffic-light'=>'traffic-light'),
array('fad fa-traffic-light-go'=>'traffic-light-go'),
array('fad fa-traffic-light-slow'=>'traffic-light-slow'),
array('fad fa-traffic-light-stop'=>'traffic-light-stop'),
array('fad fa-trailer'=>'trailer'),
array('fad fa-train'=>'train'),
array('fad fa-tram'=>'tram'),
array('fad fa-transgender'=>'transgender'),
array('fad fa-transgender-alt'=>'transgender-alt'),
array('fad fa-transporter'=>'transporter'),
array('fad fa-transporter-1'=>'transporter-1'),
array('fad fa-transporter-2'=>'transporter-2'),
array('fad fa-transporter-3'=>'transporter-3'),
array('fad fa-transporter-empty'=>'transporter-empty'),
array('fad fa-trash'=>'trash'),
array('fad fa-trash-alt'=>'trash-alt'),
array('fad fa-trash-restore'=>'trash-restore'),
array('fad fa-trash-restore-alt'=>'trash-restore-alt'),
array('fad fa-trash-undo'=>'trash-undo'),
array('fad fa-trash-undo-alt'=>'trash-undo-alt'),
array('fad fa-treasure-chest'=>'treasure-chest'),
array('fad fa-tree'=>'tree'),
array('fad fa-tree-alt'=>'tree-alt'),
array('fad fa-tree-christmas'=>'tree-christmas'),
array('fad fa-tree-decorated'=>'tree-decorated'),
array('fad fa-tree-large'=>'tree-large'),
array('fad fa-tree-palm'=>'tree-palm'),
array('fad fa-trees'=>'trees'),
array('fad fa-triangle'=>'triangle'),
array('fad fa-triangle-music'=>'triangle-music'),
array('fad fa-trophy'=>'trophy'),
array('fad fa-trophy-alt'=>'trophy-alt'),
array('fad fa-truck'=>'truck'),
array('fad fa-truck-container'=>'truck-container'),
array('fad fa-truck-couch'=>'truck-couch'),
array('fad fa-truck-loading'=>'truck-loading'),
array('fad fa-truck-monster'=>'truck-monster'),
array('fad fa-truck-moving'=>'truck-moving'),
array('fad fa-truck-pickup'=>'truck-pickup'),
array('fad fa-truck-plow'=>'truck-plow'),
array('fad fa-truck-ramp'=>'truck-ramp'),
array('fad fa-trumpet'=>'trumpet'),
array('fad fa-tshirt'=>'tshirt'),
array('fad fa-tty'=>'tty'),
array('fad fa-turkey'=>'turkey'),
array('fad fa-turntable'=>'turntable'),
array('fad fa-turtle'=>'turtle'),
array('fad fa-tv'=>'tv'),
array('fad fa-tv-alt'=>'tv-alt'),
array('fad fa-tv-music'=>'tv-music'),
array('fad fa-tv-retro'=>'tv-retro'),
array('fad fa-typewriter'=>'typewriter'),
array('fad fa-ufo'=>'ufo'),
array('fad fa-ufo-beam'=>'ufo-beam'),
array('fad fa-umbrella'=>'umbrella'),
array('fad fa-umbrella-beach'=>'umbrella-beach'),
array('fad fa-underline'=>'underline'),
array('fad fa-undo'=>'undo'),
array('fad fa-undo-alt'=>'undo-alt'),
array('fad fa-unicorn'=>'unicorn'),
array('fad fa-union'=>'union'),
array('fad fa-universal-access'=>'universal-access'),
array('fad fa-university'=>'university'),
array('fad fa-unlink'=>'unlink'),
array('fad fa-unlock'=>'unlock'),
array('fad fa-unlock-alt'=>'unlock-alt'),
array('fad fa-upload'=>'upload'),
array('fad fa-usb-drive'=>'usb-drive'),
array('fad fa-usd-circle'=>'usd-circle'),
array('fad fa-usd-square'=>'usd-square'),
array('fad fa-user'=>'user'),
array('fad fa-user-alien'=>'user-alien'),
array('fad fa-user-alt'=>'user-alt'),
array('fad fa-user-alt-slash'=>'user-alt-slash'),
array('fad fa-user-astronaut'=>'user-astronaut'),
array('fad fa-user-chart'=>'user-chart'),
array('fad fa-user-check'=>'user-check'),
array('fad fa-user-circle'=>'user-circle'),
array('fad fa-user-clock'=>'user-clock'),
array('fad fa-user-cog'=>'user-cog'),
array('fad fa-user-cowboy'=>'user-cowboy'),
array('fad fa-user-crown'=>'user-crown'),
array('fad fa-user-edit'=>'user-edit'),
array('fad fa-user-friends'=>'user-friends'),
array('fad fa-user-graduate'=>'user-graduate'),
array('fad fa-user-hard-hat'=>'user-hard-hat'),
array('fad fa-user-headset'=>'user-headset'),
array('fad fa-user-injured'=>'user-injured'),
array('fad fa-user-lock'=>'user-lock'),
array('fad fa-user-md'=>'user-md'),
array('fad fa-user-md-chat'=>'user-md-chat'),
array('fad fa-user-minus'=>'user-minus'),
array('fad fa-user-music'=>'user-music'),
array('fad fa-user-ninja'=>'user-ninja'),
array('fad fa-user-nurse'=>'user-nurse'),
array('fad fa-user-plus'=>'user-plus'),
array('fad fa-user-robot'=>'user-robot'),
array('fad fa-user-secret'=>'user-secret'),
array('fad fa-user-shield'=>'user-shield'),
array('fad fa-user-slash'=>'user-slash'),
array('fad fa-user-tag'=>'user-tag'),
array('fad fa-user-tie'=>'user-tie'),
array('fad fa-user-times'=>'user-times'),
array('fad fa-user-unlock'=>'user-unlock'),
array('fad fa-user-visor'=>'user-visor'),
array('fad fa-users'=>'users'),
array('fad fa-users-class'=>'users-class'),
array('fad fa-users-cog'=>'users-cog'),
array('fad fa-users-crown'=>'users-crown'),
array('fad fa-users-medical'=>'users-medical'),
array('fad fa-utensil-fork'=>'utensil-fork'),
array('fad fa-utensil-knife'=>'utensil-knife'),
array('fad fa-utensil-spoon'=>'utensil-spoon'),
array('fad fa-utensils'=>'utensils'),
array('fad fa-utensils-alt'=>'utensils-alt'),
array('fad fa-vacuum'=>'vacuum'),
array('fad fa-vacuum-robot'=>'vacuum-robot'),
array('fad fa-value-absolute'=>'value-absolute'),
array('fad fa-vector-square'=>'vector-square'),
array('fad fa-venus'=>'venus'),
array('fad fa-venus-double'=>'venus-double'),
array('fad fa-venus-mars'=>'venus-mars'),
array('fad fa-vhs'=>'vhs'),
array('fad fa-vial'=>'vial'),
array('fad fa-vials'=>'vials'),
array('fad fa-video'=>'video'),
array('fad fa-video-plus'=>'video-plus'),
array('fad fa-video-slash'=>'video-slash'),
array('fad fa-vihara'=>'vihara'),
array('fad fa-violin'=>'violin'),
array('fad fa-voicemail'=>'voicemail'),
array('fad fa-volcano'=>'volcano'),
array('fad fa-volleyball-ball'=>'volleyball-ball'),
array('fad fa-volume'=>'volume'),
array('fad fa-volume-down'=>'volume-down'),
array('fad fa-volume-mute'=>'volume-mute'),
array('fad fa-volume-off'=>'volume-off'),
array('fad fa-volume-slash'=>'volume-slash'),
array('fad fa-volume-up'=>'volume-up'),
array('fad fa-vote-nay'=>'vote-nay'),
array('fad fa-vote-yea'=>'vote-yea'),
array('fad fa-vr-cardboard'=>'vr-cardboard'),
array('fad fa-wagon-covered'=>'wagon-covered'),
array('fad fa-walker'=>'walker'),
array('fad fa-walkie-talkie'=>'walkie-talkie'),
array('fad fa-walking'=>'walking'),
array('fad fa-wallet'=>'wallet'),
array('fad fa-wand'=>'wand'),
array('fad fa-wand-magic'=>'wand-magic'),
array('fad fa-warehouse'=>'warehouse'),
array('fad fa-warehouse-alt'=>'warehouse-alt'),
array('fad fa-washer'=>'washer'),
array('fad fa-watch'=>'watch'),
array('fad fa-watch-calculator'=>'watch-calculator'),
array('fad fa-watch-fitness'=>'watch-fitness'),
array('fad fa-water'=>'water'),
array('fad fa-water-lower'=>'water-lower'),
array('fad fa-water-rise'=>'water-rise'),
array('fad fa-wave-sine'=>'wave-sine'),
array('fad fa-wave-square'=>'wave-square'),
array('fad fa-wave-triangle'=>'wave-triangle'),
array('fad fa-waveform'=>'waveform'),
array('fad fa-waveform-path'=>'waveform-path'),
array('fad fa-webcam'=>'webcam'),
array('fad fa-webcam-slash'=>'webcam-slash'),
array('fad fa-weight'=>'weight'),
array('fad fa-weight-hanging'=>'weight-hanging'),
array('fad fa-whale'=>'whale'),
array('fad fa-wheat'=>'wheat'),
array('fad fa-wheelchair'=>'wheelchair'),
array('fad fa-whistle'=>'whistle'),
array('fad fa-wifi'=>'wifi'),
array('fad fa-wifi-1'=>'wifi-1'),
array('fad fa-wifi-2'=>'wifi-2'),
array('fad fa-wifi-slash'=>'wifi-slash'),
array('fad fa-wind'=>'wind'),
array('fad fa-wind-turbine'=>'wind-turbine'),
array('fad fa-wind-warning'=>'wind-warning'),
array('fad fa-window'=>'window'),
array('fad fa-window-alt'=>'window-alt'),
array('fad fa-window-close'=>'window-close'),
array('fad fa-window-frame'=>'window-frame'),
array('fad fa-window-frame-open'=>'window-frame-open'),
array('fad fa-window-maximize'=>'window-maximize'),
array('fad fa-window-minimize'=>'window-minimize'),
array('fad fa-window-restore'=>'window-restore'),
array('fad fa-windsock'=>'windsock'),
array('fad fa-wine-bottle'=>'wine-bottle'),
array('fad fa-wine-glass'=>'wine-glass'),
array('fad fa-wine-glass-alt'=>'wine-glass-alt'),
array('fad fa-won-sign'=>'won-sign'),
array('fad fa-wreath'=>'wreath'),
array('fad fa-wrench'=>'wrench'),
array('fad fa-x-ray'=>'x-ray'),
array('fad fa-yen-sign'=>'yen-sign'),
array('fad fa-yin-yang'=>'yin-yang'),
),
'Brands Icons' => array(
array('fab fa-500px'=>'500px'),
array('fab fa-accessible-icon'=>'accessible-icon'),
array('fab fa-accusoft'=>'accusoft'),
array('fab fa-acquisitions-incorporated'=>'acquisitions-incorporated'),
array('fab fa-adn'=>'adn'),
array('fab fa-adobe'=>'adobe'),
array('fab fa-adversal'=>'adversal'),
array('fab fa-affiliatetheme'=>'affiliatetheme'),
array('fab fa-airbnb'=>'airbnb'),
array('fab fa-algolia'=>'algolia'),
array('fab fa-alipay'=>'alipay'),
array('fab fa-amazon'=>'amazon'),
array('fab fa-amazon-pay'=>'amazon-pay'),
array('fab fa-amilia'=>'amilia'),
array('fab fa-android'=>'android'),
array('fab fa-angellist'=>'angellist'),
array('fab fa-angrycreative'=>'angrycreative'),
array('fab fa-angular'=>'angular'),
array('fab fa-app-store'=>'app-store'),
array('fab fa-app-store-ios'=>'app-store-ios'),
array('fab fa-apper'=>'apper'),
array('fab fa-apple'=>'apple'),
array('fab fa-apple-pay'=>'apple-pay'),
array('fab fa-artstation'=>'artstation'),
array('fab fa-asymmetrik'=>'asymmetrik'),
array('fab fa-atlassian'=>'atlassian'),
array('fab fa-audible'=>'audible'),
array('fab fa-autoprefixer'=>'autoprefixer'),
array('fab fa-avianex'=>'avianex'),
array('fab fa-aviato'=>'aviato'),
array('fab fa-aws'=>'aws'),
array('fab fa-bandcamp'=>'bandcamp'),
array('fab fa-battle-net'=>'battle-net'),
array('fab fa-behance'=>'behance'),
array('fab fa-behance-square'=>'behance-square'),
array('fab fa-bimobject'=>'bimobject'),
array('fab fa-bitbucket'=>'bitbucket'),
array('fab fa-bitcoin'=>'bitcoin'),
array('fab fa-bity'=>'bity'),
array('fab fa-black-tie'=>'black-tie'),
array('fab fa-blackberry'=>'blackberry'),
array('fab fa-blogger'=>'blogger'),
array('fab fa-blogger-b'=>'blogger-b'),
array('fab fa-bluetooth'=>'bluetooth'),
array('fab fa-bluetooth-b'=>'bluetooth-b'),
array('fab fa-bootstrap'=>'bootstrap'),
array('fab fa-btc'=>'btc'),
array('fab fa-buffer'=>'buffer'),
array('fab fa-buromobelexperte'=>'buromobelexperte'),
array('fab fa-buy-n-large'=>'buy-n-large'),
array('fab fa-buysellads'=>'buysellads'),
array('fab fa-canadian-maple-leaf'=>'canadian-maple-leaf'),
array('fab fa-cc-amazon-pay'=>'cc-amazon-pay'),
array('fab fa-cc-amex'=>'cc-amex'),
array('fab fa-cc-apple-pay'=>'cc-apple-pay'),
array('fab fa-cc-diners-club'=>'cc-diners-club'),
array('fab fa-cc-discover'=>'cc-discover'),
array('fab fa-cc-jcb'=>'cc-jcb'),
array('fab fa-cc-mastercard'=>'cc-mastercard'),
array('fab fa-cc-paypal'=>'cc-paypal'),
array('fab fa-cc-stripe'=>'cc-stripe'),
array('fab fa-cc-visa'=>'cc-visa'),
array('fab fa-centercode'=>'centercode'),
array('fab fa-centos'=>'centos'),
array('fab fa-chrome'=>'chrome'),
array('fab fa-chromecast'=>'chromecast'),
array('fab fa-cloudscale'=>'cloudscale'),
array('fab fa-cloudsmith'=>'cloudsmith'),
array('fab fa-cloudversify'=>'cloudversify'),
array('fab fa-codepen'=>'codepen'),
array('fab fa-codiepie'=>'codiepie'),
array('fab fa-confluence'=>'confluence'),
array('fab fa-connectdevelop'=>'connectdevelop'),
array('fab fa-contao'=>'contao'),
array('fab fa-cotton-bureau'=>'cotton-bureau'),
array('fab fa-cpanel'=>'cpanel'),
array('fab fa-creative-commons'=>'creative-commons'),
array('fab fa-creative-commons-by'=>'creative-commons-by'),
array('fab fa-creative-commons-nc'=>'creative-commons-nc'),
array('fab fa-creative-commons-nc-eu'=>'creative-commons-nc-eu'),
array('fab fa-creative-commons-nc-jp'=>'creative-commons-nc-jp'),
array('fab fa-creative-commons-nd'=>'creative-commons-nd'),
array('fab fa-creative-commons-pd'=>'creative-commons-pd'),
array('fab fa-creative-commons-pd-alt'=>'creative-commons-pd-alt'),
array('fab fa-creative-commons-remix'=>'creative-commons-remix'),
array('fab fa-creative-commons-sa'=>'creative-commons-sa'),
array('fab fa-creative-commons-sampling'=>'creative-commons-sampling'),
array('fab fa-creative-commons-sampling-plus'=>'creative-commons-sampling-plus'),
array('fab fa-creative-commons-share'=>'creative-commons-share'),
array('fab fa-creative-commons-zero'=>'creative-commons-zero'),
array('fab fa-critical-role'=>'critical-role'),
array('fab fa-css3'=>'css3'),
array('fab fa-css3-alt'=>'css3-alt'),
array('fab fa-cuttlefish'=>'cuttlefish'),
array('fab fa-d-and-d'=>'d-and-d'),
array('fab fa-d-and-d-beyond'=>'d-and-d-beyond'),
array('fab fa-dailymotion'=>'dailymotion'),
array('fab fa-dashcube'=>'dashcube'),
array('fab fa-delicious'=>'delicious'),
array('fab fa-deploydog'=>'deploydog'),
array('fab fa-deskpro'=>'deskpro'),
array('fab fa-dev'=>'dev'),
array('fab fa-deviantart'=>'deviantart'),
array('fab fa-dhl'=>'dhl'),
array('fab fa-diaspora'=>'diaspora'),
array('fab fa-digg'=>'digg'),
array('fab fa-digital-ocean'=>'digital-ocean'),
array('fab fa-discord'=>'discord'),
array('fab fa-discourse'=>'discourse'),
array('fab fa-dochub'=>'dochub'),
array('fab fa-docker'=>'docker'),
array('fab fa-draft2digital'=>'draft2digital'),
array('fab fa-dribbble'=>'dribbble'),
array('fab fa-dribbble-square'=>'dribbble-square'),
array('fab fa-dropbox'=>'dropbox'),
array('fab fa-drupal'=>'drupal'),
array('fab fa-dyalog'=>'dyalog'),
array('fab fa-earlybirds'=>'earlybirds'),
array('fab fa-ebay'=>'ebay'),
array('fab fa-edge'=>'edge'),
array('fab fa-elementor'=>'elementor'),
array('fab fa-ello'=>'ello'),
array('fab fa-ember'=>'ember'),
array('fab fa-empire'=>'empire'),
array('fab fa-envira'=>'envira'),
array('fab fa-erlang'=>'erlang'),
array('fab fa-ethereum'=>'ethereum'),
array('fab fa-etsy'=>'etsy'),
array('fab fa-evernote'=>'evernote'),
array('fab fa-expeditedssl'=>'expeditedssl'),
array('fab fa-facebook'=>'facebook'),
array('fab fa-facebook-f'=>'facebook-f'),
array('fab fa-facebook-messenger'=>'facebook-messenger'),
array('fab fa-facebook-square'=>'facebook-square'),
array('fab fa-fantasy-flight-games'=>'fantasy-flight-games'),
array('fab fa-fedex'=>'fedex'),
array('fab fa-fedora'=>'fedora'),
array('fab fa-figma'=>'figma'),
array('fab fa-firefox'=>'firefox'),
array('fab fa-firefox-browser'=>'firefox-browser'),
array('fab fa-first-order'=>'first-order'),
array('fab fa-first-order-alt'=>'first-order-alt'),
array('fab fa-firstdraft'=>'firstdraft'),
array('fab fa-flickr'=>'flickr'),
array('fab fa-flipboard'=>'flipboard'),
array('fab fa-fly'=>'fly'),
array('fab fa-font-awesome'=>'font-awesome'),
array('fab fa-font-awesome-alt'=>'font-awesome-alt'),
array('fab fa-font-awesome-flag'=>'font-awesome-flag'),
array('fab fa-fonticons'=>'fonticons'),
array('fab fa-fonticons-fi'=>'fonticons-fi'),
array('fab fa-fort-awesome'=>'fort-awesome'),
array('fab fa-fort-awesome-alt'=>'fort-awesome-alt'),
array('fab fa-forumbee'=>'forumbee'),
array('fab fa-foursquare'=>'foursquare'),
array('fab fa-free-code-camp'=>'free-code-camp'),
array('fab fa-freebsd'=>'freebsd'),
array('fab fa-fulcrum'=>'fulcrum'),
array('fab fa-galactic-republic'=>'galactic-republic'),
array('fab fa-galactic-senate'=>'galactic-senate'),
array('fab fa-get-pocket'=>'get-pocket'),
array('fab fa-gg'=>'gg'),
array('fab fa-gg-circle'=>'gg-circle'),
array('fab fa-git'=>'git'),
array('fab fa-git-alt'=>'git-alt'),
array('fab fa-git-square'=>'git-square'),
array('fab fa-github'=>'github'),
array('fab fa-github-alt'=>'github-alt'),
array('fab fa-github-square'=>'github-square'),
array('fab fa-gitkraken'=>'gitkraken'),
array('fab fa-gitlab'=>'gitlab'),
array('fab fa-gitter'=>'gitter'),
array('fab fa-glide'=>'glide'),
array('fab fa-glide-g'=>'glide-g'),
array('fab fa-gofore'=>'gofore'),
array('fab fa-goodreads'=>'goodreads'),
array('fab fa-goodreads-g'=>'goodreads-g'),
array('fab fa-google'=>'google'),
array('fab fa-google-drive'=>'google-drive'),
array('fab fa-google-play'=>'google-play'),
array('fab fa-google-plus'=>'google-plus'),
array('fab fa-google-plus-g'=>'google-plus-g'),
array('fab fa-google-plus-square'=>'google-plus-square'),
array('fab fa-google-wallet'=>'google-wallet'),
array('fab fa-gratipay'=>'gratipay'),
array('fab fa-grav'=>'grav'),
array('fab fa-gripfire'=>'gripfire'),
array('fab fa-grunt'=>'grunt'),
array('fab fa-gulp'=>'gulp'),
array('fab fa-hacker-news'=>'hacker-news'),
array('fab fa-hacker-news-square'=>'hacker-news-square'),
array('fab fa-hackerrank'=>'hackerrank'),
array('fab fa-hips'=>'hips'),
array('fab fa-hire-a-helper'=>'hire-a-helper'),
array('fab fa-hooli'=>'hooli'),
array('fab fa-hornbill'=>'hornbill'),
array('fab fa-hotjar'=>'hotjar'),
array('fab fa-houzz'=>'houzz'),
array('fab fa-html5'=>'html5'),
array('fab fa-hubspot'=>'hubspot'),
array('fab fa-ideal'=>'ideal'),
array('fab fa-imdb'=>'imdb'),
array('fab fa-instagram'=>'instagram'),
array('fab fa-instagram-square'=>'instagram-square'),
array('fab fa-intercom'=>'intercom'),
array('fab fa-internet-explorer'=>'internet-explorer'),
array('fab fa-invision'=>'invision'),
array('fab fa-ioxhost'=>'ioxhost'),
array('fab fa-itch-io'=>'itch-io'),
array('fab fa-itunes'=>'itunes'),
array('fab fa-itunes-note'=>'itunes-note'),
array('fab fa-java'=>'java'),
array('fab fa-jedi-order'=>'jedi-order'),
array('fab fa-jenkins'=>'jenkins'),
array('fab fa-jira'=>'jira'),
array('fab fa-joget'=>'joget'),
array('fab fa-joomla'=>'joomla'),
array('fab fa-js'=>'js'),
array('fab fa-js-square'=>'js-square'),
array('fab fa-jsfiddle'=>'jsfiddle'),
array('fab fa-kaggle'=>'kaggle'),
array('fab fa-keybase'=>'keybase'),
array('fab fa-keycdn'=>'keycdn'),
array('fab fa-kickstarter'=>'kickstarter'),
array('fab fa-kickstarter-k'=>'kickstarter-k'),
array('fab fa-korvue'=>'korvue'),
array('fab fa-laravel'=>'laravel'),
array('fab fa-lastfm'=>'lastfm'),
array('fab fa-lastfm-square'=>'lastfm-square'),
array('fab fa-leanpub'=>'leanpub'),
array('fab fa-less'=>'less'),
array('fab fa-line'=>'line'),
array('fab fa-linkedin'=>'linkedin'),
array('fab fa-linkedin-in'=>'linkedin-in'),
array('fab fa-linode'=>'linode'),
array('fab fa-linux'=>'linux'),
array('fab fa-lyft'=>'lyft'),
array('fab fa-magento'=>'magento'),
array('fab fa-mailchimp'=>'mailchimp'),
array('fab fa-mandalorian'=>'mandalorian'),
array('fab fa-markdown'=>'markdown'),
array('fab fa-mastodon'=>'mastodon'),
array('fab fa-maxcdn'=>'maxcdn'),
array('fab fa-mdb'=>'mdb'),
array('fab fa-medapps'=>'medapps'),
array('fab fa-medium'=>'medium'),
array('fab fa-medium-m'=>'medium-m'),
array('fab fa-medrt'=>'medrt'),
array('fab fa-meetup'=>'meetup'),
array('fab fa-megaport'=>'megaport'),
array('fab fa-mendeley'=>'mendeley'),
array('fab fa-microblog'=>'microblog'),
array('fab fa-microsoft'=>'microsoft'),
array('fab fa-mix'=>'mix'),
array('fab fa-mixcloud'=>'mixcloud'),
array('fab fa-mixer'=>'mixer'),
array('fab fa-mizuni'=>'mizuni'),
array('fab fa-modx'=>'modx'),
array('fab fa-monero'=>'monero'),
array('fab fa-napster'=>'napster'),
array('fab fa-neos'=>'neos'),
array('fab fa-nimblr'=>'nimblr'),
array('fab fa-node'=>'node'),
array('fab fa-node-js'=>'node-js'),
array('fab fa-npm'=>'npm'),
array('fab fa-ns8'=>'ns8'),
array('fab fa-nutritionix'=>'nutritionix'),
array('fab fa-odnoklassniki'=>'odnoklassniki'),
array('fab fa-odnoklassniki-square'=>'odnoklassniki-square'),
array('fab fa-old-republic'=>'old-republic'),
array('fab fa-opencart'=>'opencart'),
array('fab fa-openid'=>'openid'),
array('fab fa-opera'=>'opera'),
array('fab fa-optin-monster'=>'optin-monster'),
array('fab fa-orcid'=>'orcid'),
array('fab fa-osi'=>'osi'),
array('fab fa-page4'=>'page4'),
array('fab fa-pagelines'=>'pagelines'),
array('fab fa-palfed'=>'palfed'),
array('fab fa-patreon'=>'patreon'),
array('fab fa-paypal'=>'paypal'),
array('fab fa-penny-arcade'=>'penny-arcade'),
array('fab fa-periscope'=>'periscope'),
array('fab fa-phabricator'=>'phabricator'),
array('fab fa-phoenix-framework'=>'phoenix-framework'),
array('fab fa-phoenix-squadron'=>'phoenix-squadron'),
array('fab fa-php'=>'php'),
array('fab fa-pied-piper'=>'pied-piper'),
array('fab fa-pied-piper-alt'=>'pied-piper-alt'),
array('fab fa-pied-piper-hat'=>'pied-piper-hat'),
array('fab fa-pied-piper-pp'=>'pied-piper-pp'),
array('fab fa-pied-piper-square'=>'pied-piper-square'),
array('fab fa-pinterest'=>'pinterest'),
array('fab fa-pinterest-p'=>'pinterest-p'),
array('fab fa-pinterest-square'=>'pinterest-square'),
array('fab fa-playstation'=>'playstation'),
array('fab fa-product-hunt'=>'product-hunt'),
array('fab fa-pushed'=>'pushed'),
array('fab fa-python'=>'python'),
array('fab fa-qq'=>'qq'),
array('fab fa-quinscape'=>'quinscape'),
array('fab fa-quora'=>'quora'),
array('fab fa-r-project'=>'r-project'),
array('fab fa-raspberry-pi'=>'raspberry-pi'),
array('fab fa-ravelry'=>'ravelry'),
array('fab fa-react'=>'react'),
array('fab fa-reacteurope'=>'reacteurope'),
array('fab fa-readme'=>'readme'),
array('fab fa-rebel'=>'rebel'),
array('fab fa-red-river'=>'red-river'),
array('fab fa-reddit'=>'reddit'),
array('fab fa-reddit-alien'=>'reddit-alien'),
array('fab fa-reddit-square'=>'reddit-square'),
array('fab fa-redhat'=>'redhat'),
array('fab fa-renren'=>'renren'),
array('fab fa-replyd'=>'replyd'),
array('fab fa-researchgate'=>'researchgate'),
array('fab fa-resolving'=>'resolving'),
array('fab fa-rev'=>'rev'),
array('fab fa-rocketchat'=>'rocketchat'),
array('fab fa-rockrms'=>'rockrms'),
array('fab fa-safari'=>'safari'),
array('fab fa-salesforce'=>'salesforce'),
array('fab fa-sass'=>'sass'),
array('fab fa-schlix'=>'schlix'),
array('fab fa-scribd'=>'scribd'),
array('fab fa-searchengin'=>'searchengin'),
array('fab fa-sellcast'=>'sellcast'),
array('fab fa-sellsy'=>'sellsy'),
array('fab fa-servicestack'=>'servicestack'),
array('fab fa-shirtsinbulk'=>'shirtsinbulk'),
array('fab fa-shopify'=>'shopify'),
array('fab fa-shopware'=>'shopware'),
array('fab fa-simplybuilt'=>'simplybuilt'),
array('fab fa-sistrix'=>'sistrix'),
array('fab fa-sith'=>'sith'),
array('fab fa-sketch'=>'sketch'),
array('fab fa-skyatlas'=>'skyatlas'),
array('fab fa-skype'=>'skype'),
array('fab fa-slack'=>'slack'),
array('fab fa-slack-hash'=>'slack-hash'),
array('fab fa-slideshare'=>'slideshare'),
array('fab fa-snapchat'=>'snapchat'),
array('fab fa-snapchat-ghost'=>'snapchat-ghost'),
array('fab fa-snapchat-square'=>'snapchat-square'),
array('fab fa-soundcloud'=>'soundcloud'),
array('fab fa-sourcetree'=>'sourcetree'),
array('fab fa-speakap'=>'speakap'),
array('fab fa-speaker-deck'=>'speaker-deck'),
array('fab fa-spotify'=>'spotify'),
array('fab fa-squarespace'=>'squarespace'),
array('fab fa-stack-exchange'=>'stack-exchange'),
array('fab fa-stack-overflow'=>'stack-overflow'),
array('fab fa-stackpath'=>'stackpath'),
array('fab fa-staylinked'=>'staylinked'),
array('fab fa-steam'=>'steam'),
array('fab fa-steam-square'=>'steam-square'),
array('fab fa-steam-symbol'=>'steam-symbol'),
array('fab fa-sticker-mule'=>'sticker-mule'),
array('fab fa-strava'=>'strava'),
array('fab fa-stripe'=>'stripe'),
array('fab fa-stripe-s'=>'stripe-s'),
array('fab fa-studiovinari'=>'studiovinari'),
array('fab fa-stumbleupon'=>'stumbleupon'),
array('fab fa-stumbleupon-circle'=>'stumbleupon-circle'),
array('fab fa-superpowers'=>'superpowers'),
array('fab fa-supple'=>'supple'),
array('fab fa-suse'=>'suse'),
array('fab fa-swift'=>'swift'),
array('fab fa-symfony'=>'symfony'),
array('fab fa-teamspeak'=>'teamspeak'),
array('fab fa-telegram'=>'telegram'),
array('fab fa-telegram-plane'=>'telegram-plane'),
array('fab fa-tencent-weibo'=>'tencent-weibo'),
array('fab fa-the-red-yeti'=>'the-red-yeti'),
array('fab fa-themeco'=>'themeco'),
array('fab fa-themeisle'=>'themeisle'),
array('fab fa-think-peaks'=>'think-peaks'),
array('fab fa-trade-federation'=>'trade-federation'),
array('fab fa-trello'=>'trello'),
array('fab fa-tripadvisor'=>'tripadvisor'),
array('fab fa-tumblr'=>'tumblr'),
array('fab fa-tumblr-square'=>'tumblr-square'),
array('fab fa-twitch'=>'twitch'),
array('fab fa-twitter'=>'twitter'),
array('fab fa-twitter-square'=>'twitter-square'),
array('fab fa-typo3'=>'typo3'),
array('fab fa-uber'=>'uber'),
array('fab fa-ubuntu'=>'ubuntu'),
array('fab fa-uikit'=>'uikit'),
array('fab fa-umbraco'=>'umbraco'),
array('fab fa-uniregistry'=>'uniregistry'),
array('fab fa-unity'=>'unity'),
array('fab fa-untappd'=>'untappd'),
array('fab fa-ups'=>'ups'),
array('fab fa-usb'=>'usb'),
array('fab fa-usps'=>'usps'),
array('fab fa-ussunnah'=>'ussunnah'),
array('fab fa-vaadin'=>'vaadin'),
array('fab fa-viacoin'=>'viacoin'),
array('fab fa-viadeo'=>'viadeo'),
array('fab fa-viadeo-square'=>'viadeo-square'),
array('fab fa-viber'=>'viber'),
array('fab fa-vimeo'=>'vimeo'),
array('fab fa-vimeo-square'=>'vimeo-square'),
array('fab fa-vimeo-v'=>'vimeo-v'),
array('fab fa-vine'=>'vine'),
array('fab fa-vk'=>'vk'),
array('fab fa-vnv'=>'vnv'),
array('fab fa-vuejs'=>'vuejs'),
array('fab fa-waze'=>'waze'),
array('fab fa-weebly'=>'weebly'),
array('fab fa-weibo'=>'weibo'),
array('fab fa-weixin'=>'weixin'),
array('fab fa-whatsapp'=>'whatsapp'),
array('fab fa-whatsapp-square'=>'whatsapp-square'),
array('fab fa-whmcs'=>'whmcs'),
array('fab fa-wikipedia-w'=>'wikipedia-w'),
array('fab fa-windows'=>'windows'),
array('fab fa-wix'=>'wix'),
array('fab fa-wizards-of-the-coast'=>'wizards-of-the-coast'),
array('fab fa-wolf-pack-battalion'=>'wolf-pack-battalion'),
array('fab fa-wordpress'=>'wordpress'),
array('fab fa-wordpress-simple'=>'wordpress-simple'),
array('fab fa-wpbeginner'=>'wpbeginner'),
array('fab fa-wpexplorer'=>'wpexplorer'),
array('fab fa-wpforms'=>'wpforms'),
array('fab fa-wpressr'=>'wpressr'),
array('fab fa-xbox'=>'xbox'),
array('fab fa-xing'=>'xing'),
array('fab fa-xing-square'=>'xing-square'),
array('fab fa-y-combinator'=>'y-combinator'),
array('fab fa-yahoo'=>'yahoo'),
array('fab fa-yammer'=>'yammer'),
array('fab fa-yandex'=>'yandex'),
array('fab fa-yandex-international'=>'yandex-international'),
array('fab fa-yarn'=>'yarn'),
array('fab fa-yelp'=>'yelp'),
array('fab fa-yoast'=>'yoast'),
array('fab fa-youtube'=>'youtube'),
array('fab fa-youtube-square'=>'youtube-square'),
array('fab fa-zhihu'=>'zhihu'),
)
    );

    // Return icons.
    return $fapro_icons;
}
add_filter( 'vc_iconpicker-type-fapro', 'vc_iconpicker_type_fapro' );


// Enqueue the CSS file so that the icons display in the backend editor.
function enqueue_fapro_font() {
    wp_enqueue_style( 'agilechilli-font-awesome', 'https://pro.fontawesome.com/releases/v5.12.0/css/all.css' );
}
add_action( 'vc_backend_editor_enqueue_js_css', 'enqueue_fapro_font' );