<?php
defined( 'ABSPATH' ) || exit;

/** config import for Studiare */
add_filter( 'studi_importer_demo_plugins', 'studiare_importer_plugins' );
add_filter( 'studi_importer_theme_option_name', 'studiare_theme_option_name' );
add_filter( 'studi_importer_demo_name', 'studiare_importer_demo_name' );
add_action( 'studi_importer_before_content', 'studiare_importer_duplicate_menus' );
add_action( 'studi_importer_before_widgets', 'studiare_importer_init_widgets' );
add_action( 'studi_importer_content_settings', 'studiare_importer_setup_content', 10, 1 );
add_action( 'studi_importer_content_settings', 'studiare_importer_setup_category', 20, 2 );
add_action( 'studi_importer_after_theme_options', 'studiare_importer_remove_cache' );
add_action( 'studi_importer_header', 'studiare_importer_header' );

/** setup plugins */
if ( ! function_exists( 'studiare_importer_plugins' ) ) {
	function studiare_importer_plugins( $directory ) {

		switch ( $directory ) {
			default :
				return false;
		}
	}
}

/** theme options */
if ( ! function_exists( 'studiare_theme_option_name' ) ) {
	function studiare_theme_option_name() {

		//return 'studiare_theme_options';
		return 'codebean_option';
	}
}

/** setup content */
if ( ! function_exists( 'studiare_importer_demo_name' ) ) {
	function studiare_importer_demo_name( $directory ) {

		switch ( $directory ) {
			
			default:
				return $directory;
		}
	}
}

/** setup content */
if ( ! function_exists( 'studiare_importer_setup_content' ) ) {
	function studiare_importer_setup_content( $directory ) {

		$homepage = '';
		if ( defined( 'ELEMENTOR_VERSION' ) ) {
			switch ( $directory ) {
				case '11' :
					$homepage = 'Elementor Recipe';
					break;
				case '12' :
					$homepage = 'Elementor Fashion';
					break;
				case '13' :
					$homepage = 'Elementor Tech';
					break;
				case '14' :
					$homepage = 'Elementor Travel';
					break;
				case '15' :
					$homepage = 'Elementor Lifestyle';
					break;
				case '16' :
					$homepage = 'Elementor Photography';
					break;
				case '17' :
					$homepage = 'Elementor Baby';
					break;
				case '18' :
					$homepage = 'Elementor Blogger';
					break;
				case '19' :
					$homepage = 'Elementor Work';
					break;
				case '20' :
					$homepage = 'Elementor Food';
					break;
				case '21' :
					$homepage = 'Elementor Gadget';
					break;
				case '22' :
					$homepage = 'Elementor Review';
					break;
				case '23' :
					$homepage = 'Elementor Fdeal';
					break;
				case '24' :
					$homepage = 'Elementor Freebie';
					break;
				case '25' :
					$homepage = 'Elementor Sport';
					break;
				case '26' :
					$homepage = 'Elementor RTL';
					break;
				case '27' :
					$homepage = 'Elementor Decor';
					break;
				case '28' :
					$homepage = 'Elementor Beauty';
					break;
				case '29' :
					$homepage = 'Elementor Medical';
					break;
				case '30' :
					$homepage = 'Elementor Yoga';
					break;
				case '31' :
					$homepage = 'Elementor Marketing';
					break;
				case '32' :
					$homepage = 'Elementor App';
					break;
				case '33' :
					$homepage = 'Elementor Game';
					break;
				case '34' :
					$homepage = 'Home Tutorial';
					break;
				case '35' :
					$homepage = 'Home Howtos';
					break;
				case '36' :
					$homepage = 'Home Podcast';
					break;
				case '37' :
					$homepage = 'Home Software';
					break;
				case '38' :
					$homepage = 'Elementor Outfit';
					break;
				case '39' :
					$homepage = 'Elementor Military';
					break;
				case '40' :
					$homepage = 'Elementor Crypto';
					break;
				case '41' :
					$homepage = 'Home Wedding';
					break;
				case '42' :
					$homepage = 'Home Architecture';
					break;
				case '43' :
					$homepage = 'Home Mom';
					break;
				case '44' :
					$homepage = 'Home News';
					break;
				case '45' :
					$homepage = 'Home Wellness';
					break;
				case '46' :
					$homepage = 'Home Today';
					break;
				case '47' :
					$homepage = 'Home Tasty';
					break;
			}
		} else {
			switch ( $directory ) {
				case '11' :
					$homepage = 'Home Recipe';
					break;
				case '12' :
					$homepage = 'Home Fashion';
					break;
				case '13' :
					$homepage = 'Home Tech';
					break;
				case '14' :
					$homepage = 'Home Travel';
					break;
				case '15' :
					$homepage = 'Home Lifestyle';
					break;
				case '16' :
					$homepage = 'Home Photography';
					break;
				case '17' :
					$homepage = 'Home Baby';
					break;
				case '18' :
					$homepage = 'Home Blogger';
					break;
				case '19' :
					$homepage = 'Home Work';
					break;
				case '20' :
					$homepage = 'Home Food';
					break;
				case '21' :
					$homepage = 'Home Gadget';
					break;
				case '22' :
					$homepage = 'Home Review';
					break;
				case '23' :
					$homepage = 'Home Fdeal';
					break;
				case '24' :
					$homepage = 'Home Freebie';
					break;
				case '25' :
					$homepage = 'Home Sport';
					break;
				case '26' :
					$homepage = 'Home RTL';
					break;
				case '27' :
					$homepage = 'Home Decor';
					break;
				case '28' :
					$homepage = 'Home Beauty';
					break;
				case '29' :
					$homepage = 'Home Medical';
					break;
				case '30' :
					$homepage = 'Home Yoga';
					break;
				case '31' :
					$homepage = 'Home Marketing';
					break;
				case '32' :
					$homepage = 'Home App';
					break;
				case '33' :
					$homepage = 'Home Game';
					break;
				case '34' :
					$homepage = 'Home Tutorial';
					break;
				case '35' :
					$homepage = 'Home Howtos';
					break;
				case '36' :
					$homepage = 'Home Podcast';
					break;
				case '37' :
					$homepage = 'Home Software';
					break;
				case '38' :
					$homepage = 'Elementor Outfit';
					break;
				case '39' :
					$homepage = 'Elementor Military';
					break;
				case '40' :
					$homepage = 'Elementor Crypto';
					break;
				case '41' :
					$homepage = 'Home Wedding';
					break;
				case '42' :
					$homepage = 'Home Architecture';
					break;
				case '43' :
					$homepage = 'Home Mom';
					break;
				case '44' :
					$homepage = 'Home News';
					break;
				case '45' :
					$homepage = 'Home Wellness';
					break;
				case '46' :
					$homepage = 'Home Today';
					break;
				case '47' :
					$homepage = 'Home Tasty';
					break;
			}
		}

		if ( ! empty( $homepage ) ) {
			$page = get_page_by_title( $homepage );
			if ( ! empty( $page->ID ) ) {
				update_option( 'page_on_front', $page->ID );
				update_option( 'show_on_front', 'page' );
				$blog = get_page_by_title( 'Blog' );
				if ( ! empty( $blog->ID ) ) {
					update_option( 'page_for_posts', $blog->ID );
				}
			} else {
				update_option( 'page_on_front', 0 );
				update_option( 'show_on_front', 'posts' );
			}
		}

		/** delete Hello word */
		// wp_delete_post( 1, true );

		/** setup WC */
		if ( class_exists( 'WC_Install' ) ) {
			WC_Install::create_pages();
		}

		/** setup menu */
		$main_menu   = get_term_by( 'name', 'main', 'nav_menu' );
		$mobile_menu = get_term_by( 'name', 'mobile', 'nav_menu' );
		$top_menu    = get_term_by( 'name', 'top', 'nav_menu' );

		$menu_locations = [];
		if ( isset( $main_menu->term_id ) ) {
			//$menu_locations['studiare_menu_main']      = $main_menu->term_id;
			//$menu_locations['studiare_menu_offcanvas'] = $main_menu->term_id;
			$menu_locations['main-menu']      = $main_menu->term_id;
		}
		if ( isset( $mobile_menu->term_id ) ) {
			$menu_locations['mobile-menu'] = $mobile_menu->term_id;
		}
		if ( !isset( $mobile_menu->term_id ) ) {
		    if ( isset( $main_menu->term_id ) ) {
			$menu_locations['mobile-menu'] = $main_menu->term_id;
		    }
		}
		
		if ( isset( $top_menu->term_id ) ) {
			//$menu_locations['studiare_menu_top'] = $top_menu->term_id;
			$menu_locations['top-bar-menu'] = $top_menu->term_id;
		}

		set_theme_mod( 'nav_menu_locations', $menu_locations );
	}
}

/** remove duplicated menu */
if ( ! function_exists( 'studiare_importer_duplicate_menus' ) ) {
	function studiare_importer_duplicate_menus() {

		$deleted_menus = [ 'main', 'mobile', 'top' ];
		foreach ( $deleted_menus as $menu ) {
			wp_delete_nav_menu( $menu );
		}

		return false;
	}
}

/** init widgets */
if ( ! function_exists( 'studiare_importer_init_widgets' ) ) {
	function studiare_importer_init_widgets() {

		//empty all sidebars
		$sidebars_widgets['studiare_sidebar_default']       = [];
		$sidebars_widgets['studiare_sidebar_offcanvas']     = [];
		$sidebars_widgets['studiare_sidebar_topsite']       = [];
		$sidebars_widgets['studiare_sidebar_single_top']    = [];
		$sidebars_widgets['studiare_sidebar_single_bottom'] = [];
		$sidebars_widgets['studiare_sidebar_fw_footer']     = [];
		$sidebars_widgets['studiare_sidebar_footer_1']      = [];
		$sidebars_widgets['studiare_sidebar_footer_2']      = [];
		$sidebars_widgets['studiare_sidebar_footer_3']      = [];

		/** add sidebars */
		$theme_options                          = get_option( 'studiare_theme_options' );
		$theme_options['studiare_multi_sidebar'] = [ 'sb1', 'sb2', 'infinite', 'single' ];

		update_option( 'sidebars_widgets', $sidebars_widgets );
		update_option( 'studiare_theme_options', $theme_options );

		/** register sidebar to import */
		register_sidebar( [
			'name'          => 'sb1',
			'id'            => 'studiare_sidebar_multi_sb1',
			'before_widget' => '<div id="%1$s" class="widget widget-sidebar %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		] );

		register_sidebar( [
			'name'          => 'sb2',
			'id'            => 'studiare_sidebar_multi_sb2',
			'before_widget' => '<div id="%1$s" class="widget widget-sidebar %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		] );

		register_sidebar( [
			'name'          => 'infinite',
			'id'            => 'studiare_sidebar_multi_infinite',
			'before_widget' => '<div id="%1$s" class="widget widget-sidebar %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		] );

		register_sidebar( [
			'name'          => 'single',
			'id'            => 'studiare_sidebar_multi_single',
			'before_widget' => '<div id="%1$s" class="widget widget-sidebar %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		] );

		register_sidebar( [
			'name'          => 'contact',
			'id'            => 'studiare_sidebar_multi_contact',
			'before_widget' => '<div id="%1$s" class="widget widget-sidebar %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		] );

		return false;
	}
}

/** setup category */
if ( ! function_exists( 'studiare_importer_setup_category' ) ) {
	function studiare_importer_setup_category( $directory, $path ) {

		$category_file = $path . 'categories.txt';
		$data          = [];

		if ( ! file_exists( $category_file ) ) {
			return false;
		}

		WP_Filesystem();
		global $wp_filesystem;
		$content  = $wp_filesystem->get_contents( $category_file );
		$settings = json_decode( $content, true );

		if ( ! is_array( $settings ) ) {
			return false;
		}

		$settings   = array_values( $settings );
		$categories = get_categories( [
			'hide_empty' => true,
			'info'       => 'post',
		] );
		$index      = 0;
		foreach ( $categories as $category ) {
			$id = $category->term_id;
			if ( isset( $settings[ $index ] ) ) {
				$data[ $id ] = $settings[ $index ];
			}
			$index ++;
		}

		update_option( 'studiare_meta_categories', $data );

		return false;
	}
}

/** remove css cache */
if ( ! function_exists( 'studiare_importer_remove_cache' ) ) {
	function studiare_importer_remove_cache() {

		delete_option( 'studiare_style_cache' );
		if ( function_exists( 'studiare_write_dynamic_css' ) ) {
			studiare_write_dynamic_css();
		}

		return false;
	}
}

if ( ! function_exists( 'studiare_importer_header' ) ) {
	function studiare_importer_header() {

		?>
		<div class="importer-header">
			<h2 class="importer-headline">
				<i class="dashicons dashicons-download"></i><?php _e( 'Import Studiare Demos' , 'studiare'); ?></h2>
			<div class="importer-desc">
				<p><?php  echo __( 'Importing the theme demo allows you to quickly edit everything instead of creating content from scratch. Please <strong>DO NOT navigate away</strong> from this page while the importer is processing. This may take up to 5 ~ 7 minutes, depending on the server speed.', 'studiare' );?></p>
				
			</div>
			<div class="importer-tips">
				<p><strong><?php  _e( 'Import Tips:', 'studiare' );?></strong></p>
				<p>- <?php  _e( 'Refresh this page and re-import if the process cannot complete after 5 minutes.', 'studiare' );?></p>
				<p>- <?php  _e( 'You can choose to import Only Pages, Widgets, and Theme Options if your site already has data.', 'studiare' );?></p>
				<p>-<?php  _e( "<strong>Don't need</strong> to install or activate Recommended & Optional plugins if you don't want to use them.", "studiare" );?>
				</p>
				<p>- <?php  _e( 'Install and activate the Woocommerce plugin before importing if you would like to set up a shop.', 'studiare' );?></p>
				<p>- <?php  _e( 'Online Documentation:', 'studiare' );?>
					<a href="https://docs.studiaretheme.ir/" target="_blank"><?php  _e( 'HERE', 'studiare' );?></a>
				</p>
			</div>
		</div>
		<?php
	}
}