<?php
/**
 * Default Single Teacher Post Template
 */
	if ( did_action( 'elementor/loaded' ) && \Elementor\Plugin::$instance->db->is_built_with_elementor( get_the_ID() ) ) {}else{ 
       add_filter('studi_custom_dynamic_css', function($css){
            $css .= "
            .teacher_lessons_list { transform: translateY(30px); }
            .studi_teacher-thumbnail img { border-radius: 10px; box-shadow: 0 0 10px var(--primary_color); background: var(--primary_color); padding: 10px; }
            a.studi_teacher_sbtn { font-size: 20px; color: var(--primary_color); margin: 0 5px; }
            a.studi_teacher_sbtn:hover { color: var(--secondary_color); }
            .stspadder{padding:10px 0;margin:10px 0;}
            .st_te_cou { display: flex ; align-content: center; justify-content: space-between; align-items: center; flex-wrap: wrap; }
            .st_te_cou_btn { display: flex ; flex-wrap: wrap; align-items: center; }
            .st_te_cou_btn i { margin: 0 10px; }
            .st_te_cou:before { content: ''; position: absolute; right: 0; top: 33px; width: 100%; height: 1px; z-index: -1; border-width: 1px 0 0 0; border-style: dashed; border-image: linear-gradient(to right, transparent 10%, var(--primary_color), transparent 90%) 1; }
            ";
            return $css;
        }); 
    }
get_header(); 

// Container start
$site_inner = array('site-content-inner container');
$container  = array('main-page-content default-margin');

?>
<div class="<?php echo esc_attr( implode( ' ', $container ) ); ?>" id="content">

	<div class="<?php echo esc_attr( implode( ' ', $site_inner ) ); ?>" role="main">

		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
			<div class="studi_teacher-single">

				<?php 
				// Check if the post was edited with Elementor
				if ( did_action( 'elementor/loaded' ) && \Elementor\Plugin::$instance->db->is_built_with_elementor( get_the_ID() ) ) {
					// If edited with Elementor, show the content normally
					the_content();
				} else {
					// If NOT edited with Elementor, show alternative content
					?>
					<div class="row studi_teacher-default-content">
					    <div class="container">
    						
    						
    						<div class="col-md-5 studi_teacher-thumbnail">
    							<?php the_post_thumbnail('large'); ?>
    						</div>
    						<div class="col-md-7">
        						<div class="studi_teacher-bio">
        						    <h2 class="stspadder"><?php the_title(); ?></h2>
        							<?php 
        							// You can use custom fields or the excerpt/content
        							the_content(); 
        							
        							// Or show specific custom fields if you have them
        							// echo get_post_meta(get_the_ID(), 'teacher_bio', true);
        							?>
        						</div>
        						<div class="studi_teacher-meta stspadder">
        							<?php
        							// Example of showing custom fields
        							if ($specialty = get_post_meta(get_the_ID(), '_studiare_teacher_job_title', true)) {
        								echo '<p><strong>'.__("Specialty","studiare").':</strong> ' . esc_html($specialty) . '</p>';
        							}
        							?>
        							<div class="studi_teacher_socials stspadder">
            							<?php
            							if ($facebook = get_post_meta(get_the_ID(), 'facebook', true)) {
            								echo '<a class="studi_teacher_sbtn" href="'.$facebook.'" target="_blank"> <i class="fab fa-facebook"></i></a>';
            							}
            							if ($twitter = get_post_meta(get_the_ID(), 'twitter', true)) {
            								echo '<a class="studi_teacher_sbtn" href="'.$twitter.'" target="_blank"> <i class="fab fa-twitter"></i></a>';
            							}
            							if ($googleplus = get_post_meta(get_the_ID(), 'google-plus', true)) {
            								echo '<a class="studi_teacher_sbtn" href="'.$googleplus.'" target="_blank"> <i class="fab fa-google-plus"></i></a>';
            							}
            							if ($linkedin = get_post_meta(get_the_ID(), 'linkedin', true)) {
            								echo '<a class="studi_teacher_sbtn" href="'.$linkedin.'" target="_blank"> <i class="fab fa-linkedin"></i></a>';
            							}
            							if ($youtube = get_post_meta(get_the_ID(), 'youtube', true)) {
            								echo '<a class="studi_teacher_sbtn" href="'.$youtube.'" target="_blank"> <i class="fab fa-youtube"></i></a>';
            							}
            							if ($telegram = get_post_meta(get_the_ID(), 'telegram', true)) {
            								echo '<a class="studi_teacher_sbtn" href="'.$telegram.'" target="_blank"> <i class="fab fa-telegram"></i></a>';
            							}
            							if ($instagram = get_post_meta(get_the_ID(), 'instagram', true)) {
            								echo '<a class="studi_teacher_sbtn" href="'.$instagram.'" target="_blank"> <i class="fab fa-instagram"></i></a>';
            							}
            							if ($whatsapp = get_post_meta(get_the_ID(), 'whatsapp', true)) {
            								echo '<a class="studi_teacher_sbtn" href="'.$whatsapp.'" target="_blank"> <i class="fab fa-whatsapp"></i></a>';
            							}
            							
            							?>
        							</div>
        						</div>
    						</div>
    <div class="col-md-12">
<?php 
        $desktop_clmn  = "4";
        $tablet_clmn   = "2";
        $mobile_clmn   = "1";
        
        $tid = get_the_ID();
        $args = [
            'post_type'      => 'product',
            'post_status'    => 'publish',
            'fields'         => 'ids',
            'posts_per_page' => 5,
            'meta_query'    => [
                [
                    'key'     => '_studiare_course_teachers',
                    'value'   => $tid,  // Note the quotes to match serialized format
                    'compare' => 'LIKE',
                ],
            ],
        ];
       
        
        $teachers = new WP_Query($args);
        
        $shop_page_url = get_permalink( wc_get_page_id( 'shop' ) );
        
?>

<?php if($teachers->have_posts()): ?>
    <div class="st_te_cou">
        <h3 class="stspadder"><?php echo __("Courses","studiare"); ?></h3>
        <a class="st_te_cou_btn" href="<?php echo $shop_page_url."?te=".$tid;?>"><span><?php echo __("View All","studiare"); ?></span><i class="fal fa-arrow-<?php echo $direction_by_lang;?>"></i></a>
    </div>
    <div class="teacher_lessons_list products owl-carousel owl-rtl <?php //echo esc_attr( $css_class ) . vc_shortcode_custom_css_class($css, ' '); ?>">

	    <?php while($teachers->have_posts()){ $teachers->the_post(); ?>

		    <?php get_template_part( 'woocommerce/content-product' ); ?>

	    <?php \wp_reset_postdata(); }//endwhile; 
	    
	    ?>
    </div>

<?php else: ?>

	<?php get_template_part( 'inc/templates/not-found' ); ?>

<?php endif; ?>
</div>						
<script>
jQuery(document).ready(function($) {
 
  $(".teacher_lessons_list.owl-carousel").owlCarousel({
    loop:false,
    nav:true,
    dots:true,
	navText: ["<i class='fal fa-arrow-right'></i>","<i class='fal fa-arrow-left'></i>"],
    responsive:{
                                0:{
                                    items:<?php echo $mobile_clmn;?>,
									nav:true,
                                },
                                768:{
                                    items:<?php echo $tablet_clmn;?>
                                },
                                1000:{
                                    items:<?php echo $desktop_clmn;?>
                                }
                            } 
                            
 
  });
 
});
</script>

        
    						
						</div>
					</div>
					<?php
				}
				?>

			</div>
		<?php endwhile; endif; ?>

	</div>

</div>

<?php get_footer(); ?>