<?php
// suncode localization file for estudiare plugins
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
function studiare_plugin_load_my_own_textdomain( $mofile, $domain ) {
    if ( 'revslider' === $domain && false !== strpos( $mofile, WP_LANG_DIR . '/plugins/' ) ) {
        $locale = apply_filters( 'plugin_locale', determine_locale(), $domain );
        $mofile = WP_PLUGIN_DIR . '/' . dirname( plugin_basename( __FILE__ ) ) . '/languages/revslider-fa_IR.mo';
    }
    return $mofile;
}
//add_filter( 'load_textdomain_mofile', 'studiare_plugin_load_my_own_textdomain', 10, 2 );

function studiare_revslider_data_get_font_familys( $fonts ) {

	$persian_fonts = [];

	//Web Safe fonts

	// Persian Fonts
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'sc_dana');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'sc_iran');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'sc_anjoman');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'sc_iransans');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'IRANSansX_SunCode');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'IRANSansX_English_Numbers');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'sc_iranyekan');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'sc_iransansdn');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Pelak');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Doran');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Azhdar');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'sc_mahboobeh');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Shabnam');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'scmahboobeh');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Shabnam-Bold');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'irsns-light-fa');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'irsns-regular-fa');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'irsns-bold-fa');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Lalezar-Regular');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'broyabold');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'rezvan');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'khodkar');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'DastNevis');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'BTitrBold');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'BYekan');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'BZar');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'BSinaBold');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'BZiba');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Javanweb');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Yekan_Bakh');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Modam');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'farhang_fa_num');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'rokh');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Peyda');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Shoor');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'ShoorRounded');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Azar');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Edameh');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'MahalWebFN');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Darvish');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Gozar');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'GramophoneFaNum-Clean');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'GramophoneFaNum-CleanCnd');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'GramophoneFaNum-Grunge');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'GramophoneFaNum-Stone');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'Kamand');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'PinarOne');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'PinarTwo');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'custom_one');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'custom_two');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'custom_three');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'custom_four');
			$fonts[] = array('type' => 'websafe', 'version' => __('Persian Fonts', 'revslider'), 'label' => 'custom_five');

	return wp_parse_args( $fonts, $persian_fonts );
}
add_filter( 'revslider_data_get_font_familys', 'studiare_revslider_data_get_font_familys' );
function studiare_add_rtl_studiare_front() {
	wp_enqueue_style( 'rtl-studiare-front', plugin_dir_url(__FILE__) . 'css/rtl-studiare-front.css' );
}
add_action( 'wp_enqueue_scripts', 'studiare_add_rtl_studiare_front' );

function suncode_admin_notice_warning() {

	if ( is_plugin_active( 'wp-events-manager-woo-payment/wp-events-manager-woo-payment.php' ) ) {
		?>
			<div class="notice notice-warning">
				<p>لطفا افزونه "WP Events Manager - WooCommerce Payment Methods Integration (افزونه اتصال مدیر رویدادها به ووکامرس)" را غیرفعال کنید (سپس پاک کنید) <br/>
از نگارش 12.4 به بالاتر دیگر نیازی به این افزونه نمی باشد.
</p>
			</div>
			
		<?php
	}
	if ( is_plugin_active( 'cmb2/init.php' ) ) {
		?>
			<div class="notice notice-warning">
لطفا افزونه CMB2 را غیرفعال نمایید. از نسخه 12.4 به بالاتر دیگر نیازی به این افزونه نمی باشد.
			</div>
			
		<?php
	}
	
	if ( is_plugin_active( 'breadcrumb-navxt/breadcrumb-navxt.php' ) ) {
		?>
			<div class="notice notice-warning">
لطفا افزونه عنوان ها و مسیرهای سایت  ( Breadcrumb NavXT) را غیرفعال نمایید. از نسخه 12.4 به بالاتر دیگر نیازی به این افزونه نمی باشد.
			</div>
			
		<?php
	}
	if ( is_plugin_active( 'wp-tab-widget/wp-tab-widget.php' ) ) {
		?>
			<div class="notice notice-warning">
لطفا افزونه تب های وردپرس  (  WP Tab Widget) را غیرفعال نمایید. از نسخه 12.4 به بالاتر دیگر نیازی به این افزونه نمی باشد.
			</div>
			
		<?php
	}
		if ( is_plugin_active( 'portfolio-post-type/portfolio-post-type.php' ) ) {
		    ?>
			<div class="notice notice-warning">
				<p>لطفا افزونه پست تایپ نمونه کار (Portfolio Post Type) را غیرفعال سپس حذف نمایید.
از نگارش 12.4 به بالاتر دیگر نیازی به این افزونه نمی باشد.
</p>
			</div>
			
		<?php
	
}

}
add_action( 'admin_notices', 'suncode_admin_notice_warning' );

# Prtfolio Override
function override_portfolio_post_type_and_taxonomies() {
    global $codebean_option;

    $slug = isset($codebean_option['portfolio_slug']) && !empty($codebean_option['portfolio_slug']) ? $codebean_option['portfolio_slug'] : 'portfolio';
    $category_slug = isset($codebean_option['portfolio_category_slug']) && !empty($codebean_option['portfolio_category_slug']) ? $codebean_option['portfolio_category_slug'] : 'portfolio_category';
    $tag_slug = isset($codebean_option['portfolio_tag_slug']) && !empty($codebean_option['portfolio_tag_slug']) ? $codebean_option['portfolio_tag_slug'] : 'portfolio_tag';

    $singular_name = isset($codebean_option['portfolio_singular_name']) && !empty($codebean_option['portfolio_singular_name']) ? $codebean_option['portfolio_singular_name'] : __('Portfolio', 'studiare-core');
    $plural_name = isset($codebean_option['portfolio_plural_name']) && !empty($codebean_option['portfolio_plural_name']) ? $codebean_option['portfolio_plural_name'] : __('Portfolios', 'studiare-core');

    $labels = array(
        'name' => $plural_name,
        'singular_name' => $singular_name,
        'menu_name' => $plural_name,
        'name_admin_bar' => $singular_name,
        'add_new' => __('Add New', 'studiare-core'),
        'add_new_item' => __('Add New ' . $singular_name, 'studiare-core'),
        'new_item' => __('New ' . $singular_name, 'studiare-core'),
        'edit_item' => __('Edit ' . $singular_name, 'studiare-core'),
        'view_item' => __('View ' . $singular_name, 'studiare-core'),
        'all_items' => __('All ' . $plural_name, 'studiare-core'),
        'search_items' => __('Search ' . $plural_name, 'studiare-core'),
        'not_found' => __('Not Found', 'studiare-core'),
        'not_found_in_trash' => __('Not found in Trash', 'studiare-core'),
    );

    $args = array(
        'labels' => $labels,
        'public' => true,
        'rewrite' => array('slug' => $slug),
        'has_archive' => true,
        'supports' => array('title', 'editor', 'thumbnail'),
    );

    register_post_type('portfolio', $args);

    $category_labels = array(
        'name' => __('Categories', 'studiare-core'),
        'singular_name' => __('Category', 'studiare-core'),
        'search_items' => __('Search Categories', 'studiare-core'),
        'all_items' => __('All Categories', 'studiare-core'),
        'parent_item' => __('Parent Category', 'studiare-core'),
        'parent_item_colon' => __('Parent Category:', 'studiare-core'),
        'edit_item' => __('Edit Category', 'studiare-core'),
        'update_item' => __('Update Category', 'studiare-core'),
        'add_new_item' => __('Add New Category', 'studiare-core'),
        'new_item_name' => __('New Category Name', 'studiare-core'),
        'menu_name' => __('Category', 'studiare-core'),
    );

    $category_args = array(
        'hierarchical' => true,
        'labels' => $category_labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array('slug' => $category_slug),
    );

    register_taxonomy('portfolio_category', array('portfolio'), $category_args);

    $tag_labels = array(
        'name' => __('Tags', 'studiare-core'),
        'singular_name' => __('Tag', 'studiare-core'),
        'search_items' => __('Search Tags', 'studiare-core'),
        'popular_items' => __('Popular Tags', 'studiare-core'),
        'all_items' => __('All Tags', 'studiare-core'),
        'edit_item' => __('Edit Tag', 'studiare-core'),
        'update_item' => __('Update Tag', 'studiare-core'),
        'add_new_item' => __('Add New Tag', 'studiare-core'),
        'new_item_name' => __('New Tag Name', 'studiare-core'),
        'separate_items_with_commas' => __('Separate tags with commas', 'studiare-core'),
        'add_or_remove_items' => __('Add or remove tags', 'studiare-core'),
        'choose_from_most_used' => __('Choose from the most used tags', 'studiare-core'),
        'menu_name' => __('Tags', 'studiare-core'),
    );
    $tag_args = array(
        'hierarchical' => false,
        'labels' => $tag_labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var' => true,
        'rewrite' => array('slug' => $tag_slug),
    );

    register_taxonomy('portfolio_tag', 'portfolio', $tag_args);
}

add_action('init', 'override_portfolio_post_type_and_taxonomies', 101);