var StudiareChatTemplate;

   
   
(function($) {
    "use strict";
    
    const { __, _x, _n, sprintf } = wp.i18n;
  
    StudiareChatTemplate = (function() {
        
        return {
            
            extractTime:function(microtime) {
	

                  const milliseconds = microtime * 1000;
    
       
                const date = new Date(milliseconds);
                
              
                let hours = date.getHours();
                const minutes = date.getMinutes().toString().padStart(2, '0');
                
              
                //const period = hours >= 12 ? 'PM' : 'AM';
                //hours = hours % 12 || 12;//suncode
                //hours = hours.toString().padStart(2, '0');//suncode
               
                return `${hours}:${minutes} `;//suncode ${period}
            
            },
            
            
               
            conversation_header:function(data) {
             
                var data = {
                    'thread_id':data.thread_id,
                    'sender_id':data.sender_id,
                    'name':data.recipients[data.sender_id].user_name,
                    'is_online':data.recipients[data.sender_id].is_online === true ? stc_chat.online_text : stc_chat.offline_text, //suncode
                    'is_online_status':data.recipients[data.sender_id].is_online === true ? 'active' : '',
                    'user_start':data.user_start === true ? true : false,
                    'is_report':data.recipients[data.sender_id].is_report === true ? true : false, 
                    'subject' : data.subject ? data.subject : 'thread',  
                    'recipients': data.recipients ? data.recipients : '',  
                    'type': data.type ? data.type : 'thread',
                }
                //console.log(data); //javad
                const totalUsers = Object.keys(data.recipients).length;
                const onlineUsers = Object.values(data.recipients).filter(function(user) {
                    return user.is_online; 
                });
                let name = '';
                let online_text = '';
                
                if(data.type == 'group') {  
                   name = data.subject; 
                   online_text = ''+totalUsers+' '+stc_chat.participants_text + ' ( '+ onlineUsers.length +' '+ stc_chat.online_text +')'; //suncode
                    
                } else {
                   name = data.name;
                   online_text = data.is_online;  
                }
                
                
                 var html = `
                     
                        <div class="conversation-h-left">
                            <div class="back-conversation"><i class="stc-icon-caret-left-light"></i></div> 
                            <div class="header-reply-name">${name ? `${name}` : stc_chat.user_removed_text }</div>
                            <span>${online_text}</span>
                        </div>
                        <div class="conversation-h-right">
                            ${data.user_start ? 
                            `
                            <div class="conversation-action">
                                <button type="button" class="btn-dropdown"><i class="fal fa-ellipsis-h"></i>
                                </button>
                                <div class="menu-dropdown">
                                 <a class="delete-conversation" href="javascript:void(0);" data-conversation="${data.thread_id}"><i class="fal fa-trash"></i>${stc_chat.delete_conversation}</a>
                                </div>
                            </div>
                            ` 
                            : '' }
                        </div>
                   
                `;
                     
                
                
                return  html;       
         
                
            },
   
            conversation_item:function(data) {
                
                var current_conversation = $('.stc-chat-members').attr('data-conversation'); 
       
                var data = {
                    'thread_id':data.thread_id,
                    'avatar':data.recipients[data.sender_id].avatar,
                    'name':data.recipients[data.sender_id].user_name,
                    'time':data.display_time,
                    'last_message':data.last_message,
                    'sender_text':data.is_me == 'me'  ? 'You' : data.recipients[data.sender_id].user_name,
                    'unread': data.unread ? data.unread : '',
                    'type': data.type ? data.type : 'thread',
                    'subject' : data.subject ? data.subject : 'thread', 
                    'recipients': data.recipients ? data.recipients : '',
                    'last_message_sender' : data.last_message_sender 
                }
              
                var class_item = (current_conversation == data.thread_id ) ? 'conversation-item active' : 'conversation-item';
                
                let avatart = '';
                let name = '';
                let last_mess = '';
             
                if(data.type == 'group') {
                    
                    
                    Object.values(data.recipients).slice(0, 4).forEach(function(value) {  
                     
                         avatart += `   
                        
                           <img class="${data.name}" src="${value.avatar}">
                
                        `;
                        
                    });
                    
                    name = data.subject;
                    
                    if(data.last_message_sender != '') {
                       last_mess += `<img src="${data.recipients[data.last_message_sender].avatar}">`; 
                    }
                    last_mess += data.last_message;
                    
                     
                                      
                } else {
                    
                     avatart += `   
                    
                       <img src="${data.avatar}">
            
                    `;
                    
                    name = data.name;
                    
                    last_mess = data.last_message;
                    
                }
        
                      
                 var html = `
                     <div class="${class_item} ${data.type}" data-conversation="${data.thread_id}">
                       <div class="users-avatar">
                          ${avatart}
                        </div>
                       <div class="users-info">
                          <h6>
                          ${name ? `${name}` : stc_chat.user_removed_text }
                          <span class="chat-status">${data.time}</span></h6>
                           <div class="last-messages ${data.unread >= 1?`new` :''}">
                               ${last_mess}
                               ${data.unread >= 1 ? 
                               `<span class="unread">${data.unread}</span>` 
                             : '' }
                           </div>
                       </div>
                     
                     </div>
                `;
                     
                
                
                return  html;       
         
                
            },
            
            message_date:function(data) { 
                
                
            },
            
            message_item:function(message,thread) {
               
                var data = {
                    'id':message.id,
                    'avatar':thread.recipients[message.sender_id].avatar,
                    'name':thread.recipients[message.sender_id].user_name,
                    'time':message.time,
                    'content':message.content,
                    'is_me':message.is_me,
                    'is_online':thread.recipients[message.sender_id].is_online === true ? 'active' : '',
                }
                let actionHtml = '';
                
                let like = '';
                
              
                
                const date_time = StudiareChatTemplate.extractTime(message.last_date);
                
               
                
                
                
                if(data.is_me == 'orther') {
                    
                     like = `   
                    
                     ${message.is_like ? 
                       ` <i class="stc-icon-heartfill"></i>` 
                     : `<div class="like-mess"><i class="stc-icon-heartfill"></i></div>` }
            
                    `;  
                                      
                } else {
                    
                    like = `   
                    
                     ${message.is_like ? 
                       ` <i class="stc-icon-heartfill"></i>` 
                     : '' }
            
                    `;
                    
                }
                
                 if(message.is_deleted) {
                    
                    actionHtml = stc_chat.message_deleted_text;
                    
                } else if(message.content == 'gift') {
                    
                    actionHtml = `<div class="gift-image"><img src="${message.gift}"></div>`;
                    
                } else if(message.content == 'gif') {
                    
                  actionHtml = `
                    <div class="gif-player"> <video preload="auto" playsinline="" autoplay="" loop="" muted="" poster="${message.gif.image_url}">
    					<source src="${message.gif.video_url}" type="video/mp4">
    				</video>
                    </div>
                    `;
                    
                } else if(message.content == 'media') { 
                    
                     
                   message.media.forEach(function(media) { 

                     if( media.type == 'image' ) {
                        
                        actionHtml += `
                        
                        
                       <img src="${media.url}" alt="${media.name}">
                        
                        
                        
                        `;
                        
                     } else if( media.type == 'video' ) {
                        
                         actionHtml += `
                              <video controls>
                                <source src="${media.url}" type="${media.mime_type}">
                             </video>
                        `;     
                            
                     } else if( media.type == 'audio' ) {
                        
                         actionHtml += `
                              <audio controls>
                                <source src="${media.url}" type="${media.mime_type}">
                              </audio>
                        `;     
                            
                     }
         
                  });
                    
                    
                } else {
                    
                    actionHtml = data.content;
                    
                }
            
                      
                 var html = `
               
                     <div class="message-item ${data.is_me}" data-id="${data.id}">
                        <div class="users-avatar ${data.is_online}">
                            <img src="${data.avatar}"> 
                        </div>
                        <div class="messasge-container">
                            <div class="messasge-content">
                                <div class="message-top"> 
                                    <div class="name">${data.name}</div>
                                    <div class="time">${date_time}</div>
                                </div>
                                <div class="message-wrap">
                                    ${message.reply ? 
                                      `<div class="reply-text">${message.reply}</div>` 
                                   : '' }
                                   ${message.is_deleted ? 
                                      ''
                                   : `${like}` }
                                    
                                    <div class="message">
                                       ${actionHtml}
                                    </div>
                                    ${message.is_deleted ? 
                                      ''
                                   : `<div class="mess-edit"><i class="fal fa-ellipsis-h"></i></div>` }
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                `;
                     
                
                
                return  html;       
         
                
            },
         
            
            form_send_chat:function(data) {
                
                var data = {
                    'thread_id':data.thread_id,
                }
       
                     
                 var html = `
                     <div class="stc-messages-action">
                         <textarea id="message-input" name="message_content" class="form-input"></textarea>
                         <input id="gift-input" class="form-input" name="message_gift" type="hidden"> 
                         <input id="enmoji-input" class="form-input" name="message_enmoji" type="hidden"> 
                         <input type="hidden" name="thread_id" value="${data.thread_id}"  />
                         <div class="meassage-tool">
                                <div id="stc-file-container"></div>
                                <div id="stc-gift-container"></div>
                                <div id="stc-gif-container">
                                    <input type="text" id="search-giphy" placeholder="${stc_chat.search_gif}">
                                    <div class="gif-wap stc-scrollbar"><div class="gif-row"></div></div>
                                </div>
                             <div class="meassage-media">
                                 ${ stc_chat.chat_emojies == '1' ? 
                                       `<div id="send-emoji" class="button"></div>` 
                                 : '' }
                                ${ stc_chat.chat_gif == '1' ? 
                                       `<button id="send-gif" class="button"  type="button"><span><i class="fal fa-image"></i></span></button>` 
                                 : '' }
                                ${ stc_chat.chat_file == '1' ? 
                                       `<button id="send-file" type="button" class="button"><i class="fal fa-paperclip"></i></button>` 
                                 : '' }
                             </div>
                             <button type="submit" disabled>
                                <span class="text"><i class="fal fa-chevron-down"></i><span>${stc_chat.send}</span></span>
                             </button>   
                         </div>
                    </div>
                `;
                     
                
                
                return  html;       
         
                
            },
            
            tab_create_conversation:function() { 
                
               var html = `
                    <div class="stc-filter-empty empty">
                   
                        <form class="stc-message-form-search-user">
                            <input type="text" name="subject" placeholder="` + stc_chat.subject_placeholder + `" value="" />
                            <select class="search-user" multiple="true" name="users[]"></select>
                            <button class="btn btn-solid" type="submit"><span>` + stc_chat.create_conversation + `</span></button>
                        </form>
                    </div>
                `;
                            
               return  html;
        
            }
            
            
         }   
            
    }());      
         
})(jQuery);            