<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if ( !class_exists( 'Studiare_Chat_View' ) ) {
    class Studiare_Chat_View { 

        public static function instance() {
            // Store the instance locally to avoid private static replication
            static $instance = null;
            // Only run these methods if they haven't been run previously
            if ( null === $instance ) {
                
                $instance = new Studiare_Chat_View();
  
            }
            // Always return the instance
            return $instance;
            // The last metroid is in captivity. The galaxy is at peace.
        }
        
        public function __construct() { 
            
            
              add_shortcode('stc_chat',array($this,'get_chat_html'));
            
        }


   
     
      public function stc_form_create_messages($thread_id = '') {
       
            $is_owner = stc_check_owner_conversation($thread_id);

            ?>
            
          <div class="conversation-header">
              
          </div>
            
            <div class="row-messages-list-container">
            <div class="messages-list-container">
            <div id="messages-list" class="stc-scrollbar">
              <div id="messages-inner">
              
                <?php
                 
                 if(!$is_owner) { 
                        ?> 
                     <div class="stc-filter-empty empty">
                        
                        <div class="start-conversation">
                         
                        <i class="stc-icon-chatscircle"></i>
                        <h6><?php echo esc_html__('Select a new conversation to display','studiare-core'); ?></h6>
                        <p><?php echo esc_html__('or','studiare-core') ?></p>
                        <a href="javascript:void(0)" class="button"><?php echo esc_html__('Start a new conversation!','studiare-core'); ?></a>
                        
                        </div>
                      
                        <form class="stc-message-form-search-user">
                            
                            <input type="text" name="subject" placeholder="<?php echo esc_attr__('Subject','studiare-core'); ?>" value="" />
                            <select class="search-user" multiple="true" name="users[]"></select>
                            <button class="btn btn-solid" type="submit"><span><?php echo esc_html__('Create Conversation','studiare-core'); ?></span></button>
                         
                         </form>
                        
                     </div>
                     
                    
                    
                    <?php
                    
                 }
                
                
                 ?>
              
              
              </div>
            </div>
            <form id="form-create-messages">
  
            </form>
            </div>
         
            
            </div> 
            <?php
   
            
     }
     
     public function get_attachment_file($attachment_id) { 
        
            $attachment_metadata = wp_get_attachment_metadata($attachment_id);
            $attachment_url = wp_get_attachment_url($attachment_id);
            $attachment_mime_type = get_post_mime_type($attachment_id);
            $file_name = basename($attachment_url);
            if (strpos($attachment_mime_type, 'image/') !== false) {
               
                echo '<img src="' . esc_url($attachment_url) . '" alt="'.$file_name.'">';
                
            } elseif (strpos($attachment_mime_type, 'video/') !== false) {
               
                 echo '<video controls>
                    <source src="' . esc_url($attachment_url) . '" type="' . esc_attr(get_post_mime_type($attachment_id)) . '">
                 </video>';
                 
            } elseif ($attachment_mime_type === 'audio/mpeg') {
              
                echo '<audio controls>
                <source src="' . esc_url($attachment_url) . '" type="' . esc_attr(get_post_mime_type($attachment_id)) . '">
              </audio>';
               
            } else {
                
                echo '<a href="' . esc_url($attachment_url) . '">' . esc_html($file_name) . '</a>';

            }
        
     }
     
     public function stc_get_messages_reply($message) { 
    
       $reply = stc_get_message_meta( $message , 'reply'); 
        
       if($reply) {
        
        $message = stc_get_message_item_data($reply);
                    
        ?>
        
          <div class="reply-text">
        
             <?php 
              
              if($message->message == 'gift') {
        
               }elseif($message->message == 'gif') {
                 
               } elseif($message->message == 'media') {
              
               }  else {
                  echo $message->message; 
               }
             
             ?>
          </div>
        
        <?php
        
        }
        
     }
     
     public function stc_get_messages_item($message) {  
        
         $current_user_id = get_current_user_id();
       
         $position = $message->sender_id == $current_user_id ? 'me' : 'orther';
         
         $delete = stc_get_message_meta($message->id , 'delete');
         
         
         if($delete) $position.= ' deleted';
         
         
        
        ?>

         <div class="message-item <?php echo $position; ?>" data-id="<?php echo $message->id; ?>">
                       
              <div class="users-avatar">
                   <?php stc_get_avatar_messages($message->sender_id); ?>
              </div>
              <div class="messasge-container">
              <?php   
                 
                     $this->stc_get_messages_reply($message->id);
                     
               
               ?> 
              <div class="messasge-content">
                  <div class="message-wrap">
                   <?php $liked = stc_get_message_meta($message->id, 'liked'); if($liked) echo '<i class="stc-icon-heartfill"></i>'; ?>
                  <?php 
                    if($position == 'orther' && !$liked) {
                        echo '<div class="like-mess"><i class="stc-icon-heartfill"></i></div>';
                    }
                  ?>
                   <div class="message">
                   
                      <?php
                 
                       if($delete) {
                        
                         echo esc_html__('This message was deleted','studiare-core');
                      
                        
                       } else {
                          
                              
                           if($message->message == 'gift') {
                              $post_id = stc_get_message_meta($message->id , 'send_gift');
                              $image = get_post_meta($post_id,'thumbnail',true);
                              ?> <div class="gift-image"> <?php
                              echo wp_get_attachment_image( $image, 'thumbnail' );
                              ?> </div> <?php
                           }elseif($message->message == 'gif') {
                              $video_info = stc_get_message_meta($message->id , 'send_gif');
                              $gif_info = json_decode(stripslashes($video_info), true);
                              ?>
                            
                              <div class="gif-player">
    								<video preload="auto" playsinline="" autoplay loop muted poster="<?php echo isset($gif_info['image_url']) ? $gif_info['image_url'] : '';  ?>">
    									<source src="<?php echo isset($gif_info['video_url']) ? $gif_info['video_url'] : '';  ?>" type="video/mp4">
    								</video>
    						  </div>
                              <?php
                           } elseif($message->message == 'media') {
                              $media = stc_get_message_meta($message->id , 'send_media');
                              $media = explode(",",$media);
                              if(!empty($media)) {
                                 ?> <div class="file-media"> <?php
                                 foreach($media as $id) {
                                       
                                       $this->get_attachment_file($id);
                                       
                                 }
                                 ?> </div> <?php
                              }
                           }  else {
                              echo esc_html($message->message); 
                           }
                        
                       }
                  
                 
                       ?> 
                   </div>
                   <?php
               
                       if(!$delete) { 
                        
                         echo '<div class="mess-edit"><i class="stc-icon-dotsthreeoutline"></i></div>';
                         
                       }
                      
                       ?>
                   </div>
                   <div class="time"> <?php  echo date('h:i A', $message->created_at);  ?> </div>
              </div> 
              </div>
    
              

              
          </div>
         
        <?php
        
     }
     
 
      
     public function stc_get_conversation_messages($thread_id) { 
        
        global $wpdb;

        
        $table_name = stc_get_table('messages'); 
   
        $query = $wpdb->prepare(
            "SELECT * FROM $table_name 
            WHERE thread_id = %d 
            ORDER BY created_at ASC", 
            $thread_id
        );
        
        $messages = $wpdb->get_results($query);
        
        if ($messages) { 

           return $messages; 
            
        } else {
            
           return false;
            
        }
        
        
        
        
     }
        
     public function get_chat_html() {
          
     $thread_id = isset($_REQUEST['conversation']) ? $_REQUEST['conversation'] : '';
     $check = stc_get_last_messages($thread_id);
    
    
        $current_user_id = get_current_user_id();
 
        $stc_user_settings = get_user_meta($current_user_id, 'stc_user_settings', true);
   
        $args = wp_parse_args( $stc_user_settings, array('online_now'  => 'on'));
        extract( $args ); 
        ob_start(); 
   
        
     ?>

      <div class="row stc-chat-members<?php echo !empty($thread_id) ? ' loaded' : ''; ?>" data-conversation="<?php echo esc_attr($thread_id); ?>" data-total=<?php echo esc_attr(stc_get_messages_total_count($thread_id)) ?>>
     
       <div class="col-lg-4 col-xl-4 chat-sidebar">
          <div class="conversation-sd-top" aria-label="<?php echo esc_attr__('New Conversation','studiare-core'); ?>">
          <div class="create-new-conversation"> <i class="fal fa-edit"></i> </div>
          <form id="form-search-conversation">
          
                <input type="text" name="search" placeholder="<?php echo esc_attr_x( 'Search conversation', 'placeholder', 'studiare-core' ); ?>" onkeyup="search_conversation()" autocomplete="off" />
                <i aria-hidden="true" class="fal fa-search"></i>
                <script type="text/javascript">
                	function search_conversation() {
                
                	    var filter, ul, text, found = 0;
                
                	    filter 		= jQuery( "#form-search-conversation [name='search']" ).val().toUpperCase();
                        var list = jQuery('.conversation-list');
                	    list.find( '.conversation-item h6' ).each(function(i){
                	    	text = jQuery( this ).text().toUpperCase().indexOf(filter);
                	    	if ( text > -1 ) {
                	    		jQuery(this).closest( '.conversation-item' ).css( 'display', 'flex' );
                	    		found++;
                	    	}else{
                	    		jQuery(this).closest( '.conversation-item' ).css( 'display', 'none' );
                	    	}
                	    });
                
                	    if( found == 0 ){
                	    	var notFound = '<div class="not-found p">Not found</div>';
                
                	    	if( list.find( 'div.not-found' ).length == 0 ){
                	    		list.append( notFound );	
                	    	}
                	    }else{
                	    	list.find( 'div.not-found' ).remove();
                	    }
                	}
                       document.getElementById("form-search-conversation").addEventListener("keydown", function(event) {
                         
                            if (event.key === "Enter") {
                              
                                event.preventDefault();
                            }
                        });
                </script>
          
          </form>
          </div>
          <div class="conversation-list stc-scrollbar">
       
            
                                    
          </div>
          
          <?php 
          
         
          
          ?>
       </div>
       
       <div class="col-lg-8 col-xl-8 chat-content">
       <?php
         
          
              $this->stc_form_create_messages($thread_id);
       
           
     
       ?>

       </div>
      
      
      </div>
     
     <?php
      $result = ob_get_clean(); 
      return $result;   
    }

    }
}



function Studiare_Chat_View() {
    return Studiare_Chat_View::instance();
}




