<?php
/** 
 * Mellipayamak start
 * SMS Provider for Mellipayamak
 **/

class MellipayamakProvider extends SC_SMSProvider {
    private $api_address;

    public function __construct($api_address) {
        $this->api_address = $api_address;
    }

    public function send_otp($phone) {
        $url = $this->api_address;
        $data = array('to' => $phone);
        $data_string = json_encode($data);
        $ch = curl_init($url);                          
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");                      
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Content-Length: ' . strlen($data_string)));
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }
} 

/** 
 * IPPanel start
 * SMS Provider for IPPanel
 **/
class IPPanelProvider extends SC_SMSProvider {
    private $api_address;

    public function __construct($api_address) {
        $this->api_address = $api_address;
    }
    
    
    public function send_otp($phone) {


        $myApi        = class_exists('Redux') ? codebean_option('ippanel_api_address') : '';
        $pattern_code = class_exists('Redux') ? codebean_option('ippanel_pattern_code') : '';
        $pattern_var  = class_exists('Redux') ? codebean_option('ippanel_pattern_variable') : '';
        $otp_rand     = rand(1001,9999);
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api2.ippanel.com/api/v1/sms/pattern/normal/send',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
            "code": "'.$pattern_code.'",
            "sender": "+983000505",
            "recipient": "'.$phone.'",
            "variable": {
                "'.$pattern_var.'":"'.$otp_rand.'"
                    }
        }',
          CURLOPT_HTTPHEADER => array(
            'apikey: '.$myApi.'',
            'Content-Type: application/json',
            )
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        if($response) {
            $responseObj = json_decode($response);
            $responseObj->code = $otp_rand;
            return json_encode($responseObj);
        }
        return $response;

    }
}  


/** 
 * FarazSMS start
 * SMS Provider for FarazSMS
 **/
class FarazsmsProvider extends SC_SMSProvider {

    public function __construct() {
    }
    
    
    public function send_otp($phone) {


        $myApi        = class_exists('Redux') ? codebean_option('farazsms_api_address') : '';
        $pattern_code = class_exists('Redux') ? codebean_option('farazsms_pattern_code') : '';
        $pattern_var  = class_exists('Redux') ? codebean_option('farazsms_pattern_variable') : '';
        $otp_rand     = rand(1001,9999);
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api2.ippanel.com/api/v1/sms/pattern/normal/send',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
            "code": "'.$pattern_code.'",
            "sender": "+983000505",
            "recipient": "'.$phone.'",
            "variable": {
                "'.$pattern_var.'":"'.$otp_rand.'"
                    }
        }',
          CURLOPT_HTTPHEADER => array(
            'apikey: '.$myApi.'',
            'Content-Type: application/json',
            )
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        if($response) {
            $responseObj = json_decode($response);
            $responseObj->code = $otp_rand;
            return json_encode($responseObj);
        }
        return $response;

    }
}  


/** 
 * SMS.ir start
 * SMS Provider for SMS.ir
 **/
class SMSIRProvider extends SC_SMSProvider {

    public function __construct() {
    }
    
    
    public function send_otp($phone) {


        $myApi        = class_exists('Redux') ? codebean_option('smsir_api_address') : '';
        $pattern_code = class_exists('Redux') ? codebean_option('smsir_pattern_code') : '';
        $pattern_var  = class_exists('Redux') ? codebean_option('smsir_pattern_variable') : '';
        $otp_rand     = rand(1001,9999);
        
        $curl = curl_init();

      curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.sms.ir/v1/send/verify',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
        "mobile": "'.$phone.'",
        "templateId": '.$pattern_code.',
        "parameters": [
          {
            "name": "'.$pattern_var.'",
            "value": "'.$otp_rand.'"
          }
          
        ]
      }',
        CURLOPT_HTTPHEADER => array(
          'Content-Type: application/json',
          'Accept: text/plain',
          'x-api-key: '.$myApi.''
        ),
      ));

      $response = curl_exec($curl);

      curl_close($curl);
      if($response) {
            $responseObj = json_decode($response);
            $responseObj->code = $otp_rand;
            return json_encode($responseObj);
        }
      return $response;

    }
}  

