<?php 
class SWSS_CustomStatusConfiguratorPage
{
	public function __construct(){}
	
	public function render_page()
	{
		global $swss_ticket_model, $swss_html_helper ;
		$print_result_message = false;
		if(isset($_POST) && !empty($_POST['wcts_statuses']))
		{
			$swss_ticket_model->save_statuses($_POST['wcts_statuses']);
			//swss_var_dump($_POST['wcts_statuses']);
			
			//if(isset($_POST['ticket_id']) || isset($_POST['user_id']))
			{
				$print_result_message = true;
			}
			/* elseif(!isset($_POST['ticket_id']) && !isset($_POST['user_id']))
			{
				echo '<div id="message" class="error"><p>'.__('Choose at least 1 user and/or 1 ticket.', 'sunticket').'</p></div>';
			} */
		}
		
		$statuses = $swss_ticket_model->get_available_statuses();
		//swss_var_dump($statuses);
		wp_enqueue_style( 'swss-common', SWSS_PLUGIN_PATH.'/css/backend-common.css');
		wp_enqueue_style( 'swss-custom-status', SWSS_PLUGIN_PATH.'/css/backend-custom-status-page.css');
	
		wp_register_script('swss-custom-status', SWSS_PLUGIN_PATH.'/js/backend-custom-status.js', array('jquery'));	
				$translation_array = array(
						'remove_custom_status_text' => __( 'Are you sure you want to remove it?', 'sunticket' )
		);
		wp_localize_script( 'swss-custom-status', 'swss', $translation_array );
		wp_enqueue_script('swss-custom-status');	
		?>
		<?php if($print_result_message ): ?>
			<div id="message" class="updated"><p><?php _e('Operation successfully performed.', 'sunticket'); ?></p></div>
		<?php endif; ?>
		<form action="" method="post" id="swss_assign_tickets_form">
			<div class="white-box">
								
					<h2 class="swss_title_with_border"><?php _e('Default statuses', 'sunticket');?></h2>
					<p><?php _e('Default statuses cannot be deleted.', 'sunticket');?></p>
					<?php 
						foreach($statuses as $id => $status)
							if(!$status['is_custom'])
							{
								$swss_html_helper->render_status_configuration($status);
							}
					?>
			
				<h2 class="swss_title_with_border_with_margin"><?php _e('Custom statuses', 'sunticket');?></h2>
				<p><?php _e('You can add or delete custom statuses in addition to existing ones.', 'sunticket');?></p>
				<div id="swss_custom_statuses_container">
					<?php 
						foreach($statuses as $id => $status)
							if($status['is_custom'])
							{
								$swss_html_helper->render_status_configuration($status);
							}
					?>
				</div>
				<img id="swss_preloader_image" src="<?php echo SWSS_PLUGIN_PATH.'/images/horizontal-15.gif' ?>" ></img>
				<button class="button-primary" id="swss_add_new_custom_status_button"><?php _e('Add new custom status', 'sunticket');?></button>		
			
				<p class="submit">
					<input type="submit" id="swss_submit_button" value="<?php _e('Save', 'sunticket');?>" class="button-primary" />
				</p>
			</div>
		</form>
		
		<?php
	}
}
?>