<?php
Redux::setSection( $opt_name, array(
    'title'  => esc_html__( 'Suncode Player', 'studiare' ),
    'id'     => 'suncode_player',
    'icon'   => 'fal fa-video',
    'desc'   => esc_html__( 'Settings for the Suncode Advanced Video and Audio Player.', 'studiare' ),
    'fields' => array(
        array(
            'id'       => 'enable_suncode_player',
            'type'     => 'switch',
            'title'    => esc_html__( 'Enable Suncode Player', 'studiare' ),
            'subtitle' => esc_html__( 'Enable or disable the Suncode Advanced Player for video and audio.', 'studiare' ),
            'default'  => false,
        ),

        array(
            'id'       => 'disable_mejs',
            'type'     => 'switch',
            'title'    => esc_html__( 'Disable MediaElement.js', 'studiare' ),
            'subtitle' => esc_html__( 'Disable the default WordPress MediaElement.js player when Suncode Player is enabled.', 'studiare' ),
            'default'  => false,
            'required' => array( 'enable_suncode_player', '=', true ),
        ),
        
        array(
            'id'       => 'enable_hls_support',
            'type'     => 'switch',
            'title'    => esc_html__( 'Enable HLS (m3u8) Support', 'studiare' ),
            'subtitle' => esc_html__( 'Enable support for HLS streaming (m3u8 files) using hls.js. Note: This adds approximately 400KB to page load.', 'studiare' ),
            'default'  => false,
            'required' => array( 'enable_suncode_player', '=', true ),
        ),

        array(
            'id'       => 'suncode_video_player_controls',
            'type'     => 'sorter',
            'title'    => esc_html__( 'Video Player Controls', 'studiare' ),
            'subtitle' => esc_html__( 'Organize and enable/disable controls for the Suncode Video Player.', 'studiare' ),
            'desc'     => esc_html__( 'Drag and drop to reorder or move controls to Disabled to hide them.', 'studiare' ),
            'required' => array( 'enable_suncode_player', '=', true ),
            'options'  => array(
                'enabled'  => array(
                    'play-large'    => esc_html__( 'Large Play Button', 'studiare' ),
                    'rewind'        => esc_html__( 'Rewind', 'studiare' ),
                    'play'          => esc_html__( 'Play/Pause', 'studiare' ),
                    'fast-forward'  => esc_html__( 'Fast Forward', 'studiare' ),
                    'progress'      => esc_html__( 'Progress Bar', 'studiare' ),
                    'mute'          => esc_html__( 'Mute/Unmute', 'studiare' ),
                    'volume'        => esc_html__( 'Volume', 'studiare' ),
                    'captions'      => esc_html__( 'Captions', 'studiare' ),
                    'airplay'       => esc_html__( 'AirPlay', 'studiare' ),
                    'current-time'  => esc_html__( 'Current Time', 'studiare' ),
                    'duration'      => esc_html__( 'Duration', 'studiare' ),
                    'restart'       => esc_html__( 'Restart', 'studiare' ),
                    'loop'          => esc_html__( 'Loop', 'studiare' ),
                    'quality'       => esc_html__( 'Quality', 'studiare' ),
                    'settings'      => esc_html__( 'Settings', 'studiare' ),
                    'fullscreen'    => esc_html__( 'Fullscreen', 'studiare' ),
                ),
                'disabled' => array(
                    'download'      => esc_html__( 'Download', 'studiare' ),
                    'pip'           => esc_html__( 'Picture-in-Picture', 'studiare' ),
                ),
            ),
        ),

        array(
            'id'       => 'suncode_audio_player_controls',
            'type'     => 'sorter',
            'title'    => esc_html__( 'Audio Player Controls', 'studiare' ),
            'subtitle' => esc_html__( 'Organize and enable/disable controls for the Suncode Audio Player.', 'studiare' ),
            'desc'     => esc_html__( 'Drag and drop to reorder or move controls to Disabled to hide them.', 'studiare' ),
            'required' => array( 'enable_suncode_player', '=', true ),
            'options'  => array(
                'enabled'  => array(
                    'play'          => esc_html__( 'Play/Pause', 'studiare' ),
                    'progress'      => esc_html__( 'Progress Bar', 'studiare' ),
                    'mute'          => esc_html__( 'Mute/Unmute', 'studiare' ),
                    'volume'        => esc_html__( 'Volume', 'studiare' ),
                    'settings'      => esc_html__( 'Settings', 'studiare' ),
                    'current-time'  => esc_html__( 'Current Time', 'studiare' ),
                    'duration'      => esc_html__( 'Duration', 'studiare' ),
                    
                    
                ),
                'disabled' => array(
                    'download'      => esc_html__( 'Download', 'studiare' ),
                    'restart'       => esc_html__( 'Restart', 'studiare' ),
                    'rewind'        => esc_html__( 'Rewind', 'studiare' ),
                    'loop'          => esc_html__( 'Loop', 'studiare' ),
                    'play-large'    => esc_html__( 'Large Play Button', 'studiare' ),
                    'fast-forward'  => esc_html__( 'Fast Forward', 'studiare' ),
                ),
            ),
        ),

        array(
            'id'       => 'suncode_player_tooltips',
            'type'     => 'switch',
            'title'    => esc_html__( 'Enable Tooltips', 'studiare' ),
            'subtitle' => esc_html__( 'Show tooltips for player controls and seek bar.', 'studiare' ),
            'default'  => true,
            'required' => array( 'enable_suncode_player', '=', true ),
        ),

        array(
            'id'       => 'suncode_player_watermark',
            'type'     => 'select',
            'title'    => esc_html__( 'Watermark Display', 'studiare' ),
            'subtitle' => esc_html__( 'Choose where to display the watermark on videos.', 'studiare' ),
            'options'  => array(
                'disabled'       => esc_html__( 'Disabled', 'studiare' ),
                'all_videos'     => esc_html__( 'Enabled for all videos', 'studiare' ),
                'course_videos'  => esc_html__( 'Enabled only for course videos', 'studiare' ),
            ),
            'default'  => 'disabled',
            'required' => array( 'enable_suncode_player', '=', true ),
        ),
         array(
            'id'       => 'watermark_content_type',
            'type'     => 'select',
            'title'    => esc_html__( 'Watermark Content Type', 'studiare' ),
            'subtitle' => esc_html__( 'Select what information to display in the watermark for logged-in users.', 'studiare' ),
            'options'  => array(
                'display_name'  => esc_html__( 'User Display Name (First & Last Name)', 'studiare' ),
                'mobile_number' => esc_html__( 'User Mobile Number', 'studiare' ),
            ),
            'default'  => 'display_name', // Default to display name
            'required' => array(
                array( 'suncode_player_watermark', '!=', 'disabled' ),
                array( 'enable_suncode_player', '=', true ),
            ),
        ),
         array(
            'id'       => 'watermark_count',
            'type'     => 'slider',
            'title'    => esc_html__('Number of Watermarks', 'studiare'),
            'desc'     => esc_html__('Set the number of dynamic watermarks to display simultaneously. Set to 0 for a single, static watermark.', 'studiare'),
            'min'      => 0,
            'step'     => 1,
            'max'      => 5,
            'default'  => 1,
            'display_value' => 'text',
            'required' => array('suncode_player_watermark', '!=', 'disabled'),
        ),
        array(
            'id'          => 'watermark_min_speed',
            'type'        => 'slider',
            'title'       => esc_html__( 'Watermark Minimum Speed', 'studiare' ),
            'subtitle'    => esc_html__( 'Minimum speed of the watermark movement (pixels per second).', 'studiare' ),
            'desc'        => esc_html__( 'Set the slowest speed the watermark can move.', 'studiare' ),
            'default'     => 30,
            'min'         => 10,
            'max'         => 100,
            'step'        => 1,
            'display_value' => 'text',
            'required'    => array( 'suncode_player_watermark', '!=', 'disabled' ),
        ),
        array(
            'id'          => 'watermark_max_speed',
            'type'        => 'slider',
            'title'       => esc_html__( 'Watermark Maximum Speed', 'studiare' ),
            'subtitle'    => esc_html__( 'Maximum speed of the watermark movement (pixels per second).', 'studiare' ),
            'desc'        => esc_html__( 'Set the fastest speed the watermark can move.', 'studiare' ),
            'default'     => 60,
            'min'         => 20,
            'max'         => 200,
            'step'        => 1,
            'display_value' => 'text',
            'required'    => array( 'suncode_player_watermark', '!=', 'disabled' ),
        ),

        array(
            'id'       => 'enable_video_cover',
            'type'     => 'switch',
            'title'    => esc_html__( 'Enable Default Video Cover', 'studiare' ),
            'subtitle' => esc_html__( 'Enable or disable a default cover image for videos without a poster.', 'studiare' ),
            'default'  => false,
            'required' => array( 'enable_suncode_player', '=', true ),
        ),

        array(
            'id'       => 'video_cover_image',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Default Video Cover Image', 'studiare' ),
            'subtitle' => esc_html__( 'Select a default cover image for videos. If not set, a default image will be used.', 'studiare' ),
            'default'  => array(
                'url' => get_template_directory_uri() . '/assets/images/video-cover.webp',
            ),
            'required' => array( 'enable_video_cover', '=', true ),
        ),
    ),
) );
?>