<?php
/**
 * Template for Single Product on Site
 * Optimized to prevent duplicate custom meta display
 */

defined('ABSPATH') || exit;

// Prefix for custom meta keys
$prefix = '_studiare_';

// Retrieve Redux settings efficiently
$course_post_share = class_exists('Redux') ? codebean_option('course_share_story') : false;
$product_meta_info_list = class_exists('Redux') ? codebean_option('product_meta_info_list') : false;
$product_buyers_insingle = class_exists('Redux') ? codebean_option('product_buyers_insingle') : false;

// Define meta keys with defaults
$meta_keys = [
    '_stock' => '',
    $prefix . 'course_duration' => '',
    $prefix . 'course_lesseons' => '',
    $prefix . 'course_level' => '',
    $prefix . 'sc_file_type' => '',
    $prefix . 'sc_file_size' => '',
    $prefix . 'sc_file_type_icon' => '',
    $prefix . 'course_certificate' => '',
    $prefix . 'course_language' => '',
    $prefix . 'course_sessions' => '',
    $prefix . 'sc_course_type_selector' => '',
    $prefix . 'course_buyers_text' => 'دانشجو',
    $prefix . 'course_buyers_text_hint' => 'تعداد دانشجویان',
    $prefix . 'course_buyers_text_icon' => 'fal fa-users',
    $prefix . 'course_duration_hint' => 'مدت زمان آموزش',
    $prefix . 'course_lesseons_hint' => 'تعداد سرفصل‌ها',
    $prefix . 'course_level_hint' => 'سطح آموزش',
    $prefix . 'sc_file_type_hint' => 'نوع فایل',
    $prefix . 'sc_file_size_hint' => 'حجم فایل',
    $prefix . 'course_certificate_hint' => 'نوع گواهی',
    $prefix . 'course_language_hint' => 'زبان آموزش',
    $prefix . 'course_sessions_hint' => 'تعداد جلسات',
    $prefix . 'sc_course_type_title_1' => '',
    $prefix . 'sc_course_type_title_2' => '',
    $prefix . 'metaboxjff_sections' => '',
];

// Fetch all meta values in one go
$meta_values = [];
$post_id = get_the_ID();
foreach ($meta_keys as $key => $default) {
    $meta_values[$key] = get_post_meta($post_id, $key, true) ?: $default;
}

// Helper function to display meta units
function display_meta_unit($icon, $label, $value) {
    if (!empty($value)) {
        if (strpos($icon, 'fal') === 0) {
            $icon_class = substr($icon, 0, 3) . ' ' . substr($icon, 3);
        } else {
            $icon_class = $icon;
        }
        ?>
        <div class="meta-info-unit">
            <div class="icon"><i class="<?php echo esc_attr($icon_class); ?>"></i></div>
            <div class="sc-meta-holder">
                <div class="sc-meta-item"><?php echo esc_html($label); ?></div>
                <div class="value"><?php echo esc_html($value); ?></div>
            </div>
        </div>
        <?php
    }
}
?>

<div class="product-info-box">
    <?php
    // WooCommerce single product summary hook
    do_action('woocommerce_single_product_summary');
    ?>

    <?php if ($product_meta_info_list): ?>
        <div class="product-meta-info-list">
            <?php
            // Display buyers count if enabled
            if ($product_buyers_insingle) {
                $count = get_post_meta($post_id, 'total_sales', true);
                $text = sprintf(_n("%s %s", "%s %s", $count, 'studiare'), number_format_i18n($count), $meta_values[$prefix . 'course_buyers_text']);
                $buyers_icon = $meta_values[$prefix . 'course_buyers_text_icon'];
                    if (!empty($buyers_icon) && in_array(substr($buyers_icon, 0, 3), ['fal', 'fas', 'far', 'fab']) && substr($buyers_icon, 3, 1) !== ' ') {
                        $buyers_icon = substr($buyers_icon, 0, 3) . ' ' . substr($buyers_icon, 3);
                }
                ?>
                <div class="meta-info-unit sc_sellscount">
                    <div class="icon"><i class="<?php echo esc_attr($buyers_icon); ?>"></i></div>
                    <div class="sc-meta-holder">
                        <div class="sc-meta-item"><?php echo esc_html($meta_values[$prefix . 'course_buyers_text_hint']); ?></div>
                        <div class="value"><?php echo esc_html($text); ?></div>
                    </div>
                </div>
            <?php } ?>

            <?php
            // Define meta info array for display
            $meta_info = [
                ['icon' => 'fal fa-language', 'label' => $meta_values[$prefix . 'course_language_hint'], 'value' => $meta_values[$prefix . 'course_language']],
                ['icon' => 'fal fa-clock', 'label' => $meta_values[$prefix . 'course_duration_hint'], 'value' => $meta_values[$prefix . 'course_duration']],
                ['icon' => 'fal fa-list', 'label' => $meta_values[$prefix . 'course_lesseons_hint'], 'value' => $meta_values[$prefix . 'course_lesseons']],
                ['icon' => 'fal fa-list', 'label' => $meta_values[$prefix . 'course_sessions_hint'], 'value' => $meta_values[$prefix . 'course_sessions']],
                ['icon' => 'fal fa-signal-4', 'label' => $meta_values[$prefix . 'course_level_hint'], 'value' => $meta_values[$prefix . 'course_level']],
                ['icon' => $meta_values[$prefix . 'sc_file_type_icon'], 'label' => $meta_values[$prefix . 'sc_file_type_hint'], 'value' => $meta_values[$prefix . 'sc_file_type']],
                ['icon' => 'fal fa-save', 'label' => $meta_values[$prefix . 'sc_file_size_hint'], 'value' => $meta_values[$prefix . 'sc_file_size']],
                ['icon' => 'fal fa-award', 'label' => $meta_values[$prefix . 'course_certificate_hint'], 'value' => $meta_values[$prefix . 'course_certificate']],
            ];

            // Display course type conditionally
            if ($meta_values[$prefix . 'sc_course_type_selector'] == 1) {
                display_meta_unit('fal fa-signal', esc_html__('Course Type', 'studiare'), $meta_values[$prefix . 'sc_course_type_title_1']);
            } elseif ($meta_values[$prefix . 'sc_course_type_selector'] == 2) {
                display_meta_unit('fal fa-signal-slash', esc_html__('Course Type', 'studiare'), $meta_values[$prefix . 'sc_course_type_title_2']);
            }

            // Loop through meta info
            foreach ($meta_info as $info) {
                display_meta_unit($info['icon'], $info['label'], $info['value']);
            }

            // Custom entries
            $custom_entries = $meta_values[$prefix . 'metaboxjff_sections'];
            if ($custom_entries) {
                foreach ((array)$custom_entries as $entry) {
                    $title = isset($entry[$prefix . 'sc_studi_custom_title_1']) ? esc_html($entry[$prefix . 'sc_studi_custom_title_1']) : '';
                    $content = isset($entry[$prefix . 'sc_studi_custom_text_1']) ? esc_html($entry[$prefix . 'sc_studi_custom_text_1']) : '';
                    $icon = isset($entry[$prefix . 'sc_studi_custom_icon_1']) ? esc_attr($entry[$prefix . 'sc_studi_custom_icon_1']) : 'fal fa-list';
                    display_meta_unit($icon, $content, $title);
                }
            }
            ?>
        </div>
    <?php endif; ?>
</div>

<?php
// Comments and views section
if (class_exists('Redux') && codebean_option('product_meta_info_comment_number')): ?>
    <div class="product-info-box">
        <div class="sccommentnumber">
            <a href="javascript:void(0);" onclick="jQuery('html, body').animate({scrollTop: jQuery('#reviews').offset().top}, 2000);">
                <span class="icon"><i class="fal fa-comments-alt"></i></span>
                <?php echo get_comments_number(); ?> <?php esc_html_e('Comment', 'studiare'); ?>
            </a>
            <span class="sc_studi_number_of_views"><i class="fal fa-eye"></i><?php echo sc_studi_gt_get_post_view(); ?></span>
        </div>
    </div>
<?php endif; ?>

<?php
// Share box
if ($course_post_share): ?>
    <div class="product-info-box sc_stud_share_box_holder">
        <div class="sc_stud_share_box">
            <?php echo do_shortcode('[sc_studiare_product_share_box]'); ?>
        </div>
    </div>
<?php endif; ?>

<?php
// Additional meta info
if (class_exists('Redux') && codebean_option('product_meta_info_list_2')): ?>
    <div class="product-info-box">
        <?php
        if (codebean_option('product_meta_info_list_date_published')): ?>
            <div class="course-rating before-gallery-unit">
                <div class="icon"><i class="fal fa-calendar-alt"></i></div>
                <span class="date_published"><?php esc_html_e('Published on', 'studiare'); ?>: <?php echo get_the_date(); ?></span>
            </div>
        <?php endif; ?>

        <?php
        if (codebean_option('product_meta_info_list_date_modified')):
            $date_update = get_post_meta($post_id, '_studiare_woo_course_date_update', true);
            if ($date_update): ?>
                <div class="course-rating before-gallery-unit">
                    <div class="icon"><i class="fal fa-calendar-edit"></i></div>
                    <span class="date_published"><?php esc_html_e('Updated on', 'studiare'); ?>: <?php echo date_i18n("j F Y", $date_update); ?></span>
                </div>
            <?php endif;
        endif; ?>

        <?php
        if (codebean_option('product_meta_info_list_stars')): ?>
            <div class="course-rating before-gallery-unit">
                <div class="icon"><i class="fal fa-star"></i></div>
                <div class="info"><?php esc_html_e('User Ratings', 'studiare'); ?>:</div>
                <?php woocommerce_template_loop_rating(); ?>
            </div>
        <?php endif; ?>

        <?php
        if (codebean_option('product_meta_info_list_cats')):
            $product_cats = get_the_terms($post_id, 'product_cat');
            if ($product_cats): ?>
                <div class="course-category before-gallery-unit">
                    <div class="icon"><i class="fal fa-folder-open"></i></div>
                    <div class="info">
                        <span class="label"><?php esc_html_e('Category', 'studiare'); ?></span>
                        <div class="value">
                            <?php foreach ($product_cats as $cat): ?>
                                <a href="<?php echo esc_url(get_term_link($cat)); ?>"><?php echo esc_html($cat->name); ?><span>/</span></a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif;
        endif; ?>

        <?php
        if (codebean_option('product_meta_info_list_tags')):
            $product_tags = get_the_terms($post_id, 'product_tag');
            if ($product_tags): ?>
                <div class="course-category before-gallery-unit">
                    <div class="icon"><i class="fal fa-tags"></i></div>
                    <div class="info">
                        <span class="label"><?php esc_html_e('Tags', 'studiare'); ?></span>
                        <div class="value">
                            <?php foreach ($product_tags as $tag): ?>
                                <a href="<?php echo esc_url(get_term_link($tag)); ?>"><?php echo esc_html($tag->name); ?><span>/</span></a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif;
        endif; ?>

        <?php
        if (codebean_option('product_meta_info_list_short_link')): ?>
            <div class="scshortlink">
                <div class="icon"><i class="fal fa-link"></i></div>
                <div class="info"><?php esc_html_e('Short Link:', 'studiare'); ?></div>
            </div>
            <div class="scshort-link">
                <?php echo esc_url(wp_get_shortlink()); ?>
                <span class="sc_autocopy hint--top" aria-label="<?php esc_attr_e('Copy Link', 'studiare'); ?>"
                      onclick="sc_auto_copy_text('<?php echo esc_js(wp_get_shortlink()); ?>', '<?php esc_js(_e('Copy Link', 'studiare')); ?>', '<?php esc_js(_e('Copied', 'studiare')); ?>')">
                    <i class="fal fa-clone"></i>
                </span>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>

<?php
// Sidebar
if (is_active_sidebar('singleshop')): ?>
    <div class="product-info-box singleshop">
        <div class="sidebar-widgets-wrapper">
            <?php dynamic_sidebar('singleshop'); ?>
        </div>
    </div>
<?php endif; ?>