<?php
/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

if ( ! comments_open() ) {
	return;
}

if (class_exists('Redux')) {
    $use_emojis = codebean_option('product_single_rating_mode');
} else {
    $use_emojis = false;
}

//https://codepen.io/suez/details/MezwON
?>
<div id="reviews" class="woocommerce-Reviews">
    <div id="comments">
        <h2 class="woocommerce-Reviews-title">
            <?php
            $count = $product->get_review_count();
			if ( $count && wc_review_ratings_enabled() ) {
                $reviews_title = sprintf( esc_html( _n( '%1$s review for %2$s', '%1$s reviews for %2$s', $count, 'woocommerce' ) ), esc_html( $count ), '<span>' . get_the_title() . '</span>' );

				echo apply_filters( 'woocommerce_reviews_title', $reviews_title, $count, $product ); // WPCS: XSS ok.
            } else {
				esc_html_e( 'Reviews', 'woocommerce' );
            }
            ?>
        </h2>

		<?php if ( have_comments() ) : ?>
			<ol class="commentlist">
				<?php wp_list_comments( apply_filters( 'woocommerce_product_review_list_args', array( 'callback' => 'woocommerce_comments' ) ) ); ?>
            </ol>
            <?php
			if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
                echo '<nav class="woocommerce-pagination">';
                paginate_comments_links(
                    apply_filters(
                        'woocommerce_comment_pagination_args',
                        array(
                            'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
                            'next_text' => is_rtl() ? '&larr;' : '&rarr;',
                            'type'      => 'list',
                        )
                    )
                );
                echo '</nav>';
            endif;
            ?>
        <?php else : ?>
			<p class="woocommerce-noreviews"><?php esc_html_e( 'There are no reviews yet.', 'woocommerce' ); ?></p>
        <?php endif; ?>
    </div>

	<?php if ( get_option( 'woocommerce_review_rating_verification_required' ) === 'no' || wc_customer_bought_product( '', get_current_user_id(), $product->get_id() ) ) : ?>
        <div id="review_form_wrapper">
            <div id="review_form">
                <?php
				$commenter    = wp_get_current_commenter();
                $comment_form = array(
					'title_reply'         => have_comments() ? esc_html__( 'Add a review', 'woocommerce' ) : sprintf( esc_html__( 'Be the first to review &ldquo;%s&rdquo;', 'woocommerce' ), get_the_title() ),
					'title_reply_to'      => esc_html__( 'Leave a Reply to %s', 'woocommerce' ),
					'title_reply_before'  => '<span id="reply-title" class="comment-reply-title" role="heading" aria-level="3">',
                    'title_reply_after'   => '</span>',
                    'comment_notes_after' => '',
					'label_submit'        => esc_html__( 'Submit', 'woocommerce' ),
                    'logged_in_as'        => '',
                    'comment_field'       => '',
                );

                if ($use_emojis && wc_review_ratings_enabled()) {
                    $comment_form['comment_field'] = '
                    <svg class="fb-emotes-svg" style="display: none;">
                    <symbol id="fb-emote-terrible" data-emote="terrible" viewBox="0 0 100 100">
                    <path class="fb-emote__eye fb-emote__eye--left" d="M32,25 l10,10 a10,10 0 0,1 -20,0 a10,10 0 0,1 10,-10"/>
                    <path class="fb-emote__eye fb-emote__eye--right" d="M58,35 l10,-10 a10,10 0 0,1 0,20 a10,10 0 0,1 -10,-10"/>
                    <path class="fb-emote__smile" d="M30,68 q20,-13 40,0 M30,68 q20,-13 40,0"/>
                    </symbol>
                    <symbol id="fb-emote-bad" data-emote="bad" viewBox="0 0 100 100">
                    <path class="fb-emote__eye fb-emote__eye--left" d="M22,35 l10,-10 a10,10 0 0,1 0,20 a10,10 0 0,1 -10,-10"/>
                    <path class="fb-emote__eye fb-emote__eye--right" d="M68,25 l10,10 a10,10 0 0,1 -20,0 a10,10 0 0,1 10,-10"/>
                    <path class="fb-emote__smile" d="M30,68 q20,-10 40,0 M30,68 q20,-10 40,0"/>
                    </symbol>
                    <symbol id="fb-emote-okay" viewBox="0 0 100 100">
                    <path class="fb-emote__eye fb-emote__eye--left" d="M32,25 a10,10 0 0,1 0,20 a10,10 0 0,1 0,-20"/>
                    <path class="fb-emote__eye fb-emote__eye--right" d="M68,25 a10,10 0 0,1 0,20 a10,10 0 0,1 0,-20"/>
                    <path class="fb-emote__smile" d="M35,73 q20,-4 35,-8 M35,73 q20,-4 35,-8"/>
                    </symbol>
                    <symbol id="fb-emote-good" viewBox="0 0 100 100">
                    <path class="fb-emote__eye fb-emote__eye--left" d="M32,25 a10,10 0 0,1 0,20 a10,10 0 0,1 0,-20"/>
                    <path class="fb-emote__eye fb-emote__eye--right" d="M68,25 a10,10 0 0,1 0,20 a10,10 0 0,1 0,-20"/>
                    <path class="fb-emote__smile" d="M30,68 q20,10 40,0 M30,68 q20,10 40,0"/>
                    </symbol>
                    <symbol id="fb-emote-great" viewBox="0 0 100 100">
                    <path class="fb-emote__eye fb-emote__eye--left" d="M32,25 a10,10 0 0,1 0,20 a10,10 0 0,1 0,-20"/>
                    <path class="fb-emote__eye fb-emote__eye--right" d="M68,25 a10,10 0 0,1 0,20 a10,10 0 0,1 0,-20"/>
                    <path class="fb-emote__smile" d="M30,68 q20,15 40,0 M30,68 q20,0 40,0"/>
                    </symbol>
                    </svg>
                    <div class="comment-form-rating ">
                     <label>' . esc_html__('Your rating', 'woocommerce') . '</label>
                     <div class="fb-cont">
                        <div class="fb-cont__inner">
                            <div class="fb-emote" data-rating="1" data-emote="terrible">
                                <svg><use xlink:href="#fb-emote-terrible"></use></svg>
                                <p class="fb-emote__caption">' . esc_html__('Very poor', 'woocommerce') . '</p>
                            </div>
                            <div class="fb-emote" data-rating="2" data-emote="bad">
                                <svg><use xlink:href="#fb-emote-bad"></use></svg>
                                <p class="fb-emote__caption">' . esc_html__('Not that bad', 'woocommerce') . '</p>
                            </div>
                            <div class="fb-emote" data-rating="3" data-emote="okay">
                                <svg><use xlink:href="#fb-emote-okay"></use></svg>
                                <p class="fb-emote__caption">' . esc_html__('Average', 'woocommerce') . '</p>
                            </div>
                            <div class="fb-emote" data-rating="4" data-emote="good">
                                <svg><use xlink:href="#fb-emote-good"></use></svg>
                                <p class="fb-emote__caption">' . esc_html__('Good', 'woocommerce') . '</p>
                            </div>
                            <div class="fb-emote" data-rating="5" data-emote="great">
                                <svg><use xlink:href="#fb-emote-great"></use></svg>
                                <p class="fb-emote__caption">' . esc_html__('Perfect', 'woocommerce') . '</p>
                            </div>
                            
                             <input type="hidden" name="rating" id="rating" value="" />
                        </div>
                        </div>
                    </div>';
                } else {
                    $comment_form['comment_field'] = '<div class="comment-form-rating"><label for="rating" id="comment-form-rating-label">' . esc_html__( 'Your rating', 'woocommerce' ) . ( wc_review_ratings_required() ? '&nbsp;<span class="required">*</span>' : '' ) . '</label><select name="rating" id="rating" required>

                    <option value="">' . esc_html__( 'Rate&hellip;', 'woocommerce' ) . '</option>
						<option value="5">' . esc_html__( 'Perfect', 'woocommerce' ) . '</option>
						<option value="4">' . esc_html__( 'Good', 'woocommerce' ) . '</option>
						<option value="3">' . esc_html__( 'Average', 'woocommerce' ) . '</option>
						<option value="2">' . esc_html__( 'Not that bad', 'woocommerce' ) . '</option>
						<option value="1">' . esc_html__( 'Very poor', 'woocommerce' ) . '</option>
					</select></div>';
				}
				$comment_form['comment_field'] .= '<p class="comment-form-comment"><label for="comment">' . esc_html__( 'Your review', 'woocommerce' ) . '&nbsp;<span class="required">*</span></label><textarea id="comment" name="comment" cols="45" rows="8" required></textarea></p>';

				comment_form( apply_filters( 'woocommerce_product_review_comment_form_args', $comment_form ) );
                ?>
            </div>
        </div>
    <?php else : ?>
		<p class="woocommerce-verification-required"><?php esc_html_e( 'Only logged in customers who have purchased this product may leave a review.', 'woocommerce' ); ?></p>
    <?php endif; ?>
    <div class="clear"></div>
</div>
<?php  if ($use_emojis && wc_review_ratings_enabled()) { ?>
<style>
    .fb-cont { overflow: visible; position: relative; margin: 0px auto; max-width: 500px; margin-bottom: 40px; } .fb-cont__inner { position: relative; display: flex; justify-content: space-between; } .fb-cont__inner:before { content: ""; position: absolute; left: 50%; top: 50%; width: 90%; height: 4px; margin-top: -2px; background: rgba(200, 206, 211, 0.5); border-radius: 2px; transform: translateX(-50%); } .fb-cont__drag-cont { z-index: 2; position: absolute; left: 50%; top: 0; width: 574px; height: 100%; margin-left: -287px; pointer-events: none; transform: translate3d(50%, 0, 0); } .fb-heading { margin: 0 auto 60px; font-size: 30px; text-align: center; color: #737b7b; } .fb-emote { z-index: 1; position: relative; display: flex; flex-wrap: wrap; justify-content: center; width: 46px; height: 46px; cursor: pointer; } .fb-emote svg { display: block; margin-bottom: 15px; width: 100%; height: 100%; background: #c8ced3; border-radius: 50%; transition: transform 0.5s; } 
    .fb-emote.s--active svg { transform: scale(1.1); } .fb-emote__caption { text-align: center; font-size: 26px; font-weight: 700; color: #c8ced3; transition: all 0.5s; } .fb-emote.s--active .fb-emote__caption { color: #655e53; transform: translateY(15px); } .fb-emote__eye { stroke: none; fill: #fff; } 
    .fb-emote__smile { stroke: #fff; stroke-width: 10; stroke-linecap: round; fill: none; } .fb-active-emote { position: absolute; left: 0; top: 50%; width: 110px; height: 110px; margin-left: -55px; margin-top: -55px; background: #ffd68c; border-radius: 50%; } .fb-active-emote svg { width: 100%; height: 100%; } .fb-active-emote__eye { stroke: none; fill: #655e53; } .fb-active-emote__smile { stroke: #655e53; stroke-width: 10; stroke-linecap: round; fill: none; } .icon-link { position: absolute; left: 5px; bottom: 5px; width: 32px; } .icon-link img { width: 100%; vertical-align: top; } .icon-link--twitter { left: auto; right: 5px; }
    p.fb-emote__caption { font-size: 12px; padding: 0; margin: 0; display: contents;text-wrap-mode: nowrap; }
    .rtl .fb-cont__inner { flex-direction: row-reverse; }
    .fb-cont__inner:before { display:none}
    
    .fb-emote.s--active[data-emote="terrible"] > svg { 
        background: linear-gradient(135deg, #f42525, #da0b73); 
    }
    
    .fb-emote.s--active[data-emote="bad"] > svg { 
        background: linear-gradient(135deg, #f49a25, #da190b); 
    }
    
    .fb-emote.s--active[data-emote="okay"] > svg { 
        background: linear-gradient(135deg, #f4f425, #da730b); 
    }
    
    .fb-emote.s--active[data-emote="good"] > svg { 
        background: linear-gradient(135deg, #90f425, #dad70b); 
    }
    
    .fb-emote.s--active[data-emote="great"] > svg { 
        background: linear-gradient(135deg, #25f425, #73da0b); 
    }


</style>
<script>
    jQuery(document).ready(function($){
        
        var current_r_v = $('.fb-emote');
        current_r_v.click(function(){
            $('.fb-emote').removeClass("s--active");
            var rv_val = jQuery(this).data("rating");
            jQuery(this).addClass("s--active");
            jQuery("#rating").val(rv_val);
            //alert(rv_val);
        });
        
    });
</script>
<?php } ?>